/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.client.FaBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaChangeBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClearBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaCurCardEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaDepreciationUI;
import com.kingdee.eas.fi.fa.manage.client.FaEvaluateBillEditUI;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.IFaList;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFaSubLedgerUI;
import com.kingdee.eas.fi.fa.rpt.client.CommQueryDlogForFaSbLeger;
import com.kingdee.eas.fi.fa.rpt.client.FaRptBaseUI;
import com.kingdee.eas.fi.fa.rpt.client.FaRptPrintHelper;
import com.kingdee.eas.fi.fa.rpt.client.FaRptQueryPanel;
import com.kingdee.eas.fi.fa.rpt.client.FaSubLedgerCond;
import com.kingdee.eas.fi.fa.rpt.client.FaSubLedgerPrintSelectUI;
import com.kingdee.eas.fi.fa.rpt.client.IDNode;
import com.kingdee.eas.fi.fa.rpt.client.TreeIdsList;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaSubLedgerUI
extends AbstractFaSubLedgerUI {
    private static final long serialVersionUID = -5669936518683630961L;
    private static final String VOUCHERTYPE = new VoucherInfo().getBOSType().toString();
    private static final Logger logger = CoreUIObject.getLogger(FaSubLedgerUI.class);
    private GetIdThreadForSpec getAllIdThread = null;
    String rptPeriod;
    String title;
    private boolean isGroupByAssetType;
    private boolean isGroupByAdminDepartment;
    private boolean isGroupByCard;
    private List cardNameList;
    private List cardNumList;
    private List assetTypeList;
    private List adminDepartmentList;
    private List catNumList;
    private List adminNumList;
    private List currentList;
    private int index = 0;
    private FilterItemInfo catOrAdminFilter = null;
    private String lastAdminCatItem = null;
    private boolean isFistAdminCat = false;
    private boolean isReQuery = false;
    private boolean isUnAudit = false;

    public FaSubLedgerUI() throws Exception {
        EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startPerionBalance");
        EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yearTotal");
        this.btnFilter.setEnabled(true);
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        this.menuItemViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        this.actionExport.setEnabled(true);
    }

    @Override
    protected void displayPeriodInfo() {
        String year = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"periodYear");
        String month = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"periodNumber");
        String strNo = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"ordinal");
        Map customCond = this.getCustomCond();
        String period = customCond.get("startNumber").equals(customCond.get("endNumber")) && customCond.get("startYear").equals(customCond.get("endYear")) ? MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), customCond.get("startYear").toString(), customCond.get("startNumber").toString()) : MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayTerm"), customCond.get("startYear").toString(), customCond.get("startNumber").toString(), customCond.get("endYear").toString(), customCond.get("endNumber").toString());
        this.rptPeriod = period;
        this.lblPeriodValue.setText(period);
    }

    @Override
    protected void initTableColumn(List sumColumnNames) {
        super.initTableColumn(sumColumnNames);
        if (((Boolean)this.getCustomCond().get("isByEvalue")).booleanValue()) {
            this.tblMain.getHeadRow(0).getCell("valueDebit").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetVAndEvalV"));
            this.tblMain.getHeadRow(0).getCell("valueCredit").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetVAndEvalV"));
            this.tblMain.getHeadRow(0).getCell("valueBal").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetVAndEvalV"));
        }
        this.title = (String)this.tblMain.getHeadRow(0).getCell("valueDebit").getValue();
    }

    @Override
    protected void afterFillTableRow(IRow row, int rowIndex) {
        Object value;
        if (row.getCell("BILLID").getValue() == null) {
            row.getStyleAttributes().setBackground(this.tblMain.getRequiredColor());
            row.getCell("assetnumber").setValue(null);
            row.getCell("assetname").setValue(null);
        }
        if ((value = row.getCell("Fcurrencypre").getValue()) != null) {
            int perc = new BigDecimal(row.getCell("Fcurrencypre").getValue().toString()).intValue();
            row.getCell("FexRate").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)perc));
        }
        if (this.isVirCompany) {
            if (row.getCell("BILLID").getValue() == null) {
                BigDecimal valueBal = (BigDecimal)row.getCell("valueBal").getValue();
                BigDecimal deprBal = (BigDecimal)row.getCell("deprBal").getValue();
                BigDecimal devalueBal = (BigDecimal)row.getCell("devalueBal").getValue();
                if (valueBal == null) {
                    valueBal = ZERO;
                }
                if (deprBal == null) {
                    deprBal = ZERO;
                }
                if (devalueBal == null) {
                    devalueBal = ZERO;
                }
                row.getCell("netValue").setValue((Object)valueBal.subtract(deprBal));
                row.getCell("netAmount").setValue((Object)valueBal.subtract(deprBal).subtract(devalueBal));
            }
            if (row.getCell("BILLID").getValue() == null && rowIndex > 0 && this.tblMain.getCell(rowIndex - 1, "BILLID").getValue() != null) {
                int index = rowIndex;
                BigDecimal lastValueBal = ZERO;
                BigDecimal lastDeprBal = ZERO;
                BigDecimal lastDevalueBal = ZERO;
                --index;
                while (index >= 0) {
                    if (this.tblMain.getCell(index, "BILLID") != null && this.tblMain.getCell(index, "BILLID").getValue() == null) {
                        lastValueBal = (BigDecimal)this.tblMain.getCell(index, "valueBal").getValue();
                        lastDeprBal = (BigDecimal)this.tblMain.getCell(index, "deprBal").getValue();
                        lastDevalueBal = (BigDecimal)this.tblMain.getCell(index, "devalueBal").getValue();
                        break;
                    }
                    --index;
                }
                index = rowIndex;
                --index;
                while (index >= 0 && this.tblMain.getCell(index, "BILLID") != null && this.tblMain.getCell(index, "BILLID").getValue() != null) {
                    this.tblMain.getCell(index, "valueBal").setValue((Object)lastValueBal);
                    BigDecimal valueDebit = this.tblMain.getCell(index, "valueDebit").getValue() == null ? ZERO : (BigDecimal)this.tblMain.getCell(index, "valueDebit").getValue();
                    BigDecimal valueCredit = this.tblMain.getCell(index, "valueCredit").getValue() == null ? ZERO : (BigDecimal)this.tblMain.getCell(index, "valueCredit").getValue();
                    lastValueBal = lastValueBal.add(valueCredit).subtract(valueDebit);
                    this.tblMain.getCell(index, "deprBal").setValue((Object)lastDeprBal);
                    BigDecimal deprDebit = this.tblMain.getCell(index, "deprDebit").getValue() == null ? ZERO : (BigDecimal)this.tblMain.getCell(index, "deprDebit").getValue();
                    BigDecimal deprCredit = this.tblMain.getCell(index, "deprCredit").getValue() == null ? ZERO : (BigDecimal)this.tblMain.getCell(index, "deprCredit").getValue();
                    lastDeprBal = lastDeprBal.add(deprCredit).subtract(deprDebit);
                    this.tblMain.getCell(index, "devalueBal").setValue((Object)lastDevalueBal);
                    BigDecimal devalueDebit = this.tblMain.getCell(index, "devalueDebit").getValue() == null ? ZERO : (BigDecimal)this.tblMain.getCell(index, "devalueDebit").getValue();
                    BigDecimal devalueCredit = this.tblMain.getCell(index, "devalueCredit").getValue() == null ? ZERO : (BigDecimal)this.tblMain.getCell(index, "devalueCredit").getValue();
                    lastDevalueBal = lastDevalueBal.add(devalueCredit).subtract(devalueDebit);
                    BigDecimal valueBal = (BigDecimal)this.tblMain.getCell(index, "valueBal").getValue();
                    BigDecimal deprBal = (BigDecimal)this.tblMain.getCell(index, "deprBal").getValue();
                    BigDecimal devalueBal = (BigDecimal)this.tblMain.getCell(index, "devalueBal").getValue();
                    this.tblMain.getCell(index, "netValue").setValue((Object)valueBal.subtract(deprBal));
                    this.tblMain.getCell(index, "netAmount").setValue((Object)valueBal.subtract(deprBal).subtract(devalueBal));
                    --index;
                }
            }
        } else {
            if (rowIndex > 0 && row.getCell("BILLID").getValue() != null) {
                BigDecimal lastValueBal = (BigDecimal)this.tblMain.getCell(rowIndex - 1, "valueBal").getValue();
                BigDecimal valueDebit = row.getCell("valueDebit").getValue() == null ? ZERO : (BigDecimal)row.getCell("valueDebit").getValue();
                BigDecimal valueCredit = row.getCell("valueCredit").getValue() == null ? ZERO : (BigDecimal)row.getCell("valueCredit").getValue();
                row.getCell("valueBal").setValue((Object)lastValueBal.add(valueDebit).subtract(valueCredit));
                BigDecimal lastDeprBal = (BigDecimal)this.tblMain.getCell(rowIndex - 1, "deprBal").getValue();
                BigDecimal deprDebit = (BigDecimal)row.getCell("deprDebit").getValue();
                BigDecimal deprCredit = (BigDecimal)row.getCell("deprCredit").getValue();
                row.getCell("deprBal").setValue((Object)lastDeprBal.add(deprCredit).subtract(deprDebit));
                BigDecimal lastDevalueBal = (BigDecimal)this.tblMain.getCell(rowIndex - 1, "devalueBal").getValue();
                BigDecimal devalueDebit = (BigDecimal)row.getCell("devalueDebit").getValue();
                BigDecimal devalueCredit = (BigDecimal)row.getCell("devalueCredit").getValue();
                row.getCell("devalueBal").setValue((Object)lastDevalueBal.add(devalueCredit).subtract(devalueDebit));
            }
            BigDecimal valueBal = (BigDecimal)row.getCell("valueBal").getValue();
            BigDecimal deprBal = (BigDecimal)row.getCell("deprBal").getValue();
            BigDecimal devalueBal = (BigDecimal)row.getCell("devalueBal").getValue();
            row.getCell("netValue").setValue((Object)valueBal.subtract(deprBal));
            row.getCell("netAmount").setValue((Object)valueBal.subtract(deprBal).subtract(devalueBal));
        }
    }

    @Override
    protected void formatData() throws EASBizException, BOSException {
        FaClientUtils.fmtDate((KDTable)this.tblMain, (String)"bizDate");
        FaClientUtils.fmtAssetAmt((KDTable)this.tblMain, (String)"assetAmt");
        String[] fmtColumnNames = new String[]{"FexRate", "FOriginAmt", "FAddons", "FassetValue", "valueDebit", "valueCredit", "valueBal", "deprDebit", "deprCredit", "deprBal", "netValue", "devalueDebit", "devalueCredit", "devalueBal", "netAmount"};
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])fmtColumnNames, (String)FaClientUtils.getDecimalFormat((int)this.getCurrencyScale()));
        String[] fmtAssetAmtNames = new String[]{"assetAmt"};
        int quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])fmtAssetAmtNames, (String)FaClientUtils.getDecimalFormat((int)quantityScale));
    }

    @Override
    protected void initCommonQueryDialog() throws Exception {
        this.commonQueryDialog = new CommQueryDlogForFaSbLeger();
        super.initCommonQueryDialog();
        this.commonQueryDialog.setWidth(520);
        this.commonQueryDialog.setHeight(400);
    }

    @Override
    protected FaRptQueryPanel getConditionUI() throws Exception {
        return new FaSubLedgerCond();
    }

    @Override
    protected String getQueryName() {
        return "FaSubLedgerQuery";
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.faSubLedgerRpt");
    }

    @Override
    protected String getDaoClassName() {
        return "FaSubLedgerNewDao";
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.showIsUnAudit();
        this.setHeadContent();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.actionViewCard.setEnabled(false);
        this.actionViewVoucher.setEnabled(false);
        this.addListener();
        if (this.isVirCompany) {
            this.menuItemSetPrintParam.setEnabled(false);
        }
    }

    private void setHeadContent() {
        ArrayList cells = this.tblMain.getHead().getRow(1).getCells();
        for (int i = 0; i < cells.size(); ++i) {
            KDTCell cell = (KDTCell)cells.get(i);
            if (i == 16 || i == 19 || i == 23) {
                cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"162_FaSubLedgerUI"));
            }
            if (i == 17 || i == 20 || i == 24) {
                cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"163_FaSubLedgerUI"));
            }
            if (i != 18 && i != 21 && i != 25) continue;
            cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"164_FaSubLedgerUI"));
        }
    }

    private void addListener() {
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent arg0) {
                FaSubLedgerUI.this.subLedgertableMouseEvent(arg0);
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                boolean isSelelcted = FaSubLedgerUI.this.tblMain.getSelectManager().get() != null;
                int selectRow = FaSubLedgerUI.this.tblMain.getSelectManager().get().getBeginRow();
                if (FaSubLedgerUI.this.tblMain.getRow(selectRow) == null) {
                    return;
                }
                isSelelcted = isSelelcted && selectRow != -1;
                ICell billIdCell = FaSubLedgerUI.this.tblMain.getRow(selectRow).getCell("BILLID");
                ICell billTypeCell = FaSubLedgerUI.this.tblMain.getRow(selectRow).getCell("BILLTYPE");
                isSelelcted = isSelelcted && billIdCell != null && billIdCell.getValue() != null && billTypeCell != null && billTypeCell.getValue() != null;
                boolean isEffective = false;
                if (isSelelcted) {
                    String billType = billTypeCell.getValue().toString();
                    isEffective = "1".equals(billType) || "2".equals(billType) || "3".equals(billType) || "5".equals(billType) || "6".equals(billType) || "7".equals(billType);
                }
                FaSubLedgerUI.this.actionViewCard.setEnabled(isSelelcted && isEffective);
                ICell voucherNumCell = FaSubLedgerUI.this.tblMain.getRow(selectRow).getCell("voucherNumber");
                boolean hasVoucherNumber = false;
                if (voucherNumCell != null && voucherNumCell.getValue() != null && ((String)voucherNumCell.getValue()).trim().length() > 0) {
                    hasVoucherNumber = true;
                }
                FaSubLedgerUI.this.actionViewVoucher.setEnabled(isSelelcted && hasVoucherNumber);
            }
        });
    }

    private void subLedgertableMouseEvent(KDTMouseEvent e) {
        if (e.getClickCount() == 2) {
            if (this.tblMain.getRow(e.getRowIndex()) == null) {
                return;
            }
            ICell billIdCell = this.tblMain.getRow(e.getRowIndex()).getCell("BILLID");
            ICell billTypeCell = this.tblMain.getRow(e.getRowIndex()).getCell("BILLTYPE");
            String companyId = (String)this.tblMain.getRow(e.getRowIndex()).getCell("COMPANY_ID").getValue();
            if (this.checkProperColumn(billIdCell, billTypeCell)) {
                return;
            }
            String billId = billIdCell.getValue().toString();
            String billType = billTypeCell.getValue().toString();
            if (billId != null && !billId.trim().equals("") && billType != null && !billType.trim().equals("")) {
                try {
                    this.viewCardUI(billId, billType, companyId);
                }
                catch (Exception e1) {
                    this.handleException(e1);
                }
            }
        }
    }

    @Override
    public void actionViewCard_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().get() == null) {
            return;
        }
        int selectRow = this.tblMain.getSelectManager().get().getBeginRow();
        if (selectRow == -1) {
            return;
        }
        ICell billIdCell = this.tblMain.getRow(selectRow).getCell("BILLID");
        ICell billTypeCell = this.tblMain.getRow(selectRow).getCell("BILLTYPE");
        String companyId = (String)this.tblMain.getRow(selectRow).getCell("COMPANY_ID").getValue();
        if (billIdCell == null || billIdCell.getValue() == null || billTypeCell == null || billTypeCell.getValue() == null) {
            return;
        }
        String billId = billIdCell.getValue().toString();
        String billType = billTypeCell.getValue().toString();
        if (billId != null && !billId.trim().equals("") && billType != null && !billType.trim().equals("")) {
            try {
                this.viewCardUI(billId, billType, companyId);
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    protected void viewCardUI(String billId, String billType, String companyId) throws EASBizException, BOSException {
        if (billId == null) {
            return;
        }
        if (companyId == null) {
            companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        }
        this.setCursorOfWair();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"ID", (Object)billId);
        uiContext.put((Object)"Link", (Object)Boolean.TRUE);
        uiContext.put((Object)"COMPANY_ID", (Object)companyId);
        String uiClassName = null;
        if ("1".equals(billType)) {
            uiContext.put((Object)"isInit", (Object)false);
            uiContext.put((Object)"Change_Mode", (Object)true);
            uiClassName = FaChangeBillEditUI.class.getName();
        } else if ("2".equals(billType)) {
            uiClassName = FaClearBillEditUI.class.getName();
        } else if ("3".equals(billType)) {
            uiClassName = FaCurCardEditUI.class.getName();
            uiContext.put((Object)"isFromSubLedgerUI", (Object)"true");
        } else if ("5".equals(billType)) {
            uiContext.put((Object)"billId", (Object)billId);
            uiClassName = FaDepreciationUI.class.getName();
            uiContext.put((Object)"isFromSubLedgerUI", (Object)"true");
        } else if ("6".equals(billType)) {
            uiClassName = FaCurCardEditUI.class.getName();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            SelectorItemCollection cardSelectors = FaBillEditUI.getCurCardSelectors((int)2);
            cardSelectors.add(new SelectorItemInfo("period.periodYear"));
            cardSelectors.add(new SelectorItemInfo("period.periodNumber"));
            FaBakCardInfo bakCardInfo = FaBakCardFactory.getRemoteInstance().getFaBakCardInfo((IObjectPK)pk, cardSelectors);
            FaCurCardInfo curCardInfo = FaManageUtils.BakCard2CurCard((FaBakCardInfo)bakCardInfo);
            uiContext.put((Object)"InitDataObject", (Object)curCardInfo);
            if (bakCardInfo.getPeriod() != null) {
                uiContext.put((Object)"PeriodYear", (Object)new Integer(bakCardInfo.getPeriod().getPeriodYear()));
                uiContext.put((Object)"PeriodNumber", (Object)new Integer(bakCardInfo.getPeriod().getPeriodNumber()));
            }
            uiContext.put((Object)"isFromSubLedgerUI", (Object)"true");
        } else if ("7".equals(billType)) {
            uiClassName = FaEvaluateBillEditUI.class.getName();
        } else {
            return;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.setCursorOfDefault();
    }

    @Override
    protected int getTableHeadRowCounts() {
        return 2;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isVirCompany && this.isUseTempPrint) {
            if (this.isGroupByCard) {
                if (this.cardNumList != null) {
                    List newCardNumList;
                    this.ev.getFilter().setMaskString(null);
                    this.currentList = newCardNumList = this.showPrintSelectWindow();
                    if (this.currentList.size() != 0) {
                        DynamicRowSet dRowSet = this.getPrintData();
                        this.invokePrintNew(false, (IRowSet)dRowSet);
                    } else {
                        this.currentList = this.cardNumList;
                    }
                }
            } else {
                IRowSet rowSet = this.printRptList();
                this.invokePrint(false, rowSet);
            }
        } else {
            super.actionPrint_actionPerformed(e);
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isVirCompany && this.isUseTempPrint) {
            boolean bl = this.isGroupByCard = this.getCustomCond().get("isGroupByCard") == null ? false : (Boolean)this.getCustomCond().get("isGroupByCard");
            if (this.isGroupByCard) {
                if (this.cardNumList != null) {
                    List newCardNumList;
                    this.ev.getFilter().setMaskString(null);
                    this.currentList = newCardNumList = this.showPrintSelectWindow();
                    if (this.currentList.size() != 0) {
                        DynamicRowSet dRowSet = this.getPrintData();
                        this.invokePrintNew(true, (IRowSet)dRowSet);
                    } else {
                        this.currentList = this.cardNumList;
                    }
                }
            } else {
                IRowSet rowSet = this.printRptList();
                this.invokePrint(true, rowSet);
            }
        } else {
            super.actionPrintPreview_actionPerformed(e);
        }
    }

    protected List showPrintSelectWindow() throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"cardNumList", (Object)this.cardNumList);
        uiContext.put((Object)"cardNameList", (Object)this.cardNameList);
        IUIWindow uiWindow = UIFactory.createUIFactory().create(FaSubLedgerPrintSelectUI.class.getName(), (Map)uiContext, null, "View");
        ((FaSubLedgerPrintSelectUI)uiWindow.getUIObject()).setBounds(new Rectangle(10, 10, 250, 400));
        uiWindow.show();
        Object numObj = ((FaSubLedgerPrintSelectUI)uiWindow.getUIObject()).getUIContext().get("newCardNumList");
        Object nameObj = ((FaSubLedgerPrintSelectUI)uiWindow.getUIObject()).getUIContext().get("newCardNameList");
        List newCardNumList = new ArrayList();
        List newCardNameList = new ArrayList();
        if (numObj != null && nameObj != null) {
            newCardNumList = (List)numObj;
            newCardNameList = (List)nameObj;
        }
        return newCardNumList;
    }

    protected DynamicRowSet getPrintData() throws Exception {
        int j;
        DynamicRowSet dRowSet = null;
        int rowIndex = 0;
        String[] colNames = new String[]{"bizDate", "brief", "assetnumber", "assetname", "unit", "assetAmt", "currency", "FexRate", "FOriginAmt", "FAddons", "FassetValue", "valueDebit", "valueCredit", "valueBal", "deprDebit", "deprCredit", "deprBal", "netValue", "devalueDebit", "devalueCredit", "devalueBal", "netAmount", "ASSETTYPE", "CATNUM", "ADMINDEPARTMENT", "ADMINNUM", "BILLID", "FACURCARDID", "VOUCHERNUMBER", "BIZNUMBER", "FASSETVALUE", "BILLTYPE", "OLDERNUMBER", "FCURRENCYPRE", "COMPANY_ID", "abstract"};
        String[] title = new String[]{"companyName", "period", "header", "cardNumber", "cardName"};
        String[] amountCols = new String[]{"FOriginAmt", "FAddons", "FassetValue", "valueDebit", "valueCredit", "valueBal", "deprDebit", "deprCredit", "deprBal", "netValue", "devalueDebit", "devalueCredit", "devalueBal", "netAmount"};
        String[] normalCols = new String[]{"bizDate", "brief", "assetnumber", "assetname", "unit", "currency", "abstract"};
        int basePrecision = 2;
        String rptPeriod = "";
        String companyName = "";
        String header = "";
        String cardNumber = "";
        String cardName = "";
        basePrecision = FaClientUtils.getCurrencyScale();
        HashMap faParameter = FaClientUtils.getFAParameter((BOSUuid)SysContext.getSysContext().getCurrentFIUnit().getId());
        int quantityScale = Integer.valueOf(faParameter.get("FA_008") == null ? "0" : (String)faParameter.get("FA_008"));
        dRowSet = new DynamicRowSet(colNames.length + title.length);
        for (j = 1; j <= colNames.length; ++j) {
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = colNames[j - 1];
            ci.nullable = 1;
            dRowSet.setColInfo(j, ci);
        }
        j = colNames.length + 1;
        for (int k = 0; k < title.length; ++k) {
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = title[k];
            ci.nullable = 1;
            dRowSet.setColInfo(j, ci);
            ++j;
        }
        HashSet changeId = new HashSet();
        for (int i = 0; i < this.currentList.size(); ++i) {
            if (this.currentList.get(rowIndex) == null) continue;
            changeId.add(this.currentList.get(i));
        }
        if (changeId != null && changeId.size() > 0) {
            if (this.catOrAdminFilter != null) {
                this.ev.getFilter().getFilterItems().remove(this.catOrAdminFilter);
            }
            FilterInfo filter = new FilterInfo();
            filter = this.ev.getFilter();
            FilterItemCollection filteritems = filter.getFilterItems();
            int filteritemsLength = filteritems.size();
            Iterator it = filteritems.iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            this.catOrAdminFilter = new FilterItemInfo("ASSETNUMBER", changeId, CompareType.INCLUDE);
            this.ev.getFilter().getFilterItems().add(this.catOrAdminFilter);
            this.ev.put("isFromPrint", (Object)"true");
            this.execute(true);
            this.ev.remove("isFromPrint");
        }
        IRowSet rowSet = null;
        rowSet = this.printRptList();
        JdbcRowSet jrowSet = (JdbcRowSet)rowSet;
        jrowSet.beforeFirst();
        int oldRsCount = 0;
        while (!jrowSet.isLast()) {
            dRowSet.moveToInsertRow();
            FaSubLedgerUI.clearRow((IRowSet)dRowSet);
            jrowSet.next();
            if (jrowSet.getString("ADMINNUM") != null) {
                cardNumber = jrowSet.getString("ADMINNUM");
            }
            if (jrowSet.getString("ASSETNAME") != null) {
                cardName = jrowSet.getString("ASSETNAME");
            }
            dRowSet.updateString("companyName", companyName);
            dRowSet.updateString("period", rptPeriod);
            dRowSet.updateString("header", header);
            dRowSet.updateString("cardNumber", cardNumber);
            dRowSet.updateString("cardName", cardName);
            dRowSet.updateString("BIZDATE", jrowSet.getString("BIZDATE"));
            dRowSet.updateString("BRIEF", jrowSet.getString("BRIEF"));
            dRowSet.updateString("ASSETTYPE", jrowSet.getString("ASSETTYPE"));
            dRowSet.updateString("CATNUM", jrowSet.getString("CATNUM"));
            dRowSet.updateString("ADMINDEPARTMENT", jrowSet.getString("ADMINDEPARTMENT"));
            dRowSet.updateString("ADMINNUM", jrowSet.getString("ADMINNUM"));
            dRowSet.updateString("BILLID", jrowSet.getString("BILLID"));
            dRowSet.updateString("FACURCARDID", jrowSet.getString("FACURCARDID"));
            dRowSet.updateString("VOUCHERNUMBER", jrowSet.getString("VOUCHERNUMBER"));
            dRowSet.updateString("BIZNUMBER", jrowSet.getString("BIZNUMBER"));
            dRowSet.updateString("BILLTYPE", jrowSet.getString("BILLTYPE"));
            dRowSet.updateString("ASSETNUMBER", cardNumber);
            dRowSet.updateString("abstract", jrowSet.getString("abstract"));
            dRowSet.updateString("ASSETNAME", jrowSet.getString("ASSETNAME"));
            dRowSet.updateString("UNIT", jrowSet.getString("UNIT"));
            dRowSet.updateString("ASSETAMT", jrowSet.getString("ASSETAMT"));
            dRowSet.updateString("CURRENCY", jrowSet.getString("CURRENCY"));
            dRowSet.updateString("FCURRENCYPRE", jrowSet.getString("FCURRENCYPRE"));
            dRowSet.updateString("FEXRATE", jrowSet.getString("FEXRATE"));
            dRowSet.updateString("FORIGINAMT", jrowSet.getString("FORIGINAMT"));
            dRowSet.updateString("FADDONS", jrowSet.getString("FADDONS"));
            dRowSet.updateString("FASSETVALUE", jrowSet.getString("FASSETVALUE"));
            dRowSet.updateBigDecimal("VALUEDEBIT", jrowSet.getBigDecimal("VALUEDEBIT"));
            dRowSet.updateBigDecimal("VALUECREDIT", jrowSet.getBigDecimal("VALUECREDIT"));
            dRowSet.updateBigDecimal("VALUEBAL", jrowSet.getBigDecimal("VALUEBAL"));
            dRowSet.updateBigDecimal("DEPRDEBIT", jrowSet.getBigDecimal("DEPRDEBIT"));
            dRowSet.updateBigDecimal("DEPRCREDIT", jrowSet.getBigDecimal("DEPRCREDIT"));
            dRowSet.updateString("DEPRBAL", jrowSet.getString("DEPRBAL"));
            dRowSet.updateBigDecimal("NETVALUE", jrowSet.getBigDecimal("NETVALUE"));
            dRowSet.updateBigDecimal("DEVALUEDEBIT", jrowSet.getBigDecimal("DEVALUEDEBIT"));
            dRowSet.updateBigDecimal("DEVALUECREDIT", jrowSet.getBigDecimal("DEVALUECREDIT"));
            dRowSet.updateBigDecimal("DEVALUEBAL", jrowSet.getBigDecimal("DEVALUEBAL"));
            dRowSet.updateString("NETAMOUNT", jrowSet.getString("NETAMOUNT"));
            dRowSet.updateString("COMPANY_ID", jrowSet.getString("COMPANY_ID"));
            dRowSet.insertRow();
            ++oldRsCount;
        }
        int recordNum = 0;
        if (oldRsCount > 50) {
            recordNum = oldRsCount % 50;
        } else if (oldRsCount < 50) {
            recordNum = 50 - oldRsCount;
        }
        this.currentList = this.cardNumList;
        return dRowSet;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private void invokePrintNew(boolean preview, IRowSet cardList) throws Exception {
        KDNoteHelper appHlp = new KDNoteHelper();
        BOSQueryDelegate data = FaRptPrintHelper.getPrintManagerForFaRptSublegerBatchPrint(cardList, this.rptPeriod, this.currCompany.getName(), this.title);
        if (preview) {
            this.index = 0;
            this.lastAdminCatItem = null;
            this.showData();
            appHlp.printPreview("/FI/FA/FaRptPrintTemplate", (Object)data, (Component)((Object)this));
        } else {
            this.index = 0;
            this.lastAdminCatItem = null;
            this.showData();
            appHlp.print("/FI/FA/FaRptPrintTemplate", (Object)data, (Component)((Object)this));
        }
    }

    private void invokePrint(boolean preview, IRowSet rowSet) throws Exception {
        KDNoteHelper appHlp = new KDNoteHelper();
        BOSQueryDelegate data = null;
        if ((this.isGroupByAssetType || this.isGroupByAdminDepartment) && this.labAssetAdminInfo.getText() != null) {
            HashMap<String, String> attachData = new HashMap<String, String>();
            attachData.put("assetAdmin", this.labAssetAdminInfo.getText().toString().trim());
            data = FaRptPrintHelper.getPrintManagerForFaRptSublegerPrint(rowSet, this.rptPeriod, this.currCompany.getName(), this.title, attachData);
        } else {
            data = FaRptPrintHelper.getPrintManagerForFaRptSublegerPrint(rowSet, this.rptPeriod, this.currCompany.getName(), this.title);
        }
        if (preview) {
            appHlp.printPreview("/FI/FA/FaRptPrintTemplate", (Object)data, (Component)((Object)this));
        } else {
            appHlp.print("/FI/FA/FaRptPrintTemplate", (Object)data, (Component)((Object)this));
        }
    }

    @Override
    public void actionSetPrintParam_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"isUseTempPrint", (Object)this.isUseTempPrint);
        uiContext.put((Object)"rptUI", (Object)this);
        String uiClassName = "com.kingdee.eas.fi.fa.rpt.client.FaRptPrintParamUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClassName, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    protected boolean isAllowVirtualOrg() {
        return true;
    }

    @Override
    public void actionViewVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().get() == null) {
            return;
        }
        int selectRow = this.tblMain.getSelectManager().get().getBeginRow();
        if (selectRow == -1) {
            return;
        }
        ICell billIdCell = this.tblMain.getRow(selectRow).getCell("BILLID");
        ICell billTypeCell = this.tblMain.getRow(selectRow).getCell("BILLTYPE");
        ICell voucherNoCell = this.tblMain.getRow(selectRow).getCell("voucherNumber");
        if (voucherNoCell.getValue() != null) {
            String billID = billIdCell.getValue().toString();
            String blllType = billTypeCell.getValue().toString();
            this.viewVoucher(billID, blllType);
        }
        super.actionViewVoucher_actionPerformed(e);
    }

    private void viewVoucher(String billId, String billType) throws Exception {
        if (billId == null) {
            return;
        }
        String voucherID = "";
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
        SelectorItemCollection voucherSeletor = new SelectorItemCollection();
        voucherSeletor.add(new SelectorItemInfo("voucher.id"));
        if ("1".equals(billType)) {
            FaChangeBillInfo changeBillInfo = FaChangeBillFactory.getRemoteInstance().getFaChangeBillInfo((IObjectPK)pk);
            if (changeBillInfo != null && changeBillInfo.get("voucher") != null) {
                voucherID = ((VoucherInfo)changeBillInfo.get("voucher")).getId().toString();
            }
        } else if ("2".equals(billType)) {
            FaClearBillInfo clearBillInfo = FaClearBillFactory.getRemoteInstance().getFaClearBillInfo((IObjectPK)pk, voucherSeletor);
            if (clearBillInfo != null && clearBillInfo.get("voucher") != null) {
                voucherID = ((VoucherInfo)clearBillInfo.get("voucher")).getId().toString();
            }
        } else if ("3".equals(billType)) {
            FaCurCardInfo curCardInfo = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)pk, voucherSeletor);
            if (curCardInfo != null && curCardInfo.get("voucher") != null) {
                voucherID = ((VoucherInfo)curCardInfo.get("voucher")).getId().toString();
            }
        } else if ("6".equals(billType)) {
            FaBakCardInfo bakCardInfo = FaBakCardFactory.getRemoteInstance().getFaBakCardInfo((IObjectPK)pk, voucherSeletor);
            if (bakCardInfo != null && bakCardInfo.get("voucher") != null) {
                voucherID = ((VoucherInfo)bakCardInfo.get("voucher")).getId().toString();
            }
        } else if ("7".equals(billType)) {
            FaEvaluateBillInfo evaluateBillInfo = FaEvaluateBillFactory.getRemoteInstance().getFaEvaluateBillInfo((IObjectPK)pk, voucherSeletor);
            if (evaluateBillInfo != null && evaluateBillInfo.get("voucher") != null) {
                voucherID = ((VoucherInfo)evaluateBillInfo.get("voucher")).getId().toString();
            }
        } else if ("5".equals(billType)) {
            Iterator iter;
            IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
            BOTRelationCollection relationCollection = iBotRelation.getCollection(new EntityViewInfo("where srcObjectID ='" + billId + "' and destEntityID ='" + VOUCHERTYPE + "'"));
            if (relationCollection.size() > 0 && (iter = relationCollection.iterator()).hasNext()) {
                BOTRelationInfo relationInfo = (BOTRelationInfo)iter.next();
                voucherID = relationInfo.getDestObjectID();
            }
        } else {
            return;
        }
        HashMap ids = new HashMap();
        Vector<String> voucherBillVector = new Vector<String>();
        voucherBillVector.add(voucherID);
        if (voucherBillVector.size() > 0) {
            ids.put(new VoucherInfo().getBOSType().toString(), voucherBillVector);
        }
        if (ids == null || ids.size() <= 0) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        FaClientUtils.showTraceUI((CoreUI)this, ids, (int)0);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.wbtFirstLine.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.wbtFirstLine.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.first"));
        this.wbtFirstLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.first"));
        this.wbtFirstLine.setEnabled(true);
        this.wbtPreviousLine.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.wbtPreviousLine.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.previous"));
        this.wbtPreviousLine.setEnabled(true);
        this.wbtPreviousLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.previous"));
        this.wbtNextLine.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.wbtNextLine.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.next"));
        this.wbtNextLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.next"));
        this.wbtNextLine.setEnabled(true);
        this.wbtLastLine.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.wbtLastLine.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.last"));
        this.wbtLastLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.last"));
        this.wbtLastLine.setEnabled(true);
        this.menuItemFirst.setEnabled(true);
        this.menuItemFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.menuItemFirst.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.first"));
        this.menuItemPrevious.setEnabled(true);
        this.menuItemPrevious.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.menuItemPrevious.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.previous"));
        this.menuItemNext.setEnabled(true);
        this.menuItemNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.menuItemNext.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.next"));
        this.menuItemLast.setEnabled(true);
        this.menuItemLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.menuItemLast.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.last"));
    }

    private void showStatusMessage(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    @Override
    protected void fillDataToTable(IRowSet rows, int start) throws Exception {
        super.fillDataToTable(rows, start);
    }

    private void showData() throws Exception {
        this.isGroupByAssetType = this.getCustomCond().get("isGroupByAssetType") == null ? false : (Boolean)this.getCustomCond().get("isGroupByAssetType");
        this.isGroupByAdminDepartment = this.getCustomCond().get("isGroupByDep") == null ? false : (Boolean)this.getCustomCond().get("isGroupByDep");
        boolean bl = this.isGroupByCard = this.getCustomCond().get("isGroupByCard") == null ? false : (Boolean)this.getCustomCond().get("isGroupByCard");
        if (this.isGroupByAssetType) {
            if (this.lastAdminCatItem != null && ((String)this.catNumList.get(this.index)).equals(this.lastAdminCatItem)) {
                return;
            }
            String currentAssetTypeOfTotle = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"currentAssetTypeOfTotle");
            this.setVisable(true);
            if (this.assetTypeList == null || this.assetTypeList.isEmpty() || this.catNumList == null || this.catNumList.isEmpty()) {
                this.setEnable(false);
                this.labAssetAdminInfo.setText(" ");
                this.showStatusMessage(currentAssetTypeOfTotle + " 0/0");
                return;
            }
            this.currentList = this.catNumList;
            if (this.assetTypeList.size() - 1 < this.index) {
                this.index = 0;
            }
            String assetTypeInfo = (String)this.assetTypeList.get(this.index);
            this.labAssetAdminInfo.setText(assetTypeInfo);
            if (this.catNumList.get(this.index) != null) {
                if (this.catOrAdminFilter != null) {
                    this.ev.getFilter().getFilterItems().remove(this.catOrAdminFilter);
                }
                this.catOrAdminFilter = new FilterItemInfo("assetCat.FLongNumber", this.currentList.get(this.index));
                FilterInfo filterMerge = new FilterInfo();
                filterMerge = this.ev.getFilter();
                String mask = this.ev.getFilter().getMaskString();
                FilterInfo newFilter = new FilterInfo();
                newFilter.getFilterItems().add(this.catOrAdminFilter);
                filterMerge.mergeFilter(newFilter, "and");
                this.ev.setFilter(filterMerge);
                this.execute(true);
                this.ev.getFilter().setMaskString(mask);
                this.lastAdminCatItem = (String)this.catNumList.get(this.index);
            }
            this.showStatusMessage(currentAssetTypeOfTotle + " " + (this.index + 1) + "/" + this.assetTypeList.size());
        } else if (this.isGroupByAdminDepartment) {
            if (this.lastAdminCatItem != null && ((String)this.adminNumList.get(this.index)).equals(this.lastAdminCatItem)) {
                return;
            }
            this.setVisable(true);
            String currentDepOfTotle = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"currentDepOfTotle");
            if (this.adminDepartmentList == null || this.adminDepartmentList.isEmpty() || this.adminNumList == null || this.adminNumList.isEmpty()) {
                this.setEnable(false);
                this.labAssetAdminInfo.setText(" ");
                this.showStatusMessage(currentDepOfTotle + " 0/0");
                return;
            }
            this.currentList = this.adminNumList;
            if (this.adminDepartmentList.size() - 1 < this.index) {
                this.index = 0;
            }
            String adminDepartmentInfo = (String)this.adminDepartmentList.get(this.index);
            this.labAssetAdminInfo.setText(adminDepartmentInfo);
            if (this.adminNumList.get(this.index) != null) {
                if (this.catOrAdminFilter != null) {
                    this.ev.getFilter().getFilterItems().remove(this.catOrAdminFilter);
                }
                this.catOrAdminFilter = new FilterItemInfo("useDepartment.FLongNumber", this.currentList.get(this.index));
                FilterInfo filterMerge = new FilterInfo();
                filterMerge = this.ev.getFilter();
                String mask = this.ev.getFilter().getMaskString();
                FilterInfo newFilter = new FilterInfo();
                newFilter.getFilterItems().add(this.catOrAdminFilter);
                filterMerge.mergeFilter(newFilter, "and");
                this.ev.setFilter(filterMerge);
                this.execute(true);
                this.ev.getFilter().setMaskString(mask);
                this.lastAdminCatItem = (String)this.adminNumList.get(this.index);
            }
            this.showStatusMessage(currentDepOfTotle + " " + (this.index + 1) + "/" + this.adminDepartmentList.size());
        } else if (this.isGroupByCard) {
            if (this.lastAdminCatItem != null && ((String)this.cardNumList.get(this.index)).equals(this.lastAdminCatItem)) {
                return;
            }
            this.setVisable(true);
            String currentCardOfTotle = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.RPTAutoGenerateResource", (String)"4_FaSubLedgerUI");
            if (this.cardNameList == null || this.cardNameList.isEmpty() || this.cardNumList == null || this.cardNumList.isEmpty()) {
                this.setEnable(false);
                this.labAssetAdminInfo.setText(" ");
                this.showStatusMessage(currentCardOfTotle + " 0/0");
                return;
            }
            this.currentList = this.cardNumList;
            if (this.cardNumList.size() - 1 < this.index) {
                this.index = 0;
            }
            String carNumber = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"cardNumber");
            String carName = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"cardAssetName");
            String cardInfo = carNumber + ":" + (String)this.cardNumList.get(this.index) + "    " + carName + ":" + this.cardNameList.get(this.index);
            this.labAssetAdminInfo.setText(cardInfo);
            if (this.cardNumList.get(this.index) != null) {
                if (this.catOrAdminFilter != null) {
                    this.ev.getFilter().getFilterItems().remove(this.catOrAdminFilter);
                }
                this.catOrAdminFilter = new FilterItemInfo("ASSETNUMBER", this.currentList.get(this.index));
                FilterInfo filterMerge = new FilterInfo();
                filterMerge = this.ev.getFilter();
                String mask = this.ev.getFilter().getMaskString();
                FilterInfo newFilter = new FilterInfo();
                newFilter.getFilterItems().add(this.catOrAdminFilter);
                filterMerge.mergeFilter(newFilter, "and");
                this.ev.setFilter(filterMerge);
                this.execute(true);
                this.ev.getFilter().setMaskString(mask);
                this.lastAdminCatItem = (String)this.cardNumList.get(this.index);
            }
            this.showStatusMessage(currentCardOfTotle + " " + (this.index + 1) + "/" + this.cardNumList.size());
        } else {
            this.setVisable(false);
            return;
        }
        if (this.index == 0) {
            this.wbtFirstLine.setEnabled(false);
            this.menuItemFirst.setEnabled(false);
            this.wbtPreviousLine.setEnabled(false);
            this.menuItemPrevious.setEnabled(false);
        } else {
            this.wbtFirstLine.setEnabled(true);
            this.menuItemFirst.setEnabled(true);
            this.wbtPreviousLine.setEnabled(true);
            this.menuItemPrevious.setEnabled(true);
        }
        if (this.index == this.currentList.size() - 1) {
            this.wbtNextLine.setEnabled(false);
            this.menuItemNext.setEnabled(false);
            this.wbtLastLine.setEnabled(false);
            this.menuItemLast.setEnabled(false);
        } else {
            this.wbtNextLine.setEnabled(true);
            this.menuItemNext.setEnabled(true);
            this.wbtLastLine.setEnabled(true);
            this.menuItemLast.setEnabled(true);
        }
    }

    private void setEnable(boolean isShow) {
        this.wbtFirstLine.setEnabled(isShow);
        this.wbtPreviousLine.setEnabled(isShow);
        this.wbtNextLine.setEnabled(isShow);
        this.wbtLastLine.setEnabled(isShow);
        this.menuItemFirst.setEnabled(isShow);
        this.menuItemPrevious.setEnabled(isShow);
        this.menuItemNext.setEnabled(isShow);
        this.menuItemLast.setVisible(isShow);
    }

    private void setVisable(boolean isShow) {
        this.wbtFirstLine.setVisible(isShow);
        this.wbtPreviousLine.setVisible(isShow);
        this.wbtNextLine.setVisible(isShow);
        this.wbtLastLine.setVisible(isShow);
        this.menuItemFirst.setVisible(isShow);
        this.menuItemPrevious.setVisible(isShow);
        this.menuItemNext.setVisible(isShow);
        this.menuItemLast.setVisible(isShow);
        this.labAssetAdminInfo.setVisible(isShow);
    }

    private void showIsUnAudit() {
        if (this.isUnAudit) {
            MsgBox.showInfo((Component)((Component)this.getUIContext().get("Owner")), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"alreadyDepr"));
            this.isUnAudit = false;
        }
    }

    @Override
    public void actionFirstLine_actionPerformed(ActionEvent e) throws Exception {
        this.index = 0;
        this.showData();
    }

    @Override
    public void actionNextLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.index < this.currentList.size() - 1) {
            ++this.index;
            this.showData();
        }
    }

    @Override
    public void actionPreviousLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.index > 0) {
            --this.index;
            this.showData();
        }
    }

    @Override
    public void actionLastLine_actionPerformed(ActionEvent e) throws Exception {
        this.index = this.currentList.size() - 1;
        this.showData();
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilter_actionPerformed(e);
        this.showIsUnAudit();
    }

    @Override
    protected void beforeExecute() throws Exception {
        this.isGroupByAssetType = this.getCustomCond().get("isGroupByAssetType") == null ? false : (Boolean)this.getCustomCond().get("isGroupByAssetType");
        this.isGroupByAdminDepartment = this.getCustomCond().get("isGroupByDep") == null ? false : (Boolean)this.getCustomCond().get("isGroupByDep");
        boolean bl = this.isGroupByCard = this.getCustomCond().get("isGroupByCard") == null ? false : (Boolean)this.getCustomCond().get("isGroupByCard");
        if (this.isGroupByAssetType || this.isGroupByAdminDepartment || this.isGroupByCard) {
            this.isFistAdminCat = true;
        }
    }

    @Override
    protected void afterExecute() throws Exception {
        int i;
        this.isFistAdminCat = false;
        this.lastAdminCatItem = null;
        this.index = 0;
        this.assetTypeList = (List)this.result.get("assetTypeList");
        this.catNumList = (List)this.result.get("catNumList");
        this.adminDepartmentList = (List)this.result.get("adminDepartmentList");
        this.adminNumList = (List)this.result.get("adminNumList");
        this.cardNameList = (List)this.result.get("cardNameList");
        this.cardNumList = (List)this.result.get("cardNumList");
        for (i = 0; i < this.assetTypeList.size(); ++i) {
            if (this.assetTypeList.get(i) != null && this.catNumList != null) continue;
            this.assetTypeList.remove(i);
            this.catNumList.remove(i);
        }
        for (i = 0; i < this.adminDepartmentList.size(); ++i) {
            if (this.adminDepartmentList.get(i) != null && this.adminNumList.get(i) != null) continue;
            this.adminDepartmentList.remove(i);
            this.adminNumList.remove(i);
        }
        for (i = 0; i < this.cardNameList.size(); ++i) {
            if (this.cardNameList.get(i) != null && this.cardNumList.get(i) != null) continue;
            this.cardNameList.remove(i);
            this.cardNumList.remove(i);
        }
        this.showData();
    }

    @Override
    protected void execute(boolean refresh) throws Exception {
        this.dropTempTable();
        if (!refresh || this.ev == null) {
            if (this.commonQueryDialog == null) {
                if (this.ev == null) {
                    this.ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    this.ev.setFilter(filter);
                }
            } else {
                this.ev = this.commonQueryDialog.getEntityViewInfoResult();
            }
        }
        this.ev.put("customcond", (Object)this.getCustomCond());
        this.displayPeriodInfo();
        if (this.isReQuery && this.isFistAdminCat) {
            IFaList manager = FaListFactory.getRemoteInstance();
            this.result = manager.getCatAdminNum(this.ev, "com.kingdee.eas.fi.fa.rpt.app.dao." + this.getDaoClassName());
            this.isReQuery = false;
            return;
        }
        this.tblMain.setRefresh(false);
        Map result = this.findData(this.ev);
        if (this.isVirtualMode()) {
            this.tblMain.getDataRequestManager().setDataRequestMode(1);
            if (this.dataRequstListener == null) {
                this.dataRequstListener = new KDTDataRequestListener(){

                    public void tableDataRequest(KDTDataRequestEvent e) {
                        FaSubLedgerUI.this.tblMain_doRequestRowSet1(e);
                    }
                };
            }
            if (this.tblMain.getListenerList().getListenerCount(KDTDataRequestListener.class) == 0) {
                this.tblMain.addKDTDataRequestListener(this.dataRequstListener);
            }
        } else {
            this.tblMain.getDataRequestManager().setDataRequestMode(0);
            if (this.dataRequstListener != null) {
                this.tblMain.removeKDTDataRequestListener(this.dataRequstListener);
            }
        }
        if (result != null && result.size() > 0) {
            this.applyData(result);
        }
        this.validate();
        this.repaint();
        if (Boolean.TRUE.equals(result.get("hasNoAudit"))) {
            this.isUnAudit = true;
        }
    }

    @Override
    protected void handleFirstLoadData(int start, int length) throws BOSException, Exception {
        IRowSet rowSet;
        IFaList manager = FaListFactory.getRemoteInstance();
        if (this.getTreeColumn() != null) {
            int topLevel = this.getTreeColumn().getTopLevel();
            int specLevel = (Integer)this.getCustomCond().get("defCompanyLevel") - 1;
            rowSet = manager.getTreeDataForFirstSpec(this.resultSql, length, topLevel, specLevel);
        } else {
            rowSet = manager.getDataForFirst(this.resultSql, length);
        }
        if (this.getTreeColumn() != null) {
            int specLevel = (Integer)this.getCustomCond().get("defCompanyLevel") - 1;
            this.treeIdList = new TreeIdsList(this.getTreeColumn().getTopLevel());
            this.treeIdList.initNode(this.resultSql, specLevel);
            this.tblMain.setRowCount(this.treeIdList.getViewRowCount());
        }
        this.tblMain.addRows(rowSet.size());
        this.fillDataToTable(rowSet, start);
        if (rowSet.size() == length || this.getTreeColumn() != null) {
            this.getAllDataOfId();
        }
    }

    @Override
    protected void getAllDataOfId() {
        this.getAllIdThread = new GetIdThreadForSpec(this);
        this.getAllIdThread.setDaemon(true);
        this.getAllIdThread.start();
        Date nowEnd = new Date();
        logger.debug((Object)("getAllDataOfId end at : " + nowEnd));
    }

    @Override
    protected void setProperNodeOpen(IDNode node) {
        int specLevel = (Integer)this.getCustomCond().get("defCompanyLevel") - 1;
        if (node.getLevel() <= specLevel + this.getTreeColumn().getTopLevel() - 1) {
            node.setOpen(true);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.lastAdminCatItem = null;
        this.showData();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
            request.put("COMPANY", (Object)SysContext.getSysContext().getCurrentFIUnit());
            request.put("USERINFO", (Object)SysContext.getSysContext().getCurrentUserInfo());
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    class GetIdThreadForSpec
    extends Thread {
        FaRptBaseUI baseUi;

        public GetIdThreadForSpec(FaRptBaseUI baseUI) {
            this.baseUi = baseUI;
        }

        @Override
        public void run() {
            try {
                int specLevel = (Integer)FaSubLedgerUI.this.getCustomCond().get("defCompanyLevel") - 1;
                if (FaSubLedgerUI.this.tempTableName == null || !FaSubLedgerUI.this.tempTableName.equals(FaSubLedgerUI.this.resultSql.getFrom())) {
                    return;
                }
                if (FaSubLedgerUI.this.getTreeColumn() != null) {
                    FaSubLedgerUI.this.treeIdList = new TreeIdsList(FaSubLedgerUI.this.getTreeColumn().getTopLevel());
                    FaSubLedgerUI.this.treeIdList.initNode(FaSubLedgerUI.this.resultSql, specLevel);
                    FaSubLedgerUI.this.tblMain.setRowCount(FaSubLedgerUI.this.treeIdList.getViewRowCount());
                } else {
                    FaSubLedgerUI.this.allIdList = new ArrayList();
                    if (FaSubLedgerUI.this.tempTableName != null) {
                        IFaList manager = FaListFactory.getRemoteInstance();
                        IRowSet ids = manager.getIdList(FaSubLedgerUI.this.resultSql);
                        while (ids != null && ids.next()) {
                            FaSubLedgerUI.this.allIdList.add(ids.getString("FId"));
                        }
                    }
                    if (FaSubLedgerUI.this.allIdList != null) {
                        FaSubLedgerUI.this.tblMain.setRowCount(FaSubLedgerUI.this.allIdList.size());
                    }
                }
                FaSubLedgerUI.this.setButtonEnabled(true);
            }
            catch (Exception ex) {
                FaSubLedgerUI.this.setButtonEnabled(true);
                this.baseUi.handUIExceptionAndAbort(ex);
            }
        }
    }
}

