/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.rpt.FaSumItemEnum;
import com.kingdee.eas.fi.fa.rpt.FabirptUtils;
import com.kingdee.eas.fi.fa.rpt.client.AbstractFabiRptComposingFilterUI;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FabiRptComposingFilterUI
extends AbstractFabiRptComposingFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FabiRptComposingFilterUI.class);
    private PeriodCollection availableAcctPeriod = new PeriodCollection();

    public void onInit(RptParams initParams) throws Exception {
        this.btnSelectCompany.setIcon(EASResource.getIcon((String)"imgTbtn_orgstruchart"));
        this.spnAcctPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FabiRptComposingFilterUI.this.fireYearChange();
            }
        });
        this.spnAcctPeriodYear.setEnabled(false);
        this.spnAcctPeriodNumber.setEnabled(false);
        this.spnAcctPeriodYear.setValue((Object)Integer.valueOf("0"));
        this.spnAcctPeriodNumber.setValue((Object)Integer.valueOf("0"));
        this.configUI(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setCustomCondition(RptParams params) {
        Object composingMode;
        Object acctPeriod;
        RptConditionManager rm = new RptConditionManager(params);
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        Object acctPeriodYear = rm.getProperty("acctPeriodYear");
        if (acctPeriodYear != null) {
            this.spnAcctPeriodYear.setValue(acctPeriodYear);
        }
        if ((acctPeriod = rm.getProperty("acctPeriodNumber")) != null) {
            this.spnAcctPeriodNumber.setValue(acctPeriod);
        }
        if ((composingMode = rm.getProperty("composingMode")) != null) {
            this.cbxComposingMode.setSelectedItem(composingMode);
        }
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.setProperty("companyIdSet", this.companyIdSet == null ? new HashSet() : this.companyIdSet);
        rm.setProperty("acctPeriodYear", this.spnAcctPeriodYear.getValue());
        rm.setProperty("acctPeriodNumber", this.spnAcctPeriodNumber.getValue());
        FaSumItemEnum composeMode = (FaSumItemEnum)((Object)this.cbxComposingMode.getSelectedItem());
        rm.setProperty("composingMode", (Object)composeMode);
        return rm.toRptParams();
    }

    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        Integer acctPeriodYear = this.spnAcctPeriodYear.getIntegerVlaue();
        Integer acctPeriodNumber = this.spnAcctPeriodNumber.getIntegerVlaue();
        if (acctPeriodYear <= 0 || acctPeriodNumber <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"incorrectAcctYearOrPeriod"));
            return false;
        }
        return true;
    }

    public void onCompanySelected(String[] companyIds) {
        Set oldCompanyIdSet = this.companyIdSet;
        super.onCompanySelected(companyIds);
        if (this.needRefreshAcctPeriod(oldCompanyIdSet, this.companyIdSet)) {
            boolean isSuccessful = false;
            try {
                this.initAcctPeriod(this.companyIdSet);
                isSuccessful = true;
            }
            catch (EASBizException e) {
                this.companyIdSet = oldCompanyIdSet;
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.companyIdSet = oldCompanyIdSet;
                this.handUIException(e);
            }
            if (this.availableAcctPeriod.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"noOverlappedAcctPeriod"));
            }
            if (isSuccessful) {
                this.configUI(false);
            }
        }
    }

    private boolean needRefreshAcctPeriod(Set oldCompanyIdSet, Set newCompanyIdSet) {
        if (newCompanyIdSet == null) {
            return false;
        }
        if (oldCompanyIdSet == null) {
            return true;
        }
        return !newCompanyIdSet.equals(oldCompanyIdSet);
    }

    private void fireYearChange() {
        this.configUI(true);
    }

    private void configUI(boolean onlyConfigPeriodNumber) {
        if (onlyConfigPeriodNumber) {
            this.configAcctPeriodNumber();
        } else {
            this.configAcctPeriodYearAndNumber();
        }
    }

    private void configAcctPeriodNumber() {
        Integer acctPeriodYear = this.spnAcctPeriodYear.getIntegerVlaue();
        List periods = FabirptUtils.findAndDecreasingAcctPeriods(this.availableAcctPeriod, acctPeriodYear);
        if (periods.size() == 0) {
            this.spnAcctPeriodNumber.setEnabled(false);
            this.spnAcctPeriodNumber.setValue((Object)Integer.valueOf("0"));
            return;
        }
        SpinnerNumberModel spnModel = new SpinnerNumberModel();
        this.spnAcctPeriodNumber.setModel((SpinnerModel)spnModel);
        PeriodInfo minPeriod = (PeriodInfo)periods.get(0);
        spnModel.setMinimum(Integer.valueOf(String.valueOf(minPeriod.getPeriodNumber())));
        PeriodInfo maxPeriod = periods.size() == 1 ? minPeriod : periods.get(periods.size() - 1);
        spnModel.setMaximum(Integer.valueOf(String.valueOf(maxPeriod.getPeriodNumber())));
        spnModel.setValue(Integer.valueOf(String.valueOf(minPeriod.getPeriodNumber())));
        this.spnAcctPeriodYear.setEnabled(true);
        this.spnAcctPeriodNumber.setEnabled(true);
    }

    private void configAcctPeriodYearAndNumber() {
        if (this.availableAcctPeriod.size() == 0) {
            this.spnAcctPeriodYear.setEnabled(false);
            this.spnAcctPeriodNumber.setEnabled(false);
            this.spnAcctPeriodYear.setValue((Object)Integer.valueOf("0"));
            this.spnAcctPeriodNumber.setValue((Object)Integer.valueOf("0"));
        } else {
            List<Object> periods = Arrays.asList(this.availableAcctPeriod.toArray());
            FabirptUtils.decreasingAcctPeriod(periods);
            PeriodInfo minPeriod = (PeriodInfo)periods.get(0);
            PeriodInfo maxPeriod = periods.size() == 1 ? minPeriod : periods.get(periods.size() - 1);
            SpinnerNumberModel spnYearModel = new SpinnerNumberModel();
            this.spnAcctPeriodYear.setModel((SpinnerModel)spnYearModel);
            spnYearModel.setMinimum(Integer.valueOf(String.valueOf(minPeriod.getPeriodYear())));
            spnYearModel.setMaximum(Integer.valueOf(String.valueOf(maxPeriod.getPeriodYear())));
            spnYearModel.setValue(Integer.valueOf(String.valueOf(maxPeriod.getPeriodYear())));
            this.spnAcctPeriodYear.setEnabled(true);
            this.spnAcctPeriodNumber.setEnabled(true);
        }
    }

    private void initAcctPeriod(Set companyIdSet) throws BOSException, EASBizException {
        IObjectCollection periods = FabirptUtils.queryIntersectionAcctPeriod(companyIdSet);
        this.availableAcctPeriod.clear();
        this.availableAcctPeriod.addObjectCollection(periods);
    }
}

