/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.BalanceCompareFilter;
import com.kingdee.eas.fi.books.client.AbstractBalanceCompareListFilterUI;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class BalanceCompareListFilterUI
extends AbstractBalanceCompareListFilterUI {
    private static final long serialVersionUID = -1222286469222237911L;
    boolean loading = false;
    private Map initDataMap = null;
    private CompanyOrgUnitInfo transferOrg = SysContext.getSysContext().getCurrentFIUnit();

    public BalanceCompareListFilterUI() throws Exception {
        this.initCompanyF7();
        this.initParam();
    }

    private void initCompanyF7() {
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        f7.setShowAssistantOrg(false);
        f7.setIsCUFilter(false);
        f7.setShowVirtual(false);
        f7.setContainSealUp(true);
        f7.setNeedAddAssistant(true);
        f7.setPermissionItem(this.getPermissionItem());
        this.prmtCompany.setSelector((KDPromptSelector)f7);
        this.prmtCompany.setEditable(false);
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                CompanyOrgUnitInfo oldCompany = null;
                CompanyOrgUnitInfo newCompany = null;
                if (e.getOldValue() != null && e.getOldValue() instanceof CompanyOrgUnitInfo) {
                    oldCompany = (CompanyOrgUnitInfo)e.getOldValue();
                }
                if (e.getNewValue() != null && e.getNewValue() instanceof CompanyOrgUnitInfo) {
                    newCompany = (CompanyOrgUnitInfo)e.getNewValue();
                }
                if (newCompany == null || !BooksUtil.checkSelectedCompany((Component)((Object)BalanceCompareListFilterUI.this), newCompany)) {
                    return;
                }
                if (oldCompany == null || !newCompany.getId().toString().equals(oldCompany.getId().toString())) {
                    BalanceCompareListFilterUI.this.transferOrg = newCompany;
                    BalanceCompareListFilterUI.this.initParam();
                }
            }
        });
    }

    private void initParam() {
        this.getUIContext().put("company", this.transferOrg);
        try {
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.transferOrg);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYear, (KDSpinner)this.spnPeriodNumber, (KDSpinner)this.spnPeriodYear, (KDSpinner)this.spnPeriodNumber, (boolean)false, (boolean)false);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public BalanceCompareFilter getCustomCondition() {
        BalanceCompareFilter condition = new BalanceCompareFilter();
        condition.setTransferOrg(this.getTransferOrg());
        condition.setPeriodYearStart((Integer)this.spnPeriodYear.getValue());
        condition.setPeriodNumberStart((Integer)this.spnPeriodNumber.getValue());
        condition.setAccountLevelStart((Integer)this.spnAccountLevel.getValue());
        CurrencyInfo currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        if (currency != null) {
            if (currency.getId() != null) {
                condition.setCurrencyID(currency.getId().toString());
                condition.setCurCurrency(currency);
            } else {
                condition.setCurrencyID(currency.getNumber());
            }
            condition.setCurrencyName(currency.getName());
        }
        condition.setOptionPosting(this.chkOpIncludeNotPosting.isSelected());
        condition.setOptionOnlyLeaf(this.chkOpOnlyLeaf.isSelected());
        condition.setIncludeBWAccount(this.chkIncludeBW.isSelected());
        return condition;
    }

    public void setCustomCondition(BalanceCompareFilter condition) {
        if (condition == null) {
            return;
        }
        this.prmtCompany.setValue((Object)condition.getTransferOrg());
        this.spnPeriodYear.setValue((Object)new Integer(condition.getPeriodYearStart()));
        this.spnPeriodNumber.setValue((Object)new Integer(condition.getPeriodNumberStart()));
        this.spnAccountLevel.setValue((Object)new Integer(condition.getAccountLevelStart()));
        String currencyId = condition.getCurrencyID();
        if (currencyId != null && currencyId.length() > 0) {
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getItemAt(i);
                if (currencyInfo == null || !currencyId.equals(currencyInfo.getId().toString()) && !currencyId.equals(currencyInfo.getNumber())) continue;
                this.cmbCurrency.setSelectedIndex(i);
                break;
            }
        }
        this.chkOpIncludeNotPosting.setSelected(condition.getOptionPosting());
        this.chkOpOnlyLeaf.setSelected(condition.getOptionOnlyLeaf());
        this.chkIncludeBW.setSelected(condition.getIncludeBWAccount());
    }

    public static Collection getInitDataItem() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("AllCurrency");
        list.add("CurrentPeriod");
        list.add("MaxAccountLevel");
        list.add("PeriodRange");
        list.add("DefaultCurrency");
        return list;
    }

    public void setInitData(Map initData) throws EASBizException, BOSException {
        CurrencyCollection currencyCollection;
        this.loading = true;
        this.initDataMap = initData;
        try {
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.transferOrg);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYear, (KDSpinner)this.spnPeriodNumber, (KDSpinner)this.spnPeriodYear, (KDSpinner)this.spnPeriodNumber, (boolean)false);
        }
        catch (Exception e) {
            throw new ReportException(ReportException.PERIOD_ERROR, e);
        }
        Integer maxLevel = (Integer)initData.get("MaxAccountLevel");
        if (maxLevel != null) {
            SpinnerNumberModel levelModel = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnAccountLevel.setModel((SpinnerModel)levelModel);
        }
        if ((currencyCollection = (CurrencyCollection)initData.get("AllCurrency")) != null) {
            this.cmbCurrency.removeAllItems();
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cmbCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.loading = false;
    }

    public void clear() {
        CurrencyCollection currencyCollection;
        this.prmtCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        try {
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.transferOrg);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYear, (KDSpinner)this.spnPeriodNumber, (KDSpinner)this.spnPeriodYear, (KDSpinner)this.spnPeriodNumber, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        Integer maxLevel = (Integer)this.initDataMap.get("MaxAccountLevel");
        if (maxLevel != null) {
            SpinnerNumberModel levelModel = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnAccountLevel.setModel((SpinnerModel)levelModel);
        }
        if ((currencyCollection = (CurrencyCollection)this.initDataMap.get("AllCurrency")) != null) {
            this.cmbCurrency.removeAllItems();
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cmbCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.chkOpIncludeNotPosting.setSelected(false);
        this.chkOpOnlyLeaf.setSelected(false);
    }

    @Override
    protected void chkOpOnlyLeaf_itemStateChanged(ItemEvent e) throws Exception {
        super.chkOpOnlyLeaf_itemStateChanged(e);
        this.spnAccountLevel.setEnabled(!((KDCheckBox)e.getSource()).isSelected());
    }

    public Object getParam() {
        return this.getCustomCondition().toMap();
    }

    public void setParam(Object param) {
        if (param != null) {
            try {
                this.setCustomCondition(new BalanceCompareFilter((Map)param));
            }
            catch (CloneNotSupportedException ex) {
                this.handUIException(ex);
            }
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)this.getParam());
        return cp;
    }

    public Component getFocusComponent() {
        return ((KDSpinner.DefaultNumberEditor)this.spnPeriodYear.getEditor()).getTextField();
    }

    private String getPermissionItem() {
        return "balanceMirror";
    }

    public CompanyOrgUnitInfo getTransferOrg() {
        return this.transferOrg;
    }

    public void setTransferOrg(CompanyOrgUnitInfo transferOrg) {
        this.transferOrg = transferOrg;
    }

    public boolean verify() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CWGXResource", (String)"companyIsNull"));
            return false;
        }
        return true;
    }
}

