/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.BalanceCompareFacadeFactory;
import com.kingdee.eas.fi.books.BalanceCompareFilter;
import com.kingdee.eas.fi.books.IBalanceCompareFacade;
import com.kingdee.eas.fi.books.client.AbstractBalanceCompareListUI;
import com.kingdee.eas.fi.books.client.BalanceCompareListFilterUI;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LowTimer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.KeyStroke;

public class BalanceCompareListUI
extends AbstractBalanceCompareListUI {
    ReportResultInfo result = null;
    private boolean isFirstDefaultQuery = true;
    private static final long serialVersionUID = -1160025034101042213L;
    CommonQueryDialog conditionDialog = null;
    BalanceCompareListFilterUI conditionPanel = null;
    CurrencyInfo curCurrency = null;
    private CompanyOrgUnitInfo transferOrg = SysContext.getSysContext().getCurrentFIUnit();
    private static final String ReportPeriodExtraRes = "com.kingdee.eas.fi.gl.ReportPeriodExtraRes";

    @Override
    public void onLoad() throws Exception {
        BooksUtil.checkBiz((CompanyOrgUnitInfo)this.transferOrg);
        super.onLoad();
        this.getTable().getDataRequestManager().setDataRequestMode(1);
        this.getTable().getViewManager().unFreeze();
        this.getMainStatusBar().setPerTitle(GlUtils.getSysStatusBarTitle(this.transferOrg));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl Q"));
        this.menuItemRefresh.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.menuItemPrint.setAccelerator(KeyStroke.getKeyStroke("ctrl P"));
        this.menuItemPrintView.setAccelerator(KeyStroke.getKeyStroke("ctrl shift P"));
        this.menuItemToolBarCustom.setVisible(false);
        this.menuItemToolBarCustom.setEnabled(false);
        this.actionToolBarCustom.setEnabled(false);
    }

    private void checkIfAccountIsClosed() throws BOSException, EASBizException {
        String orgUnitId = this.transferOrg.getId().toString();
        IGLFlag flag = GLFlagFactory.getRemoteInstance();
        if (!flag.getGLInitClosed(orgUnitId)) {
            throw new AccountBooksException(AccountBooksException.ACCOUNT_NOT_CLOSED);
        }
    }

    private void checkHasRefContrast(String srcTable, String objTable, String companyId) throws EASBizException, BOSException {
        IBalanceCompareFacade facade = BalanceCompareFacadeFactory.getRemoteInstance();
        if (!facade.getRefContrastId(srcTable, objTable, companyId) && !srcTable.equals(objTable)) {
            throw new AccountBooksException(AccountBooksException.ACCT_NOTREF_COMPARE);
        }
    }

    @Override
    protected Collection getInitList() {
        Collection list = BalanceCompareListFilterUI.getInitDataItem();
        list.add("DefaultTableHead");
        list.add("CurrentCompany");
        return list;
    }

    @Override
    protected IGLReport getRemoteInstance() throws BOSException {
        return BalanceCompareFacadeFactory.getRemoteInstance();
    }

    @Override
    protected void openConditionDialog() throws Exception {
        EntityViewInfo mainQuery = null;
        if (this.isFirstDefaultQuery) {
            this.isFirstDefaultQuery = false;
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
            if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                mainQuery = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                if (solution.getQueryPanelInfo().get(0).getCustomerParams() != null) {
                    this.getConditionPanel().setCustomerParams(CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams()));
                }
            }
        }
        if (mainQuery == null && this.getConditionDialog().show()) {
            mainQuery = this.getConditionDialog().getEntityViewInfoResult();
            if (this.conditionPanel != null) {
                this.transferOrg = this.conditionPanel.getTransferOrg();
            }
        }
        if (mainQuery != null) {
            if (this.conditionPanel != null) {
                this.transferOrg = this.conditionPanel.getTransferOrg();
            }
            this.checkIfAccountIsClosed();
            GlUtils.updateBalance(new String[]{this.transferOrg.getId().toString()});
            this.query(mainQuery);
            this.tHelper.init();
        }
    }

    @Override
    protected void query(EntityViewInfo mainQuery) throws Exception {
        String srcTable = null;
        String objTable = null;
        String companyId = null;
        try {
            srcTable = BooksUtil.getCurrentMasterCompany(null, (CompanyOrgUnitInfo)this.transferOrg).getAccountTable().getId().toString();
            objTable = this.transferOrg.getAccountTable().getId().toString();
            companyId = this.transferOrg.getId().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (srcTable != null && objTable != null && companyId != null) {
            this.checkHasRefContrast(srcTable, objTable, companyId);
        }
        BalanceCompareFilter condition = ((BalanceCompareListFilterUI)this.getConditionPanel()).getCustomCondition();
        this.curCurrency = condition.getCurCurrency();
        mainQuery.put("GLFixCondition", (Object)condition);
        CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany(null, (CompanyOrgUnitInfo)this.transferOrg);
        condition.setMasterCompany(masterCompany);
        this.setCondition(mainQuery);
        this.masterCompany.setText(EASResource.getString((String)ReportPeriodExtraRes, (String)"MASTERCOMPANY") + ": " + BooksUtil.getCurrentMasterCompany(null, (CompanyOrgUnitInfo)this.transferOrg).getName());
        this.subCompany.setText(EASResource.getString((String)ReportPeriodExtraRes, (String)"TRANSFERCOMPANY") + ": " + this.transferOrg.getName());
        this.lblPeriod.setText(EASResource.getString((String)ReportPeriodExtraRes, (String)"PREPERIOD") + this.getPeriodTitle(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearStart(), condition.getPeriodNumberStart()));
        StringBuffer sb = new StringBuffer(EASResource.getString((String)ReportPeriodExtraRes, (String)"PRECURRENCY"));
        sb.append(condition.getCurrencyName());
        this.lblCurrency.setText(sb.toString());
        this.tblMain.removeRows();
    }

    @Override
    public CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new BalanceCompareListFilterUI();
            this.conditionPanel.setInitData(this.getInitData());
        }
        return this.conditionPanel;
    }

    @Override
    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.conditionDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(250);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setTitle(this.getConditionPanel().getUITitle());
            this.conditionDialog.setAllowSystemSolutionAsDefaultFilter(false);
        }
        return this.conditionDialog;
    }

    @Override
    protected void showResult(ReportResultInfo result, KDTable tableForShowResult, int startRow) {
        if (result == null) {
            return;
        }
        tableForShowResult.setRefresh(false);
        this.tblMain.checkParsed();
        this.showData(result.getData());
        if (result.getData() != null && result.getData().size() > 0) {
            tableForShowResult.setRefresh(true);
            tableForShowResult.reLayoutAndPaint();
        }
    }

    private void showData(ArrayList list) {
        String amountFormat = GlUtils.getDecimalFormatString();
        this.tblMain.getColumn("MasterEndDebit").getStyleAttributes().setNumberFormat(amountFormat);
        this.tblMain.getColumn("MasterEndCredit").getStyleAttributes().setNumberFormat(amountFormat);
        this.tblMain.getColumn("AdjustDebit").getStyleAttributes().setNumberFormat(amountFormat);
        this.tblMain.getColumn("AdjustCredit").getStyleAttributes().setNumberFormat(amountFormat);
        this.tblMain.getColumn("SubEndDebit").getStyleAttributes().setNumberFormat(amountFormat);
        this.tblMain.getColumn("SubEndCredit").getStyleAttributes().setNumberFormat(amountFormat);
        int currencyPrecision = 2;
        try {
            CurrencyInfo baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.transferOrg.getBaseCurrency().getId()));
            currencyPrecision = baseCurrency.getPrecision();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.setNumberFormat(currencyPrecision);
        for (Object[] data : list) {
            Object subEndBalance;
            IRow row = this.tblMain.addRow();
            row.getCell("AccountNumbers").setValue(data[0]);
            row.getCell("AccountNames").setValue(data[1]);
            row.getCell("subAcctNumbers").setValue(data[6]);
            row.getCell("subAcctNames").setValue(data[7]);
            Object masterEndBalance = data[2];
            if (masterEndBalance != null && this.getFormateAmount(masterEndBalance, currencyPrecision).compareTo(InitClientHelp.zero) > 0) {
                row.getCell("MasterEndDebit").setValue((Object)this.getFormateAmount(masterEndBalance, currencyPrecision));
            } else if (masterEndBalance != null && this.getFormateAmount(masterEndBalance, currencyPrecision).compareTo(InitClientHelp.zero) < 0) {
                row.getCell("MasterEndCredit").setValue((Object)this.getFormateAmount(masterEndBalance, currencyPrecision).negate());
            }
            Object adjustDebitBalance = data[3];
            Object adjustCreditBalance = data[4];
            if (adjustDebitBalance != null && this.getFormateAmount(adjustDebitBalance, currencyPrecision).compareTo(InitClientHelp.zero) != 0) {
                row.getCell("AdjustDebit").setValue((Object)this.getFormateAmount(adjustDebitBalance, currencyPrecision));
            }
            if (adjustCreditBalance != null && this.getFormateAmount(adjustCreditBalance, currencyPrecision).compareTo(InitClientHelp.zero) != 0) {
                row.getCell("AdjustCredit").setValue((Object)this.getFormateAmount(adjustCreditBalance, currencyPrecision));
            }
            if ((subEndBalance = data[5]) != null && this.getFormateAmount(subEndBalance, currencyPrecision).compareTo(InitClientHelp.zero) > 0) {
                row.getCell("SubEndDebit").setValue((Object)this.getFormateAmount(subEndBalance, currencyPrecision));
                continue;
            }
            if (subEndBalance == null || this.getFormateAmount(subEndBalance, currencyPrecision).compareTo(InitClientHelp.zero) >= 0) continue;
            row.getCell("SubEndCredit").setValue((Object)this.getFormateAmount(subEndBalance, currencyPrecision).negate());
        }
    }

    private void setNumberFormat(int currencyPrecision) {
        this.tblMain.getColumn("MasterEndDebit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)currencyPrecision, (boolean)true));
        this.tblMain.getColumn("MasterEndCredit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)currencyPrecision, (boolean)true));
        this.tblMain.getColumn("AdjustDebit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)currencyPrecision, (boolean)true));
        this.tblMain.getColumn("AdjustCredit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)currencyPrecision, (boolean)true));
        this.tblMain.getColumn("SubEndDebit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)currencyPrecision, (boolean)true));
        this.tblMain.getColumn("SubEndCredit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)currencyPrecision, (boolean)true));
    }

    private BigDecimal getFormateAmount(Object data, int precision) {
        InitClientHelp.ScaleHelp scaleHelp = new InitClientHelp.ScaleHelp();
        scaleHelp.setScale(precision);
        return scaleHelp.getScaleBigDecimal(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            this.setCursorOfWair();
            if (e.getDataRequestMode() == 0) {
                return;
            }
            LowTimer t = new LowTimer();
            t.reset();
            IGLReport report = null;
            try {
                EntityViewInfo evi = this.getCondition();
                ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
                customCondition.setNewQuery(e.getFirstRow() == 0);
                report = this.getRemoteInstance();
                this.setCompanyCondition(this.getCondition());
                this.result = report.findData(this.getCondition(), e.getFirstRow(), e.getLastRow() - e.getFirstRow() + 1, this.getTempTableName(), this.transferOrg, false);
                this.setTempTableName(this.result.getTempTableName());
                this.showResult(this.result, this.getTable(), e.getFirstRow());
            }
            catch (Exception err) {
                this.getTable().setRowCount(0);
                this.setTempTableName(null);
                this.handUIException(err);
                SysUtil.abort();
            }
            Object var3_3 = null;
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    @Override
    protected boolean isNeedUpdateTableHead() {
        return true;
    }

    @Override
    protected boolean isNeedUpdateTableColumnVisible() {
        return true;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    protected void initTableHead(ReportTableHeadInfo tableHeadInfo, KDTable tableForInit) {
    }

    protected boolean initDefaultFilter() {
        return false;
    }
}

