/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.BalanceInitFacadeFactory;
import com.kingdee.eas.fi.books.IBalanceInitFacade;
import com.kingdee.eas.fi.books.client.AbstractBalanceInitWizardUI;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GLTaskProcessor;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.GLTaskMonitor;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;

public class BalanceInitWizardUI
extends AbstractBalanceInitWizardUI {
    private static final String BOOKS_RESOURCE = "com.kingdee.eas.fi.books.AccountBooksResource";
    private static final String GL_RESOURCE = "com.kingdee.eas.fi.gl.GLResource";
    private static final long serialVersionUID = 7131818466919089673L;
    private HashMap otherCtx = new HashMap();
    private boolean isAccountInit = false;
    private String[] closedAsstAccount;
    private String[] closedCussentAccount;
    private boolean allowCussent = true;

    public void onLoad() throws Exception {
        BooksUtil.checkBiz();
        super.onLoad();
        this.init();
    }

    private void init() throws EASBizException, BOSException {
        this.otherCtx.put("COMPANY", InitClientHelp.getCurrentCompany());
        ArrayList datas = BalanceInitWizardUI.getFacade().getInitData(this.otherCtx);
        Boolean b = (Boolean)datas.get(0);
        this.isAccountInit = b;
        this.closedAsstAccount = (String[])datas.get(1);
        this.closedCussentAccount = (String[])datas.get(2);
        this.allowCussent = (Boolean)datas.get(3);
        this.lbPic.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        PeriodInfo startPeriod = GlUtils.getStartPeriod(null, InitClientHelp.getCurrentCompany().getId().toString());
        if (startPeriod != null) {
            this.spYear.setValue((Object)new Integer(startPeriod.getPeriodYear()));
            this.spNumber.setValue((Object)new Integer(startPeriod.getPeriodNumber()));
        }
        this.btnOK.setEnabled(true);
        this.btnFinish.setVisible(false);
        this.btnCancel.setEnabled(true);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        int type = (this.chkAcctBalance.isSelected() ? 1 : 0) | (this.chkAsstBalance.isSelected() ? 2 : 0) | (this.chkCussentBalance.isSelected() ? 4 : 0);
        this.verify(type);
        CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany(null);
        PeriodInfo startPeriod = GlUtils.getStartPeriod(null, InitClientHelp.getCurrentCompany().getId().toString());
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)masterCompany);
        this.otherCtx.put("type", new Integer(type));
        this.otherCtx.put("startperiod", startPeriod);
        this.otherCtx.put("currentperiod", currentPeriod);
        this.otherCtx.put("periodyear", this.spYear.getValue());
        this.otherCtx.put("periodnumber", this.spNumber.getValue());
        this.otherCtx.put("mastercompany", masterCompany);
        this.otherCtx.put("curcompany", InitClientHelp.getCurrentCompany());
        this.otherCtx.put("curbook", BooksUtil.getCurrentBook(null));
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.otherCtx.put("CUID", cuid);
        this.otherCtx.put("ACCOUNTTABLEID", masterCompany.getAccountTable().getId().toString());
        this.otherCtx.put("continue", "no");
        this.lblInitSuccess.setVisible(false);
        this.lblInitFailed.setVisible(false);
        boolean isContinue = true;
        String message = BalanceInitWizardUI.getFacade().checkAccountIsValid(this.otherCtx);
        if (!StringUtils.isEmpty((String)message)) {
            int choice = -1;
            String msg1 = EASResource.getString((String)BOOKS_RESOURCE, (String)"AccountNotValid");
            String msg2 = EASResource.getString((String)BOOKS_RESOURCE, (String)"AccountNotDifferent");
            choice = message.startsWith(msg1) ? MsgBox.showConfirm3((Component)((Object)this), (String)msg1, (String)message.substring(msg1.length())) : (message.startsWith(msg2) ? MsgBox.showConfirm3((Component)((Object)this), (String)msg2, (String)message.substring(msg2.length())) : MsgBox.showConfirm2((Component)((Object)this), (String)message));
            if (MsgBox.isYes((int)choice)) {
                this.otherCtx.put("continue", "yes");
            } else {
                isContinue = false;
            }
        }
        if (!isContinue) {
            return;
        }
        HashMap<String, Comparable<Boolean>> param = new HashMap<String, Comparable<Boolean>>();
        param.put("isAdjust", Boolean.valueOf(true));
        param.put("isNeedBtnCancel", Boolean.valueOf(true));
        param.put("width", Integer.valueOf(700));
        param.put("height", Integer.valueOf(400));
        GLTaskMonitor.show((Object)this, new GLTaskProcessor(){

            @Override
            public Object process() {
                try {
                    this.showInfo(EASResource.getString((String)BalanceInitWizardUI.GL_RESOURCE, (String)"1021"));
                    String msg = BalanceInitWizardUI.getFacade().importBalance(BalanceInitWizardUI.this.otherCtx);
                    this.showInfo(EASResource.getString((String)BalanceInitWizardUI.GL_RESOURCE, (String)"1020"));
                    if (!StringUtils.isEmpty((String)msg)) {
                        this.showInfo(EASResource.getString((String)BalanceInitWizardUI.GL_RESOURCE, (String)"1022") + msg);
                    }
                    BalanceInitWizardUI.this.lblInitSuccess.setVisible(false);
                    BalanceInitWizardUI.this.btnOK.setVisible(false);
                    BalanceInitWizardUI.this.btnFinish.setVisible(true);
                    BalanceInitWizardUI.this.btnFinish.setEnabled(true);
                }
                catch (Exception e) {
                    BalanceInitWizardUI.this.lblInitFailed.setVisible(true);
                    this.showError(e.getMessage(), e);
                }
                return null;
            }

            @Override
            public boolean isAutoClose() {
                return false;
            }
        }, param);
    }

    private void verify(int type) throws AccountBooksException {
        if (type == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)BOOKS_RESOURCE, (String)"ChooseOneType"));
            SysUtil.abort();
        }
        if (this.chkAcctBalance.isSelected() && this.isAccountInit) {
            MsgBox.showInfo((String)EASResource.getString((String)BOOKS_RESOURCE, (String)"AccountClosed"));
            SysUtil.abort();
        }
        if (this.chkAsstBalance.isSelected() && this.closedAsstAccount != null) {
            MsgBox.showInfo((String)EASResource.getString((String)BOOKS_RESOURCE, (String)"AsstAcctClosed"));
            SysUtil.abort();
        }
        if (this.chkCussentBalance.isSelected() && !this.allowCussent) {
            MsgBox.showInfo((String)EASResource.getString((String)BOOKS_RESOURCE, (String)"CussentNotAllow"));
            SysUtil.abort();
        }
        if (this.chkCussentBalance.isSelected() && this.closedCussentAccount != null) {
            MsgBox.showInfo((String)EASResource.getString((String)BOOKS_RESOURCE, (String)"CussentClosed"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    private static IBalanceInitFacade getFacade() throws BOSException {
        return BalanceInitFacadeFactory.getRemoteInstance();
    }
}

