/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.client.AbstractRptVoucherGeneralConditionUI;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.GLEditor;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.toolkit.dbmono.DMApp;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class RptVoucherGeneralConditionUI
extends AbstractRptVoucherGeneralConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(RptVoucherGeneralConditionUI.class);
    protected boolean hasLoadInitData;
    VoucherTypeCollection voucherTypeCols = null;
    protected CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();

    public RptVoucherGeneralConditionUI() throws Exception {
        this.tbl.checkParsed();
        this.tbl.getColumn(0).setWidth(50);
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.setupDBMono();
        this.dataFrom.setSupportedEmpty(false);
        this.dataTo.setSupportedEmpty(false);
        InitClientHelp.setTableKeyBoardManager(this.tbl);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    private void setupDBMono() {
        this.includeAll.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isControlDown() && e.getClickCount() == 2) {
                    new DMApp(true);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)((Object)e));
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    protected void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptParams();
            this.pp.setObject("voucherTypes", (Object)this.initMap());
            this.pp.setInt("maxAccountLevel", this.getUIReportContext().getMaxAccountLevel());
            this.pp.setObject("allCurrency", (Object)this.getUIReportContext().getAllCurrency());
            this.pp.setObject("currentPeriod", this.getUIReportContext().getObject("currentPeriod"));
        }
    }

    protected List initMap() throws EASBizException, BOSException {
        VoucherTypeCollection col;
        this.voucherTypeCols = col = GlUtils.getVoucherTypeCollection(null, null, this.curCompany.getCU().getId().toString());
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                list.add(new LabelValueBean(col.get(i).getId().toString(), col.get(i).getName()));
            }
        }
        return list;
    }

    protected void fillDataToUI() {
        int i;
        if (this.pp == null) {
            return;
        }
        PeriodInfo pi = (PeriodInfo)this.pp.getObject("currentPeriod");
        this.dataFrom.setValue((Object)pi.getBeginDate());
        this.dataTo.setValue((Object)pi.getEndDate());
        this.tbl.removeRows();
        List list = (List)this.pp.getObject("voucherTypes");
        HashMap<String, String> idMap = new HashMap<String, String>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        if (this.voucherTypeCols == null) {
            try {
                this.voucherTypeCols = GlUtils.getVoucherTypeCollection(null, null, this.curCompany.getCU().getId().toString());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        for (i = 0; i < this.voucherTypeCols.size(); ++i) {
            VoucherTypeInfo voucherTypeInfo = this.voucherTypeCols.get(i);
            nameMap.put(voucherTypeInfo.getId().toString(), voucherTypeInfo.getName());
        }
        for (i = 0; i < list.size(); ++i) {
            LabelValueBean bean = (LabelValueBean)list.get(i);
            String id = bean.getValue();
            if (!nameMap.containsKey(id)) continue;
            bean.setLabel((String)nameMap.get(id));
            idMap.put(id, id);
            IRow row = this.tbl.addRow();
            row.getCell(0).setValue((Object)Boolean.FALSE);
            row.getCell(1).setValue((Object)bean);
            row.getCell(2).setEditor(GLEditor.getTextField());
            row.getCell(3).setEditor(GLEditor.getTextField());
        }
        boolean includeAllTypes = false;
        if (this.pp.containsKey("includeAll")) {
            includeAllTypes = (Boolean)this.pp.getObject("includeAll");
            this.includeAll.setSelected(includeAllTypes);
        }
        for (int i2 = 0; i2 < this.voucherTypeCols.size(); ++i2) {
            VoucherTypeInfo voucherTypeInfo = this.voucherTypeCols.get(i2);
            if (idMap.containsKey(voucherTypeInfo.getId().toString())) continue;
            LabelValueBean bean = new LabelValueBean(voucherTypeInfo.getId().toString(), voucherTypeInfo.getName());
            IRow row = this.tbl.addRow();
            row.getCell("selected").setValue((Object)includeAllTypes);
            row.getCell("selected").setEditor(GLEditor.getCkeckBox());
            row.getCell("voucherType").setValue((Object)bean);
            row.getCell("from").setEditor(GLEditor.getTextField());
            row.getCell("to").setEditor(GLEditor.getTextField());
        }
        if (this.pp.containsKey("dateFrom")) {
            this.dataFrom.setValue(this.pp.getObject("dateFrom"));
        }
        if (this.pp.containsKey("dateTo")) {
            this.dataTo.setValue(this.pp.getObject("dateTo"));
        }
        if (this.pp.containsKey("tblData")) {
            Object[] tblData = (Object[])this.pp.getObject("tblData");
            for (int i3 = 0; i3 < tblData.length; ++i3) {
                Object[] tblData1 = (Object[])tblData[i3];
                for (int j = 0; j < tblData1.length; ++j) {
                    this.tbl.getCell(i3, "selected").setValue(tblData1[0]);
                    this.tbl.getCell(i3, "selected").setEditor(GLEditor.getCkeckBox());
                    this.tbl.getCell(i3, "voucherType").setValue(tblData1[1]);
                    this.tbl.getCell(i3, "from").setValue(tblData1[2]);
                    this.tbl.getCell(i3, "to").setValue(tblData1[3]);
                }
            }
        }
    }

    @Override
    public RptParams getCustomCondition() {
        if (this.pp == null) {
            this.pp = new RptParams();
        }
        this.pp.setObject("dateFrom", this.dataFrom.getValue());
        this.pp.setObject("dateTo", this.dataTo.getValue());
        this.pp.setObject("includeAll", (Object)this.includeAll.isSelected());
        Object[][] tblData = new Object[this.tbl.getRowCount()][4];
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            tblData[i][0] = row.getCell("selected").getValue();
            tblData[i][1] = row.getCell("voucherType").getValue();
            tblData[i][2] = row.getCell("from").getValue();
            tblData[i][3] = row.getCell("to").getValue();
        }
        this.pp.setObject("tblData", (Object)tblData);
        return this.pp;
    }

    @Override
    protected void includeAll_actionPerformed(ActionEvent e) throws Exception {
        boolean ss = this.includeAll.isSelected();
        if (ss) {
            for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                this.tbl.getCell(i, "selected").setValue((Object)Boolean.TRUE);
                this.tbl.getCell(i, "selected").getStyleAttributes().setLocked(true);
            }
        } else {
            for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                this.tbl.getCell(i, "selected").setValue((Object)Boolean.FALSE);
                this.tbl.getCell(i, "selected").getStyleAttributes().setLocked(false);
            }
        }
    }

    @Override
    public void setCustomCondition(RptParams ac) {
        if (ac == null) {
            return;
        }
        this.pp = ac;
        this.fillDataToUI();
    }

    @Override
    public Object getParam() {
        return this.getCustomCondition();
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptParams)condition);
    }

    public boolean verify() {
        Date from = (Date)this.dataFrom.getValue();
        Date to = (Date)this.dataTo.getValue();
        if (to.before(from)) {
            MsgBox.showInfo((String)GLResUtil.getRes("input_correct_dateRange"));
            this.dataFrom.requestFocus();
            return false;
        }
        boolean hasSelected = false;
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            hasSelected = true;
            break;
        }
        if (!hasSelected) {
            MsgBox.showInfo((String)GLResUtil.getRes("select_voucher_type_please"));
            return false;
        }
        int yearEnd = DateTimeUtils.getYear((Date)this.dataTo.getSqlDate());
        int yearBegin = DateTimeUtils.getYear((Date)this.dataFrom.getSqlDate());
        try {
            int numberBegin;
            PeriodInfo period = PeriodUtils.getPeriodInfo((Date)this.dataFrom.getSqlDate(), (CompanyOrgUnitInfo)this.curCompany);
            if (period != null && RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin, numberBegin = period.getPeriodNumber(), this.curCompany)) {
                return false;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return true;
    }

    public Dimension getSize() {
        return new Dimension(320, 286);
    }

    public void clear() {
        super.clear();
        this.pp = null;
        try {
            this.loadInitData();
            this.fillDataToUI();
            this.includeAll.setSelected(false);
            if (this.tbl != null && this.tbl.getRowCount() > 0) {
                for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                    this.tbl.getCell(i, "selected").setValue((Object)Boolean.FALSE);
                    this.tbl.getCell(i, "selected").getStyleAttributes().setLocked(false);
                }
            }
        }
        catch (ReportBizException e) {
            ExceptionHandler.handle((Throwable)((Object)e));
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    public CompanyOrgUnitInfo getCurCompany() {
        return this.curCompany;
    }

    public void setCurCompany(CompanyOrgUnitInfo curCompany) {
        this.curCompany = curCompany;
    }
}

