/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.AccountRuleFactory;
import com.kingdee.eas.fi.books.VoucherMessageFactory;
import com.kingdee.eas.fi.books.client.AbstractVoucherCancelImpBookUI;
import com.kingdee.eas.fi.books.util.BooksRuleInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GLTaskProcessor;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherMessageFacadeFactory;
import com.kingdee.eas.fi.gl.client.GLTaskMonitor;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherCancelImpBookUI
extends AbstractVoucherCancelImpBookUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherCancelImpBookUI.class);
    private CompanyOrgUnitInfo transferOrg = SysContext.getSysContext().getCurrentFIUnit();
    private Object[] transferOrgArr = null;

    public VoucherCancelImpBookUI() throws Exception {
        this.btnClearAll.setEnabled(true);
        this.btnExit.setVisible(false);
        this.btnOk.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnOk.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.doSelect(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.doSelect(false);
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionOk_actionPerformed(e);
        ArrayList<BOSUuid> idList = new ArrayList<BOSUuid>();
        final HashMap idComMap = new HashMap();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            Boolean select = (Boolean)rowAss.getCell("select").getValue();
            if (!select.booleanValue()) continue;
            VoucherInfo info = new VoucherInfo();
            info = (VoucherInfo)rowAss.getUserObject();
            idList.add(info.getId());
            ArrayList<CompanyOrgUnitInfo> comList = new ArrayList<CompanyOrgUnitInfo>();
            String masterComId = info.getCompany().getId().toString();
            for (int j = 0; j < this.transferOrgArr.length; ++j) {
                CompanyOrgUnitInfo transferOrgItem = (CompanyOrgUnitInfo)this.transferOrgArr[j];
                if (!masterComId.equals(transferOrgItem.getMainOrg().getId().toString())) continue;
                transferOrgItem.getMainOrg().setName(info.getCompany().getName());
                comList.add(transferOrgItem);
            }
            idComMap.put(info, comList);
        }
        if (idList.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.books.VoucherCancelImpResource", (String)"SELONE"));
            return;
        }
        HashMap<String, Comparable<Boolean>> param = new HashMap<String, Comparable<Boolean>>();
        param.put("isAdjust", Boolean.valueOf(true));
        param.put("width", Integer.valueOf(700));
        param.put("height", Integer.valueOf(400));
        GLTaskMonitor.show((Object)this, new GLTaskProcessor(){

            @Override
            public Object process() {
                int index = 0;
                List partMaps = VoucherCancelImpBookUI.this.split(idComMap, 100);
                for (Map part : partMaps) {
                    try {
                        this.showInfo(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Import Canceling") + (index += part.size()) + "/" + idComMap.size() + "...");
                        String result = VoucherMessageFacadeFactory.getRemoteInstance().batchCancelImportVoucher(part);
                        if (StringUtils.isEmpty((String)result) || result.length() <= 0) continue;
                        this.showInfo(result);
                    }
                    catch (Exception e) {
                        this.showError(e.getMessage(), null);
                        logger.error((Object)e);
                    }
                }
                this.showInfo(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"CancelImport Success"));
                return null;
            }

            @Override
            public boolean isAutoClose() {
                return false;
            }
        }, param);
        this.loadData();
    }

    private List<Map> split(Map map, int size) {
        ArrayList<Map> list = new ArrayList<Map>();
        if (map.size() <= size) {
            list.add(map);
        } else {
            HashMap part = new HashMap();
            Set keySet = map.keySet();
            for (VoucherInfo key : keySet) {
                part.put(key, map.get(key));
                if (part.size() < size) continue;
                list.add(part);
                part = new HashMap();
            }
            if (part.size() > 0) {
                list.add(part);
            }
        }
        return list;
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
    }

    private void doSelect(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            rowAss.getCell("select").setValue((Object)select);
        }
    }

    public void onLoad() throws Exception {
        RptParams param;
        super.onLoad();
        if (this.getUIContext().get("param") != null && (param = (RptParams)this.getUIContext().get("param")).getObject("prmtCompanyArr") != null) {
            this.transferOrgArr = (Object[])param.getObject("prmtCompanyArr");
        }
        if (this.getUIContext().get("COMPANY") != null) {
            this.transferOrg = (CompanyOrgUnitInfo)this.getUIContext().get("COMPANY");
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn("period").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("voucherType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("bizStatus").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("abstract").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("bookedDate").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("sourceSys").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("sourceType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("creditAmount").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("creator").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("debitAmount").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        CurrencyInfo localCurrency = this.transferOrg.getBaseCurrency();
        ICurrency curr = CurrencyFactory.getRemoteInstance();
        if (localCurrency != null) {
            localCurrency = (CurrencyInfo)curr.getValue((IObjectPK)new ObjectUuidPK(localCurrency.getId()));
        }
        this.tblMain.getColumn("creditAmount").getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormatString());
        this.tblMain.getColumn("debitAmount").getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormatString());
        this.initData();
    }

    @Override
    protected void cbxVoucherType_actionPerformed(ActionEvent e) throws Exception {
        this.loadData();
    }

    private void initData() throws Exception {
        this.loadData();
        this.setUI();
    }

    private void setUI() throws Exception {
        RptParams param = (RptParams)this.getUIContext().get("param");
        if (param.getBoolean("radByPeriod")) {
            Integer yearFrom = (Integer)param.getObject("spnYearFrom");
            Integer periodFrom = (Integer)param.getObject("spnPeriodFrom");
            Integer yearTo = (Integer)param.getObject("spnYearTo");
            Integer periodTo = (Integer)param.getObject("spnPeriodTo");
            this.txtPeriod.setText(yearFrom.toString() + "." + periodFrom.toString() + "-" + yearTo.toString() + "." + periodTo.toString());
        } else {
            Date dateFrom = (Date)param.getObject("dateFrom");
            Date dtTo = (Date)param.getObject("dateTo");
            DateFormat df = DateFormat.getDateInstance(1, Locale.CHINA);
            this.txtPeriod.setText(GlUtils.formatDate(df, dateFrom) + "-" + GlUtils.formatDate(df, dtTo));
            this.lablePeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"Date"));
        }
        this.cbxVoucherType.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"ALL"));
        VoucherTypeCollection col = GlUtils.getVoucherTypeCollection(null, null, this.transferOrg.getCU().getId().toString());
        this.cbxVoucherType.addItems(col.toArray());
        if (param.getObject("cbxVoucherType") != null && param.getObject("cbxVoucherType") instanceof VoucherTypeInfo) {
            VoucherTypeInfo accfromInfo = (VoucherTypeInfo)param.getObject("cbxVoucherType");
            this.cbxVoucherType.setSelectedItem((Object)accfromInfo);
        }
    }

    protected int getVoucherStatusByAccountRule() {
        if (this.transferOrgArr == null || this.transferOrgArr.length == 0) {
            return 0;
        }
        StringBuffer sql = null;
        int result = 0;
        try {
            int count;
            sql = new StringBuffer();
            sql.append("select count(r.fid) as count from T_BKS_ACCOUNTRULE r inner join T_BKS_ACOUNTSCHEME s on r.FACCOUNTSCHEMEID = s.fid inner join T_ORG_COMPANY c on c.FACCOUNTSCHEMEID = s.fid ");
            sql.append("where r.FVALUE = 0 and r.FISENABLE = 1 ");
            sql.append("and c.fid in ( ");
            for (int i = 0; i < this.transferOrgArr.length; ++i) {
                sql.append("'");
                sql.append(((CompanyOrgUnitInfo)this.transferOrgArr[i]).getId().toString());
                sql.append("'");
                if (i == this.transferOrgArr.length - 1) continue;
                sql.append(",");
            }
            sql.append(")");
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            if (rs.next() && (count = rs.getInt("count")) == 0) {
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void loadData() throws Exception {
        String number;
        String bookId;
        RptParams param = (RptParams)this.getUIContext().get("param");
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = evi.getSelector();
        this.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        HashSet<String> companyIdSet = new HashSet<String>();
        StringBuffer bookIdStr = new StringBuffer();
        bookIdStr.append("(");
        if (this.transferOrgArr != null && this.transferOrgArr.length == 1) {
            CompanyOrgUnitInfo masterComany = ((CompanyOrgUnitInfo)this.transferOrgArr[0]).getMainOrg();
            bookId = BooksUtil.getCurrentBook(null, (String)((CompanyOrgUnitInfo)this.transferOrgArr[0]).getId().toString()).getId().toString();
            BooksRuleInfo ruleInfo = AccountRuleFactory.getRemoteInstance().getRuleS(bookId, masterComany);
            if (ruleInfo.getProperties().get("B001") == null) {
                throw new AccountBooksException(AccountBooksException.STARTACCOUNTRULE);
            }
        }
        if (this.transferOrgArr != null && this.transferOrgArr.length > 0) {
            for (int i = 0; i < this.transferOrgArr.length; ++i) {
                companyIdSet.add(((CompanyOrgUnitInfo)this.transferOrgArr[i]).getMainOrg().getId().toString());
                bookId = BooksUtil.getCurrentBook(null, (String)((CompanyOrgUnitInfo)this.transferOrgArr[i]).getId().toString()).getId().toString();
                bookIdStr.append("'").append(bookId).append("'");
                if (i == this.transferOrgArr.length - 1) continue;
                bookIdStr.append(",");
            }
        }
        bookIdStr.append(")");
        int voucherStatus = this.getVoucherStatusByAccountRule();
        if (companyIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(1), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(voucherStatus + 3), CompareType.GREATER_EQUALS));
        String sql = " select FSrcVoucherID from T_BKS_VoucherMessage where FisSuc = 1 and FaccountSchemeID in " + bookIdStr + "";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        if (param.getBoolean("radByPeriod")) {
            Integer yearFrom = (Integer)param.getObject("spnYearFrom");
            Integer periodFrom = (Integer)param.getObject("spnPeriodFrom");
            Integer yearTo = (Integer)param.getObject("spnYearTo");
            Integer periodTo = (Integer)param.getObject("spnPeriodTo");
            Integer from = new Integer(yearFrom * 100 + periodFrom);
            Integer to = new Integer(yearTo * 100 + periodTo);
            filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)from, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)to, CompareType.LESS_EQUALS));
        } else {
            Date dateFrom = (Date)param.getObject("dateFrom");
            Date dtTo = (Date)param.getObject("dateTo");
            filter.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)dateFrom, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)dtTo, CompareType.LESS_EQUALS));
        }
        if (this.cbxVoucherType.getSelectedItem() instanceof VoucherTypeInfo) {
            VoucherTypeInfo voucherTypeInfo = (VoucherTypeInfo)this.cbxVoucherType.getSelectedItem();
            filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)voucherTypeInfo.getId().toString()));
        }
        if (param.getObject("numFrom") != null) {
            number = (String)param.getObject("numFrom");
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.GREATER_EQUALS));
        }
        if (param.getObject("numTo") != null) {
            number = (String)param.getObject("numTo");
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.LESS_EQUALS));
        }
        evi.setFilter(filter);
        SorterItemCollection sorters = evi.getSorter();
        sorters.add(new SorterItemInfo("company.number"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("bookedDate");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorters.add(sorterItemInfo);
        sorters.add(new SorterItemInfo("voucherType.number"));
        sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorters.add(sorterItemInfo);
        VoucherCollection col = VoucherFactory.getRemoteInstance().getVoucherCollection(evi);
        this.tblMain.removeRows();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                IRow rowAss = this.tblMain.addRow();
                VoucherInfo info = col.get(i);
                rowAss.setUserObject((Object)info);
                rowAss.getCell("select").setValue((Object)Boolean.FALSE);
                rowAss.getCell("company").setValue((Object)info.getCompany().getName());
                rowAss.getCell("id").setValue((Object)info.getId().toString());
                rowAss.getCell("period").setValue((Object)(info.getPeriod().getPeriodYear() + "." + info.getPeriod().getPeriodNumber()));
                rowAss.getCell("voucherType").setValue((Object)info.getVoucherType().getName());
                rowAss.getCell("number").setValue((Object)info.getNumber());
                rowAss.getCell("abstract").setValue((Object)info.getVoucherAbstract());
                rowAss.getCell("bookedDate").setValue((Object)info.getBookedDate());
                rowAss.getCell("sourceSys").setValue((Object)info.getSourceSys().getAlias());
                rowAss.getCell("sourceType").setValue((Object)info.getSourceType().getAlias());
                rowAss.getCell("creator").setValue((Object)info.getCreator().getName());
                rowAss.getCell("bizStatus").setValue((Object)info.getBizStatus().getAlias());
                rowAss.getCell("creditAmount").setValue((Object)info.getLocalCreditAmount());
                rowAss.getCell("debitAmount").setValue((Object)info.getLocalDebitAmount());
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VoucherMessageFactory.getRemoteInstance();
    }

    protected SelectorItemCollection setSelector(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("voucherType.*"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("bookedDate"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("voucherAbstract"));
        sic.add(new SelectorItemInfo("sourceSys"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("localDebitAmount"));
        sic.add(new SelectorItemInfo("localCreditAmount"));
        return sic;
    }
}

