/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.client.AbstractVoucherCompareFilterUI;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class VoucherCompareFilterUI
extends AbstractVoucherCompareFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherCompareFilterUI.class);

    public VoucherCompareFilterUI() throws Exception {
        this.initCompanyF7();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    private void initCompanyF7() {
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        f7.setShowAssistantOrg(false);
        f7.setIsCUFilter(false);
        f7.setShowVirtual(false);
        f7.setContainSealUp(true);
        f7.setNeedAddAssistant(true);
        f7.setPermissionItem(this.getPermissionItem());
        this.prmtCompany.setSelector((KDPromptSelector)f7);
        this.prmtCompany.setHistoryRecordEnabled(false);
        this.prmtCompany.setEditable(false);
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                CompanyOrgUnitInfo oldCompany = null;
                CompanyOrgUnitInfo newCompany = null;
                if (e.getOldValue() != null && e.getOldValue() instanceof CompanyOrgUnitInfo) {
                    oldCompany = (CompanyOrgUnitInfo)e.getOldValue();
                }
                if (e.getNewValue() != null && e.getNewValue() instanceof CompanyOrgUnitInfo) {
                    newCompany = (CompanyOrgUnitInfo)e.getNewValue();
                }
                if (newCompany == null || !BooksUtil.checkSelectedCompany((Component)((Object)VoucherCompareFilterUI.this), newCompany)) {
                    return;
                }
                if (oldCompany == null || !newCompany.getId().toString().equals(oldCompany.getId().toString())) {
                    VoucherCompareFilterUI.this.curCompany = newCompany;
                    VoucherCompareFilterUI.this.initParam();
                }
            }
        });
    }

    private void initParam() {
        try {
            PeriodInfo cur = GlUtils.getCurrentPeriod(null, this.curCompany.getId().toString());
            this.dataFrom.setValue((Object)cur.getBeginDate());
            this.dataTo.setValue((Object)cur.getEndDate());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private String getPermissionItem() {
        return "books_01voucherMirror";
    }

    @Override
    protected void includeAll_actionPerformed(ActionEvent e) throws Exception {
        super.includeAll_actionPerformed(e);
    }

    @Override
    public RptParams getCustomCondition() {
        if (this.pp == null) {
            this.pp = new RptParams();
        }
        this.pp.setObject("company", this.prmtCompany.getValue());
        return super.getCustomCondition();
    }

    @Override
    public void setCustomCondition(RptParams ac) {
        super.setCustomCondition(ac);
        this.prmtCompany.setValue(this.pp.getObject("company"));
    }

    @Override
    public void clear() {
        this.prmtCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        super.clear();
    }

    @Override
    public boolean verify() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CWGXResource", (String)"companyIsNull"));
            return false;
        }
        return super.verify();
    }
}

