/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.books.IVoucherCompareFacade;
import com.kingdee.eas.fi.books.VoucherCompareFacadeFactory;
import com.kingdee.eas.fi.books.client.AbstractVoucherCompareUI;
import com.kingdee.eas.fi.books.client.VoucherCompareFilterUI;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.IRptBase;
import com.kingdee.eas.fi.gl.client.RptBaseConditionUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherCompareUI
extends AbstractVoucherCompareUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherCompareUI.class);
    protected VoucherCompareFilterUI queryPanel = new VoucherCompareFilterUI();
    private CompanyOrgUnitInfo transferOrg = SysContext.getSysContext().getCurrentFIUnit();
    private CompanyOrgUnitInfo masterCompany;

    public VoucherCompareUI() throws Exception {
        BooksUtil.checkBiz((CompanyOrgUnitInfo)this.transferOrg);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn("masterQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("masterDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("masterCredit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("curQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("curDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("curCredit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("qty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("debit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("credit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        int masterCurrencyPrecision = 2;
        int transferCurrencyPrecision = 2;
        this.masterCompany = BooksUtil.getCurrentMasterCompany(null, (CompanyOrgUnitInfo)this.transferOrg);
        if (this.masterCompany.getBaseCurrency() != null) {
            masterCurrencyPrecision = this.masterCompany.getBaseCurrency().getPrecision();
        }
        if (this.transferOrg.getBaseCurrency() != null) {
            CurrencyInfo baseCur = this.transferOrg.getBaseCurrency();
            baseCur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCur.getId()));
            transferCurrencyPrecision = baseCur.getPrecision();
        }
        this.tblMain.getColumn("masterDebit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)masterCurrencyPrecision, (boolean)true));
        this.tblMain.getColumn("masterCredit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)masterCurrencyPrecision, (boolean)true));
        this.tblMain.getColumn("curDebit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)masterCurrencyPrecision, (boolean)true));
        this.tblMain.getColumn("curCredit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)masterCurrencyPrecision, (boolean)true));
        this.tblMain.getColumn("debit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)transferCurrencyPrecision, (boolean)true));
        this.tblMain.getColumn("credit").getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)transferCurrencyPrecision, (boolean)true));
        this.kDLabelContainer3.setVisible(false);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    VoucherCompareUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    VoucherCompareUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
        this.initMyIcon();
    }

    private void initData() throws Exception {
        BooksUtil.checkBook(null);
    }

    private void initMyIcon() throws EASBizException, BOSException {
        this.btnCompare.setIcon(EASResource.getIcon((String)"imgTbtn_targetreport"));
        this.actionRefresh.setEnabled(true);
        this.actionQuery.setEnabled(true);
        this.menuItemToolBarCustom.setVisible(false);
        this.menuItemToolBarCustom.setEnabled(false);
        this.actionToolBarCustom.setEnabled(false);
    }

    @Override
    public void actionCompare_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String voucherType = (String)this.tblMain.getRow(rowIndex).getCell("voucherType").getUserObject();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"dateFrom", this.pp.getObject("dateFrom"));
        uiContext.put((Object)"dateTo", this.pp.getObject("dateTo"));
        uiContext.put((Object)"voucherType", (Object)voucherType);
        uiContext.put((Object)"COMPANY", (Object)this.transferOrg);
        StringBuffer str = new StringBuffer();
        str.append(this.pp.getObject("dateFrom"));
        str.append(this.pp.getObject("dateTo"));
        str.append(voucherType);
        str.append(rowIndex);
        uiContext.put((Object)"UIClassParam", (Object)str.toString());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.books.client.VoucherDetailMessageListUI", (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected KDTable getPrintTable() {
        return this.tblMain;
    }

    @Override
    protected Variant getPrintVariant(String varName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Object condition) {
        this.tblMain.removeRows();
        if (condition == null) {
            condition = this.queryPanel.getCustomCondition();
        }
        this.transferOrg = this.queryPanel.getCurCompany();
        this.pp = (RptParams)condition;
        this.dataFrom.setValue(this.pp.getObject("dateFrom"));
        this.dataTo.setValue(this.pp.getObject("dateTo"));
        try {
            this.setCursorOfWair();
            List result = ((IVoucherCompareFacade)this.getInitRemoteInstance()).queryVoucher(this.pp, this.transferOrg);
            Map companre = null;
            int count = result.size();
            for (int i = 0; i < count; ++i) {
                BigDecimal curDebit;
                companre = (Map)result.get(i);
                IRow row = this.tblMain.addRow();
                String id = (String)companre.get("vouchertypeid");
                row.getCell("voucherType").setUserObject((Object)id);
                String number = (String)companre.get("voucherType");
                row.getCell("voucherType").setValue((Object)number);
                Integer mastQty = (Integer)companre.get("masterQty");
                row.getCell("masterQty").setValue((Object)mastQty);
                BigDecimal masterDebit = (BigDecimal)companre.get("masterDebit");
                row.getCell("masterDebit").setValue((Object)masterDebit);
                BigDecimal masterCredit = (BigDecimal)companre.get("masterCredit");
                row.getCell("masterCredit").setValue((Object)masterCredit);
                Integer curQty = (Integer)companre.get("curQty");
                if (curQty != null) {
                    row.getCell("curQty").setValue((Object)curQty);
                    row.getCell("qty").setValue((Object)new Integer(mastQty - curQty));
                }
                if ((curDebit = (BigDecimal)companre.get("curDebit")) != null) {
                    row.getCell("curDebit").setValue((Object)curDebit);
                    row.getCell("debit").setValue((Object)masterDebit.subtract(curDebit));
                }
                BigDecimal curCredit = (BigDecimal)companre.get("curCredit");
                if (curDebit == null) continue;
                row.getCell("curCredit").setValue((Object)curCredit);
                row.getCell("credit").setValue((Object)masterCredit.subtract(curCredit));
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
            ExceptionHandler.handle((Throwable)ex);
        }
        catch (EASBizException ex) {
            logger.error((Object)"", (Throwable)ex);
            this.handleException((Exception)((Object)ex));
            this.close();
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    @Override
    public RptBaseConditionUI getQueryDialogUserPanel() {
        return this.queryPanel;
    }

    @Override
    public IRptBase getInitRemoteInstance() throws BOSException {
        return VoucherCompareFacadeFactory.getRemoteInstance();
    }

    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.query(this.pp);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get();
            if (sb != null) {
                int rowIndex = sb.getTop();
                IRow row = this.tblMain.getRow(rowIndex);
                int qty = (Integer)row.getCell("qty").getValue();
                int debit = ((BigDecimal)row.getCell("debit").getValue()).intValue();
                int credit = ((BigDecimal)row.getCell("credit").getValue()).intValue();
                if (qty != 0 || debit != 0 || credit != 0) {
                    this.actionCompare.setEnabled(true);
                } else {
                    this.actionCompare.setEnabled(false);
                }
            }
        } else if (e.getType() == 1 && e.getClickCount() == 2 && this.actionCompare.isEnabled()) {
            this.actionCompare_actionPerformed(null);
        }
    }

    @Override
    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }
}

