/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.AccountRuleFactory;
import com.kingdee.eas.fi.books.VoucherMessageFactory;
import com.kingdee.eas.fi.books.client.AbstractVoucherImpBookUI;
import com.kingdee.eas.fi.books.util.BooksRuleInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GLTaskProcessor;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherMessageFacadeFactory;
import com.kingdee.eas.fi.gl.client.GLTaskMonitor;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherImpBookUI
extends AbstractVoucherImpBookUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherImpBookUI.class);
    private CompanyOrgUnitInfo transferOrg = SysContext.getSysContext().getCurrentFIUnit();
    private Object[] transferOrgArr = null;

    public VoucherImpBookUI() throws Exception {
        this.btnClearAll.setEnabled(true);
        this.btnExit.setVisible(false);
        this.btnOk.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnOk.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(false);
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        final HashMap idComMap = new HashMap();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            String id = (String)rowAss.getCell("id").getValue();
            Boolean select = (Boolean)rowAss.getCell("select").getValue();
            if (!select.booleanValue()) continue;
            idList.add(id);
            ArrayList<CompanyOrgUnitInfo> comList = new ArrayList<CompanyOrgUnitInfo>();
            VoucherInfo info = (VoucherInfo)rowAss.getUserObject();
            String masterComId = info.getCompany().getId().toString();
            for (int j = 0; j < this.transferOrgArr.length; ++j) {
                CompanyOrgUnitInfo transferOrgItem = (CompanyOrgUnitInfo)this.transferOrgArr[j];
                if (!masterComId.equals(transferOrgItem.getMainOrg().getId().toString())) continue;
                transferOrgItem.getMainOrg().setName(info.getCompany().getName());
                comList.add(transferOrgItem);
            }
            idComMap.put(id, comList);
        }
        if (idList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"SelectOne"));
            return;
        }
        CurrencyInfo baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.transferOrg.getBaseCurrency().getId()));
        CurrencyInfo rptCurrency = null;
        if (this.transferOrg.getReportCurrency() != null) {
            rptCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.transferOrg.getReportCurrency().getId()));
        }
        this.transferOrg.setBaseCurrency(baseCurrency);
        this.transferOrg.setReportCurrency(rptCurrency);
        HashMap<String, Comparable<Boolean>> param = new HashMap<String, Comparable<Boolean>>();
        param.put("isAdjust", Boolean.valueOf(true));
        param.put("width", Integer.valueOf(700));
        param.put("height", Integer.valueOf(400));
        GLTaskMonitor.show((Object)this, new GLTaskProcessor(){

            @Override
            public Object process() {
                int index = 0;
                List partMaps = VoucherImpBookUI.this.split(idComMap, 100);
                for (Map part : partMaps) {
                    try {
                        this.showInfo(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Importing") + (index += part.size()) + "/" + idComMap.size() + "...");
                        VoucherMessageFacadeFactory.getRemoteInstance().transferVoucher(part);
                    }
                    catch (Exception e) {
                        String result = e.getMessage();
                        if (StringUtils.isEmpty((String)result)) continue;
                        this.showInfo(result);
                        logger.error((Object)e);
                    }
                }
                this.showInfo(EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"ImpFinished"));
                return null;
            }

            @Override
            public boolean isAutoClose() {
                return false;
            }
        }, param);
        this.loadData();
    }

    private List<Map> split(Map map, int size) {
        ArrayList<Map> list = new ArrayList<Map>();
        if (map.size() <= size) {
            list.add(map);
        } else {
            HashMap part = new HashMap();
            Set keySet = map.keySet();
            for (String key : keySet) {
                part.put(key, map.get(key));
                if (part.size() < size) continue;
                list.add(part);
                part = new HashMap();
            }
            if (part.size() > 0) {
                list.add(part);
            }
        }
        return list;
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
    }

    private void doSelect(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            rowAss.getCell("select").setValue((Object)select);
        }
    }

    private void initData() throws Exception {
        this.loadData();
        this.setUI();
    }

    private void setUI() throws Exception {
        RptParams param = (RptParams)this.getUIContext().get("param");
        if (param.getBoolean("radByPeriod")) {
            Integer yearFrom = (Integer)param.getObject("spnYearFrom");
            Integer periodFrom = (Integer)param.getObject("spnPeriodFrom");
            Integer yearTo = (Integer)param.getObject("spnYearTo");
            Integer periodTo = (Integer)param.getObject("spnPeriodTo");
            this.txtPeriod.setText(yearFrom.toString() + "." + periodFrom.toString() + "-" + yearTo.toString() + "." + periodTo.toString());
        } else {
            Date dateFrom = (Date)param.getObject("dateFrom");
            Date dtTo = (Date)param.getObject("dateTo");
            DateFormat df = DateFormat.getDateInstance(1, Locale.CHINA);
            this.txtPeriod.setText(GlUtils.formatDate(df, dateFrom) + "-" + GlUtils.formatDate(df, dtTo));
            this.lablePeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"Date"));
        }
        if (param.getObject("cbxVoucherType") != null) {
            if (param.getObject("cbxVoucherType") instanceof VoucherTypeInfo) {
                VoucherTypeInfo accfromInfo = (VoucherTypeInfo)param.getObject("cbxVoucherType");
                this.txtType.setText(accfromInfo.getName());
            } else {
                this.txtType.setText((String)param.getObject("cbxVoucherType"));
            }
        }
    }

    protected int getVoucherStatusByAccountRule() {
        if (this.transferOrgArr == null || this.transferOrgArr.length == 0) {
            return 0;
        }
        StringBuffer sql = null;
        int result = 0;
        try {
            int count;
            sql = new StringBuffer();
            sql.append("select count(r.fid) as count from T_BKS_ACCOUNTRULE r inner join T_BKS_ACOUNTSCHEME s on r.FACCOUNTSCHEMEID = s.fid inner join T_ORG_COMPANY c on c.FACCOUNTSCHEMEID = s.fid ");
            sql.append("where r.FVALUE = 0 and r.FISENABLE = 1 ");
            sql.append("and c.fid in ( ");
            for (int i = 0; i < this.transferOrgArr.length; ++i) {
                sql.append("'");
                sql.append(((CompanyOrgUnitInfo)this.transferOrgArr[i]).getId().toString());
                sql.append("'");
                if (i == this.transferOrgArr.length - 1) continue;
                sql.append(",");
            }
            sql.append(")");
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            if (rs.next() && (count = rs.getInt("count")) == 0) {
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void loadData() throws Exception {
        String number;
        RptParams param = (RptParams)this.getUIContext().get("param");
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = evi.getSelector();
        this.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        HashSet<String> companyIdSet = new HashSet<String>();
        ArrayList<String> bookIdList = new ArrayList<String>();
        StringBuffer bookIdStr = new StringBuffer();
        bookIdStr.append("(");
        if (this.transferOrgArr != null && this.transferOrgArr.length == 1) {
            CompanyOrgUnitInfo masterComany = ((CompanyOrgUnitInfo)this.transferOrgArr[0]).getMainOrg();
            String bookId = BooksUtil.getCurrentBook(null, (String)((CompanyOrgUnitInfo)this.transferOrgArr[0]).getId().toString()).getId().toString();
            BooksRuleInfo ruleInfo = AccountRuleFactory.getRemoteInstance().getRuleS(bookId, masterComany);
            if (ruleInfo.getProperties().get("B001") == null) {
                throw new AccountBooksException(AccountBooksException.STARTACCOUNTRULE);
            }
        }
        if (this.transferOrgArr != null && this.transferOrgArr.length > 0) {
            for (int i = 0; i < this.transferOrgArr.length; ++i) {
                CompanyOrgUnitInfo masterComany = ((CompanyOrgUnitInfo)this.transferOrgArr[i]).getMainOrg();
                String bookId = BooksUtil.getCurrentBook(null, (String)((CompanyOrgUnitInfo)this.transferOrgArr[i]).getId().toString()).getId().toString();
                BooksRuleInfo ruleInfo = AccountRuleFactory.getRemoteInstance().getRuleS(bookId, masterComany);
                if (ruleInfo.getProperties().get("B001") == null) continue;
                companyIdSet.add(((CompanyOrgUnitInfo)this.transferOrgArr[i]).getMainOrg().getId().toString());
                bookIdList.add(bookId);
            }
        }
        if (bookIdList.size() != 0) {
            for (int i = 0; i < bookIdList.size(); ++i) {
                bookIdStr.append("'").append((String)bookIdList.get(i)).append("'");
                if (i == bookIdList.size() - 1) continue;
                bookIdStr.append(",");
            }
        }
        bookIdStr.append(")");
        int voucherStatus = this.getVoucherStatusByAccountRule();
        if (companyIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(1), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(voucherStatus + 3), CompareType.GREATER_EQUALS));
        String sql = " select FSrcVoucherID from T_BKS_VoucherMessage where FisSuc = 1 and FaccountSchemeID in " + bookIdStr + "";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.NOTINNER));
        if (param.getBoolean("radByPeriod")) {
            Integer yearFrom = (Integer)param.getObject("spnYearFrom");
            Integer periodFrom = (Integer)param.getObject("spnPeriodFrom");
            Integer yearTo = (Integer)param.getObject("spnYearTo");
            Integer periodTo = (Integer)param.getObject("spnPeriodTo");
            Integer from = new Integer(yearFrom * 100 + periodFrom);
            Integer to = new Integer(yearTo * 100 + periodTo);
            filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)from, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)to, CompareType.LESS_EQUALS));
        } else {
            Date dateFrom = (Date)param.getObject("dateFrom");
            Date dtTo = (Date)param.getObject("dateTo");
            filter.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)dateFrom, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)dtTo, CompareType.LESS_EQUALS));
        }
        if (param.getObject("cbxVoucherType") != null && param.getObject("cbxVoucherType") instanceof VoucherTypeInfo) {
            VoucherTypeInfo accfromInfo = (VoucherTypeInfo)param.getObject("cbxVoucherType");
            filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)accfromInfo.getId().toString()));
        }
        if (param.getObject("numFrom") != null) {
            number = (String)param.getObject("numFrom");
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.GREATER_EQUALS));
        }
        if (param.getObject("numTo") != null) {
            number = (String)param.getObject("numTo");
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.LESS_EQUALS));
        }
        evi.setFilter(filter);
        SorterItemCollection sorters = evi.getSorter();
        sorters.add(new SorterItemInfo("company.number"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("bookedDate");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorters.add(sorterItemInfo);
        sorters.add(new SorterItemInfo("voucherType.number"));
        sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorters.add(sorterItemInfo);
        VoucherCollection col = VoucherFactory.getRemoteInstance().getVoucherCollection(evi);
        this.tblMain.removeRows();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                IRow rowAss = this.tblMain.addRow();
                VoucherInfo info = col.get(i);
                rowAss.setUserObject((Object)info);
                rowAss.getCell("select").setValue((Object)Boolean.FALSE);
                rowAss.getCell("company").setValue((Object)info.getCompany().getName());
                rowAss.getCell("id").setValue((Object)info.getId().toString());
                rowAss.getCell("period").setValue((Object)(info.getPeriod().getPeriodYear() + "." + info.getPeriod().getPeriodNumber()));
                rowAss.getCell("voucherType").setValue((Object)info.getVoucherType().getName());
                rowAss.getCell("number").setValue((Object)info.getNumber());
                rowAss.getCell("abstract").setValue((Object)info.getVoucherAbstract());
                rowAss.getCell("bookedDate").setValue((Object)info.getBookedDate());
                rowAss.getCell("sourceSys").setValue((Object)info.getSourceSys().getAlias());
                rowAss.getCell("sourceType").setValue((Object)info.getSourceType().getAlias());
                rowAss.getCell("creator").setValue((Object)info.getCreator().getName());
                rowAss.getCell("bizStatus").setValue((Object)info.getBizStatus().getAlias());
                rowAss.getCell("creditAmount").setValue((Object)info.getLocalCreditAmount());
                rowAss.getCell("debitAmount").setValue((Object)info.getLocalDebitAmount());
            }
        }
    }

    public void onLoad() throws Exception {
        RptParams param;
        super.onLoad();
        if (this.getUIContext().get("param") != null && (param = (RptParams)this.getUIContext().get("param")).getObject("prmtCompanyArr") != null) {
            this.transferOrgArr = (Object[])param.getObject("prmtCompanyArr");
        }
        if (this.getUIContext().get("COMPANY") != null) {
            this.transferOrg = (CompanyOrgUnitInfo)this.getUIContext().get("COMPANY");
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn("period").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("voucherType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("bizStatus").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("abstract").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("bookedDate").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("sourceSys").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("sourceType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("creditAmount").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("creator").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("debitAmount").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        CurrencyInfo localCurrency = this.transferOrg.getBaseCurrency();
        CurrencyInfo reportCurrency = this.transferOrg.getReportCurrency();
        ICurrency curr = CurrencyFactory.getRemoteInstance();
        if (localCurrency != null) {
            localCurrency = (CurrencyInfo)curr.getValue((IObjectPK)new ObjectUuidPK(localCurrency.getId()));
            this.transferOrg.setBaseCurrency(localCurrency);
        }
        if (reportCurrency != null) {
            reportCurrency = (CurrencyInfo)curr.getValue((IObjectPK)new ObjectUuidPK(reportCurrency.getId()));
            this.transferOrg.setReportCurrency(reportCurrency);
        }
        this.tblMain.getColumn("creditAmount").getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormatString());
        this.tblMain.getColumn("debitAmount").getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormatString());
        this.initData();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VoucherMessageFactory.getRemoteInstance();
    }

    protected SelectorItemCollection setSelector(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("bookedDate"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("voucherAbstract"));
        sic.add(new SelectorItemInfo("sourceSys"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("localDebitAmount"));
        sic.add(new SelectorItemInfo("localCreditAmount"));
        return sic;
    }
}

