/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.client.AbstractVoucherMessageFilterUI;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class VoucherMessageFilterUI
extends AbstractVoucherMessageFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherMessageFilterUI.class);
    private PeriodInfo startPeriod = null;
    private CompanyOrgUnitInfo transferOrg = null;
    private CompanyOrgUnitInfo[] transferOrgArr = null;

    public VoucherMessageFilterUI(CompanyOrgUnitInfo transferOrg) throws Exception {
        if (transferOrg == null) {
            transferOrg = SysContext.getSysContext().getCurrentFIUnit();
        } else {
            this.transferOrg = transferOrg;
            this.transferOrgArr = new CompanyOrgUnitInfo[]{transferOrg};
        }
        this.initCompanyF7();
        this.initParam();
        this.jbInit();
    }

    private void initCompanyF7() {
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        f7.setShowAssistantOrg(false);
        f7.setIsCUFilter(false);
        f7.setShowVirtual(false);
        f7.setContainSealUp(true);
        f7.setNeedAddAssistant(true);
        f7.setPermissionItem(this.getPermissionItem());
        f7.setMultiSelect(true);
        this.prmtCompany.setSelector((KDPromptSelector)f7);
        this.prmtCompany.setHistoryRecordEnabled(false);
        this.prmtCompany.setEditable(false);
        this.prmtCompany.setDisplayFormat("$name");
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object[] newCompanyArr = null;
                Object[] oldCompanyArr = null;
                if (e.getNewValue() != null && e.getNewValue() instanceof Object[]) {
                    newCompanyArr = (Object[])e.getNewValue();
                }
                if (e.getOldValue() != null && e.getOldValue() instanceof Object[]) {
                    oldCompanyArr = (Object[])e.getOldValue();
                }
                if (newCompanyArr == null) {
                    return;
                }
                VoucherMessageFilterUI.access$002(VoucherMessageFilterUI.this, new CompanyOrgUnitInfo[newCompanyArr.length]);
                for (int i = 0; i < newCompanyArr.length; ++i) {
                    ((VoucherMessageFilterUI)VoucherMessageFilterUI.this).transferOrgArr[i] = (CompanyOrgUnitInfo)newCompanyArr[i];
                }
                if (!Arrays.equals(oldCompanyArr, newCompanyArr)) {
                    VoucherMessageFilterUI.this.initParam();
                }
            }
        });
    }

    private String getPermissionItem() {
        return "books_01voucherCheck";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void jbInit() throws Exception {
        this.dateFrom.setSupportedEmpty(false);
        this.dateTo.setSupportedEmpty(false);
        this.spnPeriodFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Integer.valueOf(VoucherMessageFilterUI.this.spnPeriodFrom.getValue().toString()) <= 0) {
                    VoucherMessageFilterUI.this.spnPeriodFrom.setValue((Object)1);
                }
            }
        });
        this.spnPeriodTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Integer.valueOf(VoucherMessageFilterUI.this.spnPeriodTo.getValue().toString()) <= 0) {
                    VoucherMessageFilterUI.this.spnPeriodTo.setValue((Object)1);
                }
            }
        });
        this.dateFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    VoucherMessageFilterUI.this.dateDateBegin_dataChanged(e);
                }
                catch (Exception exc) {
                    VoucherMessageFilterUI.this.handUIException(exc);
                }
            }
        });
        this.dateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    VoucherMessageFilterUI.this.dateDateEnd_dataChanged(e);
                }
                catch (Exception exc) {
                    VoucherMessageFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initParam() {
        try {
            this.startPeriod = GlUtils.getStartPeriod(null, this.transferOrg.getId().toString());
            VoucherTypeCollection col = GlUtils.getVoucherTypeCollection(null, null, this.transferOrg.getCU().getId().toString());
            this.cbxVoucherType.removeAllItems();
            this.cbxVoucherType.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"ALL"));
            this.cbxVoucherType.addItems(col.toArray());
            PeriodInfo cur = GlUtils.getCurrentPeriod(null, this.transferOrg.getId().toString());
            this.dateFrom.setValue((Object)cur.getBeginDate());
            this.dateTo.setValue((Object)cur.getEndDate());
            Map companyMap = CommRptBaseFactory.getRemoteInstance().getPeriodRange(this.transferOrg);
            Map periodMap = this.getPeriodByCurTransferArr();
            if (periodMap != null) {
                Map queryPeriod = (Map)companyMap.get("queryPeriod");
                queryPeriod.putAll(periodMap);
                companyMap.remove("usedPeriod");
                companyMap.put("usedPeriod", periodMap.get("usedPeriod"));
                queryPeriod.remove("usedPeriod");
            }
            PeriodEntity pe = new PeriodEntity(companyMap);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false, (boolean)false);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected Map getPeriodByCurTransferArr() {
        if (this.transferOrgArr == null || this.transferOrgArr.length == 0) {
            return null;
        }
        StringBuffer sql = null;
        HashMap<Object, Object> result = null;
        try {
            result = new HashMap<Object, Object>();
            sql = new StringBuffer();
            sql.append("select fperiodyear as year, min(fperiodnumber) as min, max(fperiodnumber) as max from t_bd_period p inner join T_BD_PERIODTYPE t on p.FTYPEID = t.fid inner join T_ORG_COMPANY c on c.FACCOUNTPERIODID = t.fid ");
            sql.append(" where c.fid in ( ");
            for (int i = 0; i < this.transferOrgArr.length; ++i) {
                sql.append("'");
                sql.append(this.transferOrgArr[i].getId().toString());
                sql.append("'");
                if (i == this.transferOrgArr.length - 1) continue;
                sql.append(",");
            }
            sql.append(" ) group by fperiodyear");
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            int minyear = 10000;
            int minperiod = 1;
            int maxperiod = 12;
            while (rs.next()) {
                int year = rs.getInt("year");
                int min = rs.getInt("min");
                int max = rs.getInt("max");
                if (minyear > year) {
                    minyear = year;
                    minperiod = min;
                    maxperiod = max;
                }
                result.put(rs.getInt("year"), new int[]{rs.getInt("min"), rs.getInt("max")});
            }
            HashMap<Integer, int[]> usedPeriod = new HashMap<Integer, int[]>();
            usedPeriod.put(minyear, new int[]{minperiod, maxperiod});
            result.put("usedPeriod", usedPeriod);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean verify() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CWGXResource", (String)"companyIsNull"));
            return false;
        }
        return true;
    }

    @Override
    protected void radByPeriod_stateChanged(ChangeEvent e) throws Exception {
        if (this.radByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(true);
            this.pnlByDate.setVisible(false);
        } else {
            this.pnlByPeriod.setVisible(false);
            this.pnlByDate.setVisible(true);
        }
    }

    @Override
    protected void radByDate_stateChanged(ChangeEvent e) throws Exception {
        this.radByPeriod_stateChanged(e);
    }

    protected List initMap() throws EASBizException, BOSException {
        VoucherTypeCollection col = GlUtils.getVoucherTypeCollection(null, null, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                list.add(new LabelValueBean(col.get(i).getId().toString(), col.get(i).getName()));
            }
        }
        return list;
    }

    protected RptParams getParam() {
        String number;
        RptParams param = new RptParams();
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            param.setObject("prmtCompany", this.prmtCompany.getValue());
        }
        if (param.getObject("prmtCompany") == null) {
            param.setObject("prmtCompany", (Object)this.transferOrg);
        }
        if (this.prmtCompany.getValue() instanceof Object[]) {
            param.setObject("prmtCompanyArr", this.prmtCompany.getValue());
        }
        if (param.getObject("prmtCompanyArr") == null) {
            param.setObject("prmtCompanyArr", (Object)this.transferOrgArr);
        }
        if (this.radByPeriod.isSelected()) {
            param.setBoolean("radByPeriod", true);
            param.setObject("spnYearFrom", this.spnYearFrom.getValue());
            param.setObject("spnYearTo", this.spnYearTo.getValue());
            param.setObject("spnPeriodFrom", this.spnPeriodFrom.getValue());
            param.setObject("spnPeriodTo", this.spnPeriodTo.getValue());
        } else {
            param.setBoolean("radByPeriod", false);
            param.setObject("dateFrom", this.dateFrom.getValue());
            param.setObject("dateTo", this.dateTo.getValue());
        }
        if (this.cbxVoucherType.getSelectedItem() instanceof VoucherTypeInfo) {
            VoucherTypeInfo accfromInfo = (VoucherTypeInfo)this.cbxVoucherType.getSelectedItem();
            if (accfromInfo != null) {
                param.setObject("cbxVoucherType", (Object)accfromInfo);
            }
        } else {
            param.setObject("cbxVoucherType", (Object)EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"ALL"));
        }
        if (this.numFrom.getText() != null && this.numFrom.getText().trim().length() > 0) {
            number = this.numFrom.getText();
            param.setObject("numFrom", (Object)number);
        }
        if (this.numTo.getText() != null && this.numTo.getText().trim().length() > 0) {
            number = this.numTo.getText();
            param.setObject("numTo", (Object)number);
        }
        if (this.radYes.isSelected()) {
            param.setBoolean("radYes", true);
        } else if (this.radNo.isSelected()) {
            param.setBoolean("radNo", true);
        } else {
            param.setBoolean("radAllSuc", true);
        }
        return param;
    }

    public FilterInfo getFilterInfo() {
        return this.getPanelFilterInfo();
    }

    public FilterInfo getPanelFilterInfo() {
        String number;
        VoucherTypeInfo accfromInfo;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        HashSet<String> companyIdSet = new HashSet<String>();
        if (this.transferOrgArr.length == 1) {
            fic.add(new FilterItemInfo("company.id", (Object)this.transferOrgArr[0].getId().toString()));
        } else {
            for (int i = 0; i < this.transferOrgArr.length; ++i) {
                companyIdSet.add(this.transferOrgArr[i].getId().toString());
            }
            fic.add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        }
        StringBuffer maskString = new StringBuffer("#0 and #1 AND (");
        int index = 2;
        if (!this.radByPeriod.isSelected()) {
            java.util.Date dtFrom = (java.util.Date)this.dateFrom.getValue();
            java.util.Date dtTo = (java.util.Date)this.dateTo.getValue();
            if (dtFrom == null && dtTo == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"InputDate"));
                SysUtil.abort();
            }
            fic.add(new FilterItemInfo("srcVoucher.bookedDate", (Object)DateTimeUtils.format((java.util.Date)dtFrom), CompareType.GREATER_EQUALS));
            fic.add(new FilterItemInfo("srcVoucher.bookedDate", (Object)DateTimeUtils.format((java.util.Date)dtTo), CompareType.LESS_EQUALS));
            maskString.append("#" + index++ + " AND ");
            maskString.append("#" + index++ + ")");
        } else {
            Integer yearFrom = (Integer)this.spnYearFrom.getValue();
            Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
            Integer yearTo = (Integer)this.spnYearTo.getValue();
            Integer periodTo = (Integer)this.spnPeriodTo.getValue();
            Integer from = new Integer(yearFrom * 100 + periodFrom);
            Integer to = new Integer(yearTo * 100 + periodTo);
            fic.add(new FilterItemInfo("period.number", (Object)from, CompareType.GREATER_EQUALS));
            fic.add(new FilterItemInfo("period.number", (Object)to, CompareType.LESS_EQUALS));
            maskString.append("#" + index++ + " AND ");
            maskString.append("#" + index++ + ")");
        }
        if (this.cbxVoucherType.getSelectedItem() instanceof VoucherTypeInfo && (accfromInfo = (VoucherTypeInfo)this.cbxVoucherType.getSelectedItem()) != null) {
            String accFrom = accfromInfo.getNumber().trim();
            fic.add(new FilterItemInfo("voucherType.number", (Object)accFrom));
            maskString.append(" AND #" + index++);
        }
        if (this.radYes.isSelected()) {
            fic.add(new FilterItemInfo("isSuc", (Object)new Integer(1)));
            maskString.append(" AND #" + index++);
        } else if (this.radNo.isSelected()) {
            fic.add(new FilterItemInfo("isSuc", (Object)new Integer(0)));
            maskString.append(" AND #" + index++);
        }
        if (this.numFrom.getText() != null && this.numFrom.getText().trim().length() > 0) {
            number = this.numFrom.getText();
            fic.add(new FilterItemInfo("srcVoucher.number", (Object)number, CompareType.GREATER_EQUALS));
        }
        if (this.numTo.getText() != null && this.numTo.getText().trim().length() > 0) {
            number = this.numTo.getText();
            fic.add(new FilterItemInfo("srcVoucher.number", (Object)number, CompareType.LESS_EQUALS));
        }
        return filter;
    }

    public void clear() {
        super.clear();
        try {
            this.initParam();
            this.jbInit();
            this.prmtCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
            this.numTo.setText("");
            this.numFrom.setText("");
            if (this.cbxVoucherType.getSelectedIndex() != -1) {
                this.cbxVoucherType.setSelectedIndex(0);
            }
            this.radByPeriod.setSelected(true);
            this.radAllSuc.setSelected(true);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    public void setParam(Object condition) {
        if (condition != null) {
            this.setCustomerParams(RptParams.parseFrom((Map)((Map)condition)));
        }
    }

    private void setCustomerParams(RptParams condition) {
        if (condition.getObject("prmtCompany") instanceof CompanyOrgUnitInfo) {
            this.prmtCompany.setValue(condition.getObject("prmtCompany"));
        }
        if (condition.getObject("prmtCompanyArr") instanceof Object[]) {
            this.prmtCompany.setValue(condition.getObject("prmtCompanyArr"));
        }
        this.radByPeriod.setSelected(condition.getBoolean("radByPeriod"));
        this.radByDate.setSelected(!condition.getBoolean("radByPeriod"));
        if (this.radByPeriod.isSelected()) {
            this.spnYearFrom.setValue(condition.getObject("spnYearFrom"));
            this.spnYearTo.setValue(condition.getObject("spnYearTo"));
            this.spnPeriodFrom.setValue(condition.getObject("spnPeriodFrom"));
            this.spnPeriodTo.setValue(condition.getObject("spnPeriodTo"));
        } else {
            this.dateFrom.setValue(condition.getObject("dateFrom"));
            this.dateTo.setValue(condition.getObject("dateTo"));
        }
        if (condition.getObject("cbxVoucherType") instanceof VoucherTypeInfo) {
            this.cbxVoucherType.setSelectedItem(condition.getObject("cbxVoucherType"));
        } else {
            this.cbxVoucherType.setSelectedIndex(0);
        }
        if (condition.getObject("numFrom") != null) {
            this.numFrom.setText((String)condition.getObject("numFrom"));
        } else {
            this.numFrom.setText("");
        }
        if (condition.getObject("numTo") != null) {
            this.numTo.setText((String)condition.getObject("numTo"));
        } else {
            this.numTo.setText("");
        }
        this.radYes.setSelected(condition.getBoolean("radYes"));
        this.radNo.setSelected(condition.getBoolean("radNo"));
        this.radAllSuc.setSelected(condition.getBoolean("radAllSuc"));
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam().toMap()));
        return cp;
    }

    protected void dateDateBegin_dataChanged(DataChangeEvent e) throws Exception {
        Date dateEnd;
        Date dateBegin = this.dateFrom.getSqlDate();
        if (dateBegin.after(dateEnd = this.dateTo.getSqlDate())) {
            this.dateTo.setValue((Object)dateBegin);
        }
    }

    protected void dateDateEnd_dataChanged(DataChangeEvent e) throws Exception {
        Date dateBegin = this.dateFrom.getSqlDate();
        Date dateEnd = this.dateTo.getSqlDate();
        if (dateEnd.before(dateBegin)) {
            this.dateFrom.setValue((Object)dateEnd);
        }
    }

    public CompanyOrgUnitInfo getTransferOrg() {
        return this.transferOrg;
    }

    public void setTransferOrg(CompanyOrgUnitInfo transferOrg) {
        this.transferOrg = transferOrg;
    }

    public CompanyOrgUnitInfo[] getTransferOrgArr() {
        return this.transferOrgArr;
    }

    public void setTransferOrgArr(CompanyOrgUnitInfo[] transferOrgArr) {
        this.transferOrgArr = transferOrgArr;
    }

    static /* synthetic */ CompanyOrgUnitInfo[] access$002(VoucherMessageFilterUI x0, CompanyOrgUnitInfo[] x1) {
        x0.transferOrgArr = x1;
        return x1;
    }
}

