/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.books.IVoucherMessage;
import com.kingdee.eas.fi.books.VoucherMessageFactory;
import com.kingdee.eas.fi.books.client.AbstractVoucherMessegeListUI;
import com.kingdee.eas.fi.books.client.VoucherMessageFilterUI;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherMessegeListUI
extends AbstractVoucherMessegeListUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherMessegeListUI.class);
    private VoucherMessageFilterUI voucherMessageFilterUI = null;
    private PeriodInfo curPeriod = null;
    private CompanyOrgUnitInfo transferOrg = SysContext.getSysContext().getCurrentFIUnit();
    private CompanyOrgUnitInfo[] transferOrgArr = null;
    private CompanyOrgUnitInfo masterCompany;
    protected CommonQueryDialog dialog = null;
    public static final String MASTERVOUCHER = "MASTERVOUCHER";
    private boolean initDefaultFilter = true;
    boolean hasRefresh = false;

    public VoucherMessegeListUI() throws Exception {
        BooksUtil.checkBiz((CompanyOrgUnitInfo)this.transferOrg);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("COMPANY") != null) {
            this.transferOrg = (CompanyOrgUnitInfo)this.getUIContext().get("COMPANY");
        }
        this.masterCompany = BooksUtil.getCurrentMasterCompany(null, (CompanyOrgUnitInfo)this.transferOrg);
        if (this.voucherMessageFilterUI == null) {
            this.voucherMessageFilterUI = new VoucherMessageFilterUI(this.transferOrg);
            this.voucherMessageFilterUI.loadData(null);
        }
        if ("LIANCHA".equals(this.getUIContext().get("LIANCHA"))) {
            this.initDefaultFilter = false;
        }
        super.onLoad();
        this.initData();
        this.initMyIcon();
        this.tblMain.getColumn("srcVoucher.bookedDate").getStyleAttributes().setNumberFormat(GlUtils.getDateFormatString());
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!this.hasRefresh) {
            this.refreshList();
        }
    }

    public void setCondition(Map params) {
        Date dateFrom = (Date)params.get("dateFrom");
        Date dateTo = (Date)params.get("dateTo");
        this.voucherMessageFilterUI.radByDate.setSelected(true);
        this.voucherMessageFilterUI.dateFrom.setValue((Object)dateFrom);
        this.voucherMessageFilterUI.dateTo.setValue((Object)dateTo);
        String vouchertype = (String)params.get("voucherType");
        GlUtils.setSelectedItem(this.voucherMessageFilterUI.cbxVoucherType, BOSUuid.read((String)vouchertype));
        this.voucherMessageFilterUI.radNo.setSelected(true);
        String numFrom = (String)params.get("numFrom");
        String numTo = (String)params.get("numTo");
        this.voucherMessageFilterUI.numFrom.setText(numFrom);
        this.voucherMessageFilterUI.numTo.setText(numTo);
        this.hasRefresh = false;
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.hasRefresh = true;
    }

    private void initData() throws Exception {
        this.curPeriod = GlUtils.getCurrentPeriod(null, this.transferOrg.getId().toString());
    }

    private void initMyIcon() {
        this.btnImpVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_importfromzz"));
        this.menuItemImpVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_importfromzz"));
        this.btnTraceUp.setIcon(EASResource.getIcon((String)"imgTbtn_topview"));
        this.menuItemTranceUP.setIcon(EASResource.getIcon((String)"imgTbtn_topview"));
        this.btnTranceDown.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        this.menuItemTranceDown.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        this.btnReimport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemReimport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.cancelImport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemCancelImport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionView.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionLocate.setEnabled(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("srcVoucher.localDebitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("srcVoucher.localCreditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        int masterCurrencyPrecision = 2;
        if (this.masterCompany.getBaseCurrency() != null) {
            masterCurrencyPrecision = this.masterCompany.getBaseCurrency().getPrecision();
        }
        this.tblMain.getColumn("srcVoucher.localDebitAmount").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(masterCurrencyPrecision));
        this.tblMain.getColumn("srcVoucher.localCreditAmount").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(masterCurrencyPrecision));
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.dialog = super.initCommonQueryDialog();
        this.dialog.setHeight(270);
        this.dialog.setWidth(320);
        this.dialog.addUserPanel((KDPanel)this.voucherMessageFilterUI);
        this.dialog.setAllowSystemSolutionAsDefaultFilter(false);
        return this.dialog;
    }

    @Override
    public void actionReimport_actionPerformed(ActionEvent e) throws Exception {
        PeriodInfo currentPeriod;
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        Date srcPeriod = (Date)this.tblMain.getRow(rowIndex).getCell("srcVoucher.bookedDate").getValue();
        IRow rowAss = this.tblMain.getRow(rowIndex);
        String transferOrgName = (String)rowAss.getCell("company.name").getValue();
        CompanyOrgUnitInfo transferOrg = null;
        for (int i = 0; i < this.transferOrgArr.length; ++i) {
            CompanyOrgUnitInfo transferOrgItem = this.transferOrgArr[i];
            if (!transferOrgItem.getName().equals(transferOrgName)) continue;
            transferOrg = transferOrgItem;
            break;
        }
        if ((currentPeriod = GlUtils.getCurrentPeriod(null, transferOrg != null ? transferOrg.getId().toString() : null)) != null) {
            if (srcPeriod.before(currentPeriod.getBeginDate())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"CanNotReImpBeforePeriodVoucher"));
                SysUtil.abort();
            }
        } else if (srcPeriod.before(this.curPeriod.getBeginDate())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"CanNotReImpBeforePeriodVoucher"));
            SysUtil.abort();
        }
        String vmId = this.getSelectedKeyValue();
        boolean isSuc = ((IVoucherMessage)this.getBizInterface()).transferVoucher(vmId, transferOrg != null ? transferOrg : this.transferOrg);
        if (isSuc) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"ImpFinished"));
            this.refreshList();
        }
    }

    @Override
    public void actionImpVoucher_actionPerformed(ActionEvent e) throws Exception {
        RptParams param = this.voucherMessageFilterUI.getParam();
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"param", (Object)param);
        uiContext.put((Object)"COMPANY", (Object)this.transferOrg);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.books.client.VoucherImpBookUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    @Override
    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String key = (String)this.tblMain.getRow(rowIndex).getCell("srcVoucher.id").getValue();
        if (key != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)key);
            uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
            uiContext.put((Object)MASTERVOUCHER, (Object)MASTERVOUCHER);
            this.trace(uiContext);
        }
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String key = (String)this.tblMain.getRow(rowIndex).getCell("targVoucher.id").getValue();
        if (key != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)key);
            uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
            this.trace(uiContext);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.books.BOOKSAutoGenerateResource", (String)"6_VoucherMessegeListUI"));
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.transferOrg = this.voucherMessageFilterUI.getTransferOrg();
        this.transferOrgArr = this.voucherMessageFilterUI.getTransferOrgArr();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VoucherMessageFactory.getRemoteInstance();
    }

    protected void trace(UIContext uiContext) throws Exception {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)VoucherEditUI.getEditUIMode((CoreUIObject)this)).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public EntityViewInfo mergeFilter(EntityViewInfo viewInfo) {
        this.hasRefresh = true;
        FilterInfo vfilter = new FilterInfo();
        if (!"LIANCHA".equals(this.getUIContext().get("LIANCHA"))) {
            vfilter = viewInfo.getFilter();
        }
        FilterInfo filter = this.voucherMessageFilterUI.getPanelFilterInfo();
        try {
            filter.mergeFilter(vfilter, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sorters = viewInfo.getSorter();
        if (sorters == null || sorters.size() == 0) {
            sorters = new SorterItemCollection();
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo("company.number");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorters.add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("srcVoucher.bookedDate");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorters.add(sorterItemInfo);
        sorters.add(new SorterItemInfo("srcVoucher.voucherType.number"));
        sorterItemInfo = new SorterItemInfo("srcVoucher.number");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorters.add(sorterItemInfo);
        viewInfo.setSorter(sorters);
        return viewInfo;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return super.getQueryExecutor(queryPK, this.mergeFilter(viewInfo));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }

    @Override
    public void actionCancelImpVoucher_actionPerformed(ActionEvent e) throws Exception {
        RptParams param = this.voucherMessageFilterUI.getParam();
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"param", (Object)param);
        uiContext.put((Object)"COMPANY", (Object)this.transferOrg);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.books.client.VoucherCancelImpBookUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    protected boolean initDefaultFilter() {
        return this.initDefaultFilter;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

