/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.IBgCtrlHandler;
import org.apache.log4j.Logger;

public class BgCtrlVoucherHandler
implements IBgCtrlHandler {
    private static final Logger logger = Logger.getLogger(BgCtrlVoucherHandler.class);
    public static final String BGHANDLER = "com.kingdee.eas.fi.gl.BgCtrlVoucherHandler";

    public BgCtrlParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        BgCtrlParamCollection result = new BgCtrlParamCollection();
        IVoucher iVoucher = null;
        iVoucher = ctx == null ? VoucherFactory.getRemoteInstance() : VoucherFactory.getLocalInstance((Context)ctx);
        VoucherInfo info = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(billId));
        for (int i = 0; i < info.getEntries().size(); ++i) {
            VoucherEntryInfo entryInfo = info.getEntries().get(i);
            if (entryInfo.getAccount() == null) continue;
            VoucherAssistRecordCollection rec = entryInfo.getAssistRecords();
            if (rec != null && rec.size() > 0) {
                for (int g = 0; g < rec.size(); ++g) {
                    VoucherAssistRecordInfo recordInfo = rec.get(g);
                    BgCtrlParamInfo ctrlInfo = BgCtrlVoucherHandler.getCtrlInfo(info, entryInfo, recordInfo, ctx);
                    result.add(ctrlInfo);
                }
                continue;
            }
            BgCtrlParamInfo ctrlInfo = BgCtrlVoucherHandler.getCtrlInfo(info, entryInfo, null, ctx);
            result.add(ctrlInfo);
        }
        return result;
    }

    public static BgCtrlParamCollection getParameters(VoucherInfo info) throws BOSException, EASBizException {
        BgCtrlParamCollection result = new BgCtrlParamCollection();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            VoucherEntryInfo entryInfo = info.getEntries().get(i);
            if (entryInfo.getAccount() == null) continue;
            VoucherAssistRecordCollection rec = entryInfo.getAssistRecords();
            if (rec != null && rec.size() > 0) {
                for (int g = 0; g < rec.size(); ++g) {
                    VoucherAssistRecordInfo recordInfo = rec.get(g);
                    BgCtrlParamInfo ctrlInfo = BgCtrlVoucherHandler.getCtrlInfo(info, entryInfo, recordInfo, null);
                    result.add(ctrlInfo);
                }
                continue;
            }
            BgCtrlParamInfo ctrlInfo = BgCtrlVoucherHandler.getCtrlInfo(info, entryInfo, null, null);
            result.add(ctrlInfo);
        }
        return result;
    }

    public static BgCtrlParamCollection getParametersInfo(VoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        BgCtrlParamCollection result = new BgCtrlParamCollection();
        VoucherAssistRecordCollection rec = entryInfo.getAssistRecords();
        if (entryInfo.getAccount() != null) {
            if (rec != null && rec.size() > 0) {
                for (int i = 0; i < rec.size(); ++i) {
                    VoucherAssistRecordInfo recordInfo = rec.get(i);
                    BgCtrlParamInfo ctrlInfo = BgCtrlVoucherHandler.getCtrlInfo(entryInfo.getBill(), entryInfo, recordInfo, null);
                    result.add(ctrlInfo);
                }
            } else {
                BgCtrlParamInfo ctrlInfo = BgCtrlVoucherHandler.getCtrlInfo(entryInfo.getBill(), entryInfo, null, null);
                result.add(ctrlInfo);
            }
        }
        return result;
    }

    public static BgCtrlParamInfo getCtrlInfo(VoucherInfo info, VoucherEntryInfo entryInfo, VoucherAssistRecordInfo recordInfo, Context ctx) {
        BgCtrlParamInfo ctrlInfo = new BgCtrlParamInfo();
        ctrlInfo.setOrgUnitId(info.getCompany().getId().toString());
        ctrlInfo.setBizDate(info.getBizDate());
        if (info.getId() != null) {
            ctrlInfo.setSrcBillId(info.getId().toString());
            ctrlInfo.setSrcBillNumber(info.getNumber());
        }
        ctrlInfo.setCurrencyNumber(entryInfo.getCurrency().getNumber());
        ctrlInfo.setCurrencyId(entryInfo.getCurrency().getId().toString());
        String itemNumber = entryInfo.getAccount().getNumber();
        String itemName = entryInfo.getAccount().getName();
        if (recordInfo == null || recordInfo.getAssGrp() == null) {
            ctrlInfo.setItemCombinNumber(itemNumber);
            ctrlInfo.setItemCombinName(itemName);
            ctrlInfo.setAmount(entryInfo.getLocalAmount());
        } else {
            AssistantHGInfo hg = recordInfo.getAssGrp();
            try {
                hg = (AssistantHGInfo)BgCtrlVoucherHandler.getHgInterface(ctx).getValue((IObjectPK)new ObjectUuidPK(hg.getId().toString()));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            CostCenterOrgUnitInfo costCenter = hg.getCostOrg();
            if (costCenter != null) {
                ctrlInfo.setOrgUnitId(costCenter.getId().toString());
            }
            ctrlInfo.setItemCombinNumber(itemNumber);
            ctrlInfo.setItemCombinName(itemName);
            ctrlInfo.setAmount(recordInfo.getLocalAmount());
        }
        return ctrlInfo;
    }

    private static IAssistantHG getHgInterface(Context ctx) throws BOSException {
        IAssistantHG assHg = null;
        assHg = ctx == null ? AssistantHGFactory.getRemoteInstance() : AssistantHGFactory.getLocalInstance((Context)ctx);
        return assHg;
    }
}

