/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffFactory;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffInfo;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemViewFactory;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityCollection;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityInfo;
import com.kingdee.eas.basedata.assistant.ICashFlowAccountDiff;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashEntryInfo;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCategoryEnum;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherHelpFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.fi.gl.app.TAccountSplitStrategyFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashFlowUtils {
    public static final int ASSIGNED_FINISHED = 1;
    public static final int ASSIGNED_UNFINISHED = 2;
    private static final Logger logger = Logger.getLogger(CashFlowUtils.class);

    public static Map getVoucherOrder(Context ctx, VoucherInfo voucher, Map difference) throws BOSException {
        VoucherEntryCollection entries = new VoucherEntryCollection();
        int size = voucher.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entries.add(voucher.getEntries().get(i));
        }
        HashMap<String, VoucherEntryCollection> map = new HashMap<String, VoucherEntryCollection>();
        map.put("col", entries);
        return map;
    }

    public static Map getVoucherByNear(Context ctx, VoucherInfo voucher) throws BOSException {
        VoucherEntryCollection enColcl = voucher.getEntries();
        ArrayList<CashEntryInfo> enCol = new ArrayList<CashEntryInfo>();
        int d = 0;
        int c = 0;
        int a = 0;
        int b = 0;
        int enCount = enColcl.size();
        for (int j = 0; j < enCount; ++j) {
            VoucherEntryInfo entryInfo = (VoucherEntryInfo)enColcl.getObject(j);
            if (entryInfo.getAccount().isBudget()) continue;
            VoucherAssistRecordCollection assistCol = entryInfo.getAssistRecords();
            entryInfo.setBill(voucher);
            CashEntryInfo cashEntry = new CashEntryInfo(entryInfo);
            if (entryInfo.getAccount().getCAA() != null && !CashFlowUtils.isCashAccount(entryInfo.getAccount()) && assistCol != null && assistCol.size() != 0) {
                ArrayList<CashEntryInfo> cashEntryCol = new ArrayList<CashEntryInfo>();
                for (int i = 0; i < assistCol.size(); ++i) {
                    VoucherAssistRecordInfo asst = assistCol.get(i);
                    CashEntryInfo assistCashEntry = new CashEntryInfo(entryInfo, asst);
                    cashEntryCol.add(assistCashEntry);
                }
                cashEntry.setAssistCol(cashEntryCol);
            }
            enCol.add(cashEntry);
            if (entryInfo.getEntryDC() == EntryDC.DEBIT) {
                ++d;
                if (!CashFlowUtils.isCashAccount(entryInfo.getAccount())) continue;
                ++a;
                continue;
            }
            ++c;
            if (!CashFlowUtils.isCashAccount(entryInfo.getAccount())) continue;
            ++b;
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("col", enCol);
        map.put("isOneDebit", Boolean.valueOf(d == 1 && a == 1 && b == 0));
        map.put("isOneCredit", Boolean.valueOf(c == 1 && b == 1 && a == 0));
        return map;
    }

    public static boolean isCashAccount(AccountViewInfo acct) {
        return acct.isIsCash() || acct.isIsBank() || acct.isIsCashEquivalent();
    }

    public static boolean isPL(AccountViewInfo account) {
        return account.getPLType() != AccountPLType.NONE;
    }

    public static boolean isPL(AccountViewInfo account, VoucherInfo voucherInfo) {
        return account.getPLType() != AccountPLType.NONE && CashFlowUtils.isShowSI(voucherInfo, account.getNumber());
    }

    public static Map getDifferenceMap(Context ctx) throws BOSException {
        CashFlowAccountDiffCollection col_diff = (CashFlowAccountDiffCollection)CashFlowUtils.getDifference(ctx).get("CashFlowAccountDiffCollection");
        HashMap<String, String> difference = new HashMap<String, String>();
        int size = col_diff.size();
        for (int i = 0; i < size; ++i) {
            difference.put(col_diff.get(i).getDiffAccount().getId().toString(), "");
        }
        return difference;
    }

    public static void cashCounteract(Context ctx, CompanyOrgUnitInfo company, CashEntryInfo cashentry, CashEntryInfo opposingAccountEntry, BigDecimal[] amount, int coef, boolean hasCashAccount) throws EASBizException, BOSException {
        CashflowRecordInfo record = new CashflowRecordInfo();
        ICashflowRecord cfr = CashflowRecordFactory.getLocalInstance(ctx);
        record.setOriginalAmount(amount[0]);
        if (company.getBaseCurrency() != null) {
            amount[1] = amount[1].setScale(company.getBaseCurrency().getPrecision(), 4);
        }
        if (company.getReportCurrency() != null) {
            amount[2] = amount[2].setScale(company.getReportCurrency().getPrecision(), 4);
        }
        record.setLocalAmount(amount[1]);
        record.setReportingAmount(amount[2]);
        if (CashFlowUtils.isCashAccount(cashentry.getAccount())) {
            record.setPrimaryCoefficient(coef);
        } else {
            record.setSupplementaryCoefficient(coef);
            if (hasCashAccount) {
                record.setIsSupItem(true);
            }
        }
        VoucherInfo voucher = new VoucherInfo();
        voucher.setId(cashentry.getBill().getId());
        record.setVoucher(voucher);
        VoucherEntryInfo entry = cashentry.getVoucherEntry();
        record.setEntry(entry);
        record.setAccount(entry.getAccount());
        record.setCurrency(entry.getCurrency());
        record.setEntryDC(entry.getEntryDC());
        VoucherEntryInfo oppEntry = opposingAccountEntry.getVoucherEntry();
        record.setOpposingAccountEntry(oppEntry);
        record.setOppAccount(oppEntry.getAccount());
        record.setOppEntryDC(oppEntry.getEntryDC());
        record.setItemFlag(ItemFlag.DISPOSE);
        cfr.addnew((CoreBaseInfo)record);
    }

    public static Map getDifference(Context ctx) throws BOSException {
        HashMap<String, CashFlowAccountDiffCollection> difference = new HashMap<String, CashFlowAccountDiffCollection>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getAccountSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("diffAccount.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString()));
        ICashFlowAccountDiff activity = CashFlowAccountDiffFactory.getLocalInstance((Context)ctx);
        CashFlowAccountDiffCollection col = activity.getCashFlowAccountDiffCollection(view);
        if (col != null) {
            difference.put("CashFlowAccountDiffCollection", col);
        }
        return difference;
    }

    public static void sortByAmount(List enCol) {
        Collections.sort(enCol, new Comparator(){

            public int compare(Object o1, Object o2) {
                CashEntryInfo entry = (CashEntryInfo)o1;
                CashEntryInfo entry1 = (CashEntryInfo)o2;
                return entry1.getLocalAmount().abs().compareTo(entry.getLocalAmount().abs());
            }
        });
    }

    public static String getPrimaryItemVocuherSql(String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate, List params, int type) {
        String periodListSql = "select p.fid fid  from t_bd_period p left join t_org_company c on c.faccountperiodid = p.ftypeid where p.fnumber >= ? and p.fnumber <= ? and c.fid = ?";
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid fid from \r\n");
        sql.append("( \r\n");
        sql.append("\t\tselect v.fid,sum(case when ve.fentrydc=0 then -1 else 1 end * ve.flocalamount) vamount \r\n");
        sql.append("\t\tfrom t_gl_voucher v \r\n");
        sql.append("\t\tinner join t_gl_voucherentry ve on ve.fbillid=v.fid \r\n");
        sql.append("\t\tinner join t_bd_accountview av on av.fid=ve.faccountid \r\n");
        sql.append("\t\twhere v.fcompanyid=? and av.fcompanyid=? and v.fsourcetype <> 1  and v.fsourcetype<>7 \r\n");
        params.add(companyId);
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and v.fperiodid in ( " + periodListSql + ")").append("\r\n");
            params.add(startPeriod);
            params.add(endPeriod);
            params.add(companyId);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("\t\t      and (av.fisCash=1 or av.fisBank=1 or av.fisCashEquivalent=1) \r\n");
        sql.append("\t\tgroup by v.fid \r\n");
        sql.append(") t1 \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\t\tselect v.fid,sum(case when cfi.fdirection=1 then 1 else -1 end * cf.flocalamount * cf.fprimarycoeffient) cfamount \r\n");
        sql.append("\t\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\t\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\t\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fprimaryitemid \r\n");
        sql.append("\t\twhere v.fcompanyid=? and v.fsourcetype <> 1  and v.fsourcetype<>7 \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and v.fperiodid in ( " + periodListSql + ")").append("\r\n");
            params.add(startPeriod);
            params.add(endPeriod);
            params.add(companyId);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("\t\t      and (cf.fitemflag=1 or cf.fitemflag=3) \r\n");
        sql.append("\t\tgroup by v.fid \r\n");
        sql.append(") t2 on t1.fid=t2.fid \r\n");
        if (1 == type) {
            sql.append("where vamount = cfamount \r\n");
        } else {
            sql.append("where vamount <> isnull(cfamount,0) \r\n");
        }
        return sql.toString();
    }

    public static String getSupplementaryVoucher(String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate, List params, int type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid fid \r\n");
        sql.append("from ( \r\n");
        sql.append("\tselect v.fid,sum(case when actype.fproperty=4 and avdiff.fid is null then \r\n");
        sql.append("\tcase when ve.fentrydc=0 then 1 else -1 end \r\n");
        sql.append("\telse 0 end * isnull(ve.flocalamount,0)) netprofit \r\n");
        sql.append("\tfrom t_gl_voucher v \r\n");
        sql.append("\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\tinner join t_gl_voucherentry ve on ve.fbillid=v.fid \r\n");
        sql.append("\tinner join t_bd_accountview av on av.fid=ve.faccountid \r\n");
        sql.append("\tinner join t_bd_accounttype actype on actype.fid = av.faccounttypeid \r\n");
        sql.append("\tleft join t_bd_cashflowaccountdiff avdiff on av.fid = avdiff.fdiffaccountid \r\n");
        sql.append("\twhere v.fcompanyid=? and av.fcompanyid=? \r\n");
        params.add(companyId);
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("\t      and v.fsourcetype <> 1  and v.fsourcetype<>7\r\n");
        sql.append("\tgroup by v.fid \r\n");
        sql.append(") t1 \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\tselect v.fid,sum(cf.flocalamount * cf.fsupplementarycoeffient) supamount \r\n");
        sql.append("\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fsupplementaryitemid \r\n");
        sql.append("where v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("      and  v.fsourcetype <> 1  and v.fsourcetype<>7  \r\n");
        sql.append("\tand\t(cf.fitemflag = 2 or cf.fitemflag = 3)");
        sql.append("group by v.fid \r\n");
        sql.append(") t2 on t1.fid=t2.fid \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\tselect v.fid,sum(case when cfi.fdirection=1 then 1 else -1 end * cf.flocalamount * cf.fprimarycoeffient) pamount \r\n");
        sql.append("\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fprimaryitemid \r\n");
        sql.append("\tleft  join t_bd_cashflowkeepactivity kc on cfi.fid =kc.fconcashflowitemid \r\n");
        sql.append("where v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("      and (cf.fitemflag=1 or cf.fitemflag=3) \r\n");
        sql.append("      and cfi.fisdealactivity =1 and kc.fid is null and v.fsourcetype <> 1  and v.fsourcetype<>7 \r\n");
        sql.append("group by v.fid \r\n");
        sql.append(") t3 on t1.fid=t3.fid \r\n");
        if (1 == type) {
            sql.append("where netprofit+isnull(supamount,0) = isnull(pamount,0) \r\n");
        } else {
            sql.append("where netprofit+isnull(supamount,0)<>isnull(pamount,0) \r\n");
        }
        return sql.toString();
    }

    public static String getSupplementaryVoucherExcludeAdjust(String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate, List params, int type) throws BOSException {
        String periodListSql = "select p.fid fid  from t_bd_period p left join t_org_company c on c.faccountperiodid = p.ftypeid where p.fnumber >= ? and p.fnumber <= ? and c.fid = ?";
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid fid \r\n");
        sql.append("from ( \r\n");
        sql.append("\tselect v.fid,sum(case when actype.fproperty=4 and avdiff.fid is null then \r\n");
        sql.append("\tcase when ve.fentrydc=0 then 1 else -1 end \r\n");
        sql.append("\telse 0 end * isnull(ve.flocalamount,0)) netprofit \r\n");
        sql.append("\tfrom t_gl_voucher v \r\n");
        sql.append("\tinner join t_gl_voucherentry ve on ve.fbillid=v.fid \r\n");
        sql.append("\tinner join t_bd_accountview av on av.fid=ve.faccountid \r\n");
        sql.append("\tinner join t_bd_accounttype actype on actype.fid = av.faccounttypeid \r\n");
        sql.append("\tleft join t_bd_cashflowaccountdiff avdiff on av.fid = avdiff.fdiffaccountid \r\n");
        sql.append("\twhere v.fcompanyid=? and av.fcompanyid=? \r\n");
        params.add(companyId);
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and v.fperiodid in ( " + periodListSql + ")").append("\r\n");
            params.add(startPeriod);
            params.add(endPeriod);
            params.add(companyId);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("\t      and v.fsourceType <> 1 \r\n");
        sql.append("\tgroup by v.fid \r\n");
        sql.append(") t1 \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\tselect v.fid,sum(cf.flocalamount * cf.fsupplementarycoeffient) supamount \r\n");
        sql.append("\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fsupplementaryitemid \r\n");
        sql.append("where v.fcompanyid=? and cf.fitemflag <> 7 \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and v.fperiodid in ( " + periodListSql + ")").append("\r\n");
            params.add(startPeriod);
            params.add(endPeriod);
            params.add(companyId);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("      and v.fsourceType <> 1 \r\n");
        sql.append("group by v.fid \r\n");
        sql.append(") t2 on t1.fid=t2.fid \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\tselect v.fid,sum(case when cfi.fdirection=1 then 1 else -1 end * cf.flocalamount * cf.fprimarycoeffient) pamount \r\n");
        sql.append("\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fprimaryitemid \r\n");
        sql.append("\tleft  join t_bd_cashflowkeepactivity kc on cfi.fid =kc.fconcashflowitemid \r\n");
        sql.append("where v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and v.fperiodid in ( " + periodListSql + ")").append("\r\n");
            params.add(startPeriod);
            params.add(endPeriod);
            params.add(companyId);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("      and (cf.fitemflag=1 or cf.fitemflag=3) \r\n");
        sql.append("      and cfi.fisdealactivity =1 and kc.fid is null and v.fsourceType <> 1 \r\n");
        sql.append("group by v.fid \r\n");
        sql.append(") t3 on t1.fid=t3.fid \r\n");
        if (1 == type) {
            sql.append("where netprofit+isnull(supamount,0) = isnull(pamount,0) \r\n");
        } else {
            sql.append("where netprofit+isnull(supamount,0)<>isnull(pamount,0) \r\n");
        }
        return sql.toString();
    }

    public static boolean isPL(AccountViewInfo account, Map difference) {
        return account.getPLType() != AccountPLType.NONE && !difference.containsKey(account.getId().toString());
    }

    public static boolean isPL(AccountViewInfo account, Set<String> difference) {
        return account.getPLType() != AccountPLType.NONE && !difference.contains(account.getId().toString());
    }

    public static boolean isDealActivity(CashFlowItemInfo item, Map difference) {
        return item.isIsDealActivity() && !difference.containsKey(item.getId().toString());
    }

    public static CashflowFlag computeCashflowFlag(VoucherInfo voucherInfo) {
        if (SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType()) || VoucherCategoryEnum.BUDGET.equals((Object)voucherInfo.getCategory())) {
            return CashflowFlag.NONE;
        }
        boolean cashAccExist = false;
        boolean pnlAccExist = false;
        boolean qylAccExist = false;
        boolean elseAccExist = false;
        VoucherEntryCollection entries = voucherInfo.getEntries();
        int count = entries.size();
        VoucherEntryInfo entry = null;
        for (int i = 0; i < count; ++i) {
            entry = entries.get(i);
            AccountViewInfo acc = entry.getAccount();
            if (acc == null || AccountCategoryEnum.BUDGET.equals((Object)acc.getCategory())) continue;
            if (acc.isIsCash() || acc.isIsBank() || acc.isIsCashEquivalent()) {
                cashAccExist = true;
                continue;
            }
            if (acc.getAccountTypeID() != null && AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty()) && CashFlowUtils.isShowSI(voucherInfo, acc.getNumber())) {
                pnlAccExist = true;
                continue;
            }
            if (acc.getAccountTypeID() != null && AccountProperty.QUANYI.equals((Object)acc.getAccountTypeID().getProperty())) {
                qylAccExist = true;
                continue;
            }
            elseAccExist = true;
        }
        CashflowFlag flag = null;
        flag = !cashAccExist && pnlAccExist && qylAccExist && !elseAccExist ? CashflowFlag.ONLY_PNLACCOUNT : (cashAccExist && pnlAccExist ? CashflowFlag.BOTH_CASH_AND_PNL : (cashAccExist && (elseAccExist || qylAccExist) ? CashflowFlag.ONLY_CASHACCOUNT : (pnlAccExist && elseAccExist ? CashflowFlag.ONLY_PNLACCOUNT : (!cashAccExist && !pnlAccExist ? CashflowFlag.BOTHNONE : CashflowFlag.NONE))));
        return flag;
    }

    private static boolean isShowSI(VoucherInfo voucherInfo, String accountNumber) {
        CashFlowAccountDiffCollection actCol = voucherInfo.getCashFlowAccountDiffCollection();
        boolean isShowSI = true;
        if (actCol != null) {
            int size = actCol.size();
            for (int i = 0; i < size; ++i) {
                CashFlowAccountDiffInfo actitem = actCol.get(i);
                if (actitem.getDiffAccount() == null || !accountNumber.equals(actitem.getDiffAccount().getNumber())) continue;
                isShowSI = false;
                break;
            }
        }
        return isShowSI;
    }

    public static void splitByTMethod(VoucherInfo vch, boolean isSimpleMode, int autoSetCashflow) throws Exception {
        CashflowRecordCollection records;
        Context ctx;
        CashflowFlag cfFlag;
        if (vch.getCashflowRecords() != null) {
            boolean isAllDipose = true;
            CashflowRecordCollection cashflowRecords = (CashflowRecordCollection)vch.getCashflowRecords();
            for (int i = 0; i < cashflowRecords.size(); ++i) {
                CashflowRecordInfo recordInfo = cashflowRecords.get(i);
                if (recordInfo.getItemFlag() == ItemFlag.DISPOSE) continue;
                isAllDipose = false;
                break;
            }
            if (!isAllDipose) {
                return;
            }
        }
        if (!CashflowFlag.ONLY_CASHACCOUNT.equals((Object)(cfFlag = CashFlowUtils.computeCashflowFlag(vch))) && !CashflowFlag.BOTH_CASH_AND_PNL.equals((Object)cfFlag)) {
            if (CashflowFlag.ONLY_PNLACCOUNT.equals((Object)cfFlag)) {
                String splitPLCashFlowMethod = "";
                splitPLCashFlowMethod = autoSetCashflow == 1 ? "com.kingdee.eas.fi.gl.app.CashflowSplitServer#splitByOppositeMethod" : "com.kingdee.eas.fi.gl.app.CashflowSplitServer#splitByPLMethod";
                CashflowSplitRecordCollection sp = null;
                try {
                    if (vch.get("ctxVch") != null) {
                        ctx = (Context)vch.get("ctxVch");
                        ITAccountSplitStrategy strategy = TAccountSplitStrategyFactory.getSplitStrategy((String)(autoSetCashflow == 1 ? "byOpposite" : "pl"));
                        sp = strategy.split(ctx, vch, new HashMap());
                    } else {
                        sp = (CashflowSplitRecordCollection)CommRptBaseFactory.getRemoteInstance().invoke(splitPLCashFlowMethod, new Object[]{vch}, new Class[]{VoucherInfo.class}, true);
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
                if (sp == null || sp.size() == 0) {
                    return;
                }
                records = new CashflowRecordCollection();
                int seq = 1;
                for (CashflowSplitRecordInfo splitRecord : sp) {
                    int sc;
                    VoucherEntryInfo oppEntry = splitRecord.getOpposingAccountEntry();
                    VoucherEntryInfo entry = splitRecord.getEntry();
                    CashflowRecordInfo record = new CashflowRecordInfo();
                    record.setSeq(seq++);
                    record.setVoucher(vch);
                    record.setEntry(entry);
                    record.setAccount(entry.getAccount());
                    record.setCurrency(entry.getCurrency());
                    record.setEntryDC(entry.getEntryDC());
                    record.setOpposingAccountEntry(oppEntry);
                    record.setOppAccount(oppEntry.getAccount());
                    record.setOppEntryDC(oppEntry.getEntryDC());
                    if (splitRecord.getOppVoucherAssistRecord() != null) {
                        record.setOppVoucherAssistRecord(splitRecord.getOppVoucherAssistRecord());
                        record.setOppAssGrp(splitRecord.getOppAssGrp());
                    }
                    record.setOriginalAmount(splitRecord.getOriginalAmount());
                    record.setLocalAmount(splitRecord.getLocalAmount());
                    record.setReportingAmount(splitRecord.getReportingAmount());
                    if (ItemFlag.DISPOSE.equals((Object)splitRecord.getItemFlag())) {
                        record.setItemFlag(splitRecord.getItemFlag());
                        record.setSupplementaryItem(null);
                        record.setSupplementaryCoefficient(0);
                        record.setPrimaryItem(null);
                        record.setPrimaryCoefficient(0);
                        record.setIsSupItem(false);
                        records.add(record);
                        continue;
                    }
                    boolean isDebit = oppEntry.getEntryDC().equals((Object)EntryDC.DEBIT);
                    CashFlowItemInfo supItem = null;
                    supItem = isDebit ? oppEntry.getAccount().getBorrowerAttCashFlowItem() : oppEntry.getAccount().getLenderAttCashFlowItem();
                    if (record.getOppVoucherAssistRecord() != null && record.getOppVoucherAssistRecord().getSupplementaryItem() != null) {
                        supItem = record.getOppVoucherAssistRecord().getSupplementaryItem();
                    } else if (oppEntry.getSupplementaryItem() != null) {
                        supItem = oppEntry.getSupplementaryItem();
                    }
                    record.setItemFlag(ItemFlag.SUPPLEMENTARY);
                    record.setSupplementaryItem(supItem);
                    boolean isPnL = AccountProperty.SUNYI.equals((Object)oppEntry.getAccount().getAccountTypeID().getProperty()) && CashFlowUtils.isShowSI(vch, oppEntry.getAccount().getNumber());
                    EntryDC entryDC = entry.getEntryDC();
                    if (isPnL) {
                        sc = -1;
                        if (EntryDC.DEBIT.equals((Object)oppEntry.getEntryDC())) {
                            sc = 1;
                            if (EntryDC.DEBIT.equals((Object)entryDC)) {
                                sc = -1;
                            }
                        } else if (EntryDC.CREDIT.equals((Object)entryDC)) {
                            sc = 1;
                        }
                        record.setSupplementaryCoefficient(sc);
                        record.setItemFlag(ItemFlag.DISPOSE);
                    } else {
                        sc = -1;
                        if (EntryDC.DEBIT.equals((Object)entryDC)) {
                            sc = 1;
                        }
                        record.setSupplementaryCoefficient(sc);
                    }
                    record.setPrimaryItem(null);
                    record.setPrimaryCoefficient(0);
                    record.setIsSupItem(false);
                    records.add(record);
                }
                vch.setCashflowRecords((AbstractObjectCollection)records);
            }
            return;
        }
        String splitCashFlowMethod = "";
        splitCashFlowMethod = autoSetCashflow == 1 ? "com.kingdee.eas.fi.gl.app.CashflowSplitServer#splitByOppositeMethod" : "com.kingdee.eas.fi.gl.app.CashflowSplitServer#splitByTMethod";
        CashflowSplitRecordCollection sp = null;
        try {
            if (vch.get("ctxVch") != null) {
                ctx = (Context)vch.get("ctxVch");
                ITAccountSplitStrategy strategy = TAccountSplitStrategyFactory.getSplitStrategy((String)(autoSetCashflow == 1 ? "byOpposite" : "default"));
                sp = strategy.split(ctx, vch, new HashMap());
            } else {
                sp = (CashflowSplitRecordCollection)CommRptBaseFactory.getRemoteInstance().invoke(splitCashFlowMethod, new Object[]{vch}, new Class[]{VoucherInfo.class}, true);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (sp == null || sp.size() == 0) {
            return;
        }
        records = new CashflowRecordCollection();
        int seq = 1;
        HashMap hmDynamicColumnInfo = new HashMap();
        HashMap hmDynamicDatabaseInfo = new HashMap();
        HashMap hmPrimaryAssGrpInfo = new HashMap();
        for (CashflowSplitRecordInfo splitRecord : sp) {
            VoucherEntryInfo oppEntry = splitRecord.getOpposingAccountEntry();
            VoucherEntryInfo entry = splitRecord.getEntry();
            CashflowRecordInfo record = new CashflowRecordInfo();
            record.setSeq(seq++);
            record.setVoucher(vch);
            record.setEntry(entry);
            record.setAccount(entry.getAccount());
            record.setCurrency(entry.getCurrency());
            record.setEntryDC(entry.getEntryDC());
            record.setOpposingAccountEntry(oppEntry);
            record.setOppAccount(oppEntry.getAccount());
            record.setOppEntryDC(oppEntry.getEntryDC());
            if (splitRecord.getOppVoucherAssistRecord() != null) {
                record.setOppVoucherAssistRecord(splitRecord.getOppVoucherAssistRecord());
                record.setOppAssGrp(splitRecord.getOppAssGrp());
            }
            record.setOriginalAmount(splitRecord.getOriginalAmount());
            record.setLocalAmount(splitRecord.getLocalAmount());
            record.setReportingAmount(splitRecord.getReportingAmount());
            if (ItemFlag.DISPOSE.equals((Object)splitRecord.getItemFlag())) {
                record.setSupplementaryItem(null);
                record.setSupplementaryCoefficient(0);
                record.setItemFlag(ItemFlag.DISPOSE);
                record.setIsSupItem(false);
                record.setPrimaryItem(null);
                record.setPrimaryCoefficient(0);
                records.add(record);
                continue;
            }
            boolean isDebit = oppEntry.getEntryDC().equals((Object)EntryDC.DEBIT);
            CashFlowItemInfo primaryItem = null;
            primaryItem = isDebit ? oppEntry.getAccount().getBorrowerMainCashFlowItem() : oppEntry.getAccount().getLenderMainCashFlowItem();
            if (record.getOppVoucherAssistRecord() != null && record.getOppVoucherAssistRecord().getPrimaryItem() != null) {
                primaryItem = record.getOppVoucherAssistRecord().getPrimaryItem();
            } else if (oppEntry.getPrimaryItem() != null) {
                primaryItem = oppEntry.getPrimaryItem();
            }
            record.setPrimaryItem(primaryItem);
            record.setSupplementaryItem(null);
            record.setSupplementaryCoefficient(0);
            record.setItemFlag(ItemFlag.PRIMARY);
            record.setIsSupItem(false);
            if (primaryItem != null) {
                Object[] asstInfo;
                CashFlowDirection direction = primaryItem.getDirection();
                if (EntryDC.DEBIT.equals((Object)entry.getEntryDC()) && CashFlowDirection.OUT.equals((Object)direction) || EntryDC.CREDIT.equals((Object)entry.getEntryDC()) && CashFlowDirection.IN.equals((Object)direction)) {
                    record.setPrimaryCoefficient(-1);
                } else {
                    record.setPrimaryCoefficient(1);
                }
                if (primaryItem.isIsEnable() && primaryItem.getAsstAccount() != null && primaryItem.getAsstAccount().getId() != null && oppEntry.getAccount().getCAA() != null && oppEntry.getAccount().getCAA().getId() != null && (asstInfo = CashFlowUtils.getCachedColumnInfo(hmDynamicColumnInfo, oppEntry.getAccount().getCAA().getId().toString())) != null && record.getOppAssGrp() != null) {
                    VoucherInfo.DynamicColumnInfo[] asstItemCols = (VoucherInfo.DynamicColumnInfo[])asstInfo[0];
                    Object[] cfiInfo = CashFlowUtils.getCachedColumnInfo(hmDynamicColumnInfo, primaryItem.getAsstAccount().getId().toString());
                    VoucherInfo.DynamicColumnInfo[] cfiItemCols = (VoucherInfo.DynamicColumnInfo[])cfiInfo[0];
                    CashFlowUtils.autoSetActTypeValue(hmDynamicDatabaseInfo, record, record.getOppAssGrp().getId().toString(), asstItemCols, primaryItem.getAsstAccount(), cfiItemCols, isSimpleMode);
                }
                if (primaryItem.isIsEnable() && primaryItem.getAsstAccount() != null && primaryItem.getAsstAccount().getId() != null && oppEntry.getAccount().getCAA() == null) {
                    Object[] cfiInfo = CashFlowUtils.getCachedColumnInfo(hmDynamicColumnInfo, primaryItem.getAsstAccount().getId().toString());
                    VoucherInfo.DynamicColumnInfo[] cfiItemCols = (VoucherInfo.DynamicColumnInfo[])cfiInfo[0];
                    CashFlowUtils.autoSetActTypeValue(hmPrimaryAssGrpInfo, record, primaryItem.getAsstAccount(), cfiItemCols, isSimpleMode);
                }
                if (CashFlowUtils.isNeedAssignSupItem(vch, oppEntry, primaryItem)) {
                    CashFlowItemInfo supItem = null;
                    supItem = isDebit ? oppEntry.getAccount().getBorrowerAttCashFlowItem() : oppEntry.getAccount().getLenderAttCashFlowItem();
                    if (record.getOppVoucherAssistRecord() != null && record.getOppVoucherAssistRecord().getSupplementaryItem() != null) {
                        supItem = record.getOppVoucherAssistRecord().getSupplementaryItem();
                    } else if (oppEntry.getSupplementaryItem() != null) {
                        supItem = oppEntry.getSupplementaryItem();
                    }
                    if (supItem != null) {
                        record.setItemFlag(ItemFlag.BOTH);
                        record.setSupplementaryItem(supItem);
                        boolean isPnL = AccountProperty.SUNYI.equals((Object)oppEntry.getAccount().getAccountTypeID().getProperty()) && CashFlowUtils.isShowSI(vch, oppEntry.getAccount().getNumber());
                        EntryDC entryDC = entry.getEntryDC();
                        if (isPnL) {
                            int sc = -1;
                            if (EntryDC.DEBIT.equals((Object)oppEntry.getEntryDC())) {
                                sc = 1;
                                if (EntryDC.DEBIT.equals((Object)entryDC)) {
                                    sc = -1;
                                }
                            } else if (EntryDC.CREDIT.equals((Object)entryDC)) {
                                sc = 1;
                            }
                            record.setSupplementaryCoefficient(sc);
                        } else {
                            int sc = -1;
                            if (EntryDC.DEBIT.equals((Object)entryDC)) {
                                sc = 1;
                            }
                            record.setSupplementaryCoefficient(sc);
                        }
                    }
                }
            } else {
                record.setPrimaryCoefficient(1);
            }
            records.add(record);
        }
        vch.setCashflowRecords((AbstractObjectCollection)records);
    }

    public static void autoSetActTypeValue(Map hmPrimaryAssGrpInfo, CashflowRecordInfo info, AsstAccountInfo cfiTypeGroup, VoucherInfo.DynamicColumnInfo[] cfiActTypeCols, boolean isSimpleMode) {
        if (!isSimpleMode || cfiActTypeCols == null || cfiActTypeCols.length == 0) {
            return;
        }
        AssistantHGInfo defaultAssGrp = new AssistantHGInfo();
        if (hmPrimaryAssGrpInfo.containsKey(info.getPrimaryItem().getId().toString())) {
            defaultAssGrp = (AssistantHGInfo)hmPrimaryAssGrpInfo.get(info.getPrimaryItem().getId().toString());
            if (defaultAssGrp == null) {
                defaultAssGrp = new AssistantHGInfo();
            }
        } else {
            try {
                defaultAssGrp = CashFlowUtils.getDefaultAsstItems(cfiActTypeCols, info.getOppAccount(), info.getVoucher().getCompany() != null ? info.getVoucher().getCompany() : SysContext.getSysContext().getCurrentFIUnit());
            }
            catch (Exception e) {
                logger.error((Object)"CashFlowUtils.getDefaultAsstItems error", (Throwable)e);
            }
        }
        boolean isAllNull = true;
        AssistantHGInfo group = new AssistantHGInfo();
        group.setAsstAccount(cfiTypeGroup);
        CashflowTypeEnum cfType = CashflowTypeEnum.OUT;
        for (int i = 0; i < cfiActTypeCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = cfiActTypeCols[i];
            String key = colInfo.getMappingPropName();
            if (defaultAssGrp.get(key) != null) {
                group.put(key, defaultAssGrp.get(key));
                isAllNull = false;
                if (!cfType.equals((Object)CashflowTypeEnum.OUT)) continue;
                if (key.equals("companyOrg")) {
                    cfType = CashflowTypeEnum.IN;
                }
                if (key.equals("customer") && ((CustomerInfo)defaultAssGrp.get(key)).getInternalCompany() != null) {
                    cfType = CashflowTypeEnum.IN;
                }
                if (!key.equals("provider") || ((SupplierInfo)defaultAssGrp.get(key)).getInternalCompany() == null) continue;
                cfType = CashflowTypeEnum.IN;
                continue;
            }
            group.put(key, null);
        }
        info.setType(cfType);
        if (isAllNull) {
            info.setAssGrp(null);
        } else {
            try {
                group = VoucherFacadeFactory.getRemoteInstance().confirmAssGrp(group, cfiTypeGroup.getId().toString(), cfiActTypeCols);
                if (group != null) {
                    info.setAssGrp(group);
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            }
            catch (Exception e) {
                info.setType(CashflowTypeEnum.OUT);
                logger.error((Object)"CashflowSplitClient invoke autoSetActTypeValue error", (Throwable)e);
            }
        }
        if (!hmPrimaryAssGrpInfo.containsKey(info.getPrimaryItem().getId().toString())) {
            hmPrimaryAssGrpInfo.put(info.getPrimaryItem().getId().toString(), info.getAssGrp());
        }
    }

    private static Object[] getCachedColumnInfo(Map hmDynamicColumnInfo, String typeGroupId) {
        if (typeGroupId == null) {
            return null;
        }
        Object[] colInfo = (Object[])hmDynamicColumnInfo.get(typeGroupId);
        try {
            if (colInfo == null) {
                colInfo = VoucherFacadeFactory.getRemoteInstance().fetchAssColumnInfo(null, typeGroupId, null);
                hmDynamicColumnInfo.put(typeGroupId, colInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"CashflowSplitClient invoke getCachedColumnInfo error");
        }
        return colInfo;
    }

    public static void autoSetActTypeValue(Map dynamicDatabaseInfo, CashflowRecordInfo info, String hgId, VoucherInfo.DynamicColumnInfo[] acctActTypeCols, AsstAccountInfo cfiTypeGroup, VoucherInfo.DynamicColumnInfo[] cfiActTypeCols, boolean isSimpleMode) {
        Object objCompany;
        CustomerInfo customerFromCompany;
        SupplierInfo supplierFromCompany;
        CustomerInfo customerFromBizAnalysisCode;
        SupplierInfo supplierFromBizAnalysisCode;
        boolean isCompanyToProvider;
        boolean isCompanyToCustomer;
        boolean isCompanyToCustomerAndProvider;
        boolean isProviderToCustomer;
        boolean isCustomerToProvider;
        boolean isExistsCfProvider;
        boolean isExistsCfCustomer;
        boolean isExistsOppCompany;
        boolean isExistsOppProvider;
        boolean isExistsOppCustomer;
        AssistantHGInfo assGrp;
        block92: {
            block91: {
                if (StringUtils.isEmpty((String)hgId) || acctActTypeCols == null || acctActTypeCols.length == 0 || cfiActTypeCols == null || cfiActTypeCols.length == 0) {
                    return;
                }
                if (!isSimpleMode) {
                    return;
                }
                assGrp = null;
                try {
                    assGrp = GlUtils.dynamicLoadAssistangHG(null, dynamicDatabaseInfo, hgId, acctActTypeCols);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                if (assGrp == null) {
                    return;
                }
                isExistsOppCustomer = false;
                isExistsOppProvider = false;
                isExistsOppCompany = false;
                isExistsCfCustomer = false;
                isExistsCfProvider = false;
                isCustomerToProvider = false;
                isProviderToCustomer = false;
                isCompanyToCustomerAndProvider = false;
                isCompanyToCustomer = false;
                isCompanyToProvider = false;
                supplierFromBizAnalysisCode = null;
                customerFromBizAnalysisCode = null;
                supplierFromCompany = null;
                customerFromCompany = null;
                for (VoucherInfo.DynamicColumnInfo oppCol : cfiActTypeCols) {
                    if ("customer".equals(oppCol.getMappingPropName())) {
                        isExistsCfCustomer = true;
                    }
                    if (!"provider".equals(oppCol.getMappingPropName())) continue;
                    isExistsCfProvider = true;
                }
                for (VoucherInfo.DynamicColumnInfo oppCol : acctActTypeCols) {
                    if ("customer".equals(oppCol.getMappingPropName())) {
                        isExistsOppCustomer = true;
                    }
                    if ("provider".equals(oppCol.getMappingPropName())) {
                        isExistsOppProvider = true;
                    }
                    if (!"companyOrg".equals(oppCol.getMappingPropName())) continue;
                    isExistsOppCompany = true;
                }
                if (isExistsOppCustomer && !isExistsOppProvider && isExistsCfProvider) {
                    isCustomerToProvider = true;
                    Object objCustomer = assGrp.get("customer");
                    if (objCustomer instanceof CustomerInfo) {
                        CustomerInfo customer = (CustomerInfo)objCustomer;
                        if (customer.getBizAnalysisCode() == null) {
                            isCustomerToProvider = false;
                        } else {
                            try {
                                EntityViewInfo view = CashFlowUtils.getBizAnalysisCodeView(customer.getBizAnalysisCode().getId().toString());
                                SupplierCollection supplies = SupplierFactory.getRemoteInstance().getSupplierCollection(view);
                                if (supplies.size() == 1) {
                                    supplierFromBizAnalysisCode = supplies.get(0);
                                    break block91;
                                }
                                isCustomerToProvider = false;
                            }
                            catch (BOSException e) {
                                logger.error((Object)"autoSetActTypeValue invoke CFAsstautoSetByBizAnalysisCode error", (Throwable)e);
                            }
                        }
                    } else {
                        isCustomerToProvider = false;
                    }
                }
            }
            if (!isExistsOppCustomer && isExistsOppProvider && isExistsCfCustomer) {
                isProviderToCustomer = true;
                Object objSupplier = assGrp.get("provider");
                if (objSupplier instanceof SupplierInfo) {
                    SupplierInfo supplier = (SupplierInfo)objSupplier;
                    if (supplier.getBizAnalysisCode() == null) {
                        isProviderToCustomer = false;
                    } else {
                        try {
                            EntityViewInfo view = CashFlowUtils.getBizAnalysisCodeView(supplier.getBizAnalysisCode().getId().toString());
                            CustomerCollection customers = CustomerFactory.getRemoteInstance().getCustomerCollection(view);
                            if (customers.size() == 1) {
                                customerFromBizAnalysisCode = customers.get(0);
                                break block92;
                            }
                            isProviderToCustomer = false;
                        }
                        catch (BOSException e) {
                            logger.error((Object)"autoSetActTypeValue invoke CFAsstautoSetByBizAnalysisCode error", (Throwable)e);
                        }
                    }
                } else {
                    isProviderToCustomer = false;
                }
            }
        }
        if (isExistsOppCompany && (objCompany = assGrp.get("companyOrg")) instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)objCompany;
            CompanyOrgUnitInfo company = info.getVoucher().getCompany();
            String internalCompanyId = companyOrgUnitInfo.getId().toString();
            try {
                Map<String, Object> customerMap;
                if (!isExistsOppProvider && !isExistsOppCustomer && (isExistsCfProvider || isExistsCfCustomer)) {
                    Map<String, Object> supplierMap;
                    Map<String, Object> customerMap2;
                    boolean isCustomerNotNull = false;
                    boolean isSupplierNotNull = false;
                    if (isExistsCfCustomer && (customerMap2 = CashFlowUtils.getCustomerInfo(null, internalCompanyId, company, null)).size() == 1) {
                        customerFromCompany = (CustomerInfo)customerMap2.values().toArray()[0];
                        isCustomerNotNull = true;
                    }
                    if (isExistsCfProvider && (supplierMap = CashFlowUtils.getSuppliersInfo(null, internalCompanyId, company, null)).size() == 1) {
                        supplierFromCompany = (SupplierInfo)supplierMap.values().toArray()[0];
                        isSupplierNotNull = true;
                    }
                    isCompanyToCustomerAndProvider = isSupplierNotNull || isCustomerNotNull;
                } else if (isExistsOppCustomer && !isExistsOppProvider && isExistsCfProvider) {
                    Map<String, Object> supplierMap = CashFlowUtils.getSuppliersInfo(null, internalCompanyId, company, null);
                    if (supplierMap.size() == 1) {
                        supplierFromCompany = (SupplierInfo)supplierMap.values().toArray()[0];
                        isCompanyToProvider = true;
                    }
                } else if (isExistsOppProvider && !isExistsOppCustomer && isExistsCfCustomer && (customerMap = CashFlowUtils.getCustomerInfo(null, internalCompanyId, company, null)).size() == 1) {
                    customerFromCompany = (CustomerInfo)customerMap.values().toArray()[0];
                    isCompanyToCustomer = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)"invoke findCustomerAndSupplier error", (Throwable)e);
            }
        }
        AssistantHGInfo defaultAssGrp = new AssistantHGInfo();
        try {
            defaultAssGrp = CashFlowUtils.getDefaultAsstItems(cfiActTypeCols, info.getOppAccount(), info.getVoucher().getCompany() != null ? info.getVoucher().getCompany() : SysContext.getSysContext().getCurrentFIUnit());
        }
        catch (Exception e) {
            logger.error((Object)"CashFlowUtils.getDefaultAsstItems error", (Throwable)e);
        }
        boolean isAllNull = true;
        AssistantHGInfo group = new AssistantHGInfo();
        group.setAsstAccount(cfiTypeGroup);
        CashflowTypeEnum cfType = CashflowTypeEnum.OUT;
        for (int i = 0; i < cfiActTypeCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = cfiActTypeCols[i];
            String key = colInfo.getMappingPropName();
            Object value = assGrp.get(key);
            if ("companyOrg".equals(key)) {
                SupplierInfo supplier;
                Object objSupplier;
                CustomerInfo customer;
                Object objCustomer;
                if (value == null && (objCustomer = assGrp.get("customer")) instanceof CustomerInfo && (customer = (CustomerInfo)objCustomer).getInternalCompany() != null) {
                    value = customer.getInternalCompany();
                }
                if (value == null && (objSupplier = assGrp.get("provider")) instanceof SupplierInfo && (supplier = (SupplierInfo)objSupplier).getInternalCompany() != null) {
                    value = supplier.getInternalCompany();
                }
                if (value != null) {
                    info.setType(CashflowTypeEnum.IN);
                    cfType = CashflowTypeEnum.IN;
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            } else if ("customer".equals(key)) {
                if (value instanceof CustomerInfo) {
                    CustomerInfo customer = (CustomerInfo)value;
                    if (customer.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
                if (value == null && isProviderToCustomer) {
                    if (customerFromBizAnalysisCode.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                }
                if (value == null && (isCompanyToCustomer || isCompanyToCustomerAndProvider)) {
                    info.setType(CashflowTypeEnum.IN);
                    cfType = CashflowTypeEnum.IN;
                }
            } else if ("provider".equals(colInfo.getMappingPropName())) {
                if (value instanceof SupplierInfo) {
                    SupplierInfo supplier = (SupplierInfo)value;
                    if (supplier.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
                if (value == null && isCustomerToProvider) {
                    if (supplierFromBizAnalysisCode.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                }
                if (value == null && (isCompanyToProvider || isCompanyToCustomerAndProvider)) {
                    info.setType(CashflowTypeEnum.IN);
                    cfType = CashflowTypeEnum.IN;
                }
            } else if (!CashflowTypeEnum.IN.equals((Object)info.getType())) {
                info.setType(CashflowTypeEnum.OUT);
            }
            group.put(key, value);
            if (value != null) {
                isAllNull = false;
            }
            if (isCustomerToProvider && key.equals("provider")) {
                group.put(key, (Object)supplierFromBizAnalysisCode);
                if (supplierFromBizAnalysisCode != null) {
                    isAllNull = false;
                }
            }
            if (isProviderToCustomer && key.equals("customer")) {
                group.put(key, (Object)customerFromBizAnalysisCode);
                if (customerFromBizAnalysisCode != null) {
                    isAllNull = false;
                }
            }
            if (isCompanyToCustomer && key.equals("customer")) {
                group.put(key, (Object)customerFromCompany);
                if (customerFromCompany != null) {
                    isAllNull = false;
                }
            }
            if (isCompanyToProvider && key.equals("provider")) {
                group.put(key, (Object)supplierFromCompany);
                if (supplierFromCompany != null) {
                    isAllNull = false;
                }
            }
            if (isCompanyToCustomerAndProvider) {
                if (key.equals("customer")) {
                    group.put(key, (Object)customerFromCompany);
                } else if (key.equals("provider")) {
                    group.put(key, (Object)supplierFromCompany);
                }
                if (supplierFromCompany != null || customerFromCompany != null) {
                    isAllNull = false;
                }
            }
            if (group.get(key) != null || defaultAssGrp.get(key) == null) continue;
            group.put(key, defaultAssGrp.get(key));
            isAllNull = false;
            info.setType(CashflowTypeEnum.OUT);
            if (key.equals("companyOrg")) {
                info.setType(CashflowTypeEnum.IN);
                cfType = CashflowTypeEnum.IN;
            }
            if (key.equals("customer") && ((CustomerInfo)defaultAssGrp.get(key)).getInternalCompany() != null) {
                info.setType(CashflowTypeEnum.IN);
                cfType = CashflowTypeEnum.IN;
            }
            if (!key.equals("provider") || ((SupplierInfo)defaultAssGrp.get(key)).getInternalCompany() == null) continue;
            info.setType(CashflowTypeEnum.IN);
            cfType = CashflowTypeEnum.IN;
        }
        if (cfType.equals((Object)CashflowTypeEnum.IN)) {
            info.setType(CashflowTypeEnum.IN);
        } else {
            info.setType(CashflowTypeEnum.OUT);
        }
        if (isAllNull) {
            info.setAssGrp(null);
        } else {
            try {
                group = VoucherFacadeFactory.getRemoteInstance().confirmAssGrp(group, cfiTypeGroup.getId().toString(), cfiActTypeCols);
                if (group != null) {
                    info.setAssGrp(group);
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            }
            catch (Exception e) {
                info.setType(CashflowTypeEnum.OUT);
                logger.error((Object)"CashflowSplitClient invoke autoSetActTypeValue error", (Throwable)e);
            }
        }
    }

    public static EntityViewInfo getBizAnalysisCodeView(String bizAnalysisCode) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("browseGroup.id"));
        view.getSelector().add(new SelectorItemInfo("browseGroup.displayName"));
        view.getSelector().add(new SelectorItemInfo("internalCompany.longNumber"));
        view.getSelector().add(new SelectorItemInfo("internalCompany.displayName"));
        view.getSelector().add(new SelectorItemInfo("internalCompany.name"));
        view.getSelector().add(new SelectorItemInfo("internalCompany.number"));
        view.getSelector().add(new SelectorItemInfo("internalCompany.isLeaf"));
        view.getSelector().add(new SelectorItemInfo("internalCompany.isBizUnit"));
        view.getSelector().add(new SelectorItemInfo("isInternalCompany"));
        view.getSelector().add(new SelectorItemInfo("bizAnalysisCode.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizAnalysisCode.id", (Object)bizAnalysisCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1));
        view.setFilter(filter);
        return view;
    }

    public static boolean isNeedAssignSupItem(VoucherInfo vch, VoucherEntryInfo entry, CashFlowItemInfo pi) {
        if (entry == null || pi == null) {
            return false;
        }
        boolean isPnL = CashFlowUtils.isPLAccount(vch, entry.getAccount());
        boolean isAct = CashFlowUtils.isCFItemDealActivity(vch, pi);
        return isPnL && !isAct || !isPnL && isAct;
    }

    private static boolean isPLAccount(VoucherInfo vch, AccountViewInfo account) {
        if (account == null || account.getPLType() == AccountPLType.NONE) {
            return false;
        }
        CashFlowAccountDiffCollection actCol = vch.getCashFlowAccountDiffCollection();
        if (actCol == null) {
            return true;
        }
        int size = actCol.size();
        for (int i = 0; i < size; ++i) {
            CashFlowAccountDiffInfo actitem = actCol.get(i);
            if (actitem.getDiffAccount() == null || !account.getNumber().equals(actitem.getDiffAccount().getNumber())) continue;
            return false;
        }
        return true;
    }

    private static boolean isCFItemDealActivity(VoucherInfo vch, CashFlowItemInfo item) {
        if (item == null || !item.isIsDealActivity()) {
            return false;
        }
        CashFlowKeepActivityCollection actCol = vch.getCashFlowKeepActivityCollection();
        if (actCol == null) {
            return true;
        }
        int size = actCol.size();
        for (int i = 0; i < size; ++i) {
            CashFlowKeepActivityInfo actitem = actCol.get(i);
            if (actitem.getConCashFlowItem() == null || !item.getId().toString().equals(actitem.getConCashFlowItem().getId().toString())) continue;
            return false;
        }
        return true;
    }

    public static AssistantHGInfo getDefaultAsstItems(VoucherInfo.DynamicColumnInfo[] cfiItemCols, AccountViewInfo acc, CompanyOrgUnitInfo vchCompany) throws Exception {
        AssistantHGInfo defaultAsstGrp = new AssistantHGInfo();
        BankInfo bank = null;
        AccountBankInfo accountBank = null;
        for (int i = 0; i < cfiItemCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo info = cfiItemCols[i];
            DataBaseInfo data = GlUtils.getDefaultDataBaseInfo(new HashMap(), info.getMappingPropName());
            if (data == null) continue;
            defaultAsstGrp.put(info.getMappingPropName(), (Object)data);
            if ("bankAccount".equalsIgnoreCase(info.getMappingPropName())) {
                accountBank = (AccountBankInfo)data;
            }
            if (!"region".equalsIgnoreCase(info.getMappingPropName())) continue;
            bank = (BankInfo)data;
        }
        if (accountBank != null && bank != null) {
            if (accountBank.getBank() == null) {
                accountBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId()));
            }
            if (!accountBank.getBank().getId().equals((Object)bank.getId())) {
                defaultAsstGrp.remove("region");
            }
        }
        try {
            AssistantHGInfo defaultHG = (AssistantHGInfo)VoucherHelpFacadeFactory.getRemoteInstance().getDefaultAssistantHgInfo((IObjectPK)new ObjectUuidPK(acc.getId()), null);
            if (defaultHG != null) {
                for (int i = 0; i < cfiItemCols.length; ++i) {
                    DataBaseInfo data;
                    VoucherInfo.DynamicColumnInfo info = cfiItemCols[i];
                    if (defaultAsstGrp.get(info.getMappingPropName()) != null) continue;
                    String key = cfiItemCols[i].getMappingPropName();
                    ObjectBaseInfo dbInfo = (ObjectBaseInfo)defaultHG.get(key);
                    if (dbInfo != null) {
                        defaultAsstGrp.put(info.getMappingPropName(), (Object)dbInfo);
                        continue;
                    }
                    IAsstActTypeDefault def = AsstActTypeDefaultFactory.getRemoteInstance();
                    if (defaultAsstGrp.get(info.getMappingPropName()) != null) continue;
                    AsstActTypeInfo type = new AsstActTypeInfo();
                    type.setAsstHGAttribute(info.getMappingPropName());
                    type.setId(info.getId());
                    type.setName(info.getColName());
                    AsstActTypeDefaultInfo defalt = (AsstActTypeDefaultInfo)def.getDefaultAcctItem(vchCompany.getId().toString(), (IObjectValue)type);
                    if (defalt.getDefaultId() == null || (data = GlUtils.findAsstActObject(info.getMappingPropName(), defalt.getDefaultId().toString())) == null) continue;
                    defaultAsstGrp.put(info.getMappingPropName(), (Object)data);
                }
            } else {
                IAsstActTypeDefault def = AsstActTypeDefaultFactory.getRemoteInstance();
                for (int i = 0; i < cfiItemCols.length; ++i) {
                    VoucherInfo.DynamicColumnInfo info = cfiItemCols[i];
                    if (defaultAsstGrp.get(info.getMappingPropName()) != null) continue;
                    AsstActTypeInfo type = new AsstActTypeInfo();
                    type.setAsstHGAttribute(info.getMappingPropName());
                    type.setId(info.getId());
                    type.setName(info.getColName());
                    AsstActTypeDefaultInfo defalt = (AsstActTypeDefaultInfo)def.getDefaultAcctItem(vchCompany.getId().toString(), (IObjectValue)type);
                    if (defalt.getDefaultId() == null) continue;
                    DataBaseInfo data = GlUtils.findAsstActObject(info.getMappingPropName(), defalt.getDefaultId().toString());
                    if (data instanceof GeneralAsstActTypeInfo) {
                        GeneralAsstActTypeInfo asst = (GeneralAsstActTypeInfo)data;
                        data.setString("displayLongNumber", asst.getLongNumber().replace("!", "."));
                    }
                    if (data == null) continue;
                    defaultAsstGrp.put(info.getMappingPropName(), (Object)data);
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"379_VoucherEditBaseUI"), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"379_VoucherEditBaseUI"), (Throwable)e);
        }
        return defaultAsstGrp;
    }

    public static boolean isOppAccountActivity(CashflowRecordInfo record) {
        return record != null && record.getOppAccount() != null && record.getOppAccount().getAccountTypeID() != null && AccountProperty.SUNYI.equals((Object)record.getOppAccount().getAccountTypeID().getProperty());
    }

    public static Map getCashflowItems(CashflowRecordCollection cashflowRecords) {
        if (cashflowRecords != null && cashflowRecords.size() > 0) {
            HashSet<String> itemIdSet = new HashSet<String>();
            HashSet<String> freezeItemIDSet = new HashSet<String>();
            CashFlowItemCollection freezeItems = new CashFlowItemCollection();
            int size = cashflowRecords.size();
            for (int i = 0; i < size; ++i) {
                CashflowRecordInfo cfRecord = cashflowRecords.get(i);
                if (cfRecord == null) continue;
                if (cfRecord.getPrimaryItem() != null) {
                    if (cfRecord.getPrimaryItem().isIsFreeze()) {
                        if (!freezeItemIDSet.contains(cfRecord.getPrimaryItem().getId().toString())) {
                            freezeItemIDSet.add(cfRecord.getPrimaryItem().getId().toString());
                            freezeItems.add(cfRecord.getPrimaryItem());
                        }
                    } else {
                        itemIdSet.add(cfRecord.getPrimaryItem().getId().toString());
                    }
                }
                if (cfRecord.getSupplementaryItem() != null) {
                    if (cfRecord.getSupplementaryItem().isIsFreeze()) {
                        if (!freezeItemIDSet.contains(cfRecord.getSupplementaryItem().getId().toString())) {
                            freezeItemIDSet.add(cfRecord.getSupplementaryItem().getId().toString());
                            freezeItems.add(cfRecord.getSupplementaryItem());
                        }
                    } else {
                        itemIdSet.add(cfRecord.getSupplementaryItem().getId().toString());
                    }
                }
                if (cfRecord.getFullInfoItem() == null) continue;
                if (cfRecord.getFullInfoItem().isIsFreeze()) {
                    if (freezeItemIDSet.contains(cfRecord.getFullInfoItem().getId().toString())) continue;
                    freezeItemIDSet.add(cfRecord.getFullInfoItem().getId().toString());
                    freezeItems.add(cfRecord.getFullInfoItem());
                    continue;
                }
                itemIdSet.add(cfRecord.getFullInfoItem().getId().toString());
            }
            List<Object> itemIdList = new ArrayList();
            itemIdList = Arrays.asList(itemIdSet.toArray());
            HashMap rtnValue = new HashMap();
            rtnValue.put("itemIdList", itemIdList);
            rtnValue.put("freezeItems", freezeItems);
            return rtnValue;
        }
        return null;
    }

    public static String checkCashflowItemView(Context ctx, String CUid, Map itemIdMap) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)CUid) && itemIdMap != null && itemIdMap.size() > 0) {
            List itemIdList = (List)itemIdMap.get("itemIdList");
            CashFlowItemCollection freezeItems = (CashFlowItemCollection)itemIdMap.get("freezeItems");
            CashFlowItemCollection noRightViewItems = new CashFlowItemCollection();
            if (itemIdList != null && itemIdList.size() > 0) {
                noRightViewItems = ctx == null ? CashFlowItemViewFactory.getRemoteInstance().checkCashFlowItemView(itemIdList, CUid) : CashFlowItemViewFactory.getLocalInstance((Context)ctx).checkCashFlowItemView(itemIdList, CUid);
            }
            freezeItems.addCollection(noRightViewItems);
            if (freezeItems.size() > 0) {
                StringBuffer msg = new StringBuffer();
                int size = freezeItems.size();
                for (int i = 0; i < size; ++i) {
                    CashFlowItemInfo item = freezeItems.get(i);
                    if (i > 0) {
                        msg.append(", ");
                    }
                    msg.append(item.getNumber()).append(" (").append(item.getName()).append(")");
                }
                return msg.toString();
            }
        }
        return "";
    }

    public static boolean isContainsDAPCashflowItems(VoucherEntryInfo voucherEntryInfo) {
        if (voucherEntryInfo == null) {
            return false;
        }
        if (voucherEntryInfo.getPrimaryItem() != null || voucherEntryInfo.getSupplementaryItem() != null) {
            return true;
        }
        if (voucherEntryInfo.getAssistRecords() != null && voucherEntryInfo.getAssistRecords().size() > 0) {
            int size = voucherEntryInfo.getAssistRecords().size();
            for (int i = 0; i < size; ++i) {
                if (voucherEntryInfo.getAssistRecords().get(i).getPrimaryItem() == null && voucherEntryInfo.getAssistRecords().get(i).getSupplementaryItem() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllZero4CashOrPLAccount(VoucherInfo voucher, CashflowFlag cfFlag) {
        int count = voucher.getEntries().size();
        if (CashflowFlag.ONLY_CASHACCOUNT.equals((Object)cfFlag) || CashflowFlag.ONLY_PNLACCOUNT.equals((Object)cfFlag) || CashflowFlag.BOTH_CASH_AND_PNL.equals((Object)cfFlag)) {
            for (int i = 0; i < count; ++i) {
                VoucherEntryInfo entry = voucher.getEntries().get(i);
                AccountViewInfo account = entry.getAccount();
                if (account == null || AccountCategoryEnum.BUDGET.equals((Object)account.getCategory())) continue;
                if ((account.isIsCash() || account.isIsBank() || account.isIsCashEquivalent()) && entry.getLocalAmount().compareTo(GlUtils.zero) != 0) {
                    return false;
                }
                if (account.getAccountTypeID() == null || !AccountProperty.SUNYI.equals((Object)account.getAccountTypeID().getProperty()) || !CashFlowUtils.isShowSI(voucher, account.getNumber()) || entry.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static FilterInfo getDFilterInfoForStandImp(IDataBaseD iDaba, String cuid) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(cuid);
        if (iDaba instanceof ISupplier) {
            return iDaba.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        return iDaba.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
    }

    public static Map<String, Object> getCustomerInfo(Context ctx, String internalCompanyId, CompanyOrgUnitInfo company, String pKey) throws Exception {
        HashMap<String, Object> asstActs = new HashMap<String, Object>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isInternalCompany");
        selector.add("browseGroup.id");
        selector.add("browseGroup.displayName");
        selector.add("internalCompany.longNumber");
        selector.add("internalCompany.displayName");
        selector.add("internalCompany.name");
        selector.add("internalCompany.number");
        selector.add("internalCompany.isLeaf");
        selector.add("internalCompany.isBizUnit");
        selector.add("bizAnalysisCode.id");
        selector.add("usedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("internalCompany.id", (Object)internalCompanyId, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("usedstatus", (Object)1));
        FilterInfo Dfilter = null;
        Dfilter = ctx == null ? CashFlowUtils.getDFilterInfoForStandImp((IDataBaseD)CustomerFactory.getRemoteInstance(), company.getCU().getId().toString()) : CashFlowUtils.getDFilterInfoForStandImp((IDataBaseD)CustomerFactory.getLocalInstance((Context)ctx), company.getCU().getId().toString());
        if (Dfilter != null) {
            filter.mergeFilter(Dfilter, "and");
        }
        CustomerCollection coll = null;
        coll = ctx == null ? CustomerFactory.getRemoteInstance().getCustomerCollection(view) : CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
        if (coll == null || coll.size() == 0) {
            return asstActs;
        }
        HashMap<String, CustomerInfo> aas = new HashMap<String, CustomerInfo>();
        HashSet<String> existAsstActIds = new HashSet<String>();
        for (CustomerInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
            existAsstActIds.add(aa.getId().toString());
        }
        if (existAsstActIds.size() > 0) {
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("usingStatus");
            selector.add("effectedStatus");
            selector.add("customer.id");
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("customer.id", existAsstActIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
            CustomerCompanyInfoCollection cColl = null;
            cColl = ctx == null ? CustomerCompanyInfoFactory.getRemoteInstance().getCustomerCompanyInfoCollection(view) : CustomerCompanyInfoFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfoCollection(view);
            if (cColl == null || cColl.size() == 0) {
                return asstActs;
            }
            HashMap<String, CustomerCompanyInfoInfo> aacs = new HashMap<String, CustomerCompanyInfoInfo>();
            for (CustomerCompanyInfoInfo aac : cColl) {
                aacs.put(aac.getCustomer().getId().toString(), aac);
            }
            for (String asstActId : existAsstActIds) {
                String key = pKey + asstActId;
                CustomerInfo aa = (CustomerInfo)aas.get(asstActId);
                CustomerCompanyInfoInfo aac = (CustomerCompanyInfoInfo)aacs.get(asstActId);
                if (aac == null || UsingStatusEnum.FREEZED.equals((Object)aac.getUsingStatus()) || !EffectedStatusEnum.EFFECTED.equals((Object)aac.getEffectedStatus())) continue;
                asstActs.put(key, aa);
            }
        }
        return asstActs;
    }

    public static Map<String, Object> getSuppliersInfo(Context ctx, String internalCompanyId, CompanyOrgUnitInfo company, String pKey) throws Exception {
        HashMap<String, Object> asstActs = new HashMap<String, Object>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isInternalCompany");
        selector.add("browseGroup.id");
        selector.add("browseGroup.displayName");
        selector.add("internalCompany.longNumber");
        selector.add("internalCompany.displayName");
        selector.add("internalCompany.name");
        selector.add("internalCompany.number");
        selector.add("internalCompany.isLeaf");
        selector.add("internalCompany.isBizUnit");
        selector.add("bizAnalysisCode.id");
        selector.add("usedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("internalCompany.id", (Object)internalCompanyId, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("usedstatus", (Object)1));
        FilterInfo Dfilter = null;
        Dfilter = ctx == null ? CashFlowUtils.getDFilterInfoForStandImp((IDataBaseD)SupplierFactory.getRemoteInstance(), company.getCU().getId().toString()) : CashFlowUtils.getDFilterInfoForStandImp((IDataBaseD)SupplierFactory.getLocalInstance((Context)ctx), company.getCU().getId().toString());
        if (Dfilter != null) {
            filter.mergeFilter(Dfilter, "and");
        }
        SupplierCollection coll = null;
        coll = ctx == null ? SupplierFactory.getRemoteInstance().getSupplierCollection(view) : SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
        if (coll == null || coll.size() == 0) {
            return asstActs;
        }
        HashMap<String, SupplierInfo> aas = new HashMap<String, SupplierInfo>();
        HashSet<String> existAsstActIds = new HashSet<String>();
        for (SupplierInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
            existAsstActIds.add(aa.getId().toString());
        }
        if (existAsstActIds.size() > 0) {
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("usedStatus");
            selector.add("usingStatus");
            selector.add("effectedStatus");
            selector.add("supplier.id");
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", existAsstActIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
            SupplierCompanyInfoCollection cColl = null;
            cColl = ctx == null ? SupplierCompanyInfoFactory.getRemoteInstance().getSupplierCompanyInfoCollection(view) : SupplierCompanyInfoFactory.getLocalInstance((Context)ctx).getSupplierCompanyInfoCollection(view);
            if (cColl == null || cColl.size() == 0) {
                return asstActs;
            }
            HashMap<String, SupplierCompanyInfoInfo> aacs = new HashMap<String, SupplierCompanyInfoInfo>();
            for (SupplierCompanyInfoInfo aac : cColl) {
                aacs.put(aac.getSupplier().getId().toString(), aac);
            }
            for (String asstActId : existAsstActIds) {
                String key = pKey + asstActId;
                SupplierInfo aa = (SupplierInfo)aas.get(asstActId);
                SupplierCompanyInfoInfo aac = (SupplierCompanyInfoInfo)aacs.get(asstActId);
                if (aac == null || UsingStatusEnum.FREEZED.equals((Object)aac.getUsingStatus()) || !EffectedStatusEnum.EFFECTED.equals((Object)aac.getEffectedStatus())) continue;
                asstActs.put(key, aa);
            }
        }
        return asstActs;
    }

    public static Object getCustomerOrSupplier(Context ctx, String internalCompanyId, String bizAnalysisCodeId, String name) throws Exception {
        if (bizAnalysisCodeId != null) {
            EntityViewInfo view = CashFlowUtils.getBizAnalysisCodeView(bizAnalysisCodeId);
            if ("customer".equals(name)) {
                CustomerCollection customers = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
                if (customers.size() == 1) {
                    return customers.get(0);
                }
            } else {
                SupplierCollection supplier = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
                if (supplier.size() == 1) {
                    return supplier.get(0);
                }
            }
        } else if (internalCompanyId != null) {
            Map<String, Object> map;
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
            Map<String, Object> map2 = map = "customer".equals(name) ? CashFlowUtils.getCustomerInfo(ctx, internalCompanyId, company, null) : CashFlowUtils.getSuppliersInfo(ctx, internalCompanyId, company, null);
            if (map.size() == 1) {
                return map.values().toArray()[0];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getBothNotExsitVoucherIds(Context ctx, String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate) throws Exception {
        Connection conn;
        HashSet<String> idSet;
        block6: {
            String tempTable = null;
            idSet = new HashSet<String>();
            conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                tempTable = CashFlowUtils.creatVocuherIDTable(ctx, conn, companyId, includeNoPostedVoucher, queryByPeriod, startPeriod, endPeriod, startDate, endDate);
                StringBuffer selectSql = new StringBuffer();
                selectSql.append("\tselect t1.fid\r\n");
                selectSql.append("  from (select v.fid\r\n");
                selectSql.append("\tfrom " + tempTable + " v\r\n");
                selectSql.append("\tleft join t_gl_cashflowrecord cf on  v.fid = cf.FVOUCHERID\r\n");
                selectSql.append("\twhere cf.fid is null) t1\r\n");
                selectSql.append("\tinner join (select v.fid\r\n");
                selectSql.append("\tfrom " + tempTable + " v\r\n");
                selectSql.append("\tleft join t_gl_cashflowsplitrecord cfs on v.fid = cfs.FVOUCHERID \r\n");
                selectSql.append("\twhere cfs.fid is null) t2\r\n");
                selectSql.append("\ton t1.fid = t2.fid\r\n");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                while (rs.next()) {
                    idSet.add(rs.getString("fid"));
                }
                if (tempTable == null) break block6;
            }
            catch (Throwable throwable) {
                if (tempTable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                }
                if (conn != null) {
                    conn.close();
                }
                throw throwable;
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        if (conn != null) {
            conn.close();
        }
        return idSet;
    }

    public static String creatVocuherIDTable(Context ctx, Connection conn, String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate) throws Exception {
        List<Object> periodIdList = new ArrayList();
        if (queryByPeriod) {
            periodIdList = CashFlowUtils.getPeriodIdByNumberRange(ctx, companyId, startPeriod, endPeriod);
        }
        String tempTable = "tempTable_vchID";
        SqlParams sp = new SqlParams();
        StringBuffer sql = new StringBuffer();
        sql.append("\tselect t1.fid fid\r\n");
        sql.append("\tfrom (select v.fid,v.fentrycount entrycount, \r\n");
        sql.append("    sum(case when (av.fisCash = 1 or av.fisBank = 1 or av.fisCashEquivalent = 1) then 1  else 0 end) cashentrycount,\r\n");
        sql.append("\tsum(case when (actype.fproperty = 4) then 1 else 0 end) plentrycount \r\n");
        sql.append("\tfrom T_GL_voucher v \r\n");
        sql.append("\tinner join t_gl_voucherentry ve on ve.fbillid = v.fid \r\n");
        sql.append("\tinner join t_bd_accountview av on av.fid = ve.faccountid \r\n");
        sql.append("\tinner join t_bd_accounttype actype on actype.fid = av.faccounttypeid \r\n");
        sql.append("\twhere v.fcompanyid=? and av.fcompanyid=? \r\n");
        sp.addString(companyId);
        sp.addString(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod && periodIdList.size() > 0) {
            String periodIdIn = CashFlowUtils.buildIn(periodIdList);
            sql.append("   and v.fperiodid in ").append(periodIdIn).append("\r\n");
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            sp.addDate(startDate);
            sp.addDate(endDate);
        }
        sql.append("\tand v.fsourcetype <> 1 and v.fsourcetype <> 7 --and v.fcategory <> 2 \r\n");
        sql.append("\tgroup by v.fid, v.fentrycount ) t1\r\n");
        sql.append("\twhere (t1.cashentrycount <> 0 or t1.plentrycount <> 0) and t1.entrycount <> t1.cashentrycount and t1.entrycount <> t1.plentrycount \r\n");
        tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)("select * into " + tempTable + " from (" + sql.toString() + ") as tempTable "), (SqlParams)sp, (Connection)conn).getTempTable();
        return tempTable;
    }

    public static Set<String> getEntryIdIsNullOrNotExsitVchIds(Context ctx, String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            ArrayList<Object> sp = new ArrayList<Object>();
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct v.fid from T_GL_voucher v inner join t_bd_period p on p.fid = v.fperiodid inner join t_gl_cashflowrecord cf on v.fid = cf.FVOUCHERID\r\n");
            sql.append("where v.fcompanyid = ? \r\n");
            sp.add(companyId);
            if (includeNoPostedVoucher) {
                sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
            } else {
                sql.append("\t\t      and v.fbizstatus =5 \r\n");
            }
            if (queryByPeriod) {
                sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
                sp.add(startPeriod);
                sp.add(endPeriod);
            } else {
                sql.append("              and v.FBookedDate >= ? \r\n");
                sql.append("              and v.FBookedDate <= ? \r\n");
                sp.add(startDate);
                sp.add(endDate);
            }
            sql.append("and (cf.FENTRYID is null or cf.FOPPOSINGACCOUNTENTRYID is null or cf.FACCOUNTID is null or cf.FOPPACCOUNTID is null) and cf.FItemFlag <> 5\r\n");
            sql.append("\tunion \r\n");
            sql.append("    select distinct v.fid \r\n");
            sql.append("\tfrom T_GL_voucher v inner join t_bd_period p on p.fid = v.fperiodid inner join t_gl_cashflowrecord cf on v.fid = cf.FVOUCHERID \r\n");
            sql.append("    where v.fcompanyid = ? \r\n");
            sp.add(companyId);
            if (includeNoPostedVoucher) {
                sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
            } else {
                sql.append("\t\t      and v.fbizstatus =5 \r\n");
            }
            if (queryByPeriod) {
                sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
                sp.add(startPeriod);
                sp.add(endPeriod);
            } else {
                sql.append("              and v.FBookedDate >= ? \r\n");
                sql.append("              and v.FBookedDate <= ? \r\n");
                sp.add(startDate);
                sp.add(endDate);
            }
            sql.append("and cf.FItemFlag <> 5 \r\n");
            sql.append("and (not exists (select ve.fid from t_gl_voucherentry ve where cf.FENTRYID = ve.fid)\n           or  not exists (select ve.fid from t_gl_voucherentry ve where cf.FOPPOSINGACCOUNTENTRYID = ve.fid))\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sp.toArray());
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
        return idSet;
    }

    public static Set<String> getAccountErrorVchIds(Context ctx, String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            ArrayList<Object> sp = new ArrayList<Object>();
            StringBuffer sql = new StringBuffer();
            sql.append(" select distinct v.fid from T_GL_voucher v inner join t_bd_period p on p.fid = v.fperiodid \r\n");
            sql.append("\tinner join t_gl_cashflowrecord cf on v.fid = cf.fvoucherid inner join t_bd_accountview av ON cf.FACCOUNTID = AV.FID  \r\n");
            sql.append("    where v.fcompanyid = ? \r\n");
            sp.add(companyId);
            if (includeNoPostedVoucher) {
                sql.append("\tand v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
            } else {
                sql.append("\tand v.fbizstatus =5 \r\n");
            }
            if (queryByPeriod) {
                sql.append("\tand p.fnumber >= ? and p.fnumber <= ? \r\n");
                sp.add(startPeriod);
                sp.add(endPeriod);
            } else {
                sql.append("\tand v.FBookedDate >= ? \r\n");
                sql.append("\tand v.FBookedDate <= ? \r\n");
                sp.add(startDate);
                sp.add(endDate);
            }
            sql.append("\tand av.FISBANK = 0 and av.FISCASH = 0 and av.FISCASHEQUIVALENT = 0 and cf.FPRIMARYITEMID is not null and cf.Fitemflag in (1, 3)\r\n");
            sql.append("union \r\n");
            sql.append("    select distinct v.fid from T_GL_voucher v inner join t_bd_period p on p.fid = v.fperiodid inner join t_gl_cashflowrecord cf \r\n");
            sql.append("\ton v.fid = cf.fvoucherid inner join t_bd_accountview av ON cf.FACCOUNTID = AV.FID  \r\n");
            sql.append("\tinner join t_bd_accounttype actype on actype.fid = av.faccounttypeid \r\n");
            sql.append("\twhere v.fcompanyid = ? \r\n");
            sp.add(companyId);
            if (includeNoPostedVoucher) {
                sql.append("\tand v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
            } else {
                sql.append("\tand v.fbizstatus =5 \r\n");
            }
            if (queryByPeriod) {
                sql.append("\tand p.fnumber >= ? and p.fnumber <= ? \r\n");
                sp.add(startPeriod);
                sp.add(endPeriod);
            } else {
                sql.append("\tand v.FBookedDate >= ? \r\n");
                sql.append("\tand v.FBookedDate <= ? \r\n");
                sp.add(startDate);
                sp.add(endDate);
            }
            sql.append("\tand actype.fproperty <> 4 and cf.FSUPPLEMENTARYITEMID is not null and cf.Fitemflag = 2\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sp.toArray());
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
        return idSet;
    }

    public static Set<String> getCFAmountNotEqualVchIds(Context ctx, String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select fbasecurrencyid,FREPORTCURRENCYID from t_org_company where fid = ?");
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId});
            String fbasecurrencyid = null;
            String freportcurrencyid = null;
            if (rs1.next()) {
                fbasecurrencyid = rs1.getString("fbasecurrencyid");
                freportcurrencyid = rs1.getString("FREPORTCURRENCYID");
            }
            GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])new String[]{"G001"}, (String)companyId);
            boolean useReportingCurrency = glParam.getBoolean("G001");
            sql = new StringBuffer();
            ArrayList<Object> sp = new ArrayList<Object>();
            sql.append("select  v.fid   from T_GL_voucher v inner join t_bd_period p on p.fid = v.fperiodid  \r\n");
            sql.append("\tinner join t_gl_voucherentry ve on ve.fbillid = v.fid \r\n");
            sql.append("\tinner join t_gl_cashflowrecord cf on ve.fid = cf.fentryid \r\n");
            sql.append("    where v.fcompanyid = ? \r\n");
            sp.add(companyId);
            if (includeNoPostedVoucher) {
                sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
            } else {
                sql.append("\t\t      and v.fbizstatus =5 \r\n");
            }
            if (queryByPeriod) {
                sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
                sp.add(startPeriod);
                sp.add(endPeriod);
            } else {
                sql.append("              and v.FBookedDate >= ? \r\n");
                sql.append("              and v.FBookedDate <= ? \r\n");
                sp.add(startDate);
                sp.add(endDate);
            }
            if (!useReportingCurrency) {
                sql.append(" \tand ve.fcurrencyid = ? --\u672c\u4f4d\u5e01 \r\n");
                sp.add(fbasecurrencyid);
                sql.append("\tand cf.FORIGINALAMOUNT <> cf.FLOCALAMOUNT \r\n");
            } else {
                sql.append(" \tand ((ve.fcurrencyid = ? and cf.FORIGINALAMOUNT <> cf.FLOCALAMOUNT)   \r\n");
                sp.add(fbasecurrencyid);
                sql.append(" \tor (ve.fcurrencyid = ?   and cf.FORIGINALAMOUNT <> cf.FREPORTINGAMOUNT)) \r\n");
                sp.add(freportcurrencyid);
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sp.toArray());
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return idSet;
    }

    public static Set<String> getoppAcountErrorVchIds(Context ctx, String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            ArrayList<Object> sp = new ArrayList<Object>();
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct v.fid from t_gl_voucher v inner join t_bd_period p on p.fid = v.fperiodid inner join t_gl_voucherentry ve on v.fid = ve.fbillid \r\n");
            sql.append("inner join t_gl_cashflowrecord cf on cf.FOPPOSINGACCOUNTENTRYID = ve.fid \r\n");
            sql.append("    where v.fcompanyid = ? \r\n");
            sp.add(companyId);
            if (includeNoPostedVoucher) {
                sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
            } else {
                sql.append("\t\t      and v.fbizstatus =5 \r\n");
            }
            if (queryByPeriod) {
                sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
                sp.add(startPeriod);
                sp.add(endPeriod);
            } else {
                sql.append("              and v.FBookedDate >= ? \r\n");
                sql.append("              and v.FBookedDate <= ? \r\n");
                sp.add(startDate);
                sp.add(endDate);
            }
            sql.append(" \tand  ve.faccountid <> cf.FOPPACCOUNTID; \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sp.toArray());
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
        return idSet;
    }

    public static boolean isAllDisposeCashRecord(CashflowRecordCollection cashflowRecords) {
        if (cashflowRecords != null && cashflowRecords.size() > 0) {
            int disposeCount = 0;
            for (int i = 0; i < cashflowRecords.size(); ++i) {
                if (!ItemFlag.DISPOSE.equals((Object)cashflowRecords.get(i).getItemFlag())) continue;
                ++disposeCount;
            }
            return disposeCount == cashflowRecords.size();
        }
        return false;
    }

    public static List<String> getPeriodIdByNumberRange(Context ctx, String companyIds, Integer startPeriod, Integer endPeriod) throws BOSException {
        StringBuffer periodSql = new StringBuffer();
        if (!companyIds.contains("'")) {
            companyIds = "'" + companyIds + "'";
        }
        periodSql.append("select p.fid fid");
        periodSql.append(" from t_bd_period p");
        periodSql.append(" left join t_org_company c on c.faccountperiodid = p.ftypeid");
        periodSql.append(" where p.fnumber >= ? and p.fnumber <= ? and c.fid in (" + companyIds + ") ");
        periodSql.append(" order by p.fnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)periodSql.toString(), (Object[])new Object[]{startPeriod, endPeriod});
        ArrayList<String> periodIdList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("fid");
                if (periodIdList.contains(id)) continue;
                periodIdList.add(id);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return periodIdList;
    }

    public static String buildIn(List<String> idList) {
        StringBuffer where = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            if (i == 0) {
                where.append("(");
            } else {
                where.append(", ");
            }
            where.append("'").append(idList.get(i)).append("'");
            if (i != idList.size() - 1) continue;
            where.append(")");
        }
        return where.toString();
    }
}

