/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.master.account.AccountDiffType;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.DiffItemCollection;
import com.kingdee.eas.fi.gl.DiffItemFactory;
import com.kingdee.eas.fi.gl.DiffItemInfo;
import com.kingdee.eas.fi.gl.DiffItemMappingFactory;
import com.kingdee.eas.fi.gl.DiffItemMappingInfo;
import com.kingdee.eas.fi.gl.DiffType;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DiffItemMappingImport
extends AbstractDataTransmission {
    private static final String RESOURCE = "com.kingdee.eas.fi.gl.DiffItemResource";
    private Map<String, CompanyOrgUnitInfo> companys = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, AccountViewInfo> accounts = new HashMap<String, AccountViewInfo>();
    private Map<String, DiffItemInfo> diffItems = new HashMap<String, DiffItemInfo>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return DiffItemMappingFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("diffItemMapping", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        DiffItemMappingInfo mapping = new DiffItemMappingInfo();
        try {
            String strDiffAccount;
            String strDiffType;
            Object object = hsData.get("FCompany");
            String strCompany = object == null || object.toString().trim().length() == 0 ? ContextUtil.getCurrentFIUnit((Context)ctx).getNumber() : object.toString().trim();
            CompanyOrgUnitInfo company = this.getCompany(ctx, strCompany);
            if (company == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"Company_NotExist", (Locale)ctx.getLocale(), (Object[])new Object[]{strCompany}));
            }
            if (!company.isIsBizUnit()) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"Company_NotBizUnit", (Locale)ctx.getLocale(), (Object[])new Object[]{strCompany}));
            }
            if (company.getAccountTable() == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"Company_NoAccountTable", (Locale)ctx.getLocale(), (Object[])new Object[]{strCompany}));
            }
            DiffType diffType = null;
            object = hsData.get("FDiffType");
            if (object != null && (strDiffType = object.toString().trim()).length() > 0) {
                if ("11".equals(strDiffType)) {
                    diffType = DiffType.FINANCE_INCOME;
                } else if ("12".equals(strDiffType)) {
                    diffType = DiffType.FINANCE_EXPENSE;
                } else if ("21".equals(strDiffType)) {
                    diffType = DiffType.BUDGET_INCOME;
                } else if ("22".equals(strDiffType)) {
                    diffType = DiffType.BUDGET_EXPENSE;
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"DiffType_InputError", (Locale)ctx.getLocale(), (Object[])new Object[]{strDiffType}));
                }
            }
            AccountViewInfo diffAccount = null;
            object = hsData.get("FDiffAccount");
            if (object != null && (strDiffAccount = object.toString().trim()).length() > 0) {
                diffAccount = this.getAccount(ctx, company, strDiffAccount);
                if (diffAccount == null) {
                    throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"Account_NotExist", (Locale)ctx.getLocale(), (Object[])new Object[]{strDiffAccount}));
                }
                if (!diffAccount.isIsLeaf()) {
                    throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"Account_NotLeaf", (Locale)ctx.getLocale(), (Object[])new Object[]{strDiffAccount}));
                }
                if (!AccountDiffType.INCOME.equals((Object)diffAccount.getDiffType()) && !AccountDiffType.EXPENSE.equals((Object)diffAccount.getDiffType())) {
                    throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"Account_NotInEx", (Locale)ctx.getLocale(), (Object[])new Object[]{strDiffAccount}));
                }
            }
            if ((object = hsData.get("FCheckAccount")) == null || object.toString().trim().length() == 0) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"CheckAccount_CanNotEmpty", (Locale)ctx.getLocale()));
            }
            String strCheckAccount = object.toString().trim();
            AccountViewInfo checkAccount = this.getAccount(ctx, company, strCheckAccount);
            if (checkAccount == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"Account_NotExist", (Locale)ctx.getLocale(), (Object[])new Object[]{strCheckAccount}));
            }
            if (!checkAccount.isIsLeaf()) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"Account_NotLeaf", (Locale)ctx.getLocale(), (Object[])new Object[]{strCheckAccount}));
            }
            if (checkAccount.isIsBank() || checkAccount.isIsCash() || checkAccount.isIsCashEquivalent()) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"BankAccount_CanNotBeCheck", (Locale)ctx.getLocale()));
            }
            if (AccountCategoryEnum.BUDGET.equals((Object)checkAccount.getCategory())) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"BudgetAccount_CanNotBeCheck", (Locale)ctx.getLocale()));
            }
            if (AccountDiffType.INCOME.equals((Object)checkAccount.getDiffType()) && AccountDiffType.EXPENSE.equals((Object)checkAccount.getDiffType())) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"InExAccount_CanNotBeCheck", (Locale)ctx.getLocale()));
            }
            object = hsData.get("FDiffItem");
            if (object == null || object.toString().trim().length() == 0) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"DiffItem_CanNotEmpty", (Locale)ctx.getLocale()));
            }
            String strDiffItem = object.toString().trim();
            DiffItemInfo diffItem = this.getDiffItem(ctx, strDiffItem);
            if (diffItem == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"DiffItem_NotExist", (Locale)ctx.getLocale(), (Object[])new Object[]{strDiffItem}));
            }
            if (!diffItem.isIsLeaf()) {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"DiffItem_NotLeaf", (Locale)ctx.getLocale(), (Object[])new Object[]{strDiffItem}));
            }
            if (diffAccount != null) {
                diffType = this.getDiffType(diffAccount);
                if (!this.isMatch(diffType, diffItem)) {
                    throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"DiffAccountDiffItem_NotMatch", (Locale)ctx.getLocale(), (Object[])new Object[]{diffAccount.getNumber(), strDiffItem}));
                }
                String sql = "select FID, FDiffItemID from T_GL_DiffItemMapping where FCheckAccountID = ? and FDiffAccountID = ?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{checkAccount.getId().toString(), diffAccount.getId().toString()});
                if (rs.next()) {
                    if (!this.isSltImportUpdate()) {
                        throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"DiffAccountCheckAccount_Exist", (Locale)ctx.getLocale(), (Object[])new Object[]{diffAccount.getNumber(), checkAccount.getNumber()}));
                    }
                    mapping.setId(BOSUuid.read((String)rs.getString("FID")));
                    if (diffItem.getId().toString().equals(rs.getString("FDiffItemID"))) {
                        mapping.put("ignore", "true");
                    }
                }
            } else if (diffType != null) {
                if (!this.isMatch(diffType, diffItem)) {
                    throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"DiffTypeDiffItem_NotMatch", (Locale)ctx.getLocale(), (Object[])new Object[]{String.valueOf(diffType.getValue()), strDiffItem}));
                }
                String sql = "select FID, FDiffItemID from T_GL_DiffItemMapping where FCheckAccountID = ? and FDiffType = ? and FDiffAccountID is null";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{checkAccount.getId().toString(), diffType.getValue()});
                if (rs.next()) {
                    if (!this.isSltImportUpdate()) {
                        throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"DiffTypeCheckAccount_Exist", (Locale)ctx.getLocale(), (Object[])new Object[]{String.valueOf(diffType.getValue()), checkAccount.getNumber()}));
                    }
                    mapping.setId(BOSUuid.read((String)rs.getString("FID")));
                    if (diffItem.getId().toString().equals(rs.getString("FDiffItemID"))) {
                        mapping.put("ignore", "true");
                    }
                }
            } else {
                throw new TaskExternalException(ResourceBase.getString((String)RESOURCE, (String)"DiffTypeDiffAccount_CanNotEmpty", (Locale)ctx.getLocale()));
            }
            mapping.setDiffType(diffType);
            mapping.setDiffAccount(diffAccount);
            mapping.setCheckAccount(checkAccount);
            mapping.setDiffItem(diffItem);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return mapping;
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, String number) throws BOSException, TaskExternalException {
        if (this.companys.containsKey(number)) {
            return this.companys.get(number);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isBizUnit");
        selector.add("accountTable.id");
        view.setSelector(selector);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        CompanyOrgUnitInfo company = null;
        if (coll.size() > 0) {
            company = coll.get(0);
        }
        this.companys.put(number, company);
        return company;
    }

    private AccountViewInfo getAccount(Context ctx, CompanyOrgUnitInfo company, String number) throws BOSException {
        String key = company.getId().toString() + "_" + number;
        if (this.accounts.containsKey(key)) {
            return this.accounts.get(key);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isLeaf");
        selector.add("category");
        selector.add("diffType");
        selector.add("isBank");
        selector.add("isCash");
        selector.add("isCashEquivalent");
        view.setSelector(selector);
        AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        AccountViewInfo account = null;
        if (coll.size() > 0) {
            account = coll.get(0);
        }
        this.accounts.put(key, account);
        return account;
    }

    private DiffItemInfo getDiffItem(Context ctx, String number) throws BOSException {
        if (this.diffItems.containsKey(number)) {
            return this.diffItems.get(number);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isLeaf");
        selector.add("level");
        selector.add("dc");
        view.setSelector(selector);
        DiffItemCollection coll = DiffItemFactory.getLocalInstance(ctx).getDiffItemCollection(view);
        DiffItemInfo diffItem = null;
        if (coll.size() > 0) {
            diffItem = coll.get(0);
        }
        this.diffItems.put(number, diffItem);
        return diffItem;
    }

    private DiffType getDiffType(AccountViewInfo diffAccount) {
        if (diffAccount.isBudget()) {
            if (AccountDiffType.INCOME.equals((Object)diffAccount.getDiffType())) {
                return DiffType.BUDGET_INCOME;
            }
            return DiffType.BUDGET_EXPENSE;
        }
        if (AccountDiffType.INCOME.equals((Object)diffAccount.getDiffType())) {
            return DiffType.FINANCE_INCOME;
        }
        return DiffType.FINANCE_EXPENSE;
    }

    private boolean isMatch(DiffType diffType, DiffItemInfo diffItem) {
        if (diffItem.getNumber().startsWith("2")) {
            return true;
        }
        return diffItem.getNumber().startsWith("101") ? diffType.equals((Object)DiffType.FINANCE_INCOME) : (diffItem.getNumber().startsWith("102") ? diffType.equals((Object)DiffType.BUDGET_EXPENSE) : (diffItem.getNumber().startsWith("103") ? diffType.equals((Object)DiffType.BUDGET_INCOME) : diffItem.getNumber().startsWith("104") && diffType.equals((Object)DiffType.FINANCE_EXPENSE)));
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        String ignore = coreBaseInfo.getString("ignore");
        if (ignore != null) {
            return;
        }
        try {
            DiffItemMappingInfo mapping = (DiffItemMappingInfo)coreBaseInfo;
            if (mapping.getId() != null) {
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                Timestamp time = GlUtils.getTime();
                String sql = "update T_GL_DiffItemMapping set FDiffItemID = ?, FLastUpdateUserID = ?, FLastUpdateTime = ? where FID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{mapping.getDiffItem().getId().toString(), userId, time, mapping.getId().toString()});
                return;
            }
            CoreBaseCollection infos = new CoreBaseCollection();
            infos.add(coreBaseInfo);
            DiffItemMappingFactory.getLocalInstance(ctx).saveMappings((IObjectCollection)infos);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        try {
            row.put("FCompany", rs.getObject("company.number"));
            row.put("FDiffType", rs.getObject("diffType"));
            row.put("FDiffAccount", rs.getObject("diffAccount.number"));
            row.put("FCheckAccount", rs.getObject("checkAccount.number"));
            row.put("FDiffItem", rs.getObject("diffItem.number"));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        return row;
    }
}

