/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.IAccountCurrency;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AcctCussentInitFacadeFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussentInitFacade;
import com.kingdee.eas.fi.gl.IAssistCustomizedProperty;
import com.kingdee.eas.fi.gl.InitImportBase;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherLeadControlFactory;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InitAcctCussentImport
extends InitImportBase {
    protected static final Logger logger = Logger.getLogger(InitAcctCussentImport.class);
    private Map seqMap = new HashMap();
    private IAcctCussentInitFacade initFacade = null;
    private final int maxLengthForCustommizedType = 80;
    private final int maxLengthForDescription = 200;
    private Map asstMap = null;
    private Map currencyMap = null;
    private int baseCurrencyPrecision = 4;
    private int reportCurrencyPrecision = 4;
    private int qtyScale = 0;
    private int rowNumber = 1;
    private boolean isFirstLoaded = true;
    private CompanyOrgUnitInfo curCompany = null;

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AcctCussentInfo infos = new AcctCussentInfo();
        infos.setIsInit(true);
        String fAsstid = null;
        try {
            BigDecimal amountLocal;
            String actTypeID;
            HashMap<String, String> map;
            CustomerInfo info;
            CompanyOrgUnitInfo company = this.getCompany(ctx, hsData);
            infos.setCompany(company);
            String companyID = company.getId().toString();
            CurrencyInfo currency = this.getCurrency(ctx, hsData);
            infos.setCurrency(currency);
            AccountViewInfo account = this.getAccount(ctx, currency, hsData, true);
            if (account.isIsCFreeze()) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1022_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            if (!account.isAC()) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"988_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            FilterInfo filter = new FilterInfo();
            if (AccountingCurrencyEnum.ONECURRENCY.equals((Object)account.getAccountingcurrency())) {
                IAccountCurrency acctcu = AccountCurrencyFactory.getLocalInstance((Context)ctx);
                filter.getFilterItems().add(new FilterItemInfo("accountView.id", (Object)account.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
                if (!acctcu.exists(filter)) {
                    String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1077_CurrencyVaild", (Locale)ctx.getLocale()), account.getNumber(), currency.getNumber());
                    throw new TaskExternalException(msg);
                }
            }
            infos.setAccount(account);
            infos.setEntrydc(account.getDC().getValue() == 1 ? 1 : 0);
            fAsstid = account.getCAA().getId().toString();
            AssistantHGInfo actualAssistantHGInfo = this.getAssistantHGInfo(ctx, hsData, fAsstid);
            VoucherAssistRecordInfo entry = new VoucherAssistRecordInfo();
            entry.setAssGrp(actualAssistantHGInfo);
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setStandardQuantity(new BigDecimal("0"));
            Calendar calendar = Calendar.getInstance();
            calendar.set(1970, 1, 1);
            java.util.Date minDate = calendar.getTime();
            try {
                Date bizDate = Date.valueOf(((DataToken)hsData.get((Object)"FBizDate")).data.toString());
                entry.setBizDate((java.util.Date)bizDate);
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"989_InitAcctCussentImport", (Locale)ctx.getLocale()), (Throwable)e);
            }
            if (entry.getBizDate().compareTo(minDate) < 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"BizDate_Illegal", (Locale)ctx.getLocale()));
            }
            try {
                Date endDate = Date.valueOf(((DataToken)hsData.get((Object)"FEndDate")).data.toString());
                entry.setEndDate((java.util.Date)endDate);
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"990_InitAcctCussentImport", (Locale)ctx.getLocale()), (Throwable)e);
            }
            if (entry.getEndDate().compareTo(minDate) < 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"EndDate_Illegal", (Locale)ctx.getLocale()));
            }
            entry.setSeq(0);
            filter = new FilterInfo();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("isNecessary"));
            sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("account.id", (Object)account.getId().toString()));
            IAssistCustomizedProperty cpCtrl = AssistCustomizedPropertyFactory.getLocalInstance(ctx);
            AssistCustomizedPropertyCollection props = cpCtrl.getAssistCustomizedPropertyCollection(view);
            Iterator itr = props.iterator();
            ArrayList<String> customizedProperty = new ArrayList<String>();
            while (itr.hasNext()) {
                AssistCustomizedPropertyInfo prop = (AssistCustomizedPropertyInfo)itr.next();
                AssistCustomizedTypeInfo t = prop.getCustomizedType();
                if (!prop.isIsNecessary()) continue;
                customizedProperty.add(t.getMappingPropName());
            }
            String number = ((DataToken)hsData.get((Object)"Customer")).data.toString();
            if (customizedProperty.contains("customer") && (number == null || number.length() == 0)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"991_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            if (number.length() > 0) {
                info = new CustomerInfo();
                map = new HashMap<String, String>();
                map.put("numbers", number);
                map.put("actType", "customer");
                actTypeID = VoucherLeadControlFactory.getLocalInstance(ctx).getAsstinfo(map);
                info.setId(BOSUuid.read((String)actTypeID));
                entry.setCustomer(info);
            }
            number = ((DataToken)hsData.get((Object)"Supplier")).data.toString();
            if (customizedProperty.contains("supplier") && (number == null || number.length() == 0)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"992_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            if (number.length() > 0) {
                info = new SupplierInfo();
                map = new HashMap();
                map.put("numbers", number);
                map.put("actType", "supplier");
                actTypeID = VoucherLeadControlFactory.getLocalInstance(ctx).getAsstinfo(map);
                info.setId(BOSUuid.read((String)actTypeID));
                entry.setSupplier((SupplierInfo)info);
            }
            number = ((DataToken)hsData.get((Object)"Material")).data.toString();
            if (customizedProperty.contains("material") && (number == null || number.length() == 0)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"993_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            if (number.length() > 0) {
                info = new MaterialInfo();
                map = new HashMap();
                map.put("numbers", number);
                map.put("actType", "material");
                actTypeID = VoucherLeadControlFactory.getLocalInstance(ctx).getAsstinfo(map);
                info.setId(BOSUuid.read((String)actTypeID));
                entry.setMaterial((MaterialInfo)info);
            }
            number = ((DataToken)hsData.get((Object)"OrgUnit")).data.toString();
            if (customizedProperty.contains("orgUnit") && (number == null || number.length() == 0)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"994_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            if (number.length() > 0) {
                info = new CompanyOrgUnitInfo();
                map = new HashMap();
                map.put("numbers", number);
                map.put("actType", "orgUnit");
                actTypeID = VoucherLeadControlFactory.getLocalInstance(ctx).getAsstinfo(map);
                info.setId(BOSUuid.read((String)actTypeID));
                entry.setOrgUnit((CompanyOrgUnitInfo)info);
            }
            number = ((DataToken)hsData.get((Object)"SettlementType")).data.toString();
            if (customizedProperty.contains("settlementType") && (number == null || number.length() == 0)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"995_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            if (number.length() > 0) {
                info = new SettlementTypeInfo();
                map = new HashMap();
                map.put("numbers", number);
                map.put("actType", "settlementType");
                actTypeID = VoucherLeadControlFactory.getLocalInstance(ctx).getAsstinfo(map);
                info.setId(BOSUuid.read((String)actTypeID));
                entry.setSettlementType((SettlementTypeInfo)info);
            }
            number = ((DataToken)hsData.get((Object)"BizNumber")).data.toString();
            if (customizedProperty.contains("bizNumber") && (number == null || number.length() == 0)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"996_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            entry.setBizNumber(this.autoSubString(number, 80));
            number = ((DataToken)hsData.get((Object)"SettlementCode")).data.toString();
            if (customizedProperty.contains("settlementCode") && (number == null || number.length() == 0)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"997_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            entry.setSettlementCode(this.autoSubString(number, 80));
            number = ((DataToken)hsData.get((Object)"TicketNumber")).data.toString();
            if (customizedProperty.contains("ticketNumber") && (number == null || number.length() == 0)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"998_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            entry.setTicketNumber(this.autoSubString(number, 80));
            number = ((DataToken)hsData.get((Object)"InvoiceNumber")).data.toString();
            if (customizedProperty.contains("invoiceNumber") && (number == null || number.length() == 0)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"999_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            entry.setInvoiceNumber(this.autoSubString(number, 80));
            infos.setVchAssistRecord(entry);
            BigDecimal amountFor = new BigDecimal("0");
            if (!this.CheckString(((DataToken)hsData.get((Object)"FamountFor")).data)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1000_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            amountFor = this.getValue(hsData.get("FamountFor"));
            amountFor = amountFor.setScale(currency.getPrecision(), 4);
            infos.setUnHoldedAmtFor(amountFor);
            infos.setUnVerifiedAmtFor(amountFor);
            infos.getVchAssistRecord().setOriginalAmount(amountFor);
            if (this.CheckString(((DataToken)hsData.get((Object)"FamountLocal")).data)) {
                if (currency.getId().toString().equals(company.getBaseCurrency().getId().toString())) {
                    amountLocal = amountFor;
                } else {
                    amountLocal = this.getValue(hsData.get("FamountLocal"));
                    amountLocal = amountLocal.setScale(company.getBaseCurrency().getPrecision(), 4);
                }
            } else {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1001_InitAcctCussentImport", (Locale)ctx.getLocale()));
            }
            infos.setUnHoldedAmtLocal(amountLocal);
            infos.setUnVerifiedAmtLocal(amountLocal);
            infos.getVchAssistRecord().setLocalAmount(amountLocal);
            BigDecimal amountReport = new BigDecimal("0");
            if (this.CheckString(((DataToken)hsData.get((Object)"FamountRpt")).data) && company.getReportCurrency() != null) {
                if (currency.getId().toString().equals(company.getReportCurrency().getId().toString())) {
                    amountReport = amountFor;
                } else {
                    amountReport = this.getValue(hsData.get("FamountRpt"));
                    amountReport = amountReport.setScale(company.getReportCurrency().getPrecision(), 4);
                }
            }
            infos.setUnHoldedAmtRpt(amountReport);
            infos.setUnVerifiedAmtRpt(amountReport);
            infos.getVchAssistRecord().setReportingAmount(amountReport);
            MeasureUnitInfo minfo = this.getMeasureUnit(ctx, null, hsData);
            if (minfo != null) {
                entry.setMeasureUnit(minfo);
            }
            if (account.isIsQty() && minfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"887_measureUnitRequired", (Locale)ctx.getLocale()));
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FQty")).data)) {
                BigDecimal qty = this.getValue(hsData.get("FQty"));
                infos.setUnHoldedQty(qty);
                infos.setUnVerifiedQty(qty);
                infos.setUnHoldedStdQty(qty);
                infos.setUnVerifiedStdQty(qty);
                infos.getVchAssistRecord().setQuantity(qty);
                if (minfo != null) {
                    qty = qty.multiply(minfo.getCoefficient());
                    infos.getVchAssistRecord().setStandardQuantity(qty);
                }
            }
            String description = ((DataToken)hsData.get((Object)"Fdescription")).data.toString();
            infos.setDescription(this.autoSubString(description, 200));
            infos.getVchAssistRecord().setDescription(this.autoSubString(description, 200));
            infos.setBizDate((java.util.Date)Date.valueOf(((DataToken)hsData.get((Object)"FBizDate")).data.toString()));
            if (this.isSltImportUpdate()) {
                StringBuffer sqls = new StringBuffer();
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(companyID);
                params.add(account.getId().toString());
                params.add(actualAssistantHGInfo.getId().toString());
                params.add(currency.getId().toString());
                params.add(entry.getBizDate());
                params.add(entry.getEndDate());
                sqls.append("select ac.FID from T_GL_AcctCussent ac join T_GL_VoucherAssistRecord ar on ac.FVchAssistRecordID=ar.FID ");
                sqls.append("where ac.FCompanyID=? and ac.FAccountID=? and ar.FAssGrpID =? and ac.FCurrencyID=? and ar.FBizDate=? and ar.FEndDate=? ");
                if (infos.getDescription() == null || infos.getDescription().length() == 0) {
                    sqls.append("and (ac.FDescription is null or ac.FDescription = '') ");
                } else {
                    sqls.append("and ac.FDescription=? ");
                    params.add(infos.getDescription());
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqls.toString(), (Object[])params.toArray());
                AcctCussentInfo oldInfo = null;
                if (rs.next()) {
                    String id = rs.getString("FID");
                    infos.setId(BOSUuid.read((String)id));
                    SelectorItemCollection sicol = new SelectorItemCollection();
                    sicol.add(new SelectorItemInfo("vchAssistRecord.*"));
                    oldInfo = (AcctCussentInfo)AcctCussentFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(id), sicol);
                }
                if (oldInfo != null) {
                    VoucherAssistRecordInfo vchassistrecord = infos.getVchAssistRecord();
                    VoucherAssistRecordInfo oldVchassistrecord = oldInfo.getVchAssistRecord();
                    this.updateInfoUserProperties(props, vchassistrecord, oldVchassistrecord);
                }
                while (rs.next()) {
                    AcctCussentFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(rs.getString("FID")));
                }
            }
            infos.setSeq(this.getSeq(ctx, company, account, currency));
            InitHelp.addRongYu4AcctCussent((Context)ctx, (AcctCussentInfo)infos, (VoucherAssistRecordInfo)infos.getVchAssistRecord());
            return infos;
        }
        catch (Exception e) {
            logger.error((Object)"Init transmit error", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void updateInfoUserProperties(AssistCustomizedPropertyCollection props, VoucherAssistRecordInfo vchassistrecord, VoucherAssistRecordInfo oldVchassistrecord) {
        if (props.size() > 0) {
            Iterator iterator = props.iterator();
            while (iterator.hasNext()) {
                AssistCustomizedPropertyInfo prop = (AssistCustomizedPropertyInfo)iterator.next();
                String propertyName = prop.getCustomizedType().getMappingPropName();
                if ("customer".equals(propertyName)) {
                    if (vchassistrecord.getCustomer() != null) continue;
                    vchassistrecord.setCustomer(oldVchassistrecord.getCustomer());
                    continue;
                }
                if ("supplier".equals(propertyName)) {
                    if (vchassistrecord.getSupplier() != null) continue;
                    vchassistrecord.setSupplier(oldVchassistrecord.getSupplier());
                    continue;
                }
                if ("material".equals(propertyName)) {
                    if (vchassistrecord.getMaterial() != null) continue;
                    vchassistrecord.setMaterial(oldVchassistrecord.getMaterial());
                    continue;
                }
                if ("orgUnit".equals(propertyName)) {
                    if (vchassistrecord.getOrgUnit() != null) continue;
                    vchassistrecord.setOrgUnit(oldVchassistrecord.getOrgUnit());
                    continue;
                }
                if ("settlementType".equals(propertyName)) {
                    if (vchassistrecord.getSettlementType() != null) continue;
                    vchassistrecord.setSettlementType(oldVchassistrecord.getSettlementType());
                    continue;
                }
                if ("bizNumber".equals(propertyName)) {
                    if (vchassistrecord.getBizNumber() != null) continue;
                    vchassistrecord.setBizNumber(oldVchassistrecord.getBizNumber());
                    continue;
                }
                if ("settlementCode".equals(propertyName)) {
                    if (vchassistrecord.getSettlementCode() != null) continue;
                    vchassistrecord.setSettlementCode(oldVchassistrecord.getSettlementCode());
                    continue;
                }
                if ("ticketNumber".equals(propertyName)) {
                    if (vchassistrecord.getTicketNumber() != null) continue;
                    vchassistrecord.setTicketNumber(oldVchassistrecord.getTicketNumber());
                    continue;
                }
                if ("invoiceNumber".equals(propertyName)) {
                    if (vchassistrecord.getInvoiceNumber() != null) continue;
                    vchassistrecord.setInvoiceNumber(oldVchassistrecord.getInvoiceNumber());
                    continue;
                }
                if (!"feeType".equals(propertyName) || vchassistrecord.getFeeType() != null) continue;
                vchassistrecord.setFeeType(oldVchassistrecord.getFeeType());
            }
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AcctCussentFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getType(), (Throwable)e);
        }
    }

    @Override
    protected String getType() {
        return "InitAcctCussent";
    }

    private int getSeq(Context ctx, CompanyOrgUnitInfo company, AccountViewInfo account, CurrencyInfo currency) throws TaskExternalException {
        String key = company.getId().toString() + account.getId().toString() + currency.getId().toString();
        int seq = this.getMaxSeq(ctx, company, account, currency);
        this.seqMap.put(key, ++seq);
        return seq;
    }

    private int getMaxSeq(Context ctx, CompanyOrgUnitInfo company, AccountViewInfo account, CurrencyInfo currency) throws TaskExternalException {
        String key = company.getId().toString() + account.getId().toString() + currency.getId().toString();
        if (!this.seqMap.containsKey(key)) {
            this.seqMap.put(key, this.getRemoteMaxSeq(ctx, company, account, currency));
        }
        return Integer.parseInt(this.seqMap.get(key).toString());
    }

    private int getRemoteMaxSeq(Context ctx, CompanyOrgUnitInfo company, AccountViewInfo account, CurrencyInfo currency) throws TaskExternalException {
        try {
            if (this.initFacade == null) {
                this.initFacade = AcctCussentInitFacadeFactory.getLocalInstance(ctx);
            }
            HashMap<String, Object> otherCtx = new HashMap<String, Object>();
            otherCtx.put("COMPANY", company);
            otherCtx.put("Account", account);
            otherCtx.put("Currency", currency);
            return this.initFacade.getMaxInitSeq(otherCtx);
        }
        catch (BOSException e) {
            logger.error((Object)"Get Max Seq Error!", (Throwable)e);
            throw new TaskExternalException(this.getType(), (Throwable)e);
        }
    }

    private String autoSubString(String str, int maxLength) {
        if (str.length() > maxLength) {
            str = str.substring(0, maxLength);
        }
        return str;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            if (this.asstMap == null) {
                this.asstMap = new HashMap();
                rs.previous();
                while (rs.next()) {
                    String[][] temp;
                    String asstGroup = rs.getString("assGrp.displayNameGroup");
                    if (asstGroup == null || this.asstMap.containsKey(asstGroup) || (temp = this.dealAsstGroup(asstGroup)) == null) continue;
                    this.asstMap.put(asstGroup, temp);
                }
                rs.first();
            }
            this.getCurrencyPrecision(ctx);
            String[] values = new String[]{"seq", "company.number", "currency.number", "account.number", "vchAssistRecord.bizDate", "vchAssistRecord.description", "vchAssistRecord.endDate", "vchAssistRecord.quantity", "customer.number", "supplier.number", "material.number", "orgUnit.number", "settlementType.number", "bizNumber", "settlementCode", "ticketNumber", "invoiceNumber", "creator.number", "createTime", "measureUnit.number"};
            String[] fields = new String[]{"Fno", "FOrgUnitID", "Fcurrency", "FAccountID", "FBizDate", "Fdescription", "FEndDate", "FQty", "Customer", "Supplier", "Material", "OrgUnit", "SettlementType", "BizNumber", "SettlementCode", "TicketNumber", "InvoiceNumber", "FCreatorNumber", "FCreateTime", "MeasureUnit"};
            String fqtyKey = "FQty";
            String fqtyValue = "0E-10";
            int size = fields.length;
            for (int i = 0; i < size; ++i) {
                String value;
                String string = value = rs.getString(values[i]) == null ? "" : rs.getString(values[i]);
                if (fields[i].equals(fqtyKey) && value.equals(fqtyValue)) {
                    value = "0";
                }
                result.put(fields[i], value);
            }
            String currencyId = rs.getString("currency.id");
            int currencyPre = this.currencyMap.get(currencyId) == null ? 2 : Integer.parseInt(this.currencyMap.get(currencyId).toString());
            BigDecimal tmpOriginalAmount = rs.getBigDecimal("originalAmount").setScale(currencyPre, 4);
            Number originalAmount = 0;
            if (tmpOriginalAmount != null) {
                originalAmount = tmpOriginalAmount;
            }
            BigDecimal tmpLocalAmount = rs.getBigDecimal("localAmount").setScale(this.baseCurrencyPrecision, 4);
            Number localAmount = 0;
            if (tmpLocalAmount != null) {
                localAmount = tmpLocalAmount;
            }
            BigDecimal tmpReportingAmount = rs.getBigDecimal("reportingAmount").setScale(this.reportCurrencyPrecision, 4);
            Number reportingAmount = 0;
            if (tmpReportingAmount != null) {
                reportingAmount = tmpReportingAmount;
            }
            if (tmpOriginalAmount == null && tmpLocalAmount == null && tmpReportingAmount == null) {
                return null;
            }
            result.put("FamountFor", originalAmount);
            result.put("FamountLocal", localAmount);
            result.put("FamountRpt", reportingAmount);
            String groups = rs.getString("assGrp.displayNameGroup");
            String[][] items = (String[][])this.asstMap.get(groups);
            for (int i = 0; i < items.length; ++i) {
                result.put("Fitem_" + (i + 1), items[i][0]);
                result.put("Fnumber_" + (i + 1), items[i][1]);
                result.put("Fname_" + (i + 1), items[i][2]);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gl.app.AcctCussentInitExportQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        Set keySet = paramMap.keySet();
        if (keySet.contains("DATATASKMODE")) {
            String orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgId));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CompareType.NOTINCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), CompareType.NOTINCLUDE));
        }
        return filter;
    }

    private String[][] dealAsstGroup(String asstGroup) {
        String[][] list = null;
        String[] groups = asstGroup.split(";");
        list = new String[groups.length][3];
        for (int i = 0; i < groups.length; ++i) {
            String[] ss = groups[i].replaceAll("_!", ":").split(":");
            if (ss.length < 3) {
                return null;
            }
            for (int j = 0; j < 3; ++j) {
                list[i][j] = ss[j];
            }
        }
        return list;
    }

    private void getCurrencyPrecision(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo;
        if (!this.isFirstLoaded) {
            return;
        }
        Map paramMap = this.getContextMap();
        this.currencyMap = new HashMap();
        String orgId = (String)paramMap.get("orgunit.id");
        if (StringUtils.isEmpty((String)orgId)) {
            orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        this.baseCurrencyPrecision = (companyInfo = GlUtils.getCompanyById(ctx, orgId)).getBaseCurrency() == null ? 4 : companyInfo.getBaseCurrency().getPrecision();
        this.reportCurrencyPrecision = companyInfo.getReportCurrency() == null ? 4 : companyInfo.getReportCurrency().getPrecision();
        HashMap<String, String> glparam = new HashMap<String, String>();
        glparam.put("GL_002", orgId);
        IParamControl pc = null;
        pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmParam = pc.getParamHashMap(glparam);
        this.qtyScale = hmParam.get("GL_002") == null ? 0 : Integer.parseInt(hmParam.get("GL_002").toString());
        CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select id, precision ");
        for (CurrencyInfo currencyInfo : currencyColl) {
            this.currencyMap.put(currencyInfo.getId().toString(), currencyInfo.getPrecision());
        }
        this.isFirstLoaded = false;
    }
}

