/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AssistInitFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.InitAssistBalanceFactory;
import com.kingdee.eas.fi.gl.InitAssistBalanceInfo;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.fi.gl.InitImportBase;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InitAssistBalanceImport
extends InitImportBase {
    private static final Logger logger = Logger.getLogger(InitAssistBalanceImport.class);
    private String accountid = null;
    private String actualAssistantHGInfoID = null;
    private String currecyID = null;
    private Map asstMap = null;
    private Map currencyMap = null;
    private int baseCurrencyPrecision = 4;
    private int reportCurrencyPrecision = 4;
    private int qtyScale = 0;
    private int rowNumber = 1;
    private boolean isFirstLoaded = true;
    private CompanyOrgUnitInfo cacheCompany = null;
    private List<String> cacheClosedAccounts = null;
    private List<String> cacheCussentClosedAccounts = null;
    private Map<String, AccountViewInfo> cacheAccounts = new HashMap<String, AccountViewInfo>();
    private Map<String, AssistantHGInfo> assistantHGs = new HashMap<String, AssistantHGInfo>();
    private Map<String, ArrayList> InitDatas = new HashMap<String, ArrayList>();
    private Map<String, Object[]> exess = new HashMap<String, Object[]>();
    private Map<String, Map<String, String>> caamus = new HashMap<String, Map<String, String>>();
    private Map<String, List<Map<String, String>>> caas = new HashMap<String, List<Map<String, String>>>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InitAssistBalanceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getType(), (Throwable)e);
        }
    }

    @Override
    public CompanyOrgUnitInfo getCompany(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        CompanyOrgUnitInfo unitInfo = this.doGetCompany(ctx);
        String orgUnitID = ((DataToken)hsData.get((Object)"FOrgUnitID")).data.toString();
        if (!unitInfo.getNumber().equals(orgUnitID)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1011_InitImportBase", (Locale)ctx.getLocale()));
        }
        return unitInfo;
    }

    private CompanyOrgUnitInfo doGetCompany(Context ctx) throws BOSException, EASBizException {
        if (this.cacheCompany != null) {
            return this.cacheCompany;
        }
        Map pageParam = super.getContextMap();
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK companyId = pageParam != null && pageParam.get("COMPANYID") != null ? new ObjectUuidPK(pageParam.get("COMPANYID").toString()) : new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        this.cacheCompany = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)companyId, sic);
        return this.cacheCompany;
    }

    public CompanyOrgUnitInfo getCurrentCompany(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (GlUtils.isCompanyUnion(company)) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return company;
    }

    @Override
    public void isCloseInit(Context ctx, AccountViewInfo account, boolean isCussent) throws Exception, BOSException {
        if (this.getClosedAccounts(ctx, isCussent).contains(account.getId().toString())) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1012_InitImportBase", (Locale)ctx.getLocale()));
        }
    }

    private List<String> getClosedAccounts(Context ctx, boolean isCussent) throws EASBizException, BOSException {
        if (isCussent) {
            if (this.cacheCussentClosedAccounts != null) {
                return this.cacheCussentClosedAccounts;
            }
        } else if (this.cacheClosedAccounts != null) {
            return this.cacheClosedAccounts;
        }
        CompanyOrgUnitInfo curCompany = this.doGetCompany(ctx);
        String orgUnitId = curCompany.getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        if (isCussent) {
            String[] closedAccount = flag.getAllCussentInitClosed(orgUnitId);
            this.cacheCussentClosedAccounts = new ArrayList<String>();
            if (closedAccount != null) {
                this.cacheCussentClosedAccounts = Arrays.asList(closedAccount);
            }
            return this.cacheCussentClosedAccounts;
        }
        String[] closedAccount = flag.getAllAstInitClosed(orgUnitId);
        this.cacheClosedAccounts = new ArrayList<String>();
        if (closedAccount != null) {
            this.cacheClosedAccounts = Arrays.asList(closedAccount);
        }
        return this.cacheClosedAccounts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AccountViewInfo getAccount(Context ctx, CurrencyInfo currency, Hashtable hsData, boolean isCussent) throws Exception, SQLException {
        AccountViewInfo account = new AccountViewInfo();
        String accountID = ((DataToken)hsData.get((Object)"FAccountID")).data.toString();
        CompanyOrgUnitInfo unitInfo = this.doGetCompany(ctx);
        if ("InitAccountBalance".equals(this.getType())) {
            account = this.doGetAccountForAcc(ctx, unitInfo, accountID);
            if (account == null) throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1014_InitImportBase", (Locale)ctx.getLocale()));
            if (AccountingCurrencyEnum.NOCURRENCY.equals((Object)account.getAccountingcurrency()) && !currency.getId().equals((Object)unitInfo.getBaseCurrency().getId())) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1013_InitImportBase", (Locale)ctx.getLocale()));
            }
            this.isCloseInit(ctx, account, isCussent);
            return account;
        } else {
            account = this.doGetAccountForAss(ctx, unitInfo, accountID);
            if (account == null) throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1015_InitImportBase", (Locale)ctx.getLocale()));
            if (AccountingCurrencyEnum.NOCURRENCY.equals((Object)account.getAccountingcurrency()) && !currency.getId().equals((Object)unitInfo.getBaseCurrency().getId())) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1013_InitImportBase", (Locale)ctx.getLocale()));
            }
            this.isCloseInit(ctx, account, isCussent);
        }
        return account;
    }

    private AccountViewInfo doGetAccountForAcc(Context ctx, CompanyOrgUnitInfo unitInfo, String accountNumber) throws BOSException, UuidException, SQLException {
        String key = unitInfo.getId().toString() + "_" + accountNumber;
        if (this.cacheAccounts.containsKey(key)) {
            return this.cacheAccounts.get(key);
        }
        String sqlToGetAccount = "select top 1 fid,fcaa,fac,facctcurrency,fisQty,flongnumber from T_BD_ACCOUNTVIEW where fisleaf=1 and fcaa is null and fnumber=? and Fcompanyid=? and faccounttableid=?";
        IRowSet rsToGetAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccount, (Object[])new Object[]{accountNumber, unitInfo.getId().toString(), unitInfo.getAccountTable().getId().toString()});
        AccountViewInfo account = null;
        if (rsToGetAccount != null && rsToGetAccount.next()) {
            account = new AccountViewInfo();
            account.setId(BOSUuid.read((String)rsToGetAccount.getString("fid")));
            account.setAC(rsToGetAccount.getBoolean("fac"));
            account.setIsQty(rsToGetAccount.getBoolean("fisQty"));
            account.setLongNumber(rsToGetAccount.getString("flongnumber"));
            account.setNumber(accountNumber);
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rsToGetAccount.getInt("facctcurrency")));
        }
        this.cacheAccounts.put(key, account);
        return account;
    }

    private AccountViewInfo doGetAccountForAss(Context ctx, CompanyOrgUnitInfo unitInfo, String accountNumber) throws BOSException, UuidException, SQLException {
        String key = unitInfo.getId().toString() + "_" + accountNumber;
        if (this.cacheAccounts.containsKey(key)) {
            return this.cacheAccounts.get(key);
        }
        String sqlToGetAccount = "select top 1 fid,fcaa,fac,facctcurrency,fisQty,FIsCashEquivalent,FIsBank from T_BD_ACCOUNTVIEW where fisleaf=1 and fcaa is not null and fnumber=? and Fcompanyid=? and faccounttableid=?";
        IRowSet rsToGetAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccount, (Object[])new Object[]{accountNumber, unitInfo.getId().toString(), unitInfo.getAccountTable().getId().toString()});
        AccountViewInfo account = null;
        if (rsToGetAccount != null && rsToGetAccount.next()) {
            account = new AccountViewInfo();
            account.setId(BOSUuid.read((String)rsToGetAccount.getString("fid")));
            AsstAccountInfo caa = new AsstAccountInfo();
            caa.setId(BOSUuid.read((String)rsToGetAccount.getString("fcaa")));
            account.setCAA(caa);
            account.setAC(rsToGetAccount.getBoolean("fac"));
            account.setIsQty(rsToGetAccount.getBoolean("fisQty"));
            account.setNumber(accountNumber);
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rsToGetAccount.getInt("facctcurrency")));
            account.setIsBank(rsToGetAccount.getBoolean("FIsBank"));
            account.setIsCashEquivalent(rsToGetAccount.getBoolean("FIsCashEquivalent"));
        }
        this.cacheAccounts.put(key, account);
        return account;
    }

    @Override
    public Object[] getExchangeRate(Context ctx, String orgCurId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curCompany = this.getCurrentCompany(ctx, this.doGetCompany(ctx));
        CurrencyInfo reportCur = curCompany.getReportCurrency();
        CurrencyInfo localCur = curCompany.getBaseCurrency();
        LowTimer low = new LowTimer();
        low.reset();
        ArrayList al = this.findInitData(ctx, curCompany);
        int index = 0;
        ++index;
        int n = ++index;
        ++index;
        Boolean b = (Boolean)al.get(n);
        boolean isUsingReport = b;
        int n2 = ++index;
        ++index;
        PeriodInfo startPeriod = (PeriodInfo)al.get(n2);
        Object[] info = new Object[8];
        if (curCompany.getBaseExchangeTable() == null) {
            throw new GLException(GLException.NOLOCALEXTABLE);
        }
        if (this.exess.containsKey(orgCurId)) {
            return this.exess.get(orgCurId);
        }
        info[0] = curCompany.getBaseExchangeTable().getId().toString();
        info[2] = orgCurId;
        info[3] = localCur.getId().toString();
        if (isUsingReport) {
            info[4] = reportCur.getId().toString();
            info[1] = curCompany.getReportExchangeTable().getId().toString();
        }
        info[6] = startPeriod.getBeginDate();
        info[5] = startPeriod.getBeginDate();
        Object[] exes = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
        this.exess.put(orgCurId, exes);
        return exes;
    }

    private ArrayList findInitData(Context ctx, CompanyOrgUnitInfo curCompany) throws EASBizException, BOSException {
        String key = curCompany.getId().toString();
        if (this.InitDatas.containsKey(key)) {
            return this.InitDatas.get(key);
        }
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        AccountTableInfo accouttable = curCompany.getAccountTable();
        String cuid = curCompany.getCU().getId().toString();
        otherCtx.put("COMPANY", curCompany);
        otherCtx.put("CUID", cuid);
        otherCtx.put("ACCOUNTTABLEID", accouttable.getId().toString());
        ArrayList al = AssistInitFacadeFactory.getLocalInstance(ctx).findInitData(otherCtx);
        this.InitDatas.put(key, al);
        return al;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        InitAssistBalanceInfo infos = new InitAssistBalanceInfo();
        infos.setFromExcel(true);
        Map pageParam = super.getContextMap();
        String Fcaaname = ((DataToken)hsData.get((Object)"FCAA")).data.toString();
        String faccid = null;
        String fmeasureunitgroupid = null;
        String companyid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        try {
            int precision;
            BigDecimal amt;
            BigDecimal qty;
            boolean isSettleByLocal;
            MeasureUnitInfo minfo;
            List<Map<String, String>> rsToGetAcctname;
            CompanyOrgUnitInfo company = this.getCompany(ctx, hsData);
            companyid = company.getId().toString();
            infos.setOrgUnit(company);
            ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)company);
            CurrencyInfo currency = super.getCurrency(ctx, hsData);
            this.currecyID = currency.getId().toString();
            infos.setCurrency(currency);
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("GL_0155");
            Map hmParams = GlUtils.getParamsByKeys(ctx, companyid, paramList);
            boolean filterAccount = Boolean.valueOf(hmParams.get("GL_0155").toString());
            AccountViewInfo account = this.getAccount(ctx, currency, hsData, false);
            String FAccountID = ((DataToken)hsData.get((Object)"FAccountID")).data.toString();
            this.accountid = account.getId().toString();
            infos.setAccount(account);
            Map<String, String> caamu = this.getCaamu(ctx, Fcaaname, FAccountID, companyid);
            if (caamu == null) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1074_InitAssistBalanceImport", (Locale)ctx.getLocale()));
            }
            faccid = caamu.get("faccid");
            fmeasureunitgroupid = caamu.get("fmeasureunitgroupid");
            String region = null;
            String bankAccount = null;
            String material = null;
            AssistantHGInfo assistantHGInfo = new AssistantHGInfo();
            if (faccid != null && (rsToGetAcctname = this.getCaa(ctx, faccid)) != null) {
                int siz = rsToGetAcctname.size();
                String[] asstactTypeName = new String[siz];
                String[] asstactTypeNumber = new String[siz];
                String[] asstactType = new String[siz];
                String[] attrs = new String[siz];
                for (int iop = 0; iop < siz; ++iop) {
                    asstactType[iop] = rsToGetAcctname.get(iop).get("Fname");
                    attrs[iop] = rsToGetAcctname.get(iop).get("FAsstHgAttribute");
                }
                for (int i = 0; i < siz; ++i) {
                    int counts = 8;
                    for (int ii = 0; ii < counts; ++ii) {
                        String Fitem = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fitem_").append((String)String.valueOf((int)(ii + 1))).toString())).data.toString();
                        if (!Fitem.equals(asstactType[i]) || ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fnumber_").append((String)String.valueOf((int)(ii + 1))).toString())).data == null || ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fname_").append((String)String.valueOf((int)(ii + 1))).toString())).data == null) continue;
                        asstactTypeNumber[i] = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fnumber_").append((String)String.valueOf((int)(ii + 1))).toString())).data.toString();
                        asstactTypeName[i] = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fname_").append((String)String.valueOf((int)(ii + 1))).toString())).data.toString();
                        if ("region".equals(attrs[i])) {
                            region = "region";
                            break;
                        }
                        if ("bankAccount".equals(attrs[i])) {
                            bankAccount = "bankAccount";
                            break;
                        }
                        if (!"material".equals(attrs[i])) break;
                        material = "material";
                        break;
                    }
                    if (asstactTypeNumber[i] != null) continue;
                    throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1016_InitImportBase", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1017_InitImportBase", (Locale)ctx.getLocale()));
                }
                AsstActTypeCollection arrayAsstActTypeInfo = new AsstActTypeCollection();
                int count = asstactTypeName.length;
                for (int i = 0; i < count; ++i) {
                    this.constructAssistInfo(ctx, assistantHGInfo, asstactType[i], asstactTypeNumber[i], asstactTypeName[i], arrayAsstActTypeInfo);
                }
                AssistantHGInfo actualAssistantHGInfo = this.findAssistantHG(ctx, faccid, arrayAsstActTypeInfo, assistantHGInfo);
                if (assistantHGInfo.getBankAccount() != null) {
                    AccountBankInfo accountBankInfo = assistantHGInfo.getBankAccount();
                    if ((account.isIsBank() || filterAccount && account.isIsCashEquivalent()) && accountBankInfo.getAccount() != null && accountBankInfo.getAccount().getId() != null && !accountBankInfo.getAccount().getId().toString().equals(this.accountid)) {
                        throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"285_BankAccountNoMatch", (Locale)ctx.getLocale()));
                    }
                    if (accountBankInfo.isIsClosed()) {
                        throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"286_BankAccountIsClosed", (Locale)ctx.getLocale()));
                    }
                }
                this.actualAssistantHGInfoID = actualAssistantHGInfo.getId().toString();
                infos.setAssistGrp(actualAssistantHGInfo);
            }
            String sqls = "select top 1 FID from T_GL_InitAssistBalance  where FOrgUnitID=? and FAccountID=?  and  FCurrencyID=? and FAssistGrpID=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqls, (Object[])new Object[]{companyid, this.accountid, this.currecyID, this.actualAssistantHGInfoID});
            if (this.isSltImportUpdate()) {
                if (rs.next()) {
                    String sql = "delete from T_GL_InitAssistBalance  where FOrgUnitID=? and FAccountID=?  and  FCurrencyID=? and FAssistGrpID=?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{companyid, this.accountid, this.currecyID, this.actualAssistantHGInfoID});
                }
            } else if (rs.size() > 0) {
                throw new TaskExternalException(GLResUtil.getRes("cannot_import_repeated_records"));
            }
            if ((minfo = this.getMeasureUnit(ctx, fmeasureunitgroupid, hsData)) != null) {
                infos.setMesureUnit(minfo);
            }
            if (material != null) {
                String materialId = null;
                if (material != null && assistantHGInfo.get("material") != null) {
                    materialId = ((DataBaseInfo)assistantHGInfo.get("material")).getId().toString();
                }
                String curCompanyId = (String)ctx.get((Object)"CurCompanyId");
                Object[] params = new Object[]{curCompanyId, materialId};
                StringBuffer sql = new StringBuffer();
                sql.append("select material.fid as id from t_bd_material as material inner join ");
                sql.append("t_bd_measureunit as baseunit on material.fbaseunit = baseunit.fid inner join ");
                sql.append("t_org_ctrlunit as cu on material.fcontrolunitid = cu.fid left outer join ");
                sql.append("t_bd_materialgroup as materialgroup on material.fmaterialgroupid = materialgroup.fid ");
                sql.append("inner join t_bd_materialcompanyinfo as fiinfo on material.fid = fiinfo.fmaterialid ");
                sql.append("inner join t_org_company as orgunit on fiinfo.fcompanyid = orgunit.fid ");
                sql.append("where orgunit.fid = ? and material.fid = ?");
                IRowSet res = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                if (res.size() <= 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"287_MaterialNotMatch", (Locale)ctx.getLocale()));
                }
            }
            if (account.isIsQty() && minfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"887_measureUnitRequired", (Locale)ctx.getLocale()));
            }
            Object obj = GlUtils.getParamByKey(ctx, companyid, "GL_0155");
            if (account.isIsBank() || account.isIsCashEquivalent() && Boolean.valueOf(obj.toString()).booleanValue()) {
                String comID = companyid;
                StringBuffer sql = new StringBuffer();
                String regionId = null;
                String bankAccountNumber = null;
                if (region != null && assistantHGInfo.get("region") != null) {
                    regionId = ((DataBaseInfo)assistantHGInfo.get("region")).getId().toString();
                }
                if (bankAccount != null && assistantHGInfo.get("bankAccount") != null) {
                    bankAccountNumber = ((DataBaseInfo)assistantHGInfo.get("bankAccount")).getNumber().toString();
                }
                if (BooksUtil.isMasterBook((Context)ctx, (String)companyid)) {
                    sql.append(" select top 1 FID from T_BD_AccountBanks ");
                    sql.append(" where FCompanyID = ? and FAccountID = ? and FNumber = ? and (( FCurrencyID=?  and FISBYCURRENCY = 1 ) or FISBYCURRENCY = 0)");
                    if (regionId != null) {
                        sql.append("and FBank = ? ");
                    }
                } else {
                    comID = BooksUtil.getCurrentMasterCompany((Context)ctx, (CompanyOrgUnitInfo)company).getId().toString();
                    sql.append(" select top 1 bk.FID from T_BD_AccountBanks bk\t\t\t\t\t \t\t\t\t\r\n");
                    sql.append(" inner join T_BD_AcctRefContrastEntry ref on ref.foldacctid = bk.faccountid \r\n");
                    sql.append(" where bk.fcompanyid = ? and ref.Fnewacctid = ?  and bk.Fnumber =? and ((bk.FCurrencyID = ? and bk.FISBYCURRENCY =1 ) or bk.FISBYCURRENCY = 0) \r\n");
                    if (regionId != null) {
                        sql.append("and bk.FBank = ? \r\n");
                    }
                }
                Object[] params = region != null ? new Object[]{comID, this.accountid, bankAccountNumber, this.currecyID, regionId} : new Object[]{comID, this.accountid, bankAccountNumber, this.currecyID};
                IRowSet res = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                if (res.size() <= 0 && region != null) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"286_BankNoMatch", (Locale)ctx.getLocale()));
                }
                if (res.size() <= 0 && bankAccountNumber != null) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"285_BankAccountNoMatch", (Locale)ctx.getLocale()));
                }
            }
            boolean isLocal = this.currecyID.equals(ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency().getId().toString());
            Object[] exes = this.getExchangeRate(ctx, this.currecyID);
            VoucherInfo.ExchangeRateWithValue lex = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            VoucherInfo.ExchangeRateWithValue rex = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            if (exes != null) {
                if (!isLocal && exes[0] != null) {
                    lex = (VoucherInfo.ExchangeRateWithValue)exes[0];
                } else if (!isLocal) {
                    throw new InitException(InitException.LOCAL_EX_ERROR);
                }
                if (exes[1] != null) {
                    rex = (VoucherInfo.ExchangeRateWithValue)exes[1];
                }
            }
            BigDecimal yearDebitFor = new BigDecimal("0");
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearDebitFor")).data)) {
                infos.setYearDebitFor(this.getValue(hsData.get("FYearDebitFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitLocal")).data)) {
                BigDecimal yearDebitLocal;
                if (currency.getId().toString().equals(company.getBaseCurrency().getId().toString())) {
                    yearDebitLocal = yearDebitFor;
                } else {
                    yearDebitLocal = this.getValue(hsData.get("FYearDebitLocal"));
                    yearDebitLocal = yearDebitLocal.setScale(company.getBaseCurrency().getPrecision(), 4);
                }
                infos.setYearDebitLocal(yearDebitLocal);
            } else if (infos.getYearDebitFor() != null) {
                infos.setYearDebitLocal(lex.getValue().multiply(infos.getYearDebitFor()));
            }
            boolean bl = isSettleByLocal = 3 == company.getReportConvertMode().getValue();
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitRpt")).data)) {
                infos.setYearDebitRpt(this.getValue(hsData.get("FYearDebitRpt")));
            } else if (infos.getYearDebitFor() != null) {
                if (isSettleByLocal) {
                    infos.setYearDebitRpt(rex.getValue().multiply(infos.getYearDebitLocal()));
                } else {
                    infos.setYearDebitRpt(rex.getValue().multiply(infos.getYearDebitFor()));
                }
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitQty")).data)) {
                qty = this.getValue(hsData.get("FYearDebitQty"));
                infos.setYearDebitQty(qty);
                if (minfo != null) {
                    qty = qty.multiply(minfo.getCoefficient());
                }
                infos.setStabdardYearDebitQty(qty);
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditQty")).data)) {
                qty = this.getValue(hsData.get("FYearCreditQty"));
                infos.setYearCreditQty(qty);
                if (minfo != null) {
                    qty = qty.multiply(minfo.getCoefficient());
                }
                infos.setStabdardYearCreditQty(qty);
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearCreditFor")).data)) {
                infos.setYearCreditFor(this.getValue(hsData.get("FYearCreditFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditLocal")).data)) {
                infos.setYearCreditLocal(this.getValue(hsData.get("FYearCreditLocal")));
            } else if (infos.getYearCreditFor() != null) {
                infos.setYearCreditLocal(lex.getValue().multiply(infos.getYearCreditFor()));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditRpt")).data)) {
                infos.setYearCreditRpt(this.getValue(hsData.get("FYearCreditRpt")));
            } else if (infos.getYearCreditFor() != null) {
                if (isSettleByLocal) {
                    infos.setYearCreditRpt(rex.getValue().multiply(infos.getYearCreditLocal()));
                } else {
                    infos.setYearCreditRpt(rex.getValue().multiply(infos.getYearCreditFor()));
                }
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FBeginQty")).data)) {
                infos.setEndQty(this.getValue(hsData.get("FBeginQty")));
                qty = this.getValue(hsData.get("FBeginQty"));
                infos.setBeginQty(qty);
                if (minfo != null) {
                    qty = qty.multiply(minfo.getCoefficient());
                }
                infos.setStabdardBeginQty(qty);
                infos.setStabdardEndQty(qty);
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceFor")).data)) {
                infos.setBeginBalanceFor(this.getValue(hsData.get("FBeginBalanceFor")));
                infos.setEndBalanceFor(this.getValue(hsData.get("FBeginBalanceFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceLocal")).data)) {
                infos.setBeginBalanceLocal(this.getValue(hsData.get("FBeginBalanceLocal")));
                infos.setEndBalanceLocal(this.getValue(hsData.get("FBeginBalanceLocal")));
            } else if (infos.getBeginBalanceFor() != null) {
                infos.setBeginBalanceLocal(lex.getValue().multiply(infos.getBeginBalanceFor()));
                infos.setEndBalanceLocal(lex.getValue().multiply(infos.getBeginBalanceFor()));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceRpt")).data)) {
                infos.setBeginBalanceRpt(this.getValue(hsData.get("FBeginBalanceRpt")));
                infos.setEndBalanceRpt(this.getValue(hsData.get("FBeginBalanceRpt")));
            } else if (infos.getBeginBalanceFor() != null) {
                if (isSettleByLocal) {
                    infos.setBeginBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceLocal()));
                    infos.setEndBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceLocal()));
                } else {
                    infos.setBeginBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceFor()));
                    infos.setEndBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceFor()));
                }
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearPnLFor")).data)) {
                infos.setYearPnLFor(this.getValue(hsData.get("FYearPnLFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearPnLLocal")).data)) {
                infos.setYearPnLLocal(this.getValue(hsData.get("FYearPnLLocal")));
            } else if (infos.getYearPnLFor() != null) {
                infos.setYearPnLLocal(lex.getValue().multiply(infos.getYearPnLFor()));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearPnLRpt")).data)) {
                infos.setYearPnLRpt(this.getValue(hsData.get("FYearPnLRpt")));
            } else if (infos.getYearPnLFor() != null) {
                if (isSettleByLocal) {
                    infos.setYearPnLRpt(rex.getValue().multiply(infos.getYearPnLLocal()));
                } else {
                    infos.setYearPnLRpt(rex.getValue().multiply(infos.getYearPnLFor()));
                }
            }
            PeriodInfo perid = GlUtils.getStartPeriod(ctx, companyid);
            if (perid != null && perid.getPeriodNumber() == 1) {
                infos.setYearDebitFor(BigDecimal.ZERO);
                infos.setYearDebitLocal(BigDecimal.ZERO);
                infos.setYearDebitRpt(BigDecimal.ZERO);
                infos.setYearDebitQty(BigDecimal.ZERO);
                infos.setYearCreditFor(BigDecimal.ZERO);
                infos.setYearCreditLocal(BigDecimal.ZERO);
                infos.setYearCreditRpt(BigDecimal.ZERO);
                infos.setYearCreditQty(BigDecimal.ZERO);
                infos.setYearPnLFor(BigDecimal.ZERO);
                infos.setYearPnLLocal(BigDecimal.ZERO);
                infos.setYearPnLRpt(BigDecimal.ZERO);
            }
            if (infos.getYearDebitFor() != null) {
                amt = infos.getYearDebitFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearDebitFor(amt);
            }
            if (infos.getYearDebitLocal() != null) {
                amt = infos.getYearDebitLocal();
                amt = amt.setScale(company.getBaseCurrency().getPrecision(), 4);
                infos.setYearDebitLocal(amt);
            }
            if (infos.getYearDebitRpt() != null) {
                amt = infos.getYearDebitRpt();
                precision = company.getBaseCurrency().getPrecision();
                if (company.getReportCurrency() != null) {
                    precision = company.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearDebitRpt(amt);
            }
            if (infos.getYearCreditFor() != null) {
                amt = infos.getYearCreditFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearCreditFor(amt);
            }
            if (infos.getYearCreditLocal() != null) {
                amt = infos.getYearCreditLocal();
                amt = amt.setScale(company.getBaseCurrency().getPrecision(), 4);
                infos.setYearCreditLocal(amt);
            }
            if (infos.getYearCreditRpt() != null) {
                amt = infos.getYearCreditRpt();
                precision = company.getBaseCurrency().getPrecision();
                if (company.getReportCurrency() != null) {
                    precision = company.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearCreditRpt(amt);
            }
            if (infos.getBeginBalanceFor() != null) {
                amt = infos.getBeginBalanceFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setBeginBalanceFor(amt);
            }
            if (infos.getBeginBalanceLocal() != null) {
                amt = infos.getBeginBalanceLocal();
                amt = amt.setScale(company.getBaseCurrency().getPrecision(), 4);
                infos.setBeginBalanceLocal(amt);
            }
            if (infos.getBeginBalanceRpt() != null) {
                amt = infos.getBeginBalanceRpt();
                precision = company.getBaseCurrency().getPrecision();
                if (company.getReportCurrency() != null) {
                    precision = company.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setBeginBalanceRpt(amt);
            }
            if (infos.getYearPnLFor() != null) {
                amt = infos.getYearPnLFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearPnLFor(amt);
            }
            if (infos.getYearPnLLocal() != null) {
                amt = infos.getYearPnLLocal();
                amt = amt.setScale(company.getBaseCurrency().getPrecision(), 4);
                infos.setYearPnLLocal(amt);
            }
            if (infos.getYearPnLRpt() != null) {
                amt = infos.getYearPnLRpt();
                precision = company.getBaseCurrency().getPrecision();
                if (company.getReportCurrency() != null) {
                    precision = company.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearPnLRpt(amt);
            }
            return infos;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = null;
        try {
            if (this.asstMap == null) {
                this.asstMap = new HashMap();
                rs.previous();
                while (rs.next()) {
                    String[][] temp;
                    String asstGroup = rs.getString("ASSISTGRP.DISPLAYNAMEGROUP");
                    if (asstGroup == null || this.asstMap.containsKey(asstGroup) || (temp = this.dealAsstGroup(asstGroup)) == null) continue;
                    this.asstMap.put(asstGroup, temp);
                }
                rs.first();
            }
            this.getCurrencyPrecision(ctx);
            String currencyId = rs.getString("currency.id");
            result = new Hashtable<String, Object>();
            int currencyPre = this.currencyMap.get(currencyId) == null ? 2 : Integer.parseInt(this.currencyMap.get(currencyId).toString());
            result.put("FYearDebitQty", rs.getBigDecimal("yearDebitQty").setScale(this.qtyScale, 4));
            result.put("FYearDebitFor", rs.getBigDecimal("yearDebitFor").setScale(currencyPre, 4));
            result.put("FYearDebitLocal", rs.getBigDecimal("yearDebitLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearDebitRpt", rs.getBigDecimal("yearDebitRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FYearCreditQty", rs.getBigDecimal("yearCreditQty").setScale(this.qtyScale, 4));
            result.put("FYearCreditFor", rs.getBigDecimal("yearCreditFor").setScale(currencyPre, 4));
            result.put("FYearCreditLocal", rs.getBigDecimal("yearCreditLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearCreditRpt", rs.getBigDecimal("yearCreditRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FBeginQty", rs.getBigDecimal("beginQty").setScale(this.qtyScale, 4));
            result.put("FBeginBalanceFor", rs.getBigDecimal("beginBalanceFor").setScale(currencyPre, 4));
            result.put("FBeginBalanceLocal", rs.getBigDecimal("beginBalanceLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FBeginBalanceRpt", rs.getBigDecimal("beginBalanceRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FYearPnLFor", rs.getBigDecimal("yearPnLFor").setScale(currencyPre, 4));
            result.put("FYearPnLLocal", rs.getBigDecimal("yearPnLLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearPnLRpt", rs.getBigDecimal("yearPnLRpt").setScale(this.reportCurrencyPrecision, 4));
            String groups = rs.getString("ASSISTGRP.DISPLAYNAMEGROUP");
            String[][] items = (String[][])this.asstMap.get(groups);
            for (int i = 0; i < items.length; ++i) {
                result.put("Fitem_" + (i + 1), items[i][0]);
                result.put("Fnumber_" + (i + 1), items[i][1]);
                result.put("Fname_" + (i + 1), items[i][2]);
            }
            result.put("Fno", this.rowNumber);
            result.put("FOrgUnitID", StringUtils.isEmpty((String)rs.getString("ORGUNIT.NUMBER")) ? "" : rs.getString("ORGUNIT.NUMBER"));
            result.put("Fcurrency", StringUtils.isEmpty((String)rs.getString("CURRENCY.NUMBER")) ? "" : rs.getString("CURRENCY.NUMBER"));
            result.put("FCAA", StringUtils.isEmpty((String)rs.getString("CAA.NAME")) ? "" : rs.getString("CAA.NAME"));
            result.put("FAccountID", StringUtils.isEmpty((String)rs.getString("ACCOUNT.NUMBER")) ? "" : rs.getString("ACCOUNT.NUMBER"));
            result.put("MeasureUnit", rs.getString("MESUREUNIT.NAME") == null ? "" : rs.getString("MESUREUNIT.NAME"));
            ++this.rowNumber;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getCurrencyPrecision(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo;
        if (!this.isFirstLoaded) {
            return;
        }
        Map paramMap = this.getContextMap();
        this.currencyMap = new HashMap();
        String orgId = (String)paramMap.get("orgunit.id");
        if (StringUtils.isEmpty((String)orgId)) {
            orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        this.baseCurrencyPrecision = (companyInfo = GlUtils.getCompanyById(ctx, orgId)).getBaseCurrency() == null ? 4 : companyInfo.getBaseCurrency().getPrecision();
        this.reportCurrencyPrecision = companyInfo.getReportCurrency() == null ? 4 : companyInfo.getReportCurrency().getPrecision();
        HashMap<String, String> glparam = new HashMap<String, String>();
        glparam.put("GL_002", orgId);
        IParamControl pc = null;
        pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmParam = pc.getParamHashMap(glparam);
        this.qtyScale = hmParam.get("GL_002") == null ? 0 : Integer.parseInt(hmParam.get("GL_002").toString());
        CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select id, precision ");
        for (CurrencyInfo currencyInfo : currencyColl) {
            this.currencyMap.put(currencyInfo.getId().toString(), currencyInfo.getPrecision());
        }
        this.isFirstLoaded = false;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gl.app.AssInitExportQuery";
    }

    private String[][] dealAsstGroup(String asstGroup) {
        String[][] list = null;
        String[] groups = asstGroup.split(";");
        list = new String[groups.length][3];
        for (int i = 0; i < groups.length; ++i) {
            String[] ss = groups[i].replaceAll("_!", ":").split(":");
            if (ss.length < 3) {
                return null;
            }
            for (int j = 0; j < 3; ++j) {
                list[i][j] = VoucherUtil.decodeSplitFlag((String)ss[j]);
            }
        }
        return list;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        Set keySet = paramMap.keySet();
        if (keySet.contains("DATATASKMODE")) {
            String orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("ORGUNIT.id", (Object)orgId));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CompareType.NOTINCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), CompareType.NOTINCLUDE));
        } else {
            for (String key : keySet) {
                String value = (String)paramMap.get(key);
                filter.getFilterItems().add(new FilterItemInfo(key, (Object)value));
            }
        }
        return filter;
    }

    @Override
    protected String getType() {
        return "InitAssistBalance";
    }

    private Map<String, String> getCaamu(Context ctx, String caaname, String accountNumber, String companyid) throws BOSException, SQLException {
        String key = caaname + "_" + accountNumber + "_" + companyid;
        if (this.caamus.containsKey(key)) {
            return this.caamus.get(key);
        }
        String sqlToGetAcctType = "SELECT TOP 1 b.FID,b.fmeasureunitgroupid FROM T_BD_AsstAccount b join t_bd_accountview a on a.fcaa=b.fid where rtrim(ltrim(b.Fname_" + ctx.getLocale() + "))=? and a.fnumber=? and a.fcompanyid=?";
        IRowSet rsToGetAcctType = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctType, (Object[])new Object[]{caaname, accountNumber, companyid});
        HashMap<String, String> caamu = null;
        if (rsToGetAcctType != null && rsToGetAcctType.next()) {
            caamu = new HashMap<String, String>();
            caamu.put("faccid", rsToGetAcctType.getString("FID"));
            caamu.put("fmeasureunitgroupid", rsToGetAcctType.getString("fmeasureunitgroupid"));
            this.caamus.put(key, caamu);
        }
        return caamu;
    }

    private List<Map<String, String>> getCaa(Context ctx, String faccid) throws BOSException, SQLException {
        if (this.caas.containsKey(faccid)) {
            return this.caas.get(faccid);
        }
        String sqltoacctaccount = "select c.Fname_" + ctx.getLocale() + " Fname, c.FAsstHgAttribute from T_BD_AsstAccount a  inner join T_BD_AsstActGroupDetail b on a.fid=b.fasstaccountid  inner join  t_bd_asstacttype c on b.fasstacttypeid=c.fid where a.FID=? order by b.fseq";
        IRowSet rsToGetAcctname = DbUtil.executeQuery((Context)ctx, (String)sqltoacctaccount, (Object[])new Object[]{faccid});
        ArrayList<Map<String, String>> caa = null;
        if (rsToGetAcctname != null) {
            caa = new ArrayList<Map<String, String>>();
            while (rsToGetAcctname.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Fname", rsToGetAcctname.getString("Fname"));
                map.put("FAsstHgAttribute", rsToGetAcctname.getString("FAsstHgAttribute"));
                caa.add(map);
            }
        }
        this.caas.put(faccid, caa);
        return caa;
    }

    public AssistantHGInfo findAssistantHG(Context ctx, String caaId, AsstActTypeCollection types, AssistantHGInfo inHg) throws BOSException, EASBizException {
        String key = caaId;
        for (int i = 0; i < types.size(); ++i) {
            AsstActTypeInfo type = types.get(i);
            String attr = type.getAsstHGAttribute();
            DataBaseInfo dataInfo = (DataBaseInfo)inHg.get(attr);
            key = key + "_" + attr + "_" + dataInfo.getId().toString();
        }
        if (this.assistantHGs.containsKey(key)) {
            return this.assistantHGs.get(key);
        }
        AssistantHGInfo info = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(inHg, caaId, types);
        AsstAccountInfo caa = new AsstAccountInfo();
        caa.setId(BOSUuid.read((String)caaId));
        info.setAsstAccount(caa);
        this.assistantHGs.put(key, info);
        return info;
    }
}

