/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VchAmortDestAccountCollection;
import com.kingdee.eas.fi.gl.VchAmortDestAccountInfo;
import com.kingdee.eas.fi.gl.VchAmortDestAssistCollection;
import com.kingdee.eas.fi.gl.VchAmortDestAssistInfo;
import com.kingdee.eas.fi.gl.VchAmortException;
import com.kingdee.eas.fi.gl.VchAmortPolicyCollection;
import com.kingdee.eas.fi.gl.VchAmortPolicyInfo;
import com.kingdee.eas.fi.gl.VchAmortSchemeInfo;
import com.kingdee.eas.fi.gl.VchAmortTargetAccountCollection;
import com.kingdee.eas.fi.gl.VchAmortTargetAccountInfo;
import com.kingdee.eas.fi.gl.VchAmortTargetAssistCollection;
import com.kingdee.eas.fi.gl.VchAmortTargetAssistInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class VchAmortUtils {
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");
    public static final String ASSITEM_PREFIX = "#";
    public static final String AMT_FORMAT_ERROR = "AMT_FORMAT_ERROR";
    public static final String PERIOD_FORMAT_ERROR = "PERIOD_FORMAT_ERROR";
    public static final String PERIOD_BEYOND_RANGE = "PERIOD_BEYOND_RANGE";
    public static final String RATIO_CANNOT_NEGATIVE = "RATIO_CANNOT_NEGATIVE";
    public static final String FORMULA_NOT_AVAILABLE = "FORMULA_NOT_AVAILABLE";
    public static final String ERROR_WHEN_CALCULATE_FORMULA = "ERROR_WHEN_CALCULATE_FORMULA";
    public static final String SCHEME_GEN_VOUCHER_DEL_FORBID = "SCHEME_GEN_VOUCHER_DEL_FORBID";
    public static final String SCHEME_DELETED = "SCHEME_DELETED";
    public static final String SCHEME_FINISHED = "SCHEME_FINISHED";
    public static final String SCHEME_CLOSED = "SCHEME_CLOSED";
    public static final String PERIOD_NOT_VOUCHER = "PERIOD_NOT_VOUCHER";
    public static final String PERIOD_GEN_VOUCHER = "PERIOD_GEN_VOUCHER";
    public static final String SCHEME_MODIFY_REFRESH_GEN_VOUCHER = "SCHEME_MODIFY_REFRESH_GEN_VOUCHER";
    public static final String SCHEME_MODIFY_REFRESH = "SCHEME_MODIFY_REFRESH";
    public static final String AMORT_VOUCHER_NOT_CANCEL = "AMORT_VOUCHER_NOT_CANCEL";
    public static final String ENDPERIOD_WHEN_SCHEME_NOT_VOUCHER = "ENDPERIOD_WHEN_SCHEME_NOT_VOUCHER";
    public static final String POLICY_AMT_LARGE = "POLICY_AMT_LARGE";
    public static final String POLICY_AMT_SIGNUM_ERROR = "POLICY_AMT_SIGNUM_ERROR";
    public static final String SCHEME_NAME = "SCHEME_NAME";
    public static final String GEN_VOUCHER_FAILED = "GEN_VOUCHER_FAILED";
    public static final String SCHEME_NUMBER = "SCHEME_NUMBER";
    public static final String RATIO_BEYOND_RANGE = "RATIO_BEYOND_RANGE";
    public static final String SCHEME_VOUCHER_ERROR = "SCHEME_VOUCHER_ERROR";
    public static final String NOT_SUPPORT_ADVANCE_TOTAL = "NOT_SUPPORT_ADVANCE_TOTAL";
    public static final String RES_PATH = "com.kingdee.eas.fi.gl.VchAmortResource";
    public static final String PARAM_PERIODS = "Periods";
    public static final String PARAM_CUR_PERIOD = "CurPeriod";
    public static final Integer STATUS_NEW = new Integer(1);
    public static final Integer STATUS_DELETED = new Integer(2);
    public static final Integer STATUS_MODIFIED = new Integer(3);
    public static final String STATUS_KEY = "Status";

    public static void checkTargetValid(VchAmortSchemeInfo schemeInfo, Map params, boolean mustNeedProfitCenter) throws EASBizException, BOSException {
        VchAmortTargetAccountInfo targetAccount = null;
        AccountViewInfo av = null;
        ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = null;
        BigDecimal totalTargetAmount = GlUtils.zero;
        VchAmortTargetAccountCollection targetAccounts = schemeInfo.getTargetAccounts();
        for (int i = 0; i < targetAccounts.size(); ++i) {
            targetAccount = targetAccounts.get(i);
            profitCenterOrgUnitInfo = targetAccount.getProfitCenter();
            if (mustNeedProfitCenter && profitCenterOrgUnitInfo == null) {
                throw new VchAmortException(VchAmortException.TAC_NOT_EXIST_PROFITCENTER, new Object[]{new Integer(i + 1)});
            }
            av = targetAccount.getAccount();
            if (av == null) {
                throw new VchAmortException(VchAmortException.TAC_NOT_EXIST, new Object[]{new Integer(i + 1)});
            }
            if (!av.isIsLeaf()) {
                throw new VchAmortException(VchAmortException.TAC_NOT_LEAF, new Object[]{new Integer(i + 1)});
            }
            if (av.isIsGFreeze() || av.isIsCFreeze() || av.isIsSelfFreeze()) {
                throw new VchAmortException(VchAmortException.TAC_DISABLED, new Object[]{new Integer(i + 1)});
            }
            if (targetAccount.getPlanAmount() == null) {
                throw new VchAmortException(VchAmortException.TAC_AMT_NULL, new Object[]{new Integer(i + 1)});
            }
            if (targetAccount.getPlanAmount().signum() == 0) {
                throw new VchAmortException(VchAmortException.TAC_AMT_ZERO, new Object[]{new Integer(i + 1)});
            }
            totalTargetAmount = totalTargetAmount.add(targetAccount.getPlanAmount());
            BigDecimal totalAssistAmount = GlUtils.zero;
            VchAmortTargetAssistCollection targetAsssists = VchAmortUtils.getUsedTargetAssist(targetAccount);
            VchAmortTargetAssistInfo targetAssist = null;
            for (int j = 0; j < targetAsssists.size(); ++j) {
                targetAssist = targetAsssists.get(j);
                if (av.getCAA() != null && (targetAssist.getAssGrp() == null || targetAssist.getAssGrp().getId() == null)) {
                    throw new VchAmortException(VchAmortException.TAS_LACK_ASSIST, new Object[]{new Integer(i + 1), new Integer(j + 1)});
                }
                if (targetAssist.getPlanAmount() == null) {
                    throw new VchAmortException(VchAmortException.TAS_AMT_NULL, new Object[]{new Integer(i + 1), new Integer(j + 1)});
                }
                if (targetAssist.getPlanAmount().signum() == 0) {
                    throw new VchAmortException(VchAmortException.TAS_AMT_ZERO, new Object[]{new Integer(i + 1), new Integer(j + 1)});
                }
                totalAssistAmount = totalAssistAmount.add(targetAssist.getPlanAmount());
            }
            if (targetAsssists.size() > 0 && totalAssistAmount.compareTo(targetAccount.getPlanAmount()) != 0) {
                throw new VchAmortException(VchAmortException.TAS_SUM_NOTEQUAL_TAC, new Object[]{new Integer(i + 1), targetAccount.getPlanAmount(), totalAssistAmount});
            }
            if (av.getCAA() == null || targetAccount.getAssists() != null && targetAccount.getAssists().size() != 0) continue;
            throw new VchAmortException(VchAmortException.TAC_LACK_TAS, new Object[]{new Integer(i + 1)});
        }
        int targetAccountCount = schemeInfo.getTargetAccounts().size();
        if (targetAccountCount <= 0) {
            throw new VchAmortException(VchAmortException.ONE_TAC_MUST);
        }
        params.put("TotalTargetAmount", totalTargetAmount);
    }

    public static void checkDestValid(VchAmortSchemeInfo schemeInfo, Map params) throws EASBizException, BOSException {
        VchAmortDestAccountInfo destAccount = null;
        AccountViewInfo av = null;
        BigDecimal totalDestAccountRatio = GlUtils.zero;
        VchAmortDestAccountCollection destAccounts = schemeInfo.getDestAccounts();
        for (int i = 0; i < destAccounts.size(); ++i) {
            destAccount = destAccounts.get(i);
            av = destAccount.getAccount();
            if (av == null) {
                throw new VchAmortException(VchAmortException.DAC_NOT_EXIST, new Object[]{new Integer(i + 1)});
            }
            if (!av.isIsLeaf()) {
                throw new VchAmortException(VchAmortException.DAC_NOT_LEAF, new Object[]{new Integer(i + 1)});
            }
            if (av.isIsGFreeze() || av.isIsCFreeze() || av.isIsSelfFreeze()) {
                throw new VchAmortException(VchAmortException.DAC_DISABLED, new Object[]{new Integer(i + 1)});
            }
            if (destAccount.getRatio() == null) {
                throw new VchAmortException(VchAmortException.DAC_RATIO_NULL, new Object[]{new Integer(i + 1)});
            }
            if (destAccount.getRatio().signum() == 0) {
                throw new VchAmortException(VchAmortException.DAC_RATIO_ZERO, new Object[]{new Integer(i + 1)});
            }
            if (destAccount.getRatio().signum() < 0) {
                throw new VchAmortException(VchAmortException.DAC_RATIO_NEGATIVE, new Object[]{new Integer(i + 1)});
            }
            totalDestAccountRatio = totalDestAccountRatio.add(destAccount.getRatio());
            BigDecimal totalAssistRatio = GlUtils.zero;
            VchAmortDestAssistCollection destAssists = VchAmortUtils.getUsedDestAssist(destAccount);
            VchAmortDestAssistInfo destAssist = null;
            for (int j = 0; j < destAssists.size(); ++j) {
                destAssist = destAssists.get(j);
                if (av.getCAA() != null && (destAssist.getAssGrp() == null || destAssist.getAssGrp().getId() == null)) {
                    throw new VchAmortException(VchAmortException.DAS_LACK_ASSIST, new Object[]{new Integer(i + 1), new Integer(j + 1)});
                }
                if (destAssist.getRatio() == null) {
                    throw new VchAmortException(VchAmortException.DAS_RATIO_NULL, new Object[]{new Integer(i + 1), new Integer(j + 1)});
                }
                if (destAssist.getRatio().signum() == 0) {
                    throw new VchAmortException(VchAmortException.DAS_RATIO_ZERO, new Object[]{new Integer(i + 1), new Integer(j + 1)});
                }
                if (destAssist.getRatio().signum() < 0) {
                    throw new VchAmortException(VchAmortException.DAS_RATIO_NEGATIVE, new Object[]{new Integer(i + 1), new Integer(j + 1)});
                }
                totalAssistRatio = totalAssistRatio.add(destAssist.getRatio());
            }
            if (destAssists.size() > 0 && totalAssistRatio.compareTo(ONE_HUNDRED) != 0) {
                throw new VchAmortException(VchAmortException.DAS_RATIO_SUM_NOT_CORRECT, new Object[]{new Integer(i + 1), totalAssistRatio});
            }
            if (av.getCAA() == null || destAccount.getAssists() != null && destAccount.getAssists().size() != 0) continue;
            throw new VchAmortException(VchAmortException.DAC_LACK_DAS, new Object[]{new Integer(i + 1)});
        }
        if (totalDestAccountRatio.compareTo(ONE_HUNDRED) != 0) {
            throw new VchAmortException(VchAmortException.DAC_RATIO_SUM_NOT_CORRECT, new Object[]{totalDestAccountRatio});
        }
        int destAccountCount = schemeInfo.getDestAccounts().size();
        if (destAccountCount <= 0) {
            throw new VchAmortException(VchAmortException.ONE_DAC_MUST);
        }
    }

    public static String checkAssistIntegrity(Object[] info, AccountViewInfo acc, AssistantHGInfo assGrp) {
        VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        if (assItemCols.length > 0) {
            for (int i = 0; i < assItemCols.length; ++i) {
                String propName = assItemCols[i].getMappingPropName();
                Object val = assGrp.get(propName);
                if (val != null) continue;
                return ASSITEM_PREFIX + propName;
            }
        }
        return null;
    }

    public static void checkPolicyValid(VchAmortSchemeInfo schemeInfo, Map params) throws EASBizException, BOSException {
        if (schemeInfo.getPolicies() == null || schemeInfo.getPolicies().size() == 0) {
            throw new VchAmortException(VchAmortException.ONE_POLICY_MUST);
        }
        BigDecimal totalTargetAmount = (BigDecimal)params.get("TotalTargetAmount");
        VchAmortPolicyInfo policy = null;
        BigDecimal totalPolicyRatio = GlUtils.zero;
        BigDecimal totalPolicyAmount = GlUtils.zero;
        VchAmortPolicyCollection policies = schemeInfo.getPolicies();
        for (int i = 0; i < policies.size(); ++i) {
            policy = policies.get(i);
            if (policy.getPeriod() == null) {
                throw new VchAmortException(VchAmortException.PERIOD_NOT_CORRECT, new Object[]{new Integer(i + 1)});
            }
            if (policy.getRatio() == null) {
                throw new VchAmortException(VchAmortException.POLICY_RATIO_NULL, new Object[]{new Integer(i + 1)});
            }
            if (policy.getRatio().signum() == 0) {
                throw new VchAmortException(VchAmortException.POLICY_RATIO_ZERO, new Object[]{new Integer(i + 1)});
            }
            if (policy.getRatio().signum() < 0) {
                throw new VchAmortException(VchAmortException.POLICY_RATIO_NEGATIVE, new Object[]{new Integer(i + 1)});
            }
            if (policy.getAmount() == null) {
                throw new VchAmortException(VchAmortException.POLICY_AMT_NULL, new Object[]{new Integer(i + 1)});
            }
            if (policy.getAmount().signum() == 0) {
                throw new VchAmortException(VchAmortException.POLICY_AMT_ZERO, new Object[]{new Integer(i + 1)});
            }
            totalPolicyAmount = totalPolicyAmount.add(policy.getAmount());
            totalPolicyRatio = totalPolicyRatio.add(policy.getRatio());
            if (policies.size() - 1 != i || totalTargetAmount.compareTo(totalPolicyAmount) != 0 || totalPolicyRatio.compareTo(ONE_HUNDRED) == 0) continue;
            policy.setRatio(policy.getRatio().add(ONE_HUNDRED.subtract(totalPolicyRatio)));
            totalPolicyRatio = totalPolicyRatio.add(ONE_HUNDRED.subtract(totalPolicyRatio));
        }
        if (totalPolicyRatio.compareTo(ONE_HUNDRED) != 0) {
            throw new VchAmortException(VchAmortException.POLICY_RATIO_SUM_NOT_CORRECT, new Object[]{totalPolicyRatio});
        }
        if (totalTargetAmount.compareTo(totalPolicyAmount) != 0) {
            throw new VchAmortException(VchAmortException.POLICY_AMT_SUM_NOT_CORRECT, new Object[]{totalPolicyAmount, totalTargetAmount});
        }
        if (VchAmortUtils.isExistsSamePeriod(schemeInfo.getPolicies())) {
            throw new VchAmortException(VchAmortException.PERIOD_EXIST_SAME);
        }
    }

    public static boolean isExistsSamePeriod(VchAmortPolicyCollection policies) {
        if (policies == null || policies.size() == 0) {
            return false;
        }
        int size = policies.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (!policies.get(i).getPeriod().getId().toString().equals(policies.get(j).getPeriod().getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPeriodString(int periodYear, int periodNumber) {
        if (periodNumber < 10) {
            return String.valueOf(periodYear) + ".0" + String.valueOf(periodNumber);
        }
        return String.valueOf(periodYear) + "." + String.valueOf(periodNumber);
    }

    public static PeriodInfo getNextAvailabePeriod(Map periods, String year, String number) {
        PeriodInfo prePeriod = VchAmortUtils.getAvailabePeriod(periods, year, number);
        if (prePeriod == null) {
            return null;
        }
        PeriodInfo nextPeriod = VchAmortUtils.getAvailabePeriod(periods, String.valueOf(prePeriod.getPeriodYear()), String.valueOf(prePeriod.getPeriodNumber() + 1));
        if (nextPeriod != null && !nextPeriod.isIsAdjustPeriod()) {
            return nextPeriod;
        }
        nextPeriod = VchAmortUtils.getAvailabePeriod(periods, String.valueOf(prePeriod.getPeriodYear() + 1), "1");
        return nextPeriod;
    }

    public static PeriodInfo getAvailabePeriod(Map periods, String year, String number) {
        if (year == null || number == null) {
            return null;
        }
        if (number.length() < 2) {
            return (PeriodInfo)periods.get(year + ".0" + number);
        }
        return (PeriodInfo)periods.get(year + "." + number);
    }

    public static String getResource(Context ctx, String key, Object[] params) {
        String message = ResourceBase.getString((String)RES_PATH, (String)key, (Locale)ctx.getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }

    public static String getResource(String key, Object[] params) {
        String message = EASResource.getString((String)RES_PATH, (String)key);
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }

    public static VchAmortTargetAssistCollection getUsedTargetAssist(VchAmortTargetAccountInfo info) {
        VchAmortTargetAssistCollection newAssists = new VchAmortTargetAssistCollection();
        VchAmortTargetAssistCollection assists = info.getAssists();
        VchAmortTargetAssistInfo assist = null;
        for (int i = 0; i < assists.size(); ++i) {
            assist = assists.get(i);
            Object status = assist.get(STATUS_KEY);
            if (status instanceof Integer && STATUS_DELETED.intValue() == ((Integer)status).intValue()) continue;
            newAssists.add(assist);
        }
        return newAssists;
    }

    public static VchAmortDestAssistCollection getUsedDestAssist(VchAmortDestAccountInfo info) {
        VchAmortDestAssistCollection newAssists = new VchAmortDestAssistCollection();
        VchAmortDestAssistCollection assists = info.getAssists();
        VchAmortDestAssistInfo assist = null;
        for (int i = 0; i < assists.size(); ++i) {
            assist = assists.get(i);
            Object status = assist.get(STATUS_KEY);
            if (status instanceof Integer && STATUS_DELETED.intValue() == ((Integer)status).intValue()) continue;
            newAssists.add(assist);
        }
        return newAssists;
    }
}

