/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.ImpVoucherStructure;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherDBFSparser;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherExpImpException;
import com.kingdee.eas.fi.gl.VoucherImpExpParam;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.dbf.utils.DBFException;
import com.kingdee.eas.fi.gl.dbf.utils.DBFField;
import com.kingdee.eas.fi.gl.dbf.utils.DBFReader;
import com.kingdee.eas.fi.gl.dbf.utils.DBFWriter;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class VoucherDBFNewSparser
extends VoucherDBFSparser {
    private boolean hasCompanyNum = true;

    public static String[] getFieldName(DBFReader dbfReader) throws IOException {
        int fieldCount = dbfReader.getFieldCount();
        String[] fieldName = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldName[i] = dbfReader.getField(i).getName();
        }
        return fieldName;
    }

    private WSVoucherCollection getCashFlowMap(boolean isSelectCash, String path, VoucherImpExpParam filterParam) throws VoucherExpImpException {
        if (!isSelectCash) {
            return null;
        }
        WSVoucherCollection cashs = new WSVoucherCollection();
        WSVoucherInfo wsvoucher = null;
        try {
            File file = new File(path);
            DBFReader reader = new DBFReader((InputStream)new FileInputStream(file), Charset.forName("GBK"));
            Object[] values = reader.nextRecord();
            int rows = 1;
            String[] keys = VoucherDBFNewSparser.getFieldName(reader);
            GLRptRowSet rsVoucher = new GLRptRowSet(keys, 1);
            while (values != null && values.length > 0) {
                rsVoucher.insertRow(0);
                rsVoucher.setRowIndex(0);
                for (int i = 0; i < values.length; ++i) {
                    rsVoucher.updateObject(keys[i], values[i]);
                }
                wsvoucher = new WSVoucherInfo();
                wsvoucher.put("lineNum", new Integer(rows + 1));
                wsvoucher.setItemFlag(1);
                if (!this.hasCompanyNum) {
                    wsvoucher.setCompanyNumber(this.getCompany().getNumber());
                } else {
                    wsvoucher.setCompanyNumber(rsVoucher.getString("FGROUPID"));
                }
                java.sql.Date voucherDate = rsVoucher.getDate("FDATE");
                wsvoucher.setBookedDate(voucherDate);
                int periodNum = rsVoucher.getInt("FPERIOD");
                wsvoucher.setPeriodNumber(periodNum);
                if (voucherDate != null) {
                    wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
                }
                String voucherTypeNum = rsVoucher.getString("FGROUP");
                wsvoucher.setVoucherType(voucherTypeNum);
                String vouchernumber = rsVoucher.getString("FNUM");
                wsvoucher.setVoucherNumber(vouchernumber);
                String curNumber = rsVoucher.getString("FCYID");
                wsvoucher.setCurrencyNumber(curNumber);
                int entryesq = rsVoucher.getInt("FENTRYID");
                wsvoucher.setEntrySeq(entryesq);
                int entryoppesq = rsVoucher.getInt("FOPENTRYID");
                wsvoucher.put("cashOppEntrySeq", entryoppesq);
                String primarynumber = rsVoucher.getString("FNUMBER");
                wsvoucher.setPrimaryItem(primarynumber);
                String supplynumber = rsVoucher.getString("FSUBNUMBER");
                wsvoucher.setSupplyItem(supplynumber);
                BigDecimal originalAmount = new BigDecimal(rsVoucher.getObject("FAMOUNTFOR").toString());
                wsvoucher.setCashflowAmountOriginal(originalAmount.doubleValue());
                BigDecimal localamount = new BigDecimal(rsVoucher.getObject("FAMOUNTLOC").toString());
                wsvoucher.setCashflowAmountLocal(localamount.doubleValue());
                BigDecimal reportamount = new BigDecimal(rsVoucher.getObject("FAMOUNTRPT").toString());
                wsvoucher.setCashflowAmountRpt(reportamount.doubleValue());
                int primarycoef = rsVoucher.getInt("FPRICOEF");
                wsvoucher.setPrimaryCoef(primarycoef);
                int supplycoef = rsVoucher.getInt("FSUPCOEF");
                wsvoucher.setSupplyCoef(supplycoef);
                String type = rsVoucher.getString("FTYPE");
                wsvoucher.setType(type);
                int assistCount = 0;
                for (int k = 0; k < 8; ++k) {
                    String obj1 = rsVoucher.getString("FCLSNAME" + (k + 1));
                    String obj2 = rsVoucher.getString("FOBJID" + (k + 1));
                    String obj3 = rsVoucher.getString("FOBJNAME" + (k + 1));
                    if (!(obj1 != null && !"".equals(obj1) || obj2 != null && !"".equals(obj2) || obj3 != null && !"".equals(obj3))) continue;
                    String strAsstActTypeName = null;
                    if (obj1 != null) {
                        strAsstActTypeName = String.valueOf(obj1);
                        wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                    }
                    String strAsstActID = null;
                    if (obj2 != null) {
                        strAsstActID = obj2;
                        wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                    }
                    String strAsstActName = null;
                    if (obj3 != null) {
                        strAsstActName = obj3;
                        wsvoucher.put("asstActName" + assistCount, strAsstActName);
                    }
                    ++assistCount;
                }
                wsvoucher.put("assistCount", new Integer(assistCount));
                cashs.add(wsvoucher);
                rsVoucher = new GLRptRowSet(keys, 1);
                values = reader.nextRecord();
                ++rows;
            }
        }
        catch (Exception e) {
            logger.error((Object)"read dbf file error:", (Throwable)e);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
        }
        return cashs;
    }

    private static Date convertStringToDate(String dateStr) {
        if (StringUtils.isEmpty((String)dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    private WSVoucherCollection getVchList(String path, VoucherImpExpParam filterParam) throws VoucherExpImpException {
        WSVoucherCollection vchs = new WSVoucherCollection();
        WSVoucherInfo wsvoucher = null;
        java.sql.Date begin = filterParam.getDateBegin();
        java.sql.Date end = filterParam.getDateEnd();
        String numberBegin = filterParam.getINumberBegin();
        String numberEnd = filterParam.getINumberEnd();
        VoucherTypeInfo filteVoucherTypeInfo = filterParam.getVoucherTypeInfo();
        try (DBFReader reader = null;){
            File file = new File(path);
            reader = new DBFReader((InputStream)new FileInputStream(file), Charset.forName("GBK"));
            Object[] values = reader.nextRecord();
            int rows = 1;
            String[] keys = VoucherDBFNewSparser.getFieldName(reader);
            GLRptRowSet rsVoucher = new GLRptRowSet(keys, 1);
            HashMap map = new HashMap();
            while (values != null && values.length > 0) {
                List<WSVoucherInfo> list;
                java.sql.Date asstBizDate;
                String objSupplier;
                String objCompanyOrgUnit;
                String objMaterial;
                String objHandler;
                String objFeeType;
                String objCustomer;
                String strTicketNumber;
                BigDecimal cAmount;
                BigDecimal dAmount;
                BigDecimal price;
                BigDecimal quantity;
                rsVoucher.insertRow(0);
                rsVoucher.setRowIndex(0);
                for (int i = 0; i < values.length; ++i) {
                    rsVoucher.updateObject(keys[i], values[i]);
                }
                wsvoucher = new WSVoucherInfo();
                wsvoucher.put("lineNum", new Integer(rows));
                if (!this.hasCompanyNum) {
                    wsvoucher.setCompanyNumber(this.getCompany().getNumber());
                } else {
                    wsvoucher.setCompanyNumber(rsVoucher.getObject("FGROUPID") != null ? rsVoucher.getString("FGROUPID") : this.getCompany().getNumber());
                }
                java.sql.Date d = rsVoucher.getDate("FDATE") != null ? rsVoucher.getDate("FDATE") : (rsVoucher.getObject("FDATE") != null && !StringUtils.isEmpty((String)rsVoucher.getObject("FDATE").toString()) ? (Date)rsVoucher.getObject("FDATE") : null);
                java.sql.Date voucherDate = d == null ? null : new java.sql.Date(d.getTime());
                wsvoucher.setBookedDate(voucherDate);
                if (voucherDate != null && (voucherDate.before(begin) || voucherDate.after(end))) {
                    rsVoucher = new GLRptRowSet(keys, 1);
                    values = reader.nextRecord();
                    ++rows;
                    continue;
                }
                d = rsVoucher.getDate("FTRANSDATE") != null ? rsVoucher.getDate("FTRANSDATE") : (rsVoucher.getObject("FTRANSDATE") != null && !StringUtils.isEmpty((String)rsVoucher.getObject("FTRANSDATE").toString()) ? (Date)rsVoucher.getObject("FTRANSDATE") : null);
                wsvoucher.setBizDate(d == null ? null : new java.sql.Date(d.getTime()));
                int periodNum = rsVoucher.getInt("FPERIOD");
                wsvoucher.setPeriodNumber(periodNum);
                if (voucherDate != null) {
                    wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
                } else if (rsVoucher.getDate("FTRANSDATE") != null) {
                    wsvoucher.setPeriodYear(rsVoucher.getDate("FTRANSDATE").getYear() + 1900);
                }
                String voucherTypeNum = rsVoucher.getString("FGROUP");
                wsvoucher.setVoucherType(voucherTypeNum);
                String vouchernumber = rsVoucher.getObject("FNUM").toString();
                wsvoucher.setVoucherNumber(vouchernumber);
                if (numberBegin != null && numberBegin.trim().length() > 0 || numberEnd != null && numberEnd.trim().length() > 0) {
                    if (filteVoucherTypeInfo != null && !voucherTypeNum.equals(filteVoucherTypeInfo.getName())) {
                        rsVoucher = new GLRptRowSet(keys, 1);
                        values = reader.nextRecord();
                        ++rows;
                        continue;
                    }
                    if (numberBegin != null && numberBegin.trim().length() > 0 && vouchernumber.compareTo(numberBegin.trim()) < 0) {
                        rsVoucher = new GLRptRowSet(keys, 1);
                        values = reader.nextRecord();
                        ++rows;
                        continue;
                    }
                    if (numberEnd != null && numberEnd.trim().length() > 0 && vouchernumber.compareTo(numberEnd.trim()) > 0) {
                        rsVoucher = new GLRptRowSet(keys, 1);
                        values = reader.nextRecord();
                        ++rows;
                        continue;
                    }
                }
                if (filteVoucherTypeInfo != null && !voucherTypeNum.equals(filteVoucherTypeInfo.getName())) {
                    rsVoucher = new GLRptRowSet(keys, 1);
                    values = reader.nextRecord();
                    ++rows;
                    continue;
                }
                int iSeq = rsVoucher.getInt("FENTRYID");
                wsvoucher.setEntrySeq(iSeq);
                String voucherAbstract = rsVoucher.getString("FEXP");
                wsvoucher.setVoucherAbstract(voucherAbstract);
                String strAccountView = rsVoucher.getString("FACCTID");
                wsvoucher.setAccountNumber(strAccountView);
                String strCurrenyISOcode = rsVoucher.getString("FCYID");
                wsvoucher.setCurrencyNumber(strCurrenyISOcode);
                BigDecimal exchangeRate = rsVoucher.getObject("FEXCHRATE") != null ? new BigDecimal(rsVoucher.getObject("FEXCHRATE").toString()) : null;
                exchangeRate = exchangeRate != null ? exchangeRate.setScale(10, 4) : GlUtils.zero;
                wsvoucher.setLocalRate(exchangeRate.doubleValue());
                int asstDC = rsVoucher.getInt("FDC");
                wsvoucher.setEntryDC(asstDC);
                BigDecimal originalAmount = new BigDecimal(rsVoucher.getObject("FFCYAMT").toString());
                if (originalAmount != null) {
                    wsvoucher.setOriginalAmount(originalAmount.doubleValue());
                }
                BigDecimal bigDecimal = quantity = rsVoucher.getObject("FQTY") != null ? new BigDecimal(rsVoucher.getObject("FQTY").toString()) : null;
                if (quantity != null) {
                    wsvoucher.setQty(quantity.doubleValue());
                }
                BigDecimal qty = GlUtils.zero;
                try {
                    qty = new BigDecimal(rsVoucher.getObject("FASSISTQTY").toString());
                }
                catch (Exception e) {
                    qty = GlUtils.zero;
                }
                if (qty != null) {
                    wsvoucher.put("assistQty", qty);
                }
                BigDecimal bigDecimal2 = price = rsVoucher.getObject("FPRICE") != null ? new BigDecimal(rsVoucher.getObject("FPRICE").toString()) : null;
                if (price != null) {
                    wsvoucher.setPrice(price.doubleValue());
                }
                BigDecimal bigDecimal3 = dAmount = rsVoucher.getObject("FDEBIT") != null ? new BigDecimal(rsVoucher.getObject("FDEBIT").toString()) : null;
                if (dAmount != null) {
                    wsvoucher.setDebitAmount(dAmount.doubleValue());
                }
                BigDecimal bigDecimal4 = cAmount = rsVoucher.getObject("FCREDIT") != null ? new BigDecimal(rsVoucher.getObject("FCREDIT").toString()) : null;
                if (cAmount != null) {
                    wsvoucher.setCreditAmount(cAmount.doubleValue());
                }
                String strCreator = rsVoucher.getString("FPREPARE");
                wsvoucher.setCreator(strCreator);
                int iAttachments = 0;
                try {
                    iAttachments = rsVoucher.getInt("FATTCHMENT");
                }
                catch (Exception e) {
                    iAttachments = 0;
                }
                wsvoucher.setAttaches(iAttachments);
                wsvoucher.put("module", null);
                wsvoucher.put("deleted", null);
                wsvoucher.put("pingzhengxuhao", rsVoucher.getObject("FSERIALNO") != null ? rsVoucher.getObject("FSERIALNO").toString() : null);
                String strUnitName = !StringUtils.isEmpty((String)rsVoucher.getString("FUNITNAME")) ? rsVoucher.getString("FUNITNAME") : null;
                wsvoucher.setMeasurement(strUnitName);
                try {
                    String strAssistUnitName = !StringUtils.isEmpty((String)rsVoucher.getString("FASSISTUNI")) ? rsVoucher.getString("FASSISTUNI") : null;
                    wsvoucher.put("assistUnit", strAssistUnitName);
                }
                catch (Exception e) {
                    wsvoucher.put("assistUnit", null);
                }
                String description = rsVoucher.getString("FREFERENCE");
                wsvoucher.setDescription(description);
                wsvoucher.put("cashflowFlag", null);
                int itemFlag = 0;
                wsvoucher.setItemFlag(itemFlag);
                String bizNumber = rsVoucher.getString("FTRANSID");
                wsvoucher.setBizNumber(bizNumber);
                String objSettleCode = rsVoucher.getString("FSETTLCODE");
                wsvoucher.setSettlementType(objSettleCode);
                String strSettleNumber = rsVoucher.getString("FSETTLENO");
                wsvoucher.setSettlementNumber(strSettleNumber);
                String des = rsVoucher.getString("FDES");
                wsvoucher.put("asstAbstract", des);
                int assistCount = 0;
                for (int k = 0; k < 8; ++k) {
                    String obj1 = rsVoucher.getString("FCLSNAME" + (k + 1));
                    String obj2 = rsVoucher.getString("FOBJID" + (k + 1));
                    String obj3 = rsVoucher.getString("FOBJNAME" + (k + 1));
                    if (!(obj1 != null && !"".equals(obj1) || obj2 != null && !"".equals(obj2) || obj3 != null && !"".equals(obj3))) continue;
                    String strAsstActTypeName = null;
                    if (obj1 != null) {
                        strAsstActTypeName = String.valueOf(obj1);
                        wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                    }
                    String strAsstActID = null;
                    if (obj2 != null) {
                        strAsstActID = obj2;
                        wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                    }
                    String strAsstActName = null;
                    if (obj3 != null) {
                        strAsstActName = obj3;
                        wsvoucher.put("asstActName" + assistCount, strAsstActName);
                    }
                    ++assistCount;
                }
                wsvoucher.put("assistCount", new Integer(assistCount));
                String strInvoiceNumber = rsVoucher.getString("FINVNUM");
                if (strInvoiceNumber != null) {
                    wsvoucher.setInvoiceNumber(strInvoiceNumber);
                }
                if ((strTicketNumber = rsVoucher.getString("FTICKETNUM")) != null) {
                    wsvoucher.put("ticketNumber", strTicketNumber.toString());
                }
                if ((objCustomer = rsVoucher.getString("FCUSTOMER")) != null) {
                    wsvoucher.put("customer", objCustomer);
                }
                if ((objFeeType = rsVoucher.getString("FFEETYPE")) != null) {
                    wsvoucher.put("feeType", objFeeType);
                }
                if ((objHandler = rsVoucher.getString("FHANDLER")) != null) {
                    wsvoucher.put("handler", objHandler);
                }
                if ((objMaterial = rsVoucher.getString("FMATERIAL")) != null) {
                    wsvoucher.put("material", objMaterial);
                }
                if ((objCompanyOrgUnit = rsVoucher.getString("FORGUNIT")) != null) {
                    wsvoucher.put("orgUnit", objCompanyOrgUnit);
                }
                if ((objSupplier = rsVoucher.getString("FSUPPLIER")) != null) {
                    wsvoucher.put("supplier", objSupplier);
                }
                d = rsVoucher.getDate("FBIZDATE") != null ? rsVoucher.getDate("FBIZDATE") : (rsVoucher.getObject("FBIZDATE") != null && !StringUtils.isEmpty((String)rsVoucher.getObject("FBIZDATE").toString()) ? (Date)rsVoucher.getObject("FBIZDATE") : null);
                java.sql.Date date = asstBizDate = d == null ? null : new java.sql.Date(d.getTime());
                if (asstBizDate != null) {
                    wsvoucher.setAssistBizDate(asstBizDate);
                }
                d = rsVoucher.getDate("FENDDATE") != null ? rsVoucher.getDate("FENDDATE") : (rsVoucher.getObject("FENDDATE") != null && !StringUtils.isEmpty((String)rsVoucher.getObject("FENDDATE").toString()) ? (Date)rsVoucher.getObject("FENDDATE") : null);
                java.sql.Date endDate = d == null ? null : new java.sql.Date(d.getTime());
                wsvoucher.setAssistEndDate(endDate);
                StringBuffer keyStr = new StringBuffer(wsvoucher.getCompanyNumber()).append("_").append(wsvoucher.getPeriodYear()).append(wsvoucher.getPeriodNumber()).append("_").append(wsvoucher.getVoucherType()).append("_").append(wsvoucher.getVoucherNumber());
                if (map.containsKey(keyStr.toString())) {
                    list = (List)map.get(keyStr.toString());
                    list.add(wsvoucher);
                } else {
                    list = new ArrayList<WSVoucherInfo>();
                    list.add(wsvoucher);
                    map.put(keyStr.toString(), list);
                }
                rsVoucher = new GLRptRowSet(keys, 1);
                values = reader.nextRecord();
                ++rows;
            }
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                List list = (List)map.get((String)iter.next());
                Collections.sort(list, new Comparator<WSVoucherInfo>(){

                    @Override
                    public int compare(WSVoucherInfo v1, WSVoucherInfo v2) {
                        return v1.getEntrySeq() - v2.getEntrySeq();
                    }
                });
                for (Object item : list) {
                    vchs.add((WSVoucherInfo)item);
                }
            }
        }
        return vchs;
    }

    @Override
    public IObjectCollection getImpVoucherList(String strFullName, String strPath, String strFileName, VoucherImpExpParam filterParam) throws EASBizException, BOSException {
        WSVoucherCollection vchs = this.getVchList(strFullName, filterParam);
        if (filterParam.isSelectCash()) {
            int iIndex = strFullName.toLowerCase().lastIndexOf(".dbf");
            String strCFFullFile = strFullName.substring(0, iIndex);
            strCFFullFile = strCFFullFile + "CF.dbf";
            WSVoucherCollection cashs = this.getCashFlowMap(filterParam.isSelectCash(), strCFFullFile, filterParam);
            vchs.addCollection(cashs);
        }
        return vchs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCompanyNum(Connection conn, String strFullName) {
        boolean hasComNum = false;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("select top 1 * from " + strFullName);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            hasComNum = "FGROUPID".equalsIgnoreCase(rsmd.getColumnName(1));
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        catch (SQLException e) {
            hasComNum = false;
        }
        finally {
            SQLUtils.cleanup(rs, ps);
        }
        return hasComNum;
    }

    @Override
    public void checkFileValidate(String strFilePath, String strFileName) throws EASBizException {
        String[][] keys = new String[][]{{"fgroupid", "char"}, {"fdate", "date"}, {"ftransdate", "date"}, {"fperiod", "int"}, {"fgroup", "char"}, {"fnum", "char"}, {"fentryid", "int"}, {"fexp", "char"}, {"facctid", "char"}, {"fclsname1", "char"}, {"fobjid1", "char"}, {"fobjname1", "char"}, {"fclsname2", "char"}, {"fobjid2", "char"}, {"fobjname2", "char"}, {"fclsname3", "char"}, {"fobjid3", "char"}, {"fobjname3", "char"}, {"fclsname4", "char"}, {"fobjid4", "char"}, {"fobjname4", "char"}, {"fclsname5", "char"}, {"fobjid5", "char"}, {"fobjname5", "char"}, {"fclsname6", "char"}, {"fobjid6", "char"}, {"fobjname6", "char"}, {"fclsname7", "char"}, {"fobjid7", "char"}, {"fobjname7", "char"}, {"fclsname8", "char"}, {"fobjid8", "char"}, {"fobjname8", "char"}, {"fdes", "char"}, {"ftransid", "char"}, {"fcyid", "char"}, {"fexchrate", "decimal"}, {"fdc", "char"}, {"ffcyamt", "decimal"}, {"fqty", "decimal"}, {"fassistqty", "decimal"}, {"fprice", "decimal"}, {"fdebit", "decimal"}, {"fcredit", "decimal"}, {"fsettlcode", "char"}, {"fsettleno", "char"}, {"fprepare", "char"}, {"fpay", "char"}, {"fcash", "char"}, {"fposter", "char"}, {"fchecker", "char"}, {"fattchment", "int"}, {"fposted", "logical"}, {"fmodule", "char"}, {"fdeleted", "logical"}, {"fserialno", "char"}, {"funitname", "char"}, {"fassistuni", "char"}, {"freference", "char"}, {"fcashflow", "int"}, {"finvnum", "char"}, {"fticketnum", "char"}, {"fcustomer", "char"}, {"ffeetype", "char"}, {"forgunit", "char"}, {"fmaterial", "char"}, {"fhandler", "char"}, {"fsupplier", "char"}, {"fbizdate", "date"}, {"fenddate", "date"}};
        File file = new File(strFilePath + strFileName);
        try {
            DBFReader reader = new DBFReader(new FileInputStream(file));
            int fieldCount = reader.getFieldCount();
            Object fieldName = null;
            for (int i = 0; i < fieldCount; ++i) {
            }
        }
        catch (DBFException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setExtraData(String strFilePath, String strFileName, KDSpinner spnVoucherNumberBegin, KDSpinner spnVoucherNumberEnd) throws EASBizException {
        String jdkVersion = System.getProperty("java.version");
        if (jdkVersion != null && jdkVersion.contains("1.8.")) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnetion(strFilePath);
            String strTotal = "SELECT min(FNum) as minFNum,Max(FNum) as maxFNum FROM " + strFilePath + "\\" + strFileName + " where FNum >0 ";
            stmt = conn.createStatement();
            logger.debug((Object)"conn.createStatement();");
            rs = stmt.executeQuery(strTotal);
            logger.debug((Object)"stmt.executeQuery(strTotal);");
            int iMinNum = 0;
            int iMaxNum = 0;
            if (rs.next()) {
                iMinNum = rs.getInt("minFNum");
                iMaxNum = rs.getInt("maxFNum");
            }
            logger.debug((Object)("iMinNum" + iMinNum));
            logger.debug((Object)("iMaxNum" + iMaxNum));
            SpinnerNumberModel yearNumberBegin = new SpinnerNumberModel(iMinNum, iMinNum, iMaxNum, 1);
            spnVoucherNumberBegin.setModel((SpinnerModel)yearNumberBegin);
            SpinnerNumberModel yearNumberEnd = new SpinnerNumberModel(iMaxNum, iMinNum, iMaxNum, 1);
            spnVoucherNumberEnd.setModel((SpinnerModel)yearNumberEnd);
        }
        catch (SQLException sqlE) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            return;
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map expVoucher(String strFullName, String strFilePath, String strFileName, boolean overide, VoucherImpExpParam filterParam) throws Exception {
        this.info("Export start");
        Map<String, StringBuffer> map = new HashMap<String, StringBuffer>();
        StringBuffer areaInfo = new StringBuffer();
        map.put("areainfo", areaInfo);
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(currentTime);
        int expCount = 0;
        String strPeriodInfoMidTitle = this.getResx(EXP_RES_NAME, "PeriodInfoMid");
        String strPeriodNumberTitle = this.getResx(EXP_RES_NAME, "PeriodNumber");
        String strVoucherTitle = this.getResx(EXP_RES_NAME, "Voucher");
        String strExpOKTitle = this.getResx(EXP_RES_NAME, "ExpOK");
        String strExpNotOKTitle = this.getResx(EXP_RES_NAME, "ExpNotOK");
        String expResult_before = this.getResx(EXP_RES_NAME, "ExpResult_before");
        String expResult_after = this.getResx(EXP_RES_NAME, "ExpResult_after");
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getRemoteInstance();
        Calendar start = Calendar.getInstance();
        this.info("Get voucher pks ...");
        FilterInfo filter = this.getFilterInfo(filterParam);
        IObjectPK[] pkList = this.getVoucherPkList(filter);
        Calendar end = Calendar.getInstance();
        logger.debug((Object)("1 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
        int size = pkList.length;
        FileNameHelp help = new FileNameHelp(strFullName);
        for (int cu = 0; cu < size; cu += 100) {
            this.info("Get vouchers " + cu + "/" + size + " ...");
            VoucherCollection voucherCollection = this.getVoucherPkList(cu, size, pkList, filter);
            this.info("Build dbf " + cu + "/" + size + " ...");
            end = Calendar.getInstance();
            logger.debug((Object)("2." + (cu + 1) + " " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
            if (voucherCollection != null && voucherCollection.size() > 0) {
                if (cu > 0) {
                    overide = false;
                }
                logger.debug((Object)(GLResUtil.getRes("import_result_info_tip") + strFullName));
                DBFField[][] fields = this.createTable(help, overide);
                DBFWriter writer = null;
                DBFWriter writerCF = null;
                FileOutputStream out = null;
                FileOutputStream outCF = null;
                try {
                    writer = new DBFWriter(Charset.forName("GBK"));
                    writer.setFields(fields[1]);
                    writerCF = new DBFWriter(Charset.forName("GBK"));
                    writerCF.setFields(fields[0]);
                    for (int i = 0; i < voucherCollection.size(); ++i) {
                        VoucherInfo tmpVoucher = voucherCollection.get(i);
                        end = Calendar.getInstance();
                        logger.debug((Object)("3." + (i + 1) + " " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
                        CompanyOrgUnitInfo tmpCompany = GlUtils.getCompanyById(tmpVoucher.getCompany().getId().toString());
                        String companyName = " " + tmpCompany.getName() + " ";
                        int iPeriodYear = tmpVoucher.getPeriod().getPeriodYear();
                        int iPeriodNumber = tmpVoucher.getPeriod().getPeriodNumber();
                        String strVoucherTypeInfo = null;
                        if (tmpVoucher.getVoucherType() != null && tmpVoucher.getVoucherType().getName() != null) {
                            strVoucherTypeInfo = tmpVoucher.getVoucherType().getName().trim();
                        }
                        String strVoucherNumber = "";
                        if (tmpVoucher.getNumber() != null) {
                            strVoucherNumber = tmpVoucher.getNumber().trim();
                        }
                        String strVoucher = strVoucherTitle + GLResUtil.getRes("sign_colon") + companyName + iPeriodYear + strPeriodInfoMidTitle;
                        strVoucher = strVoucher + iPeriodNumber + strPeriodNumberTitle;
                        strVoucher = strVoucher + strVoucherTypeInfo + strVoucherNumber;
                        try {
                            this.chechVoucherAssit(tmpVoucher, filterParam);
                            this.exportSingleVoucher(writer, writerCF, fields, help, tmpVoucher, expCount, facade, filterParam);
                            logger.debug((Object)("expCount:" + ++expCount));
                            areaInfo.append(this.getMessageBuffer(strVoucher, strExpOKTitle));
                            continue;
                        }
                        catch (Exception _ex) {
                            logger.error((Object)_ex);
                            areaInfo.append(this.getMessageBuffer(strVoucher, strExpNotOKTitle));
                        }
                    }
                    out = new FileOutputStream(new File(help.getFullFileName()));
                    outCF = new FileOutputStream(new File(help.getCFFullFileName()));
                    writer.write(out);
                    writerCF.write(outCF);
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (outCF != null) {
                            outCF.close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                        if (writerCF != null) {
                            writerCF.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    map.put("areainfo", areaInfo);
                    StringBuffer resultInfo = new StringBuffer(expResult_before + expCount + expResult_after);
                    map.put("resultinfo", resultInfo);
                }
            }
            end = Calendar.getInstance();
            logger.debug((Object)("4 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
            if (size == 0) {
                map = this.haveNoVoucher(expResult_before, expResult_after);
                continue;
            }
            try {
                File file;
                if (expCount > 0) {
                    try {
                        file = new File(help.getCFFullFileName());
                        file.renameTo(new File(help.getCFFullFileName()));
                        file = new File(help.getFullFileName());
                        file.renameTo(new File(help.getFullFileName()));
                    }
                    catch (Exception _ignore) {
                        logger.error((Object)_ignore);
                    }
                    continue;
                }
                file = new File(help.getCFFullFileName());
                if (file.exists()) {
                    try {
                        file.delete();
                    }
                    catch (Exception _ignore) {
                        logger.error((Object)_ignore);
                    }
                }
                if (!(file = new File(help.getFullFileName())).exists()) continue;
                try {
                    file.delete();
                }
                catch (Exception _ignore) {
                    logger.error((Object)_ignore);
                }
                continue;
            }
            catch (Exception _ignore) {
                logger.error((Object)_ignore);
            }
        }
        end = Calendar.getInstance();
        logger.debug((Object)("5 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
        if (size == 0) {
            map = this.haveNoVoucher(expResult_before, expResult_after);
        }
        this.info("Export end");
        return map;
    }

    private StringBuffer getVoucherSelector() {
        StringBuffer strBuffer = new StringBuffer();
        if (this.hasCompanyNum) {
            strBuffer.append("  SELECT distinct FGROUPID,FDATE,FTRANSDATE,FPERIOD,FGROUP,FNUM,");
        } else {
            strBuffer.append("  SELECT distinct FDATE,FTRANSDATE,FPERIOD,FGROUP,FNUM,");
        }
        strBuffer.append("FPREPARE,FPAY,FCASH,FPOSTER,FCHECKER,FATTCHMENT,FPOSTED,");
        strBuffer.append("FMODULE,FDELETED,FSERIALNO,FREFERENCE,FCASHFLOW ");
        strBuffer.append(" ,FENTRYID,FEXP,FACCTID,FCYID,FEXCHRATE,FDC,FPRICE,FUNITNAME ");
        strBuffer.append("  ,FCLSNAME1,FOBJID1,FOBJNAME1,FCLSNAME2,FOBJID2,FOBJNAME2,FCLSNAME3,FOBJID3,FOBJNAME3,");
        strBuffer.append(" FCLSNAME4,FOBJID4,FOBJNAME4,FCLSNAME5,FOBJID5,FOBJNAME5,FCLSNAME6,FOBJID6,FOBJNAME6,");
        strBuffer.append(" FCLSNAME7,FOBJID7,FOBJNAME7,FCLSNAME8,FOBJID8,FOBJNAME8, ");
        strBuffer.append(" FDES,FTRANSID,FFCYAMT,FQTY,fassistqty,FDEBIT,FCREDIT,FSETTLCODE,FSETTLENO, ");
        strBuffer.append("   fassistuni,finvnum,fticketnum,fcustomer,ffeetype,");
        strBuffer.append("   fmaterial,forgunit,fhandler,fsupplier,fbizdate,fenddate ");
        return strBuffer;
    }

    private StringBuffer getVoucherForSelector() {
        StringBuffer strBuffer = new StringBuffer();
        if (this.hasCompanyNum) {
            strBuffer.append("  SELECT distinct FGROUPID,FDATE,FTRANSDATE,FPERIOD,FGROUP,FNUM,FCYID,");
        } else {
            strBuffer.append("  SELECT distinct FDATE,FTRANSDATE,FPERIOD,FGROUP,FNUM,FCYID,");
        }
        strBuffer.append("FPREPARE,FPAY,FCASH,FPOSTER,FCHECKER,FATTCHMENT,FPOSTED,");
        strBuffer.append("FREFERENCE, ");
        strBuffer.append("FMODULE,FDELETED,FSERIALNO,FREFERENCE,FCASHFLOW ");
        strBuffer.append(" ,FENTRYID,FEXP,FACCTID,FCYID,FEXCHRATE,FDC,FPRICE,FUNITNAME ");
        strBuffer.append("  ,FCLSNAME1,FOBJID1,FOBJNAME1,FCLSNAME2,FOBJID2,FOBJNAME2,FCLSNAME3,FOBJID3,FOBJNAME3,");
        strBuffer.append(" FCLSNAME4,FOBJID4,FOBJNAME4,FCLSNAME5,FOBJID5,FOBJNAME5,FCLSNAME6,FOBJID6,FOBJNAME6,");
        strBuffer.append(" FCLSNAME7,FOBJID7,FOBJNAME7,FCLSNAME8,FOBJID8,FOBJNAME8, ");
        strBuffer.append(" FDES,FTRANSID,FFCYAMT,FQTY,fassistqty,FDEBIT,FCREDIT,FSETTLCODE,FSETTLENO, ");
        strBuffer.append("   fassistuni,finvnum,fticketnum,fcustomer,ffeetype,");
        strBuffer.append("   fmaterial,forgunit,fhandler,fsupplier,fbizdate,fenddate ");
        return strBuffer;
    }

    private String getVoucherSorter() {
        return " ORDER BY FPERIOD,FGROUP,FNUM ";
    }

    private StringBuffer getVoucherEntrySelector() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("  SELECT distinct fnum,FENTRYID,FEXP,FACCTID,FCYID,FEXCHRATE,FDC,FPRICE,FUNITNAME ");
        return strBuffer;
    }

    private String getVoucherEntryFilter(String strFileName, ImpVoucherStructure impVoucher) {
        String filter = " FROM " + strFileName + " WHERE FNUM = ? AND FGROUP=? ";
        if (this.hasCompanyNum) {
            filter = filter + " and FGROUPID = ? ";
        }
        return filter;
    }

    private String getVoucherEntrySorter() {
        return " ORDER BY FENTRYID";
    }

    private StringBuffer getVoucherAssistSelector() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("  SELECT FCLSNAME1,FOBJID1,FOBJNAME1,FCLSNAME2,FOBJID2,FOBJNAME2,FCLSNAME3,FOBJID3,FOBJNAME3,");
        strBuffer.append(" FCLSNAME4,FOBJID4,FOBJNAME4,FCLSNAME5,FOBJID5,FOBJNAME5,FCLSNAME6,FOBJID6,FOBJNAME6,");
        strBuffer.append(" FCLSNAME7,FOBJID7,FOBJNAME7,FCLSNAME8,FOBJID8,FOBJNAME8, ");
        strBuffer.append(" FDES,FTRANSID,FDATE,ftransdate,FDC,FFCYAMT,FQTY,fassistqty,FDEBIT,FCREDIT,FSETTLCODE,FSETTLENO,FPRICE,FUNITNAME, ");
        strBuffer.append("   fassistuni,finvnum,fticketnum,fcustomer,ffeetype,");
        strBuffer.append("   FENTRYID,fnum,");
        strBuffer.append("   fmaterial,forgunit,fhandler,fsupplier,fbizdate,fenddate,FAssistPrice");
        return strBuffer;
    }

    private String getVoucherAssistFilter(String strFileName) {
        String filter = " FROM " + strFileName + " WHERE FNUM = ? AND FENTRYID = ?  AND FGROUP=? ";
        if (this.hasCompanyNum) {
            filter = filter + " and FGROUPID = ? ";
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer formatSqlToRedundancyField(Connection conn, StringBuffer strSql, String StrTable, ArrayList importDBFField) {
        String str1 = strSql.toString().toUpperCase().replaceAll(" ", "").replaceFirst("SELECT", "");
        StringBuffer newStrSql = new StringBuffer(str1 + ",");
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("select top 1 * from " + StrTable);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int rsmdCount = rsmd.getColumnCount();
            for (int i = 0; i < rsmdCount; ++i) {
                importDBFField.add(rsmd.getColumnName(i + 1).toUpperCase());
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        catch (SQLException e) {
            logger.error((Object)"conn close");
        }
        finally {
            SQLUtils.cleanup(rs, ps);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(newStrSql.toString(), ",");
        while (stringTokenizer.hasMoreElements()) {
            String temp = stringTokenizer.nextToken();
            if (importDBFField.contains(temp.trim())) continue;
            int tempSize = new String(temp + ",").length();
            int index = newStrSql.indexOf(temp + ",");
            newStrSql.replace(index, index + tempSize, "");
        }
        newStrSql.insert(0, "select ").replace(newStrSql.length() - 1, newStrSql.length(), "");
        return newStrSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getImpVoucheAssist(String strFileName, VoucherEntryInfo entry, ImpVoucherStructure impVoucher, VoucherImpExpParam filterParam, StringBuffer areaInfo) throws EASBizException, BOSException {
        StringBuffer voucherAssistSelector = this.getVoucherAssistSelector();
        JdbcRowSet rsVoucherAssist = null;
        PreparedStatement stmtVoucherAsst = null;
        ResultSet rsVoucherAsstRS = null;
        Connection conn = null;
        ArrayList importDBFField = new ArrayList();
        try {
            conn = this.getConnetion(strFileName);
            voucherAssistSelector = this.formatSqlToRedundancyField(conn, voucherAssistSelector, strFileName, importDBFField);
            String voucherAssistFilter = this.getVoucherAssistFilter(strFileName);
            StringBuffer voucherAssistSQL = new StringBuffer();
            voucherAssistSQL.append(voucherAssistSelector).append(voucherAssistFilter);
            rsVoucherAssist = new JdbcRowSet();
            stmtVoucherAsst = conn.prepareStatement(voucherAssistSQL.toString());
            int indexEntry = 1;
            stmtVoucherAsst.setString(indexEntry++, impVoucher.getIVoucherNumber());
            stmtVoucherAsst.setInt(indexEntry++, entry.getSeq());
            stmtVoucherAsst.setString(indexEntry++, impVoucher.getVoucherInfo().getVoucherType().getName());
            if (this.hasCompanyNum) {
                stmtVoucherAsst.setString(indexEntry++, impVoucher.getVoucherInfo().getCompany().getNumber());
            }
            rsVoucherAsstRS = stmtVoucherAsst.executeQuery();
            rsVoucherAssist.populate(rsVoucherAsstRS);
        }
        catch (Exception _ex) {
            try {
                logger.error((Object)_ex);
                throw new BOSException((Throwable)_ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsVoucherAsstRS, stmtVoucherAsst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsVoucherAsstRS, (Statement)stmtVoucherAsst, (Connection)conn);
        AccountViewInfo acc = entry.getAccount();
        try {
            int assistCount = 0;
            BigDecimal entry_originalAmount = SysConstant.BIGZERO;
            BigDecimal entry_localAmount = SysConstant.BIGZERO;
            BigDecimal entry_qunatity = SysConstant.BIGZERO;
            while (rsVoucherAssist.next()) {
                String message;
                StringBuffer sb;
                String INDEX;
                BigDecimal price;
                String strSettleNumber;
                BigDecimal quantity;
                String message2;
                String bizNumber;
                VoucherAssistRecordInfo assitInfo = new VoucherAssistRecordInfo();
                assitInfo.setOprStatus(1);
                assitInfo.setSeq(assistCount);
                int iSeq = rsVoucherAssist.getInt("FENTRYID");
                String voucherNumber = rsVoucherAssist.getString("FNUM");
                StringBuffer sb5 = new StringBuffer();
                sb5.append(voucherNumber).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1054_VoucherDBFSparser"));
                sb5.append(iSeq).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1055_VoucherDBFSparser"));
                String msg = sb5.toString();
                if (importDBFField.contains("FDES")) {
                    String des = rsVoucherAssist.getString("FDES");
                    assitInfo.setDescription(des);
                }
                if ((bizNumber = rsVoucherAssist.getString("FTRANSID")) != null) {
                    assitInfo.setBizNumber(bizNumber.trim());
                }
                boolean isUpFrom530 = false;
                java.sql.Date bizDate = null;
                java.sql.Date endDate1 = null;
                String invnum = null;
                try {
                    bizDate = rsVoucherAssist.getDate("fbizdate");
                    endDate1 = rsVoucherAssist.getDate("fenddate");
                    invnum = rsVoucherAssist.getString("finvnum");
                }
                catch (Exception e) {
                    isUpFrom530 = true;
                }
                if (!isUpFrom530) {
                    java.sql.Date asstBizDate = bizDate;
                    if (asstBizDate != null) {
                        assitInfo.setBizDate((Date)asstBizDate);
                        VoucherInfo voucherInfo = impVoucher.getVoucherInfo();
                        java.sql.Date assitbizDate = new java.sql.Date(assitInfo.getBizDate().getYear(), assitInfo.getBizDate().getMonth(), assitInfo.getBizDate().getDate());
                        java.sql.Date bookDate = new java.sql.Date(voucherInfo.getBookedDate().getYear(), voucherInfo.getBookedDate().getMonth(), voucherInfo.getBookedDate().getDate());
                        if (assitbizDate.after(bookDate)) {
                            String ASsistBizDateNotBook;
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            String INDEX2 = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                            String errMsg = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource", (String)"ASsistBizDateNotBook");
                            StringBuffer sb6 = new StringBuffer(voucherInfo.getCompany().getNumber());
                            sb6.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                            sb6.append(INDEX2).append(entry.getSeq()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"353_VoucherLeadControlControllerBean")).append(errMsg);
                            message2 = ASsistBizDateNotBook = sb6.toString();
                            impVoucher.getLstErrorInfo().add(message2);
                            areaInfo.append(message2);
                            areaInfo.append("\r\n");
                        }
                    }
                    java.sql.Date endDate = endDate1;
                    if (acc.isAC()) {
                        if (endDate == null) {
                            assitInfo.setEndDate(assitInfo.getBizDate());
                        } else {
                            assitInfo.setEndDate((Date)endDate);
                        }
                    }
                }
                if ((quantity = rsVoucherAssist.getBigDecimal("FQTY")) == null) {
                    quantity = GlUtils.zero;
                }
                assitInfo.setQuantity(quantity);
                BigDecimal asstquantity = null;
                try {
                    asstquantity = rsVoucherAssist.getBigDecimal("fassistqty");
                }
                catch (Exception e) {
                    asstquantity = GlUtils.zero;
                }
                if (asstquantity == null) {
                    asstquantity = GlUtils.zero;
                }
                assitInfo.setAssistQty(asstquantity);
                BigDecimal originalAmount = rsVoucherAssist.getBigDecimal("FFCYAMT");
                String strDC = rsVoucherAssist.getString("FDC");
                BigDecimal asstprice = new BigDecimal(0);
                if (strDC.trim().equals("1")) {
                    BigDecimal debitAmount = rsVoucherAssist.getBigDecimal("FDEBIT");
                    assitInfo.setLocalAmount(debitAmount);
                    assitInfo.setReportingAmount(debitAmount);
                    if (asstquantity.intValue() != 0) {
                        asstprice = debitAmount.divide(asstquantity, 2, 5);
                    }
                } else {
                    BigDecimal creditAmount = rsVoucherAssist.getBigDecimal("FCREDIT");
                    assitInfo.setLocalAmount(creditAmount);
                    assitInfo.setReportingAmount(creditAmount);
                    if (asstquantity.intValue() != 0) {
                        asstprice = creditAmount.divide(asstquantity, 2, 5);
                    }
                }
                if (originalAmount != null && assitInfo.getLocalAmount() != null && entry.getCurrency() != null && impVoucher.getVoucherInfo().getCompany().getBaseCurrency() != null && entry.getCurrency().getId().toString().equals(impVoucher.getVoucherInfo().getCompany().getBaseCurrency().getId().toString())) {
                    if (originalAmount.compareTo(GlUtils.zero) == 0) {
                        originalAmount = assitInfo.getLocalAmount();
                    }
                    if (originalAmount.compareTo(assitInfo.getLocalAmount()) != 0) {
                        impVoucher.setBreak(true);
                        impVoucher.setBNoWrong(false);
                        String INDEX3 = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                        String errMsg = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "oAmount_notEquanls_locAmount");
                        StringBuffer sb7 = new StringBuffer(impVoucher.getVoucherInfo().getCompany().getNumber());
                        sb7.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                        sb7.append(INDEX3).append(entry.getSeq()).append(errMsg);
                        message2 = sb7.toString();
                        impVoucher.getLstErrorInfo().add(message2);
                        areaInfo.append(message2);
                        areaInfo.append("\r\n");
                        return;
                    }
                }
                assitInfo.setOriginalAmount(originalAmount);
                assitInfo.setAssistPrice(asstprice);
                String strSettleCode = rsVoucherAssist.getString("FSETTLCODE");
                if (strSettleCode != null) {
                    SettlementTypeInfo settlementTypeInfo = this.findSettelmentTypeByName(strSettleCode);
                    if (settlementTypeInfo == null) {
                        impVoucher.setBreak(true);
                        impVoucher.setBNoWrong(false);
                        StringBuffer sb8 = new StringBuffer(msg);
                        sb8.append(impVoucher.getVoucherInfo().getCompany().getNumber());
                        sb8.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1058_VoucherDBFSparser"));
                        sb8.append(strSettleCode).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                        message2 = sb8.toString();
                        impVoucher.getLstErrorInfo().add(message2);
                        areaInfo.append(message2);
                        areaInfo.append("\r\n");
                        return;
                    }
                    assitInfo.setSettlementType(settlementTypeInfo);
                }
                if ((strSettleNumber = rsVoucherAssist.getString("FSETTLENO")) != null) {
                    assitInfo.setSettlementCode(strSettleNumber.trim());
                }
                if (!isUpFrom530) {
                    String strSupplier;
                    String strCompanyOrgUnit;
                    String strMaterial;
                    String strHandler;
                    String strFeeType;
                    String strCustomer;
                    String strTicketNumber;
                    String strInvoiceNumber = invnum;
                    if (strInvoiceNumber != null) {
                        assitInfo.setInvoiceNumber(strInvoiceNumber);
                    }
                    if ((strTicketNumber = rsVoucherAssist.getString("fticketnum")) != null) {
                        assitInfo.setTicketNumber(strTicketNumber);
                    }
                    if (this.isNullString(strCustomer = rsVoucherAssist.getString("fcustomer"))) {
                        strCustomer = null;
                    }
                    if (strCustomer != null) {
                        CustomerInfo customerInfo = this.findCustomerByName(strCustomer, impVoucher.getVoucherInfo().getCompany().getId().toString());
                        if (customerInfo == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb9 = new StringBuffer(msg);
                            sb9.append(impVoucher.getVoucherInfo().getCompany().getNumber());
                            sb9.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1059_VoucherDBFSparser"));
                            sb9.append(strCustomer).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message3 = sb9.toString();
                            impVoucher.getLstErrorInfo().add(message3);
                            areaInfo.append(message3);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setCustomer(customerInfo);
                    }
                    if (this.isNullString(strFeeType = rsVoucherAssist.getString("ffeetype"))) {
                        strFeeType = null;
                    }
                    if (strFeeType != null) {
                        assitInfo.setFeeType(FeeTypeEnum.getEnum((int)Integer.parseInt(strFeeType)));
                    }
                    if (this.isNullString(strHandler = rsVoucherAssist.getString("fhandler"))) {
                        strHandler = null;
                    }
                    if (strHandler != null) {
                        UserInfo handlerInfo = this.findUserUByNumber(strHandler);
                        if (handlerInfo == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb2 = new StringBuffer(msg);
                            sb2.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1060_VoucherDBFSparser"));
                            sb2.append(strHandler).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message4 = sb2.toString();
                            impVoucher.getLstErrorInfo().add(message4);
                            areaInfo.append(message4);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setHandler(handlerInfo);
                    }
                    if (this.isNullString(strMaterial = rsVoucherAssist.getString("fmaterial"))) {
                        strMaterial = null;
                    }
                    if (strMaterial != null) {
                        MaterialInfo materialInfo = this.findMaterialByName(strMaterial, impVoucher.getVoucherInfo().getCompany().getId().toString());
                        if (materialInfo == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb3 = new StringBuffer(msg);
                            sb3.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1061_VoucherDBFSparser"));
                            sb3.append(strMaterial).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message5 = sb3.toString();
                            impVoucher.getLstErrorInfo().add(message5);
                            areaInfo.append(message5);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setMaterial(materialInfo);
                    }
                    if (this.isNullString(strCompanyOrgUnit = rsVoucherAssist.getString("forgunit"))) {
                        strCompanyOrgUnit = null;
                    }
                    if (strCompanyOrgUnit != null) {
                        CompanyOrgUnitInfo orgUnitInfo = this.findCompanyOrgUnitByName(strCompanyOrgUnit);
                        if (orgUnitInfo == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb4 = new StringBuffer(msg);
                            sb4.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1062_VoucherDBFSparser"));
                            sb4.append(strCompanyOrgUnit).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message6 = sb4.toString();
                            impVoucher.getLstErrorInfo().add(message6);
                            areaInfo.append(message6);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setOrgUnit(orgUnitInfo);
                    }
                    if (this.isNullString(strSupplier = rsVoucherAssist.getString("fsupplier"))) {
                        strSupplier = null;
                    }
                    if (strSupplier != null) {
                        SupplierInfo supplier = this.findSupplierByName(strSupplier, impVoucher.getVoucherInfo().getCompany().getId().toString());
                        if (strSupplier == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb6 = new StringBuffer(msg);
                            sb6.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1063_VoucherDBFSparser"));
                            sb6.append(strSupplier).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message7 = sb6.toString();
                            impVoucher.getLstErrorInfo().add(message7);
                            areaInfo.append(message7);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setSupplier(supplier);
                    }
                }
                if ((price = rsVoucherAssist.getBigDecimal("FPRICE")) == null) {
                    price = GlUtils.zero;
                }
                assitInfo.setPrice(price);
                String strUnitName = rsVoucherAssist.getString("FUNITNAME");
                MeasureUnitInfo measureUnitInfo = this.findUnitByName(strUnitName, acc);
                assitInfo.setMeasureUnit(measureUnitInfo);
                AssistantHGInfo assistantHGInfo = new AssistantHGInfo();
                String strAsstUnitName = null;
                try {
                    strAsstUnitName = rsVoucherAssist.getString("fassistuni");
                }
                catch (Exception e) {
                    strAsstUnitName = "";
                }
                MeasureUnitInfo measureAsstUnitInfo = this.findUnitByName(strAsstUnitName, acc);
                assitInfo.setAssistUnit(measureAsstUnitInfo);
                boolean isHasAssist = false;
                boolean isAssist = false;
                int entrySeq = entry.getSeq();
                AsstActTypeCollection arrayAsstActTypeIndfo = new AsstActTypeCollection();
                String strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME1");
                String strAsstActID = rsVoucherAssist.getString("FOBJID1");
                String strAsstActName = rsVoucherAssist.getString("FOBJNAME1");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 1, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                boolean isChkHalfInivableSaveVoucher = filterParam.isChkHalfInviableSaveVoucher();
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME2");
                strAsstActID = rsVoucherAssist.getString("FOBJID2");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME2");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 2, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME3");
                strAsstActID = rsVoucherAssist.getString("FOBJID3");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME3");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 3, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME4");
                strAsstActID = rsVoucherAssist.getString("FOBJID4");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME4");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 4, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME5");
                strAsstActID = rsVoucherAssist.getString("FOBJID5");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME5");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 5, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME6");
                strAsstActID = rsVoucherAssist.getString("FOBJID6");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME6");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 6, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME7");
                strAsstActID = rsVoucherAssist.getString("FOBJID7");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME7");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 7, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME8");
                strAsstActID = rsVoucherAssist.getString("FOBJID8");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME8");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 8, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                if (isHasAssist && acc.getCAA() == null) {
                    impVoucher.setBreak(true);
                    impVoucher.setBNoWrong(false);
                    INDEX = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                    String NOT_MATCH_ACC = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "NOT_MATCH_ACC");
                    sb = new StringBuffer(msg);
                    sb.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                    sb.append(INDEX).append(entry.getSeq()).append(NOT_MATCH_ACC);
                    message = sb.toString();
                    impVoucher.getLstErrorInfo().add(message);
                    areaInfo.append(message);
                    areaInfo.append("\r\n");
                    return;
                }
                if (!isHasAssist && acc.getCAA() != null) {
                    impVoucher.setBreak(true);
                    impVoucher.setBNoWrong(false);
                    INDEX = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                    String NOT_ACC_ASSISt = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "NOT_ACC_ASSIST");
                    sb = new StringBuffer(msg);
                    sb.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                    sb.append(INDEX).append(entry.getSeq()).append(NOT_ACC_ASSISt);
                    message = sb.toString();
                    impVoucher.getLstErrorInfo().add(message);
                    areaInfo.append(message);
                    areaInfo.append("\r\n");
                    return;
                }
                if (!isHasAssist && acc.getCAA() == null && !acc.isHasUserProperty()) {
                    entry.setOriginalAmount(assitInfo.getOriginalAmount());
                    entry.setLocalAmount(assitInfo.getLocalAmount());
                    entry.setReportingAmount(assitInfo.getReportingAmount());
                    entry.setQuantity(assitInfo.getQuantity());
                    return;
                }
                if (isHasAssist && acc.getCAA() != null || acc.isHasUserProperty()) {
                    StringBuffer sb7;
                    try {
                        if (acc.getCAA() != null) {
                            IAssistantHG igCtrl = AssistantHGFactory.getRemoteInstance();
                            AssistantHGInfo actualAssistantHGInfo = igCtrl.getAssistantHG(assistantHGInfo, entry.getAccount().getCAA().getId().toString(), arrayAsstActTypeIndfo);
                            assitInfo.setAssGrp(actualAssistantHGInfo);
                        }
                        assitInfo.setEntry(entry);
                        VoucherInfo voucher = impVoucher.getVoucherInfo();
                        assitInfo.setBill(voucher);
                        assitInfo.setBizDate(voucher.getBizDate());
                        entry_originalAmount = entry_originalAmount.add(assitInfo.getOriginalAmount());
                        entry_localAmount = entry_localAmount.add(assitInfo.getLocalAmount());
                        entry_qunatity = entry_qunatity.add(assitInfo.getQuantity());
                        boolean canSaveZero = false;
                        try {
                            canSaveZero = Boolean.valueOf(GlUtils.getParamByKey(null, voucher.getCompany().getId().toString(), "GL_0301").toString());
                        }
                        catch (EASBizException e) {
                            logger.error((Object)e);
                        }
                        if (filterParam.isPost() && !canSaveZero && GlUtils.isAllZeroOrNull(new BigDecimal[]{assitInfo.getQuantity(), assitInfo.getOriginalAmount(), assitInfo.getLocalAmount()})) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            String INDEX4 = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                            sb7 = new StringBuffer(voucher.getCompany().getNumber());
                            sb7.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                            sb7.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource", (String)"recordZero"));
                            String NOT_ACC_ASSIST = sb7.toString();
                            StringBuffer sb1 = new StringBuffer(INDEX4);
                            sb1.append(entry.getSeq()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1031_VoucherXLSSparser"));
                            sb1.append(NOT_ACC_ASSIST);
                            String message8 = sb1.toString();
                            impVoucher.getLstErrorInfo().add(message8);
                            areaInfo.append(message8);
                            areaInfo.append("\r\n");
                            if (!isChkHalfInivableSaveVoucher) {
                                return;
                            }
                        }
                        entry.getAssistRecords().add(assitInfo);
                    }
                    catch (Exception exAssist) {
                        impVoucher.setBreak(true);
                        impVoucher.setBNoWrong(false);
                        String INDEX5 = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                        String NOT_ACC_ASSIST = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "NOT_ACC_ASSIST");
                        sb7 = new StringBuffer(msg);
                        sb7.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                        sb7.append(INDEX5).append(entry.getSeq()).append(NOT_ACC_ASSIST);
                        String message9 = sb7.toString();
                        impVoucher.getLstErrorInfo().add(message9);
                        areaInfo.append(message9);
                        areaInfo.append("\r\n");
                        logger.error((Object)exAssist);
                        return;
                    }
                }
                ++assistCount;
            }
            if (impVoucher.isBNoWrong() && assistCount == 0) {
                impVoucher.setBreak(true);
                impVoucher.setBNoWrong(false);
                String INDEX = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                String NOT_ASSIST_COUNT = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "NOT_ASSIST_COUNT");
                StringBuffer sb = new StringBuffer(impVoucher.getVoucherInfo().getCompany().getNumber());
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                sb.append(INDEX).append(entry.getSeq()).append(NOT_ASSIST_COUNT);
                String message = sb.toString();
                impVoucher.getLstErrorInfo().add(message);
                areaInfo.append(message);
                areaInfo.append("\r\n");
            }
            entry.setOriginalAmount(entry_originalAmount);
            entry.setLocalAmount(entry_localAmount);
            entry.setReportingAmount(entry_localAmount);
            entry.setQuantity(entry_qunatity);
        }
        catch (SQLException _exEntry) {
            impVoucher.setBreak(true);
            impVoucher.setBNoWrong(false);
            String CANNT_GET_ENTRY = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "CANNT_GET_ENTRY");
            impVoucher.getLstErrorInfo().add(CANNT_GET_ENTRY);
            areaInfo.append(CANNT_GET_ENTRY);
            areaInfo.append("\r\n");
            logger.error((Object)_exEntry);
        }
    }

    private boolean isNullString(String strValue) {
        if (strValue == null) {
            return true;
        }
        return "null".equalsIgnoreCase(strValue) || strValue.trim().length() == 0;
    }

    private StringBuffer getVoucherFilter(String strFileName, VoucherImpExpParam filterParam) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" FROM " + strFileName);
        strBuffer.append("  WHERE ( Fdate >= ?  AND FDate <= ? ) or FDate is null ");
        if (filterParam.getVoucherTypeInfo() != null) {
            strBuffer.append("     AND FGroup = ? ");
        }
        if (filterParam.isIncludeNoPost() && !filterParam.isIncludePost()) {
            strBuffer.append("   AND FPosted = false ");
        } else if (!filterParam.isIncludeNoPost() && filterParam.isIncludePost()) {
            strBuffer.append("   AND FPosted = true ");
        } else if (filterParam.isIncludeNoPost() || !filterParam.isIncludePost()) {
            // empty if block
        }
        return strBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSingleVoucher(DBFWriter writer, DBFWriter writerCF, DBFField[][] fields, FileNameHelp help, VoucherInfo tmpVoucher, int expCount, IGLGeneralFacade facade, VoucherImpExpParam filterParam) throws SQLException, EASBizException, BOSException {
        int iLen;
        CompanyOrgUnitInfo company = GlUtils.getCompanyById(tmpVoucher.getCompany().getId().toString());
        java.sql.Date voucherBookDate = (java.sql.Date)tmpVoucher.getBookedDate();
        java.sql.Date voucherBizDate = (java.sql.Date)tmpVoucher.getBizDate();
        PeriodInfo periodInfo = tmpVoucher.getPeriod();
        int iPeriodNumber = periodInfo.getPeriodNumber();
        VoucherTypeInfo voucherTypeInfo = tmpVoucher.getVoucherType();
        String strVoucherTypeInfo = "";
        if (voucherTypeInfo != null) {
            strVoucherTypeInfo = voucherTypeInfo.getName().trim();
        }
        String iNumber = tmpVoucher.getNumber();
        if (!filterParam.isRetainOrgNumber()) {
            iNumber = String.valueOf(expCount);
        }
        UserInfo userPrepare = tmpVoucher.getCreator();
        String strPrepare = null;
        if (userPrepare != null) {
            strPrepare = userPrepare.getNumber().trim();
        }
        UserInfo userPost = tmpVoucher.getPoster();
        String strPoster = null;
        if (userPost != null) {
            strPoster = userPost.getNumber().trim();
        }
        UserInfo userCheck = tmpVoucher.getAuditor();
        String strChecker = null;
        if (userCheck != null) {
            strChecker = userCheck.getNumber().trim();
        }
        int iAttachement = tmpVoucher.getAttachments();
        VoucherStatusEnum status = tmpVoucher.getBizStatus();
        boolean isPosted = false;
        if (status.getValue() == VoucherStatusEnum.POSTED.getValue()) {
            isPosted = true;
        }
        String strModule = "";
        SystemEnum systemEnum = tmpVoucher.getSourceSys();
        SourceType sourceType = tmpVoucher.getSourceType();
        if (sourceType.getValue() != 0 && systemEnum.getValue() != 6 && (strModule = systemEnum.getName()) != null && (iLen = (strModule = strModule.trim()).length()) > 10) {
            strModule = strModule.substring(0, iLen);
        }
        boolean isDeleted = false;
        String iVoucherTotalNumber = String.valueOf(System.currentTimeMillis()) + "--" + expCount;
        String description = tmpVoucher.getDescription();
        String strRefrence = "";
        if (description != null) {
            strRefrence = tmpVoucher.getDescription().trim();
        }
        try {
            VoucherEntryCollection voucherLines = tmpVoucher.getEntries();
            if (voucherLines == null || voucherLines.size() == 0) {
                return;
            }
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < voucherLines.size(); ++i) {
                boolean isHasCashFlow;
                MeasureUnitInfo measureUnitInfo;
                VoucherEntryInfo voucherEntryInfo = voucherLines.get(i);
                int iEntryNumber = voucherEntryInfo.getSeq();
                String entryDes = voucherEntryInfo.getDescription();
                String strEntryRemark = "";
                if (entryDes != null) {
                    strEntryRemark = voucherEntryInfo.getDescription().trim();
                }
                AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
                String strAccountViewInfo = accountViewInfo.getNumber();
                CurrencyInfo currencyInfo = voucherEntryInfo.getCurrency();
                String strCurrencyInfo = currencyInfo.getNumber();
                BigDecimal exchangeRate = voucherEntryInfo.getLocalExchangeRate().stripTrailingZeros();
                EntryDC dc = voucherEntryInfo.getEntryDC();
                int iDC = 0;
                if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                    iDC = 1;
                }
                BigDecimal originalAmount = voucherEntryInfo.getOriginalAmount().stripTrailingZeros();
                BigDecimal qty = voucherEntryInfo.getQuantity().stripTrailingZeros();
                BigDecimal price = voucherEntryInfo.getPrice().stripTrailingZeros();
                BigDecimal localDebit = SysConstant.BIGZERO.stripTrailingZeros();
                BigDecimal localCredit = SysConstant.BIGZERO.stripTrailingZeros();
                if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                    localDebit = voucherEntryInfo.getLocalAmount().stripTrailingZeros();
                } else {
                    localCredit = voucherEntryInfo.getLocalAmount().stripTrailingZeros();
                }
                String strMeasureUnitInfo = null;
                if (!filterParam.isQtyByAsst()) {
                    measureUnitInfo = voucherEntryInfo.getMeasureUnit();
                    strMeasureUnitInfo = null;
                    if (measureUnitInfo != null) {
                        strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                    }
                }
                CashflowRecordCollection cashFlowRecordCollection = voucherEntryInfo.getCashflowRecords();
                VoucherAssistRecordCollection assitRecordCollection = voucherEntryInfo.getAssistRecords();
                if (assitRecordCollection == null || assitRecordCollection.size() == 0) {
                    values = new ArrayList();
                    values.add(company.getNumber());
                    values.add(voucherBookDate != null ? voucherBookDate.toString() : null);
                    values.add(voucherBizDate != null ? voucherBizDate.toString() : null);
                    values.add(String.valueOf(iPeriodNumber));
                    values.add(strVoucherTypeInfo != null ? strVoucherTypeInfo.toString() : null);
                    values.add(iNumber != null ? iNumber.toString() : null);
                    values.add(String.valueOf(iEntryNumber));
                    values.add(strEntryRemark != null ? strEntryRemark.toString() : null);
                    values.add(strAccountViewInfo != null ? strAccountViewInfo.toString() : null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(strCurrencyInfo != null ? strCurrencyInfo.toString() : null);
                    values.add(exchangeRate != null ? exchangeRate.toPlainString() : null);
                    values.add(String.valueOf(iDC));
                    values.add(originalAmount != null ? originalAmount.toPlainString() : null);
                    values.add(qty != null ? qty.toPlainString() : null);
                    values.add(new BigDecimal(0).stripTrailingZeros().toPlainString());
                    values.add(price != null ? price.toPlainString() : null);
                    values.add(localDebit != null ? localDebit.toPlainString() : null);
                    values.add(localCredit != null ? localCredit.toPlainString() : null);
                    values.add(null);
                    values.add(null);
                    values.add(strPrepare != null ? strPrepare.toString() : null);
                    values.add(null);
                    values.add(null);
                    values.add(strPoster != null ? strPoster.toString() : null);
                    values.add(strChecker != null ? strChecker.toString() : null);
                    values.add(String.valueOf(iAttachement));
                    values.add(String.valueOf(isPosted));
                    values.add(strModule != null ? strModule.toString() : null);
                    values.add(String.valueOf(isDeleted));
                    values.add(iVoucherTotalNumber != null ? iVoucherTotalNumber.toString() : null);
                    values.add(strMeasureUnitInfo != null ? strMeasureUnitInfo.toString() : null);
                    values.add(null);
                    values.add(strRefrence != null ? strRefrence.toString() : null);
                    values.add(tmpVoucher.getCashflowFlag() != null ? String.valueOf(tmpVoucher.getCashflowFlag().getValue()) : null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    try {
                        writer.addRecord(values.toArray());
                    }
                    catch (Exception e) {
                        logger.debug((Object)e.getMessage());
                        logger.error((Object)e);
                    }
                } else {
                    Calendar start = Calendar.getInstance();
                    for (int j = 0; j < assitRecordCollection.size(); ++j) {
                        String strTicketNumber;
                        String strInvoiceNumber;
                        String strSettleCode;
                        String strDescripton;
                        VoucherAssistRecordInfo tmpAssistRecordInfo = assitRecordCollection.get(j);
                        Calendar end = Calendar.getInstance();
                        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1067_VoucherDBFSparser"));
                        sb.append(i).append(".").append(j).append(" ").append(GLResUtil.getRes("use_time"));
                        sb.append(end.getTimeInMillis() - start.getTimeInMillis());
                        logger.debug((Object)sb.toString());
                        originalAmount = tmpAssistRecordInfo.getOriginalAmount().stripTrailingZeros();
                        String strBizNumber = tmpAssistRecordInfo.getBizNumber();
                        if (strBizNumber != null) {
                            strBizNumber = strBizNumber.trim();
                        }
                        if ((strDescripton = tmpAssistRecordInfo.getDescription()) != null) {
                            strDescripton = strDescripton.trim();
                        }
                        SettlementTypeInfo settlementTypeInfo = tmpAssistRecordInfo.getSettlementType();
                        String strSettleTypeInfo = null;
                        if (settlementTypeInfo != null) {
                            strSettleTypeInfo = settlementTypeInfo.getName().trim();
                        }
                        if ((strSettleCode = tmpAssistRecordInfo.getSettlementCode()) != null) {
                            strSettleCode = strSettleCode.trim();
                        }
                        if ((strInvoiceNumber = tmpAssistRecordInfo.getInvoiceNumber()) != null) {
                            strInvoiceNumber = strInvoiceNumber.trim();
                        }
                        if ((strTicketNumber = tmpAssistRecordInfo.getTicketNumber()) != null) {
                            strTicketNumber = strTicketNumber.trim();
                        }
                        CustomerInfo customerInfo = tmpAssistRecordInfo.getCustomer();
                        String strCustomerInfo = null;
                        if (customerInfo != null) {
                            strCustomerInfo = customerInfo.getName().trim();
                        }
                        FeeTypeEnum feeType = tmpAssistRecordInfo.getFeeType();
                        String strFeeType = null;
                        if (feeType != null) {
                            strFeeType = String.valueOf(feeType.getValue());
                        }
                        UserInfo handlerInfo = tmpAssistRecordInfo.getHandler();
                        String strHandlerInfo = null;
                        if (handlerInfo != null) {
                            strHandlerInfo = handlerInfo.getNumber().trim();
                        }
                        MaterialInfo materialInfo = tmpAssistRecordInfo.getMaterial();
                        String strMaterialInfo = null;
                        if (materialInfo != null) {
                            strMaterialInfo = materialInfo.getName().trim();
                        }
                        CompanyOrgUnitInfo companyOrgUnitInfo = tmpAssistRecordInfo.getOrgUnit();
                        String strCompanyOrgUnitInfo = null;
                        if (companyOrgUnitInfo != null) {
                            strCompanyOrgUnitInfo = companyOrgUnitInfo.getName().trim();
                        }
                        SupplierInfo supplierInfo = tmpAssistRecordInfo.getSupplier();
                        String strSupplierInfo = null;
                        if (supplierInfo != null) {
                            strSupplierInfo = supplierInfo.getName().trim();
                        }
                        java.sql.Date asstBizDate = (java.sql.Date)tmpAssistRecordInfo.getBizDate();
                        java.sql.Date endDate = (java.sql.Date)tmpAssistRecordInfo.getEndDate();
                        BigDecimal asstOriginalAmount = tmpAssistRecordInfo.getOriginalAmount().stripTrailingZeros();
                        BigDecimal assLocalDebit = SysConstant.BIGZERO.stripTrailingZeros();
                        BigDecimal assLocalCredit = SysConstant.BIGZERO.stripTrailingZeros();
                        if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                            assLocalDebit = tmpAssistRecordInfo.getLocalAmount().stripTrailingZeros();
                        } else {
                            assLocalCredit = tmpAssistRecordInfo.getLocalAmount().stripTrailingZeros();
                        }
                        if (filterParam.isQtyByAsst()) {
                            measureUnitInfo = tmpAssistRecordInfo.getMeasureUnit();
                            strMeasureUnitInfo = null;
                            if (measureUnitInfo != null) {
                                strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                            }
                        }
                        String strAsstMeasureUnitInfo = null;
                        BigDecimal asstQty = new BigDecimal(0).stripTrailingZeros();
                        if (filterParam.isQtyByAsst() && accountViewInfo.isIsQty() && filterParam.isUnitByAsst()) {
                            measureUnitInfo = tmpAssistRecordInfo.getAssistUnit();
                            if (measureUnitInfo != null) {
                                strAsstMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                            }
                            if (tmpAssistRecordInfo.getAssistQty() != null) {
                                asstQty = tmpAssistRecordInfo.getAssistQty().stripTrailingZeros();
                            }
                        }
                        BigDecimal assQty = tmpAssistRecordInfo.getQuantity().stripTrailingZeros();
                        String[] asstTypes = new String[8];
                        String[] asstItemNumbers = new String[8];
                        String[] asstItemNames = new String[8];
                        if (tmpAssistRecordInfo.getAssGrp() != null) {
                            BOSUuid assGrpId = tmpAssistRecordInfo.getAssGrp().getId();
                            HashMap<String, String> key = new HashMap<String, String>();
                            key.put("key", assGrpId.toString());
                            Map result = facade.dealTask("getAsstItem", key);
                            if (result != null) {
                                AsstActTypeCollection col = (AsstActTypeCollection)result.get("value");
                                int count = 0;
                                if (col != null) {
                                    count = col.size();
                                }
                                for (int k = 0; k < count; ++k) {
                                    AsstActTypeInfo data = col.get(k);
                                    asstTypes[k] = (String)data.get("asstTypes");
                                    asstItemNumbers[k] = (String)data.get("asstItemNumbers");
                                    asstItemNames[k] = (String)data.get("asstItemNames");
                                }
                            }
                        }
                        values = new ArrayList();
                        values.add(company.getNumber());
                        values.add(voucherBookDate != null ? voucherBookDate.toString() : null);
                        values.add(voucherBizDate != null ? voucherBizDate.toString() : null);
                        values.add(String.valueOf(iPeriodNumber));
                        values.add(strVoucherTypeInfo != null ? strVoucherTypeInfo.toString() : null);
                        values.add(iNumber != null ? iNumber.toString() : null);
                        values.add(String.valueOf(iEntryNumber));
                        values.add(strEntryRemark != null ? strEntryRemark.toString() : null);
                        values.add(strAccountViewInfo != null ? strAccountViewInfo.toString() : null);
                        values.add(asstTypes[0] != null ? asstTypes[0].toString() : null);
                        values.add(asstItemNumbers[0] != null ? asstItemNumbers[0].toString() : null);
                        values.add(asstItemNames[0] != null ? asstItemNames[0].toString() : null);
                        values.add(asstTypes[1] != null ? asstTypes[1].toString() : null);
                        values.add(asstItemNumbers[1] != null ? asstItemNumbers[1].toString() : null);
                        values.add(asstItemNames[1] != null ? asstItemNames[1].toString() : null);
                        values.add(asstTypes[2] != null ? asstTypes[2].toString() : null);
                        values.add(asstItemNumbers[2] != null ? asstItemNumbers[2].toString() : null);
                        values.add(asstItemNames[2] != null ? asstItemNames[2].toString() : null);
                        values.add(asstTypes[3] != null ? asstTypes[3].toString() : null);
                        values.add(asstItemNumbers[3] != null ? asstItemNumbers[3].toString() : null);
                        values.add(asstItemNames[3] != null ? asstItemNames[3].toString() : null);
                        values.add(asstTypes[4] != null ? asstTypes[4].toString() : null);
                        values.add(asstItemNumbers[4] != null ? asstItemNumbers[4].toString() : null);
                        values.add(asstItemNames[4] != null ? asstItemNames[4].toString() : null);
                        values.add(asstTypes[5] != null ? asstTypes[5].toString() : null);
                        values.add(asstItemNumbers[5] != null ? asstItemNumbers[5].toString() : null);
                        values.add(asstItemNames[5] != null ? asstItemNames[5].toString() : null);
                        values.add(asstTypes[6] != null ? asstTypes[6].toString() : null);
                        values.add(asstItemNumbers[6] != null ? asstItemNumbers[6].toString() : null);
                        values.add(asstItemNames[6] != null ? asstItemNames[6].toString() : null);
                        values.add(asstTypes[7] != null ? asstTypes[7].toString() : null);
                        values.add(asstItemNumbers[7] != null ? asstItemNumbers[7].toString() : null);
                        values.add(asstItemNames[7] != null ? asstItemNames[7].toString() : null);
                        values.add(strDescripton != null ? strDescripton.toString() : null);
                        values.add(strBizNumber != null ? strBizNumber.toString() : null);
                        values.add(strCurrencyInfo != null ? strCurrencyInfo.toString() : null);
                        values.add(exchangeRate != null ? exchangeRate.toPlainString() : null);
                        values.add(String.valueOf(iDC));
                        values.add(asstOriginalAmount != null ? asstOriginalAmount.toPlainString() : null);
                        values.add(assQty != null ? assQty.toPlainString() : null);
                        values.add(asstQty != null ? asstQty.toPlainString() : null);
                        values.add(price != null ? price.toPlainString() : null);
                        values.add(assLocalDebit != null ? assLocalDebit.toPlainString() : null);
                        values.add(assLocalCredit != null ? assLocalCredit.toPlainString() : null);
                        values.add(strSettleTypeInfo != null ? strSettleTypeInfo.toString() : null);
                        values.add(strSettleCode != null ? strSettleCode.toString() : null);
                        values.add(strPrepare != null ? strPrepare.toString() : null);
                        values.add(null);
                        values.add(null);
                        values.add(strPoster != null ? strPoster.toString() : null);
                        values.add(strChecker != null ? strChecker.toString() : null);
                        values.add(String.valueOf(iAttachement));
                        values.add(String.valueOf(isPosted));
                        values.add(strModule != null ? strModule.toString() : null);
                        values.add(String.valueOf(isDeleted));
                        values.add(iVoucherTotalNumber != null ? iVoucherTotalNumber.toString() : null);
                        values.add(strMeasureUnitInfo != null ? strMeasureUnitInfo.toString() : null);
                        values.add(strAsstMeasureUnitInfo != null ? strAsstMeasureUnitInfo.toString() : null);
                        values.add(strRefrence != null ? strRefrence.toString() : null);
                        values.add(String.valueOf(tmpVoucher.getCashflowFlag().getValue()));
                        values.add(strInvoiceNumber != null ? strInvoiceNumber.toString() : null);
                        values.add(strTicketNumber != null ? strTicketNumber.toString() : null);
                        values.add(strCustomerInfo != null ? strCustomerInfo.toString() : null);
                        values.add(strFeeType != null ? strFeeType.toString() : null);
                        values.add(strCompanyOrgUnitInfo != null ? strCompanyOrgUnitInfo.toString() : null);
                        values.add(strMaterialInfo != null ? strMaterialInfo.toString() : null);
                        values.add(strHandlerInfo != null ? strHandlerInfo.toString() : null);
                        values.add(strSupplierInfo != null ? strSupplierInfo.toString() : null);
                        values.add(asstBizDate != null ? asstBizDate.toString() : null);
                        values.add(endDate != null ? endDate.toString() : null);
                        writer.addRecord(values.toArray());
                    }
                }
                boolean bl = isHasCashFlow = tmpVoucher.getCashflowFlag().getValue() > 0;
                if (!isHasCashFlow) continue;
                for (int l = 0; l < cashFlowRecordCollection.size(); ++l) {
                    CashflowRecordInfo cashFlowRecordInfo = cashFlowRecordCollection.get(l);
                    CashFlowItemInfo primaryCashFlowItemInfo = cashFlowRecordInfo.getPrimaryItem();
                    String strPrimaryCashFlowItemInfo = null;
                    if (primaryCashFlowItemInfo != null) {
                        strPrimaryCashFlowItemInfo = primaryCashFlowItemInfo.getNumber();
                    }
                    CashFlowItemInfo subCashFlowItemInfo = cashFlowRecordInfo.getSupplementaryItem();
                    String strSubCashFlowItemInfo = null;
                    if (subCashFlowItemInfo != null) {
                        strSubCashFlowItemInfo = subCashFlowItemInfo.getNumber();
                    }
                    BigDecimal cashFlowAmountFor = cashFlowRecordInfo.getOriginalAmount().stripTrailingZeros();
                    BigDecimal cashFlowAmountLocal = cashFlowRecordInfo.getLocalAmount().stripTrailingZeros();
                    String[] asstTypes = new String[8];
                    String[] asstItemNumbers = new String[8];
                    String[] asstItemNames = new String[8];
                    if (cashFlowRecordInfo.getAssGrp() != null) {
                        BOSUuid assGrpId = cashFlowRecordInfo.getAssGrp().getId();
                        HashMap<String, String> key = new HashMap<String, String>();
                        key.put("key", assGrpId.toString());
                        Map result = facade.dealTask("getAsstItem", key);
                        if (result != null) {
                            AsstActTypeCollection col = (AsstActTypeCollection)result.get("value");
                            int count = 0;
                            if (col != null) {
                                count = col.size();
                            }
                            for (int k = 0; k < count; ++k) {
                                AsstActTypeInfo data = col.get(k);
                                asstTypes[k] = (String)data.get("asstTypes");
                                asstItemNumbers[k] = (String)data.get("asstItemNumbers");
                                asstItemNames[k] = (String)data.get("asstItemNames");
                            }
                        }
                        values = new ArrayList();
                        values.add(company.getNumber());
                        values.add(voucherBizDate != null ? voucherBizDate.toString() : null);
                        values.add(String.valueOf(iPeriodNumber));
                        values.add(strVoucherTypeInfo != null ? strVoucherTypeInfo.toString() : null);
                        values.add(iNumber != null ? iNumber.toString() : null);
                        values.add(strCurrencyInfo != null ? strCurrencyInfo.toString() : null);
                        values.add(cashFlowRecordInfo.getEntry() != null ? String.valueOf(cashFlowRecordInfo.getEntry().getSeq()) : null);
                        values.add(cashFlowRecordInfo.getOpposingAccountEntry() != null ? String.valueOf(cashFlowRecordInfo.getOpposingAccountEntry().getSeq()) : null);
                        values.add(strPrimaryCashFlowItemInfo != null ? strPrimaryCashFlowItemInfo.toString() : null);
                        values.add(strSubCashFlowItemInfo != null ? strSubCashFlowItemInfo.toString() : null);
                        values.add(cashFlowAmountFor != null ? cashFlowAmountFor.toPlainString() : null);
                        values.add(cashFlowAmountLocal != null ? cashFlowAmountLocal.toPlainString() : null);
                        values.add(cashFlowRecordInfo != null && cashFlowRecordInfo.getReportingAmount() != null ? cashFlowRecordInfo.getReportingAmount().stripTrailingZeros().toPlainString() : null);
                        values.add(cashFlowRecordInfo != null ? String.valueOf(cashFlowRecordInfo.getPrimaryCoefficient()) : null);
                        values.add(cashFlowRecordInfo != null ? String.valueOf(cashFlowRecordInfo.getSupplementaryCoefficient()) : null);
                        values.add(cashFlowRecordInfo != null && cashFlowRecordInfo.getType() != null ? cashFlowRecordInfo.getType().toString().toString() : null);
                        values.add(asstTypes[0] != null ? asstTypes[0].toString() : null);
                        values.add(asstItemNumbers[0] != null ? asstItemNumbers[0].toString() : null);
                        values.add(asstItemNames[0] != null ? asstItemNames[0].toString() : null);
                        values.add(asstTypes[1] != null ? asstTypes[1].toString() : null);
                        values.add(asstItemNumbers[1] != null ? asstItemNumbers[1].toString() : null);
                        values.add(asstItemNames[1] != null ? asstItemNames[1].toString() : null);
                        values.add(asstTypes[2] != null ? asstTypes[2].toString() : null);
                        values.add(asstItemNumbers[2] != null ? asstItemNumbers[2].toString() : null);
                        values.add(asstItemNames[2] != null ? asstItemNames[2].toString() : null);
                        values.add(asstTypes[3] != null ? asstTypes[3].toString() : null);
                        values.add(asstItemNumbers[3] != null ? asstItemNumbers[3].toString() : null);
                        values.add(asstItemNames[3] != null ? asstItemNames[3].toString() : null);
                        values.add(asstTypes[4] != null ? asstTypes[4].toString() : null);
                        values.add(asstItemNumbers[4] != null ? asstItemNumbers[4].toString() : null);
                        values.add(asstItemNames[4] != null ? asstItemNames[4].toString() : null);
                        values.add(asstTypes[5] != null ? asstTypes[5].toString() : null);
                        values.add(asstItemNumbers[5] != null ? asstItemNumbers[5].toString() : null);
                        values.add(asstItemNames[5] != null ? asstItemNames[5].toString() : null);
                        values.add(asstTypes[6] != null ? asstTypes[6].toString() : null);
                        values.add(asstItemNumbers[6] != null ? asstItemNumbers[6].toString() : null);
                        values.add(asstItemNames[6] != null ? asstItemNames[6].toString() : null);
                        values.add(asstTypes[7] != null ? asstTypes[7].toString() : null);
                        values.add(asstItemNumbers[7] != null ? asstItemNumbers[7].toString() : null);
                        values.add(asstItemNames[7] != null ? asstItemNames[7].toString() : null);
                        writerCF.addRecord(values.toArray());
                        continue;
                    }
                    values = new ArrayList();
                    values.add(company.getNumber());
                    values.add(voucherBizDate != null ? voucherBizDate.toString() : null);
                    values.add(String.valueOf(iPeriodNumber));
                    values.add(strVoucherTypeInfo != null ? strVoucherTypeInfo.toString() : null);
                    values.add(iNumber != null ? iNumber.toString() : null);
                    values.add(strCurrencyInfo != null ? strCurrencyInfo.toString() : null);
                    values.add(cashFlowRecordInfo != null && cashFlowRecordInfo.getEntry() != null ? String.valueOf(cashFlowRecordInfo.getEntry().getSeq()) : null);
                    values.add(cashFlowRecordInfo != null && cashFlowRecordInfo.getOpposingAccountEntry() != null ? String.valueOf(cashFlowRecordInfo.getOpposingAccountEntry().getSeq()) : null);
                    values.add(strPrimaryCashFlowItemInfo != null ? strPrimaryCashFlowItemInfo.toString() : null);
                    values.add(strSubCashFlowItemInfo != null ? strSubCashFlowItemInfo.toString() : null);
                    values.add(cashFlowAmountFor != null ? cashFlowAmountFor.toPlainString() : null);
                    values.add(cashFlowAmountLocal != null ? cashFlowAmountLocal.toPlainString() : null);
                    values.add(cashFlowRecordInfo != null && cashFlowRecordInfo.getReportingAmount() != null ? cashFlowRecordInfo.getReportingAmount().stripTrailingZeros().toPlainString() : null);
                    values.add(cashFlowRecordInfo != null ? String.valueOf(cashFlowRecordInfo.getPrimaryCoefficient()) : null);
                    values.add(cashFlowRecordInfo != null ? String.valueOf(cashFlowRecordInfo.getSupplementaryCoefficient()) : null);
                    values.add(cashFlowRecordInfo != null && cashFlowRecordInfo.getType() != null ? cashFlowRecordInfo.getType().toString() : null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    writerCF.addRecord(values.toArray());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private DBFField[][] createTable(FileNameHelp help, boolean overide) throws EASBizException {
        DBFField[][] fields = new DBFField[2][];
        if (overide) {
            File file = new File(help.getFullFileName());
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(help.getCFFullFileName())).exists()) {
                file.delete();
            }
        }
        fields[0] = this.getExpCFStructure(help.getCFFullFileName());
        fields[1] = this.getExpVoucherStructureDBFFields(help.getFullFileName());
        return fields;
    }

    private DBFField[] getExpVoucherStructureDBFFields(String strTableName) {
        if (StringUtil.isEmptyString((String)strTableName)) {
            return null;
        }
        HashMap<String, Byte> types = new HashMap<String, Byte>();
        types.put("char", (byte)67);
        types.put("int", (byte)78);
        types.put("date", (byte)68);
        types.put("decimal", (byte)70);
        types.put("logical", (byte)76);
        String[][] keys = new String[][]{{"fgroupid", "char"}, {"fdate", "char"}, {"ftransdate", "char"}, {"fperiod", "char"}, {"fgroup", "char"}, {"fnum", "char"}, {"fentryid", "char"}, {"fexp", "char"}, {"facctid", "char"}, {"fclsname1", "char"}, {"fobjid1", "char"}, {"fobjname1", "char"}, {"fclsname2", "char"}, {"fobjid2", "char"}, {"fobjname2", "char"}, {"fclsname3", "char"}, {"fobjid3", "char"}, {"fobjname3", "char"}, {"fclsname4", "char"}, {"fobjid4", "char"}, {"fobjname4", "char"}, {"fclsname5", "char"}, {"fobjid5", "char"}, {"fobjname5", "char"}, {"fclsname6", "char"}, {"fobjid6", "char"}, {"fobjname6", "char"}, {"fclsname7", "char"}, {"fobjid7", "char"}, {"fobjname7", "char"}, {"fclsname8", "char"}, {"fobjid8", "char"}, {"fobjname8", "char"}, {"fdes", "char"}, {"ftransid", "char"}, {"fcyid", "char"}, {"fexchrate", "char"}, {"fdc", "char"}, {"ffcyamt", "char"}, {"fqty", "char"}, {"fassistqty", "char"}, {"fprice", "char"}, {"fdebit", "char"}, {"fcredit", "char"}, {"fsettlcode", "char"}, {"fsettleno", "char"}, {"fprepare", "char"}, {"fpay", "char"}, {"fcash", "char"}, {"fposter", "char"}, {"fchecker", "char"}, {"fattchment", "char"}, {"fposted", "char"}, {"fmodule", "char"}, {"fdeleted", "char"}, {"fserialno", "char"}, {"funitname", "char"}, {"fassistuni", "char"}, {"freference", "char"}, {"fcashflow", "char"}, {"finvnum", "char"}, {"fticketnum", "char"}, {"fcustomer", "char"}, {"ffeetype", "char"}, {"forgunit", "char"}, {"fmaterial", "char"}, {"fhandler", "char"}, {"fsupplier", "char"}, {"fbizdate", "char"}, {"fenddate", "char"}};
        DBFField[] fields = new DBFField[keys.length];
        DBFField field = null;
        Byte type = null;
        for (int i = 0; i < fields.length; ++i) {
            field = new DBFField();
            type = (Byte)types.get(keys[i][1]);
            field.setName(keys[i][0]);
            field.setDataType(type);
            if (type.equals((byte)67)) {
                field.setFieldLength(80);
            }
            if (type.equals((byte)78)) {
                field.setFieldLength(2);
            }
            fields[i] = field;
        }
        return fields;
    }

    private DBFField[] getExpCFStructure(String strTableName) {
        if (StringUtil.isEmptyString((String)strTableName)) {
            return null;
        }
        if (StringUtil.isEmptyString((String)strTableName)) {
            return null;
        }
        HashMap<String, Byte> types = new HashMap<String, Byte>();
        types.put("char", (byte)67);
        types.put("int", (byte)78);
        types.put("date", (byte)68);
        types.put("decimal", (byte)70);
        String[][] keys = new String[][]{{"fgroupid", "char"}, {"fdate", "char"}, {"fperiod", "char"}, {"fgroup", "char"}, {"fnum", "char"}, {"fcyid", "char"}, {"fentryid", "char"}, {"fopentryid", "char"}, {"fnumber", "char"}, {"fsubnumber", "char"}, {"famountfor", "char"}, {"famountloc", "char"}, {"famountrpt", "char"}, {"fpricoef", "char"}, {"fsupcoef", "char"}, {"ftype", "char"}, {"fclsname1", "char"}, {"fobjid1", "char"}, {"fobjname1", "char"}, {"fclsname2", "char"}, {"fobjid2", "char"}, {"fobjname2", "char"}, {"fclsname3", "char"}, {"fobjid3", "char"}, {"fobjname3", "char"}, {"fclsname4", "char"}, {"fobjid4", "char"}, {"fobjname4", "char"}, {"fclsname5", "char"}, {"fobjid5", "char"}, {"fobjname5", "char"}, {"fclsname6", "char"}, {"fobjid6", "char"}, {"fobjname6", "char"}, {"fclsname7", "char"}, {"fobjid7", "char"}, {"fobjname7", "char"}, {"fclsname8", "char"}, {"fobjid8", "char"}, {"fobjname8", "char"}};
        DBFField[] fields = new DBFField[keys.length];
        DBFField field = null;
        Byte type = null;
        for (int i = 0; i < fields.length; ++i) {
            field = new DBFField();
            type = (Byte)types.get(keys[i][1]);
            field.setName(keys[i][0]);
            field.setDataType(type);
            if (type.equals((byte)67)) {
                field.setFieldLength(80);
            }
            if (type.equals((byte)78)) {
                field.setFieldLength(2);
            }
            fields[i] = field;
        }
        return fields;
    }

    public static class FileNameHelp {
        String fullFileName = null;
        String postfix_CF = "CF";
        String extend = null;

        public FileNameHelp(String fullFileName) {
            this.fullFileName = fullFileName;
            int iIndex = fullFileName.lastIndexOf(".");
            this.extend = fullFileName.substring(iIndex + 1).toLowerCase();
        }

        public String getExtend() {
            return this.extend;
        }

        public String getPostfix_CF() {
            return this.postfix_CF;
        }

        public void setExtend(String string) {
            this.extend = string;
        }

        public void setPostfix_CF(String string) {
            this.postfix_CF = string;
        }

        public String getPathDirection() {
            int iIndex = this.fullFileName.lastIndexOf(File.separatorChar);
            return this.fullFileName.substring(0, iIndex);
        }

        public String getFileName() {
            int index = this.fullFileName.lastIndexOf(File.separatorChar);
            String fn = this.fullFileName.substring(index + 1);
            return fn.substring(0, fn.indexOf(46));
        }

        public String getCFFileName() {
            String strFileName = this.getFileName();
            String strCFFile = strFileName + this.postfix_CF;
            return strCFFile;
        }

        public String getCFFullFileName() {
            String strFileName = this.fullFileName;
            int iIndex = strFileName.toLowerCase().lastIndexOf("." + this.extend.toLowerCase());
            String strCFFile = strFileName.substring(0, iIndex);
            strCFFile = strCFFile + this.postfix_CF + "." + this.extend;
            return strCFFile;
        }

        public String getFullFileName() {
            this.fullFileName = this.fullFileName.replace('/', File.separatorChar);
            this.fullFileName = this.fullFileName.replace('\\', File.separatorChar);
            return this.fullFileName;
        }
    }
}

