/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucherAssistRecord;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VoucherPrintDataProvider {
    public static final String[] col = new String[]{"pageCount", "pageCurrent", "pageTotal", "company", "companyNumber", "code", "companyBaseCurreny", "companyReportCurreny", "description", "attachments", "attachmentsChinese", "sum", "periodYear", "periodNumber", "bizDate", "voucherDate", "bookedDate", "bookedDateYear", "bookedDateMonth", "bookedDateDay", "sysDateNow", "vchId", "bizStatus", "voucherType", "number", "numberShort", "vouchtTypeNumber", "currency", "amountTotalChinese", "amountTotal", "creditTotal", "debitTotal", "localAmountDebit", "localAmountCredit", "reportingAmountDebit", "reportingAmountCredit", "amountTotalChinese_org", "amountTotal_org", "creditTotal_org", "debitTotal_org", "localAmountDebit_org", "localAmountCredit_org", "reportingAmountDebit_org", "reportingAmountCredit_org", "handler", "creator", "auditor", "cashier", "poster", "canceller", "e_seq", "e_description", "e_account", "e_accountCategory", "e_profitCenter", "zc_account", "e_currency", "e_isoCode", "e_measureUnitName", "e_measureUnitNumber", "e_price", "e_quantity", "e_originalAmount", "e_originalAmountDebit", "e_originalAmountCredit", "e_localExchangeRate", "e_localAmountDebit", "e_localAmountCredit", "e_reportingExchangeRate", "e_reportingAmountDebit", "e_reportingAmountCredit", "r_description", "r_settlementType", "r_settlementCode", "r_bizNumber", "r_originalAmount", "r_originalAmountDebit", "r_originalAmountCredit", "r_localAmount", "r_localAmountDebit", "r_localAmountCredit", "r_reportingAmount", "r_reportingAmountDebit", "r_reportingAmountCredit", "r_measureUnitName", "r_measureUnitNumber", "r_price", "r_quantity", "r_bizDate", "r_invoice", "r_endDate", "r_customer", "r_supplier", "r_orgUnit", "r_matirial", "r_assGrp", "r_longName", "r_AsstHeadNumber", "r_AsstNumber", "r_AsstHeadName", "r_AsstName", "r_AsstLevelName", "r_accountAsst", "r_accountAsstPrimItem", "zc_assGrp", "c_item", "c_itemEbb", "c_primItem", "c_supp", "c_suppEbb", "c_suppItem", "c_fullInfo", "c_fullInfoEbb", "c_fullInfoItem", "c_oppAccount", "c_originalAmount", "c_localAmount", "c_reportingAmount", "c_primItemName", "c_suppItemName", "customer.number", "customer.name", "cusNumberName", "c_asstactName", "c_asstactNumber", "c_cashFlowAndAsstactGoupName", "c_asstactDisplayNameGroup", "c_asstactLongGroupName", "sourceSys", "sourceType"};
    private Map<String, String> enumStr = new HashMap<String, String>();
    protected Map asstributeMap = new HashMap();
    private VoucherPrintSettingInfo settingInfo;
    private int pricePre = 2;
    private int qtyPre = 2;
    private boolean isAstQty = false;
    private boolean generalAsstShowLongNumber = false;
    private Map mapPrecision;
    private boolean commonVoucherProcess = false;

    public VoucherPrintDataProvider(VoucherPrintSettingInfo settingInfo) throws EASBizException, BOSException {
        this.settingInfo = settingInfo;
        Map sysParam = this.getSysParam();
        this.isAstQty = Boolean.valueOf(sysParam.get("G010").toString());
        this.qtyPre = Integer.parseInt(sysParam.get("GL_002").toString());
        this.pricePre = Integer.parseInt(sysParam.get("GL_003").toString());
        this.generalAsstShowLongNumber = Boolean.valueOf(sysParam.get("GL_064").toString());
    }

    private Map getSysParam() throws BOSException, EASBizException {
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("G010", null);
        hmParamIn.put("GL_002", null);
        hmParamIn.put("GL_003", null);
        hmParamIn.put("GL_064", null);
        return ParamControlFactory.getRemoteInstance().getParamHashMap(hmParamIn);
    }

    public void setSystemDate(IRowSet rs, DateFormat dft, java.util.Date serverDate) throws Exception {
        if (serverDate == null) {
            serverDate = SysUtil.getAppServerTime(null);
        }
        rs.updateString("sysDateNow", GlUtils.formatDate(dft, serverDate));
    }

    public void fillVoucherHeaderDataCF(BaseVoucherInfo vch, IRowSet rs, Set voucherCFSet) throws Exception {
        if (voucherCFSet != null && !voucherCFSet.isEmpty()) {
            for (String value : voucherCFSet) {
                Object item;
                Object info;
                String[] valueArr = value.split("#");
                if (valueArr.length == 2) {
                    if (vch == null || !vch.containsKey(valueArr[1]) || (info = vch.get(valueArr[1])) == null) continue;
                    rs.updateString(value, info.toString());
                    continue;
                }
                if (vch == null || !vch.containsKey(valueArr[1]) || (info = (ObjectBaseInfo)vch.get(valueArr[1])) == null || !info.containsKey(valueArr[2]) || (item = info.get(valueArr[2])) == null) continue;
                rs.updateString(value, item.toString());
            }
        }
    }

    public void fillVoucherEntryDataCF(BaseVoucherEntryInfo e, IRowSet rs, Set entryCFSet) throws Exception {
        if (entryCFSet != null && !entryCFSet.isEmpty()) {
            for (String value : entryCFSet) {
                Object item;
                Object info;
                String[] valueArr = value.split("#");
                if (valueArr.length == 2) {
                    if (e == null || !e.containsKey(valueArr[1]) || (info = e.get(valueArr[1])) == null) continue;
                    rs.updateString(value, info.toString());
                    continue;
                }
                if (e == null || !e.containsKey(valueArr[1]) || (info = (ObjectBaseInfo)e.get(valueArr[1])) == null || !info.containsKey(valueArr[2]) || (item = info.get(valueArr[2])) == null) continue;
                rs.updateString(value, item.toString());
            }
        }
    }

    public void fillVoucherASSTDataCF(BaseVoucherAssistRecordInfo r, IRowSet rs, Set asstCFSet) throws Exception {
        if (asstCFSet != null && !asstCFSet.isEmpty()) {
            for (String value : asstCFSet) {
                Object item;
                Object info;
                String[] valueArr = value.split("#");
                if (valueArr.length == 2) {
                    if (r == null || !r.containsKey(valueArr[1]) || (info = r.get(valueArr[1])) == null) continue;
                    rs.updateString(value, info.toString());
                    continue;
                }
                if (r == null || !r.containsKey(valueArr[1]) || (info = (ObjectBaseInfo)r.get(valueArr[1])) == null || !info.containsKey(valueArr[2]) || (item = info.get(valueArr[2])) == null) continue;
                rs.updateString(value, item.toString());
            }
        }
    }

    public void fillVoucherHeaderData(BaseVoucherInfo vch, IRowSet rs, DateFormat df, DateFormat dft, int size, BigDecimal allDeit, BigDecimal allCret) throws Exception {
        CompanyOrgUnitInfo com = vch.getCompany();
        this.initGLMap(com.getId().toString());
        rs.updateString("company", com.getName());
        rs.updateString("companyNumber", com.getNumber());
        rs.updateString("code", com.getCode());
        if (com.getBaseCurrency().getName() != null) {
            rs.updateString("companyBaseCurreny", com.getBaseCurrency().getName().toString());
        }
        if (com.getReportCurrency() != null && com.getReportCurrency().getName() != null) {
            rs.updateString("companyReportCurreny", com.getReportCurrency().getName().toString());
        }
        rs.updateString("description", vch.getDescription());
        rs.updateDate("bookedDate", new Date(vch.getBookedDate().getTime()));
        rs.updateDate("voucherDate", new Date(vch.getBookedDate().getTime()));
        rs.updateString("sourceSys", this.getSourceSysString(vch.getSourceSys()));
        rs.updateString("sourceType", this.getSourceTypeString(vch.getSourceType()));
        Date voucherBookDate = (Date)vch.getBookedDate();
        Calendar now = Calendar.getInstance();
        now.setTime(voucherBookDate);
        rs.updateString("bookedDateYear", String.valueOf(now.get(1)));
        int month = now.get(2) + 1;
        rs.updateString("bookedDateMonth", month < 10 ? "0" + month : "" + month);
        int date = now.get(5);
        rs.updateString("bookedDateDay", date < 10 ? "0" + date : "" + date);
        rs.updateDate("bizDate", new Date(vch.getBizDate().getTime()));
        PeriodInfo prd = vch.getPeriod();
        if (prd != null) {
            rs.updateString("periodYear", Integer.toString(prd.getPeriodYear()));
            rs.updateString("periodNumber", Integer.toString(prd.getPeriodNumber()));
        }
        String type = GlUtils.getName((IObjectValue)vch, "voucherType");
        rs.updateString("voucherType", type);
        String strNumber = vch.getNumber();
        String strNumberShort = "";
        if (strNumber != null) {
            int n = strNumber.length();
            int il = 0;
            char[] ch = new char[n];
            for (int i = 0; i < n; ++i) {
                ch[i] = strNumber.charAt(i);
                if (ch[i] != '0') break;
                ++il;
            }
            strNumberShort = strNumber.substring(il, n);
        }
        rs.updateString("number", vch.getNumber());
        rs.updateString("numberShort", strNumberShort);
        rs.updateString("vouchtTypeNumber", type + vch.getNumber());
        rs.updateString("currency", GlUtils.getName((IObjectValue)vch, "currency"));
        rs.updateString("handler", GlUtils.getName((IObjectValue)vch, "handler"));
        rs.updateString("creator", GlUtils.getName((IObjectValue)vch, "creator"));
        rs.updateString("auditor", GlUtils.getName((IObjectValue)vch, "auditor"));
        rs.updateString("cashier", GlUtils.getName((IObjectValue)vch, "cashier"));
        rs.updateString("poster", GlUtils.getName((IObjectValue)vch, "poster"));
        rs.updateString("canceller", GlUtils.getName((IObjectValue)vch, "canceller"));
    }

    public void fillVoucherEntryData(String vchId, BaseVoucherEntryInfo e, IRowSet rs, int lcpre, int rcpre, String companyId) throws Exception {
        rs.updateString("vchId", vchId);
        rs.updateString("e_seq", Integer.toString(e.getSeq()));
        rs.updateString("e_description", e.getDescription());
        if (rs.getString("r_description") == null) {
            rs.updateString("r_description", e.getDescription());
        }
        String acctname = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
        acctname = this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName() ? GlUtils.getNumberAndLongName((IObjectValue)e, "account") : (!this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName() ? GlUtils.getLongName((IObjectValue)e, "account") : (this.settingInfo.isShowAccountNumber() && !this.settingInfo.isShowAccountFullName() ? GlUtils.getNumberAndName((IObjectValue)e, "account") : GlUtils.getName((IObjectValue)e, "account")));
        String acctnameZC = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
        String topAccountNumer = null;
        AccountViewInfo account = (AccountViewInfo)e.get("account");
        if (account != null && account.getLongNumber() != null && account.getLevel() != 1) {
            String longNumber = account.getLongNumber();
            int idx = longNumber.indexOf("!");
            topAccountNumer = longNumber.substring(0, idx);
        }
        String zc_acctname = "";
        if (acctnameZC != null) {
            zc_acctname = acctnameZC.indexOf("_", 0) != -1 && acctnameZC.indexOf("_", 0) != -1 ? (this.settingInfo.isShowAccountNumber() && topAccountNumer != null ? topAccountNumer + " - " + acctnameZC.substring(acctnameZC.indexOf("-", 0) + 2, acctnameZC.indexOf("_", 0)) : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 2, acctnameZC.indexOf("_", 0))) : (this.settingInfo.isShowAccountNumber() ? acctnameZC : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 2, acctnameZC.length()));
        } else {
            acctname = "";
        }
        if (null != rs.getString("e_accountCategory")) {
            rs.updateString("e_accountCategory", Integer.toString(e.getAccount().getCategory().getValue()));
        }
        rs.updateString("e_account", acctname);
        rs.updateString("r_accountAsst", acctname);
        rs.updateString("r_accountAsstPrimItem", acctname);
        rs.updateString("zc_account", zc_acctname);
        if (e.getAssistRecords() == null || e.getAssistRecords().size() == 0 || !this.settingInfo.isPrintAssistant()) {
            rs.updateString("zc_assGrp", GlUtils.getName((IObjectValue)e, "account"));
            String accountLongName = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
            String accountDetail = "";
            if (!this.settingInfo.isShowAccountNumber() && !this.settingInfo.isShowAccountFullName()) {
                if (accountLongName != null) {
                    accountDetail = accountLongName.indexOf("_", 0) != -1 ? accountLongName.substring(accountLongName.indexOf("_", 0) + 1, accountLongName.length()) : accountLongName.substring(accountLongName.indexOf("-", 0) + 1, accountLongName.length());
                }
            } else {
                accountDetail = acctname;
            }
            if (accountDetail != null && !"".equals(accountDetail.trim())) {
                rs.updateString("zc_assGrp", accountDetail);
            } else {
                rs.updateString("zc_assGrp", GlUtils.getName((IObjectValue)e, "account"));
            }
        }
        if (e.getAccount() != null && e.getAccount().isIsQty()) {
            if (e.getMeasureUnit() != null) {
                rs.updateString("e_measureUnitName", e.getMeasureUnit().getName());
                rs.updateString("e_measureUnitNumber", e.getMeasureUnit().getNumber());
            }
            rs.updateString("e_price", GlUtils.formatNumber(e.getPrice(), this.pricePre));
            rs.updateString("e_quantity", GlUtils.formatNumber(e.getQuantity(), this.qtyPre));
        }
        if (e.getCustomer() != null) {
            rs.updateString("customer.number", e.getCustomer().getNumber());
            rs.updateString("customer.name", e.getCustomer().getName());
            rs.updateString("cusNumberName", e.getCustomer().getNumber() + "\uff1a" + e.getCustomer().getName());
        }
        if (this.commonVoucherProcess) {
            ProfitCenterOrgUnitInfo p = (ProfitCenterOrgUnitInfo)e.get("profitCenter");
            rs.updateString("e_profitCenter", p == null ? "" : p.getName());
        }
        rs.updateString("e_currency", GlUtils.getName((IObjectValue)e, "currency"));
        if (e.getCurrency() != null) {
            rs.updateString("e_isoCode", e.getCurrency().getIsoCode());
            rs.updateString("e_localExchangeRate", GlUtils.formatNumber(e.getLocalExchangeRate()));
            rs.updateString("e_reportingExchangeRate", GlUtils.formatNumber(e.getReportingExchangeRate()));
        }
        rs.updateString("e_originalAmount", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
        rs.updateString("r_originalAmount", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
        EntryDC dc = e.getEntryDC();
        if (EntryDC.DEBIT.equals((Object)dc)) {
            rs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
            rs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
            rs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
            rs.updateString("r_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
            rs.updateString("r_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
            rs.updateString("r_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
        } else {
            rs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
            rs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
            rs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
            rs.updateString("r_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
            rs.updateString("r_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
            rs.updateString("r_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
        }
    }

    public void fillVoucherASSTData(BaseVoucherAssistRecordInfo r, IRowSet rs, DateFormat adf, int lcpre, EntryDC dc, IAssistantHG assistantHG, IBaseVoucherAssistRecord asstre, BaseVoucherEntryInfo e, String companyId) throws Exception {
        String acctname = rs.getString("e_account");
        rs.updateString("r_description", r.getDescription());
        if (rs.getString("r_description") == null) {
            rs.updateString("r_description", e.getDescription());
        }
        if (r.getMeasureUnit() != null && e.getAccount() != null && e.getAccount().isIsQty()) {
            rs.updateString("r_measureUnitName", r.getMeasureUnit().getName());
            rs.updateString("r_measureUnitNumber", r.getMeasureUnit().getNumber());
            rs.updateString("e_measureUnitName", r.getMeasureUnit().getName());
            rs.updateString("e_measureUnitNumber", r.getMeasureUnit().getNumber());
        }
        if (r.getSettlementType() != null) {
            rs.updateString("r_settlementType", r.getSettlementType().getDisplayName());
        }
        if (e.getAccount() != null && e.getAccount().isAC()) {
            rs.updateDate("r_endDate", new Date(r.getEndDate().getTime()));
        } else {
            rs.updateString("r_endDate", "");
        }
        rs.updateString("r_settlementCode", r.getSettlementCode());
        rs.updateString("r_bizNumber", r.getBizNumber());
        rs.updateDate("r_bizDate", new Date(r.getBizDate().getTime()));
        rs.updateString("r_invoice", r.getInvoiceNumber());
        if (EntryDC.DEBIT.equals((Object)dc)) {
            rs.updateString("e_originalAmountDebit", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
            rs.updateString("e_localAmountDebit", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
            rs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
            rs.updateString("r_originalAmountDebit", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
            rs.updateString("r_localAmountDebit", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
            rs.updateString("r_reportingAmountDebit", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
        } else {
            rs.updateString("e_localAmountCredit", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
            rs.updateString("e_originalAmountCredit", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
            rs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
            rs.updateString("r_originalAmountCredit", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
            rs.updateString("r_localAmountCredit", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
            rs.updateString("r_reportingAmountCredit", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
        }
        rs.updateString("r_originalAmount", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
        rs.updateString("r_reportingAmount", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
        rs.updateString("r_localAmount", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
        String assGrpId = null;
        String name = null;
        String fullName = null;
        String levelName = null;
        String assGrp = null;
        String assGrpNumber = null;
        String asstFull = null;
        String asstFullNumber = null;
        String asstheadnumber = null;
        String asstnumber = null;
        String asstShortNumber = null;
        String asstheadname = null;
        String asstname = null;
        String asstlevelname = null;
        String asstLevelNameNumber = null;
        String zc_listacctname = "";
        AssistantHGInfo assistantHGInfo = r.getAssGrp();
        if (assistantHGInfo != null) {
            if (e.getAccount().getCAA() != null && e.getAccount().isIsQty() && (e.getAccount().getCAA().isIsQty() || !this.isAstQty)) {
                rs.updateString("r_price", GlUtils.formatNumber(r.getPrice(), this.pricePre));
                rs.updateString("r_quantity", GlUtils.formatNumber(r.getQuantity(), this.qtyPre));
                rs.updateString("e_price", GlUtils.formatNumber(r.getPrice(), this.pricePre));
                rs.updateString("e_quantity", GlUtils.formatNumber(r.getQuantity(), this.qtyPre));
            }
            IObjectValue value = null;
            assGrpId = assistantHGInfo.getId().toString();
            levelName = this.settingInfo.isShowAsstFullName() ? this.getAsstribute("r_AsstLevelNameNumber", assGrpId) : this.getAsstribute("r_AsstLevelName", assGrpId);
            if (this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                fullName = this.getAsstribute("r_asstFullNumber", assGrpId);
            } else if (this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                fullName = this.getAsstribute("r_asstFull", assGrpId);
            } else if (!this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                fullName = this.getAsstribute("r_assGrp", assGrpId);
            } else if (!this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                fullName = this.getAsstribute("r_assGrpNumber", assGrpId);
            }
            assGrp = this.getAsstribute("assGrp", assGrpId);
            assGrpNumber = this.getAsstribute("assGrpNumber", assGrpId);
            asstFull = this.getAsstribute("asstFull", assGrpId);
            asstFullNumber = this.getAsstribute("asstFullNumber", assGrpId);
            asstheadnumber = this.getAsstribute("r_AsstHeadNumber", assGrpId);
            asstnumber = this.getAsstribute("r_AsstNumber", assGrpId);
            asstShortNumber = this.getAsstribute("r_AsstShortNumber", assGrpId);
            asstheadname = this.getAsstribute("r_AsstHeadName", assGrpId);
            asstname = this.getAsstribute("r_AsstName", assGrpId);
            asstlevelname = this.getAsstribute("r_AsstLevelName", assGrpId);
            asstLevelNameNumber = this.getAsstribute("r_AsstLevelNameNumber", assGrpId);
            if (name == null) {
                value = this.getAsstValue(r.getAssGrp().getId().toString(), assistantHG, asstre);
                assGrp = value.getString("assGrp");
                this.setAsstribute("r_assGrp", assGrpId, assGrp);
                asstnumber = value.getString("asstnumber");
                this.setAsstribute("r_AsstNumber", assGrpId, asstnumber);
                asstShortNumber = value.getString("asstShortNumber");
                this.setAsstribute("r_AsstShortNumber", assGrpId, asstShortNumber);
                assGrpNumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("assGrpNumber"));
                this.setAsstribute("r_assGrpNumber", assGrpId, assGrpNumber);
                asstFull = value.getString("asstFull");
                this.setAsstribute("r_asstFull", assGrpId, asstFull);
                asstFullNumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("asstFullNumber"));
                this.setAsstribute("r_asstFullNumber", assGrpId, asstFullNumber);
                asstheadnumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("asstheadnumber"));
                this.setAsstribute("r_AsstHeadNumber", assGrpId, asstheadnumber);
                asstheadname = value.getString("asstheadname");
                this.setAsstribute("r_AsstHeadName", assGrpId, asstheadname);
                asstname = "";
                String tempasstheadname = this.getStr(asstheadname);
                if (!"".equals(tempasstheadname)) {
                    String[] cutByFs = tempasstheadname.split(";");
                    for (int i = 0; i < cutByFs.length; ++i) {
                        String[] cutByMs = cutByFs[i].split(":");
                        if (cutByMs.length < 2) continue;
                        asstname = asstname + cutByMs[1] + ";";
                    }
                }
                asstname = asstname.substring(0, asstname.length() > 0 ? asstname.length() - 1 : 0);
                this.setAsstribute("r_AsstName", assGrpId, asstname);
                asstlevelname = value.getString("asstlevelname");
                this.setAsstribute("r_AsstLevelName", assGrpId, asstlevelname);
                asstLevelNameNumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("asstLevelNameNumber"));
                this.setAsstribute("r_AsstLevelNameNumber", assGrpId, asstLevelNameNumber);
                levelName = this.settingInfo.isShowAsstFullName() ? asstLevelNameNumber : asstlevelname;
                if (this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                    fullName = asstFullNumber;
                    name = this.getNameAndAssGrpNumber(asstheadname, asstnumber, asstlevelname);
                } else if (this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                    name = fullName = asstFull;
                } else if (!this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                    name = fullName = assGrp;
                } else if (!this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                    fullName = assGrpNumber;
                    name = this.getNameAndAssGrpNumber(asstheadname, asstnumber, asstname);
                }
            }
            acctname = this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName() ? GlUtils.getNumberAndLongName((IObjectValue)e, "account") : (!this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName() ? GlUtils.getLongName((IObjectValue)e, "account") : (this.settingInfo.isShowAccountNumber() && !this.settingInfo.isShowAccountFullName() ? GlUtils.getNumberAndName((IObjectValue)e, "account") : GlUtils.getName((IObjectValue)e, "account")));
            String acctnameZC = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
            zc_listacctname = acctnameZC.indexOf("_", 0) != -1 ? acctnameZC.substring(acctnameZC.indexOf("_", 0) + 1, acctnameZC.length()) : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 1, acctnameZC.length());
        } else {
            String acctnameZC = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
            zc_listacctname = acctnameZC.indexOf("_", 0) != -1 ? acctnameZC.substring(acctnameZC.indexOf("_", 0) + 1, acctnameZC.length()) : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 1, acctnameZC.length());
        }
        String accountNumber = GlUtils.getNumber((IObjectValue)e, "account");
        if (fullName == null || "null".equals(fullName)) {
            name = fullName = "";
        }
        String name_refactory = this.getStr(name);
        String fullName_refactory = "";
        if (fullName != null && !"null".equals(fullName) && fullName.length() > 0 && this.getStr(fullName) != null && this.getStr(fullName).length() > 0) {
            fullName_refactory = "(" + this.getStr(fullName) + ")";
        }
        if (!this.settingInfo.isNotPrintSelectedAccountAsst()) {
            rs.updateString("r_assGrp", name_refactory);
            rs.updateString("r_longName", this.getStr(fullName));
            rs.updateString("r_AsstHeadNumber", asstheadnumber);
            rs.updateString("r_AsstNumber", this.generalAsstShowLongNumber ? asstnumber : asstShortNumber);
            rs.updateString("r_AsstHeadName", asstheadname);
            rs.updateString("r_AsstName", asstname);
            rs.updateString("r_AsstLevelName", levelName);
            rs.updateString("r_accountAsst", acctname + "" + fullName_refactory + "");
            rs.updateString("zc_assGrp", zc_listacctname + "" + fullName_refactory + "");
            rs.updateString("r_accountAsstPrimItem", acctname + "" + fullName_refactory + "");
        } else if (this.settingInfo.isNotPrintSelectedAccountAsst() && !this.balanceAccountIsInExistence(accountNumber)) {
            rs.updateString("r_assGrp", name_refactory);
            rs.updateString("r_longName", fullName_refactory);
            rs.updateString("r_AsstHeadNumber", asstheadnumber);
            rs.updateString("r_AsstNumber", this.generalAsstShowLongNumber ? asstnumber : asstShortNumber);
            rs.updateString("r_AsstHeadName", asstheadname);
            rs.updateString("r_AsstName", asstname);
            rs.updateString("r_AsstLevelName", levelName);
            rs.updateString("r_accountAsst", acctname + "" + fullName_refactory + "");
            rs.updateString("zc_assGrp", zc_listacctname + "" + this.getStr(fullName) + "");
            rs.updateString("r_accountAsstPrimItem", acctname + "" + fullName_refactory + "");
        } else {
            rs.updateString("r_assGrp", "");
            rs.updateString("r_longName", "");
            rs.updateString("r_AsstHeadNumber", "");
            rs.updateString("r_AsstNumber", "");
            rs.updateString("r_AsstHeadName", "");
            rs.updateString("r_AsstName", "");
            rs.updateString("r_AsstLevelName", "");
            rs.updateString("r_accountAsst", "");
            rs.updateString("r_accountAsstPrimItem", "");
            rs.updateString("zc_assGrp", "");
            rs.updateString("r_description", e.getDescription());
        }
    }

    public void fillVoucherASSTData_new(BaseVoucherAssistRecordInfo r, IRowSet rs, DateFormat adf, int lcpre, EntryDC dc, Map<String, IObjectValue> asstHGMap, BaseVoucherEntryInfo e, String companyId) throws Exception {
        String acctname = rs.getString("e_account");
        rs.updateString("r_description", r.getDescription());
        if (rs.getString("r_description") == null) {
            rs.updateString("r_description", e.getDescription());
        }
        if (r.getMeasureUnit() != null && e.getAccount() != null && e.getAccount().isIsQty()) {
            rs.updateString("r_measureUnitName", r.getMeasureUnit().getName());
            rs.updateString("r_measureUnitNumber", r.getMeasureUnit().getNumber());
            rs.updateString("e_measureUnitName", r.getMeasureUnit().getName());
            rs.updateString("e_measureUnitNumber", r.getMeasureUnit().getNumber());
        }
        if (r.getSettlementType() != null) {
            rs.updateString("r_settlementType", r.getSettlementType().getDisplayName());
        }
        if (e.getAccount() != null && e.getAccount().isAC()) {
            rs.updateDate("r_endDate", new Date(r.getEndDate().getTime()));
        } else {
            rs.updateString("r_endDate", "");
        }
        rs.updateString("r_settlementCode", r.getSettlementCode());
        rs.updateString("r_bizNumber", r.getBizNumber());
        rs.updateDate("r_bizDate", new Date(r.getBizDate().getTime()));
        rs.updateString("r_invoice", r.getInvoiceNumber());
        if (EntryDC.DEBIT.equals((Object)dc)) {
            rs.updateString("e_originalAmountDebit", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
            rs.updateString("e_localAmountDebit", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
            rs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
            rs.updateString("r_originalAmountDebit", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
            rs.updateString("r_localAmountDebit", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
            rs.updateString("r_reportingAmountDebit", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
        } else {
            rs.updateString("e_localAmountCredit", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
            rs.updateString("e_originalAmountCredit", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
            rs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
            rs.updateString("r_originalAmountCredit", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
            rs.updateString("r_localAmountCredit", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
            rs.updateString("r_reportingAmountCredit", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
        }
        rs.updateString("r_originalAmount", GlUtils.formatNumber(r.getOriginalAmount(), lcpre));
        rs.updateString("r_reportingAmount", GlUtils.formatNumber(r.getReportingAmount(), lcpre));
        rs.updateString("r_localAmount", GlUtils.formatNumber(r.getLocalAmount(), lcpre));
        String assGrpId = null;
        String name = null;
        String fullName = null;
        String levelName = null;
        String assGrp = null;
        String assGrpNumber = null;
        String asstFull = null;
        String asstFullNumber = null;
        String asstheadnumber = null;
        String asstnumber = null;
        String asstShortNumber = null;
        String asstheadname = null;
        String asstname = null;
        String asstlevelname = null;
        String asstLevelNameNumber = null;
        String zc_listacctname = "";
        AssistantHGInfo assistantHGInfo = r.getAssGrp();
        if (assistantHGInfo != null) {
            if (e.getAccount().getCAA() != null && e.getAccount().isIsQty() && (e.getAccount().getCAA().isIsQty() || !this.isAstQty)) {
                rs.updateString("r_price", GlUtils.formatNumber(r.getPrice(), this.pricePre));
                rs.updateString("r_quantity", GlUtils.formatNumber(r.getQuantity(), this.qtyPre));
                rs.updateString("e_price", GlUtils.formatNumber(r.getPrice(), this.pricePre));
                rs.updateString("e_quantity", GlUtils.formatNumber(r.getQuantity(), this.qtyPre));
            }
            IObjectValue value = null;
            assGrpId = assistantHGInfo.getId().toString();
            levelName = this.settingInfo.isShowAsstFullName() ? this.getAsstribute("r_AsstLevelNameNumber", assGrpId) : this.getAsstribute("r_AsstLevelName", assGrpId);
            if (this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                fullName = this.getAsstribute("r_asstFullNumber", assGrpId);
            } else if (this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                fullName = this.getAsstribute("r_asstFull", assGrpId);
            } else if (!this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                fullName = this.getAsstribute("r_assGrp", assGrpId);
            } else if (!this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                fullName = this.getAsstribute("r_assGrpNumber", assGrpId);
            }
            assGrp = this.getAsstribute("assGrp", assGrpId);
            assGrpNumber = this.getAsstribute("assGrpNumber", assGrpId);
            asstFull = this.getAsstribute("asstFull", assGrpId);
            asstFullNumber = this.getAsstribute("asstFullNumber", assGrpId);
            asstheadnumber = this.getAsstribute("r_AsstHeadNumber", assGrpId);
            asstnumber = this.getAsstribute("r_AsstNumber", assGrpId);
            asstShortNumber = this.getAsstribute("r_AsstShortNumber", assGrpId);
            asstheadname = this.getAsstribute("r_AsstHeadName", assGrpId);
            asstname = this.getAsstribute("r_AsstName", assGrpId);
            asstlevelname = this.getAsstribute("r_AsstLevelName", assGrpId);
            asstLevelNameNumber = this.getAsstribute("r_AsstLevelNameNumber", assGrpId);
            if (name == null) {
                value = asstHGMap.get(r.getAssGrp().getId().toString());
                assGrp = value.getString("assGrp");
                this.setAsstribute("r_assGrp", assGrpId, assGrp);
                asstnumber = value.getString("asstnumber");
                this.setAsstribute("r_AsstNumber", assGrpId, asstnumber);
                asstShortNumber = value.getString("asstShortNumber");
                this.setAsstribute("r_AsstShortNumber", assGrpId, asstShortNumber);
                assGrpNumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("assGrpNumber"));
                this.setAsstribute("r_assGrpNumber", assGrpId, assGrpNumber);
                asstFull = value.getString("asstFull");
                this.setAsstribute("r_asstFull", assGrpId, asstFull);
                asstFullNumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("asstFullNumber"));
                this.setAsstribute("r_asstFullNumber", assGrpId, asstFullNumber);
                asstheadnumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("asstheadnumber"));
                this.setAsstribute("r_AsstHeadNumber", assGrpId, asstheadnumber);
                asstheadname = value.getString("asstheadname");
                this.setAsstribute("r_AsstHeadName", assGrpId, asstheadname);
                asstname = "";
                String tempasstheadname = this.getStr(asstheadname);
                if (!"".equals(tempasstheadname)) {
                    String[] cutByFs = tempasstheadname.split(";");
                    for (int i = 0; i < cutByFs.length; ++i) {
                        String[] cutByMs = cutByFs[i].split(":");
                        if (cutByMs.length < 2) continue;
                        asstname = asstname + cutByMs[1] + ";";
                    }
                }
                asstname = asstname.substring(0, asstname.length() > 0 ? asstname.length() - 1 : 0);
                this.setAsstribute("r_AsstName", assGrpId, asstname);
                asstlevelname = value.getString("asstlevelname");
                this.setAsstribute("r_AsstLevelName", assGrpId, asstlevelname);
                asstLevelNameNumber = this.processGL_064(asstnumber, asstShortNumber, value.getString("asstLevelNameNumber"));
                this.setAsstribute("r_AsstLevelNameNumber", assGrpId, asstLevelNameNumber);
                levelName = this.settingInfo.isShowAsstFullName() ? asstLevelNameNumber : asstlevelname;
                if (this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                    fullName = asstFullNumber;
                    name = this.getNameAndAssGrpNumber(asstheadname, asstnumber, asstlevelname);
                } else if (this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                    name = fullName = asstFull;
                } else if (!this.settingInfo.isShowAsstFullName() && !this.settingInfo.isShowAsstNumber()) {
                    name = fullName = assGrp;
                } else if (!this.settingInfo.isShowAsstFullName() && this.settingInfo.isShowAsstNumber()) {
                    fullName = assGrpNumber;
                    name = this.getNameAndAssGrpNumber(asstheadname, asstnumber, asstname);
                }
            }
            if (this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName()) {
                acctname = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
            } else if (!this.settingInfo.isShowAccountNumber() && this.settingInfo.isShowAccountFullName()) {
                acctname = GlUtils.getLongName((IObjectValue)e, "account");
            } else if (this.settingInfo.isShowAccountNumber() && !this.settingInfo.isShowAccountFullName()) {
                acctname = GlUtils.getNumberAndName((IObjectValue)e, "account");
            } else {
                zc_listacctname = GlUtils.getName((IObjectValue)e, "account");
            }
            String acctnameZC = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
            zc_listacctname = !this.settingInfo.isShowAccountNumber() && !this.settingInfo.isShowAccountFullName() ? (acctnameZC.indexOf("_", 0) != -1 ? acctnameZC.substring(acctnameZC.indexOf("_", 0) + 1, acctnameZC.length()) : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 1, acctnameZC.length())) : acctname;
        } else {
            String acctnameZC = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
            zc_listacctname = acctnameZC.indexOf("_", 0) != -1 ? acctnameZC.substring(acctnameZC.indexOf("_", 0) + 1, acctnameZC.length()) : acctnameZC.substring(acctnameZC.indexOf("-", 0) + 1, acctnameZC.length());
        }
        String accountNumber = GlUtils.getNumber((IObjectValue)e, "account");
        if (fullName == null || "null".equals(fullName)) {
            name = fullName = "";
        }
        String name_refactory = this.getStr(name);
        String fullName_refactory = "";
        if (fullName != null && !"null".equals(fullName) && fullName.length() > 0 && this.getStr(fullName) != null && this.getStr(fullName).length() > 0) {
            fullName_refactory = "(" + this.getStr(fullName) + ")";
        }
        if (!this.settingInfo.isNotPrintSelectedAccountAsst()) {
            rs.updateString("r_assGrp", name_refactory);
            rs.updateString("r_longName", this.getStr(fullName));
            rs.updateString("r_AsstHeadNumber", asstheadnumber);
            rs.updateString("r_AsstNumber", this.generalAsstShowLongNumber ? asstnumber : asstShortNumber);
            rs.updateString("r_AsstHeadName", asstheadname);
            rs.updateString("r_AsstName", asstname);
            rs.updateString("r_AsstLevelName", levelName);
            rs.updateString("r_accountAsst", acctname + "" + fullName_refactory + "");
            rs.updateString("zc_assGrp", zc_listacctname + "" + fullName_refactory + "");
            rs.updateString("r_accountAsstPrimItem", acctname + "" + fullName_refactory + "");
        } else if (this.settingInfo.isNotPrintSelectedAccountAsst() && !this.balanceAccountIsInExistence(accountNumber)) {
            rs.updateString("r_assGrp", name_refactory);
            rs.updateString("r_longName", fullName_refactory);
            rs.updateString("r_AsstHeadNumber", asstheadnumber);
            rs.updateString("r_AsstNumber", this.generalAsstShowLongNumber ? asstnumber : asstShortNumber);
            rs.updateString("r_AsstHeadName", asstheadname);
            rs.updateString("r_AsstName", asstname);
            rs.updateString("r_AsstLevelName", levelName);
            rs.updateString("r_accountAsst", acctname + "" + fullName_refactory + "");
            rs.updateString("zc_assGrp", zc_listacctname + "" + this.getStr(fullName) + "");
            rs.updateString("r_accountAsstPrimItem", acctname + "" + fullName_refactory + "");
        } else {
            rs.updateString("r_assGrp", "");
            rs.updateString("r_longName", "");
            rs.updateString("r_AsstHeadNumber", "");
            rs.updateString("r_AsstNumber", "");
            rs.updateString("r_AsstHeadName", "");
            rs.updateString("r_AsstName", "");
            rs.updateString("r_AsstLevelName", "");
            rs.updateString("r_accountAsst", "");
            rs.updateString("r_accountAsstPrimItem", "");
            rs.updateString("zc_assGrp", "");
            rs.updateString("r_description", e.getDescription());
        }
    }

    private String getNameAndAssGrpNumber(String asstheadname, String asstnumber, String asstname) {
        String[] asstheadnameArr = asstheadname.split(";");
        String[] asstnumberArr = asstnumber.split(";");
        String[] asstnameArr = asstname.split(";");
        int asstSize = asstheadnameArr.length;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < asstSize; ++i) {
            String[] split = asstheadnameArr[i].split(":");
            sb.append(split[0]).append(":").append(asstnumberArr[i]).append("_").append(asstnameArr[i]);
            if (i == asstSize - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    protected void printCashflow(DynamicRowSet drs, VoucherEntryInfo e, VoucherAssistRecordInfo r, int lcpre) throws Exception {
        StringBuffer sbOriginalAmount = new StringBuffer();
        StringBuffer sblocalAmount = new StringBuffer();
        StringBuffer sbreportingAmount = new StringBuffer();
        StringBuilder sbPrimItem = new StringBuilder();
        StringBuilder sbPrimItemName = new StringBuilder();
        StringBuilder sbItem = new StringBuilder();
        StringBuilder sbItemBb = new StringBuilder();
        StringBuilder sbAssistName = new StringBuilder();
        StringBuilder sbAssistNumber = new StringBuilder();
        StringBuilder sbAssistLongName = new StringBuilder();
        StringBuilder sbCashFlowAndAssistGroupName = new StringBuilder();
        StringBuilder sbAssistDisplayNameGroup = new StringBuilder();
        StringBuffer sbsuppItem = new StringBuffer();
        StringBuffer sbsupp = new StringBuffer();
        StringBuffer sbsuppEbb = new StringBuffer();
        StringBuffer sbfullInfoItem = new StringBuffer();
        StringBuffer sbfullInfo = new StringBuffer();
        StringBuffer sbfullInfoEbb = new StringBuffer();
        BigDecimal bdPrimary = null;
        BigDecimal bdSupp = null;
        CashflowRecordCollection cashflowRecordsCollection = null;
        int seq = e.getSeq();
        cashflowRecordsCollection = this.settingInfo.isPrintCashflowMeOrOther() ? e.getCashflowEntry() : e.getCashflowRecords();
        if (cashflowRecordsCollection != null && cashflowRecordsCollection.size() > 0) {
            for (CashflowRecordInfo cfrInfo : cashflowRecordsCollection) {
                CashFlowItemInfo cfInfo_fullInfoItem;
                CashFlowItemInfo cfinfo_suppItem;
                if (cfrInfo.getItemFlag() == null || cfrInfo.getItemFlag().getValue() == 5 || (this.settingInfo.isPrintCashflowMeOrOther() ? seq != cfrInfo.getEntry().getSeq() : seq != cfrInfo.getOpposingAccountEntry().getSeq() || r != null && (cfrInfo.getItemFlag().getValue() == 1 || cfrInfo.getItemFlag().getValue() == 2 || cfrInfo.getItemFlag().getValue() == 3) && cfrInfo.getOppVoucherAssistRecord() != null && r.getSeq() != cfrInfo.getOppVoucherAssistRecord().getSeq())) continue;
                bdPrimary = new BigDecimal(String.valueOf(cfrInfo.getPrimaryCoefficient()));
                bdSupp = new BigDecimal(String.valueOf(cfrInfo.getSupplementaryCoefficient()));
                sbOriginalAmount.append(GlUtils.formatNumber(cfrInfo.getOriginalAmount(), lcpre) + ";");
                sblocalAmount.append(GlUtils.formatNumber(bdPrimary.compareTo(GlUtils.zero) == 0 ? cfrInfo.getLocalAmount() : cfrInfo.getLocalAmount().multiply(bdPrimary), lcpre) + ";");
                sbreportingAmount.append(GlUtils.formatNumber(bdPrimary.compareTo(GlUtils.zero) == 0 ? cfrInfo.getReportingAmount() : cfrInfo.getReportingAmount().multiply(bdPrimary), lcpre) + ";");
                drs.updateString("c_originalAmount", sbOriginalAmount.toString());
                drs.updateString("c_localAmount", sblocalAmount.toString());
                drs.updateString("c_reportingAmount", sbreportingAmount.toString());
                CashFlowItemInfo cfInfoPrimItem = cfrInfo.getPrimaryItem();
                if (cfInfoPrimItem != null) {
                    String str_primItem_number = cfInfoPrimItem.getNumber();
                    String str_primItem_name = cfInfoPrimItem.getName();
                    this.stringBuilderAppendWithEnter(sbPrimItem, str_primItem_number + str_primItem_name);
                    this.stringBuilderAppendWithEnter(sbPrimItemName, str_primItem_name);
                    this.stringBuilderAppendWithEnter(sbItem, cfInfoPrimItem + GlUtils.formatNumber(cfrInfo.getLocalAmount().multiply(bdPrimary), lcpre));
                    this.stringBuilderAppendWithEnter(sbItemBb, "(" + str_primItem_name + ")" + GlUtils.formatNumber(cfrInfo.getLocalAmount().multiply(bdPrimary), lcpre));
                    drs.updateString("c_primItem", sbPrimItem.toString());
                    drs.updateString("c_item", sbItem.toString());
                    drs.updateString("c_itemEbb", sbItemBb.toString());
                    drs.updateString("c_primItemName", sbPrimItemName.toString());
                    drs.updateString("r_accountAsstPrimItem", drs.getString("r_accountAsstPrimItem") + " " + str_primItem_name);
                    ICashflowRecord recCtrl = CashflowRecordFactory.getRemoteInstance();
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("assGrp.id"));
                    CashflowRecordInfo info = cfrInfo;
                    if (info.getAssGrp() != null && this.settingInfo.isPrintAssistant()) {
                        StringBuilder displayNameGp;
                        String[] str;
                        String[] names;
                        selector.clear();
                        selector.add(new SelectorItemInfo("longNameGroup"));
                        selector.add(new SelectorItemInfo("disPlayNameGroup"));
                        selector.add(new SelectorItemInfo("numberGroup"));
                        AssistantHGInfo assistantHGInfo = AssistantHGFactory.getRemoteInstance().getAssistantHGInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getAssGrp().get("id").toString())), selector);
                        StringBuilder name = new StringBuilder();
                        String assistLongName = assistantHGInfo.getLongNameGroup();
                        String assistDisplayName = assistantHGInfo.getDisplayNameGroup();
                        if (StringUtils.isEmpty((String)assistLongName)) {
                            names = null;
                            drs.updateString("c_asstactName", null);
                        } else {
                            for (String s : names = assistLongName.split(";")) {
                                str = s.split(":");
                                name.append(str.length > 1 ? s.split(":")[1] : "").append(";");
                            }
                            this.stringBuilderAppendWithEnter(sbAssistName, name.toString().substring(0, name.toString().length() - 1));
                            drs.updateString("c_asstactName", sbAssistName.toString());
                        }
                        if (!this.settingInfo.isShowAsstFullName()) {
                            displayNameGp = new StringBuilder();
                            String[] cut_DisplayNameGroup = assistDisplayName.split(";");
                            for (int i = 0; i < cut_DisplayNameGroup.length; ++i) {
                                String[] rem_cut_DisplayNameGroup = cut_DisplayNameGroup[i].split("!");
                                if (names == null) continue;
                                str = names[i].split(":");
                                displayNameGp.append(rem_cut_DisplayNameGroup[0]).append("!").append(str.length > 1 ? names[i].split(":")[1] : "").append(";");
                            }
                            assistDisplayName = displayNameGp.toString();
                        }
                        if (!this.settingInfo.isShowAsstNumber()) {
                            String[] cut_DisplayNameGroup;
                            displayNameGp = new StringBuilder();
                            for (String s : cut_DisplayNameGroup = assistDisplayName.split(";")) {
                                String[] rem_cut_DisplayNameGroup = s.split("!");
                                displayNameGp.append(rem_cut_DisplayNameGroup[0].split(":")[0]).append(":");
                                displayNameGp.append(rem_cut_DisplayNameGroup[1]).append(";");
                            }
                            assistDisplayName = displayNameGp.toString();
                        }
                        if (this.settingInfo.isShowAsstNumber()) {
                            String[] numberGroup;
                            StringBuilder number = new StringBuilder();
                            for (String s : numberGroup = assistantHGInfo.getNumberGroup().split(";")) {
                                String[] numbers = s.split(":");
                                String[] str2 = numbers[1].split("_!");
                                number.append(str2.length > 0 ? numbers[1].split("_!")[0] : "").append(";");
                            }
                            this.stringBuilderAppendWithEnter(sbAssistNumber, number.toString().substring(0, number.toString().length() - 1));
                            drs.updateString("c_asstactNumber", sbAssistNumber.toString());
                        } else {
                            drs.updateString("c_asstactNumber", "");
                        }
                        this.stringBuilderAppendWithEnter(sbAssistLongName, assistLongName);
                        drs.updateString("c_asstactLongGroupName", sbAssistLongName.toString());
                        String displayNameGroupAfterReplace = assistDisplayName.replaceAll("!", "");
                        this.stringBuilderAppendWithEnter(sbAssistDisplayNameGroup, cfInfoPrimItem.getName() + "(" + displayNameGroupAfterReplace.substring(0, displayNameGroupAfterReplace.length() - 1) + ")");
                        drs.updateString("c_asstactDisplayNameGroup", sbAssistDisplayNameGroup.toString());
                        this.stringBuilderAppendWithEnter(sbCashFlowAndAssistGroupName, cfInfoPrimItem.getName() + "(" + assistantHGInfo.getLongNameGroup().substring(0, assistantHGInfo.getLongNameGroup().length() - 1) + ")");
                        drs.updateString("c_cashFlowAndAsstactGoupName", sbCashFlowAndAssistGroupName.toString());
                    } else {
                        this.stringBuilderAppendWithEnter(sbCashFlowAndAssistGroupName, cfInfoPrimItem.getName());
                        drs.updateString("c_cashFlowAndAsstactGoupName", sbCashFlowAndAssistGroupName.toString());
                        this.stringBuilderAppendWithEnter(sbAssistDisplayNameGroup, cfInfoPrimItem.getName());
                        drs.updateString("c_asstactDisplayNameGroup", sbAssistDisplayNameGroup.toString());
                    }
                }
                if ((cfinfo_suppItem = cfrInfo.getSupplementaryItem()) != null) {
                    String str_suppItem_number = cfinfo_suppItem.getNumber();
                    String str_suppItem_name = cfinfo_suppItem.getName();
                    sbsuppItem.append(str_suppItem_number + str_suppItem_name + ";");
                    sbsupp.append(cfinfo_suppItem + GlUtils.formatNumber(cfrInfo.getLocalAmount().multiply(bdSupp), lcpre) + ";");
                    sbsuppEbb.append("(" + str_suppItem_name + ")" + GlUtils.formatNumber(cfrInfo.getLocalAmount().multiply(bdSupp), lcpre) + ";");
                    drs.updateString("c_suppItem", sbsuppItem.toString());
                    drs.updateString("c_supp", sbsupp.toString());
                    drs.updateString("c_suppEbb", sbsuppEbb.toString());
                    drs.updateString("c_suppItemName", str_suppItem_name + ";");
                }
                if ((cfInfo_fullInfoItem = cfrInfo.getFullInfoItem()) == null) continue;
                String str_fullInfoItem_number = cfInfo_fullInfoItem.getNumber();
                String str_fullInfoItem_name = cfInfo_fullInfoItem.getName();
                sbfullInfoItem.append(str_fullInfoItem_number + str_fullInfoItem_name + ";");
                sbfullInfo.append(str_fullInfoItem_number + str_fullInfoItem_name + GlUtils.formatNumber(cfrInfo.getLocalAmount(), lcpre) + ";");
                sbfullInfoEbb.append("(" + str_fullInfoItem_name + ")" + GlUtils.formatNumber(cfrInfo.getLocalAmount(), lcpre) + ";");
                drs.updateString("c_fullInfoItem", sbfullInfoItem.toString());
                drs.updateString("c_fullInfo", sbfullInfo.toString());
                drs.updateString("c_fullInfoEbb", sbfullInfoEbb.toString());
            }
        }
    }

    private void stringBuilderAppendWithEnter(StringBuilder stringBuilder, CharSequence charSequence) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append(charSequence);
    }

    private String getAsstribute(String asstribute, String id) {
        Map<String, String> map = null;
        String name = null;
        if (this.asstributeMap == null) {
            this.asstributeMap = new HashMap();
        }
        if (this.asstributeMap.containsKey(asstribute)) {
            map = (Map)this.asstributeMap.get(asstribute);
        } else {
            map = new HashMap();
            this.asstributeMap.put(asstribute, map);
        }
        if (map.containsKey(id)) {
            name = (String)map.get(id);
            map.put(id, name);
        }
        return name;
    }

    private void setAsstribute(String asstribute, String id, String value) {
        Map<String, String> map = null;
        if (this.asstributeMap == null) {
            this.asstributeMap = new HashMap();
        }
        if (this.asstributeMap.containsKey(asstribute)) {
            map = (Map)this.asstributeMap.get(asstribute);
        } else {
            map = new HashMap();
            this.asstributeMap.put(asstribute, map);
        }
        if (!map.containsKey(id)) {
            map.put(id, value);
        }
    }

    private IObjectValue getAsstValue(String assGrpId, IAssistantHG assistantHG, IBaseVoucherAssistRecord asstre) throws EASBizException, BOSException {
        if (assistantHG == null) {
            assistantHG = AssistantHGFactory.getRemoteInstance();
        }
        ObjectUuidPK objectUUidPK = new ObjectUuidPK(assGrpId);
        AssistantHGInfo info = assistantHG.getAssistantHGInfo((IObjectPK)objectUUidPK);
        if (asstre == null) {
            asstre = VoucherAssistRecordFactory.getRemoteInstance();
        }
        IObjectValue value = asstre.getDefaultAssitInfo(info.getAsstAccount().getId().toString(), assGrpId.toString());
        return value;
    }

    private String processGL_064(String asstnumber, String asstShortNumber, String toProcess) {
        if (this.generalAsstShowLongNumber || asstnumber == null || asstShortNumber == null || toProcess == null || asstnumber.equals(asstShortNumber)) {
            return toProcess;
        }
        String[] longNumber = asstnumber.split(";");
        String[] shortNumber = asstShortNumber.split(";");
        String[] process = toProcess.split(";");
        StringBuffer newStr = new StringBuffer();
        int j = process.length;
        for (int i = 0; i < j; ++i) {
            newStr.append(process[i].replace(longNumber[i], shortNumber[i]));
            newStr.append(";");
        }
        return newStr.toString();
    }

    private String getStr(String name) {
        String string = "";
        String[] names = null;
        if (name != null) {
            names = StringUtils.split((String)name, (String)";");
            String[] asstActList = this.getAsstActList();
            if (asstActList != null) {
                for (int i = 0; i < names.length; ++i) {
                    String s = names[i];
                    if (StringUtils.isEmpty((String)s)) continue;
                    String[] temp = s.split(":");
                    for (int j = 0; j < asstActList.length; ++j) {
                        String asst = asstActList[j];
                        if (StringUtils.isEmpty((String)asst) || temp[0].toString().indexOf(asst.split("-")[1].toString()) == -1) continue;
                        names[i] = "";
                    }
                }
            }
        }
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null || names[i].length() == 0) continue;
                if (string.length() > 0 && !")".equals(names[i]) && !"(".equals(names[i])) {
                    string = string + ";";
                }
                string = string + names[i];
            }
        }
        if (string.indexOf("(") != -1 && string.indexOf(")") != -1) {
            return string;
        }
        if (string.indexOf(")") != -1 && string.indexOf(")") != 0 && string.indexOf("(") == -1) {
            string = "(" + string;
        } else if (string.indexOf(")") == 0) {
            string = "";
        }
        return string;
    }

    private String[] getAsstActList() {
        if (this.settingInfo.isNotPrintSelectedAss()) {
            String[] asstActList = StringUtils.split((String)this.settingInfo.getSeleectedAsstList(), (String)",");
            return asstActList;
        }
        return null;
    }

    private boolean balanceAccountIsInExistence(String strAccountNumber) throws Exception {
        boolean isInExistence = false;
        if (this.settingInfo.getSelectedAccountList().length() != 0) {
            String[] objToSelect = this.settingInfo.getSelectedAccountList().split("\\,");
            Object[] objSelectNumber = new Object[objToSelect.length];
            int n = objToSelect.length;
            for (int i = 0; i < n; ++i) {
                String[] objTemp = objToSelect[i].toString().split("\\ ");
                objSelectNumber[i] = objTemp[0];
            }
            int m = objSelectNumber.length;
            for (int j = 0; j < m; ++j) {
                if (!strAccountNumber.equalsIgnoreCase(objSelectNumber[j].toString())) continue;
                isInExistence = true;
            }
            return isInExistence;
        }
        return isInExistence;
    }

    public void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    public boolean isAstQty() {
        return this.isAstQty;
    }

    public void initGLMap(String companyId) throws EASBizException, BOSException {
        Object pre;
        if (this.mapPrecision == null) {
            this.mapPrecision = new HashMap();
        }
        if ((pre = this.mapPrecision.get(companyId)) != null) {
            String[] pres = ((String)pre).split(":");
            this.qtyPre = Integer.valueOf(pres[0]);
            this.pricePre = Integer.valueOf(pres[1]);
            if (this.mapPrecision.get(companyId + "GL_064") != null) {
                this.generalAsstShowLongNumber = Boolean.valueOf(this.mapPrecision.get(companyId + "GL_064").toString());
            }
            if (this.mapPrecision.get(companyId + "GL_111") != null) {
                this.commonVoucherProcess = Boolean.valueOf(this.mapPrecision.get(companyId + "GL_111").toString());
            }
        } else {
            HashMap<String, String> hmParamIn = new HashMap<String, String>();
            hmParamIn.put("GL_002", companyId);
            hmParamIn.put("GL_003", companyId);
            hmParamIn.put("GL_064", companyId);
            hmParamIn.put("GL_111", companyId);
            HashMap params = ParamControlFactory.getRemoteInstance().getParamHashMap(hmParamIn);
            this.qtyPre = Integer.parseInt(params.get("GL_002").toString());
            this.pricePre = Integer.parseInt(params.get("GL_003").toString());
            this.mapPrecision.put(companyId, this.qtyPre + ":" + this.pricePre);
            this.mapPrecision.put(companyId + "GL_064", params.get("GL_064").toString());
            this.mapPrecision.put(companyId + "GL_111", params.get("GL_111").toString());
            this.commonVoucherProcess = Boolean.valueOf(params.get("GL_111").toString());
        }
    }

    private String getSourceTypeString(SourceType item) {
        if (item == null) {
            return "";
        }
        String key = "SourceType." + item.getValue();
        if (this.enumStr.containsKey(key)) {
            return this.enumStr.get(key);
        }
        String str = item.toString();
        this.enumStr.put(key, str);
        return str;
    }

    private String getSourceSysString(SystemEnum item) {
        if (item == null) {
            return "";
        }
        String key = "SourceSys." + item.getValue();
        if (this.enumStr.containsKey(key)) {
            return this.enumStr.get(key);
        }
        String str = item.toString();
        this.enumStr.put(key, str);
        return str;
    }
}

