/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.util.backport.concurrent.ExecutorService;
import com.kingdee.bos.util.backport.concurrent.Executors;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.EventModelParserExcel;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.VoucherExpImpException;
import com.kingdee.eas.fi.gl.VoucherIMPColInfo;
import com.kingdee.eas.fi.gl.VoucherIOSparser;
import com.kingdee.eas.fi.gl.VoucherImpExpParam;
import com.kingdee.eas.fi.gl.VoucherImportUtils;
import com.kingdee.eas.fi.gl.VoucherXLSCols;
import com.kingdee.eas.fi.gl.VoucherXLSXSparser;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.ss.usermodel.DateUtil;
import org.xml.sax.SAXException;

public class VoucherXLSXParserByEventModel
extends EventModelParserExcel {
    protected static final Logger logger = Logger.getLogger(VoucherXLSXParserByEventModel.class);
    VoucherXLSXSparser voucehrXlsParser;
    VoucherImpExpParam filterParam;
    Date begin;
    Date end;
    boolean isPost;
    boolean isNoPost;
    boolean isChkHalfInivableSaveVoucher;
    boolean isMulTiCompany;
    boolean commonVoucherProcess;
    VoucherXLSCols cols;
    boolean isSupAsstUnit;
    boolean xlsxHasProfitCenter;
    boolean xlsxHasAsstQtyAndUnit;
    boolean extraData;
    Map<String, String> sheetRids = new HashMap<String, String>();
    public String taskName;
    public static final int waitTime = 2;
    public static final int dequeSize = 1000;
    public LinkedBlockingDeque<RowInfo> rowInfoDeque = new LinkedBlockingDeque(1000);
    private ExecutorService threadService = Executors.newSingleThreadExecutor();
    public LinkedBlockingDeque<Object[]> vchNumberDeque = new LinkedBlockingDeque(1000);
    public LinkedBlockingDeque<Object[]> theFirstRowDeque = new LinkedBlockingDeque(1);

    public VoucherXLSXParserByEventModel(VoucherXLSXSparser voucehrXlsParser, VoucherImpExpParam filterParam, String fileName, boolean isCheck, String taskName) throws IOException, SAXException, OpenXML4JException, EASBizException, BOSException {
        super(fileName, isCheck);
        this.voucehrXlsParser = voucehrXlsParser;
        this.filterParam = filterParam;
        this.taskName = taskName;
        this.sheetRids = this.getAllSheetInfo();
        this.init();
    }

    public VoucherXLSXParserByEventModel(String fileName, boolean isCheck, boolean extraData, String taskName) {
        super(fileName, isCheck);
        this.taskName = taskName;
        this.extraData = extraData;
        this.sheetRids = this.getAllSheetInfo();
    }

    public void init() throws EASBizException, BOSException {
        this.begin = this.filterParam.getDateBegin();
        this.end = this.filterParam.getDateEnd();
        this.isPost = this.filterParam.isIncludePost();
        this.isNoPost = this.filterParam.isIncludeNoPost();
        this.isChkHalfInivableSaveVoucher = this.filterParam.isChkHalfInviableSaveVoucher();
        this.isMulTiCompany = false;
        this.commonVoucherProcess = VoucherIOSparser.getGL_111();
        this.isSupAsstUnit = VoucherIOSparser.getGL_098();
    }

    @Override
    protected void outputRow(Object[] datas, int[] cellTypes, int rowNum) {
        try {
            boolean flag;
            String queName = "";
            if (this.extraData) {
                flag = this.vchNumberDeque.offer(datas, 2L, TimeUnit.SECONDS);
                queName = "vchNumberDeque";
            } else {
                flag = this.rowInfoDeque.offer(new RowInfo(datas, cellTypes, rowNum), 2L, TimeUnit.SECONDS);
                queName = "rowInfoDeque";
            }
            if (!flag) {
                logger.info((Object)("the rownum:" + rowNum + " put '" + queName + "' fail,deque is full."));
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"EventModelParserExcel rowInfoDeque thread interrupt excepton", (Throwable)e);
        }
    }

    @Override
    protected void outputTheFirstRow(Object[] datas, int[] rowTypes, int rowNum) {
        if (rowNum == 1) {
            this.theFirstRowDeque.add(datas);
        }
    }

    public void checkTheFirstRow() throws VoucherExpImpException {
        logger.info((Object)"Check file ...");
        String voucherSheetRid = this.sheetRids.get("1");
        if (voucherSheetRid == null) {
            logger.info((Object)"excel no voucher data");
            throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
        }
        this.threadService.submit((Runnable)new VoucherXLSXParserCallable(this, voucherSheetRid));
        Object[] datas = null;
        try {
            while ((datas = this.theFirstRowDeque.pollFirst(2L, TimeUnit.SECONDS)) != null) {
                if (datas.length == 0 || datas.length < 55) {
                    throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
                }
                for (int i = 0; i < 55; i = (int)((short)(i + 1))) {
                    Object cell = datas[i];
                    if (cell != null) continue;
                    throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
                }
                if (this.theFirstRowDeque.size() != 0) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.threadService.shutdownNow();
        }
        if (datas == null) {
            throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
        }
        logger.info((Object)"Check file end");
    }

    public void setExtraData(KDTextField tfVoucherNumberBegin, KDTextField tfVoucherNumberEnd) throws VoucherExpImpException {
        logger.info((Object)"setExtraData start...");
        String voucherSheetRid = this.sheetRids.get("1");
        if (voucherSheetRid == null) {
            logger.info((Object)"excel no voucher data");
            throw new VoucherExpImpException(VoucherExpImpException.FIEL_NOT_EXIST);
        }
        this.threadService.submit((Runnable)new VoucherXLSXParserCallable(this, voucherSheetRid));
        Object[] datas = null;
        boolean theFirstRow = true;
        String min = null;
        String max = null;
        try {
            while ((datas = this.vchNumberDeque.pollFirst(2L, TimeUnit.SECONDS)) != null) {
                if (theFirstRow) {
                    Object objCol1;
                    try {
                        objCol1 = this.getCellValue(datas, 0, 0, 3);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
                    }
                    this.isMulTiCompany = VoucherImportUtils.isMultiCompany(objCol1.toString());
                    theFirstRow = false;
                } else {
                    String value;
                    if (datas == null || datas.length == 0 || (value = this.isMulTiCompany ? String.valueOf(this.getCellValue(datas, this.rowNum, 5, 3)) : String.valueOf(this.getCellValue(datas, this.rowNum, 4, 3))) == null || value.equalsIgnoreCase("null")) continue;
                    if (min == null || max == null) {
                        min = value;
                        max = value;
                        continue;
                    }
                    if (value.compareTo(min) < 0) {
                        min = value;
                    }
                    if (value.compareTo(max) > 0) {
                        max = value;
                    }
                }
                if (!this.sheetEndFlag || this.vchNumberDeque.size() != 0) continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("setExtraData voucher number is not digit." + e.toString()));
            this.endTask = true;
            return;
        }
        logger.info((Object)"setExtraData end...");
        tfVoucherNumberBegin.setText(min == null ? "" : min);
        tfVoucherNumberEnd.setText(max == null ? "" : max);
    }

    public WSVoucherCollection getVchList() throws Exception {
        String voucherSheetRid = this.sheetRids.get("1");
        if (voucherSheetRid == null) {
            logger.info((Object)"excel no voucher data");
            return null;
        }
        this.threadService.submit((Runnable)new VoucherXLSXParserCallable(this, voucherSheetRid));
        logger.info((Object)"voucherInfo cteate start...");
        WSVoucherCollection wsc = new WSVoucherCollection();
        RowInfo rowInfo = null;
        while ((rowInfo = this.rowInfoDeque.pollFirst(2L, TimeUnit.SECONDS)) != null) {
            if (rowInfo.getRowNum() == 1) {
                this.firstVchRowInfo(rowInfo.getDatas(), rowInfo.getCellTypes(), rowInfo.getRowNum());
            } else {
                WSVoucherInfo wsv = this.getVchInfo(rowInfo.getDatas(), rowInfo.getCellTypes(), rowInfo.getRowNum());
                if (wsv != null) {
                    wsc.add(wsv);
                }
            }
            if (!this.sheetEndFlag || this.rowInfoDeque.size() != 0) continue;
        }
        logger.info((Object)"voucherInfo create end..");
        return wsc;
    }

    public WSVoucherCollection getCashFlowList() throws Exception {
        String cashFlowSheetRid = this.sheetRids.get("2");
        if (cashFlowSheetRid == null) {
            logger.info((Object)"excel no cashFlow data");
            return null;
        }
        this.threadService.submit((Runnable)new VoucherXLSXParserCallable(this, cashFlowSheetRid));
        WSVoucherCollection wsc = new WSVoucherCollection();
        RowInfo rowInfo = null;
        while ((rowInfo = this.rowInfoDeque.pollFirst(2L, TimeUnit.SECONDS)) != null) {
            if (rowInfo.getRowNum() == 1) {
                this.firstCashRowInfo(rowInfo.getDatas(), rowInfo.getCellTypes(), rowInfo.getRowNum());
            } else {
                WSVoucherInfo wsv = this.getCashFlow(rowInfo.getDatas(), rowInfo.getCellTypes(), rowInfo.getRowNum());
                if (wsv != null) {
                    wsc.add(wsv);
                }
            }
            if (!this.sheetEndFlag || this.rowInfoDeque.size() != 0) continue;
            break;
        }
        return wsc;
    }

    private boolean checkCashRowCell(Object[] datas, boolean isMulTiCompany, int row) throws Exception {
        if (datas == null || datas.length == 0) {
            return false;
        }
        boolean isNullRow = true;
        int count = datas.length;
        for (int col = 0; col < count; ++col) {
            if (this.getCellValue(datas, col) == null || this.getCellValue(datas, col).toString().trim().length() == 0) continue;
            isNullRow = false;
            break;
        }
        return !isNullRow;
    }

    public WSVoucherInfo getCashFlow(Object[] datas, int[] cellTypes, int rowNum) throws Exception {
        BigDecimal rptAmount;
        BigDecimal localAmount;
        if (!this.filterParam.isSelectCash()) {
            return null;
        }
        WSVoucherInfo wsvoucher = null;
        if (!this.checkCashRowCell(datas, this.isMulTiCompany, rowNum)) {
            return null;
        }
        wsvoucher = new WSVoucherInfo();
        wsvoucher.put("lineNum", new Integer(rowNum));
        wsvoucher.setItemFlag(1);
        String companyNumber = this.isMulTiCompany ? ((String)this.getCellValue(datas, rowNum, 0, 3)).trim() : this.voucehrXlsParser.getCompany().getNumber();
        wsvoucher.setCompanyNumber(companyNumber);
        java.util.Date voucherDate = this.getCellDate(datas, cellTypes, rowNum, this.cols.getCashBookedDate().getIndex());
        wsvoucher.setBookedDate(voucherDate);
        int periodNum = 0;
        BigDecimal pNumBig = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getCashPeriodNumber());
        if (pNumBig != null) {
            periodNum = pNumBig.intValue();
        }
        wsvoucher.setPeriodNumber(periodNum);
        if (voucherDate != null) {
            wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
        }
        String strVoucherTypeInfoName = (String)this.getCellValue(datas, rowNum, this.cols.getCashVoucherType());
        wsvoucher.setVoucherType(strVoucherTypeInfoName);
        String vouchernumber = (String)this.getCellValue(datas, rowNum, this.cols.getCashVoucherNumber());
        wsvoucher.setVoucherNumber(vouchernumber);
        String strCurrenyISOcode = (String)this.getCellValue(datas, rowNum, this.cols.getCashCurrencyNumber());
        wsvoucher.setCurrencyNumber(strCurrenyISOcode);
        int iSeq = this.getCellIntValue(datas, rowNum, this.cols.getCashEntrySeq());
        wsvoucher.setEntrySeq(iSeq);
        int iOppSeq = this.getCellIntValue(datas, rowNum, this.cols.getCashOppEntrySeq());
        wsvoucher.put("cashOppEntrySeq", iOppSeq);
        String primarynumber = (String)this.getCellValue(datas, rowNum, this.cols.getCashPrimaryCashFlowItem());
        wsvoucher.setPrimaryItem(primarynumber);
        String subnumber = (String)this.getCellValue(datas, rowNum, this.cols.getCashSubCashFlowItem());
        wsvoucher.setSupplyItem(subnumber);
        BigDecimal originalAmount = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getCashOriginalAmount());
        if (originalAmount != null) {
            wsvoucher.setCashflowAmountOriginal(originalAmount.doubleValue());
        }
        if ((localAmount = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getCashLocalAmount())) != null) {
            wsvoucher.setCashflowAmountLocal(localAmount.doubleValue());
        }
        if ((rptAmount = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getCashRptAmount())) != null) {
            wsvoucher.setCashflowAmountRpt(rptAmount.doubleValue());
        }
        int primarycoef = this.getCellIntValue(datas, rowNum, this.cols.getCashPrimaryCoefficient());
        wsvoucher.setPrimaryCoef(primarycoef);
        int supplycoef = this.getCellIntValue(datas, rowNum, this.cols.getCashSupCoefficient());
        wsvoucher.setSupplyCoef(supplycoef);
        String type = (String)this.getCellValue(datas, rowNum, this.cols.getCashType());
        wsvoucher.setType(type);
        int assistCount = 0;
        for (int k = 0; k < 8; ++k) {
            Object obj1 = this.getCellValue(datas, rowNum, this.cols.getCashAsstActTypeX(k));
            Object obj2 = this.getCellValue(datas, rowNum, this.cols.getCashAsstActNumberX(k));
            Object obj3 = this.getCellValue(datas, rowNum, this.cols.getCashAsstActNameX(k));
            if (!(obj1 != null && !"".equals(obj1) || obj2 != null && !"".equals(obj2) || obj3 != null && !"".equals(obj3))) continue;
            String strAsstActTypeName = null;
            if (obj1 != null) {
                strAsstActTypeName = String.valueOf(obj1);
                wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
            }
            String strAsstActID = null;
            if (obj2 != null) {
                if (obj2 instanceof BigDecimal) {
                    strAsstActID = String.valueOf(obj2);
                    if (strAsstActID.indexOf(46) > 0) {
                        strAsstActID = strAsstActID.substring(0, strAsstActID.lastIndexOf(46));
                    }
                } else {
                    strAsstActID = (String)obj2;
                }
                wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
            }
            String strAsstActName = null;
            if (obj3 != null) {
                if (obj3 instanceof BigDecimal) {
                    strAsstActName = String.valueOf(obj3);
                    if (strAsstActName.indexOf(46) > 0) {
                        strAsstActName = strAsstActName.substring(0, strAsstActName.lastIndexOf(46));
                    }
                } else {
                    strAsstActName = (String)obj3;
                }
                wsvoucher.put("asstActName" + assistCount, strAsstActName);
            }
            ++assistCount;
        }
        wsvoucher.put("assistCount", new Integer(assistCount));
        return wsvoucher;
    }

    private void firstVchRowInfo(Object[] datas, int[] rowTypes, int rowNum) throws Exception {
        Object objCol1 = this.getCellValue(datas, 0, VoucherXLSCols.getCompany());
        if (objCol1 != null) {
            this.isMulTiCompany = VoucherImportUtils.isMultiCompany(objCol1.toString());
        }
        int index = 0;
        if (this.commonVoucherProcess) {
            index = 1;
        }
        int next = this.profitCenterNext(datas, this.isMulTiCompany, this.commonVoucherProcess);
        index += next;
        int nextAsst = this.asstQtyAndUnitNext(datas, this.isMulTiCompany, this.isSupAsstUnit);
        this.xlsxHasProfitCenter = this.xlsHasProfitCenter(datas, this.isMulTiCompany);
        this.xlsxHasAsstQtyAndUnit = this.xlsHasAsstQtyAndUnit(datas, this.isMulTiCompany);
        int allCellCount = datas.length;
        VoucherIOSparser.EXP_RES_NAME = this.isSupAsstUnit ? "com.kingdee.eas.fi.gl.VoucherExpWizardByAssistUnitUI" : "com.kingdee.eas.fi.gl.VoucherExpWizardUI";
        this.cols = new VoucherXLSCols(this.isMulTiCompany, this.isSupAsstUnit, this.commonVoucherProcess, next, 0);
    }

    private void firstCashRowInfo(Object[] datas, int[] rowTypes, int rowNum) throws Exception {
        if (rowNum == 1 && (datas == null || datas.length == 0)) {
            throw new VoucherExpImpException(VoucherExpImpException.CASH_NOTITLE);
        }
        Object objCol1 = this.getCellValue(datas, 0, VoucherXLSCols.getCompany());
        this.isMulTiCompany = VoucherImportUtils.isMultiCompany((String)objCol1);
        int next = 0;
        int nextAsst = 0;
        this.cols = new VoucherXLSCols(this.isMulTiCompany, false, this.commonVoucherProcess, next, nextAsst);
    }

    private WSVoucherInfo getVchInfo(Object[] datas, int[] cellTypes, int rowNum) throws Exception, VoucherExpImpException {
        java.util.Date asstBizDate;
        Object objSupplier;
        Object objCompanyOrgUnit;
        Object objMaterial;
        Object objHandler;
        Object objFeeType;
        Object objCustomer;
        Object strTicketNumber;
        BigDecimal cAmount;
        BigDecimal dAmount;
        BigDecimal price;
        BigDecimal qty;
        BigDecimal quantity;
        WSVoucherInfo wsvoucher = null;
        if (!this.checkRowCell(datas, this.isMulTiCompany, rowNum)) {
            return null;
        }
        boolean posted = false;
        VoucherIMPColInfo col = this.cols.getPosted();
        Object obj = this.getCellValue(datas, rowNum, col.getIndex(), 1);
        if (obj instanceof String) {
            if (obj != null) {
                posted = Boolean.valueOf((String)obj);
            }
        } else {
            Boolean postedB = (Boolean)this.getCellValue(datas, rowNum, col);
            if (postedB != null) {
                posted = postedB;
            }
        }
        if (this.isPost && !this.isNoPost && !posted || !this.isPost && this.isNoPost && posted) {
            return null;
        }
        wsvoucher = new WSVoucherInfo();
        wsvoucher.put("lineNum", new Integer(rowNum));
        String companyNumber = this.isMulTiCompany ? ((String)this.getCellValue(datas, rowNum, 0, 3)).trim() : this.voucehrXlsParser.getCompany().getNumber();
        wsvoucher.setCompanyNumber(companyNumber);
        java.util.Date voucherDate = this.getCellDate(datas, cellTypes, rowNum, this.cols.getBookedDate().getIndex());
        wsvoucher.setBookedDate(voucherDate);
        if (voucherDate != null && (voucherDate.before(this.begin) || voucherDate.after(this.end))) {
            return null;
        }
        java.util.Date bizDate = this.getCellDate(datas, cellTypes, rowNum, this.cols.getBizDate().getIndex());
        if (bizDate == null && this.isChkHalfInivableSaveVoucher) {
            bizDate = voucherDate;
        }
        wsvoucher.setBizDate(bizDate);
        int periodNum = 0;
        BigDecimal pNumBig = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getPeriodNumber());
        if (pNumBig != null) {
            periodNum = pNumBig.intValue();
        }
        wsvoucher.setPeriodNumber(periodNum);
        CompanyOrgUnitInfo companyOrgUnitInfo = this.voucehrXlsParser.getCompany();
        PeriodInfo periodInfo = null;
        try {
            periodInfo = GlWebServiceUtil.fetchPeriod(companyOrgUnitInfo.getAccountPeriodType().getId().toString(), wsvoucher.getBookedDate()).get(0);
        }
        catch (Exception e) {
            periodInfo = null;
        }
        if (periodInfo != null) {
            wsvoucher.setPeriodYear(periodInfo.getPeriodYear());
        } else if (voucherDate != null) {
            wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
        } else if (bizDate != null) {
            wsvoucher.setPeriodYear(bizDate.getYear() + 1900);
        }
        String strVoucherTypeInfoName = (String)this.getCellValue(datas, rowNum, this.cols.getVoucherType());
        wsvoucher.setVoucherType(strVoucherTypeInfoName);
        String vouchernumber = (String)this.getCellValue(datas, rowNum, this.cols.getVoucherNumber());
        wsvoucher.setVoucherNumber(vouchernumber);
        String numberBegin = this.filterParam.getINumberBegin();
        String numberEnd = this.filterParam.getINumberEnd();
        VoucherTypeInfo filteVoucherTypeInfo = this.filterParam.getVoucherTypeInfo();
        if (numberBegin != null && numberBegin.trim().length() > 0 || numberEnd != null && numberEnd.trim().length() > 0) {
            if (filteVoucherTypeInfo != null && !strVoucherTypeInfoName.equals(filteVoucherTypeInfo.getName())) {
                return null;
            }
            if (numberBegin != null && numberBegin.trim().length() > 0 && vouchernumber != null && vouchernumber.compareTo(numberBegin.trim()) < 0) {
                return null;
            }
            if (numberEnd != null && numberEnd.trim().length() > 0 && vouchernumber != null && vouchernumber.compareTo(numberEnd.trim()) > 0) {
                return null;
            }
        }
        if (filteVoucherTypeInfo != null && !strVoucherTypeInfoName.equals(filteVoucherTypeInfo.getName())) {
            return null;
        }
        int iSeq = this.getCellIntValue(datas, rowNum, this.cols.getEntrySeq());
        wsvoucher.setEntrySeq(iSeq);
        String voucherAbstract = (String)this.getCellValue(datas, rowNum, this.cols.getVoucherAbstract());
        wsvoucher.setVoucherAbstract(voucherAbstract);
        if (this.commonVoucherProcess && this.xlsxHasProfitCenter) {
            String profitCenterNumber = (String)this.getCellValue(datas, rowNum, this.cols.getProfitCenterNumber());
            wsvoucher.setProfitCenterNumber(profitCenterNumber);
        }
        String strAccountView = null;
        obj = this.getCellValue(datas, rowNum, this.cols.getAccountNumber());
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                strAccountView = String.valueOf(obj);
                if (strAccountView.indexOf(46) > 0) {
                    strAccountView = strAccountView.substring(0, strAccountView.lastIndexOf(46));
                }
            } else {
                strAccountView = String.valueOf(obj);
            }
        }
        wsvoucher.setAccountNumber(strAccountView);
        String strCurrenyISOcode = (String)this.getCellValue(datas, rowNum, this.cols.getCurrencyNumber());
        wsvoucher.setCurrencyNumber(strCurrenyISOcode);
        BigDecimal exchangeRate = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getLocalRate());
        if (exchangeRate != null) {
            exchangeRate = exchangeRate.setScale(10, 4);
            wsvoucher.setLocalRate(exchangeRate.doubleValue());
        }
        int asstDC = this.getCellIntValue(datas, rowNum, this.cols.getEntryDC());
        wsvoucher.setEntryDC(asstDC);
        BigDecimal originalAmount = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getOriginalAmount());
        if (originalAmount != null) {
            wsvoucher.setOriginalAmount(originalAmount.doubleValue());
        }
        if ((quantity = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getQty())) != null) {
            wsvoucher.setQty(quantity.doubleValue());
        } else {
            wsvoucher.setQty(GlUtils.zero.doubleValue());
        }
        if (this.isSupAsstUnit && this.xlsxHasAsstQtyAndUnit && (qty = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getAsstQty())) != null) {
            wsvoucher.put("assistQty", qty);
        }
        if ((price = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getPrice())) != null) {
            wsvoucher.setPrice(price.doubleValue());
        }
        if ((dAmount = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getDebitAmount())) != null) {
            wsvoucher.setDebitAmount(dAmount.doubleValue());
        }
        if ((cAmount = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getCreditAmount())) != null) {
            wsvoucher.setCreditAmount(cAmount.doubleValue());
        }
        String strCreator = (String)this.getCellValue(datas, rowNum, this.cols.getCreator());
        wsvoucher.setCreator(strCreator);
        String strPoster = (String)this.getCellValue(datas, rowNum, this.cols.getPoster());
        wsvoucher.put("poster", strPoster);
        String strAuditer = (String)this.getCellValue(datas, rowNum, this.cols.getAuditer());
        wsvoucher.put("auditer", strAuditer);
        int iAttachments = 0;
        BigDecimal attachBig = (BigDecimal)this.getCellValue(datas, rowNum, this.cols.getAttaches());
        if (attachBig != null && attachBig.intValue() > 0) {
            iAttachments = attachBig.intValue();
        }
        wsvoucher.setAttaches(iAttachments);
        String strModle = (String)this.getCellValue(datas, rowNum, this.cols.getModule());
        wsvoucher.put("module", strModle);
        wsvoucher.put("deleted", null);
        String strVno = (String)this.getCellValue(datas, rowNum, this.cols.getPingzhengxuhao());
        wsvoucher.put("pingzhengxuhao", strVno);
        String strUnitName = (String)this.getCellValue(datas, rowNum, this.cols.getMeasurement());
        wsvoucher.setMeasurement(strUnitName);
        if (this.isSupAsstUnit && this.xlsxHasAsstQtyAndUnit) {
            String strAssistUnitName = (String)this.getCellValue(datas, rowNum, this.cols.getAssistUnit());
            wsvoucher.put("assistUnit", strAssistUnitName);
        }
        String description = (String)this.getCellValue(datas, rowNum, this.cols.getDescription());
        wsvoucher.setDescription(description);
        wsvoucher.put("cashflowFlag", null);
        int itemFlag = 0;
        wsvoucher.setItemFlag(itemFlag);
        String bizNumber = (String)this.getCellValue(datas, rowNum, this.cols.getBizNumber());
        wsvoucher.setBizNumber(bizNumber);
        String objSettleCode = (String)this.getCellValue(datas, rowNum, this.cols.getSettlementType());
        wsvoucher.setSettlementType(objSettleCode);
        String strSettleNumber = (String)this.getCellValue(datas, rowNum, this.cols.getSettlementNumber());
        wsvoucher.setSettlementNumber(strSettleNumber);
        String des = (String)this.getCellValue(datas, rowNum, this.cols.getAsstAbstract());
        wsvoucher.put("asstAbstract", des);
        int assistCount = 0;
        for (int k = 0; k < 8; ++k) {
            Object obj1 = this.getCellValue(datas, rowNum, this.cols.getAsstActTypeX(k));
            Object obj2 = this.getCellValue(datas, rowNum, this.cols.getAsstActNumberX(k));
            Object obj3 = this.getCellValue(datas, rowNum, this.cols.getAsstActNameX(k));
            if (!(obj1 != null && !"".equals(obj1) || obj2 != null && !"".equals(obj2) || obj3 != null && !"".equals(obj3))) continue;
            String strAsstActTypeName = null;
            if (obj1 != null) {
                strAsstActTypeName = String.valueOf(obj1);
                wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
            }
            String strAsstActID = null;
            if (obj2 != null) {
                if (obj2 instanceof BigDecimal) {
                    strAsstActID = String.valueOf(obj2);
                    if (strAsstActID.indexOf(46) > 0) {
                        strAsstActID = strAsstActID.substring(0, strAsstActID.lastIndexOf(46));
                    }
                } else {
                    strAsstActID = (String)obj2;
                }
                wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
            }
            String strAsstActName = null;
            if (obj3 != null) {
                if (obj3 instanceof BigDecimal) {
                    strAsstActName = String.valueOf(obj3);
                    if (strAsstActName.indexOf(46) > 0) {
                        strAsstActName = strAsstActName.substring(0, strAsstActName.lastIndexOf(46));
                    }
                } else {
                    strAsstActName = (String)obj3;
                }
                wsvoucher.put("asstActName" + assistCount, strAsstActName);
            }
            ++assistCount;
        }
        wsvoucher.put("assistCount", new Integer(assistCount));
        Object strInvoiceNumber = this.getCellValue(datas, rowNum, this.cols.getInvoiceNumber());
        if (strInvoiceNumber != null) {
            wsvoucher.setInvoiceNumber(strInvoiceNumber.toString());
        }
        if ((strTicketNumber = this.getCellValue(datas, rowNum, this.cols.getTicketNumber())) != null) {
            wsvoucher.put("ticketNumber", strTicketNumber.toString());
        }
        if ((objCustomer = this.getCellValue(datas, rowNum, this.cols.getCustomer())) != null) {
            wsvoucher.put("customer", objCustomer.toString());
        }
        if ((objFeeType = this.getCellValue(datas, rowNum, this.cols.getFeeType())) != null) {
            wsvoucher.put("feeType", objFeeType.toString());
        }
        if ((objHandler = this.getCellValue(datas, rowNum, this.cols.getHandler())) != null) {
            wsvoucher.put("handler", objHandler.toString());
        }
        if ((objMaterial = this.getCellValue(datas, rowNum, this.cols.getMaterial())) != null) {
            wsvoucher.put("material", objMaterial.toString());
        }
        if ((objCompanyOrgUnit = this.getCellValue(datas, rowNum, this.cols.getOrgUnit())) != null) {
            wsvoucher.put("orgUnit", objCompanyOrgUnit.toString());
        }
        if ((objSupplier = this.getCellValue(datas, rowNum, this.cols.getSupplier())) != null) {
            wsvoucher.put("supplier", objSupplier.toString());
        }
        if ((asstBizDate = this.getCellDate(datas, cellTypes, rowNum, this.cols.getAsstBizDate().getIndex())) != null) {
            wsvoucher.setAssistBizDate(asstBizDate);
        }
        java.util.Date endDate = null;
        Object cell = this.getCellValue(datas, this.cols.getEndDate().getIndex());
        if (cell != null && cellTypes[this.cols.getEndDate().getIndex()] == 2) {
            String period = cell.toString();
            endDate = period.length() > 0 ? this.getCellDate(datas, cellTypes, rowNum, this.cols.getEndDate().getIndex()) : null;
        }
        if (endDate == null) {
            endDate = wsvoucher.getBizDate();
        }
        wsvoucher.setAssistEndDate(endDate);
        return wsvoucher;
    }

    public Object getCellValue(Object[] datas, int col) {
        return datas[col];
    }

    private Object getCellValue(Object[] datas, int row, VoucherIMPColInfo col) throws Exception {
        return this.getCellValue(datas, row, col.getIndex(), col.getType());
    }

    private Object getCellValue(Object[] datas, int rowNum, int colIndx, int type) throws Exception {
        Object obj = datas[colIndx];
        if (obj == null || "".equals(obj)) {
            return null;
        }
        String typeAlia = "";
        try {
            if (type == 0) {
                typeAlia = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1040_VoucherXLSSparser");
                obj = new BigDecimal(obj.toString());
            } else if (type == 1) {
                typeAlia = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1041_VoucherXLSSparser");
                obj = Boolean.valueOf(obj.toString());
            } else if (type == 2) {
                typeAlia = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1042_VoucherXLSSparser");
            } else if (type == 3) {
                typeAlia = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1043_VoucherXLSSparser");
                if (obj != null) {
                    obj = obj.toString();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(rowNum), new Integer(colIndx + 1), "(" + obj + ") " + typeAlia});
        }
        return obj;
    }

    public static int profitCenterNext(String[] datas, boolean isMulTiCompany, boolean commonVoucherProcess) {
        boolean hasProfitCenter = VoucherXLSXParserByEventModel.xlsxHasProfitCenter(datas, isMulTiCompany);
        int next = 0;
        if (hasProfitCenter) {
            if (!commonVoucherProcess) {
                next = 1;
            }
        } else if (commonVoucherProcess) {
            next = -1;
        }
        return next;
    }

    public static boolean xlsxHasProfitCenter(String[] datas, boolean isMulTiCompany) {
        String resName;
        String name;
        boolean hasProfitCenter = false;
        int profitCenterIndex = 7;
        if (isMulTiCompany) {
            profitCenterIndex = (short)(profitCenterIndex + 1);
        }
        if ((name = datas[profitCenterIndex]).equals(resName = EASResource.getString((String)"com.kingdee.eas.fi.gl.VoucherExpWizardUI", (String)"HSSFCellValue7#1"))) {
            hasProfitCenter = true;
        }
        return hasProfitCenter;
    }

    public Object getCellValue(String[] datas, int cloIndx) {
        return datas[cloIndx];
    }

    private boolean checkRowCell(Object[] datas, boolean isMulTiCompany, int row) throws Exception {
        if (datas == null || datas.length == 0) {
            return false;
        }
        boolean isNullRow = true;
        int count = datas.length;
        for (int col = 0; col < count; ++col) {
            if (this.getCellValue(datas, col) == null || this.getCellValue(datas, col).toString().trim().length() == 0) continue;
            isNullRow = false;
            break;
        }
        if (isNullRow) {
            return false;
        }
        boolean isBlank = true;
        int countOne = -1;
        countOne = isMulTiCompany ? 51 : 50;
        for (int j = 0; j < countOne; ++j) {
            if (this.getCellValue(datas, row, j, 2) == null) continue;
            isBlank = false;
            break;
        }
        return !isBlank;
    }

    private java.util.Date getCellDate(Object[] datas, int[] cellTypes, int row, int col) throws VoucherExpImpException {
        Object cell = datas[col];
        java.util.Date bizDate = new java.util.Date();
        String matches = "\\d{4}/\\d{1,2}/\\d{1,2}";
        if (cell != null) {
            int type = cellTypes[col];
            if (type == 2 || this.cols.getBookedDate().getIndex() == col || this.cols.getBizDate().getIndex() == col || this.cols.getAsstBizDate().getIndex() == col || cell instanceof String && ((String)cell).matches(matches)) {
                String period = cell.toString();
                period = period.replace("/", "-");
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    bizDate = s.parse(period);
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                    throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row), col + 1, ""});
                }
            } else if (type == 0) {
                bizDate = DateUtil.getJavaDate((double)Double.parseDouble((String)cell));
            } else {
                throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row), col + 1, ""});
            }
            return bizDate;
        }
        return null;
    }

    private int getCellIntValue(Object[] datas, int row, int col, int type) throws Exception {
        int value;
        String _strV = String.valueOf(this.getCellValue(datas, row, col, 0));
        if (_strV.indexOf(46) > 0) {
            _strV = _strV.substring(0, _strV.indexOf(46));
        }
        try {
            value = Integer.parseInt(_strV);
        }
        catch (NumberFormatException e) {
            String typeAlia = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1040_VoucherXLSSparser");
            throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row + 1), new Integer(col + 1), "(" + _strV + ") " + typeAlia});
        }
        return value;
    }

    private int getCellIntValue(Object[] datas, int row, VoucherIMPColInfo col) throws Exception {
        return this.getCellIntValue(datas, row, col.getIndex(), col.getType());
    }

    private int profitCenterNext(Object[] datas, boolean isMulTiCompany, boolean commonVoucherProcess) {
        boolean hasProfitCenter = this.xlsHasProfitCenter(datas, isMulTiCompany);
        int next = 0;
        if (hasProfitCenter) {
            if (!commonVoucherProcess) {
                next = 1;
            }
        } else if (commonVoucherProcess) {
            next = -1;
        }
        return next;
    }

    private int asstQtyAndUnitNext(Object[] datas, boolean isMulTiCompany, boolean isSupAsstUnit) {
        boolean hasAsstQtyAndUnit = this.xlsHasAsstQtyAndUnit(datas, isMulTiCompany);
        int next = 0;
        if (hasAsstQtyAndUnit) {
            if (!isSupAsstUnit) {
                next = 1;
            }
        } else if (isSupAsstUnit) {
            next = -1;
        }
        return next;
    }

    private boolean xlsHasProfitCenter(Object[] datas, boolean isMulTiCompany) {
        String resName;
        String name;
        boolean hasProfitCenter = false;
        int profitCenterIndex = 7;
        if (isMulTiCompany) {
            profitCenterIndex = (short)(profitCenterIndex + 1);
        }
        if ((name = this.getCellValue(datas, profitCenterIndex).toString()).equals(resName = EASResource.getString((String)"com.kingdee.eas.fi.gl.VoucherExpWizardUI", (String)"HSSFCellValue7#1"))) {
            hasProfitCenter = true;
        }
        return hasProfitCenter;
    }

    private boolean xlsHasAsstQtyAndUnit(Object[] datas, boolean isMulTiCompany) {
        String resName;
        String name;
        boolean hasAsstQtyAndUnit = false;
        int asstQtyAndUnitIndex = 15;
        if (isMulTiCompany) {
            asstQtyAndUnitIndex = (short)(asstQtyAndUnitIndex + 1);
        }
        if ((name = this.getCellValue(datas, asstQtyAndUnitIndex).toString()).equals(resName = EASResource.getString((String)"com.kingdee.eas.fi.gl.VoucherExpWizardByAssistUnitUI", (String)"HSSFCellValue13"))) {
            hasAsstQtyAndUnit = true;
        }
        return hasAsstQtyAndUnit;
    }

    private class VoucherXLSXParserCallable
    implements Runnable {
        VoucherXLSXParserByEventModel vchParserEventModel;
        String sheetRId;

        public VoucherXLSXParserCallable(VoucherXLSXParserByEventModel vchParserEventModel, String sheetRid) {
            this.vchParserEventModel = vchParserEventModel;
            this.sheetRId = sheetRid;
        }

        @Override
        public void run() {
            try {
                logger.info((Object)("task '" + VoucherXLSXParserByEventModel.this.taskName + "' sparser start..."));
                this.vchParserEventModel.processOneSheet(this.sheetRId);
                logger.info((Object)("task '" + VoucherXLSXParserByEventModel.this.taskName + "' sparser end..."));
            }
            catch (Exception e) {
                logger.error((Object)"excel parser error", (Throwable)e);
            }
        }
    }

    private class RowInfo {
        Object[] datas;
        int[] cellTypes;
        int rowNum;

        public RowInfo(Object[] datas, int[] cellTypes, int rowNum) {
            this.datas = datas;
            this.cellTypes = cellTypes;
            this.rowNum = rowNum;
        }

        public RowInfo() {
        }

        public int getRowNum() {
            return this.rowNum;
        }

        public Object[] getDatas() {
            return this.datas;
        }

        public int[] getCellTypes() {
            return this.cellTypes;
        }
    }
}

