/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.ui.face.CoreUIObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxListReader {
    private static final Logger logger = CoreUIObject.getLogger(XlsxListReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, List<List<String>>> readXlsx(File file) {
        LinkedHashMap<String, List<List<String>>> liness = null;
        FileInputStream fis = null;
        XSSFWorkbook wb = null;
        try {
            fis = new FileInputStream(file);
            wb = new XSSFWorkbook((InputStream)fis);
            int number = wb.getNumberOfSheets();
            liness = new LinkedHashMap<String, List<List<String>>>(number);
            for (int i = 0; i < number; ++i) {
                XSSFSheet sheet = wb.getSheetAt(i);
                List<List<String>> lines = XlsxListReader.readSheet(sheet);
                liness.put(sheet.getSheetName(), lines);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                if (wb != null) {
                    wb.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return liness;
    }

    public static List<List<String>> readSheet(XSSFSheet sheet) {
        XSSFCell cell;
        String value;
        int rowSize = sheet.getLastRowNum() + 1;
        ArrayList<List<String>> lines = new ArrayList<List<String>>(rowSize);
        XSSFRow header = sheet.getRow(0);
        if (header == null) {
            return lines;
        }
        int colSize = header.getLastCellNum() + 1;
        ArrayList<String> colNames = new ArrayList<String>(colSize);
        for (int colIndex = 0; colIndex < colSize && (value = XlsxListReader.getCellValue(cell = header.getCell(colIndex))) != null && value.length() != 0; ++colIndex) {
            colNames.add(value);
        }
        if (colNames.size() <= 0) {
            return lines;
        }
        lines.add(colNames);
        colSize = colNames.size();
        for (int rowIndex = 1; rowIndex < rowSize; ++rowIndex) {
            XSSFRow row = sheet.getRow(rowIndex);
            ArrayList<String> line = new ArrayList<String>(colSize);
            for (int colIndex = 0; colIndex < colSize; ++colIndex) {
                XSSFCell cell2 = row.getCell(colIndex);
                String value2 = XlsxListReader.getCellValue(cell2);
                line.add(value2);
            }
            lines.add(line);
        }
        return lines;
    }

    public static String getCellValue(XSSFCell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case BOOLEAN: {
                return cell.getBooleanCellValue() ? "1" : "0";
            }
            case NUMERIC: {
                double d = cell.getNumericCellValue();
                if (d % 1.0 == 0.0) {
                    return String.valueOf((long)d);
                }
                return String.valueOf(d);
            }
            case STRING: {
                String str = cell.getStringCellValue();
                if (str == null) {
                    return "";
                }
                return str.trim();
            }
        }
        return "";
    }

    public static void main(String[] args) {
        File file = new File("C:" + File.separator + "Users" + File.separator + "RD_zhuliang_li" + File.separator + "Desktop" + File.separator + "importVoucher.xlsx");
        LinkedHashMap<String, List<List<String>>> datass = XlsxListReader.readXlsx(file);
        System.out.println(datass);
    }
}

