/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.ui.face.CoreUIObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxMapReader {
    private static final Logger logger = CoreUIObject.getLogger(XlsxMapReader.class);

    public static LinkedHashMap<String, List<Map<String, Object>>> readXlsx(File file) {
        return XlsxMapReader.readXlsx(file, new HashMap<String, Class>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, List<Map<String, Object>>> readXlsx(File file, Map<String, Class> clazzes) {
        LinkedHashMap<String, List<Map<String, Object>>> liness = null;
        FileInputStream fis = null;
        XSSFWorkbook wb = null;
        try {
            fis = new FileInputStream(file);
            wb = new XSSFWorkbook((InputStream)fis);
            int number = wb.getNumberOfSheets();
            liness = new LinkedHashMap<String, List<Map<String, Object>>>(number);
            for (int i = 0; i < number; ++i) {
                XSSFSheet sheet = wb.getSheetAt(i);
                List<Map<String, Object>> lines = XlsxMapReader.readSheet(sheet, clazzes);
                liness.put(sheet.getSheetName(), lines);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                if (wb != null) {
                    wb.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return liness;
    }

    public static List<Map<String, Object>> readSheet(XSSFSheet sheet, Map<String, Class> clazzes) {
        XSSFCell cell;
        String colName;
        int rowSize = sheet.getLastRowNum() + 1;
        ArrayList<Map<String, Object>> lines = new ArrayList<Map<String, Object>>(rowSize);
        XSSFRow header = sheet.getRow(0);
        if (header == null) {
            return lines;
        }
        int colSize = header.getLastCellNum() + 1;
        HashMap<String, Integer> colIndexs = new HashMap<String, Integer>();
        for (int colIndex = 0; colIndex < colSize && (colName = (String)XlsxMapReader.getCellValue(cell = header.getCell(colIndex), String.class)) != null && colName.length() != 0; ++colIndex) {
            colIndexs.put(colName, colIndex);
        }
        if (colIndexs.size() == 0) {
            return lines;
        }
        for (int rowIndex = 1; rowIndex < rowSize; ++rowIndex) {
            XSSFRow row = sheet.getRow(rowIndex);
            HashMap<String, Object> line = new HashMap<String, Object>();
            for (String name : colIndexs.keySet()) {
                Object value = XlsxMapReader.getCellValue(row.getCell(((Integer)colIndexs.get(name)).intValue()), clazzes.get(name));
                line.put(name, value);
            }
            lines.add(line);
        }
        return lines;
    }

    public static Object getCellValue(XSSFCell cell, Class clazz) {
        if (cell == null) {
            if (clazz == Integer.class) {
                return 0;
            }
            if (clazz == Double.class) {
                return 0.0;
            }
            return null;
        }
        CellType type = cell.getCellType();
        switch (type) {
            case BOOLEAN: {
                if (clazz == Integer.class) {
                    return cell.getBooleanCellValue() ? 1 : 0;
                }
                if (clazz == String.class) {
                    return cell.getBooleanCellValue() ? "1" : "0";
                }
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (clazz == Integer.class) {
                    return (int)cell.getNumericCellValue();
                }
                if (clazz == null || clazz == String.class) {
                    double d = cell.getNumericCellValue();
                    if (d % 1.0 == 0.0) {
                        return String.valueOf((long)d);
                    }
                    return String.valueOf(d);
                }
                if (clazz == Boolean.class) {
                    return cell.getNumericCellValue() == 1.0;
                }
                return cell.getNumericCellValue();
            }
            case STRING: {
                String str = cell.getStringCellValue();
                if (str != null) {
                    str = str.trim();
                }
                if (clazz == Integer.class) {
                    try {
                        return Integer.parseInt(str);
                    }
                    catch (Exception ignore) {
                        return 0;
                    }
                }
                if (clazz == Double.class) {
                    try {
                        return Double.parseDouble(str);
                    }
                    catch (Exception ignore) {
                        return 0.0;
                    }
                }
                if (clazz == Boolean.class) {
                    return "true".equalsIgnoreCase(str) || "1".equals(str);
                }
                return str;
            }
            case BLANK: {
                if (clazz == Integer.class) {
                    return 0;
                }
                if (clazz == Double.class) {
                    return 0.0;
                }
                return null;
            }
        }
        return null;
    }
}

