/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemViewFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AsstActFinder;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.validator.IValidator;
import com.kingdee.eas.fi.gl.validator.ValidatorCollection;
import com.kingdee.eas.fi.gl.validator.ValidatorFactory;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class VoucherProcessCache
implements Serializable {
    private static final long serialVersionUID = -6210234253870297108L;
    private static final Logger logger = Logger.getLogger(VoucherProcessCache.class);
    private static final ThreadLocal<VoucherProcessCache> caches = new ThreadLocal();
    private String cacheId;
    private HashMap sysParams;
    private HashMap currPeriods;
    private HashMap startPeriods;
    private HashMap isExistCodingRule;
    private HashMap voucherTypes;
    private HashMap voucherTypeCtrlLevel;
    private HashMap voucherTypeCtrlItem;
    private HashMap accountUserProperty;
    private HashMap voucherCollMap;
    private HashMap accountValidMap;
    private HashMap functionPermMap;
    private Map<String, Boolean> glInitStateMap;
    private Map<String, Boolean> accountInitStateMap;
    private Map assistInitStateMap;
    private Map cussentInitStateMap;
    private Map mutexMap;
    private Map differenceMap;
    private Map masterBookMap;
    private Map bookListMap;
    private Map relatedCompanyAccountMapping;
    private Map relatedCompanyAccountSuccessMapping;
    private Map<String, FilterInfo> cashFlowItemViewMap = new HashMap<String, FilterInfo>();
    private boolean mutexLockModifyBalance = false;
    private Map<String, Map<String, Object>> datass = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> params = new HashMap<String, Object>();
    private Map<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
    private boolean multiThread = false;
    private Map<String, ValidatorCollection> validatorss = new HashMap<String, ValidatorCollection>();
    private Map<String, PeriodInfo> currentPeriods = new HashMap<String, PeriodInfo>();
    private Map<String, PeriodInfo> pcaCurrentPeriods = new HashMap<String, PeriodInfo>();
    private Map<String, CompanyOrgUnitInfo> companysById = null;
    private Map<String, CompanyOrgUnitInfo> companysByNumber = null;
    private SelectorItemCollection accountSelector = null;
    private Map<String, AccountViewInfo> accounts = null;
    private Map<String, AsstAccountInfo> caas = new HashMap<String, AsstAccountInfo>();
    private Map<String, AsstActTypeInfo> asstActTypes = new HashMap<String, AsstActTypeInfo>();
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    private AsstActFinder finder = new AsstActFinder();
    private Map<String, DataBaseInfo> asstActObjects = null;
    private Map<String, AssistantHGInfo> assistantHGs = null;
    private Map<String, MeasureUnitInfo> measureUnits = null;
    private Map<String, SettlementTypeInfo> settlementTypes = null;
    private Map<String, SettlementTypeInfo> settlementType2s = null;
    private Map<String, Object[]> exchangeRates = null;
    private Map<String, Boolean> masterBooks = null;
    private List<Map<String, String>> asstValidators = null;
    private Map<String, Boolean> asstActInfoForAcNotice = null;
    private Map<String, IObjectValue> dataBaseMap;
    private Map asstActTypeByGroupMap;

    protected VoucherProcessCache(String cacheId) {
        this.cacheId = cacheId;
        this.sysParams = new HashMap();
        this.currPeriods = new HashMap();
        this.startPeriods = new HashMap();
        this.isExistCodingRule = new HashMap();
        this.voucherTypes = new HashMap();
        this.voucherTypeCtrlLevel = new HashMap();
        this.voucherTypeCtrlItem = new HashMap();
        this.accountUserProperty = new HashMap();
        this.voucherCollMap = new HashMap();
        this.accountValidMap = new HashMap();
        this.functionPermMap = new HashMap();
        this.glInitStateMap = new HashMap<String, Boolean>();
        this.accountInitStateMap = new HashMap<String, Boolean>();
        this.assistInitStateMap = new HashMap();
        this.cussentInitStateMap = new HashMap();
        this.differenceMap = new HashMap();
        this.masterBookMap = new HashMap();
        this.bookListMap = new HashMap();
        this.relatedCompanyAccountMapping = new HashMap();
        this.relatedCompanyAccountSuccessMapping = new HashMap();
        this.asstActTypeByGroupMap = new HashMap();
    }

    public VoucherCollection getVoucherCollection(SelectorItemCollection selector) {
        return (VoucherCollection)this.voucherCollMap.get(Thread.currentThread().getId() + "_" + selector.encode());
    }

    public void setVoucherCollection(SelectorItemCollection selector, VoucherCollection voucherColl) {
        this.voucherCollMap.put(Thread.currentThread().getId() + "_" + selector.encode(), voucherColl);
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public HashMap getSysParams() {
        return this.sysParams;
    }

    public HashMap getCurrPeriods() {
        return this.currPeriods;
    }

    public HashMap getStartPeriods() {
        return this.startPeriods;
    }

    public HashMap getIsExistCodingRule() {
        return this.isExistCodingRule;
    }

    public HashMap getVoucherTypes() {
        return this.voucherTypes;
    }

    public HashMap getVoucherTypeCtrlLevel() {
        return this.voucherTypeCtrlLevel;
    }

    public HashMap getVoucherTypeCtrlItem() {
        return this.voucherTypeCtrlItem;
    }

    public HashMap getAccountUserProperty() {
        return this.accountUserProperty;
    }

    public HashMap getAccountValidMap() {
        return this.accountValidMap;
    }

    public HashMap getFunctionPermMap() {
        return this.functionPermMap;
    }

    public Map getAsstActTypeByGroupMap() {
        return this.asstActTypeByGroupMap;
    }

    public void setAsstActTypeByGroupMap(String asstactTypeGroupId, Vector vec) {
        this.asstActTypeByGroupMap.put(asstactTypeGroupId, vec);
    }

    public static boolean isCloseInited(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.isCloseInitedFromCache(ctx, company);
        }
        return VoucherUtil.isGlStarted((Context)ctx, (CompanyOrgUnitInfo)company);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCloseInitedFromCache(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        Map<String, Boolean> map = this.glInitStateMap;
        synchronized (map) {
            String companyId = company.getId().toString();
            if (this.glInitStateMap.containsKey(companyId)) {
                return this.glInitStateMap.get(companyId);
            }
            boolean glCloseInit = VoucherUtil.isGlStarted((Context)ctx, (CompanyOrgUnitInfo)company);
            this.glInitStateMap.put(companyId, glCloseInit);
            return glCloseInit;
        }
    }

    public static boolean isAccountInited(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.isAccountInitedFromCache(ctx, company);
        }
        return VoucherUtil.isAccountInited((Context)ctx, (String)company.getId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAccountInitedFromCache(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        Map<String, Boolean> map = this.accountInitStateMap;
        synchronized (map) {
            String companyId = company.getId().toString();
            if (this.accountInitStateMap.containsKey(companyId)) {
                return this.accountInitStateMap.get(companyId);
            }
            boolean inited = VoucherUtil.isAccountInited((Context)ctx, (String)company.getId().toString());
            this.accountInitStateMap.put(companyId, inited);
            return inited;
        }
    }

    public Map getAssistInitStateMap() {
        return this.assistInitStateMap;
    }

    public void setAssistInitStateMap(Map map) {
        this.assistInitStateMap.putAll(map);
    }

    public Map getCussentInitStateMap() {
        return this.cussentInitStateMap;
    }

    public static Map getDifference(Context ctx, String companyId) throws EASBizException, BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.getDifferenceFromCache(ctx, companyId);
        }
        return CashflowRecordFactory.getLocalInstance(ctx).getDifference(companyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDifferenceFromCache(Context ctx, String companyId) throws EASBizException, BOSException {
        Map map = this.differenceMap;
        synchronized (map) {
            Map difference = (Map)this.differenceMap.get(companyId);
            if (difference == null) {
                difference = CashflowRecordFactory.getLocalInstance(ctx).getDifference(companyId);
                this.differenceMap.put(companyId, difference);
            }
            HashMap diff = new HashMap();
            diff.putAll(difference);
            return diff;
        }
    }

    public void setCussentInitStateMap(Map map) {
        this.cussentInitStateMap.putAll(map);
    }

    public Map getMutexMap() {
        return this.mutexMap;
    }

    public void setMutexMap(Map mutexMap) {
        this.mutexMap = mutexMap;
    }

    public Map getMasterBookMap() {
        return this.masterBookMap;
    }

    public void setMasterBook(String companyId, boolean isMasterBook) {
        this.masterBookMap.put(companyId, isMasterBook);
    }

    public Map getRelatedCompanyAccountMapping() {
        return this.relatedCompanyAccountMapping;
    }

    public void setRelatedCompanyAccountMapping(String key, AccountViewInfo accountViewInfo) {
        this.relatedCompanyAccountMapping.put(key, accountViewInfo);
    }

    public Map getRelatedCompanyAccountSuccessMapping() {
        return this.relatedCompanyAccountSuccessMapping;
    }

    public void setRelatedCompanyAccountSuccessMapping(String key, AccountViewInfo accountViewInfo) {
        this.relatedCompanyAccountSuccessMapping.put(key, accountViewInfo);
    }

    public Map getBookListMap() {
        return this.bookListMap;
    }

    public void setBookList(String mainOrg, Map bookList) {
        this.bookListMap.put(mainOrg, bookList);
    }

    public static VoucherProcessCache getInstance(String cacheId) {
        return new VoucherProcessCache(cacheId);
    }

    public static boolean isCache(Context ctx) {
        return caches.get() != null;
    }

    public static VoucherProcessCache getCache(Context ctx) {
        if (ctx == null) {
            return null;
        }
        return caches.get();
    }

    public static void initCache(Context ctx, String cacheId) {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache == null) {
            cache = VoucherProcessCache.getInstance(cacheId);
            caches.set(cache);
        }
    }

    public static void initCache(Context ctx, VoucherProcessCache cache) {
        VoucherProcessCache c = VoucherProcessCache.getCache(ctx);
        if (c == null && cache != null) {
            caches.set(cache);
        }
    }

    public static void clearCache(Context ctx, String cacheId) {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cacheId.equals(cache.getCacheId())) {
            caches.set(null);
        }
    }

    public boolean isMutexLockModifyBalance() {
        return this.mutexLockModifyBalance;
    }

    public void setMutexLockModifyBalance(boolean mutexLockModifyBalance) {
        this.mutexLockModifyBalance = mutexLockModifyBalance;
    }

    public static Map<String, Object> getDatas(Context ctx, String type) {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.getDatasFromCache(ctx, type);
        }
        return null;
    }

    public Map<String, Object> getDatasFromCache(Context ctx, String type) {
        if (this.datass.containsKey(type)) {
            return this.datass.get(type);
        }
        HashMap<String, Object> datas = new HashMap<String, Object>();
        this.datass.put(type, datas);
        return datas;
    }

    public Map<String, Object> getDatas(Context ctx) {
        return this.getDatasFromCache(ctx, "CommonDatas");
    }

    public static Map<String, Object> getParams(Context ctx, HashMap<String, String> ins) throws BOSException, EASBizException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.getParamsFromCache(ctx, ins);
        }
        return ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(ins);
    }

    public static Object getParam(Context ctx, String companyId, String number) throws BOSException, EASBizException {
        HashMap<String, String> ins = new HashMap<String, String>();
        ins.put(number, companyId);
        Map<String, Object> outs = VoucherProcessCache.getParams(ctx, ins);
        return outs.get(number);
    }

    public static boolean getDefaultGLParam(Context ctx, String companyId, String number) throws BOSException, EASBizException {
        Object object = VoucherProcessCache.getParam(ctx, companyId, number);
        boolean value = false;
        value = object != null ? Boolean.valueOf(object.toString()) : true;
        return value;
    }

    public Map<String, Object> getParamsFromCache(Context ctx, HashMap<String, String> ins) throws BOSException, EASBizException {
        HashMap<String, Object> outs = new HashMap<String, Object>();
        HashMap<String, String> subIns = new HashMap<String, String>();
        for (String number : ins.keySet()) {
            String companyId = ins.get(number);
            String key = (companyId == null ? "nocompany" : companyId) + "_" + number;
            if (this.params.containsKey(key)) {
                outs.put(number, this.params.get(key));
                continue;
            }
            subIns.put(number, companyId);
        }
        if (subIns.size() <= 0) {
            return outs;
        }
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.putAll(subIns);
        HashMap result = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(temp);
        for (String number : subIns.keySet()) {
            String companyId = ins.get(number);
            String key = (companyId == null ? "nocompany" : companyId) + "_" + number;
            this.params.put(key, result.get(number));
            outs.put(number, result.get(number));
        }
        return outs;
    }

    public static PeriodInfo getPeriod(Context ctx, String periodId) throws EASBizException, BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.getPeriodFromCache(ctx, periodId);
        }
        return VoucherProcessCache.doGetPeriod(ctx, periodId);
    }

    public PeriodInfo getPeriodFromCache(Context ctx, String periodId) throws EASBizException, BOSException {
        if (this.periods.containsKey(periodId)) {
            return this.periods.get(periodId);
        }
        PeriodInfo period = VoucherProcessCache.doGetPeriod(ctx, periodId);
        this.periods.put(periodId, period);
        return period;
    }

    public static PeriodInfo doGetPeriod(Context ctx, String periodId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isAdjustPeriod"));
        sic.add(new SelectorItemInfo("type.id"));
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId), sic);
    }

    public boolean isMultiThread() {
        return this.multiThread;
    }

    public void setMultiThread(boolean multiThread) {
        this.multiThread = multiThread;
    }

    public static ValidatorCollection getValidators(Context ctx, String callClassName) throws BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.getValidatorsFromCache(ctx, callClassName);
        }
        return VoucherProcessCache.doGetValidators(ctx, callClassName);
    }

    public ValidatorCollection getValidatorsFromCache(Context ctx, String callClassName) throws BOSException {
        String key = callClassName;
        if (key == null || key.length() == 0) {
            key = "VoucherProcessCache.callClassName";
        }
        if (this.validatorss.containsKey(key)) {
            return this.validatorss.get(key);
        }
        ValidatorCollection vc = VoucherProcessCache.doGetValidators(ctx, callClassName);
        this.validatorss.put(key, vc);
        return vc;
    }

    public static ValidatorCollection doGetValidators(Context ctx, String callClassName) throws BOSException {
        IValidator iValidator = ValidatorFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("callClassName"));
        coll.add(new SelectorItemInfo("validatorInterface"));
        coll.add(new SelectorItemInfo("validatorClassName"));
        evi.setSelector(coll);
        if (callClassName != null && callClassName.length() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("callClassName", (Object)callClassName, CompareType.EQUALS));
            evi.setFilter(filter);
        }
        return iValidator.getValidatorCollection(evi);
    }

    public FilterInfo getCashFlowItemViewFromCache(Context ctx, String cuID) throws EASBizException, BOSException {
        if (this.cashFlowItemViewMap.containsKey(cuID)) {
            return this.cashFlowItemViewMap.get(cuID);
        }
        FilterInfo filter = CashFlowItemViewFactory.getLocalInstance((Context)ctx).getCashFlowItemViewFilter(cuID);
        this.cashFlowItemViewMap.put(cuID, filter);
        return filter;
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.getCurrentPeriodFromCache(ctx, companyId);
        }
        return VoucherProcessCache.doGetCurrentPeriod(ctx, companyId);
    }

    public PeriodInfo getCurrentPeriodFromCache(Context ctx, String companyId) throws BOSException, EASBizException {
        if (this.currentPeriods.containsKey(companyId)) {
            return this.currentPeriods.get(companyId);
        }
        PeriodInfo period = VoucherProcessCache.doGetCurrentPeriod(ctx, companyId);
        this.currentPeriods.put(companyId, period);
        return period;
    }

    public static PeriodInfo doGetCurrentPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
    }

    public static PeriodInfo getPcaCurrentPeriod(Context ctx, String profigCenterId) throws BOSException, EASBizException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.getPcaCurrentPeriodFromCache(ctx, profigCenterId);
        }
        return VoucherProcessCache.doGetPcaCurrentPeriod(ctx, profigCenterId);
    }

    public PeriodInfo getPcaCurrentPeriodFromCache(Context ctx, String profitCenterId) throws BOSException, EASBizException {
        if (this.pcaCurrentPeriods.containsKey(profitCenterId)) {
            return this.pcaCurrentPeriods.get(profitCenterId);
        }
        PeriodInfo period = VoucherProcessCache.doGetPcaCurrentPeriod(ctx, profitCenterId);
        this.pcaCurrentPeriods.put(profitCenterId, period);
        return period;
    }

    public static PeriodInfo doGetPcaCurrentPeriod(Context ctx, String profitCenterId) throws BOSException, EASBizException {
        return SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitCurrentPeriod(new Integer(SystemEnum.PROFIT_CENTER_ACCOUNTING.getValue()).intValue(), profitCenterId);
    }

    public CompanyOrgUnitInfo getCompanyById(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        if (this.companysById == null) {
            this.companysById = new HashMap<String, CompanyOrgUnitInfo>();
        }
        if (this.companysById.containsKey(id = id.trim())) {
            return this.companysById.get(id);
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        this.companysById.put(id, company);
        return company;
    }

    public CompanyOrgUnitInfo getCompanyByNumber(Context ctx, String number) throws BOSException, EASBizException {
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        if (this.companysByNumber == null) {
            this.companysByNumber = new HashMap<String, CompanyOrgUnitInfo>();
        }
        if (this.companysByNumber.containsKey(number = number.trim())) {
            return this.companysByNumber.get(number);
        }
        CompanyOrgUnitInfo company = GlWebServiceUtil.getCompany(ctx, number);
        this.companysByNumber.put(number, company);
        return company;
    }

    public void cacheCompanys(Context ctx, Set<String> numbers) throws BOSException, EASBizException {
        Set<String> subNumbers;
        if (this.companysByNumber == null) {
            this.companysByNumber = new HashMap<String, CompanyOrgUnitInfo>();
        }
        if (this.companysByNumber.size() > 0) {
            subNumbers = new HashSet<String>();
            for (String number : numbers) {
                if (this.companysByNumber.containsKey(number)) continue;
                subNumbers.add(number);
            }
        } else {
            subNumbers = numbers;
        }
        if (subNumbers.size() <= 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", subNumbers, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            this.companysByNumber.put(coll.get(i).getNumber(), coll.get(i));
        }
    }

    public boolean getImportParam(Context ctx, String companyId) throws BOSException, EASBizException {
        Object value = VoucherProcessCache.getParam(ctx, companyId, "GL_016");
        boolean importParam = false;
        try {
            importParam = Boolean.valueOf(value.toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return importParam;
    }

    public boolean getUseImportKey(Context ctx) throws BOSException, EASBizException {
        Object value = VoucherProcessCache.getParam(ctx, null, "GL_016_1");
        boolean useImportKey = false;
        try {
            useImportKey = Boolean.valueOf(value.toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return useImportKey;
    }

    public int getVerifyMode(Context ctx, String companyId) throws BOSException, EASBizException {
        Object value = VoucherProcessCache.getParam(ctx, companyId, "GL_052");
        int verifyMode = 0;
        if (value != null) {
            verifyMode = Integer.parseInt(value.toString());
        }
        return verifyMode;
    }

    public boolean getHandnumberParam(Context ctx, String companyId) throws BOSException, EASBizException {
        Object value = VoucherProcessCache.getParam(ctx, companyId, "GL_031");
        boolean importParam = false;
        try {
            importParam = Boolean.valueOf(value.toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return importParam;
    }

    public void cacheParams(Context ctx, String companyId, Set<String> numbers) throws BOSException, EASBizException {
        HashMap<String, String> hmParamIn = new HashMap<String, String>();
        for (String number : numbers) {
            hmParamIn.put(number, companyId);
        }
        VoucherProcessCache.getParams(ctx, hmParamIn);
    }

    private SelectorItemCollection getAccountSelector() {
        if (this.accountSelector != null) {
            return this.accountSelector;
        }
        HashSet<String> fields = new HashSet<String>();
        this.accountSelector = new SelectorItemCollection();
        String prefix = "entries.account.";
        SelectorItemCollection voucherSelector = VoucherInfo.getDefaultSelector();
        for (int i = 0; i < voucherSelector.size(); ++i) {
            String name = voucherSelector.get(i).getPropertyName();
            if (!name.startsWith(prefix)) continue;
            String field = name.substring(prefix.length());
            this.accountSelector.add(field);
            fields.add(field);
        }
        if (!fields.contains("id")) {
            this.accountSelector.add("id");
        }
        if (!fields.contains("number")) {
            this.accountSelector.add("number");
        }
        if (!fields.contains("accrualDirection")) {
            this.accountSelector.add("accrualDirection");
        }
        if (!fields.contains("accountingcurrency")) {
            this.accountSelector.add("accountingcurrency");
        }
        if (!fields.contains("CAA.count")) {
            this.accountSelector.add("CAA.count");
        }
        if (!fields.contains("CAA.measureUnitGroup")) {
            this.accountSelector.add("CAA.measureUnitGroup");
        }
        this.accountSelector.add("accountCurrency.id");
        this.accountSelector.add("accountCurrency.currency");
        this.accountSelector.add("accountCurrency.currency.id");
        return this.accountSelector;
    }

    public AccountViewInfo findAccountByNumber(Context ctx, String strNumber, CompanyOrgUnitInfo company) throws BOSException {
        if (strNumber == null || strNumber.trim().length() == 0) {
            return null;
        }
        if (this.accounts == null) {
            this.accounts = new HashMap<String, AccountViewInfo>();
        }
        strNumber = strNumber.trim();
        String key = company.getId().toString() + "_" + strNumber;
        if (this.accounts.containsKey(key)) {
            return this.accounts.get(key);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strNumber));
        fic.add(new FilterItemInfo("companyId.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        String suffixMask = "";
        if (!this.isAllowImportCtrAccount(ctx)) {
            fic.add(new FilterItemInfo("control", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("control", null));
            suffixMask = " and (#3 or #4)";
        }
        filter.setMaskString("#0 and #1 and #2" + suffixMask);
        view.setSelector(this.getAccountSelector());
        AccountViewInfo account = null;
        AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        if (coll != null && coll.size() > 0) {
            account = coll.get(0);
        }
        this.accounts.put(key, account);
        return account;
    }

    public void cacheAccounts(Context ctx, CompanyOrgUnitInfo company, Set<String> numbers) throws BOSException {
        Set<String> subNumbers;
        if (this.accounts == null) {
            this.accounts = new HashMap<String, AccountViewInfo>();
        }
        String key = company.getId().toString() + "_";
        if (this.accounts.size() > 0) {
            subNumbers = new HashSet<String>();
            for (String number : numbers) {
                if (this.accounts.containsKey(key + number)) continue;
                subNumbers.add(number);
            }
        } else {
            subNumbers = numbers;
        }
        if (subNumbers.size() <= 0) {
            return;
        }
        if (subNumbers.size() <= 50) {
            this.doCacheAccounts(ctx, company, subNumbers);
        } else {
            HashSet<String> sonNumbers = new HashSet<String>();
            for (String number : subNumbers) {
                sonNumbers.add(number);
                if (sonNumbers.size() < 50) continue;
                this.doCacheAccounts(ctx, company, sonNumbers);
                sonNumbers = new HashSet();
            }
            if (sonNumbers.size() > 0) {
                this.doCacheAccounts(ctx, company, sonNumbers);
            }
        }
    }

    private void doCacheAccounts(Context ctx, CompanyOrgUnitInfo company, Set<String> subNumbers) throws BOSException {
        String key = company.getId().toString() + "_";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", subNumbers, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("companyId.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        String suffixMask = "";
        if (!this.isAllowImportCtrAccount(ctx)) {
            fic.add(new FilterItemInfo("control", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("control", null));
            suffixMask = " and (#3 or #4)";
        }
        filter.setMaskString("#0 and #1 and #2" + suffixMask);
        view.setSelector(this.getAccountSelector());
        AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            this.accounts.put(key + coll.get(i).getNumber(), coll.get(i));
        }
    }

    public AsstAccountInfo getCaa(Context ctx, AccountViewInfo account, PeriodInfo period) throws EASBizException, BOSException {
        HashSet<String> accountIds = new HashSet<String>();
        accountIds.add(account.getId().toString());
        Map<String, AsstAccountInfo> result = this.getCAAsFromCache(ctx, accountIds, period);
        return result.get(account.getId().toString());
    }

    public static Map<String, AsstAccountInfo> getCAAs(Context ctx, Set<String> accountIds, PeriodInfo period) throws EASBizException, BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.getCAAsFromCache(ctx, accountIds, period);
        }
        if (period.getNumber() <= 0) {
            period = VoucherProcessCache.getPeriod(ctx, period.getId().toString());
        }
        return AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAsByPeriod(accountIds, period.getNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AsstAccountInfo> getCAAsFromCache(Context ctx, Set<String> accountIds, PeriodInfo period) throws EASBizException, BOSException {
        Map<String, AsstAccountInfo> map = this.caas;
        synchronized (map) {
            HashMap<String, AsstAccountInfo> result = new HashMap<String, AsstAccountInfo>();
            HashSet<String> newAccountIds = new HashSet<String>();
            if (this.caas.size() > 0) {
                for (String accountId : accountIds) {
                    String key = accountId + "_" + period.getId().toString();
                    if (this.caas.containsKey(key)) {
                        result.put(accountId, this.caas.get(key));
                        continue;
                    }
                    newAccountIds.add(accountId);
                }
            } else {
                newAccountIds.addAll(accountIds);
            }
            if (newAccountIds.size() <= 0) {
                return result;
            }
            if (period.getNumber() <= 0) {
                period = VoucherProcessCache.getPeriod(ctx, period.getId().toString());
            }
            Map newCaas = AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAsByPeriod(newAccountIds, period.getNumber());
            result.putAll(newCaas);
            for (String accountId : newCaas.keySet()) {
                this.caas.put(accountId + "_" + period.getId().toString(), (AsstAccountInfo)newCaas.get(accountId));
            }
            return result;
        }
    }

    public static AsstActTypeInfo findAsstActType(Context ctx, String asstActTypeId) throws BOSException, EASBizException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.findAsstActTypeFromCache(ctx, asstActTypeId);
        }
        return VoucherProcessCache.doFindAsstActType(ctx, asstActTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsstActTypeInfo findAsstActTypeFromCache(Context ctx, String asstActTypeId) throws BOSException, EASBizException {
        Map<String, AsstActTypeInfo> map = this.asstActTypes;
        synchronized (map) {
            if (this.asstActTypes.containsKey(asstActTypeId)) {
                return this.asstActTypes.get(asstActTypeId);
            }
            AsstActTypeInfo asstActType = VoucherProcessCache.doFindAsstActType(ctx, asstActTypeId);
            this.asstActTypes.put(asstActTypeId, asstActType);
            return asstActType;
        }
    }

    private static AsstActTypeInfo doFindAsstActType(Context ctx, String asstActTypeId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("asstHGAttribute");
        selector.add("realtionDataObject");
        selector.add("mappingFieldName");
        selector.add("groupTableName");
        selector.add("isMultilevel");
        selector.add("useLongNumber");
        selector.add("glAsstActTypeGrp.*");
        return AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActTypeId), selector);
    }

    public static AsstActTypeInfo findAsstActTypeByNumberOrName(Context ctx, String numberOrName) throws BOSException {
        if (numberOrName == null || numberOrName.trim().length() == 0) {
            return null;
        }
        numberOrName = numberOrName.trim();
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.findAsstActTypeByNumberOrNameFromCache(ctx, numberOrName);
        }
        return VoucherProcessCache.doFindAsstActTypeByNumberOrName(ctx, numberOrName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsstActTypeInfo findAsstActTypeByNumberOrNameFromCache(Context ctx, String numberOrName) throws BOSException {
        Map<String, AsstActTypeInfo> map = this.asstActTypes;
        synchronized (map) {
            if (this.asstActTypes.containsKey(numberOrName)) {
                return this.asstActTypes.get(numberOrName);
            }
            AsstActTypeInfo asstActType = VoucherProcessCache.doFindAsstActTypeByNumberOrName(ctx, numberOrName);
            this.asstActTypes.put(numberOrName, asstActType);
            if (asstActType != null) {
                if (!this.asstActTypes.containsKey(asstActType.getId().toString())) {
                    this.asstActTypes.put(asstActType.getId().toString(), asstActType);
                }
                if (!this.asstActTypes.containsKey(asstActType.getAsstHGAttribute())) {
                    this.asstActTypes.put(asstActType.getAsstHGAttribute(), asstActType);
                }
            }
            return asstActType;
        }
    }

    private static AsstActTypeInfo doFindAsstActTypeByNumberOrName(Context ctx, String numberOrName) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("asstHGAttribute");
        selector.add("realtionDataObject");
        selector.add("mappingFieldName");
        selector.add("groupTableName");
        selector.add("isMultilevel");
        selector.add("useLongNumber");
        selector.add("glAsstActTypeGrp.*");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberOrName));
        AsstActTypeInfo type = null;
        AsstActTypeCollection coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
        if (coll.size() > 0) {
            type = coll.get(0);
        } else {
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)numberOrName));
            coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
            if (coll.size() > 0) {
                type = coll.get(0);
            }
        }
        return type;
    }

    public static AsstActTypeInfo findAsstActTypeByAttribute(Context ctx, String asstHGAttribute) throws BOSException {
        if (asstHGAttribute == null || asstHGAttribute.trim().length() == 0) {
            return null;
        }
        asstHGAttribute = asstHGAttribute.trim();
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.findAsstActTypeByAttributeFromCache(ctx, asstHGAttribute);
        }
        return VoucherProcessCache.doFindAsstActTypeByAttribute(ctx, asstHGAttribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsstActTypeInfo findAsstActTypeByAttributeFromCache(Context ctx, String asstHGAttribute) throws BOSException {
        Map<String, AsstActTypeInfo> map = this.asstActTypes;
        synchronized (map) {
            if (this.asstActTypes.containsKey(asstHGAttribute)) {
                return this.asstActTypes.get(asstHGAttribute);
            }
            AsstActTypeInfo asstActType = VoucherProcessCache.doFindAsstActTypeByAttribute(ctx, asstHGAttribute);
            this.asstActTypes.put(asstHGAttribute, asstActType);
            return asstActType;
        }
    }

    private static AsstActTypeInfo doFindAsstActTypeByAttribute(Context ctx, String asstHGAttribute) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("asstHGAttribute");
        selector.add("realtionDataObject");
        selector.add("mappingFieldName");
        selector.add("groupTableName");
        selector.add("isMultilevel");
        selector.add("useLongNumber");
        selector.add("glAsstActTypeGrp.*");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", (Object)asstHGAttribute));
        AsstActTypeInfo type = null;
        AsstActTypeCollection coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
        if (coll.size() > 0) {
            type = coll.get(0);
        }
        return type;
    }

    public static AsstActTypeCollection getAsstActTypes(Context ctx, String caaId) throws BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.getAsstActTypesFromCache(ctx, caaId);
        }
        return VoucherProcessCache.doGetAsstActTypes(ctx, caaId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsstActTypeCollection getAsstActTypesFromCache(Context ctx, String caaId) throws BOSException {
        Map<String, AsstActTypeCollection> map = this.asstActTypess;
        synchronized (map) {
            if (this.asstActTypess.containsKey(caaId)) {
                return this.asstActTypess.get(caaId);
            }
            AsstActTypeCollection asstActTypes = VoucherProcessCache.doGetAsstActTypes(ctx, caaId);
            this.asstActTypess.put(caaId, asstActTypes);
            return asstActTypes;
        }
    }

    public static AsstActTypeCollection doGetAsstActTypes(Context ctx, String caaId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.groupTableName"));
        sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        sic.add(new SelectorItemInfo("asstActType.isQty"));
        sic.add(new SelectorItemInfo("asstActType.groupMappingFieldName"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("seq"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        return asstActTypes;
    }

    public static Map<String, Object> findAsstActByIds(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.finder.findAsstActByIds(ctx, asstActType, asstActIds, company, cuId, userId);
        }
        return new AsstActFinder().findAsstActByIds(ctx, asstActType, asstActIds, company, cuId, userId);
    }

    public static Map<String, Object> findUserPropertiesByIds(Context ctx, String userPropertyType, Set<String> userPropertyIds, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.finder.findUserPropertiesByIds(ctx, userPropertyType, userPropertyIds, company, cuId, userId);
        }
        return new AsstActFinder().findUserPropertiesByIds(ctx, userPropertyType, userPropertyIds, company, cuId, userId);
    }

    public static Map<String, Object> findAsstActByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            return cache.finder.findAsstActByNumbers(ctx, asstActType, asstActNumbers, company, cuId, userId);
        }
        return new AsstActFinder().findAsstActByNumbers(ctx, asstActType, asstActNumbers, company, cuId, userId);
    }

    public IObjectValue getDataBaseInfo(Context ctx, BOSUuid bosid) throws BOSException {
        String key;
        if (this.dataBaseMap == null) {
            this.dataBaseMap = new HashMap<String, IObjectValue>();
        }
        if (this.dataBaseMap.containsKey(key = bosid.getType() + "_" + bosid.toString())) {
            return this.dataBaseMap.get(key);
        }
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue dataInfo = iDynamicObject.getValue(bosid.getType(), (IObjectPK)new ObjectUuidPK(bosid));
        this.dataBaseMap.put(key, dataInfo);
        return dataInfo;
    }

    public DataBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, String number, String name, String cuid, CompanyOrgUnitInfo company) throws BOSException {
        if (this.asstActObjects == null) {
            this.asstActObjects = new HashMap<String, DataBaseInfo>();
        }
        String key = asstHGAttribute + "_" + cuid + "_";
        key = key + (company == null ? "nocompany" : company.getId().toString()) + "_";
        if (this.asstActObjects.containsKey(key = key + number)) {
            return this.asstActObjects.get(key);
        }
        DataBaseInfo info = GlWebServiceUtil.findAsstActObject(ctx, asstHGAttribute, number, name, cuid, company);
        this.asstActObjects.put(key, info);
        return info;
    }

    public AssistantHGInfo findAssistantHG(Context ctx, AsstAccountInfo caa, AsstActTypeCollection types, AssistantHGInfo inHg) throws BOSException, EASBizException {
        String key = caa.getId().toString();
        for (int i = 0; i < types.size(); ++i) {
            AsstActTypeInfo type = types.get(i);
            String attr = type.getAsstHGAttribute();
            DataBaseInfo dataInfo = (DataBaseInfo)inHg.get(attr);
            key = key + "_" + attr + "_" + (dataInfo != null ? dataInfo.getId().toString() : "");
        }
        if (this.assistantHGs == null) {
            this.assistantHGs = new HashMap<String, AssistantHGInfo>();
        }
        if (this.assistantHGs.containsKey(key)) {
            return this.assistantHGs.get(key);
        }
        AssistantHGInfo info = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(inHg, caa.getId().toString(), types);
        info.setAsstAccount(caa);
        if (info.getDisplayNameGroup() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("displayNameGroup");
            AssistantHGInfo temp = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(info.getId()), selector);
            info.setDisplayNameGroup(temp.getDisplayNameGroup());
        }
        this.assistantHGs.put(key, info);
        return info;
    }

    public MeasureUnitInfo findMeasureUnitByName(Context ctx, String measureUnitGroupID, String strName) throws BOSException {
        String key;
        if (this.measureUnits == null) {
            this.measureUnits = new HashMap<String, MeasureUnitInfo>();
        }
        if (this.measureUnits.containsKey(key = measureUnitGroupID + "_" + strName)) {
            return this.measureUnits.get(key);
        }
        MeasureUnitInfo info = GlWebServiceUtil.findMeasureUnitByName(ctx, measureUnitGroupID, strName);
        this.measureUnits.put(key, info);
        return info;
    }

    public SettlementTypeInfo findSettelmentType(Context ctx, String number) throws BOSException {
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        if (this.settlementType2s == null) {
            this.settlementType2s = new HashMap<String, SettlementTypeInfo>();
        }
        if (this.settlementType2s.containsKey(number = number.trim())) {
            return this.settlementType2s.get(number);
        }
        SettlementTypeInfo info = GlWebServiceUtil.findSettelmentType(ctx, number);
        this.settlementType2s.put(number, info);
        return info;
    }

    public SettlementTypeInfo findSettelmentTypeByName(Context ctx, String strName) throws BOSException {
        if (strName == null || strName.trim().length() == 0) {
            return null;
        }
        if (this.settlementTypes == null) {
            this.settlementTypes = new HashMap<String, SettlementTypeInfo>();
        }
        if (this.settlementTypes.containsKey(strName = strName.trim())) {
            return this.settlementTypes.get(strName);
        }
        SettlementTypeInfo info = GlWebServiceUtil.findSettelmentTypeByName(ctx, strName);
        this.settlementTypes.put(strName, info);
        return info;
    }

    public boolean checkAccountAndCurrency(Context ctx, AccountViewInfo acc, CurrencyInfo cur, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        String baseCurId = company.getBaseCurrency().getId().toString();
        if (baseCurId.equals(cur.getId().toString())) {
            return true;
        }
        if (acc.getAccountingcurrency().getValue() == 1) {
            AccountCurrencyCollection cc = acc.getAccountCurrency();
            Iterator iter = cc.iterator();
            boolean hasON = false;
            while (iter.hasNext()) {
                CurrencyInfo curInfo = ((AccountCurrencyInfo)iter.next()).getCurrency();
                String curId = curInfo.getId().toString();
                if (!curId.equals(cur.getId().toString())) continue;
                hasON = true;
            }
            return hasON;
        }
        return acc.getAccountingcurrency().getValue() == 2;
    }

    public Object[] getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo currencyInfo, PeriodInfo period, Date bookDate) throws EASBizException, BOSException {
        String key;
        if (this.exchangeRates == null) {
            this.exchangeRates = new HashMap<String, Object[]>();
        }
        if (this.exchangeRates.containsKey(key = companyOrgUnitInfo.getId().toString() + "_" + currencyInfo.getId().toString() + "_" + period.getId().toString() + "_" + bookDate)) {
            return this.exchangeRates.get(key);
        }
        Object[] exchangeRate = GlWebServiceUtil.getExchangeRateByBookDate(ctx, companyOrgUnitInfo, currencyInfo, period, bookDate);
        this.exchangeRates.put(key, exchangeRate);
        return exchangeRate;
    }

    public boolean isMasterBook(Context ctx, String companyId) {
        if (this.masterBooks == null) {
            this.masterBooks = new HashMap<String, Boolean>();
        }
        if (this.masterBooks.containsKey(companyId)) {
            return this.masterBooks.get(companyId);
        }
        boolean r = BooksUtil.isMasterBook((Context)ctx, (String)companyId);
        this.masterBooks.put(companyId, r);
        return r;
    }

    public List<Map<String, String>> getAsstValidators(Context ctx) {
        if (this.asstValidators != null) {
            return this.asstValidators;
        }
        this.asstValidators = new ArrayList<Map<String, String>>();
        try {
            String checkSql = "select FHGDataBaseCreator,FasstHGAttribute from T_GL_HGDataBaseBuilder Where ftype = ?";
            IRowSet interfaceRs = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{"voucherAssistValidator"});
            while (interfaceRs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("FasstHGAttribute", interfaceRs.getString("FasstHGAttribute"));
                map.put("FHGDataBaseCreator", interfaceRs.getString("FHGDataBaseCreator"));
                this.asstValidators.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return this.asstValidators;
    }

    private boolean isAllowImportCtrAccount(Context ctx) {
        if (this.sysParams.containsKey("GL_IMPORT_CTRACCONT")) {
            return (Boolean)this.sysParams.get("GL_IMPORT_CTRACCONT");
        }
        String sql = "select fdefaultval_l2 val from t_bas_param where fnumber = 'GL_IMPORT_CTRACCONT'";
        boolean isAllowImportCtrAccount = true;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                isAllowImportCtrAccount = "true".equalsIgnoreCase(rs.getString("val"));
                this.sysParams.put("GL_IMPORT_CTRACCONT", isAllowImportCtrAccount);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
        return isAllowImportCtrAccount;
    }

    public void putAsstActInfoForAcNotice(String asstActId, boolean value) {
        if (this.asstActInfoForAcNotice == null) {
            this.asstActInfoForAcNotice = new HashMap<String, Boolean>();
        }
        this.asstActInfoForAcNotice.put(asstActId, value);
    }

    public Map<String, Boolean> getAsstAcInfoForAcNotice() {
        return this.asstActInfoForAcNotice;
    }
}

