/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check;

import com.kingdee.eas.fi.gl.check.CheckGroupType;
import java.math.BigDecimal;
import java.util.List;

public class BigDecimalCalcEngine {
    public static BigDecimal calc(CheckGroupType groupType, List<BigDecimal> values) {
        BigDecimal result = null;
        if (groupType == CheckGroupType.SUM) {
            result = BigDecimalCalcEngine.sum(values);
        } else if (groupType == CheckGroupType.AVG) {
            result = BigDecimalCalcEngine.avg(values);
        } else if (groupType == CheckGroupType.MAX) {
            result = BigDecimalCalcEngine.max(values);
        } else if (groupType == CheckGroupType.MIN) {
            result = BigDecimalCalcEngine.min(values);
        }
        return result;
    }

    public static BigDecimal sum(List<BigDecimal> values) {
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            sum = sum.add(value);
        }
        return sum;
    }

    public static BigDecimal avg(List<BigDecimal> values) {
        BigDecimal sum = BigDecimalCalcEngine.sum(values);
        BigDecimal avg = sum.divide(new BigDecimal(values.size())).setScale(sum.scale(), 4);
        return avg;
    }

    public static BigDecimal max(List<BigDecimal> values) {
        BigDecimal max = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            if (value.compareTo(max) <= 0) continue;
            max = value;
        }
        return max;
    }

    public static BigDecimal min(List<BigDecimal> values) {
        BigDecimal min = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            if (value.compareTo(min) >= 0) continue;
            min = value;
        }
        return min;
    }
}

