/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.check.CheckSchemeAssignFacadeFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeCollection;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.client.AbstractCheckSchemeAssignUI;
import com.kingdee.eas.fi.gl.check.client.CheckResourceUtil;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckSchemeAssignUI
extends AbstractCheckSchemeAssignUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckSchemeAssignUI.class);
    private final String NUMBER = "number";
    private final String NAME = "name";
    private List orgIds = new ArrayList();
    private List checkSchemeIds = new ArrayList();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initStyle();
        this.loadOrgTable();
        this.loadSchemeTable();
        this.attachListeners();
    }

    public void initStyle() {
        this.orgSearchCmBox.removeAllItems();
        this.schemeSearchComBox.removeAllItems();
        Object[] filterItems = this.getFilterItems();
        this.orgSearchCmBox.addItems(filterItems);
        this.schemeSearchComBox.addItems(filterItems);
        this.orgKDTable.checkParsed();
        this.orgKDTable.setScrollStateVertical(0);
        this.schemeKDTable.checkParsed();
        this.schemeKDTable.setScrollStateVertical(0);
        this.orgTableAllSelectBtn.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.orgTableAllCleanBtn.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.schemeTableAllSelectBtn.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.schemeTableAllCleanBtn.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.assignkDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.unAssignkDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
    }

    public FilterItem[] getFilterItems() {
        String number = CheckResourceUtil.getString("Number");
        String name = CheckResourceUtil.getString("Name");
        FilterItem[] filterItems = new FilterItem[]{new FilterItem("number", number), new FilterItem("name", name)};
        return filterItems;
    }

    public void loadOrgTable() throws BOSException, EASBizException {
        this.orgKDTable.removeRows();
        this.orgIds.clear();
        EntityViewInfo view = this.getOrgEntityView();
        FullOrgUnitCollection orgCollection = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        this.fillOrgTableData(orgCollection);
    }

    public EntityViewInfo getOrgEntityView() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)0));
        view.setFilter(filter);
        FilterItem filterItem = (FilterItem)this.orgSearchCmBox.getSelectedItem();
        String orgTxt = this.orgSearchTxt.getText();
        if (!StringUtils.isEmpty((String)orgTxt)) {
            String orgSearchFilter = CheckUtil.getSqlFulltLike(orgTxt);
            if ("number".equals(filterItem.getType())) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgSearchFilter, CompareType.LIKE));
            } else if ("name".equals(filterItem.getType())) {
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)orgSearchFilter, CompareType.LIKE));
            }
        }
        CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        String currentOrgId = CheckUtil.getCurrentOrgId(null);
        String ctrlLongNumber = currentCtrlUnit.getLongNumber();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(ctrlLongNumber + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)currentOrgId, CompareType.NOTEQUALS));
        return view;
    }

    public void fillOrgTableData(FullOrgUnitCollection orgCollection) {
        if (orgCollection == null) {
            return;
        }
        for (int i = 0; i < orgCollection.size(); ++i) {
            FullOrgUnitInfo fullOrgUnitInfo = orgCollection.get(i);
            IRow row = this.orgKDTable.addRow();
            row.getCell("id").setValue((Object)fullOrgUnitInfo.getId().toString());
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("number").setValue((Object)fullOrgUnitInfo.getNumber());
            row.getCell("name").setValue((Object)fullOrgUnitInfo.getName());
        }
    }

    public void loadSchemeTable() throws EASBizException, BOSException {
        this.schemeKDTable.removeRows();
        this.checkSchemeIds.clear();
        Map params = this.getQueryCheckSchemeParams();
        CheckSchemeCollection checkSchemes = CheckSchemeAssignFacadeFactory.getRemoteInstance().getCheckSchemes(this.orgIds, params);
        this.fillCheckSchemeTableData(checkSchemes);
    }

    private void fillCheckSchemeTableData(CheckSchemeCollection checkSchemes) {
        if (checkSchemes == null) {
            return;
        }
        for (int i = 0; i < checkSchemes.size(); ++i) {
            CheckSchemeInfo checkSchemeInfo = checkSchemes.get(i);
            IRow row = this.schemeKDTable.addRow();
            row.getCell("id").setValue((Object)checkSchemeInfo.getId().toString());
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("number").setValue((Object)checkSchemeInfo.getNumber());
            row.getCell("name").setValue((Object)checkSchemeInfo.getName());
            row.getCell("system").setValue(checkSchemeInfo.getSubSystem() != null ? checkSchemeInfo.getSubSystem().getAlias() : null);
            row.getCell("configType").setValue((Object)checkSchemeInfo.getCtrlConfigType().getAlias());
            row.getCell("bizObj").setValue(checkSchemeInfo.getConfig() != null ? checkSchemeInfo.getConfig().getBizName() : null);
        }
    }

    private Map getQueryCheckSchemeParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queryType", this.assignedRadioBtn.isSelected() ? "1" : (this.unAssignedRadioBtn.isSelected() ? "2" : null));
        params.put("searchFilterStr", this.schemeSearchTxt.getText());
        String searchFilterType = ((FilterItem)this.orgSearchCmBox.getSelectedItem()).getType();
        params.put("searcheFilterType", "number".equals(searchFilterType) ? "1" : ("name".equals(searchFilterType) ? "2" : null));
        return params;
    }

    private List getOrgIds() {
        ArrayList<String> orgIdList = new ArrayList<String>();
        int orgTableRowCount = this.orgKDTable.getRowCount();
        for (int i = 0; i < orgTableRowCount; ++i) {
            boolean isSelected = (Boolean)this.orgKDTable.getRow(i).getCell("selected").getValue();
            if (!isSelected) continue;
            String orgId = (String)this.orgKDTable.getRow(i).getCell("id").getValue();
            orgIdList.add(orgId);
        }
        return orgIdList;
    }

    private List getSchemeIds() {
        ArrayList<String> schemeIdList = new ArrayList<String>();
        int schemeTableRowCount = this.schemeKDTable.getRowCount();
        for (int i = 0; i < schemeTableRowCount; ++i) {
            boolean isSelected = (Boolean)this.schemeKDTable.getRow(i).getCell("selected").getValue();
            if (!isSelected) continue;
            String schemeId = (String)this.schemeKDTable.getRow(i).getCell("id").getValue();
            schemeIdList.add(schemeId);
        }
        return schemeIdList;
    }

    public void attachListeners() {
        this.orgKDTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 1) {
                    try {
                        String orgId = (String)CheckSchemeAssignUI.this.orgKDTable.getRow(e.getRowIndex()).getCell("id").getValue();
                        if (((Boolean)e.getValue()).booleanValue()) {
                            CheckSchemeAssignUI.this.orgIds.add(orgId);
                        } else {
                            CheckSchemeAssignUI.this.orgIds.remove(orgId);
                        }
                        CheckSchemeAssignUI.this.loadSchemeTable();
                        CheckSchemeAssignUI.this.setAssignAndUnAssignBtnStatus();
                    }
                    catch (Exception e1) {
                        logger.error((Object)"load schemeTable data exception.", (Throwable)e1);
                        CheckSchemeAssignUI.this.handUIException(e1);
                    }
                }
            }
        });
        this.schemeKDTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 1) {
                    String schemeId = (String)CheckSchemeAssignUI.this.schemeKDTable.getRow(e.getRowIndex()).getCell("id").getValue();
                    if (((Boolean)e.getValue()).booleanValue()) {
                        CheckSchemeAssignUI.this.checkSchemeIds.add(schemeId);
                    } else {
                        CheckSchemeAssignUI.this.checkSchemeIds.remove(schemeId);
                    }
                    CheckSchemeAssignUI.this.setAssignAndUnAssignBtnStatus();
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOrgSearch_actionPerformed(ActionEvent e) throws Exception {
        this.loadOrgTable();
    }

    @Override
    public void actionCheckSchemeSearch_actionPerformed(ActionEvent e) throws Exception {
        this.loadSchemeTable();
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        this.assign(true);
    }

    @Override
    public void actionUnAssign_actionPerformed(ActionEvent e) throws Exception {
        this.assign(false);
    }

    private void assign(boolean assign) throws EASBizException, BOSException {
        if (this.checkSelected()) {
            if (assign) {
                CheckSchemeAssignFacadeFactory.getRemoteInstance().assign(this.orgIds, this.checkSchemeIds);
            } else {
                CheckSchemeAssignFacadeFactory.getRemoteInstance().unAssign(this.orgIds, this.checkSchemeIds);
            }
            this.loadSchemeTable();
        } else {
            MsgBox.showInfo((String)CheckResourceUtil.getString("NoSelectData"));
        }
    }

    @Override
    public void actionAssigned_actionPerformed(ActionEvent e) throws Exception {
        this.assignkDWorkButton.setEnabled(false);
        this.unAssignkDWorkButton.setEnabled(true);
        this.unAssignedRadioBtn.setSelected(false);
        this.loadSchemeTable();
    }

    @Override
    public void actionUnAssigned_actionPerformed(ActionEvent e) throws Exception {
        this.unAssignkDWorkButton.setEnabled(false);
        this.assignkDWorkButton.setEnabled(true);
        this.assignedRadioBtn.setSelected(false);
        this.loadSchemeTable();
    }

    @Override
    public void actionOrgAllSelect_actionPerformed(ActionEvent e) throws Exception {
        this.allSelectOrClean(this.orgKDTable, Boolean.TRUE);
        this.orgIds = this.getOrgIds();
        this.loadSchemeTable();
        this.setAssignAndUnAssignBtnStatus();
    }

    @Override
    public void actionOrgAllClean_actionPerformed(ActionEvent e) throws Exception {
        this.allSelectOrClean(this.orgKDTable, Boolean.FALSE);
        this.orgIds.clear();
        this.loadSchemeTable();
        this.setAssignAndUnAssignBtnStatus();
    }

    @Override
    public void actionSchemeAllSelect_actionPerformed(ActionEvent e) throws Exception {
        this.allSelectOrClean(this.schemeKDTable, Boolean.TRUE);
        this.checkSchemeIds = this.getSchemeIds();
        this.setAssignAndUnAssignBtnStatus();
    }

    @Override
    public void actionSchemeAllClean_actionPerformed(ActionEvent e) throws Exception {
        this.allSelectOrClean(this.schemeKDTable, Boolean.FALSE);
        this.checkSchemeIds.clear();
        this.setAssignAndUnAssignBtnStatus();
    }

    private void allSelectOrClean(KDTable table, boolean select) {
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            table.getRow(i).getCell("selected").setValue((Object)select);
        }
    }

    private boolean checkSelected() {
        return this.orgIds.size() > 0 && this.checkSchemeIds.size() > 0;
    }

    private void setAssignAndUnAssignBtnStatus() {
        if (this.orgIds.size() > 0 && this.checkSchemeIds.size() > 0) {
            if (this.assignedRadioBtn.isSelected()) {
                this.assignkDWorkButton.setEnabled(false);
                this.unAssignkDWorkButton.setEnabled(true);
            } else if (this.unAssignedRadioBtn.isSelected()) {
                this.assignkDWorkButton.setEnabled(true);
                this.unAssignkDWorkButton.setEnabled(false);
            }
        } else {
            this.assignkDWorkButton.setEnabled(false);
            this.unAssignkDWorkButton.setEnabled(false);
        }
    }

    public class FilterItem {
        private String type;
        private String displayName;

        public FilterItem(String type, String displayName) {
            this.type = type;
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }

        public String getType() {
            return this.type;
        }
    }
}

