/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.check.CheckSchemeJobFactory;
import com.kingdee.eas.fi.gl.check.client.AbstractCheckSchemeJobListUI;
import com.kingdee.eas.fi.gl.check.client.CheckResourceUtil;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class CheckSchemeJobListUI
extends AbstractCheckSchemeJobListUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckSchemeJobListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.initStyle();
    }

    protected void initStyle() {
        this.checkWbtn.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
    }

    public void initTable() {
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        StringBuilder errorMsg = new StringBuilder();
        ArrayList<String> executedSmAndOrg = new ArrayList<String>();
        for (int i = 0; i < selectedRows.length; ++i) {
            try {
                String key;
                String jobId = this.tblMain.getRow(selectedRows[i]).getCell("id").getValue().toString();
                String schemeNumber = (String)this.tblMain.getRow(selectedRows[i]).getCell("scheme.number").getValue();
                String orgNumber = (String)this.tblMain.getRow(selectedRows[i]).getCell("org.number").getValue();
                if (schemeNumber == null || orgNumber == null || executedSmAndOrg.contains(key = schemeNumber + orgNumber)) continue;
                executedSmAndOrg.add(key);
                CheckSchemeJobFactory.getRemoteInstance().check(jobId);
                continue;
            }
            catch (EASBizException e1) {
                errorMsg.append(e1.getMessage()).append("\n");
            }
        }
        if (errorMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)CheckResourceUtil.getString("operateFailed"), (String)(CheckResourceUtil.getString("failMsg") + "\r\n" + errorMsg.toString()), (int)2);
        }
        this.refreshList();
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev == null) {
            return;
        }
        FilterInfo customFilter = this.customFilter();
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            filterInfo = customFilter;
        } else {
            try {
                filterInfo.mergeFilter(customFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"query checkJob exception.", (Throwable)e);
                this.handleException((Exception)((Object)e));
            }
        }
        ev.setFilter(filterInfo);
        this.mainQuery.setFilter(filterInfo);
        if (ev.getSorter() == null || ev.getSorter().size() == 0) {
            SorterItemCollection sic = new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo("startTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            sic.add(sorterItemInfo);
            ev.setSorter(sic);
        }
        super.beforeExcutQuery(ev);
    }

    private FilterInfo customFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("org.id", (Object)CheckUtil.getCurrentOrgId(null)));
        List schemeIds = (List)this.getUIContext().get("schemeIds");
        if (schemeIds != null && schemeIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("scheme.id", new HashSet(schemeIds), CompareType.INCLUDE));
            this.getUIContext().remove("schemeIds");
        }
        return filterInfo;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void refreshList() throws Exception {
        super.refreshList();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckSchemeJobFactory.getRemoteInstance();
    }
}

