/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryParam;
import com.kingdee.eas.base.job.QuartzParser;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.risk.LogicType;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.check.CheckConfigInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeGroupInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeScheduleFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeScheduleInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeScheduleType;
import com.kingdee.eas.fi.gl.check.CommonFilterEntity;
import com.kingdee.eas.fi.gl.check.ConfigType;
import com.kingdee.eas.fi.gl.check.GroupFilterEntity;
import com.kingdee.eas.fi.gl.check.SchemeStatus;
import com.kingdee.eas.fi.gl.check.client.AbstractClosePeriodCheckSchemeEditUI;
import com.kingdee.eas.fi.gl.check.client.CheckResourceUtil;
import com.kingdee.eas.fi.gl.check.client.CommonFilterUI;
import com.kingdee.eas.fi.gl.check.client.FormulaFilterUI;
import com.kingdee.eas.fi.gl.check.client.GroupFilterUI;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ClosePeriodCheckSchemeEditUI
extends AbstractClosePeriodCheckSchemeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ClosePeriodCheckSchemeEditUI.class);
    private final int maxNumberLength = 100;
    private final int maxNameLength = 100;
    private Set<SystemEnum> allSubSystem = new HashSet<SystemEnum>();
    private String scheduleXML = "";
    private ScheduleDef sdef = null;
    private SchemeStatus currentSchemeStatus = SchemeStatus.add;
    private String[] fieldsForQuery = new String[]{"orgUnit.id", "period.id"};

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
        this.initStyle();
        this.initBtnStatus();
        this.attachListeners();
        this.initBizPromptConfigType();
        this.initResponsiblesF7();
    }

    protected void initBtnStatus() {
        if (this.currentSchemeStatus == SchemeStatus.enable) {
            this.actionEdit.setEnabled(false);
        }
        this.setComponetStatus();
    }

    private void disableComponent() {
        this.txtNumber.setEnabled(false);
        this.multiLangName.setEnabled(false);
        this.comboCtrlType.setEnabled(false);
        this.comboCtrlConfigType.setEnabled(false);
        this.comboSubSystem.setEnabled(false);
        this.prmtConfig.setEnabled(false);
        this.filterWbtn.setEnabled(false);
        this.groupFilterWbtn.setEnabled(false);
        this.formulaFilterWbtn.setEnabled(false);
        this.scheduleWbtn.setEnabled(false);
        this.sendMsg.setEnabled(false);
        this.sendTxtMsg.setEnabled(false);
        this.sendEmail.setEnabled(false);
        this.setNotEditComponent();
    }

    protected void initData() throws Exception {
        Map initData = CheckSchemeFactory.getRemoteInstance().fetchInitData(null);
        this.allSubSystem = (Set)initData.get("allSubSystem");
    }

    protected void initStyle() throws Exception {
        this.comboSubSystem.removeAllItems();
        this.comboSubSystem.addItems(this.allSubSystem.toArray());
        if (this.editData != null) {
            this.comboSubSystem.setSelectedItem((Object)this.editData.getSubSystem());
        }
        this.filterWbtn.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.groupFilterWbtn.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.formulaFilterWbtn.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.scheduleWbtn.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.filterWbtn.setEnabled(true);
        this.groupFilterWbtn.setEnabled(true);
        this.formulaFilterWbtn.setEnabled(true);
        this.setComponentStatus();
        this.setNotEditComponent();
    }

    private void setComponentStatus() {
        if (this.editData != null) {
            this.setComponentStatusByConfigType(this.editData.getCtrlConfigType());
            if (this.currentSchemeStatus == SchemeStatus.enable) {
                this.scheduleWbtn.setEnabled(false);
            } else {
                this.scheduleWbtn.setEnabled(true);
            }
        }
    }

    private void setNotEditComponent() {
        this.txtFilterDes.setEditable(false);
        this.txtGroupFilterDes.setEditable(false);
        this.txtFormulaFilterDes.setEditable(false);
        this.scheduleTxt.setEditable(false);
    }

    private void initResponsiblesF7() {
        this.prmtResponsibles.setEditFormat("$number$");
        this.prmtResponsibles.setDisplayFormat("$name$");
        this.prmtResponsibles.setCommitFormat("$number$;$name$");
        HashMap<String, ClosePeriodCheckSchemeEditUI> ctx = new HashMap<String, ClosePeriodCheckSchemeEditUI>();
        ctx.put("Owner", this);
        PersonPromptBox ppBox = new PersonPromptBox(ctx);
        ppBox.showNoPositionPerson(false);
        ppBox.setEnabledMultiSelection(false);
        ppBox.setIsSingleSelect(false);
        ppBox.showAllAdmin();
        this.prmtResponsibles.setSelector((KDPromptSelector)ppBox);
        this.prmtResponsibles.setEditable(false);
        this.prmtResponsibles.setEnabledMultiSelection(false);
    }

    protected void attachListeners() {
        this.comboCtrlConfigType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ClosePeriodCheckSchemeEditUI.this.prmtConfig.setValue(null);
                    ClosePeriodCheckSchemeEditUI.this.setBizPromptConfigEntityView();
                    ClosePeriodCheckSchemeEditUI.this.setComponentStatusByConfigType((ConfigType)((Object)e.getItem()));
                }
            }
        });
        this.comboSubSystem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ClosePeriodCheckSchemeEditUI.this.prmtConfig.setValue(null);
                    ClosePeriodCheckSchemeEditUI.this.setBizPromptConfigEntityView();
                }
            }
        });
        this.prmtConfig.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (ClosePeriodCheckSchemeEditUI.this.isPrmtConfigChanged(e)) {
                    ClosePeriodCheckSchemeEditUI.this.txtFilterDes.setText(null);
                    ClosePeriodCheckSchemeEditUI.this.editData.setFilter(null);
                    ClosePeriodCheckSchemeEditUI.this.editData.setFilterDes(null);
                    ClosePeriodCheckSchemeEditUI.this.txtGroupFilterDes.setText(null);
                    ClosePeriodCheckSchemeEditUI.this.editData.setGroupFilter(null);
                    ClosePeriodCheckSchemeEditUI.this.editData.setGroupFilterDes(null);
                }
            }
        });
    }

    protected boolean isPrmtConfigChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            return e.getOldValue() != null;
        }
        if (e.getOldValue() == null) {
            return true;
        }
        CheckConfigInfo newValue = (CheckConfigInfo)e.getNewValue();
        CheckConfigInfo oldValue = (CheckConfigInfo)e.getOldValue();
        return !newValue.getId().toString().equals(oldValue.getId().toString());
    }

    private void setComponentStatusByConfigType(ConfigType configType) {
        if (ConfigType.formula == configType) {
            this.formulaFilterWbtn.setEnabled(true);
            this.txtFormulaFilterDes.setText(this.editData.getFormulaFilterDes());
            this.contSubSystem.setEnabled(false);
            this.contConfig.setEnabled(false);
            this.filterWbtn.setEnabled(false);
            this.groupFilterWbtn.setEnabled(false);
            this.comboSubSystem.setSelectedItem(null);
            this.prmtConfig.setValue(null);
            this.txtFilterDes.setText(null);
            this.txtGroupFilterDes.setText(null);
        } else if (ConfigType.bizObj == configType) {
            this.contSubSystem.setEnabled(true);
            this.contConfig.setEnabled(true);
            this.filterWbtn.setEnabled(true);
            this.groupFilterWbtn.setEnabled(true);
            this.txtFilterDes.setText(this.editData.getFilterDes());
            this.txtGroupFilterDes.setText(this.editData.getGroupFilterDes());
            this.formulaFilterWbtn.setEnabled(false);
            this.txtFormulaFilterDes.setText(null);
        } else if (ConfigType.plugIn == configType) {
            this.contSubSystem.setEnabled(true);
            this.filterWbtn.setEnabled(false);
            this.groupFilterWbtn.setEnabled(false);
            this.formulaFilterWbtn.setEnabled(false);
            this.txtFilterDes.setText(null);
            this.txtGroupFilterDes.setText(null);
            this.txtFormulaFilterDes.setText(null);
        }
    }

    private void setBizPromptConfigEntityView() {
        SystemEnum systemType = (SystemEnum)this.comboSubSystem.getSelectedItem();
        ConfigType configType = (ConfigType)((Object)this.comboCtrlConfigType.getSelectedItem());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)(systemType == null ? 6 : systemType.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("ctrlConfigType", (Object)(configType == null ? 0 : configType.getValue())));
        viewInfo.setFilter(filter);
        this.prmtConfig.setEntityViewInfo(viewInfo);
    }

    private void initBizPromptConfigType() {
        this.prmtConfig.setEditFormat("$bizNumber$");
        this.prmtConfig.setDisplayFormat("$bizName$");
        this.prmtConfig.setCommitFormat("$bizNumber$;$bizName$");
        this.setBizPromptConfigEntityView();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            String postSuccess = CheckResourceUtil.getString("InputNumber");
            MsgBox.showInfo((Component)((Object)this), (String)postSuccess);
            SysUtil.abort();
        } else if (number.length() > 100) {
            MsgBox.showInfo((Component)((Object)this), (String)CheckResourceUtil.getString("MaxNumberLength", new String[]{String.valueOf(100)}));
            SysUtil.abort();
        }
        String name = this.multiLangName.getEditor().getItem().toString();
        if (StringUtils.isEmpty((String)name)) {
            String postSuccess = CheckResourceUtil.getString("InputName");
            MsgBox.showInfo((Component)((Object)this), (String)postSuccess);
            SysUtil.abort();
        } else if (name.length() > 100) {
            MsgBox.showInfo((Component)((Object)this), (String)CheckResourceUtil.getString("MaxNameLength", new String[]{String.valueOf(100)}));
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        if (this.editData.getId() != null) {
            String currenctOrgId = CheckUtil.getCurrentOrgId(null);
            try {
                CheckSchemeOrgRelationInfo csOrInfo = CheckSchemeOrgRelationFactory.getRemoteInstance().getCheckSchemOrgRelationInfo(this.editData.getId().toString(), currenctOrgId);
                if (csOrInfo != null) {
                    this.currentSchemeStatus = csOrInfo.getSchemeStatus();
                    if (csOrInfo.getResponsibles() != null) {
                        PersonInfo perosnInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(csOrInfo.getResponsibles()));
                        this.prmtResponsibles.setValue((Object)perosnInfo);
                        this.editData.setResponsibles(perosnInfo);
                    } else {
                        this.prmtResponsibles.setValue(null);
                        this.editData.setResponsibles(null);
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (!StringUtils.isEmpty((String)this.scheduleTxt.getText()) && !StringUtils.isEmpty((String)this.scheduleXML) && this.sdef != null) {
            try {
                CheckSchemeScheduleInfo scheduleInfo = null;
                if (this.editData.getSchedule() == null) {
                    scheduleInfo = new CheckSchemeScheduleInfo();
                    this.setCheckSchemeScheduleInfo(this.scheduleXML, this.sdef, scheduleInfo);
                } else if (this.editData.getSchedule().getId() != null) {
                    ObjectUuidPK pk = new ObjectUuidPK(this.editData.getSchedule().getId());
                    scheduleInfo = CheckSchemeScheduleFactory.getRemoteInstance().getCheckSchemeScheduleInfo((IObjectPK)pk);
                    this.setCheckSchemeScheduleInfo(this.scheduleXML, this.sdef, scheduleInfo);
                }
                if (scheduleInfo != null) {
                    scheduleInfo.setDescription(this.scheduleTxt.getText());
                    this.editData.setSchedule(scheduleInfo);
                    this.editData.setScheduleDes(this.scheduleTxt.getText());
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        if (ConfigType.formula == this.editData.getCtrlConfigType()) {
            this.editData.setFilter(null);
            this.editData.setFilterDes(null);
            this.editData.setGroupFilter(null);
            this.editData.setGroupFilterDes(null);
        } else if (ConfigType.bizObj == this.editData.getCtrlConfigType()) {
            this.editData.setFormulaFilter(null);
            this.editData.setFormulaFilterDes(null);
        } else if (ConfigType.plugIn == this.editData.getCtrlConfigType()) {
            this.editData.setFilter(null);
            this.editData.setFilterDes(null);
            this.editData.setGroupFilter(null);
            this.editData.setGroupFilterDes(null);
            this.editData.setFormulaFilter(null);
            this.editData.setFormulaFilterDes(null);
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public IObjectPK runSubmit() throws Exception {
        return super.runSubmit();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setStatus(SchemeStatus.add);
        this.editData.setSchedule(null);
        this.editData.setScheduleDes(null);
        this.editData.setCreateOrg(CheckUtil.getFullOrgUnit(null, CheckUtil.getCurrentOrgId(null)));
        super.actionCopy_actionPerformed(e);
        this.setComponentStatus();
        this.setNotEditComponent();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtConfig.getValue() == null) {
            MsgBox.showInfo((String)CheckResourceUtil.getString("bizObjIsNull"));
            return;
        }
        String bizQuery = ((CheckConfigInfo)this.prmtConfig.getValue()).getBizQuery();
        if (StringUtils.isEmpty((String)bizQuery)) {
            MsgBox.showInfo((String)CheckResourceUtil.getString("NoConfigBizObj"));
            return;
        }
        Map<String, QueryFieldInfo> fieldMap = CheckUtil.getQueryPropMapping(null, bizQuery, this.getCurrentLocale());
        boolean verify = true;
        for (String field : this.fieldsForQuery) {
            verify = verify && fieldMap.containsKey(field);
        }
        if (!verify) {
            MsgBox.showInfo((String)CheckResourceUtil.getString("queryFieldVerify", new String[]{Arrays.toString(this.fieldsForQuery)}));
            return;
        }
        CommonQueryDialog commonQueryDialog = this.createCommonQueryUI(bizQuery, ((Object)((Object)this)).getClass().getName());
        String filter = this.editData.getFilter();
        if (!StringUtils.isEmpty((String)filter)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo(filter);
            entityView.setFilter(filterInfo);
            commonQueryDialog.setDefalutEntityViewInfo(entityView);
        }
        if (commonQueryDialog.show()) {
            String filterDes = this.getFilterDes(commonQueryDialog);
            EntityViewInfo entityViewInfo = commonQueryDialog.getEntityViewInfoResult();
            if (entityViewInfo != null && entityViewInfo.getFilter() != null) {
                this.txtFilterDes.setText(filterDes);
                this.editData.setFilter(entityViewInfo.getFilter().toSql());
            }
        }
    }

    private String getFilterDes(CommonQueryDialog commonQueryDialog) {
        StringBuilder filterDes = new StringBuilder();
        KDTable kdtTable = commonQueryDialog.getCommonFilterPanel().getKdtTable();
        int rowCount = kdtTable.getRowCount();
        KDTColumns columns = kdtTable.getColumns();
        block0: for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columns.size(); ++j) {
                Object value = kdtTable.getRow(i).getCell(j).getValue();
                if (j == 1 && value == null) continue block0;
                if (value != null) {
                    if (value instanceof Date) {
                        filterDes.append(CheckUtil.getFormatDate((Date)value));
                    } else if (value instanceof Object[] && ((Object[])value).length > 0) {
                        for (Object obj : (Object[])value) {
                            filterDes.append(obj.toString()).append(",");
                        }
                        filterDes.deleteCharAt(filterDes.length() - 1);
                    } else {
                        filterDes.append(value.toString());
                    }
                }
                if (value == null || j != 4 && j != 5) continue;
                filterDes.append(" ");
            }
        }
        return filterDes.toString();
    }

    private CommonQueryDialog createCommonQueryUI(String queryFullName, String parentUI) {
        CommonQueryParam commonQueryParam = new CommonQueryParam();
        commonQueryParam.setQueryObjectPK((IMetaDataPK)MetaDataPK.create((String)queryFullName));
        commonQueryParam.setParentUIClassName(parentUI);
        commonQueryParam.setShowToolbar(false);
        CommonQueryDialog commonQueryDialog = new CommonQueryDialog();
        commonQueryDialog.setCommonQueryParam(commonQueryParam);
        return commonQueryDialog;
    }

    @Override
    public void actionGroup_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtConfig.getValue() == null) {
            MsgBox.showInfo((String)CheckResourceUtil.getString("bizObjIsNull"));
            return;
        }
        String bizQuery = ((CheckConfigInfo)this.prmtConfig.getValue()).getBizQuery();
        UIContext context = new UIContext((Object)this);
        context.put("Owner", this);
        context.put("bizQuery", bizQuery);
        if (this.editData != null) {
            context.put("groupFilter", this.editData.getGroupFilter());
        }
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GroupFilterUI.class.getName(), (Map)context, null, OprtState.EDIT);
        ((JPanel)((JDialog)ui).getContentPane()).setPreferredSize(new Dimension(750, 400));
        ui.show();
        CommonFilterUI uiObject = (CommonFilterUI)ui.getUIObject();
        List<? extends CommonFilterEntity> groupFilterEntityList = uiObject.getData();
        JsonArray groupFilterJsonArray = new JsonArray();
        StringBuilder groupFilterEntityStr = new StringBuilder();
        int size = groupFilterEntityList.size();
        for (int i = 0; i < size; ++i) {
            GroupFilterEntity groupFilterEntity = (GroupFilterEntity)groupFilterEntityList.get(i);
            groupFilterEntityStr.append(groupFilterEntity.toString());
            if (i != size - 1) {
                groupFilterEntityStr.append(" ").append(groupFilterEntity.getLogicType() == null ? LogicType.AND.getName() : groupFilterEntity.getLogicType().getName()).append(" ");
            }
            JsonObject groupFilterJson = CheckUtil.groupFilterEntityToJson(groupFilterEntity);
            groupFilterJsonArray.add((JsonElement)groupFilterJson);
        }
        if (groupFilterJsonArray.size() > 0) {
            this.txtGroupFilterDes.setText(groupFilterEntityStr.toString());
            this.editData.setGroupFilterDes(groupFilterEntityStr.toString());
            this.editData.setGroupFilter(groupFilterJsonArray.toString());
        }
    }

    @Override
    public void actionFormula_actionPerformed(ActionEvent e) throws Exception {
        UIContext context = new UIContext((Object)this);
        context.put("Owner", this);
        if (this.editData != null) {
            context.put("formulaFilter", this.editData.getFormulaFilter());
        }
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormulaFilterUI.class.getName(), (Map)context, null, OprtState.EDIT);
        ((JPanel)((JDialog)ui).getContentPane()).setPreferredSize(new Dimension(645, 400));
        ui.show();
        CommonFilterUI uiObject = (CommonFilterUI)ui.getUIObject();
        List<? extends CommonFilterEntity> filterEntityList = uiObject.getData();
        JsonArray filterJsonArray = new JsonArray();
        StringBuilder filterEntityStr = new StringBuilder();
        int size = filterEntityList.size();
        for (int i = 0; i < size; ++i) {
            CommonFilterEntity filterEntity = filterEntityList.get(i);
            filterEntityStr.append(filterEntity.toString());
            if (i != size - 1) {
                filterEntityStr.append(" ").append(filterEntity.getLogicType() == null ? LogicType.AND.getName() : filterEntity.getLogicType().getName()).append(" ");
            }
            JsonObject filterJson = CheckUtil.filterEntityToJson(filterEntity);
            filterJsonArray.add((JsonElement)filterJson);
        }
        if (filterJsonArray.size() > 0) {
            this.txtFormulaFilterDes.setText(filterEntityStr.toString());
            this.editData.setFormulaFilterDes(filterEntityStr.toString());
            this.editData.setFormulaFilter(filterJsonArray.toString());
        }
    }

    @Override
    public void actionSchedule_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.scheduleXML = this.editData.getSchedule() == null ? "" : this.editData.getSchedule().getSchemeXML();
            this.scheduleXML = ProcessSchedulePlan.open((Object)((Object)this), (String)this.scheduleXML);
            if (this.scheduleXML != null && this.scheduleXML.length() > 0) {
                this.sdef = KpdlParser.parseSchedule((String)this.scheduleXML);
                QuartzParser quartzParser = new QuartzParser(this.sdef.getDefine());
                boolean useCalendar = this.sdef.isUseCalendar();
                boolean inWorkingDay = this.sdef.isInWorkingDay();
                boolean flag = this.sdef.getType().equals((Object)ScheduleType.ONETIME);
                StringBuilder scheduleText = new StringBuilder(quartzParser.parse());
                int index = scheduleText.indexOf(",") + 1;
                if (useCalendar) {
                    scheduleText.insert(index, inWorkingDay ? CheckResourceUtil.getString("workDay") : CheckResourceUtil.getString("unWorkDay"));
                }
                if (flag) {
                    scheduleText.delete(0, index);
                }
                this.scheduleTxt.setText(scheduleText.toString());
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void setCheckSchemeScheduleInfo(String scheduleXML, ScheduleDef sdef, CheckSchemeScheduleInfo scheduleInfo) {
        scheduleInfo.setBeginDate(sdef.getBeginTime());
        scheduleInfo.setScheduleType(CheckSchemeScheduleType.getEnum(sdef.getType().getName()));
        scheduleInfo.setUserDefine_val(sdef.getDefine());
        scheduleInfo.setIsSupportWorkCal(sdef.isUseCalendar());
        scheduleInfo.setSchemeXML(scheduleXML);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setComponetStatus();
    }

    private void setComponetStatus() {
        String createOrgId = this.editData.getCreateOrg().getId().toString();
        String currentOrgId = CheckUtil.getCurrentOrgId(null);
        if (this.editData.getId() != null && !currentOrgId.equals(createOrgId)) {
            this.disableComponent();
        } else {
            this.setComponentStatusByConfigType(this.editData.getCtrlConfigType());
        }
        this.setNotEditComponent();
    }

    protected IObjectValue createNewData() {
        CheckSchemeInfo checkSchemeInfo = new CheckSchemeInfo();
        Object group = this.getUIContext().get("ParentNode");
        if (group != null) {
            checkSchemeInfo.setSchemeGroup((CheckSchemeGroupInfo)group);
        }
        try {
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(CheckUtil.getCurrentOrgId(null)));
            checkSchemeInfo.setCreateOrg(fullOrgUnitInfo);
        }
        catch (Exception e) {
            logger.error((Object)"get fullOrgUnit exception.", (Throwable)e);
            this.handleException(e);
        }
        return checkSchemeInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckSchemeFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("config.*"));
        sic.add(new SelectorItemInfo("responsibles.id"));
        sic.add(new SelectorItemInfo("responsibles.name"));
        sic.add(new SelectorItemInfo("responsibles.number"));
        sic.add(new SelectorItemInfo("schemeGroup.id"));
        sic.add(new SelectorItemInfo("schemeGroup.number"));
        sic.add(new SelectorItemInfo("schemeGroup.name"));
        sic.add(new SelectorItemInfo("schedule.id"));
        sic.add(new SelectorItemInfo("schedule.schemeXML"));
        sic.add(new SelectorItemInfo("schedule.description"));
        return sic;
    }
}

