/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.check.CheckSchemeFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeGroupFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.SchemeStatus;
import com.kingdee.eas.fi.gl.check.client.AbstractClosePeriodCheckSchemeListUI;
import com.kingdee.eas.fi.gl.check.client.CheckResourceUtil;
import com.kingdee.eas.fi.gl.check.client.CheckSchemeAssignUI;
import com.kingdee.eas.fi.gl.check.client.CheckSchemeGroupEditUI;
import com.kingdee.eas.fi.gl.check.client.CheckSchemeJobListUI;
import com.kingdee.eas.fi.gl.check.client.ClosePeriodCheckSchemeEditUI;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class ClosePeriodCheckSchemeListUI
extends AbstractClosePeriodCheckSchemeListUI {
    private static final Logger logger = CoreUIObject.getLogger(ClosePeriodCheckSchemeListUI.class);
    private String schemeStatusCol = "schemeOrgR.schemeStatus";

    public void onLoad() throws Exception {
        this.initStyle();
        super.onLoad();
    }

    protected void initStyle() {
        this.assignKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.checkWbtn.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.checkSchemeJobKDBtn.setIcon(EASResource.getIcon((String)"imgTbtn_archive"));
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    int start = e.getFirstRow();
                    int end = e.getLastRow();
                    for (int i = start; i <= end; ++i) {
                        int schemeStatus = (Integer)ClosePeriodCheckSchemeListUI.this.tblMain.getRow(i).getCell(ClosePeriodCheckSchemeListUI.this.schemeStatusCol).getValue();
                        ClosePeriodCheckSchemeListUI.this.tblMain.getRow(i).getCell(ClosePeriodCheckSchemeListUI.this.schemeStatusCol).setValue((Object)SchemeStatus.getEnum(schemeStatus));
                    }
                }
                catch (Exception e2) {
                    ClosePeriodCheckSchemeListUI.this.handUIException(e2);
                }
            }
        });
    }

    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIncludeChild_itemStateChanged(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev == null) {
            return;
        }
        FilterInfo customFilter = this.getCustomFilterInfo();
        FilterInfo filter = ev.getFilter();
        if (filter == null) {
            ev.setFilter(customFilter);
        } else {
            try {
                filter.mergeFilter(customFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"merge filter exception.", (Throwable)e);
                this.handleException((Exception)((Object)e));
            }
        }
        if (ev.getSorter() == null || ev.getSorter().size() == 0) {
            SorterItemCollection sic = new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
            sic.add(sorterItemInfo);
            ev.setSorter(sic);
        }
        super.beforeExcutQuery(ev);
    }

    private FilterInfo getCustomFilterInfo() {
        String currentOrgId = CheckUtil.getCurrentOrgId(null);
        FilterInfo customFilter = new FilterInfo();
        customFilter.getFilterItems().add(new FilterItemInfo("schemeOrgR.orgId", (Object)currentOrgId));
        return customFilter;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        SchemeStatus schemeStatus = (SchemeStatus)((Object)this.tblMain.getRow(selectedRows[0]).getCell(this.schemeStatusCol).getValue());
        if (schemeStatus == SchemeStatus.enable) {
            MsgBox.showInfo((String)CheckResourceUtil.getString("canNotEditEnableSm"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList checkSchemeIds = this.getSelectedIdValues();
        CheckSchemeFactory.getRemoteInstance().disable(checkSchemeIds);
        this.refreshList();
        this.showResultMessage(CheckResourceUtil.getString("disableSuccess"));
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList checkSchemeIds = this.getSelectedIdValues();
        StringBuilder errorMsg = this.verifySchemeWhenEnable(checkSchemeIds);
        if (checkSchemeIds.size() > 0) {
            CheckSchemeFactory.getRemoteInstance().enable(checkSchemeIds);
            this.refreshList();
        }
        if (errorMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)CheckResourceUtil.getString("schemeEnableFailed"), (String)errorMsg.toString(), (int)2);
        } else {
            this.showResultMessage(CheckResourceUtil.getString("enableSuccess"));
        }
    }

    private StringBuilder verifySchemeWhenEnable(List checkSchemeIds) {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        StringBuilder errorMsg = new StringBuilder();
        for (int i = 0; i < selectedRows.length; ++i) {
            Object bizValue;
            String id = (String)this.tblMain.getRow(selectedRows[i]).getCell("id").getValue();
            String checkSchemeNumber = (String)this.tblMain.getRow(selectedRows[i]).getCell("number").getValue();
            BizEnumValueDTO configTypeValue = (BizEnumValueDTO)this.tblMain.getRow(selectedRows[i]).getCell("ctrlConfigType").getValue();
            if (0 == configTypeValue.getInt() || 2 == configTypeValue.getInt()) {
                bizValue = this.tblMain.getRow(selectedRows[i]).getCell("config.bizName").getValue();
                Object filterDes = this.tblMain.getRow(selectedRows[i]).getCell("filterDes").getValue();
                if (bizValue == null) {
                    errorMsg.append(CheckResourceUtil.getString("schemeNoBizObj", new String[]{checkSchemeNumber})).append("\n");
                    checkSchemeIds.remove(id);
                    continue;
                }
                if (filterDes != null || 0 != configTypeValue.getInt()) continue;
                errorMsg.append(CheckResourceUtil.getString("schemeNoFilter", new String[]{checkSchemeNumber})).append("\n");
                checkSchemeIds.remove(id);
                continue;
            }
            if (1 != configTypeValue.getInt()) continue;
            bizValue = this.tblMain.getRow(selectedRows[i]).getCell("formulaFilterDes").getValue();
            Object formulaFilter = this.tblMain.getRow(selectedRows[i]).getCell("formulaFilterDes").getValue();
            if (bizValue == null) {
                errorMsg.append(CheckResourceUtil.getString("schemeNoFormula", new String[]{checkSchemeNumber})).append("\n");
                checkSchemeIds.remove(id);
                continue;
            }
            if (formulaFilter != null) continue;
            errorMsg.append(CheckResourceUtil.getString("schemeNoFormulaFilter", new String[]{checkSchemeNumber})).append("\n");
            checkSchemeIds.remove(id);
        }
        return errorMsg;
    }

    private void showResultMessage(String message) {
        this.setMessageText(message);
        this.showMessage();
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectedRows.length; ++i) {
            SchemeStatus statusValue = (SchemeStatus)((Object)this.tblMain.getRow(selectedRows[i]).getCell(this.schemeStatusCol).getValue());
            if (statusValue == SchemeStatus.enable) continue;
            MsgBox.showInfo((String)CheckResourceUtil.getString("existsDisableStatusScheme"));
            return;
        }
        try {
            ArrayList checkSchemeIds = this.getSelectedIdValues();
            CheckSchemeFactory.getRemoteInstance().checkByCheckScheme(checkSchemeIds);
            this.showResultMessage(CheckResourceUtil.getString("taskHasSubmit"));
        }
        catch (EASBizException e1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)CheckResourceUtil.getString("operateFailed"), (String)(CheckResourceUtil.getString("failMsg") + "\r\n" + e1.getMessage()), (int)2);
        }
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CheckSchemeAssignUI.class.getName(), this.getUIContext(), null);
        ui.show();
    }

    @Override
    public void actionLinkJob_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList checkSchemeIds = this.getSelectedIdValues();
        UIContext context = new UIContext((Object)this);
        context.put("Owner", this);
        context.put("schemeIds", checkSchemeIds);
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CheckSchemeJobListUI.class.getName(), (Map)context, null, OprtState.VIEW);
        ui.show();
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTree_actionPerformed(e);
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        ObjectUuidPK detail = new ObjectUuidPK(this.getSelectedKeyValue());
        try {
            CheckSchemeInfo schemeInfo = (CheckSchemeInfo)this.getBizInterface().getValue((IObjectPK)detail);
            if (schemeInfo != null && schemeInfo.getSchemeGroup() != null) {
                ObjectUuidPK tree = new ObjectUuidPK(schemeInfo.getSchemeGroup().getId());
                return tree;
            }
            return null;
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return null;
        }
    }

    protected String getGroupEditUIName() {
        return CheckSchemeGroupEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getQueryFieldName() {
        return "schemeGroup.id";
    }

    protected String getRootName() {
        return CheckResourceUtil.getString("RootCheckConfigName");
    }

    protected String getSelectDetailTreeName() {
        return "schemeGroup";
    }

    protected String getEditUIName() {
        return ClosePeriodCheckSchemeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckSchemeFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return CheckSchemeGroupFactory.getRemoteInstance();
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        ItemAction action = this.getItemActionFromActionEvent(e);
        if (treeNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
        if (!action.equals(this.actionGroupAddNew) && !(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Root_CannotSelected"));
            SysUtil.abort();
        }
    }

    protected ItemAction getItemActionFromActionEvent(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof AbstractButton) {
            IItemAction act = (IItemAction)((AbstractButton)obj).getAction();
            ItemAction action = act.getItemAction();
            return action;
        }
        return null;
    }
}

