/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.risk.LogicType;
import com.kingdee.eas.fi.gl.check.CheckBracket;
import com.kingdee.eas.fi.gl.check.CheckCompareType;
import com.kingdee.eas.fi.gl.check.CommonFilterEntity;
import com.kingdee.eas.fi.gl.check.client.AbstractCommonFilterUI;
import com.kingdee.eas.fi.gl.check.client.CheckResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class CommonFilterUI
extends AbstractCommonFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CommonFilterUI.class);
    private int defaultRowCount = 10;
    protected List<CommonFilterEntity> filterEntitys = new ArrayList<CommonFilterEntity>();
    private int defaultLimitRow = 100;
    protected String leftBracketColName = "leftBracket";
    protected String compareObjSrcColName = "compareObjSrc";
    protected String compareTypeColName = "compareType";
    protected String compareObjTargetColName = "compareObjTarget";
    protected String rightBracketColName = "rightBracket";
    protected String logicTypeColName = "logicType";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTitle();
        this.initWorkButton();
        this.initTable();
        this.addNullRow();
        this.initTableRows();
    }

    protected void initTitle() {
        this.setUITitle(this.getTitle());
    }

    protected String getTitle() {
        return CheckResourceUtil.getString("filter");
    }

    protected void initWorkButton() {
        this.okKDWBtn.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.addKdWbtn.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.insertKdWbtn.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.delKdWbtn.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    protected void initTable() {
        CheckCompareType[] compareTypes;
        this.tblMain.checkParsed();
        this.tblMain.setScrollStateVertical(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        IColumn leftBracketCol = this.tblMain.getColumn(this.leftBracketColName);
        KDComboBox leftBracketBox = new KDComboBox();
        leftBracketBox.addItem((Object)CheckBracket.BLANK);
        this.fillBracket(CheckBracket.getAllLeftBrackets(), leftBracketBox);
        leftBracketCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)leftBracketBox));
        IColumn rightBracketCol = this.tblMain.getColumn(this.rightBracketColName);
        KDComboBox rightBracketBox = new KDComboBox();
        rightBracketBox.addItem((Object)CheckBracket.BLANK);
        this.fillBracket(CheckBracket.getAllRightBrackets(), rightBracketBox);
        rightBracketCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)rightBracketBox));
        IColumn compareTypeCol = this.tblMain.getColumn(this.compareTypeColName);
        KDComboBox compareTypeBox = new KDComboBox();
        for (CheckCompareType compareType : compareTypes = CheckCompareType.values()) {
            compareTypeBox.addItem((Object)compareType);
        }
        compareTypeCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)compareTypeBox));
        IColumn logicTypeCol = this.tblMain.getColumn(this.logicTypeColName);
        KDComboBox logicTypeBox = new KDComboBox();
        Iterator logicIter = LogicType.iterator();
        while (logicIter.hasNext()) {
            logicTypeBox.addItem(logicIter.next());
        }
        logicTypeCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)logicTypeBox));
    }

    private void fillBracket(CheckBracket[] checkBrackets, KDComboBox bracketBox) {
        for (CheckBracket checkBracket : checkBrackets) {
            bracketBox.addItem((Object)checkBracket);
        }
    }

    private void addNullRow() {
        int i = 0;
        do {
            this.tblMain.addRow();
        } while (++i < this.defaultRowCount);
    }

    protected void initTableRows() {
    }

    protected void fillTableRow(IRow row, CommonFilterEntity filterEntity) {
        if (row == null) {
            row = this.tblMain.addRow();
        }
        row.getCell(this.leftBracketColName).setValue((Object)filterEntity.getLeftBracket());
        row.getCell(this.compareTypeColName).setValue((Object)filterEntity.getCompareType());
        row.getCell(this.compareObjTargetColName).setValue((Object)filterEntity.getCompareObjTarget());
        row.getCell(this.rightBracketColName).setValue((Object)filterEntity.getRightBracket());
        row.getCell(this.logicTypeColName).setValue((Object)filterEntity.getLogicType());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain == null) {
            return;
        }
        if (this.tblMain.getSelectManager().size() > 0) {
            int top = this.tblMain.getSelectManager().get().getTop();
            if (this.isTableColumnSelected(this.tblMain)) {
                this.tblMain.addRow();
            } else {
                this.tblMain.addRow(top);
            }
        } else {
            this.tblMain.addRow();
        }
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Integer> selectList = new ArrayList<Integer>();
        int size = this.tblMain.getSelectManager().size();
        KDTSelectManager selectManager = this.tblMain.getSelectManager();
        for (int row = 0; row < size; ++row) {
            KDTSelectBlock selectBlock = selectManager.get(row);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            for (int i = top; i <= bottom; ++i) {
                if (this.tblMain.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                selectList.add(new Integer(i));
            }
        }
        for (int i = 0; i < selectList.size(); ++i) {
            int row = Integer.parseInt(String.valueOf(selectList.get(i))) - i;
            this.tblMain.removeRow(row);
        }
    }

    private List<String> mustInputField() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add(this.compareObjSrcColName);
        fieldList.add(this.compareTypeColName);
        fieldList.add(this.compareObjTargetColName);
        String[] addMustInputField = this.addMustInputField();
        if (addMustInputField != null && addMustInputField.length > 0) {
            for (String field : addMustInputField) {
                fieldList.add(field);
            }
        }
        return fieldList;
    }

    protected String[] addMustInputField() {
        return new String[0];
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.filterEntitys.clear();
        int leftBracketNum = 0;
        int rightBracketNum = 0;
        List<String> mustInputFields = this.mustInputField();
        int needMatchNum = mustInputFields.size();
        String[] addMustInputField = this.addMustInputField();
        int limitRow = this.limitRow();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            CheckBracket leftBracket = (CheckBracket)((Object)this.tblMain.getRow(i).getCell(this.leftBracketColName).getValue());
            Object compareObjSrc = this.tblMain.getRow(i).getCell(this.compareObjSrcColName).getValue();
            CheckCompareType compareType = (CheckCompareType)((Object)this.tblMain.getRow(i).getCell(this.compareTypeColName).getValue());
            String compareObjTarget = (String)this.tblMain.getRow(i).getCell(this.compareObjTargetColName).getValue();
            CheckBracket rightBracket = (CheckBracket)((Object)this.tblMain.getRow(i).getCell(this.rightBracketColName).getValue());
            leftBracketNum = leftBracket != null ? leftBracketNum + leftBracket.getCount() : leftBracketNum;
            rightBracketNum = rightBracket != null ? rightBracketNum + rightBracket.getCount() : rightBracketNum;
            int nullMatchNum = 0;
            if (compareObjSrc == null && mustInputFields.contains(this.compareObjSrcColName)) {
                ++nullMatchNum;
            }
            if (compareType == null && mustInputFields.contains(this.compareTypeColName)) {
                ++nullMatchNum;
            }
            if (compareObjTarget == null && mustInputFields.contains(this.compareObjTargetColName)) {
                ++nullMatchNum;
            }
            if (addMustInputField != null && addMustInputField.length > 0) {
                for (String field : addMustInputField) {
                    ICell cell = this.tblMain.getRow(i).getCell(field);
                    if (cell != null && cell.getValue() != null) continue;
                    ++nullMatchNum;
                }
            }
            if (nullMatchNum == needMatchNum) continue;
            if (nullMatchNum > 0 && needMatchNum != nullMatchNum) {
                MsgBox.showInfo((String)CheckResourceUtil.getString("filterIncomplete"));
                this.filterEntitys.clear();
                return;
            }
            if (i >= limitRow) {
                MsgBox.showInfo((String)CheckResourceUtil.getString("limitRow", new Integer[]{limitRow}));
                return;
            }
            CommonFilterEntity filterEntity = this.getFilterEntity(this.tblMain.getRow(i));
            if (filterEntity == null) continue;
            this.filterEntitys.add(filterEntity);
        }
        if (leftBracketNum != rightBracketNum) {
            MsgBox.showInfo((String)CheckResourceUtil.getString("bracketMismatching"));
            this.filterEntitys.clear();
            return;
        }
        this.getUIWindow().close();
    }

    protected CommonFilterEntity getFilterEntity(IRow row) {
        return null;
    }

    public List<? extends CommonFilterEntity> getData() {
        return this.filterEntitys;
    }

    protected Integer limitRow() {
        return this.defaultLimitRow;
    }
}

