/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.risk.LogicType;
import com.kingdee.eas.fi.gl.check.CheckBracket;
import com.kingdee.eas.fi.gl.check.CheckCompareType;
import com.kingdee.eas.fi.gl.check.CommonFilterEntity;
import com.kingdee.eas.fi.gl.check.CompareObjEntity;
import com.kingdee.eas.fi.gl.check.client.CheckResourceUtil;
import com.kingdee.eas.fi.gl.check.client.CommonFilterUI;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.client.IFormulaWizardListener;
import com.kingdee.eas.fi.rpt.client.RptFormula;
import com.kingdee.eas.fi.rpt.client.RptFormulaComp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FormulaFilterUI
extends CommonFilterUI {
    @Override
    protected void initTable() {
        super.initTable();
        this.tblMain.setFormulaMode(1);
        IColumn compareSrcCol = this.tblMain.getColumn(this.compareObjSrcColName);
        IColumn compareTargetCol = this.tblMain.getColumn(this.compareObjTargetColName);
        KDBizPromptBox formulaBox = new KDBizPromptBox();
        try {
            FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
            formulaBox.setSelector((KDPromptSelector)new FormulaPromptBox(picker, this.tblMain));
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        compareSrcCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)formulaBox));
        compareTargetCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)formulaBox));
    }

    @Override
    protected void initTableRows() {
        Map uiContext = this.getUIContext();
        String formualFilter = (String)uiContext.get("formulaFilter");
        if (formualFilter != null) {
            Gson gson = new Gson();
            JsonArray filterJsonArray = (JsonArray)gson.fromJson(formualFilter, JsonArray.class);
            for (int i = 0; i < filterJsonArray.size(); ++i) {
                CommonFilterEntity filterEntity = CheckUtil.jsonToFilterEntity(gson, filterJsonArray.get(i));
                IRow row = this.tblMain.getRow(i);
                this.fillTableRow(row, filterEntity);
                row.getCell(this.compareObjSrcColName).setValue((Object)filterEntity.getCompareObjSrc().getValue());
                this.filterEntitys.add(filterEntity);
            }
        }
    }

    @Override
    protected CommonFilterEntity getFilterEntity(IRow row) {
        CheckBracket leftBracket = (CheckBracket)((Object)row.getCell(this.leftBracketColName).getValue());
        String compareObjSrc = (String)row.getCell(this.compareObjSrcColName).getValue();
        CheckCompareType compareType = (CheckCompareType)((Object)row.getCell(this.compareTypeColName).getValue());
        String compareObjTarget = (String)row.getCell(this.compareObjTargetColName).getValue();
        CheckBracket rightBracket = (CheckBracket)((Object)row.getCell(this.rightBracketColName).getValue());
        LogicType logicType = (LogicType)row.getCell(this.logicTypeColName).getValue();
        CommonFilterEntity filterEntity = new CommonFilterEntity();
        filterEntity.setLeftBracket(leftBracket);
        filterEntity.setCompareObjSrc(new CompareObjEntity(compareObjSrc));
        filterEntity.setCompareType(compareType);
        filterEntity.setCompareObjTarget(compareObjTarget);
        filterEntity.setRightBracket(rightBracket);
        filterEntity.setLogicType(logicType);
        return filterEntity;
    }

    @Override
    protected String getTitle() {
        return CheckResourceUtil.getString("formulaFilter");
    }

    @Override
    protected Integer limitRow() {
        return 10;
    }

    private final class FormulaPromptBox
    extends CoreUIObject
    implements KDPromptSelector {
        private final FormulaPickerUI picker;
        private String formula = "";
        private boolean isRtrnOK = true;
        private CoreUIObject parentUI = null;
        private int type;
        private final String[] OprtArray = new String[]{"+", "-", "*", "/"};
        private KDTable kdTable;

        public FormulaPromptBox(FormulaPickerUI picker, KDTable templateTable) {
            this.kdTable = templateTable;
            this.picker = picker;
            picker.addFormulaPickerListener((IFormulaPickerListener)new FormulaPickerListener());
        }

        public FormulaPromptBox(CoreUIObject ownerUI, boolean isAdjust) {
            this.parentUI = ownerUI;
            this.picker = null;
            this.type = isAdjust ? 1 : 2;
        }

        public FormulaPromptBox(CoreUIObject ownerUI, int type) {
            this.parentUI = ownerUI;
            this.type = type;
            this.picker = null;
        }

        public void show() {
            int col = this.kdTable.getSelectManager().getActiveColumnIndex();
            int row = this.kdTable.getSelectManager().getActiveRowIndex();
            String line = (String)this.kdTable.getCell(row, col).getValue();
            boolean showAdvn = true;
            if (line == null) {
                line = "";
            }
            Object clientProperty_formula = null;
            try {
                List hints = null;
                FormulaHint hint = null;
                RptFormula fm = null;
                String txt = null;
                if (line != null && line.length() > 0) {
                    txt = "=" + line;
                }
                try {
                    hints = TableToolkit.parseExcelFormula(txt, (boolean)true);
                    if (hints == null || hints.size() < 1) {
                        hints = TableToolkit.parseExcelFormula(txt, (boolean)true);
                    }
                }
                catch (ParserException e) {
                    hints = new ArrayList<List>(1);
                    hints.add(TableToolkit.parseExcelFormula((String)txt, (boolean)true));
                }
                if (hints != null && hints.size() > 0) {
                    hint = (FormulaHint)hints.get(hints.size() - 1);
                    fm = RptFormulaComp.getInstance().getFormula(hint.name);
                }
                if (hint != null && fm != null && hints.size() < 2 && !this.isInclueOprtChar(txt, hint)) {
                    FormulaWizardUI wizard = FormulaWizardUI.creatFormulaWizard((String)fm.getWizard(), (Object)this.parentUI);
                    wizard.addFormulaWizardListener((IFormulaWizardListener)new WizardListener());
                    wizard.open(hint.name, hint);
                } else {
                    if (this.parentUI == null) {
                        this.parentUI = this;
                    }
                    FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this.parentUI);
                    picker.addFormulaPickerListener((IFormulaPickerListener)new FormulaPickerListener());
                    switch (this.type) {
                        case 1: {
                            picker.setFilter("include:categorys{CslRptFormula,financial,assistant},groups{1,2,6,14},formulas{AcctItem,AdjustData,CsRef,Acct}");
                            break;
                        }
                        case 2: {
                            picker.setFilter("include:categorys{CslRptFormula},groups{6,14},formulas{AcctItem,ElimData}");
                            break;
                        }
                        case 3: {
                            picker.setFilter("include:categorys{CslRptFormula},groups{6,14},formulas{AcctItem,ESP,InvData,ElimData,ElimRpt,EqtData}");
                            break;
                        }
                    }
                    picker.setFormulaLine(txt);
                    picker.setUserObject((Object)txt);
                    boolean isAdvance = txt != null;
                    picker.open(null, isAdvance, null);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.picker.setAdvMode(false);
        }

        private boolean isInclueOprtChar(String formula, FormulaHint hint) {
            if (formula == null || formula.length() == 0) {
                return false;
            }
            String hintStr = hint.toString().toLowerCase();
            hintStr = hintStr.replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
            formula = formula.toLowerCase().replaceAll("\"\",", ",").replaceAll("\"", "").replaceAll(hintStr, "");
            for (int k = 0; k < this.OprtArray.length; ++k) {
                if (formula.indexOf(this.OprtArray[k]) == -1) continue;
                return true;
            }
            return false;
        }

        public boolean isCanceled() {
            return !this.isRtrnOK;
        }

        public Object getData() {
            return this.formula;
        }

        private final class FormulaPickerListener
        implements IFormulaPickerListener {
            private FormulaPickerListener() {
            }

            public void pickerSetout(FormulaPickerUI picker) {
                int col = FormulaPromptBox.this.kdTable.getSelectManager().getActiveColumnIndex();
                int row = FormulaPromptBox.this.kdTable.getSelectManager().getActiveRowIndex();
                String line = (String)FormulaPromptBox.this.kdTable.getCell(row, col).getValue();
                if (line == null) {
                    line = "";
                }
                if (line.length() > 1 && line.charAt(0) != '=') {
                    line = "=" + line;
                }
                picker.setFormulaLine(line);
            }

            public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
                if (isOk) {
                    int col = FormulaPromptBox.this.kdTable.getSelectManager().getActiveColumnIndex();
                    int row = FormulaPromptBox.this.kdTable.getSelectManager().getActiveRowIndex();
                    FormulaPromptBox.this.kdTable.getCell(row, col).setValue((Object)formulaLine);
                    FormulaPromptBox.this.isRtrnOK = true;
                    FormulaPromptBox.this.formula = formulaLine;
                    FormulaPromptBox.this.parentUI.putClientProperty((Object)"clientProperty_formula", (Object)FormulaPromptBox.this.formula);
                } else {
                    FormulaPromptBox.this.isRtrnOK = false;
                }
            }
        }

        private class WizardListener
        implements IFormulaWizardListener {
            private WizardListener() {
            }

            public void wizardSetout(FormulaWizardUI wizard) {
            }

            public void wizardReturnee(FormulaWizardUI wizard, String formulaLine, boolean isOk) {
                if (isOk) {
                    FormulaPromptBox.this.isRtrnOK = true;
                    FormulaPromptBox.this.formula = formulaLine;
                } else {
                    FormulaPromptBox.this.isRtrnOK = false;
                }
            }
        }
    }
}

