/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.risk.LogicType;
import com.kingdee.eas.fi.gl.check.CheckBracket;
import com.kingdee.eas.fi.gl.check.CheckCompareType;
import com.kingdee.eas.fi.gl.check.CheckGroupType;
import com.kingdee.eas.fi.gl.check.CommonFilterEntity;
import com.kingdee.eas.fi.gl.check.CompareObjEntity;
import com.kingdee.eas.fi.gl.check.GroupFilterEntity;
import com.kingdee.eas.fi.gl.check.client.CheckResourceUtil;
import com.kingdee.eas.fi.gl.check.client.CommonFilterUI;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class GroupFilterUI
extends CommonFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(GroupFilterUI.class);
    protected String groupTypeColName = "groupType";

    @Override
    protected void initTable() {
        super.initTable();
        IColumn addColumn = this.tblMain.addColumn(2);
        addColumn.setKey(this.groupTypeColName);
        this.tblMain.getHeadRow(0).getCell(this.groupTypeColName).setValue((Object)CheckResourceUtil.getString("groupTypeColName"));
        IColumn groupTypeCol = this.tblMain.getColumn(this.groupTypeColName);
        KDComboBox groupTypeBox = new KDComboBox();
        Iterator groupTypeIter = CheckGroupType.iterator();
        while (groupTypeIter.hasNext()) {
            groupTypeBox.addItem(groupTypeIter.next());
        }
        groupTypeCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)groupTypeBox));
        Map uiContext = this.getUIContext();
        String bizQuery = (String)uiContext.get("bizQuery");
        try {
            List<QueryFieldInfo> groupProp = CheckUtil.getGroupProp(null, bizQuery, this.getCurrentLocale());
            IColumn compareObjSrcCol = this.tblMain.getColumn(this.compareObjSrcColName);
            KDComboBox compareObjSrcBox = new KDComboBox();
            for (QueryFieldInfo queryFiledInfo : groupProp) {
                compareObjSrcBox.addItem((Object)new CompareObjEntity(queryFiledInfo.getName(), queryFiledInfo.getDisplayName(), queryFiledInfo.getReturnType()));
            }
            compareObjSrcCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)compareObjSrcBox));
        }
        catch (BOSException e) {
            logger.error((Object)"parse query error.", (Throwable)e);
            this.handUIException(e);
        }
    }

    @Override
    protected void initTableRows() {
        Map uiContext = this.getUIContext();
        String formualFilter = (String)uiContext.get("groupFilter");
        if (formualFilter != null) {
            Gson gson = new Gson();
            JsonArray filterJsonArray = (JsonArray)gson.fromJson(formualFilter, JsonArray.class);
            for (int i = 0; i < filterJsonArray.size(); ++i) {
                GroupFilterEntity groupFilterEntity = CheckUtil.jsonToGroupFilterEntity(gson, filterJsonArray.get(i));
                IRow row = this.tblMain.getRow(i);
                this.fillTableRow(this.tblMain.getRow(i), groupFilterEntity);
                row.getCell(this.compareObjSrcColName).setValue((Object)groupFilterEntity.getCompareObjSrc());
                row.getCell(this.groupTypeColName).setValue((Object)groupFilterEntity.getGroupType());
                this.filterEntitys.add(groupFilterEntity);
            }
        }
    }

    @Override
    protected String getTitle() {
        return CheckResourceUtil.getString("logicFilter");
    }

    @Override
    protected CommonFilterEntity getFilterEntity(IRow row) {
        CheckBracket leftBracket = (CheckBracket)((Object)row.getCell(this.leftBracketColName).getValue());
        CompareObjEntity compareObjSrc = (CompareObjEntity)row.getCell(this.compareObjSrcColName).getValue();
        CheckGroupType groupType = (CheckGroupType)((Object)row.getCell(this.groupTypeColName).getValue());
        CheckCompareType compareType = (CheckCompareType)((Object)row.getCell(this.compareTypeColName).getValue());
        String compareObjTarget = (String)row.getCell(this.compareObjTargetColName).getValue();
        CheckBracket rightBracket = (CheckBracket)((Object)row.getCell(this.rightBracketColName).getValue());
        LogicType logicType = (LogicType)row.getCell(this.logicTypeColName).getValue();
        GroupFilterEntity filterEntity = new GroupFilterEntity();
        filterEntity.setLeftBracket(leftBracket);
        filterEntity.setCompareObjSrc(compareObjSrc);
        filterEntity.setGroupType(groupType);
        filterEntity.setCompareType(compareType);
        filterEntity.setCompareObjTarget(compareObjTarget);
        filterEntity.setRightBracket(rightBracket);
        filterEntity.setLogicType(logicType);
        return filterEntity;
    }

    @Override
    protected String[] addMustInputField() {
        return new String[]{this.groupTypeColName};
    }
}

