/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.eas.base.risk.LogicType;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.check.CheckBracket;
import com.kingdee.eas.fi.gl.check.CheckCompareType;
import com.kingdee.eas.fi.gl.check.CheckGroupType;
import com.kingdee.eas.fi.gl.check.CommonFilterEntity;
import com.kingdee.eas.fi.gl.check.CompareObjEntity;
import com.kingdee.eas.fi.gl.check.GroupFilterEntity;
import com.kingdee.eas.fi.gl.check.util.SnowFlakeUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class CheckUtil {
    public static final String BLANKSTR = " ";

    public static Map<String, QueryFieldInfo> getQueryPropMapping(Context ctx, String queryFullName, Locale locale) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        QueryInfo query = loader.getQuery((IMetaDataPK)MetaDataPK.create((String)queryFullName));
        SelectorInfo selector = query.getSelector();
        ArrayList fields = selector.getFields();
        HashMap<String, QueryFieldInfo> fieldMap = new HashMap<String, QueryFieldInfo>(fields.size());
        for (QueryFieldInfo queryField : fields) {
            String fieldName = queryField.getName();
            fieldMap.put(fieldName, queryField);
        }
        return fieldMap;
    }

    public static List<QueryFieldInfo> getGroupProp(Context ctx, String queryFullName, Locale locale) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        QueryInfo query = loader.getQuery((IMetaDataPK)MetaDataPK.create((String)queryFullName));
        SelectorInfo selector = query.getSelector();
        ArrayList fields = selector.getFields();
        ArrayList<QueryFieldInfo> queryFields = new ArrayList<QueryFieldInfo>();
        for (QueryFieldInfo queryField : fields) {
            ConstDataType returnType = queryField.getReturnType();
            if (returnType != ConstDataType.NUMBER) continue;
            queryFields.add(queryField);
        }
        return queryFields;
    }

    public static String getQueryFilterDes(EntityViewInfo entityViewInfo, Map<String, QueryFieldInfo> fieldMap, Locale locale) throws BOSException {
        FilterInfo filterInfo = entityViewInfo.getFilter();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        String maskString = filterInfo.getMaskString();
        StringBuilder filterDesSb = new StringBuilder();
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo filterItemInfo = filterItems.get(i);
            String propName = filterItemInfo.getPropertyName();
            QueryFieldInfo queryFieldInfo = fieldMap.get(propName);
            String propDisPlayName = queryFieldInfo.getStateManager().getLocaleValue("displayName", locale.toString()).toString();
            String compareTypeAlias = filterItemInfo.getCompareType().getAlias();
            String compareValue = null;
            ConstDataType returnType = queryFieldInfo.getReturnType();
            compareValue = returnType == ConstDataType.DATE ? CheckUtil.getFormatDate((Date)filterItemInfo.getCompareValue()) : (returnType == ConstDataType.TIME ? CheckUtil.getFormatTime((Timestamp)filterItemInfo.getCompareValue()) : filterItemInfo.getCompareValue().toString());
            filterDesSb.append(propDisPlayName).append(BLANKSTR).append(compareTypeAlias).append(BLANKSTR).append(compareValue);
            maskString = maskString.replace("#" + i, filterDesSb.toString());
            filterDesSb.setLength(0);
        }
        return maskString;
    }

    public static String getQueryFilterDes(EntityViewInfo entityViewInfo, String queryFullName, Locale locale) throws BOSException {
        return CheckUtil.getQueryFilterDes(entityViewInfo, CheckUtil.getQueryPropMapping(null, queryFullName, locale), locale);
    }

    public static String getFormatDate(Date date) {
        return CheckUtil.getFormatDate(date, "yyyy-MM-dd");
    }

    public static String getFormatTime(Timestamp time) {
        return CheckUtil.getFormatDate(time, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatDate(Date date, String format) {
        SimpleDateFormat simpleDateFmt = new SimpleDateFormat(format);
        return simpleDateFmt.format(date);
    }

    public static String getSqlLeftLike(String value) {
        return value + "%";
    }

    public static String getSqlRightLike(String value) {
        return "%" + value;
    }

    public static String getSqlFulltLike(String value) {
        return "%" + value + "%";
    }

    public static StringBuilder getSqlIn(List list) {
        StringBuilder filter = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                filter.append("?,");
            }
            filter.deleteCharAt(filter.lastIndexOf(","));
        }
        return filter;
    }

    public static JsonObject filterEntityToJson(CommonFilterEntity filterEntity) {
        JsonObject filterJson = new JsonObject();
        CheckUtil.fillJsonByFilterEntity(filterJson, filterEntity);
        return filterJson;
    }

    public static JsonObject groupFilterEntityToJson(GroupFilterEntity groupFilterEntity) {
        JsonObject filterJson = new JsonObject();
        CheckUtil.fillJsonByFilterEntity(filterJson, groupFilterEntity);
        filterJson.addProperty("g", groupFilterEntity.getGroupType().getValue());
        return filterJson;
    }

    public static JsonObject fillJsonByFilterEntity(JsonObject filterJson, CommonFilterEntity filterEntity) {
        if (filterJson == null) {
            filterJson = new JsonObject();
        }
        filterJson.addProperty("l", filterEntity.getLeftBracket() != null ? filterEntity.getLeftBracket().getName() : "");
        filterJson.addProperty("s", filterEntity.getCompareObjSrc().getValue());
        if (filterEntity.getCompareObjSrc().getDisplayName() != null) {
            filterJson.addProperty("sa", filterEntity.getCompareObjSrc().getDisplayName());
        }
        filterJson.addProperty("st", filterEntity.getCompareObjSrc().getDataType().getName());
        filterJson.addProperty("c", filterEntity.getCompareType().getName());
        filterJson.addProperty("t", filterEntity.getCompareObjTarget());
        filterJson.addProperty("r", filterEntity.getRightBracket() != null ? filterEntity.getRightBracket().getName() : "");
        filterJson.addProperty("lg", filterEntity.getLogicType() != null ? filterEntity.getLogicType().getValue() : "");
        return filterJson;
    }

    public static CommonFilterEntity jsonToFilterEntity(Gson gson, JsonElement jsonElement) {
        Map filterMap = (Map)gson.fromJson(jsonElement, Map.class);
        CommonFilterEntity commonFilterEntity = new CommonFilterEntity();
        CheckUtil.fillCommonFilterEntity(commonFilterEntity, filterMap);
        return commonFilterEntity;
    }

    public static List<GroupFilterEntity> jsonToGroupFilterEntityList(String filter) {
        ArrayList<GroupFilterEntity> groupFilterEntityList = new ArrayList<GroupFilterEntity>();
        if (StringUtils.isEmpty((String)filter)) {
            return groupFilterEntityList;
        }
        Gson gson = new Gson();
        JsonArray filterJsonArray = (JsonArray)gson.fromJson(filter, JsonArray.class);
        for (int i = 0; i < filterJsonArray.size(); ++i) {
            GroupFilterEntity groupFilterEntity = CheckUtil.jsonToGroupFilterEntity(gson, filterJsonArray.get(i));
            groupFilterEntityList.add(groupFilterEntity);
        }
        return groupFilterEntityList;
    }

    public static GroupFilterEntity jsonToGroupFilterEntity(Gson gson, JsonElement jsonElement) {
        Map filterMap = (Map)gson.fromJson(jsonElement, Map.class);
        GroupFilterEntity groupFilterEntity = new GroupFilterEntity();
        CheckUtil.fillCommonFilterEntity(groupFilterEntity, filterMap);
        groupFilterEntity.setGroupType(CheckGroupType.getEnum((String)filterMap.get("g")));
        return groupFilterEntity;
    }

    public static CommonFilterEntity fillCommonFilterEntity(CommonFilterEntity filterEntity, Map<String, String> filterMap) {
        if (filterEntity == null) {
            filterEntity = new CommonFilterEntity();
        }
        filterEntity.setLeftBracket(CheckBracket.getEnum(filterMap.get("l")));
        CompareObjEntity compareObjEntity = new CompareObjEntity(filterMap.get("s"), filterMap.get("sa"), filterMap.get("st") == null ? ConstDataType.STRING : ConstDataType.getEnum((String)filterMap.get("st")));
        filterEntity.setCompareObjSrc(compareObjEntity);
        filterEntity.setCompareType(CheckCompareType.getEnum(filterMap.get("c")));
        filterEntity.setCompareObjTarget(filterMap.get("t"));
        filterEntity.setRightBracket(CheckBracket.getEnum(filterMap.get("r")));
        filterEntity.setLogicType(LogicType.getEnum((String)filterMap.get("lg")));
        return filterEntity;
    }

    public static boolean compareResult(CheckCompareType compareType, BigDecimal srcResult, BigDecimal targetResult) {
        boolean result = false;
        if (compareType == CheckCompareType.EQUALS) {
            result = srcResult.compareTo(targetResult) == 0;
        } else if (compareType == CheckCompareType.LESS) {
            result = srcResult.compareTo(targetResult) < 0;
        } else if (compareType == CheckCompareType.LESS_E) {
            result = srcResult.compareTo(targetResult) <= 0;
        } else if (compareType == CheckCompareType.GREATER) {
            result = srcResult.compareTo(targetResult) > 0;
        } else if (compareType == CheckCompareType.GREATER_E) {
            result = srcResult.compareTo(targetResult) >= 0;
        } else if (compareType == CheckCompareType.NO_EQUALS) {
            result = srcResult.compareTo(targetResult) != 0;
        }
        return result;
    }

    public static boolean logicResult(boolean checkResult, LogicType logicType, boolean result) {
        LogicType logicType2 = logicType = logicType == null ? LogicType.AND : logicType;
        if (logicType == LogicType.AND) {
            checkResult = checkResult && result;
        } else if (logicType == LogicType.OR) {
            checkResult = checkResult || result;
        }
        return checkResult;
    }

    public static boolean exeLogicExp(String exp) throws ScriptException {
        if (StringUtils.isEmpty((String)exp)) {
            return false;
        }
        ScriptEngineManager scriptM = new ScriptEngineManager();
        ScriptEngine scriptE = scriptM.getEngineByName("js");
        return (Boolean)scriptE.eval(exp);
    }

    public static void setExp(CommonFilterEntity filterEntity, boolean result, StringBuilder expSb) {
        if (filterEntity.getLeftBracket() != null) {
            expSb.append(filterEntity.getLeftBracket().getName());
        }
        expSb.append(Boolean.toString(result));
        if (filterEntity.getRightBracket() != null) {
            expSb.append(filterEntity.getRightBracket().getName());
        }
        if (filterEntity.getLogicType() != null) {
            expSb.append(BLANKSTR).append(filterEntity.getLogicType().getValue()).append(BLANKSTR);
        }
    }

    public static boolean isFormula(String formula) {
        if (StringUtils.isEmpty((String)formula)) {
            return false;
        }
        return formula.contains("(") && formula.endsWith(")");
    }

    public static boolean isDecimal(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return false;
        }
        return s.matches("[-]*\\d+\\.*\\d*");
    }

    public static String getCheckJobName() {
        return "check_" + String.valueOf(SnowFlakeUtil.getSnowFlakeId());
    }

    public static String getCurrentOrgId(Context ctx) {
        if (ctx == null) {
            return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        }
        return ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
    }

    public static FullOrgUnitInfo getFullOrgUnit(Context ctx, String orgId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        FullOrgUnitInfo fullOrg = null;
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        fullOrg = ctx == null ? FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), selectors) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), selectors);
        return fullOrg;
    }

    public static OrgType getOrgTypeBySubSystem(SystemEnum systemEnum) {
        OrgType orgType = OrgType.Company;
        if (systemEnum == SystemEnum.GENERALLEDGER) {
            orgType = OrgType.Company;
        }
        return orgType;
    }
}

