/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.check.util;

import java.util.Date;

public class SnowFlakeUtil {
    private static SnowFlakeUtil snowFlakeUtil = new SnowFlakeUtil();
    private static final long INIT_EPOCH = 1684718789258L;
    private static final long TIME_BIT = -4194304L;
    private long lastTimeMillis = -1L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private long dataCenterId;
    private static final long WORKER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private long workerId;
    private static final long SEQUENCE_BITS = 12L;
    private static final long SEQUENCE_MASK = 4095L;
    private long sequence;
    private static final long WORK_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_SHIFT = 22L;

    public SnowFlakeUtil() {
        this(1L, 1L);
    }

    public SnowFlakeUtil(long dataCenterId, long workerId) {
        if (dataCenterId < 0L || dataCenterId > 31L) {
            throw new IllegalArgumentException(String.format("dataCenterId \u503c\u5fc5\u987b\u5927\u4e8e 0 \u5e76\u4e14\u5c0f\u4e8e %d", 31L));
        }
        if (workerId < 0L || workerId > 31L) {
            throw new IllegalArgumentException(String.format("workId \u503c\u5fc5\u987b\u5927\u4e8e 0 \u5e76\u4e14\u5c0f\u4e8e %d", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public static Long getSnowFlakeId() {
        return snowFlakeUtil.nextId();
    }

    public synchronized long nextId() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis < this.lastTimeMillis) {
            throw new RuntimeException(String.format("\u53ef\u80fd\u51fa\u73b0\u670d\u52a1\u5668\u65f6\u949f\u56de\u62e8\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u5668\u65f6\u95f4\u3002\u5f53\u524d\u670d\u52a1\u5668\u65f6\u95f4\u6233\uff1a%d\uff0c\u4e0a\u4e00\u6b21\u4f7f\u7528\u65f6\u95f4\u6233\uff1a%d", currentTimeMillis, this.lastTimeMillis));
        }
        if (currentTimeMillis == this.lastTimeMillis) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimeMillis = this.getNextMillis(this.lastTimeMillis);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimeMillis = currentTimeMillis;
        return currentTimeMillis - 1684718789258L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long getNextMillis(long lastTimeMillis) {
        long currentTimeMillis = System.currentTimeMillis();
        while (currentTimeMillis <= lastTimeMillis) {
            currentTimeMillis = System.currentTimeMillis();
        }
        return currentTimeMillis;
    }

    public static String getRandomStr() {
        return Long.toString(SnowFlakeUtil.getSnowFlakeId(), 36);
    }

    public static Date getTimeBySnowFlakeId(long id) {
        return new Date(((0xFFFFFFFFFFC00000L & id) >> 22) + 1684718789258L);
    }

    public static void main(String[] args) {
        SnowFlakeUtil snowFlakeUtil = new SnowFlakeUtil();
        long id = snowFlakeUtil.nextId();
        System.out.println(id);
        Date date = SnowFlakeUtil.getTimeBySnowFlakeId(id);
        System.out.println(date);
        long time = date.getTime();
        System.out.println(time);
        System.out.println(SnowFlakeUtil.getRandomStr());
    }
}

