/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLAccountRefContrastProcessFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractAccountRefContrastProcessVchMgrUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class AccountRefContrastProcessVchMgrUI
extends AbstractAccountRefContrastProcessVchMgrUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountRefContrastProcessVchMgrUI.class);
    private static final String GL_RESOURCE = "com.kingdee.eas.fi.gl.GLResource";
    private static final String RES = "com.kingdee.eas.fi.gl.BalanceAnalysisResource";
    private boolean stop = false;
    private KDButtonGroup bgAction = new KDButtonGroup();
    private int maxFuture = 120;
    private boolean isAdvRefMode = false;
    DataChangeListener companyListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                AccountRefContrastProcessVchMgrUI.this.initPeriod();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                AccountRefContrastProcessVchMgrUI.this.handUIException(ex);
            }
        }
    };

    public void onLoad() throws Exception {
        super.onLoad();
        this.spConsole.setBorder(BorderFactory.createLineBorder(new Color(145, 148, 140), 1));
        this.rbBuild.setSelected(true);
        this.initMyIcon();
        this.initCompany();
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f5 = KeyStroke.getKeyStroke(116, 3);
        imEntry.put(ctrl_shift_f5, "showAdvance");
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("showAdvance", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountRefContrastProcessVchMgrUI.this.showAdvanceActionPerformed(e);
            }
        });
    }

    public void showAdvanceActionPerformed(ActionEvent e) {
        if (this.isAdvRefMode) {
            this.cbPeriodValidate.setSelected(false);
            this.cbPeriodValidate.setVisible(false);
            this.isAdvRefMode = false;
            return;
        }
        if (this.cbEffect.isSelected() && !this.isAdvRefMode) {
            this.cbPeriodValidate.setSelected(false);
            this.cbPeriodValidate.setVisible(true);
            this.isAdvRefMode = true;
        }
    }

    private void initMyIcon() throws Exception {
        this.period.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.period.setEditable(true);
        this.period.setEditFormat("$number$");
        this.period.setCommitFormat("$number$");
        this.bgAction.add((AbstractButton)this.rbBuild);
        this.rbBuild.setSelected(true);
        this.btnOk.setEnabled(true);
    }

    private void initCompany() throws Exception {
        this.promptCompany.setQueryInfo("com.kingdee.eas.fi.gl.app.CompanyOrgUnitQuery");
        this.promptCompany.setEditable(true);
        this.promptCompany.setEditFormat("$number$");
        this.promptCompany.setCommitFormat("$name$;$number$");
        this.promptCompany.setDisplayFormat("$number$-$name$");
        this.promptCompany.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Integer(0)));
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s \n");
        sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append("    and sc.FStartPeriodID is not null \n");
        sql.append("    and sc.FCurrentPeriodID is not null \n");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filter);
        this.promptCompany.setEntityViewInfo(view);
        CompanyOrgUnitInfo company = this.getFirstOrg();
        if (company != null) {
            this.promptCompany.setValue((Object)new Object[]{company});
        } else {
            this.promptCompany.setValue((Object)new Object[0]);
        }
        this.promptCompany.addDataChangeListener(this.companyListener);
        this.initPeriod();
    }

    private CompanyOrgUnitInfo getFirstOrg() {
        IRowSet rs;
        StringBuffer sql;
        Map context = this.getUIContext();
        if (context.get("company") != null) {
            return (CompanyOrgUnitInfo)context.get("company");
        }
        String companyId = null;
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company.isIsBizUnit() && !company.isIsSealUp()) {
            sql = new StringBuffer();
            sql.append("select c.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
            sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
            sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            sql.append("    and c.FID = '" + company.getId().toString() + "' \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    companyId = company.getId().toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (companyId == null) {
            sql = new StringBuffer();
            sql.append("select top 1 c.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
            sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
            sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    companyId = rs.getString("FID");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (companyId != null) {
            try {
                return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void initPeriod() throws Exception {
        this.period.setEnabled(false);
        Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects == null || objects.length == 0) {
            this.period.setValue(null);
            return;
        }
        Set<String> periodTypeIdSet = this.getPeriodTypeRange(objects);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", periodTypeIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isadjustperiod", (Object)"1"));
        this.period.setEntityViewInfo(view);
        this.period.setValue(null);
        this.period.setEnabled(true);
        this.period.setEnabledMultiSelection(false);
    }

    private CompanyOrgUnitInfo queryCompany(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.getAccountPeriodType() != null) {
            return company;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountPeriodType.id");
        CompanyOrgUnitInfo c = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
        company.setAccountPeriodType(c.getAccountPeriodType());
        return company;
    }

    private Set<String> getPeriodTypeRange(Object[] companys) throws BOSException {
        HashSet<String> periodTypeIdSet = new HashSet<String>();
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < companys.length; ++i) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys[i];
            if (company.getAccountPeriodType() != null) {
                periodTypeIdSet.add(company.getAccountPeriodType().getId().toString());
                continue;
            }
            companyIdSet.add(company.getId().toString());
        }
        if (companyIdSet != null && companyIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("accountPeriodType.id");
            FilterInfo filter = new FilterInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
            CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            for (int i = 0; i < companyColl.size(); ++i) {
                CompanyOrgUnitInfo company = companyColl.get(i);
                periodTypeIdSet.add(company.getAccountPeriodType().getId().toString());
            }
        }
        return periodTypeIdSet;
    }

    private void enableComponent(boolean enable) {
        this.promptCompany.setEnabled(enable);
        this.period.setEnabled(enable);
        this.rbBuild.setEnabled(enable);
        this.cbEffect.setEnabled(enable);
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnOk.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.actionComfirm.setEnabled(false);
            this.btnOk.setEnabled(false);
            return;
        }
        final Object[] companys = (Object[])this.promptCompany.getValue();
        if (companys == null || companys.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SelectOrg"));
            return;
        }
        PeriodInfo periodInfo = (PeriodInfo)this.period.getValue();
        if (periodInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("please_select_period"));
            return;
        }
        HashSet<String> companyIds = new HashSet<String>();
        for (int i = 0; i < companys.length; ++i) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys[i];
            if (company.getAccountTable() != null && company.getAccountTable().getId() != null) continue;
            companyIds.add(company.getId().toString());
        }
        if (companyIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("accountTable.id");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
            view.setFilter(filter);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            HashMap<String, AccountTableInfo> accountTables = new HashMap<String, AccountTableInfo>();
            for (CompanyOrgUnitInfo company : coll) {
                accountTables.put(company.getId().toString(), company.getAccountTable());
            }
            for (int i = 0; i < companys.length; ++i) {
                CompanyOrgUnitInfo company;
                company = (CompanyOrgUnitInfo)companys[i];
                AccountTableInfo accountTable = (AccountTableInfo)accountTables.get(company.getId().toString());
                if (accountTable == null) continue;
                if (company.getAccountTable() == null) {
                    company.setAccountTable(accountTable);
                    continue;
                }
                if (company.getAccountTable().getId() != null) continue;
                company.getAccountTable().setId(accountTable.getId());
            }
        }
        final HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("periodNumber", periodInfo.getNumber());
        params.put("periodInfo", periodInfo);
        final boolean isTry = !this.cbEffect.isSelected();
        params.put("isTry", String.valueOf(isTry));
        if (this.cbPeriodValidate.isVisible()) {
            boolean periodValidate = this.cbPeriodValidate.isSelected();
            params.put("periodValidate", periodValidate);
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AccountRefContrastProcessVchMgrUI.this.btnOk.putClientProperty((Object)"canStop", (Object)true);
                    AccountRefContrastProcessVchMgrUI.this.btnOk.setText(EASResource.getString((String)AccountRefContrastProcessVchMgrUI.RES, (String)"Stop"));
                    AccountRefContrastProcessVchMgrUI.this.enableComponent(false);
                    for (int i = 0; i < companys.length; ++i) {
                        CompanyOrgUnitInfo c = (CompanyOrgUnitInfo)companys[i];
                        AccountRefContrastProcessVchMgrUI.this.showInfo(MessageFormat.format(AccountRefContrastProcessVchMgrUI.this.getResource("process_orgunit"), c.getNumber()), Color.BLACK);
                        params.put("companyId", c.getId().toString());
                        try {
                            VoucherCollection voucherColl;
                            Map result = GLAccountRefContrastProcessFacadeFactory.getRemoteInstance().transfer(params);
                            String error = (String)result.get("error");
                            if (!StringUtils.isEmpty((String)error)) {
                                AccountRefContrastProcessVchMgrUI.this.showInfo("    " + error, Color.RED);
                                continue;
                            }
                            Set needRepairAcct = (Set)result.get("needRepairAcct");
                            if (needRepairAcct != null && needRepairAcct.size() > 0) {
                                if (isTry) {
                                    AccountRefContrastProcessVchMgrUI.this.showInfo("        " + AccountRefContrastProcessVchMgrUI.this.getResource("accountView_not_trans"), Color.BLACK);
                                } else {
                                    AccountRefContrastProcessVchMgrUI.this.showInfo("        " + AccountRefContrastProcessVchMgrUI.this.getResource("transvoucher_creating"), Color.BLACK);
                                }
                                for (String acct : needRepairAcct) {
                                    AccountRefContrastProcessVchMgrUI.this.showInfo("            " + AccountRefContrastProcessVchMgrUI.this.getResource("account_number") + acct, Color.BLACK);
                                }
                            }
                            if ((voucherColl = (VoucherCollection)result.get("buildVouchers")) != null && voucherColl.size() > 0) {
                                VoucherInfo info;
                                if (isTry) {
                                    AccountRefContrastProcessVchMgrUI.this.showInfo("            " + AccountRefContrastProcessVchMgrUI.this.getResource("waiting_to_trans_info"), Color.BLACK);
                                    for (int j = 0; j < voucherColl.size(); ++j) {
                                        info = voucherColl.get(j);
                                        AccountRefContrastProcessVchMgrUI.this.showInfo("            " + AccountRefContrastProcessVchMgrUI.this.getResource("period") + "\uff1a" + info.getPeriod().getNumber() + "\uff0c" + AccountRefContrastProcessVchMgrUI.this.getResource("waiting_to_trans_entry") + "\uff1a", Color.BLACK);
                                        VoucherEntryCollection voucherEntryCollection = info.getEntries();
                                        block12: for (int k = 0; k < voucherEntryCollection.size(); ++k) {
                                            VoucherEntryInfo entryInfo = voucherEntryCollection.get(k);
                                            AccountRefContrastProcessVchMgrUI.this.showInfo("            " + AccountRefContrastProcessVchMgrUI.this.getResource("description") + "\uff1a" + entryInfo.getDescription() + "\uff0c " + AccountRefContrastProcessVchMgrUI.this.getResource("accountview") + "\uff1a" + entryInfo.getAccount().getNumber() + "\uff0c" + AccountRefContrastProcessVchMgrUI.this.getResource("dc") + "\uff1a" + entryInfo.getEntryDC() + "\uff0c" + AccountRefContrastProcessVchMgrUI.this.getResource("currency") + "\uff1a" + entryInfo.getCurrency().getName() + "\uff0c" + AccountRefContrastProcessVchMgrUI.this.getResource("amount") + "\uff1a" + entryInfo.getOriginalAmount(), Color.BLACK);
                                            VoucherAssistRecordCollection records = entryInfo.getAssistRecords();
                                            if (records == null || records.size() <= 0) continue;
                                            int count = 0;
                                            for (int l = 0; l < records.size(); ++l) {
                                                if (++count >= 11) {
                                                    AccountRefContrastProcessVchMgrUI.this.showInfo("                ...", Color.BLACK);
                                                    continue block12;
                                                }
                                                VoucherAssistRecordInfo recordInfo = records.get(l);
                                                AccountRefContrastProcessVchMgrUI.this.showInfo("                " + AccountRefContrastProcessVchMgrUI.this.getResource("asstaccount") + "\uff1a" + recordInfo.getAssGrp().getDisplayNameGroup() + "\uff0c " + AccountRefContrastProcessVchMgrUI.this.getResource("amount") + "\uff1a" + recordInfo.getOriginalAmount(), Color.BLACK);
                                            }
                                        }
                                    }
                                } else {
                                    AccountRefContrastProcessVchMgrUI.this.showInfo("            " + AccountRefContrastProcessVchMgrUI.this.getResource("create_transvoucher") + "\uff1a", Color.BLACK);
                                    for (int j = 0; j < voucherColl.size(); ++j) {
                                        info = voucherColl.get(j);
                                        AccountRefContrastProcessVchMgrUI.this.showInfo("            " + AccountRefContrastProcessVchMgrUI.this.getResource("period") + "\uff1a" + info.getPeriod().getNumber() + AccountRefContrastProcessVchMgrUI.this.getResource("number") + "\uff1a" + info.getNumber(), Color.BLACK);
                                    }
                                    AccountRefContrastProcessVchMgrUI.this.showInfo("            " + AccountRefContrastProcessVchMgrUI.this.getResource("transvoucher_created"), Color.BLACK);
                                }
                            }
                        }
                        catch (Exception e) {
                            AccountRefContrastProcessVchMgrUI.this.showInfo("    " + GlUtils.printStackTrace(e), Color.RED);
                        }
                        if (AccountRefContrastProcessVchMgrUI.this.stop) break;
                    }
                    AccountRefContrastProcessVchMgrUI.this.showInfo(AccountRefContrastProcessVchMgrUI.this.getResource("processed") + "\n", Color.BLACK);
                }
                finally {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    AccountRefContrastProcessVchMgrUI.this.btnOk.setText(EASResource.getString((String)AccountRefContrastProcessVchMgrUI.RES, (String)"Execute"));
                    AccountRefContrastProcessVchMgrUI.this.enableComponent(true);
                    AccountRefContrastProcessVchMgrUI.this.actionComfirm.setEnabled(true);
                    AccountRefContrastProcessVchMgrUI.this.btnOk.setEnabled(true);
                    AccountRefContrastProcessVchMgrUI.this.btnOk.putClientProperty((Object)"canStop", null);
                    AccountRefContrastProcessVchMgrUI.this.stop = false;
                }
            }
        }).start();
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtConsole.setText("");
    }

    private void showInfo(final String info, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = AccountRefContrastProcessVchMgrUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), info + "\n", attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                AccountRefContrastProcessVchMgrUI.this.txtConsole.setSelectionStart(doc.getLength());
            }
        });
    }

    public String getResource(String resName) {
        return EASResource.getString((String)RES, (String)resName);
    }
}

