/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.AcctCussentCheckFacadeFactory;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussentCheckFacade;
import com.kingdee.eas.fi.gl.client.AbstractAcctCussentCheckFilterPanel;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.UIUtil;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;

public class AcctCussentCheckFilterPanel
extends AbstractAcctCussentCheckFilterPanel {
    private static final long serialVersionUID = 4494898801082741979L;
    CompanyOrgUnitInfo curCompany = null;
    String companyid = null;
    int verifyMode = 0;
    String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.AcctCussentCheckResource";
    CurrencyInfo localCurrency = null;
    private boolean includeInitDataFlg = false;
    private Date minDate = null;
    private DataChangeListener myDataChangeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            if (eventObj.getNewValue() != null && eventObj.getNewValue() != eventObj.getOldValue()) {
                AccountViewInfo acct = (AccountViewInfo)eventObj.getNewValue();
                if (!acct.isIsLeaf()) {
                    AcctCussentCheckFilterPanel.this.pbAccount.setData(eventObj.getOldValue());
                    MsgBox.showInfo((Component)((Object)AcctCussentCheckFilterPanel.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SELECT_LEAF_ACCOUNT"));
                    SysUtil.abort();
                }
                AcctCussentCheckFilterPanel.this.accountChanged(eventObj.getOldValue(), eventObj.getNewValue());
            }
        }
    };
    AccountViewInfo currentAccount = null;
    ArrayList currentItems = null;

    public AcctCussentCheckFilterPanel() throws Exception {
        this.dpBusiDateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                AcctCussentCheckFilterPanel.this.spnYearTo_stateChanged(eventObj);
            }
        });
        this.dpBusiDateFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e != null && e.getOldValue() instanceof Date && e.getNewValue() instanceof Date) {
                    AcctCussentCheckFilterPanel.this.checkPeriod(e, true);
                }
            }
        });
    }

    private void checkPeriod(DataChangeEvent e, boolean isFrom) {
        Date oldDate = (Date)e.getOldValue();
        Date newDate = (Date)e.getNewValue();
        if (isFrom) {
            this.includeInitDataFlg = this.minDate.compareTo(newDate) == 0;
            this.includeInitData.setEnabled(true);
            if (!this.includeInitDataFlg) {
                this.includeInitData.setSelected(this.includeInitDataFlg);
            }
        }
        if (oldDate.getYear() != newDate.getYear()) {
            try {
                PeriodInfo beginPeriodInfo = PeriodUtils.getPeriodInfo((Date)newDate, (CompanyOrgUnitInfo)this.curCompany);
                if (beginPeriodInfo == null || beginPeriodInfo.getBeginDate() == null) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"no_equal_period");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    msg = msg.replace("{0}", sdf.format(newDate));
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                    if (isFrom) {
                        this.dpBusiDateFrom.setValue((Object)oldDate);
                    } else {
                        this.dpBusiDateTo.setValue((Object)oldDate);
                    }
                }
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void checkPeriod(Date date) {
        try {
            PeriodInfo beginPeriodInfo = PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)this.curCompany);
            if (beginPeriodInfo == null || beginPeriodInfo.getBeginDate() == null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"no_equal_period");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                msg = msg.replace("{0}", sdf.format(date));
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    protected void spnYearTo_stateChanged(DataChangeEvent e) {
        if (e != null && e.getOldValue() instanceof Date && e.getNewValue() instanceof Date) {
            Date oldDate = (Date)e.getOldValue();
            Date newDate = (Date)e.getNewValue();
            if (oldDate.getYear() != newDate.getYear()) {
                int yearEnd = ((Date)this.dpBusiDateTo.getValue()).getYear() + 1900;
                int numberEnd = ((Date)this.dpBusiDateTo.getValue()).getMonth() + 1;
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
                RptClientUtil.periodChanged((IUIObject)this, this.curCompany, filter, yearEnd, numberEnd, this.pbAccount, this.pbAccount);
                this.initAccountF7(new FilterInfo());
            }
        }
    }

    public void initData(boolean isFSSC) throws Exception {
        this.tblAsstItem.checkParsed();
        this.curCompany = InitClientHelp.getCurrentCompany();
        this.companyid = this.curCompany.getId().toString();
        this.getUIContext().get("Owner");
        this.initCompanyF7(isFSSC);
        this.verifyMode = GlUtils.getVerifyMode(null, this.companyid);
        if (this.verifyMode == 2) {
            this.cbIncludeUnPosted.setSelected(true);
            this.cbIncludeUnPosted.setEnabled(false);
        }
        this.cbIncludeFinished.setSelected(true);
        ICurrency curCtrl = CurrencyFactory.getRemoteInstance();
        CurrencyCollection col = curCtrl.getCurrencyCollection(true);
        CurrencyInfo local = null;
        for (int i = 0; i < col.size(); ++i) {
            CurrencyInfo temp = col.get(i);
            this.comboCurrency.addItem((Object)col.get(i));
            if (!temp.getId().toString().equals(this.curCompany.getBaseCurrency().getId().toString())) continue;
            local = temp;
        }
        this.comboCurrency.addItem((Object)GLResUtil.getRes("all_currency"));
        if (local != null) {
            this.comboCurrency.setSelectedItem(local);
            this.localCurrency = local;
        }
        FilterInfo filter = new FilterInfo();
        this.initAccountF7(filter);
        this.tblAsstItem.getSelectManager().setSelectMode(2);
        InitClientHelp.setTableKeyBoardManager(this.tblAsstItem);
        KDCheckBox cb = new KDCheckBox();
        KDTDefaultCellEditor cbEditor = new KDTDefaultCellEditor((JCheckBox)cb);
        this.tblAsstItem.getColumn("selected").setEditor((ICellEditor)cbEditor);
        this.tblAsstItem.getColumn("type").getStyleAttributes().setLocked(true);
        PeriodInfo startPeriod = GlUtils.getAcStartPeriod(null, this.companyid);
        if (startPeriod != null) {
            this.minDate = startPeriod.getBeginDate();
            this.dpBusiDateFrom.setMinimumDate(this.minDate);
            this.dpBusiDateTo.setMinimumDate(this.minDate);
        }
        if (this.dpBusiDateTo.getValue() != null) {
            int yearEnd = ((Date)this.dpBusiDateTo.getValue()).getYear() + 1900;
            int numberEnd = ((Date)this.dpBusiDateTo.getValue()).getMonth() + 1;
            RptClientUtil.periodChanged((IUIObject)this, this.curCompany, filter, yearEnd, numberEnd, this.pbAccount, this.pbAccount);
        }
    }

    private void initCompanyF7(boolean isFSSC) {
        this.bpCompany.setEditable(isFSSC);
        this.bpCompany.setEnabled(isFSSC);
        this.bpCompany.setData((Object)this.curCompany);
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.bpCompany.setEntityViewInfo(companyView);
        this.bpCompany.setSelector(this.getCompanySelector());
        this.bpCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                try {
                    if (AcctCussentCheckFilterPanel.this.isCompanyChanged(event)) {
                        AcctCussentCheckFilterPanel.this.companyChanged();
                    }
                }
                catch (Exception e) {
                    AcctCussentCheckFilterPanel.this.handUIException(e);
                }
            }
        });
    }

    private void initAccountF7(FilterInfo filter) {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.companyid));
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
        this.pbAccount.setEditable(true);
        this.pbAccount.setEditFormat("$number$");
        this.pbAccount.setCommitFormat("$helpCode$;$number$;$name$");
        this.pbAccount.setDisplayFormat("$number$ - $name$");
        this.pbAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbAccount.setEntityViewInfo(view);
        this.pbAccount.addDataChangeListener(this.myDataChangeListener);
        this.pbAccount.setCommitParser((IParser)new AccountViewParser(this.pbAccount));
        AccountTableInfo accountTable = this.curCompany.getAccountTable();
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        companyColl.add(this.curCompany);
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
        this.pbAccount.setSelector((KDPromptSelector)apb);
    }

    protected boolean isCompanyChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            return e.getOldValue() != null;
        }
        if (e.getOldValue() == null) {
            return true;
        }
        return !this.isCompanyEquals(e.getNewValue(), e.getOldValue());
    }

    protected boolean isCompanyEquals(Object newObject, Object oldObject) {
        if (newObject instanceof Object[] && oldObject instanceof Object[] && Arrays.toString((Object[])newObject).equalsIgnoreCase(Arrays.toString((Object[])oldObject))) {
            return true;
        }
        if (newObject instanceof CompanyOrgUnitInfo && oldObject instanceof CompanyOrgUnitInfo) {
            return ((CompanyOrgUnitInfo)newObject).getId().equals((Object)((CompanyOrgUnitInfo)oldObject).getId());
        }
        return false;
    }

    protected KDPromptSelector getCompanySelector() {
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(false);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        companySelector.setExtraTreeFilters("\"STRUCTURE\".FUnitID in (" + this.getCompanyIdFilter() + ")");
        return companySelector;
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    protected void companyChanged() throws Exception {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys != null && companys.length == 1) {
            this.curCompany = companys[0];
            this.companyid = this.curCompany.getId().toString();
            this.initAccountF7(new FilterInfo());
            this.comboCurrency.setSelectedItem((Object)this.curCompany.getBaseCurrency());
        }
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.bpCompany.getValue();
        return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
    }

    private String getCompanyIdFilter() {
        StringBuffer companyIdStr = new StringBuffer();
        try {
            companyIdStr.append(GLGeneralFacadeFactory.getRemoteInstance().getCompanyIDSQL(this.getPermissionItem(), null, true));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        companyIdStr.append(" and cp.fid in (select FORGUNITID from t_bas_param pm inner join t_bas_paramitem pmi on pmi.fkeyid = pm.fid where pm.fnumber = 'GL_028' and pmi.fvalue_").append(SysContext.getSysContext().getLocale().toString()).append(" = 'true')");
        return companyIdStr.toString();
    }

    protected String getPermissionItem() {
        return "gl_acctcussent_view";
    }

    private void accountChanged(Object oldValue, Object newValue) {
        try {
            this.refreshItem();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void refreshItem() throws Exception {
        IAcctCussentCheckFacade facade = AcctCussentCheckFacadeFactory.getRemoteInstance();
        this.currentAccount = (AccountViewInfo)this.pbAccount.getValue();
        this.tblAsstItem.removeRows();
        if (this.currentAccount == null) {
            return;
        }
        this.currentItems = facade.getAsstItemType(this.currentAccount.getId().toString(), this.companyid);
        for (HashMap item : this.currentItems) {
            IRow row = this.tblAsstItem.addRow();
            row.getCell("selected").setValue((Object)Boolean.TRUE);
            row.getCell("type").setValue(item.get("name"));
            KDBizPromptBox bizPromptBox = new KDBizPromptBox();
            bizPromptBox.setEditable(true);
            bizPromptBox.setEditFormat("$number$");
            bizPromptBox.setDisplayFormat("$number$ - $name$");
            bizPromptBox.setQueryInfo((String)item.get("queryname"));
            bizPromptBox.setCommitFormat("$longnumber;$number$;$name$");
            AsstActTypeInfo atInfo = new AsstActTypeInfo();
            atInfo.setAsstHGAttribute((String)item.get("propname"));
            atInfo.setIsForCompany(((Boolean)item.get("isforcompany")).booleanValue());
            atInfo.setUseLongNumber(((Boolean)item.get("useLongNUmber")).booleanValue());
            GLF7Parameter f7Param = new GLF7Parameter();
            f7Param.setUnUse(true);
            f7Param.setOnlyLeaf(true);
            GeneralAsstActTypeGroupInfo grp = null;
            if (item.get("glgroup") != null) {
                grp = new GeneralAsstActTypeGroupInfo();
                grp.setId(BOSUuid.read((String)item.get("glgroup").toString()));
                atInfo.setGlAsstActTypeGrp(grp);
                f7Param.setGeneralShowLongNumber(((Boolean)item.get("useLongNUmber")).booleanValue());
            }
            GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)bizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)this.curCompany, (GLF7Parameter)f7Param);
            ObjectValueRender numNameRender = new ObjectValueRender();
            numNameRender.setFormat((IDataFormat)new BizDataFormat("$number$-$name$"));
            bizPromptBox.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        int beginRow = AcctCussentCheckFilterPanel.this.tblAsstItem.getSelectManager().get().getBeginRow();
                        IRow row = AcctCussentCheckFilterPanel.this.tblAsstItem.getRow(beginRow);
                        UIUtil.fireToChange(e, AcctCussentCheckFilterPanel.this.tblAsstItem, row);
                    }
                    catch (Exception exc) {
                        AcctCussentCheckFilterPanel.this.handUIException(exc);
                    }
                }
            });
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
            row.getCell("to").setEditor((ICellEditor)editor);
            row.getCell("to").setRenderer((IBasicRender)numNameRender);
            bizPromptBox = new KDBizPromptBox();
            bizPromptBox.setEditable(true);
            bizPromptBox.setEditFormat("$number$");
            bizPromptBox.setDisplayFormat("$number$ - $name$");
            bizPromptBox.setQueryInfo((String)item.get("queryname"));
            bizPromptBox.setCommitFormat("$longnumber;$number$;$name$");
            bizPromptBox.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        int beginRow = AcctCussentCheckFilterPanel.this.tblAsstItem.getSelectManager().get().getBeginRow();
                        IRow row = AcctCussentCheckFilterPanel.this.tblAsstItem.getRow(beginRow);
                        UIUtil.fireFromChange(e, AcctCussentCheckFilterPanel.this.tblAsstItem, row);
                    }
                    catch (Exception exc) {
                        AcctCussentCheckFilterPanel.this.handUIException(exc);
                    }
                }
            });
            GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)bizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)this.curCompany, (GLF7Parameter)f7Param);
            editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
            row.getCell("from").setEditor((ICellEditor)editor);
            row.getCell("from").setRenderer((IBasicRender)numNameRender);
            row.setUserObject((Object)item);
            UIUtil.loadDistBox(row, bizPromptBox, null, this.tblAsstItem);
        }
    }

    @Override
    protected void tblAsstItem_editStopped(KDTEditEvent e) throws Exception {
        Object toValue;
        KDTable table = (KDTable)e.getSource();
        int r = e.getRowIndex();
        int c = e.getColIndex();
        String key = table.getColumnKey(c);
        if (key.equals("from") && ((toValue = table.getRow(r).getCell("to").getValue()) == null || toValue.equals(""))) {
            table.getRow(r).getCell("to").setValue(table.getRow(r).getCell(c).getValue());
        }
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        Date dateTo;
        if (this.pbAccount.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_PATH, (String)"noaccount"));
            return false;
        }
        if (this.dpBusiDateFrom.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.client.AcctCussentResource.beginDateInvalid"));
            return false;
        }
        if (this.dpBusiDateTo.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.client.AcctCussentResource.endDateInvalid"));
            return false;
        }
        Date dateFrom = InitClientHelp.convertToSimpleDate((Date)this.dpBusiDateFrom.getValue());
        if (dateFrom.after(dateTo = InitClientHelp.convertToSimpleDate((Date)this.dpBusiDateTo.getValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_PATH, (String)"bizdatereverse"));
            return false;
        }
        boolean hasSelected = false;
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            IRow row = this.tblAsstItem.getRow(i);
            if (!row.getCell("selected").getValue().equals(Boolean.TRUE)) continue;
            hasSelected = true;
            break;
        }
        if (!hasSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_PATH, (String)"noitem"));
            return false;
        }
        int yearEnd = dateTo.getYear() + 1900;
        return !RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = dateFrom.getYear() + 1900, numberBegin = dateFrom.getMonth() + 1);
    }

    public HashMap getResult() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<HashMap> items = new ArrayList<HashMap>();
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            boolean isUseLongNumber;
            IRow row = this.tblAsstItem.getRow(i);
            HashMap item = (HashMap)row.getUserObject();
            boolean bl = isUseLongNumber = item.containsKey("useLongNUmber") && Boolean.valueOf(item.get("useLongNUmber").toString()) != false;
            if (row.getCell("selected").getValue().equals(Boolean.FALSE)) continue;
            String[] numbers = new String[2];
            Object o = row.getCell("from").getValue();
            if (o != null) {
                numbers[0] = o instanceof IObjectValue ? (isUseLongNumber ? (String)((IObjectValue)o).get("longnumber") : (String)((IObjectValue)o).get("number")) : (String)o;
            }
            if ((o = row.getCell("to").getValue()) != null) {
                numbers[1] = o instanceof IObjectValue ? (isUseLongNumber ? (String)((IObjectValue)o).get("longnumber") : (String)((IObjectValue)o).get("number")) : (String)o;
            }
            o = row.getCell("dist").getUserObject();
            item.put("numberfrom", numbers[0]);
            item.put("numberto", numbers[1]);
            item.put("dist", o);
            items.add(item);
        }
        result.put("items", items);
        result.put("currency", this.comboCurrency.getSelectedItem());
        result.put("bizdatefrom", (Date)this.dpBusiDateFrom.getValue());
        result.put("bizdateto", (Date)this.dpBusiDateTo.getValue());
        result.put("account", this.pbAccount.getValue());
        result.put("includeUnPosted", this.cbIncludeUnPosted.isSelected());
        result.put("includeFinished", this.cbIncludeFinished.isSelected());
        result.put("includeInitData", this.includeInitData.isSelected());
        result.put("hideNotHappened", this.cbHideNotHappened.isSelected());
        result.put("showBizNum", this.chkShowBizNum.isSelected());
        result.put("curCompany", this.bpCompany.getValue());
        return result;
    }

    public Object getParam() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ParamKey.includeUnPosted, this.cbIncludeUnPosted.isSelected());
        result.put(ParamKey.includeInitData, this.includeInitData.isSelected());
        result.put(ParamKey.hideNotHappened, this.cbHideNotHappened.isSelected());
        result.put(ParamKey.includeFinished, this.cbIncludeFinished.isSelected());
        result.put("showBizNum", this.chkShowBizNum.isSelected());
        Object objectCurrency = this.comboCurrency.getSelectedItem();
        String currencyID = null;
        String currencyName = null;
        if (objectCurrency instanceof CurrencyInfo) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            currencyID = currencyInfo.getId().toString();
            currencyName = currencyInfo.getName();
        } else if (GLResUtil.getRes("all_currency").equals((String)objectCurrency)) {
            currencyID = "AllCurrency";
            currencyName = (String)objectCurrency;
        }
        result.put(ParamKey.currencyId, currencyID);
        Date dateFrom = (Date)this.dpBusiDateFrom.getValue();
        result.put(ParamKey.beginDate, dateFrom);
        Date dateTo = (Date)this.dpBusiDateTo.getValue();
        result.put(ParamKey.endDate, dateTo);
        result.put(ParamKey.account, this.pbAccount.getValue());
        HashMap<String, Object[]> items = new HashMap<String, Object[]>();
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            IRow row = this.tblAsstItem.getRow(i);
            HashMap item = (HashMap)row.getUserObject();
            if (row.getCell("selected").getValue().equals(Boolean.FALSE)) continue;
            String[] numbers = new String[4];
            numbers[3] = (String)item.get("propname");
            Object[] objs = new Object[4];
            objs[3] = (String)item.get("propname");
            Object o = row.getCell("from").getValue();
            if (o != null) {
                if (o instanceof IObjectValue) {
                    objs[0] = o;
                } else {
                    numbers[0] = (String)((IObjectValue)o).get("number");
                }
            }
            if ((o = row.getCell("to").getValue()) != null) {
                if (o instanceof IObjectValue) {
                    objs[1] = o;
                } else {
                    numbers[1] = (String)((IObjectValue)o).get("number");
                }
            }
            if ((o = row.getCell("dist").getValue()) != null) {
                numbers[2] = (String)o;
            }
            if ((o = row.getCell("dist").getUserObject()) != null) {
                objs[2] = o;
            }
            if (objs[0] != null || objs[1] != null || objs[2] != null) {
                items.put(item.get("id") + "obj", objs);
                continue;
            }
            items.put((String)item.get("id"), numbers);
        }
        result.put(ParamKey.items, items);
        return result;
    }

    public void setParam(Object param) {
        Map result;
        block16: {
            String currencyId;
            block15: {
                result = (Map)param;
                if (param == null) {
                    return;
                }
                this.cbIncludeUnPosted.setSelected(((Boolean)result.get(ParamKey.includeUnPosted)).booleanValue());
                if (this.verifyMode == 2) {
                    this.cbIncludeUnPosted.setSelected(true);
                }
                this.cbIncludeFinished.setSelected(((Boolean)result.get(ParamKey.includeFinished)).booleanValue());
                Object initData = result.get(ParamKey.includeInitData);
                boolean flg = false;
                if (initData != null) {
                    flg = (Boolean)initData;
                }
                this.includeInitData.setSelected(flg);
                this.cbHideNotHappened.setSelected(((Boolean)result.get(ParamKey.hideNotHappened)).booleanValue());
                this.chkShowBizNum.setSelected(((Boolean)result.get("showBizNum")).booleanValue());
                currencyId = (String)result.get(ParamKey.currencyId);
                if (!"AllCurrency".equalsIgnoreCase(currencyId)) break block15;
                if (this.comboCurrency.getItemCount() == 0) break block16;
                this.comboCurrency.setSelectedIndex(this.comboCurrency.getItemCount() - 1);
                break block16;
            }
            for (int i = 0; i < this.comboCurrency.getItemCount(); ++i) {
                CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getItemAt(i);
                if (!info.getId().toString().equals(currencyId)) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
        Date beginDate = (Date)result.get(ParamKey.beginDate);
        this.dpBusiDateFrom.setValue((Object)beginDate);
        Date endDate = (Date)result.get(ParamKey.endDate);
        this.dpBusiDateTo.setValue((Object)endDate);
        try {
            this.pbAccount.setValue(result.get(ParamKey.account));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map items = (Map)result.get(ParamKey.items);
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            IRow row = this.tblAsstItem.getRow(i);
            HashMap userObject = (HashMap)row.getUserObject();
            Iterator iter = items.keySet().iterator();
            boolean isSelected = false;
            while (iter.hasNext()) {
                Object[] numbers;
                String id = (String)iter.next();
                if (id.equals(userObject.get("id"))) {
                    isSelected = true;
                    row.getCell("selected").setValue((Object)Boolean.TRUE);
                    numbers = (Object[])items.get(id);
                    if (numbers == null) continue;
                    if (!StringUtils.isEmpty((String)String.valueOf(numbers[0]))) {
                        row.getCell("from").setValue(numbers[0]);
                    }
                    if (StringUtils.isEmpty((String)String.valueOf(numbers[1]))) continue;
                    row.getCell("to").setValue(numbers[1]);
                    continue;
                }
                if (id.equals(userObject.get("id") + "obj")) {
                    isSelected = true;
                    Object[] objs = (Object[])items.get(id);
                    if (objs == null) continue;
                    if (objs[0] instanceof IObjectValue) {
                        row.getCell("from").setValue(objs[0]);
                    }
                    if (objs[1] instanceof IObjectValue) {
                        row.getCell("to").setValue(objs[1]);
                    }
                    if (objs[2] == null) continue;
                    this.loadDist(row, objs[2]);
                    continue;
                }
                if (!(items.get(id) instanceof Object[]) || ((Object[])items.get(id)).length <= 3 || !userObject.get("propname").equals(((Object[])items.get(id))[3])) continue;
                isSelected = true;
                row.getCell("selected").setValue((Object)Boolean.TRUE);
                numbers = (Object[])items.get(id);
                if (numbers == null) continue;
                if (!StringUtils.isEmpty((String)String.valueOf(numbers[0]))) {
                    row.getCell("from").setValue(numbers[0]);
                }
                if (!StringUtils.isEmpty((String)String.valueOf(numbers[1]))) {
                    row.getCell("to").setValue(numbers[1]);
                }
                if (numbers[2] == null) continue;
                this.loadDist(row, numbers[2]);
            }
            row.getCell("selected").setValue((Object)isSelected);
        }
    }

    private void loadDist(IRow row, Object temp) {
        if (temp instanceof Set) {
            String asstName = "";
            AssistViewFilterInfo avf2 = null;
            for (AssistViewFilterInfo avf2 : (Set)temp) {
                asstName = asstName + avf2.getName() + ";";
            }
            if (!"".equals(asstName)) {
                row.getCell("dist").setValue((Object)asstName);
            }
            row.getCell("dist").setUserObject(temp);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public void clear() {
        if (this.verifyMode == 2) {
            this.cbIncludeUnPosted.setSelected(true);
        } else {
            this.cbIncludeUnPosted.setSelected(false);
        }
        this.cbIncludeFinished.setSelected(true);
        this.cbHideNotHappened.setSelected(false);
        this.chkShowBizNum.setSelected(false);
        this.pbAccount.setValue(null);
        this.tblAsstItem.removeRows();
        this.dpBusiDateFrom.setValue((Object)new Date());
        this.dpBusiDateTo.setValue((Object)new Date());
        this.comboCurrency.setSelectedItem((Object)this.localCurrency);
        this.clearAsst();
    }

    private void clearAsst() {
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            IRow row = this.tblAsstItem.getRow(i);
            Boolean selected = (Boolean)row.getCell("selected").getValue();
            if (selected == null || !selected.booleanValue()) continue;
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("from").setValue(null);
            row.getCell("to").setValue(null);
            row.getCell("dist").setValue(null);
            row.getCell("dist").setUserObject(null);
        }
    }

    private static class ParamKey {
        static String currencyId = "CURRENCYID";
        static String includeUnPosted = "includeUnPosted";
        static String includeFinished = "includeFinished";
        static String includeInitData = "includeInitData";
        static String hideNotHappened = "hideNotHappened";
        static String account = "account";
        static String items = "items";
        static String beginDate = "beginDate";
        static String endDate = "endDate";

        private ParamKey() {
        }
    }
}

