/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractAcctCussentFilterPanel;
import com.kingdee.eas.fi.gl.client.CurrencyPrecision;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.client.GeneralBizPromptBox;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.IRptFilterObject;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AcctCussentFilterPanel
extends AbstractAcctCussentFilterPanel {
    private static final long serialVersionUID = -8538484897609519624L;
    private static final Logger logger = CoreUIObject.getLogger(AcctCussentFilterPanel.class);
    private AcctCussentFilterParam param;
    private CompanyOrgUnitInfo curCompany;
    private PeriodEntity pe;
    private boolean useReportingCurrency;
    private boolean foreignCurrencySU;
    private boolean aiShowNum;
    private HashMap hmComIdToCurPre;
    private int helperType;
    protected int verifyMode = 0;
    private boolean isAccessFromVoucherUI = false;
    protected Object[] initData = null;
    public static final Object ALL_CURRENCY = new Object(){

        public String toString() {
            return EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"ALLCURRENCY");
        }
    };

    public AcctCussentFilterPanel(int verifyMode, Object[] initData) throws Exception {
        this.verifyMode = verifyMode;
        this.initData = initData;
        this.initUIContentLayout();
        this.chkIncludeFinished.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AcctCussentFilterPanel.this.chkIncludeHolded.setSelected(true);
                }
            }
        });
        this.chkIncludeHolded.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    AcctCussentFilterPanel.this.chkIncludeFinished.setSelected(false);
                }
            }
        });
        this.chkIncludeHistory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AcctCussentFilterPanel.this.includeHistory(true);
                } else {
                    AcctCussentFilterPanel.this.includeHistory(false);
                }
            }
        });
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                AcctCussentFilterPanel.this.tblEditStopped(e);
            }
        });
        this.fetchInitFilterData(initData);
        this.tbl.checkParsed();
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        List list = (List)initData[13];
        this.tbl.getColumn("selected").setEditor((ICellEditor)new EditorFactory.BooleanEditor());
        InitClientHelp.setTableKeyBoardManager(this.tbl);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tbl.addRow();
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            row.setUserObject((Object)at);
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("type").setValue((Object)at.getName());
            row.getCell("propname").setValue((Object)at.getHgAttribute());
        }
        this.spnYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AcctCussentFilterPanel.this.spnYearTo_stateChanged(e);
            }
        });
        this.spnPeriodTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AcctCussentFilterPanel.this.spnYearTo_stateChanged(e);
            }
        });
        this.spnYearTo_stateChanged(null);
    }

    protected void includeHistory(boolean b) {
        block6: {
            PeriodEntity pe = (PeriodEntity)this.initData[10];
            if (b) {
                this.chkIncludeInit.setSelected(true);
                this.chkIncludeInit.setEnabled(false);
                PeriodInfo period = new PeriodInfo();
                period.setPeriodType(this.curCompany.getAccountPeriodType());
                period.setPeriodYear(pe.getCurrentYear());
                PeriodInfo periodInfo = null;
                try {
                    AccountRefContrastInfo info = (AccountRefContrastInfo)this.initData[12];
                    if (info != null && info.getEnabledPeriod() != null) {
                        periodInfo = PeriodUtils.getNextPeriodInfo((PeriodInfo)info.getEnabledPeriod());
                        this.spnYearFrom.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                        this.spnPeriodFrom.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
                        break block6;
                    }
                    this.spnYearFrom.setValue((Object)new Integer(pe.getUsedPeriod().getMinYear()));
                    this.spnPeriodFrom.setValue((Object)new Integer(pe.getUsedPeriod().getMinPeriod(pe.getMinYear())));
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                this.chkIncludeInit.setEnabled(true);
                this.spnYearFrom.setValue((Object)new Integer(pe.getUsedPeriod().getCurrentYear()));
                this.spnPeriodFrom.setValue((Object)new Integer(pe.getUsedPeriod().getCurrentPeriod()));
            }
        }
    }

    protected void spnYearTo_stateChanged(ChangeEvent e) {
        if (this.isAccessFromVoucherUI) {
            return;
        }
        int yearEnd = (Integer)this.spnYearTo.getValue();
        int numberEnd = (Integer)this.spnPeriodTo.getValue();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        RptClientUtil.periodChanged((IUIObject)this, this.curCompany, filter, yearEnd, numberEnd, this.pbxAccountFrom, this.pbxAccountTo);
    }

    public AcctCussentFilterPanel() throws Exception {
    }

    private void addF7(IRow row, AsstactTypeEntity at) {
        final AsstActTypeInfo atInfo = new AsstActTypeInfo();
        atInfo.setAsstHGAttribute(at.getHgAttribute());
        atInfo.setIsForCompany(at.isForCompany());
        atInfo.setUseLongNumber(at.isUseLongNumber());
        if (at.getGeneralAsstactGroupId() != null && at.getGeneralAsstactGroupId().trim().length() > 0) {
            GeneralAsstActTypeGroupInfo groupInfo = new GeneralAsstActTypeGroupInfo();
            groupInfo.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
            atInfo.setGlAsstActTypeGrp(groupInfo);
        }
        KDBizPromptBox bizPromptBoxTo = new KDBizPromptBox();
        bizPromptBoxTo.setEditable(true);
        bizPromptBoxTo.setEditFormat("$number$;$name$");
        bizPromptBoxTo.setCommitFormat("$number$;$name$");
        bizPromptBoxTo.setDisplayFormat("$longnumber$ $name$");
        bizPromptBoxTo.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isMultilevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        bizPromptBoxTo.setSelectorCollection(sic);
        bizPromptBoxTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object newValue = e.getNewValue();
                if (newValue instanceof GeneralAsstActTypeInfo) {
                    GeneralAsstActTypeInfo newVlalue1 = (GeneralAsstActTypeInfo)newValue;
                    newVlalue1.setLongNumber(newVlalue1.getString("originalLongNumber"));
                }
                try {
                    Object from;
                    Object old;
                    int beginRow = AcctCussentFilterPanel.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = AcctCussentFilterPanel.this.tbl.getRow(beginRow);
                    KDBizPromptBox toBox = (KDBizPromptBox)e.getSource();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = toBox.getEntityViewInfo() == null ? new FilterInfo() : toBox.getEntityViewInfo().getFilter();
                    FilterInfo newFilter = new FilterInfo();
                    Object to = e.getNewValue();
                    Object object = old = e.getOldValue() == null ? row.getCell("to").getValue() : e.getOldValue();
                    if (to != null && old != null && to instanceof IObjectValue && old instanceof IObjectValue) {
                        String id = ((IObjectValue)to).get("id").toString();
                        String oid = ((IObjectValue)old).get("id").toString();
                        if (id != null && id.equals(oid)) {
                            return;
                        }
                    }
                    if (to != null && to instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)to).get("number"), CompareType.LESS_EQUALS));
                    }
                    if ((from = row.getCell("from").getValue()) != null && from instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)from).get("number"), CompareType.GREATER_EQUALS));
                    }
                    newFilter.mergeFilter(filter, "and");
                    view.setFilter(newFilter);
                    AcctCussentFilterPanel.this.loadDisPromptBox(row, toBox, atInfo, view);
                    row.getCell("dist").setValue(null);
                    row.getCell("dist").setUserObject(null);
                }
                catch (BOSException e1) {
                    AcctCussentFilterPanel.this.handUIException(e1);
                }
            }
        });
        GLF7Parameter f7Param = new GLF7Parameter();
        f7Param.setOnlyLeaf(false);
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)bizPromptBoxTo, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)this.curCompany, (GLF7Parameter)f7Param);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBoxTo);
        row.getCell("to").setEditor((ICellEditor)editor);
        row.getCell("to").setValue(null);
        KDBizPromptBox bizPromptBoxFrom = new KDBizPromptBox();
        bizPromptBoxFrom.setEditable(true);
        bizPromptBoxFrom.setEditFormat("$number$;$name$");
        bizPromptBoxFrom.setCommitFormat("$number$;$name$");
        bizPromptBoxFrom.setDisplayFormat("$longnumber$ $name$");
        bizPromptBoxFrom.setQueryInfo(at.getQueryName());
        bizPromptBoxFrom.setSelectorCollection(sic);
        bizPromptBoxFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object newValue = e.getNewValue();
                if (newValue instanceof GeneralAsstActTypeInfo) {
                    GeneralAsstActTypeInfo newVlalue1 = (GeneralAsstActTypeInfo)newValue;
                    newVlalue1.setLongNumber(newVlalue1.getString("originalLongNumber"));
                }
                try {
                    Object to;
                    Object old;
                    int beginRow = AcctCussentFilterPanel.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = AcctCussentFilterPanel.this.tbl.getRow(beginRow);
                    if (e.getNewValue() != null && row.getCell("to").getValue() == null) {
                        row.getCell("to").setValue(newValue);
                    }
                    KDBizPromptBox fromBox = (KDBizPromptBox)e.getSource();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = fromBox.getEntityViewInfo() == null ? new FilterInfo() : fromBox.getEntityViewInfo().getFilter();
                    FilterInfo newFilter = new FilterInfo();
                    Object from = e.getNewValue();
                    Object object = old = e.getOldValue() == null ? row.getCell("from").getValue() : e.getOldValue();
                    if (from != null && old != null && from instanceof IObjectValue && old instanceof IObjectValue) {
                        String id = ((IObjectValue)from).get("id").toString();
                        String oid = ((IObjectValue)old).get("id").toString();
                        if (id != null && id.equals(oid)) {
                            return;
                        }
                    }
                    if (from != null && from instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)from).get("number"), CompareType.GREATER_EQUALS));
                    }
                    if ((to = row.getCell("to").getValue()) != null && to instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)to).get("number"), CompareType.LESS_EQUALS));
                    } else if (from != null) {
                        row.getCell("to").setValue(from);
                        newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)from).get("number"), CompareType.LESS_EQUALS));
                    }
                    newFilter.mergeFilter(filter, "and");
                    view.setFilter(newFilter);
                    AcctCussentFilterPanel.this.loadDisPromptBox(row, fromBox, atInfo, view);
                    row.getCell("dist").setValue(null);
                    row.getCell("dist").setUserObject(null);
                }
                catch (Exception exc) {
                    AcctCussentFilterPanel.this.handUIException(exc);
                }
            }
        });
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)bizPromptBoxFrom, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)this.curCompany, (GLF7Parameter)f7Param);
        editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBoxFrom);
        row.getCell("from").setEditor((ICellEditor)editor);
        row.getCell("from").setValue(null);
        this.loadDisPromptBox(row, bizPromptBoxFrom, atInfo, null);
    }

    private void loadDisPromptBox(IRow row, KDBizPromptBox bizPromptBox, AsstActTypeInfo atInfo, EntityViewInfo view) {
        KDBizPromptBox disBox = new KDBizPromptBox();
        disBox.setEditFormat("$number$");
        disBox.setDisplayFormat("$name$");
        disBox.setCommitFormat("$number$");
        disBox.setEditable(false);
        if (view == null) {
            view = bizPromptBox.getEntityViewInfo();
            view = (EntityViewInfo)view.clone();
            view = this.getDefaultView(row, view);
        }
        disBox.setEntityViewInfo(view);
        disBox.setSelector((KDPromptSelector)new GeneralBizPromptBox((IUIObject)this, view, bizPromptBox.getQueryInfo(), this.tbl, atInfo, "com.kingdee.eas.fi.gl.rpt.client.FilterForAssistF7UI"));
        row.getCell("dist").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)disBox));
    }

    private EntityViewInfo getDefaultView(IRow row, EntityViewInfo view) {
        Object to;
        if (view == null || view.getFilter() == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = view.getFilter();
        FilterInfo newFilter = new FilterInfo();
        Object from = row.getCell("from").getValue();
        if (from != null && from instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)from).get("number"), CompareType.GREATER_EQUALS));
        }
        if ((to = row.getCell("to").getValue()) != null && to instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)to).get("number"), CompareType.LESS_EQUALS));
        }
        try {
            newFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        view.setFilter(newFilter);
        return view;
    }

    public AcctCussentFilterPanel(Map context) throws Exception {
        this();
        this.initVerifyFilter(context);
    }

    public void initVerifyFilter(Map context) throws EASBizException, BOSException {
        this.chkIncludeHolded.setVisible(false);
        this.chkIncludeFinished.setVisible(false);
        AccountViewInfo acc = (AccountViewInfo)context.get("ACCOUNT");
        this.isAccessFromVoucherUI = context.get("IS_ACCESSFROM_VOUCHERUI") == null ? false : (Boolean)context.get("IS_ACCESSFROM_VOUCHERUI");
        this.pbxAccountFrom.setData((Object)acc);
        this.pbxAccountTo.setData((Object)acc);
        this.pbxAccountFrom.setEditable(false);
        this.pbxAccountTo.setEditable(false);
        this.pbxAccountFrom.setEnabled(false);
        this.pbxAccountTo.setEnabled(false);
        CurrencyInfo cur = (CurrencyInfo)context.get("CURRENCY");
        GlUtils.setSelectedItem(this.cbxCurrency, (CoreBaseInfo)cur);
        this.cbxCurrency.setEnabled(false);
        this.helperType = 1;
        if (this.isAccessFromVoucherUI) {
            AccountRefContrastInfo info = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(this.curCompany.getId().toString(), this.curCompany.getAccountTable().getId().toString());
            if (info != null && info.getEnabledPeriod() != null) {
                int i;
                this.chkIncludeHistory.setSelected(true, false);
                PeriodInfo periodInfo = PeriodUtils.getNextPeriodInfo((PeriodInfo)info.getEnabledPeriod());
                ((SpinnerNumberModel)this.spnYearFrom.getModel()).setMinimum(new Integer(periodInfo.getPeriodYear()));
                this.spnYearFrom.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                this.spnPeriodFrom.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
                ChangeListener[] _ls = this.spnYearTo.getChangeListeners();
                for (i = 0; i < _ls.length; ++i) {
                    this.spnYearTo.removeChangeListener(_ls[i]);
                }
                ((SpinnerNumberModel)this.spnYearTo.getModel()).setMinimum(new Integer(periodInfo.getPeriodYear()));
                for (i = 0; i < _ls.length; ++i) {
                    this.spnYearTo.addChangeListener(_ls[i]);
                }
            } else {
                this.spnYearFrom.setValue((Object)new Integer(this.pe.getUsedPeriod().getMinYear()));
                this.spnPeriodFrom.setValue((Object)new Integer(this.pe.getUsedPeriod().getMinPeriod(this.pe.getMinYear())));
            }
        }
    }

    public boolean isAiShowNum() {
        return this.aiShowNum;
    }

    public CompanyOrgUnitInfo getCurCompany() {
        return this.curCompany;
    }

    public String getStartPeriod() {
        Integer yearFrom = (Integer)this.spnYearFrom.getValue();
        Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
        return yearFrom + "." + periodFrom;
    }

    public String getEndPeriod() {
        Integer yearTo = (Integer)this.spnYearTo.getValue();
        Integer periodTo = (Integer)this.spnPeriodTo.getValue();
        return yearTo + "." + periodTo;
    }

    public String getCurrencyName() {
        return this.cbxCurrency.getSelectedItem().toString();
    }

    public String getAccountFrom() {
        AccountViewInfo accfromInfo;
        String num = null;
        if (this.pbxAccountFrom.getValue() instanceof AccountViewInfo && (accfromInfo = (AccountViewInfo)this.pbxAccountFrom.getValue()) != null) {
            num = accfromInfo.getNumber().trim();
        }
        return num;
    }

    public String getAccountTo() {
        AccountViewInfo accfromInfo;
        String num = "";
        if (this.pbxAccountTo.getValue() instanceof AccountViewInfo && (accfromInfo = (AccountViewInfo)this.pbxAccountTo.getValue()) != null) {
            num = accfromInfo.getNumber().trim();
        }
        if (num.length() == 0) {
            return null;
        }
        return this.helperType == 1 ? num : num + "~";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.verifyMode != 0) {
            this.chkIncludeHolded.setVisible(false);
            this.chkIncludeHistory.setVisible(false);
        }
        if (this.verifyMode != 1) {
            this.chkIncludeUnpost.setSelected(false);
            this.chkIncludeUnpost.setEnabled(false);
        }
        if (this.chkIncludeHistory.isSelected()) {
            this.chkIncludeInit.setSelected(true);
            this.chkIncludeInit.setEnabled(false);
        }
        this.setPeriodRange();
    }

    private void setPeriodRange() {
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        companyColl.add(SysContext.getSysContext().getCurrentFIUnit());
        try {
            Map pdRang = VoucherFacadeFactory.getRemoteInstance().getPeriodRange(companyColl, null);
            PeriodEntity pe = new PeriodEntity(pdRang);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            this.spnYearFrom.setEnabled(false);
            this.spnYearTo.setEnabled(false);
            this.spnPeriodFrom.setEnabled(false);
            this.spnPeriodTo.setEnabled(false);
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
        }
    }

    protected void fetchInitFilterData(Object[] initData) throws Exception {
        this.curCompany = this.getCurrentPanelCompany(initData);
        this.pe = (PeriodEntity)initData[10];
        SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.curCompany.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.curCompany.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        this.pbxAccountFrom.setEditable(true);
        this.pbxAccountFrom.setEditFormat("$number$");
        this.pbxAccountFrom.setCommitFormat("$helpCode$;$number$;$name$");
        this.pbxAccountFrom.setDisplayFormat("$number$ $name$");
        this.pbxAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxAccountFrom.setCommitParser((IParser)new AccountViewParser(this.pbxAccountFrom));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        this.pbxAccountFrom.setSelectorCollection(sic);
        AccountTableInfo accountTable = this.curCompany.getAccountTable();
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        companyColl.add(this.curCompany);
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
        this.pbxAccountFrom.setSelector((KDPromptSelector)apb);
        this.pbxAccountTo.setEditFormat("$number$");
        this.pbxAccountTo.setCommitFormat("$helpCode$;$number$;$name$");
        this.pbxAccountTo.setDisplayFormat("$number$ - $name$");
        this.pbxAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxAccountTo.setCommitParser((IParser)new AccountViewParser(this.pbxAccountTo));
        this.pbxAccountTo.setSelectorCollection(sic);
        this.pbxAccountTo.setSelector((KDPromptSelector)apb);
        view.setFilter(filter);
        this.pbxAccountFrom.setEntityViewInfo(view);
        this.pbxAccountTo.setEntityViewInfo(view);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.pbxAccountFrom.setEntityViewInfo(myevi);
        this.pbxAccountTo.setEntityViewInfo(myevi);
        this.cbxCurrency.removeAllItems();
        this.cbxCurrency.addItem(ALL_CURRENCY);
        CurrencyCollection curCol = (CurrencyCollection)initData[2];
        this.cbxCurrency.addItems(curCol.toArray());
        this.useReportingCurrency = (Boolean)initData[3];
        this.foreignCurrencySU = (Boolean)initData[4];
        this.aiShowNum = false;
        this.hmComIdToCurPre = new HashMap();
        if (!this.foreignCurrencySU) {
            CurrencyInfo localCur = this.curCompany.getBaseCurrency();
            if (!this.useReportingCurrency) {
                this.curCompany.setReportCurrency(localCur);
            }
            this.hmComIdToCurPre.put(this.curCompany.getId().toString(), new CurrencyPrecision(localCur.getPrecision(), this.curCompany.getReportCurrency().getPrecision()));
        }
    }

    public boolean isUseReportingCurrency() {
        return this.useReportingCurrency;
    }

    public boolean isForeignCurrencySU() {
        return this.foreignCurrencySU;
    }

    public HashMap getCurPre() {
        return this.hmComIdToCurPre;
    }

    public CurrencyInfo getCurCurrency() {
        if (!this.cbxCurrency.getSelectedItem().toString().equals(ALL_CURRENCY.toString())) {
            return (CurrencyInfo)this.cbxCurrency.getSelectedItem();
        }
        return null;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void syschronizeParam() {
        this.param = (AcctCussentFilterParam)this.getParam();
    }

    public AcctCussentFilterParam getParamOuter() {
        return this.param;
    }

    public FilterInfo getFilterInfo() {
        return this.getFilterInfo(false);
    }

    public FilterInfo getFilterInfo_new(boolean isFromBotp) {
        AccountViewInfo accfromInfo;
        boolean excludeUnpost;
        this.param = (AcctCussentFilterParam)this.getParam();
        int flag = this.param.getFlag();
        String curComId = this.curCompany.getId().toString();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)curComId));
        boolean isIncludeInit = (flag & 0x20) != 0;
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        maskString.append("#").append(index++).append(" AND ");
        int yearNumberFrom = this.spnYearFrom.getIntegerVlaue() * 100 + this.spnPeriodFrom.getIntegerVlaue();
        int yearNumberTo = this.spnYearTo.getIntegerVlaue() * 100 + this.spnPeriodTo.getIntegerVlaue();
        int[] periodRange = new int[]{yearNumberFrom, yearNumberTo};
        try {
            List periodList = RptClientUtil.getPeriodListByNumberRange(periodRange, this.curCompany, isIncludeInit);
            Set periodSet = SQLUtil.stringArrayToSet(periodList.toArray());
            fic.add(new FilterItemInfo("period.id", (Object)periodSet, CompareType.INCLUDE));
            maskString.append("#").append(index++).append(" ");
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handUIException(e);
        }
        fic.add(new FilterItemInfo("isinit", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isinit", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("isinitclosed", (Object)new Integer(1)));
        maskString.append(" AND( #" + index++ + " OR( #" + index++ + " AND #" + index++ + "))");
        boolean bl = excludeUnpost = (flag & 0x200) == 0 && this.verifyMode != 2;
        if (this.helperType == 1) {
            if (excludeUnpost) {
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(5)));
            } else {
                fic.add(new FilterItemInfo("voucher.bizStatus", null, CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            }
            fic.add(new FilterItemInfo("voucher.hasReversed", (Object)Boolean.FALSE));
            fic.add(new FilterItemInfo("voucher.isReverseVoucher", (Object)Boolean.FALSE));
            if (isIncludeInit) {
                fic.add(new FilterItemInfo("voucher.bizStatus", null));
                if (excludeUnpost) {
                    maskString.append(" AND ((#" + index++ + " AND #" + index++ + " AND #" + index++ + ") OR #" + index++ + ")");
                } else {
                    maskString.append(" AND ((#" + index++ + " AND #" + index++ + " AND #" + index++ + " AND #" + index++ + " AND #" + index++ + ") OR #" + index++ + ")");
                }
            } else if (excludeUnpost) {
                maskString.append(" AND (#" + index++ + " AND #" + index++ + " AND #" + index++ + ")");
            } else {
                maskString.append(" AND (#" + index++ + " AND #" + index++ + " AND #" + index++ + " AND #" + index++ + " AND #" + index++ + ")");
            }
        } else {
            if (excludeUnpost) {
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(5)));
            } else {
                fic.add(new FilterItemInfo("voucher.bizStatus", null, CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            }
            if (isIncludeInit) {
                fic.add(new FilterItemInfo("voucher.bizStatus", null));
            }
            if (isIncludeInit) {
                if (excludeUnpost) {
                    maskString.append(" AND ((#" + index++ + ") OR #" + index++ + ")");
                } else {
                    maskString.append(" AND ((#" + index++ + " AND #" + index++ + " AND #" + index++ + ") OR #" + index++ + ")");
                }
            } else if (excludeUnpost) {
                maskString.append(" AND (#" + index++ + ")");
            } else {
                maskString.append(" AND (#" + index++ + " AND #" + index++ + " AND #" + index++ + ")");
            }
        }
        if ((flag & 0x400) != 0) {
            maskString.append(" AND (ACCTCUSSENT.FUnVerifiedAmtFor-ACCTCUSSENT.FUnHoldedAmtFor=0 and ACCTCUSSENT.FUnVerifiedAmtFor-ACCTCUSSENT.FOriginalAmount=0)");
        } else if ((flag & 0x800) != 0) {
            maskString.append(" AND (ACCTCUSSENT.FUnVerifiedAmtFor-ACCTCUSSENT.FUnHoldedAmtFor!=0 or ACCTCUSSENT.FUnVerifiedAmtFor-ACCTCUSSENT.FOriginalAmount!=0)");
        }
        if ((flag & 1) != 0 && this.pbxAccountFrom.getValue() instanceof AccountViewInfo && (accfromInfo = (AccountViewInfo)this.pbxAccountFrom.getValue()) != null) {
            String accFrom = accfromInfo.getNumber().trim();
            fic.add(new FilterItemInfo("account.number", (Object)accFrom, CompareType.GREATER_EQUALS));
            maskString.append(" AND #" + index++);
        }
        if ((flag & 2) != 0 && this.pbxAccountTo.getValue() instanceof AccountViewInfo && (accfromInfo = (AccountViewInfo)this.pbxAccountTo.getValue()) != null) {
            String accTo = accfromInfo.getNumber().trim() + "z";
            fic.add(new FilterItemInfo("account.number", (Object)accTo, CompareType.LESS_EQUALS));
            maskString.append(" AND #" + index++);
        }
        if ((flag & 4) != 0) {
            CurrencyInfo cur = (CurrencyInfo)this.cbxCurrency.getSelectedItem();
            fic.add(new FilterItemInfo("currency.id", (Object)cur.getId().toString()));
            maskString.append(" AND #" + index++);
        }
        if (!isFromBotp) {
            if ((flag & 8) != 0 && this.verifyMode == 0) {
                fic.add(new FilterItemInfo("unHoldedAmtFor", (Object)GlUtils.zero, CompareType.NOTEQUALS));
                maskString.append(" AND #" + index++);
            }
            if ((flag & 0x10) != 0) {
                fic.add(new FilterItemInfo("unVerifiedAmtFor", (Object)GlUtils.zero, CompareType.NOTEQUALS));
                maskString.append(" AND #" + index++);
            }
        }
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            Boolean isSelected = (Boolean)row.getCell("selected").getValue();
            if (!isSelected.booleanValue()) continue;
            String propname = row.getCell("propname").getValue().toString();
            fic.add(new FilterItemInfo("assGrp." + propname + ".id", null, CompareType.NOTEQUALS));
            maskString.append(" AND #" + index++);
            IObjectValue from = (IObjectValue)row.getCell("from").getValue();
            IObjectValue to = (IObjectValue)row.getCell("to").getValue();
            if (from == null && to == null) continue;
            maskString.append(" AND (#");
            String propFiled = null;
            Object o = null;
            if (from != null) {
                if (from.get("longnumber") != null) {
                    propFiled = ".longnumber";
                    o = from.get("longnumber");
                } else {
                    propFiled = ".number";
                    o = from.get("number");
                }
                fic.add(new FilterItemInfo("assGrp." + propname + propFiled, o, CompareType.GREATER_EQUALS));
                maskString.append(index++);
            }
            if (to != null) {
                if (to.get("longnumber") != null) {
                    propFiled = ".longnumber";
                    o = to.get("longnumber");
                } else {
                    propFiled = ".number";
                    o = to.get("number");
                }
                fic.add(new FilterItemInfo("assGrp." + propname + propFiled, o, CompareType.LESS_EQUALS));
                maskString.append(from != null ? " and #" : "").append(index++);
            }
            maskString.append(")");
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorterItems = super.getSorterItems();
        if (sorterItems == null || sorterItems.size() <= 0) {
            sorterItems = new SorterItemCollection();
            sorterItems.add(new SorterItemInfo("bizDate"));
        }
        return sorterItems;
    }

    public FilterInfo getFilterInfo(boolean isFromBotp) {
        AccountViewInfo accfromInfo;
        boolean excludeUnpost;
        this.param = (AcctCussentFilterParam)this.getParam();
        int flag = this.param.getFlag();
        String curComId = this.curCompany.getId().toString();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)curComId));
        StringBuffer maskString = new StringBuffer("#0");
        int index = 1;
        fic.add(new FilterItemInfo("isinit", (Object)new Integer(0)));
        maskString.append(" AND( #" + index++);
        fic.add(new FilterItemInfo("isinit", (Object)new Integer(1)));
        maskString.append(" OR( #" + index++);
        fic.add(new FilterItemInfo("isinitclosed", (Object)new Integer(1)));
        maskString.append(" AND #" + index++ + "))");
        maskString.append("AND (((");
        Integer yearFrom = (Integer)this.spnYearFrom.getValue();
        Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
        Integer yearTo = (Integer)this.spnYearTo.getValue();
        Integer periodTo = (Integer)this.spnPeriodTo.getValue();
        if ((flag & 0x40) != 0) {
            fic.add(new FilterItemInfo("period.periodYear", (Object)yearFrom));
            fic.add(new FilterItemInfo("period.periodNumber", (Object)periodFrom));
            maskString.append("#" + index++ + " AND ");
            maskString.append("#" + index++ + ")");
        } else if ((flag & 0x80) != 0) {
            fic.add(new FilterItemInfo("period.periodYear", (Object)yearFrom));
            fic.add(new FilterItemInfo("period.periodNumber", (Object)periodFrom, CompareType.GREATER_EQUALS));
            fic.add(new FilterItemInfo("period.periodNumber", (Object)periodTo, CompareType.LESS_EQUALS));
            maskString.append("#" + index++ + " AND ");
            maskString.append("#" + index++ + " AND ");
            maskString.append("#" + index++ + ")");
        } else {
            fic.add(new FilterItemInfo("period.periodYear", (Object)yearFrom));
            fic.add(new FilterItemInfo("period.periodNumber", (Object)periodFrom, CompareType.GREATER_EQUALS));
            fic.add(new FilterItemInfo("period.periodYear", (Object)yearFrom, CompareType.GREATER));
            fic.add(new FilterItemInfo("period.periodYear", (Object)yearTo));
            fic.add(new FilterItemInfo("period.periodNumber", (Object)periodTo, CompareType.LESS_EQUALS));
            fic.add(new FilterItemInfo("period.periodYear", (Object)yearTo, CompareType.LESS));
            maskString.append("((#" + index++ + " AND ");
            maskString.append("#" + index++ + ") OR ");
            maskString.append("#" + index++ + ") AND ");
            maskString.append("((#" + index++ + " AND ");
            maskString.append("#" + index++ + ") OR ");
            maskString.append("#" + index++ + "))");
        }
        boolean bl = excludeUnpost = (flag & 0x200) == 0 && this.verifyMode != 2;
        if (this.helperType == 1) {
            if (excludeUnpost) {
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(5)));
            } else {
                fic.add(new FilterItemInfo("voucher.bizStatus", null, CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            }
            fic.add(new FilterItemInfo("voucher.hasReversed", (Object)Boolean.FALSE));
            fic.add(new FilterItemInfo("voucher.isReverseVoucher", (Object)Boolean.FALSE));
            if ((flag & 0x20) != 0) {
                fic.add(new FilterItemInfo("voucher.bizStatus", null));
                if (excludeUnpost) {
                    maskString.append(" AND ((#" + index++ + " AND #" + index++ + " AND #" + index++ + ")) OR #" + index++ + "))");
                } else {
                    maskString.append(" AND ((#" + index++ + " AND #" + index++ + " AND #" + index++ + " AND #" + index++ + " AND #" + index++ + ")) OR #" + index++ + "))");
                }
            } else if (excludeUnpost) {
                maskString.append(" AND #" + index++ + " AND #" + index++ + " AND #" + index++ + "))");
            } else {
                maskString.append(" AND #" + index++ + " AND #" + index++ + " AND #" + index++ + " AND #" + index++ + " AND #" + index++ + "))");
            }
        } else {
            if (excludeUnpost) {
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(5)));
            } else {
                fic.add(new FilterItemInfo("voucher.bizStatus", null, CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("voucher.bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            }
            if ((flag & 0x20) != 0) {
                fic.add(new FilterItemInfo("voucher.bizStatus", null));
            }
            if ((flag & 0x20) != 0) {
                if (excludeUnpost) {
                    maskString.append(" AND ((#" + index++ + ")) OR #" + index++ + "))");
                } else {
                    maskString.append(" AND ((#" + index++ + " AND #" + index++ + " AND #" + index++ + ")) OR #" + index++ + "))");
                }
            } else if (excludeUnpost) {
                maskString.append(")) AND ((#" + index++ + "))");
            } else {
                maskString.append(")) AND ((#" + index++ + " AND #" + index++ + " AND #" + index++ + "))");
            }
        }
        if ((flag & 0x400) != 0) {
            maskString.append(" AND (ACCTCUSSENT.FUnVerifiedAmtFor-ACCTCUSSENT.FUnHoldedAmtFor=0 and ACCTCUSSENT.FUnVerifiedAmtFor-ACCTCUSSENT.FOriginalAmount=0)");
        } else if ((flag & 0x800) != 0) {
            maskString.append(" AND (ACCTCUSSENT.FUnVerifiedAmtFor-ACCTCUSSENT.FUnHoldedAmtFor!=0 or ACCTCUSSENT.FUnVerifiedAmtFor-ACCTCUSSENT.FOriginalAmount!=0)");
        }
        if ((flag & 1) != 0 && this.pbxAccountFrom.getValue() instanceof AccountViewInfo && (accfromInfo = (AccountViewInfo)this.pbxAccountFrom.getValue()) != null) {
            String accFrom = accfromInfo.getNumber().trim();
            fic.add(new FilterItemInfo("account.number", (Object)accFrom, CompareType.GREATER_EQUALS));
            maskString.append(" AND #" + index++);
        }
        if ((flag & 2) != 0 && this.pbxAccountTo.getValue() instanceof AccountViewInfo && (accfromInfo = (AccountViewInfo)this.pbxAccountTo.getValue()) != null) {
            String accTo = accfromInfo.getNumber().trim() + "z";
            fic.add(new FilterItemInfo("account.number", (Object)accTo, CompareType.LESS_EQUALS));
            maskString.append(" AND #" + index++);
        }
        if ((flag & 4) != 0) {
            CurrencyInfo cur = (CurrencyInfo)this.cbxCurrency.getSelectedItem();
            fic.add(new FilterItemInfo("currency.id", (Object)cur.getId().toString()));
            maskString.append(" AND #" + index++);
        }
        if (!isFromBotp) {
            if ((flag & 8) != 0 && this.verifyMode == 0) {
                fic.add(new FilterItemInfo("unHoldedAmtFor", (Object)GlUtils.zero, CompareType.NOTEQUALS));
                maskString.append(" AND #" + index++);
            }
            if ((flag & 0x10) != 0) {
                fic.add(new FilterItemInfo("unVerifiedAmtFor", (Object)GlUtils.zero, CompareType.NOTEQUALS));
                maskString.append(" AND #" + index++);
            }
        }
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            Boolean isSelected = (Boolean)row.getCell("selected").getValue();
            if (!isSelected.booleanValue()) continue;
            String propname = row.getCell("propname").getValue().toString();
            fic.add(new FilterItemInfo("assGrp." + propname + ".id", null, CompareType.NOTEQUALS));
            maskString.append(" AND #" + index++);
            IObjectValue from = (IObjectValue)row.getCell("from").getValue();
            IObjectValue to = (IObjectValue)row.getCell("to").getValue();
            Object dist = row.getCell("dist").getUserObject();
            if (dist != null) {
                String filedName;
                HashSet<String> numbers = new HashSet<String>();
                boolean isGeneralAssActType = propname.startsWith("generalAssActType");
                String string = filedName = isGeneralAssActType ? "longNumber" : "number";
                if (dist instanceof Set) {
                    AssistViewFilterInfo avf2 = null;
                    for (AssistViewFilterInfo avf2 : (Set)dist) {
                        numbers.add(isGeneralAssActType ? avf2.getNumber().replace(".", "!") : avf2.getNumber());
                    }
                }
                maskString.append(" AND (#");
                fic.add(new FilterItemInfo("assGrp." + propname + "." + filedName, numbers, CompareType.INCLUDE));
                maskString.append(index++);
                maskString.append(")");
                continue;
            }
            if (from == null && to == null) continue;
            maskString.append(" AND (#");
            String propFiled = null;
            Object o = null;
            if (from != null) {
                if (from.get("longnumber") != null) {
                    propFiled = ".longnumber";
                    o = from.get("longnumber");
                } else {
                    propFiled = ".number";
                    o = from.get("number");
                }
                fic.add(new FilterItemInfo("assGrp." + propname + propFiled, o, CompareType.GREATER_EQUALS));
                maskString.append(index++);
            }
            if (to != null) {
                if (to.get("longnumber") != null) {
                    propFiled = ".longnumber";
                    o = to.get("longnumber");
                } else {
                    propFiled = ".number";
                    o = to.get("number");
                }
                fic.add(new FilterItemInfo("assGrp." + propname + propFiled, o, CompareType.LESS_EQUALS));
                maskString.append(from != null ? " and #" : "").append(index++);
            }
            maskString.append(")");
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    public void loadData(EntityViewInfo view) {
        Integer periodFrom;
        Integer periodTo;
        Integer yearFrom;
        Integer yearTo;
        boolean isIncludeInit;
        this.clear();
        if (view == null || view.getFilter() == null) {
            return;
        }
        FilterItemCollection fic = view.getFilter().getFilterItems();
        if (this.param == null) {
            return;
        }
        int flag = this.param.getFlag();
        int index = 1;
        boolean bl = isIncludeInit = (flag & 0x20) != 0;
        if (this.helperType == 1) {
            index += 3;
            if (isIncludeInit) {
                ++index;
            }
        }
        if (isIncludeInit) {
            index += 3;
            this.chkIncludeInit.setSelected(true);
        } else {
            this.chkIncludeInit.setSelected(false);
        }
        if ((flag & 0x40) != 0) {
            yearFrom = yearTo = (Integer)fic.get(index++).getCompareValue();
            periodFrom = periodTo = (Integer)fic.get(index++).getCompareValue();
        } else if ((flag & 0x80) != 0) {
            yearFrom = yearTo = (Integer)fic.get(index++).getCompareValue();
            periodFrom = (Integer)fic.get(index++).getCompareValue();
            periodTo = (Integer)fic.get(index++).getCompareValue();
        } else {
            yearFrom = (Integer)fic.get(index++).getCompareValue();
            periodFrom = (Integer)fic.get(index++).getCompareValue();
            int n = ++index;
            yearTo = (Integer)fic.get(n).getCompareValue();
            int n2 = ++index;
            ++index;
            periodTo = (Integer)fic.get(n2).getCompareValue();
            ++index;
        }
        this.spnYearFrom.setValue((Object)yearFrom);
        this.spnPeriodFrom.setValue((Object)periodFrom);
        this.spnYearTo.setValue((Object)yearTo);
        this.spnPeriodTo.setValue((Object)periodTo);
        HashMap otherData = this.param.getData();
        this.pbxAccountFrom.setData(otherData.get("ACCOUNT_FROM"));
        this.pbxAccountTo.setData(otherData.get("ACCOUNT_TO"));
        if ((flag & 4) != 0) {
            Object value;
            if ((value = fic.get(index++).getCompareValue()) != null) {
                try {
                    BOSUuid curId = BOSUuid.read((String)value.toString());
                    GlUtils.setSelectedItem(this.cbxCurrency, curId);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        } else {
            this.cbxCurrency.setSelectedItem(ALL_CURRENCY);
        }
        if ((flag & 8) != 0) {
            ++index;
            this.chkIncludeHolded.setSelected(false);
        } else {
            this.chkIncludeHolded.setSelected(true);
        }
        if ((flag & 0x10) != 0) {
            ++index;
            this.chkIncludeFinished.setSelected(false);
        } else {
            this.chkIncludeFinished.setSelected(true);
        }
        if ((flag & 0x200) != 0) {
            ++index;
            this.chkIncludeUnpost.setSelected(true);
        } else {
            this.chkIncludeUnpost.setSelected(false);
        }
        if ((flag & 0x400) != 0) {
            ++index;
            this.radioUnVerified.setSelected(true);
        } else if ((flag & 0x800) != 0) {
            ++index;
            this.radioVerified.setSelected(true);
        } else {
            this.radioAll.setSelected(true);
        }
        if ((flag & 0x1000) != 0) {
            this.chkIncludeHistory.setSelected(true, false);
        } else {
            this.chkIncludeHistory.setSelected(false, false);
        }
        if (this.chkIncludeHistory.isVisible() && !this.chkIncludeHistory.isSelected()) {
            this.chkIncludeInit.setEnabled(true);
        } else {
            this.chkIncludeInit.setEnabled(false);
        }
        if (otherData != null && otherData.size() > 0) {
            for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                IRow row = this.tbl.getRow(i);
                String type = row.getCell("type").getValue().toString();
                if (otherData.get(type) != null) {
                    row.getCell("selected").setValue((Object)Boolean.TRUE);
                }
                if (otherData.get(type + "from") == null && otherData.get(type + "to") == null) continue;
                row.getCell("from").setValue(otherData.get(type + "from"));
                row.getCell("to").setValue(otherData.get(type + "to"));
            }
        }
        if (this.verifyMode == 2) {
            this.chkIncludeUnpost.setSelected(false);
        }
        this.chkDspReverseVch.setSelected(this.param.isIncludeReversed());
    }

    public Object getParam() {
        String accountTo;
        if (this.param == null) {
            this.param = new AcctCussentFilterParam();
        }
        int flag = 0;
        String accountFrom = this.pbxAccountFrom.getText().trim();
        if (accountFrom.length() != 0) {
            flag |= 1;
        }
        if ((accountTo = this.pbxAccountTo.getText().trim()).length() != 0) {
            flag |= 2;
        }
        if (this.cbxCurrency.getSelectedItem() != ALL_CURRENCY) {
            flag |= 4;
        }
        if (!this.chkIncludeHolded.isSelected()) {
            flag |= 8;
        }
        if (!this.chkIncludeFinished.isSelected()) {
            flag |= 0x10;
        }
        if (this.chkIncludeInit.isSelected()) {
            flag |= 0x20;
        }
        if (this.chkIncludeUnpost.isSelected()) {
            flag |= 0x200;
        }
        if (this.radioUnVerified.isSelected()) {
            flag |= 0x400;
        }
        if (this.radioVerified.isSelected()) {
            flag |= 0x800;
        }
        if (this.chkIncludeHistory.isSelected()) {
            flag |= 0x1000;
        }
        Integer yearFrom = (Integer)this.spnYearFrom.getValue();
        Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
        Integer yearTo = (Integer)this.spnYearTo.getValue();
        Integer periodTo = (Integer)this.spnPeriodTo.getValue();
        flag = yearFrom.equals(yearTo) ? (periodFrom.equals(periodTo) ? (flag |= 0x40) : (flag |= 0x80)) : (flag |= 0x100);
        this.param.setFlag(flag);
        HashMap<Object, Object> otherData = new HashMap<Object, Object>();
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            Boolean isSelected = (Boolean)row.getCell("selected").getValue();
            if (!isSelected.booleanValue()) continue;
            otherData.put(row.getCell("type").getValue(), "true");
            Object from = row.getCell("from").getValue();
            Object to = row.getCell("to").getValue();
            Object dist = row.getCell("dist").getUserObject();
            if (from == null && to == null && dist == null) continue;
            String type = row.getCell("type").getValue().toString();
            otherData.put(type + "from", from);
            otherData.put(type + "to", to);
            otherData.put(type + "dist", dist);
        }
        otherData.put("ACCOUNT_FROM", this.pbxAccountFrom.getValue());
        otherData.put("ACCOUNT_TO", this.pbxAccountTo.getValue());
        this.param.setData(otherData);
        this.param.setIncludeReversed(this.chkDspReverseVch.isSelected());
        this.param.setIncludeUnPost(this.chkIncludeUnpost.isSelected());
        return this.param;
    }

    public void setParam(Object p) {
        this.param = (AcctCussentFilterParam)p;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            SysUtil.abort();
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public void clear() {
        super.clear();
        this.spnYearFrom.setValue((Object)new Integer(this.pe.getCurrentYear()));
        this.spnYearTo.setValue((Object)new Integer(this.pe.getCurrentYear()));
        this.spnPeriodFrom.setValue((Object)new Integer(this.pe.getCurrentPeriod()));
        this.spnPeriodTo.setValue((Object)new Integer(this.pe.getCurrentPeriod()));
        this.pbxAccountFrom.setData(null);
        this.pbxAccountTo.setData(null);
        this.cbxCurrency.setSelectedItem(ALL_CURRENCY);
        if (this.chkIncludeHistory.isVisible()) {
            this.chkIncludeHistory.setSelected(true, false);
            this.includeHistory(true);
        }
        this.chkIncludeInit.setSelected(true);
        this.chkIncludeFinished.setSelected(false);
        this.chkIncludeHolded.setSelected(false);
        this.chkIncludeUnpost.setSelected(false);
        this.radioAll.setSelected(true);
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("from").setValue(null);
            row.getCell("to").setValue(null);
            row.getCell("dist").setValue(null);
        }
        this.chkDspReverseVch.setSelected(true);
    }

    public void setCurCompany(CompanyOrgUnitInfo curCompany) {
        this.curCompany = curCompany;
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        int yearEnd = (Integer)this.spnYearTo.getValue();
        return !RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.spnYearFrom.getValue()).intValue(), numberBegin = ((Integer)this.spnPeriodFrom.getValue()).intValue());
    }

    @Override
    protected void pbxAccountFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.pbxAccountFrom.getValue();
        Object accountTo = this.pbxAccountTo.getValue();
        if (accountFrom != null && accountTo == null) {
            this.pbxAccountTo.setValue(accountFrom);
        }
        this.pbxAccountFrom.setAutoFocusNextComponent(false);
        this.pbxAccountTo.requestFocus();
    }

    protected void tblEditStopped(KDTEditEvent e) {
        if (e.getColIndex() == 0) {
            this.tbl.getCell(e.getRowIndex(), 0).setValue(e.getValue());
            boolean isSelect = (Boolean)e.getValue();
            if (isSelect) {
                IRow row = this.tbl.getRow(e.getRowIndex());
                AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                this.addF7(row, at);
            }
        }
    }

    private CompanyOrgUnitInfo getCurrentPanelCompany(Object[] initData) {
        CompanyOrgUnitInfo company = null;
        company = initData[0] != null ? (CompanyOrgUnitInfo)initData[0] : SysContext.getSysContext().getCurrentFIUnit();
        return company;
    }

    public static class AcctCussentFilterParam
    implements Serializable,
    IRptFilterObject {
        private static final long serialVersionUID = 2316503670592533773L;
        public static final int HAS_ACCOUNT_FROM = 1;
        public static final int HAS_ACCOUNT_TO = 2;
        public static final int HAS_CURRENCY = 4;
        public static final int EXCLUDE_HOLDED = 8;
        public static final int EXCLUDE_FINISHED = 16;
        public static final int INCLUDE_INIT = 32;
        public static final int SINGLE_PERIOD = 64;
        public static final int SAME_YEAR = 128;
        public static final int DIFF_YEAR = 256;
        public static final int INCLUDE_UNPOST = 512;
        public static final int INCLUDE_UNVERIFIED = 1024;
        public static final int INCLUDE_VERIFIED = 2048;
        public static final int INCLUDE_HISTORY = 4096;
        private int flag = 0;
        private HashMap data;
        private boolean includeReversed = true;
        private boolean includeUnPost = false;

        public AcctCussentFilterParam() {
        }

        public AcctCussentFilterParam(int f) {
            this.flag = f;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int f) {
            this.flag = f;
        }

        public void setData(HashMap data) {
            this.data = data;
        }

        public HashMap getData() {
            return this.data;
        }

        public IRptFilterObject toIRptFilerObject(RptFilterInfo rptFilterMap) {
            AcctCussentFilterParam param = new AcctCussentFilterParam();
            param.flag = rptFilterMap.getInt("flag");
            param.data = (HashMap)rptFilterMap.getObject("data");
            param.includeReversed = rptFilterMap.getBoolean("includeReversed");
            return param;
        }

        public RptFilterInfo toRptFilterInfo() {
            RptFilterInfo rptInfo = new RptFilterInfo();
            rptInfo.setRptFilterObjectClassName(this.getClass().getName());
            rptInfo.setInt("flag", this.flag);
            rptInfo.setObject("data", (Object)this.data);
            rptInfo.setBoolean("includeReversed", this.includeReversed);
            return rptInfo;
        }

        public void setIncludeReversed(boolean includeReversed) {
            this.includeReversed = includeReversed;
        }

        public boolean isIncludeReversed() {
            return this.includeReversed;
        }

        public boolean isIncludeUnPost() {
            return this.includeUnPost;
        }

        public void setIncludeUnPost(boolean includeUnPost) {
            this.includeUnPost = includeUnPost;
        }
    }
}

