/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.GLAcctCussentGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.IAcctCussent;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.ReportConditionAcctCussentGeneral;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.client.AbstractAcctCussentGeneralListUI;
import com.kingdee.eas.fi.gl.client.AcctCussentGeneralFilterPanelUI;
import com.kingdee.eas.fi.gl.client.AcctCussentSubsidiaryUI;
import com.kingdee.util.LowTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AcctCussentGeneralListUI
extends AbstractAcctCussentGeneralListUI {
    private static final Logger logger = CoreUIObject.getLogger(AcctCussentGeneralListUI.class);
    protected CommonQueryDialog conditionDialog;
    AcctCussentGeneralFilterPanelUI conditionPanel;
    ReportConditionAcctCussentGeneral condition = null;
    private Object[] filterInitData = null;

    public AcctCussentGeneralListUI() throws Exception {
        this.tblMain.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int i = e.getSelectBlock().getTop();
                if (i >= 0) {
                    if (AcctCussentGeneralListUI.this.tblMain.getRow(i).getUserObject() == null) {
                        AcctCussentGeneralListUI.this.actionQueryAcctCussent.setEnabled(false);
                    } else {
                        AcctCussentGeneralListUI.this.actionQueryAcctCussent.setEnabled(true);
                    }
                }
            }
        });
        String curComId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        Object[] param = new Object[21];
        param[0] = curComId;
        IAcctCussent cussentCtrl = AcctCussentFactory.getRemoteInstance();
        this.filterInitData = cussentCtrl.fetchInitFilterData(param);
    }

    @Override
    public void actionQueryAcctCussent_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.setCursorOfWair();
            this.findAcctCussent();
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    private void findAcctCussent() throws Exception {
        KDTSelectBlock sb = this.tblMain.getSelectManager().get();
        if (sb != null && this.condition != null) {
            int top = sb.getTop();
            IRow row = this.tblMain.getRow(top);
            EntityViewInfo currentCondition = this.getCondition();
            if (currentCondition == null) {
                return;
            }
            ReportConditionBase glCondition = (ReportConditionBase)currentCondition.get("GLFixCondition");
            if (glCondition == null) {
                return;
            }
            if (row.getCell(4).getValue() == null) {
                return;
            }
            EntityViewInfo subsidiaryLedgerCondition = (EntityViewInfo)currentCondition.clone();
            ReportConditionAcctCussentGeneral fixCondition = new ReportConditionAcctCussentGeneral(glCondition);
            if (row.getUserObject() != null) {
                fixCondition.setAccountCodeStart(row.getCell(1).getValue().toString());
                fixCondition.setAccountCodeEnd(row.getCell(1).getValue().toString());
                fixCondition.setCurrencyName(row.getCell(3).getValue().toString());
                if (row.getCell(0).getValue() != null) {
                    String[] yearMonth = row.getCell(0).getValue().toString().trim().split("\\.");
                    fixCondition.setPeriodYearStart(new Integer(yearMonth[0]));
                    fixCondition.setPeriodNumberStart(new Integer(yearMonth[1]));
                    fixCondition.setPeriodYearEnd(new Integer(yearMonth[0]));
                    fixCondition.setPeriodNumberEnd(new Integer(yearMonth[1]));
                } else {
                    fixCondition.setPeriodYearStart(-1);
                    fixCondition.setPeriodNumberStart(-1);
                    fixCondition.setPeriodYearEnd(-1);
                    fixCondition.setPeriodNumberEnd(-1);
                }
                subsidiaryLedgerCondition.put("GLFixCondition", (Object)fixCondition);
                subsidiaryLedgerCondition.put("CURPER", row.getCell(3).getUserObject());
                AcctCussentSubsidiaryUI.queryByCondition(subsidiaryLedgerCondition, (CoreUIObject)this, (CompanyOrgUnitInfo)this.getUIContext().get("company"));
            }
        }
    }

    protected void initListener() {
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (!AcctCussentGeneralListUI.this.actionQueryAcctCussent.isEnabled()) {
                        return;
                    }
                    try {
                        AcctCussentGeneralListUI.this.setCursorOfWair();
                        AcctCussentGeneralListUI.this.findAcctCussent();
                    }
                    catch (Exception exc) {
                        AcctCussentGeneralListUI.this.handUIException(exc);
                    }
                    finally {
                        AcctCussentGeneralListUI.this.setCursorOfDefault();
                    }
                }
            }
        });
        super.initVirtualCompanyListener();
    }

    @Override
    protected void query(EntityViewInfo mainQuery) throws Exception {
        this.getConditionDialog();
        this.condition = ((AcctCussentGeneralFilterPanelUI)this.getConditionPanel()).getCustomCondition();
        mainQuery.put("GLFixCondition", (Object)this.condition);
        this.setCondition(mainQuery);
        this.tblMain.removeRows();
    }

    @Override
    public CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new AcctCussentGeneralFilterPanelUI();
            this.conditionPanel.setInitData(this.filterInitData);
        }
        return this.conditionPanel;
    }

    @Override
    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.conditionDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(400);
            this.conditionDialog.setHeight(365);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setTitle(this.getConditionPanel().getUITitle());
            try {
                this.conditionDialog.init();
            }
            catch (Exception e) {
                logger.error((Object)"AcctCussentGeneralListUI init querydialog error:", (Throwable)e);
            }
        }
        return this.conditionDialog;
    }

    @Override
    protected IGLReport getRemoteInstance() throws BOSException {
        return GLAcctCussentGeneralFacadeFactory.getRemoteInstance();
    }

    @Override
    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilter_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        e.setDataRequestMode(1);
        try {
            this.setCursorOfWair();
            if (e.getDataRequestMode() == 0) {
                return;
            }
            LowTimer t = new LowTimer();
            t.reset();
            IGLReport report = null;
            try {
                EntityViewInfo evi = this.getCondition();
                ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
                customCondition.setNewQuery(e.getFirstRow() == 0);
                report = this.getRemoteInstance();
                this.setCompanyCondition(this.getCondition());
                this.result = report.findData(this.getCondition(), e.getFirstRow(), e.getLastRow() - e.getFirstRow() + 1, this.getTempTableName(), (CompanyOrgUnitInfo)this.getUIContext().get("company"), false);
                this.setTempTableName(this.result.getTempTableName());
                this.showResult(this.result, this.getTable(), e.getFirstRow());
            }
            catch (Exception err) {
                this.getTable().setRowCount(0);
                this.setTempTableName(null);
                this.handUIException(err);
            }
            Object var3_3 = null;
        }
        finally {
            this.setCursorOfDefault();
        }
        this.tblMain.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(8).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(9).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(10).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    protected void initTableHead(ReportTableHeadInfo tableHeadInfo, KDTable tableForInit) {
    }

    @Override
    protected void showData(Collection data, KDTable tableForShowData, int startRow) {
        if (data == null || tableForShowData == null) {
            return;
        }
        int index = startRow;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            IRow row = tableForShowData.addRow(index++);
            Object[] lineObjects = (Object[])iterator.next();
            if (lineObjects == null) continue;
            int pre = 0;
            if ((Integer)lineObjects[11] != null) {
                pre = (Integer)lineObjects[11];
            }
            if (pre == 0) {
                pre = 2;
            }
            for (int i = 0; i < 11; ++i) {
                ICell cell = row.getCell(i);
                if (cell == null || lineObjects[i] == null) continue;
                if (!BigDecimal.class.isInstance(lineObjects[i])) {
                    cell.setValue(lineObjects[i]);
                    continue;
                }
                cell.setValue(lineObjects[i]);
            }
            Color color = AcctCussentGeneralListUI.getColor((Integer)lineObjects[lineObjects.length - 2]);
            if (!color.equals(NORMAL_COLOR)) {
                row.getStyleAttributes().setBackground(color);
            }
            row.getCell(5).getStyleAttributes().setNumberFormat(this.getDecimalFormat(pre));
            row.getCell(6).getStyleAttributes().setNumberFormat(this.getDecimalFormat(pre));
            row.getCell(7).getStyleAttributes().setNumberFormat(this.getDecimalFormat(pre));
            row.getCell(8).getStyleAttributes().setNumberFormat(this.getDecimalFormat(pre));
            row.getCell(9).getStyleAttributes().setNumberFormat(this.getDecimalFormat(pre));
            row.getCell(10).getStyleAttributes().setNumberFormat(this.getDecimalFormat(pre));
            row.getCell(3).setUserObject(lineObjects[11]);
            if ((Integer)lineObjects[13] != 1 || (Integer)lineObjects[12] == 5) continue;
            row.setUserObject(lineObjects[13]);
        }
    }

    protected String getDecimalFormat(int scale) {
        StringBuffer sbff = new StringBuffer();
        StringBuffer sbffN = new StringBuffer();
        if (scale == 0) {
            sbff.append("#,##0");
            sbffN.append("-#,##0");
        } else {
            sbff.append("#,##0.");
            sbffN.append("-#,##0.");
        }
        for (int i = 0; i < scale; ++i) {
            sbff.append("0");
            sbffN.append("0");
        }
        return sbff.append(";").append(sbffN).toString();
    }
}

