/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.AcctCussentCheckFacadeFactory;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.IAcctCussent;
import com.kingdee.eas.fi.gl.IAcctCussentCheckFacade;
import com.kingdee.eas.fi.gl.client.AbstractAcctCussentHistoryFilterUI;
import com.kingdee.eas.fi.gl.client.AcctCussentFilterPanel;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AcctCussentHistoryFilterUI
extends AbstractAcctCussentHistoryFilterUI {
    private static final long serialVersionUID = 457799497008548575L;
    private CompanyOrgUnitInfo curCompany;
    private PeriodEntity pe;
    private Map params;

    public AcctCussentHistoryFilterUI(CompanyOrgUnitInfo company) throws Exception {
        this.curCompany = company;
        if (this.curCompany == null) {
            this.curCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        String curComId = this.curCompany.getId().toString();
        Object[] param = new Object[2];
        param[0] = curComId;
        IAcctCussent cussentCtrl = AcctCussentFactory.getRemoteInstance();
        Object[] initData = cussentCtrl.fetchInitFilterData(param);
        this.curCompany = (CompanyOrgUnitInfo)initData[0];
        this.pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.curCompany);
        SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)true);
        EntityViewInfo accountView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        accountView.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.curCompany.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.curCompany.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, this.curCompany, filter, false, false);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        this.bizAccountFrom.setSelectorCollection(sic);
        this.bizAccountFrom.setSelector((KDPromptSelector)apb);
        this.bizAccountFrom.setDisplayFormat("$number$ - $name$");
        this.bizAccountFrom.setEntityViewInfo(accountView);
        CurrencyCollection curCol = (CurrencyCollection)initData[2];
        this.comboCurrency.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"ALLCURRENCY"));
        this.comboCurrency.addItems(curCol.toArray());
        this.pkUnverifyDate.setValue(null);
        this.pkBizDate.setValue(null);
        this.tblAsstItem.checkParsed();
        this.tblAsstItem.getSelectManager().setSelectMode(2);
        InitClientHelp.setTableKeyBoardManager(this.tblAsstItem);
        this.tblAsstItem.getColumn("checkbox").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        ObjectValueRender asstRender = new ObjectValueRender();
        asstRender.setFormat(new IDataFormat(){

            public String format(Object object) {
                StringBuffer ret = new StringBuffer();
                if (object.getClass().isArray()) {
                    Object[] os = (Object[])object;
                    for (int i = 0; i < os.length; ++i) {
                        if (i > 0) {
                            ret.append("; ");
                        }
                        ret.append(((IObjectValue)os[i]).toString());
                    }
                    return ret.toString();
                }
                return object.toString();
            }
        });
        this.tblAsstItem.getColumn("from").setRenderer((IBasicRender)asstRender);
        this.bizAccountFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    IAcctCussentCheckFacade facade = AcctCussentCheckFacadeFactory.getRemoteInstance();
                    AccountViewInfo currentAccount = (AccountViewInfo)AcctCussentHistoryFilterUI.this.bizAccountFrom.getValue();
                    AcctCussentHistoryFilterUI.this.tblAsstItem.removeRows();
                    if (currentAccount == null) {
                        return;
                    }
                    ArrayList currentItems = facade.getAsstItemType(currentAccount.getId().toString(), AcctCussentHistoryFilterUI.this.curCompany.getId().toString());
                    for (HashMap item : currentItems) {
                        IRow row = AcctCussentHistoryFilterUI.this.tblAsstItem.addRow();
                        row.getCell("checkbox").setValue((Object)Boolean.TRUE);
                        row.getCell("type").setValue(item.get("name"));
                        row.getCell("prop").setValue(item.get("propname"));
                        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
                        bizPromptBox.setEditable(true);
                        bizPromptBox.setEditFormat("$number$;$name$");
                        bizPromptBox.setDisplayFormat("$number$;$name$");
                        bizPromptBox.setCommitFormat("$number$;$name$");
                        bizPromptBox.setQueryInfo((String)item.get("queryname"));
                        bizPromptBox.setEnabledMultiSelection(true);
                        GeneralAsstActTypeGroupInfo grp = null;
                        if (item.get("glgroup") != null) {
                            grp = new GeneralAsstActTypeGroupInfo();
                            grp.setId(BOSUuid.read((String)item.get("glgroup").toString()));
                        }
                        bizPromptBox.addDataChangeListener(new DataChangeListener(){

                            public void dataChanged(DataChangeEvent eventObj) {
                                Object newValue = eventObj.getNewValue();
                                KDBizPromptBox bizBox = (KDBizPromptBox)eventObj.getSource();
                                bizBox.setData(newValue);
                            }
                        });
                        AsstActTypeInfo atInfo = new AsstActTypeInfo();
                        atInfo.setAsstHGAttribute(item.get("propname").toString());
                        atInfo.setIsForCompany(((Boolean)item.get("isforcompany")).booleanValue());
                        atInfo.setUseLongNumber(((Boolean)item.get("useLongNUmber")).booleanValue());
                        GLF7Parameter f7Param = new GLF7Parameter();
                        f7Param.setOnlyLeaf(true);
                        if (item.get("glgroup") != null) {
                            GeneralAsstActTypeGroupInfo groupInfo = new GeneralAsstActTypeGroupInfo();
                            groupInfo.setId(BOSUuid.read((String)item.get("glgroup").toString()));
                            atInfo.setGlAsstActTypeGrp(groupInfo);
                            f7Param.setGeneralShowLongNumber(((Boolean)item.get("useLongNUmber")).booleanValue());
                        }
                        GLF7handler.assignSelector((CoreUIObject)AcctCussentHistoryFilterUI.this, (KDBizPromptBox)bizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)AcctCussentHistoryFilterUI.this.curCompany, (GLF7Parameter)f7Param);
                        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
                        row.getCell("from").setEditor((ICellEditor)editor);
                        row.setUserObject((Object)item);
                    }
                }
                catch (Exception e) {
                    AcctCussentHistoryFilterUI.this.handUIException(e);
                    SysUtil.abort();
                }
            }
        });
        this.spnYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int year = AcctCussentHistoryFilterUI.this.spnYearTo.getIntegerVlaue();
                if (year == 2006 || year == 2007) {
                    int numberEnd = AcctCussentHistoryFilterUI.this.spnPeriodTo.getIntegerVlaue();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
                    CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                    filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
                    RptClientUtil.periodChanged((IUIObject)AcctCussentHistoryFilterUI.this, company, filter, year, numberEnd, AcctCussentHistoryFilterUI.this.bizAccountFrom, AcctCussentHistoryFilterUI.this.bizAccountFrom);
                }
            }
        });
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        Integer periodFrom = new Integer(this.spnYearFrom.getIntegerVlaue() * 100 + this.spnPeriodFrom.getIntegerVlaue());
        Integer periodTo = new Integer(this.spnYearTo.getIntegerVlaue() * 100 + this.spnPeriodTo.getIntegerVlaue());
        filterItems.add(new FilterItemInfo("cussPeriod", (Object)periodFrom, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("cussPeriod", (Object)periodTo, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("verifyPeriod", (Object)periodFrom, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("verifyPeriod", (Object)periodTo, CompareType.LESS_EQUALS));
        StringBuffer maskString = new StringBuffer();
        int index = 0;
        if (this.chkIncludeInit.isSelected()) {
            filterItems.add(new FilterItemInfo("vchDate", null, CompareType.EQUALS));
            maskString.append("((#").append(index++).append(" and #").append(index++);
            maskString.append(") or (#").append(index++).append(" and #").append(index++);
            maskString.append(") or #").append(index++).append(") ");
        } else {
            filterItems.add(new FilterItemInfo("cussentid.isInit", (Object)Boolean.FALSE, CompareType.EQUALS));
            filterItems.add(new FilterItemInfo("cussentid.isInit", null, CompareType.EMPTY));
            maskString.append("((#").append(index++).append(" and #").append(index++);
            maskString.append(") or (#").append(index++).append(" and #").append(index++);
            maskString.append(")) ");
            maskString.append(" and (#").append(index++).append(" or #").append(index++).append(")");
        }
        if (this.bizAccountFrom.getValue() != null) {
            String accountId = ((AccountViewInfo)this.bizAccountFrom.getValue()).getId().toString();
            filterItems.add(new FilterItemInfo("account.id", (Object)accountId));
            maskString.append(" and #").append(index++);
        }
        if (this.comboCurrency.getSelectedIndex() > 0) {
            filterItems.add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString()));
            maskString.append(" and #" + index++);
        }
        if (this.pkUnverifyDate.getValue() != null) {
            filterItems.add(new FilterItemInfo("verifyDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkUnverifyDate.getValue()))));
            maskString.append(" and #" + index++);
        }
        if (this.pkBizDate.getValue() != null) {
            filterItems.add(new FilterItemInfo("bizDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkBizDate.getValue()))));
            maskString.append(" and #" + index++);
        }
        if (this.txtBizNumber.getText() != null && this.txtBizNumber.getText().trim().length() > 0) {
            filterItems.add(new FilterItemInfo("bizNumber", (Object)(this.txtBizNumber.getText().trim() + "%"), CompareType.LIKE));
            maskString.append(" and #" + index++);
        }
        if (this.tblAsstItem.getRowCount() > 0) {
            int asstCnt = 0;
            for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
                IRow row = this.tblAsstItem.getRow(i);
                if (row.getCell("checkbox").getValue() == null || !((Boolean)row.getCell("checkbox").getValue()).booleanValue() || row.getCell("from").getValue() == null) continue;
                Object obj = row.getCell("from").getValue();
                HashSet<String> asstIds = new HashSet<String>();
                if (obj instanceof Object[]) {
                    Object[] assts;
                    for (Object asst : assts = (Object[])obj) {
                        if (!(asst instanceof IObjectValue)) continue;
                        asstIds.add(((IObjectValue)asst).get("id").toString());
                    }
                } else if (obj instanceof IObjectValue) {
                    asstIds.add(((IObjectValue)obj).get("id").toString());
                }
                String propname = row.getCell("prop").getValue().toString();
                filterItems.add(new FilterItemInfo("assgrp." + propname + ".id", asstIds, CompareType.INCLUDE));
                ++asstCnt;
            }
            if (asstCnt > 0) {
                maskString.append(" and (");
                for (int k = 0; k < asstCnt - 1; ++k) {
                    maskString.append("#" + index++ + " and ");
                }
                maskString.append("#" + index++ + ")");
            }
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            SysUtil.abort();
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public Object getParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("FromYear", String.valueOf(this.spnYearFrom.getIntegerVlaue()));
        params.put("FromMonth", String.valueOf(this.spnPeriodFrom.getIntegerVlaue()));
        params.put("ToYear", String.valueOf(this.spnYearTo.getIntegerVlaue()));
        params.put("ToMonth", String.valueOf(this.spnPeriodTo.getIntegerVlaue()));
        if (this.chkIncludeInit.isSelected()) {
            params.put("IncludeInit", Boolean.TRUE.toString());
        } else {
            params.put("IncludeInit", Boolean.FALSE.toString());
        }
        if (this.bizAccountFrom.getValue() != null) {
            String accountId = ((AccountViewInfo)this.bizAccountFrom.getValue()).getId().toString();
            params.put("Account", accountId);
        }
        if (this.comboCurrency.getSelectedIndex() > 0) {
            params.put("Currency", ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        }
        if (this.pkUnverifyDate.getValue() != null) {
            params.put("VerifyDate", DateTimeUtils.truncateDate((Date)((Date)this.pkUnverifyDate.getValue())));
        }
        if (this.pkBizDate.getValue() != null) {
            params.put("BizDate", DateTimeUtils.truncateDate((Date)((Date)this.pkBizDate.getValue())));
        }
        if (this.txtBizNumber.getText() != null && this.txtBizNumber.getText().trim().length() > 0) {
            params.put("BizNumber", this.txtBizNumber.getText().trim());
        }
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            IRow row = this.tblAsstItem.getRow(i);
            if (row.getCell("checkbox").getValue() == null || !((Boolean)row.getCell("checkbox").getValue()).booleanValue() || row.getCell("from").getValue() == null) continue;
            Object asst = row.getCell("from").getValue();
            String propname = row.getCell("prop").getValue().toString();
            params.put(propname, asst);
        }
        return params;
    }

    public void setParam(Object param) throws BOSException, EASBizException {
        if (param == null) {
            return;
        }
        Map params = (Map)param;
        if (params.get("FromYear") == null) {
            SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false);
        } else {
            int maxYearPeriod;
            int fromNumber = Integer.valueOf(params.get("FromYear").toString()) * 100 + Integer.valueOf(params.get("FromMonth").toString());
            int toNumber = Integer.valueOf(params.get("ToYear").toString()) * 100 + Integer.valueOf(params.get("ToMonth").toString());
            PeriodEntity queryPeriod = this.pe.getQueryPeriod();
            int minYear = queryPeriod.getMinYear();
            int minYearPeriod = queryPeriod.getMinPeriod(minYear);
            int maxYear = queryPeriod.getMaxYear();
            if (fromNumber > maxYear * 100 + (maxYearPeriod = queryPeriod.getMaxPeriod(maxYear))) {
                params.put("FromYear", String.valueOf(maxYear));
                params.put("FromMonth", String.valueOf(maxYearPeriod));
            } else if (fromNumber < minYear * 100 + minYearPeriod) {
                params.put("FromYear", String.valueOf(minYear));
                params.put("FromMonth", String.valueOf(minYearPeriod));
            }
            if (toNumber > maxYear * 100 + maxYearPeriod) {
                params.put("ToYear", String.valueOf(maxYear));
                params.put("ToMonth", String.valueOf(maxYearPeriod));
            } else if (toNumber < minYear * 100 + minYearPeriod) {
                params.put("ToYear", String.valueOf(minYear));
                params.put("ToMonth", String.valueOf(minYearPeriod));
            }
            this.spnYearFrom.setValue((Object)Integer.valueOf(params.get("FromYear").toString()));
            this.spnPeriodFrom.setValue((Object)Integer.valueOf(params.get("FromMonth").toString()));
            this.spnYearTo.setValue((Object)Integer.valueOf(params.get("ToYear").toString()));
            this.spnPeriodTo.setValue((Object)Integer.valueOf(params.get("ToMonth").toString()));
        }
        if ("true".equals(params.get("IncludeInit"))) {
            this.chkIncludeInit.setSelected(true);
        } else {
            this.chkIncludeInit.setSelected(false);
        }
        if (params.get("Account") != null) {
            IAccountView iAccount = AccountViewFactory.getRemoteInstance();
            this.bizAccountFrom.setValue((Object)iAccount.getAccountViewInfo((IObjectPK)new ObjectUuidPK(params.get("Account").toString())));
        }
        if (params.get("Currency") != null) {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(params.get("Currency").toString()));
            if (currency != null) {
                this.comboCurrency.setSelectedItem((Object)currency);
            } else {
                this.comboCurrency.setSelectedIndex(0);
            }
        } else {
            this.comboCurrency.setSelectedIndex(0);
        }
        this.pkUnverifyDate.setValue(params.get("VerifyDate"));
        this.pkBizDate.setValue(params.get("BizDate"));
        if (params.get("BizNumber") != null) {
            this.txtBizNumber.setText(params.get("BizNumber").toString());
        } else {
            this.txtBizNumber.setText(null);
        }
        for (int j = 0; j < this.tblAsstItem.getRowCount(); ++j) {
            IRow row = this.tblAsstItem.getRow(j);
            String propName = row.getCell("prop").getValue().toString();
            if (params.get(propName) == null) continue;
            row.getCell("checkbox").setValue((Object)Boolean.TRUE);
            row.getCell("from").setValue(params.get(propName));
        }
    }

    public void clear() {
        this.bizAccountFrom.setValue(null);
        this.comboCurrency.setSelectedIndex(0);
        this.pkBizDate.setValue(null);
        this.pkUnverifyDate.setValue(null);
        this.txtBizNumber.setText(null);
        this.chkIncludeInit.setSelected(false);
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        int yearEnd = (Integer)this.spnYearTo.getValue();
        return !RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.spnYearFrom.getValue()).intValue(), numberBegin = ((Integer)this.spnPeriodFrom.getValue()).intValue());
    }

    public void initUIByParam() {
        if (this.params.get("KEY_PERIOD_YEAR_FROM") != null) {
            this.spnYearFrom.setValue(this.params.get("KEY_PERIOD_YEAR_FROM"));
        }
        if (this.params.get("KEY_PERIOD_YEAR_TO") != null) {
            this.spnYearTo.setValue(this.params.get("KEY_PERIOD_YEAR_TO"));
        }
        if (this.params.get("KEY_PERIOD_FROM") != null) {
            this.spnPeriodFrom.setValue(this.params.get("KEY_PERIOD_FROM"));
        }
        if (this.params.get("KEY_PERIOD_TO") != null) {
            this.spnPeriodTo.setValue(this.params.get("KEY_PERIOD_TO"));
        }
        if (this.params.get("KEY_INCLUDE_INIT") != null) {
            this.chkIncludeInit.setSelected(((Boolean)this.params.get("KEY_INCLUDE_INIT")).booleanValue());
        }
    }

    public void setQueryParams(Map queryParams) {
        this.params = queryParams;
    }

    public CurrencyInfo getCurCurrency() {
        if (!this.comboCurrency.getSelectedItem().toString().equals(AcctCussentFilterPanel.ALL_CURRENCY.toString())) {
            return (CurrencyInfo)this.comboCurrency.getSelectedItem();
        }
        return null;
    }
}

