/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.client.ClientQueryFieldPermission;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.ICommonQureyPanelExtendForBos;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussent;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.IVoucherAssistRecord;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.client.AbstractAcctCussentVerifyUI;
import com.kingdee.eas.fi.gl.client.AcctCussentFilterPanel;
import com.kingdee.eas.fi.gl.client.AcctCussentQueryHelper;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;

public class AcctCussentVerifyUI
extends AbstractAcctCussentVerifyUI {
    private static final long serialVersionUID = -8552589921655506931L;
    private CommonQueryPanel queryPanel;
    private boolean isQty;
    protected AcctCussentQueryHelper helper;
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.AcctCussentResource";
    public static final int RV_CONFIRM = 0;
    public static final int RV_CANCEL = 1;
    protected int returnValue = 1;
    protected int quantityPrecision;
    protected VoucherAssistRecordCollection result;
    public static final String UICONTEXT_ACCOUNT = "ACCOUNT";
    public static final String UICONTEXT_MU = "MU";
    public static final String UICONTEXT_CURRENCY = "CURRENCY";
    public static final String UICONTEXT_QUANPRE = "QUANPRE";
    static final String COLKEY_ID = "id";
    static final String COLKEY_CURPRE = "currency.precision";
    static final String COLKEY_VCHASSISTRECORD_ID = "vchAssistRecord.id";
    static final String COLKEY_DESCRIPTION = "description";
    static final String COLKEY_ENDDATE = "endDate";
    static final String COLKEY_UNHOLDEDQTY = "unHoldedQty";
    static final String COLKEY_UNHOLDEDSTDQTY = "unHoldedStdQty";
    static final String COLKEY_UNHOLDEDAMTFOR = "unHoldedAmtFor";
    static final String COLKEY_UNHOLDEDAMTLOCAL = "unHoldedAmtLocal";
    static final String COLKEY_UNHOLDEDAMTRPT = "unHoldedAmtRpt";
    static final String COLKEY_UNVERIFIEDAMTFOR = "unVerifiedAmtFor";
    static final String COLKEY_UNVERIFIDEDAMTLOCAL = "unVerifiedAmtLocal";
    static final String COLKEY_UNVERIFIEDAMTRPT = "unVerifiedAmtRpt";
    protected TableMouseListener tableMouseLs = new TableMouseListener();
    public static final String IS_ACCESSFROM_VOUCHERUI = "IS_ACCESSFROM_VOUCHERUI";
    protected boolean isAfterVerify = false;
    private CompanyOrgUnitInfo curCompany;

    protected JButton getDefaultButton() {
        return this.btnConfirm;
    }

    protected BigDecimal parseDec(Object obj) {
        if (obj == null) {
            return GlUtils.zero;
        }
        String str = obj.toString().trim();
        if (str.length() == 0) {
            return GlUtils.zero;
        }
        str = str.replaceAll(",", "");
        return new BigDecimal(str);
    }

    public void onLoad() throws Exception {
        this.curCompany = this.getCurrentPanelCompany();
        if (this.curCompany == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"NOCompany"));
            SysUtil.abort();
        }
        Map uiContext = this.getUIContext();
        this.quantityPrecision = (Integer)uiContext.get(UICONTEXT_QUANPRE);
        this.isAfterVerify = (Boolean)uiContext.get("isCancelAfterCussent");
        this.initTableColumn();
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getRemoteInstance();
        HashMap<String, String> findAllAsstDataParam = new HashMap<String, String>();
        findAllAsstDataParam.put("companyId", this.curCompany.getId().toString());
        Map asstMap = facade.dealTask("findAllAsstData", findAllAsstDataParam);
        uiContext.put(IS_ACCESSFROM_VOUCHERUI, Boolean.TRUE);
        IAcctCussent cussentCtrl = AcctCussentFactory.getRemoteInstance();
        Object[] param = new Object[]{this.curCompany.getId().toString(), this.curCompany.getCU().getId().toString()};
        Object[] initData = cussentCtrl.fetchInitFilterData(param);
        AcctCussentFilterPanel myPanel = new AcctCussentFilterPanel(0, initData);
        myPanel.initVerifyFilter(uiContext);
        myPanel.setPanelName(EASResource.getString((String)RESOURCE_PATH, (String)"myPanelName"));
        this.helper = new AcctCussentQueryHelper(this, this.tblResult, myPanel, this.queryAcctCussentQueryPK, 1, uiContext);
        this.helper.setAsstMap(asstMap);
        this.helper.setIsInTimeVerify(!this.isAfterVerify);
        MetaDataPK mainQueryPK2 = new MetaDataPK("com.kingdee.eas.fi.gl.app", "AcctCussentQueryForFilter");
        this.queryPanel = new CommonQueryPanel(null, null, (IMetaDataPK)mainQueryPK2, this.getMetaDataPK().getFullName(), true, true, false, false, (IProcessor)this.helper, null, 560, 340);
        this.queryPanel.disVisiableRowCount();
        this.queryPanel.addPanel((KDPanel)myPanel);
        this.queryPanel.getCommonFilterPanel().setExtend(new ICommonQureyPanelExtendForBos(){

            public DataObject[] getDataObjects(QueryInfo queryInfo, QueryPanelTypeEnum panelType) {
                DataObject[] dataObjects = null;
                try {
                    AsstActTypeCollection typeColl = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection();
                    HashMap<String, String> asstActTypeMap = new HashMap<String, String>();
                    for (int i = 0; i < typeColl.size(); ++i) {
                        asstActTypeMap.put(typeColl.get(i).getAsstHGAttribute(), typeColl.get(i).getName());
                    }
                    SimplePropertyUnitCollection conditions = Util.getConditionList((MetaDataPK)new MetaDataPK(queryInfo.getRealFullName()), (QueryPanelTypeEnum)panelType, (String[])new String[]{"displayName", "returnType"}, (String[])new String[]{"revserseLinkProName", "displayFormat", "editFormat", "commitFormat"});
                    int size = conditions.size();
                    ArrayList<DataObject> dataList = new ArrayList<DataObject>();
                    for (int i = 0; i < size; ++i) {
                        String fieldName;
                        DataObject dataObject = new DataObject();
                        SimplePropertyUnit fieldInfo = conditions.get(i);
                        dataObject.setName(Util.getQueryFieldAlias((SimplePropertyUnit)fieldInfo));
                        boolean isRevserseLink = false;
                        String str = (String)fieldInfo.getExtendedProperties().get("isRevserseLink");
                        if (!StringUtils.isEmpty((String)str)) {
                            isRevserseLink = Boolean.valueOf(str);
                            if (!isRevserseLink) {
                                dataObject.setValue(fieldInfo.getName());
                            } else {
                                String strProp = (String)fieldInfo.getExtendedProperties().get("revserseLinkProName");
                                dataObject.setValue(strProp);
                            }
                        } else {
                            dataObject.setValue(fieldInfo.getName());
                        }
                        if (fieldInfo.getName() != null && (fieldName = fieldInfo.getName()).startsWith("vchAssistRecord.assGrp")) {
                            String[] fieldNameArry = fieldName.split("\\.");
                            if (fieldNameArry.length > 2 && !asstActTypeMap.containsKey(fieldNameArry[2])) continue;
                            if (fieldName.indexOf("generalAssActType") > 0) {
                                dataObject.setName((String)asstActTypeMap.get(fieldNameArry[2]));
                            }
                        }
                        dataList.add(dataObject);
                    }
                    dataObjects = new DataObject[dataList.size()];
                    if ((dataObjects = dataList.toArray(dataObjects)) != null && dataObjects.length > 0) {
                        DataObject[] conditionArr = ClientQueryFieldPermission.getCanViewField((MetaDataPK)new MetaDataPK(queryInfo.getRealFullName()), (DataObject[])dataObjects, (OrgUnitCollection)AcctCussentVerifyUI.this.queryPanel.getCommonFilterPanel().getMainBusinessOrg());
                        return conditionArr;
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        this.queryPanel.getCommonFilterPanel().reInitCondition();
        GlUtils.AccountPeriodInfo period = (GlUtils.AccountPeriodInfo)initData[1];
        myPanel.spnPeriodFrom.setValue((Object)period.startPeriod.getPeriodNumber());
        myPanel.spnYearFrom.setValue((Object)period.startPeriod.getPeriodYear());
        myPanel.spnPeriodTo.setValue((Object)period.curPeriod.getPeriodNumber());
        myPanel.spnYearTo.setValue((Object)period.curPeriod.getPeriodYear());
        this.helper.addKDLisener(this.queryPanel.getCommonFilterPanel());
        this.pnlFilterUI.setLayout((LayoutManager)new BorderLayout());
        this.pnlFilterUI.add((Component)this.queryPanel, (Object)"Center");
        if (myPanel.isForeignCurrencySU()) {
            this.tblResult.getColumn(COLKEY_UNHOLDEDAMTFOR).getStyleAttributes().setHided(true);
            this.tblResult.getColumn(COLKEY_UNHOLDEDAMTRPT).getStyleAttributes().setHided(true);
        } else if (!myPanel.isUseReportingCurrency()) {
            this.tblResult.getColumn(COLKEY_UNHOLDEDAMTRPT).getStyleAttributes().setHided(true);
            this.tblResult.getColumn(COLKEY_UNVERIFIEDAMTRPT).getStyleAttributes().setHided(true);
        }
        super.onLoad();
        this.loadFields();
        double width = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        Dimension size = new Dimension(width > 800.0 ? 900 : 625, width > 800.0 ? 600 : 525);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.kDContainer1.setSize(new Dimension(width > 800.0 ? 880 : 605, width > 800.0 ? 260 : 190));
    }

    private void initTableColumn() {
        this.tblResult.checkParsed();
        this.tblResult.getStyleAttributes().setLocked(true);
        this.tblResult.getDataRequestManager().setDataRequestMode(1);
        this.tblResult.getSelectManager().setSelectMode(10);
        if (this.isAfterVerify) {
            this.tblResult.getColumn(COLKEY_UNVERIFIEDAMTFOR).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblResult.getColumn(COLKEY_UNVERIFIDEDAMTLOCAL).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblResult.getColumn(COLKEY_UNVERIFIEDAMTRPT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblResult.getColumn(COLKEY_UNHOLDEDAMTFOR).getStyleAttributes().setHided(true);
            this.tblResult.getColumn(COLKEY_UNHOLDEDAMTLOCAL).getStyleAttributes().setHided(true);
            this.tblResult.getColumn(COLKEY_UNHOLDEDAMTRPT).getStyleAttributes().setHided(true);
        } else {
            this.tblResult.getColumn(COLKEY_UNHOLDEDAMTFOR).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblResult.getColumn(COLKEY_UNHOLDEDAMTLOCAL).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblResult.getColumn(COLKEY_UNHOLDEDAMTRPT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblResult.getColumn(COLKEY_UNVERIFIEDAMTFOR).getStyleAttributes().setHided(true);
            this.tblResult.getColumn(COLKEY_UNVERIFIDEDAMTLOCAL).getStyleAttributes().setHided(true);
            this.tblResult.getColumn(COLKEY_UNVERIFIEDAMTRPT).getStyleAttributes().setHided(true);
        }
        this.tblResult.getColumn(COLKEY_UNHOLDEDAMTLOCAL).getStyleAttributes().setHided(true);
        this.tblResult.getColumn(COLKEY_UNHOLDEDAMTRPT).getStyleAttributes().setHided(true);
    }

    public void attachListeners() {
        this.tblResult.addKDTMouseListener((KDTMouseListener)this.tableMouseLs);
    }

    public void detachListeners() {
        this.tblResult.removeKDTMouseListener((KDTMouseListener)this.tableMouseLs);
    }

    @Override
    public void loadFields() {
        this.detachListeners();
        super.loadFields();
        this.attachListeners();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.queryPanel.verify()) {
            if (this.isAfterVerify) {
                CurrencyInfo cur = (CurrencyInfo)this.helper.getUserPanel().cbxCurrency.getSelectedItem();
                int pre = 4;
                if (cur != null) {
                    pre = cur.getPrecision();
                }
                this.tblResult.getColumn(COLKEY_UNVERIFIEDAMTFOR).getStyleAttributes().setNumberFormat(KDTableUtil.getNumberFormat((int)pre, (boolean)true));
            }
            this.helper.getUserPanel().syschronizeParam();
            this.isQty = this.helper.getIsQty();
            EntityViewInfo view = this.queryPanel.getEntityViewInnerInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("account.accountTableID.id", (Object)this.curCompany.getAccountTable().getId().toString()));
            view.getFilter().mergeFilter(filter, "AND");
            this.helper.refreshHelper(view);
        }
    }

    protected boolean checkDataObject() {
        return this.tblResult.getSelectManager().size() != 0;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkDataObject()) {
            this.setResult(this.buildResult());
            this.setReturnValue(0);
            this.destroyWindow();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setResult(null);
        this.setReturnValue(1);
        this.destroyWindow();
    }

    @Override
    protected void tblResult_doRequestRowSet(RequestRowSetEvent e) {
        CurrencyInfo cur = (CurrencyInfo)this.helper.getUserPanel().cbxCurrency.getSelectedItem();
        int pre = 4;
        int basePre = (Integer)((CurrencyInfo)this.helper.curCompany.get("basecurrency")).get("precision");
        int reportPre = (Integer)((CurrencyInfo)this.helper.curCompany.get("reportcurrency")).get("precision");
        if (cur != null) {
            pre = cur.getPrecision();
        }
        try {
            IRowSet rs = this.helper.fetchListData(e);
            if (rs != null) {
                IRowSetMetaData md = rs.getRowSetMetaData();
                int indexOfQty = -1;
                if (this.isQty) {
                    indexOfQty = md.getColumnIndex(COLKEY_UNHOLDEDQTY);
                }
                int indexOfAmnt = md.getColumnIndex(COLKEY_UNHOLDEDAMTFOR);
                int indexOfLa = md.getColumnIndex(COLKEY_UNHOLDEDAMTLOCAL);
                int indexOfRa = md.getColumnIndex(COLKEY_UNHOLDEDAMTRPT);
                rs.beforeFirst();
                while (rs.next()) {
                    if (this.isQty) {
                        rs.updateObject(indexOfQty, (Object)GlUtils.formatNumber(rs.getBigDecimal(indexOfQty), this.quantityPrecision));
                    }
                    rs.updateObject(indexOfAmnt, (Object)GlUtils.formatNumber(rs.getBigDecimal(indexOfAmnt), pre));
                    rs.updateObject(indexOfLa, (Object)GlUtils.formatNumber(rs.getBigDecimal(indexOfLa), basePre));
                    rs.updateObject(indexOfRa, (Object)GlUtils.formatNumber(rs.getBigDecimal(indexOfRa), reportPre));
                    this.helper.dealWithAInCP(rs);
                }
                if (this.isQty) {
                    md.setColumnType(indexOfQty, 12);
                }
                md.setColumnType(indexOfAmnt, 12);
                md.setColumnType(indexOfLa, 12);
                md.setColumnType(indexOfRa, 12);
                rs.beforeFirst();
                e.setRowSet(rs);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public VoucherAssistRecordCollection buildResult() throws Exception {
        IRow row;
        KDTSelectManager sm = this.tblResult.getSelectManager();
        int blockCount = sm.size();
        HashMap<String, IRow> hmIdToRow = new HashMap<String, IRow>();
        EntityViewInfo view = new EntityViewInfo();
        IVoucherAssistRecord recCtrl = VoucherAssistRecordFactory.getRemoteInstance();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("assGrp.asstAccount"));
        int colCount = this.tblResult.getColumnCount();
        ArrayList hgProps = this.getUIContext().get("hgAttrProps") == null ? new ArrayList() : (List)this.getUIContext().get("hgAttrProps");
        for (int i = 0; i < colCount; ++i) {
            IColumn col = this.tblResult.getColumn(i);
            Object userObject = col.getUserObject();
            if (!(userObject instanceof AcctCussentInfo.AcctCussentListColumnInfo)) continue;
            AcctCussentInfo.AcctCussentListColumnInfo colInfo = (AcctCussentInfo.AcctCussentListColumnInfo)userObject;
            if (colInfo.getColType() == 0) {
                sic.add(new SelectorItemInfo("assGrp." + colInfo.getPropName() + ".number"));
                sic.add(new SelectorItemInfo("assGrp." + colInfo.getPropName() + ".name"));
                hgProps.remove(colInfo.getPropName());
                continue;
            }
            if (colInfo.getColType() != 1) continue;
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)colInfo.getDataType())) {
                sic.add(new SelectorItemInfo(colInfo.getPropName() + ".number"));
                sic.add(new SelectorItemInfo(colInfo.getPropName() + ".name"));
                continue;
            }
            sic.add(new SelectorItemInfo(colInfo.getPropName()));
        }
        for (String hgProp : hgProps) {
            sic.add(new SelectorItemInfo("assGrp." + hgProp + ".number"));
            sic.add(new SelectorItemInfo("assGrp." + hgProp + ".name"));
        }
        VoucherAssistRecordCollection recCol = new VoucherAssistRecordCollection();
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int j = top; j <= bottom; ++j) {
                FilterInfo filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                row = this.tblResult.getRow(j);
                String recId = row.getCell(COLKEY_VCHASSISTRECORD_ID).getValue().toString();
                hmIdToRow.put(recId, row);
                fic.add(new FilterItemInfo(COLKEY_ID, (Object)recId));
                view.setFilter(filter);
                VoucherAssistRecordCollection recCol2 = recCtrl.getVoucherAssistRecordCollection(view);
                recCol.addObjectCollection((IObjectCollection)recCol2);
            }
        }
        AcctCussentFilterPanel myPanel = this.helper.getUserPanel();
        boolean foreignCurrencySU = myPanel.isForeignCurrencySU();
        boolean useReportingCurrency = myPanel.isUseReportingCurrency();
        Iterator itrRec = recCol.iterator();
        String descPrefix = EASResource.getString((String)RESOURCE_PATH, (String)"verify");
        while (itrRec.hasNext()) {
            VoucherAssistRecordInfo rec = (VoucherAssistRecordInfo)itrRec.next();
            String recId = rec.getId().toString();
            row = (IRow)hmIdToRow.get(recId);
            String desc = (String)row.getCell(COLKEY_DESCRIPTION).getValue();
            if (desc != null && desc.trim().length() > 0) {
                desc = descPrefix + desc;
            }
            rec.setDescription(desc);
            rec.setEndDate((Date)row.getCell(COLKEY_ENDDATE).getValue());
            if (rec.getEndDate() == null) {
                rec.setEndDate(rec.getBizDate());
            }
            if (this.isQty) {
                if (this.isAfterVerify) {
                    rec.setQuantity(this.parseDec(row.getCell(COLKEY_UNHOLDEDQTY).getValue()));
                    rec.setStandardQuantity(this.parseDec(row.getCell(COLKEY_UNHOLDEDSTDQTY).getValue()));
                } else {
                    rec.setQuantity(this.parseDec(row.getCell(COLKEY_UNHOLDEDQTY).getValue()));
                    rec.setStandardQuantity(this.parseDec(row.getCell(COLKEY_UNHOLDEDSTDQTY).getValue()));
                }
            }
            if (foreignCurrencySU) {
                BigDecimal amt = null;
                amt = this.isAfterVerify ? this.parseDec(row.getCell(COLKEY_UNVERIFIEDAMTFOR).getValue()) : this.parseDec(row.getCell(COLKEY_UNHOLDEDAMTFOR).getValue());
                rec.setOriginalAmount(amt);
                rec.setLocalAmount(amt);
                rec.setReportingAmount(amt);
            } else if (this.isAfterVerify) {
                rec.setOriginalAmount(this.parseDec(row.getCell(COLKEY_UNVERIFIEDAMTFOR).getValue()));
                rec.setLocalAmount(this.parseDec(row.getCell(COLKEY_UNVERIFIDEDAMTLOCAL).getValue()));
                if (useReportingCurrency) {
                    rec.setReportingAmount(this.parseDec(row.getCell(COLKEY_UNVERIFIEDAMTRPT).getValue()));
                } else {
                    rec.setReportingAmount(GlUtils.zero);
                }
            } else {
                rec.setOriginalAmount(this.parseDec(row.getCell(COLKEY_UNHOLDEDAMTFOR).getValue()));
                rec.setLocalAmount(this.parseDec(row.getCell(COLKEY_UNHOLDEDAMTLOCAL).getValue()));
                if (useReportingCurrency) {
                    rec.setReportingAmount(this.parseDec(row.getCell(COLKEY_UNHOLDEDAMTRPT).getValue()));
                } else {
                    rec.setReportingAmount(GlUtils.zero);
                }
            }
            if (!this.isAfterVerify) {
                AcctCussentInfo cussent = new AcctCussentInfo();
                cussent.put(COLKEY_ID, (Object)row.getCell(COLKEY_ID).getValue().toString());
                rec.setVerifiedCussent(cussent);
            }
            rec.setId(null);
            rec.setOprStatus(1);
        }
        return recCol;
    }

    public void setReturnValue(int rv) {
        this.returnValue = rv;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void setResult(VoucherAssistRecordCollection records) {
        this.result = records;
    }

    public VoucherAssistRecordCollection getResult() {
        return this.result;
    }

    private CompanyOrgUnitInfo getCurrentPanelCompany() {
        CompanyOrgUnitInfo company = null;
        company = this.getUIContext().get("COMPANY") != null ? (CompanyOrgUnitInfo)this.getUIContext().get("COMPANY") : SysContext.getSysContext().getCurrentFIUnit();
        return company;
    }

    class TableMouseListener
    implements KDTMouseListener {
        TableMouseListener() {
        }

        public void tableClicked(KDTMouseEvent evt) {
            if (evt.getClickCount() < 2) {
                return;
            }
            try {
                AcctCussentVerifyUI.this.actionConfirm_actionPerformed(null);
            }
            catch (Exception ex) {
                AcctCussentVerifyUI.this.handUIException(ex);
            }
        }
    }
}

