/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AbstractAdjustExchangeRateFilterUI;
import com.kingdee.eas.fi.gl.client.AdjustExchangeRateFilterParam;
import com.kingdee.eas.fi.gl.client.CompanyTreePromptBox;
import com.kingdee.eas.framework.client.context.f7.DefaultF7ContextManager;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdjustExchangeRateFilterUI
extends AbstractAdjustExchangeRateFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustExchangeRateFilterUI.class);
    private DefaultF7ContextManager F7ContextManager = null;
    private String uiParam = null;
    private AdjustExchangeRateFilterParam param;

    public AdjustExchangeRateFilterUI(String uiparam) throws Exception {
        this.uiParam = uiparam;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7();
    }

    private void initCompanyF7() {
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        AcountSchemeInfo scheme = null;
        if (SysContext.getSysContext().getCurrentFIUnit().isIsAssistantOrg()) {
            scheme = new AcountSchemeInfo();
            scheme.setIsMaster(false);
        } else {
            scheme = new AcountSchemeInfo();
            scheme.setIsMaster(true);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(companyView);
        this.prmtCompany.setCommitFormat("$number$;$name$");
        this.prmtCompany.setSelector(this.getCompanySelector());
    }

    protected KDPromptSelector getCompanySelector() {
        if (!GlUtils.isEmpty(this.uiParam) && "FSSC".equalsIgnoreCase(this.uiParam)) {
            return new CompanyTreePromptBox((CoreUIObject)this, null, this.prmtCompany, this.getPermissionItem(), true, this.getCompanyFilterSql());
        }
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(false);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        return companySelector;
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        fic.add(new FilterItemInfo("unit.partFI.adjustExchangeTable.id", null, CompareType.NOTEMPTY));
        StringBuffer periodFilterSql = new StringBuffer();
        periodFilterSql.append("select 1 from T_BD_SystemStatusCtrol  AS sysctrl ");
        periodFilterSql.append(" INNER JOIN T_BD_SystemStatus AS  sysstatus ON  sysctrl.FSystemStatusID = sysstatus.FID");
        periodFilterSql.append(" where sysstatus.FName = 6 ");
        periodFilterSql.append(" and sysctrl.FCompanyID = \"UNIT\".fid ");
        periodFilterSql.append(" and sysctrl.FISSTART=1 and sysctrl.fstartperiodid is not null ");
        fic.add(new FilterItemInfo("unit.id", (Object)periodFilterSql.toString(), CompareType.EXISTS));
        Locale l = SysContext.getSysContext().getLocale();
        StringBuffer paramSql = new StringBuffer();
        paramSql.append("select 1 from T_BAS_ParamItem pi \n");
        paramSql.append("join T_BAS_Param p on p.FID = pi.FKeyID \n");
        paramSql.append("where p.FNumber = 'GL_008' and pi.fvalue_" + l + " = 'false' \n");
        paramSql.append("and pi.forgunitid = \"UNIT\".fid \n");
        fic.add(new FilterItemInfo("unit.id", (Object)paramSql.toString(), CompareType.EXISTS));
        return filter;
    }

    private String getCompanyIdFilter() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getCompanyIDSQL(this.getPermissionItem(), null, true);
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private String getPermissionItem() {
        return "gl_adjExchRate";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("FICompany.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        String name = this.txtName.getText();
        if (name != null && name.length() > 0) {
            fic.add(new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE));
            fic.add(new FilterItemInfo("number", (Object)("%" + name + "%"), CompareType.LIKE));
            filter.setMaskString("#0 AND (#1 OR #2)");
        }
        return filter;
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.prmtCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])this.prmtCompany.getValue();
        }
        if (this.prmtCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.prmtCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    protected void setCompanys(CompanyOrgUnitInfo[] companys) {
        this.prmtCompany.setValue((Object)companys);
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    private CompanyOrgUnitInfo getFirstCompany() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getFirstCompany(this.getPermissionItem(), " and " + this.getCompanyFilterSql());
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private String getCompanyFilterSql() {
        Locale l = SysContext.getSysContext().getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append(" cp.FAdjustExgTableID is not null ");
        sql.append(" and exists ( \n");
        sql.append("select 1 from T_BD_SystemStatusCtrol  AS sysctrl ");
        sql.append(" INNER JOIN T_BD_SystemStatus AS  sysstatus ON  sysctrl.FSystemStatusID = sysstatus.FID");
        sql.append(" where sysstatus.FName = 6 ");
        sql.append(" and sysctrl.FCompanyID = cp.fid ");
        sql.append(" and sysctrl.FISSTART=1 and sysctrl.fstartperiodid is not null ");
        sql.append(" ) \n");
        sql.append(" and exists ( \n");
        sql.append("select 1 from T_BAS_ParamItem pi \n");
        sql.append("join T_BAS_Param p on p.FID = pi.FKeyID \n");
        sql.append("where p.FNumber = 'GL_008' and pi.fvalue_" + l + " = 'false' \n");
        sql.append("and pi.forgunitid = cp.fid \n");
        sql.append(" ) \n");
        return sql.toString();
    }

    public void clear() {
        super.clear();
        this.txtName.setText(null);
        CompanyOrgUnitInfo firstCompany = this.getFirstCompany();
        if (firstCompany != null) {
            this.prmtCompany.setValue((Object)new CompanyOrgUnitInfo[]{firstCompany});
        } else {
            this.prmtCompany.setValue(null);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)this.getParam());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        catch (EASBizException e) {
            this.getCommonQueryPanel().getSolutionListPanel().getCommonLeftPanel().setDeleteButtonEnable(true);
            this.handUIException(e);
        }
    }

    public FilterInfo getFilterParamFromCP(CustomerParams cp) throws EASBizException {
        AdjustExchangeRateFilterParam param = (AdjustExchangeRateFilterParam)RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
        this.setParam(param);
        return this.getFilterInfo();
    }

    public void setParam(Object p) {
        this.param = (AdjustExchangeRateFilterParam)p;
        String[] companyStrs = this.param.getCompanys();
        if (companyStrs != null && companyStrs.length > 0) {
            HashSet<String> companySet = new HashSet<String>();
            for (int i = 0; i < companyStrs.length; ++i) {
                companySet.add(companyStrs[i]);
            }
            EntityViewInfo ev = new EntityViewInfo();
            ev.setSelector(GlUtils.getCompanySic());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
            ev.setFilter(filter);
            ev.getSorter().add(new SorterItemInfo("number"));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
                CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[coll.size()];
                for (int i = 0; i < coll.size(); ++i) {
                    companys[i] = coll.get(i);
                }
                this.prmtCompany.setValue((Object)companys);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.txtName.setText(this.param.getName());
    }

    public Object getParam() {
        CompanyOrgUnitInfo[] companys;
        if (this.param == null) {
            this.param = new AdjustExchangeRateFilterParam();
        }
        if ((companys = this.getCompanys()) != null && companys.length > 0) {
            String[] companyStrs = new String[companys.length];
            for (int i = 0; i < companys.length; ++i) {
                companyStrs[i] = companys[i].getId().toString();
            }
            this.param.setCompanys(companyStrs);
        }
        this.param.setName(this.txtName.getText());
        return this.param;
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        return super.verify();
    }
}

