/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IExceptionHandler;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistantAccountFactory;
import com.kingdee.eas.fi.gl.GLResource;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.client.AbstractAssistantAccountConditionUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;

public class AssistantAccountConditionUI
extends AbstractAssistantAccountConditionUI {
    private boolean loading = false;
    private boolean hasLoadInitData = false;
    private FilterInfo filter = null;
    private ArrayList tableData;

    public AssistantAccountConditionUI() throws Exception {
        this.chkOpDisplayNoTrans.setSelected(false);
        this.tblAssistantAccount.checkParsed();
        KDTMenuManager tm = new KDTMenuManager(this.tblAssistantAccount);
        String path = System.getProperty("user.dir");
        path = path + "/eastmp.xls";
        tm.setTempFile(path);
        tm.setExceptionHandler(new IExceptionHandler(){

            public void handle(Exception e) {
                AssistantAccountConditionUI.this.handUIException(e);
            }
        });
        this.tblAssistantAccount.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.onMyLoad();
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)((Object)e));
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void cmbAssistantAccount_dataChanged(DataChangeEvent e) throws Exception {
        this.cmbCodeFrom.setValue(null);
        this.cmbCodeTo.setValue(null);
        Object data = e.getNewValue();
        boolean canSelect = data != null;
        this.cmbCodeFrom.setEnabled(canSelect);
        this.cmbCodeTo.setEnabled(canSelect);
        if (!canSelect) {
            return;
        }
        AsstAccountInfo aai = (AsstAccountInfo)data;
        if (this.filter.getFilterItems().size() < 2) {
            this.filter.getFilterItems().add(new FilterItemInfo("CAA.id", (Object)aai.getId(), CompareType.EQUALS));
        } else {
            this.filter.getFilterItems().set(1, new FilterItemInfo("CAA.id", (Object)aai.getId(), CompareType.EQUALS));
        }
        if (!this.loading) {
            try {
                this.tableData = (ArrayList)AssistantAccountFactory.getRemoteInstance().queryAsstActType(((AsstAccountInfo)this.cmbAssistantAccount.getData()).getId().toString());
                for (HashMap item : this.tableData) {
                    item.put("from", null);
                    item.put("to", null);
                    item.put("selected", Boolean.TRUE);
                }
                this.setTableData();
            }
            catch (ReportBizException ex) {
                this.handUIException((Throwable)((Object)ex));
            }
        }
    }

    private void setTableData() {
        this.tblAssistantAccount.removeRows();
        this.tblAssistantAccount.getColumn(1).getStyleAttributes().setLocked(true);
        if (this.tableData == null) {
            return;
        }
        Iterator iter = this.tableData.iterator();
        EntityViewInfo vv = new EntityViewInfo();
        FilterInfo ff = new FilterInfo();
        ff.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getUIReportContext().getCompanyID(), CompareType.EQUALS));
        ff.getFilterItems().add(new FilterItemInfo("company.id", null, CompareType.EQUALS));
        ff.setMaskString("#0 or #1");
        vv.setFilter(ff);
        while (iter.hasNext()) {
            HashMap item = (HashMap)iter.next();
            IRow row = this.tblAssistantAccount.addRow();
            row.getCell("selected").setValue(item.get("selected"));
            row.getCell("type").setValue(item.get("name"));
            row.getCell("from").setValue(item.get("from"));
            row.getCell("to").setValue(item.get("to"));
            KDBizPromptBox bizPromptBox = new KDBizPromptBox();
            bizPromptBox.setEditable(true);
            bizPromptBox.setEditFormat("$number$");
            bizPromptBox.setCommitFormat("$number$");
            bizPromptBox.setDisplayFormat("$number$ - $name$");
            bizPromptBox.setQueryInfo((String)item.get("queryname"));
            if ("1".equals(item.get("FisForCompany"))) {
                bizPromptBox.setEntityViewInfo(vv);
                bizPromptBox.setHasCUDefaultFilter(false);
            } else {
                bizPromptBox.setHasCUDefaultFilter(true);
            }
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
            row.getCell("from").setEditor((ICellEditor)editor);
            row.getCell("to").setEditor((ICellEditor)editor);
            row.setUserObject((Object)item);
        }
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptParams();
            this.pp.setObject("period", (Object)new PeriodEntity((Map)this.getUIReportContext().getObject("periodRange")));
            this.pp.setInt("maxAccountLevel", this.getUIReportContext().getMaxAccountLevel());
            this.pp.setObject("allCurrency", (Object)this.getUIReportContext().getAllCurrency());
        }
    }

    private void fillDataToUI() {
        int i;
        this.loading = true;
        this.tblAssistantAccount.removeRows();
        if (this.filter == null) {
            this.filter = new FilterInfo();
            this.filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.getUIReportContext().getCompanyID(), CompareType.EQUALS));
        }
        SpinnerUtil.managePeriodRange((PeriodEntity)((PeriodEntity)this.pp.getObject("period")), (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false);
        SpinnerUtil.manageAccountLevelRange((int)1, (int)this.pp.getInt("maxAccountLevel"), (KDSpinner)this.spnClassFrom, (KDSpinner)this.spnClassTo);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(this.filter);
        this.cmbCodeFrom.setEditable(true);
        this.cmbCodeFrom.setEditFormat("$number$");
        this.cmbCodeFrom.setCommitFormat("$number$");
        this.cmbCodeFrom.setDisplayFormat("$number$ - $name$");
        this.cmbCodeFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.cmbCodeFrom.setEntityViewInfo(view);
        this.cmbCodeTo.setEditable(true);
        this.cmbCodeTo.setEditFormat("$number$");
        this.cmbCodeTo.setCommitFormat("$number$");
        this.cmbCodeTo.setDisplayFormat("$number$ - $name$");
        this.cmbCodeTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.cmbCodeTo.setEntityViewInfo(view);
        this.cmbAssistantAccount.setEditable(true);
        this.cmbAssistantAccount.setEditFormat("$number$");
        this.cmbAssistantAccount.setCommitFormat("$number$");
        this.cmbAssistantAccount.setDisplayFormat("$number$ - $name$");
        this.cmbAssistantAccount.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.F7AsstAccountQuery");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, this.getUIReportContext().getCompany(), this.filter, false, false);
        this.cmbCodeFrom.setSelector((KDPromptSelector)apb);
        this.cmbCodeTo.setSelector((KDPromptSelector)apb);
        this.cmbCurrency.removeAllItems();
        CurrencyCollection cc = (CurrencyCollection)this.pp.getObject("allCurrency");
        for (i = 0; i < cc.size(); ++i) {
            if (cc.get(i).isGeneralLocalCurrency() || cc.get(i).isGeneralReportCurrency()) continue;
            this.cmbCurrency.addItem((Object)cc.get(i));
        }
        if (!this.getUIReportContext().isForeignCurrencySu()) {
            for (i = 0; i < cc.size(); ++i) {
                if (!cc.get(i).isGeneralLocalCurrency() && !cc.get(i).isGeneralReportCurrency()) continue;
                this.cmbCurrency.addItem((Object)cc.get(i));
            }
        }
        if (this.pp.containsKey("spnYearFrom")) {
            this.spnYearFrom.setValue(this.pp.getObject("spnYearFrom"));
        }
        if (this.pp.containsKey("spnPeriodFrom")) {
            this.spnPeriodFrom.setValue(this.pp.getObject("spnPeriodFrom"));
        }
        if (this.pp.containsKey("spnPeriodFrom")) {
            this.spnPeriodFrom.setValue(this.pp.getObject("spnPeriodFrom"));
        }
        if (this.pp.containsKey("spnYearTo")) {
            this.spnYearTo.setValue(this.pp.getObject("spnYearTo"));
        }
        if (this.pp.containsKey("spnPeriodTo")) {
            this.spnPeriodTo.setValue(this.pp.getObject("spnPeriodTo"));
        }
        if (this.pp.containsKey("spnClassFrom")) {
            this.spnClassFrom.setValue(this.pp.getObject("spnClassFrom"));
        }
        if (this.pp.containsKey("spnClassTo")) {
            this.spnClassTo.setValue(this.pp.getObject("spnClassTo"));
        }
        if (this.pp.containsKey("cmbAssistantAccount")) {
            this.cmbAssistantAccount.setValue(this.pp.getObject("cmbAssistantAccount"));
        }
        if (this.pp.containsKey("cmbCodeFrom")) {
            this.cmbCodeFrom.setValue(this.pp.getObject("cmbCodeFrom"));
        }
        if (this.pp.containsKey("cmbCodeTo")) {
            this.cmbCodeTo.setValue(this.pp.getObject("cmbCodeTo"));
        }
        if (this.pp.containsKey("cmbCodeFromEnabled")) {
            this.cmbCodeFrom.setEnabled(((Boolean)this.pp.getObject("cmbCodeFromEnabled")).booleanValue());
        }
        if (this.pp.containsKey("cmbCodeToEnabled")) {
            this.cmbCodeTo.setEnabled(((Boolean)this.pp.getObject("cmbCodeToEnabled")).booleanValue());
        }
        if (this.pp.containsKey("cmbCurrency")) {
            this.cmbCurrency.setSelectedItem(this.pp.getObject("cmbCurrency"));
        } else {
            EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.cmbCurrency, (ObjectBaseInfo)this.getUIReportContext().getCompany().getBaseCurrency());
        }
        if (this.pp.containsKey("chkOpIncludeNotPosting")) {
            this.chkOpIncludeNotPosting.setSelected(((Boolean)this.pp.getObject("chkOpIncludeNotPosting")).booleanValue());
        }
        if (this.pp.containsKey("chkOpDisplayNoTrans")) {
            this.chkOpDisplayNoTrans.setSelected(((Boolean)this.pp.getObject("chkOpDisplayNoTrans")).booleanValue());
        }
        this.tableData = (ArrayList)this.pp.getObject("tableData");
        this.setTableData();
        this.loading = false;
    }

    @Override
    public void setCustomCondition(RptParams ac) {
        this.pp = ac;
        this.fillDataToUI();
    }

    @Override
    public RptParams getCustomCondition() {
        this.pp.setObject("spnYearFrom", this.spnYearFrom.getValue());
        this.pp.setObject("spnYearTo", this.spnYearTo.getValue());
        this.pp.setObject("spnPeriodFrom", this.spnPeriodFrom.getValue());
        this.pp.setObject("spnPeriodTo", this.spnPeriodTo.getValue());
        this.pp.setObject("spnClassFrom", this.spnClassFrom.getValue());
        this.pp.setObject("spnClassTo", this.spnClassTo.getValue());
        this.pp.setObject("cmbCodeFrom", this.cmbCodeFrom.getValue());
        this.pp.setObject("cmbCodeTo", this.cmbCodeTo.getValue());
        this.pp.setObject("cmbCodeFromEnabled", (Object)this.cmbCodeFrom.isEnabled());
        this.pp.setObject("cmbCodeToEnabled", (Object)this.cmbCodeTo.isEnabled());
        this.pp.setObject("cmbCurrency", this.cmbCurrency.getSelectedItem());
        this.pp.setObject("chkOpIncludeNotPosting", (Object)this.chkOpIncludeNotPosting.isSelected());
        this.pp.setObject("chkOpDisplayNoTrans", (Object)this.chkOpDisplayNoTrans.isSelected());
        this.pp.setObject("cmbAssistantAccount", this.cmbAssistantAccount.getValue());
        for (int i = 0; i < this.tblAssistantAccount.getRowCount(); ++i) {
            ((Map)this.tableData.get(i)).put("selected", this.tblAssistantAccount.getRow(i).getCell("selected").getValue());
            ((Map)this.tableData.get(i)).put("from", this.tblAssistantAccount.getRow(i).getCell("from").getValue());
            ((Map)this.tableData.get(i)).put("to", this.tblAssistantAccount.getRow(i).getCell("to").getValue());
        }
        this.pp.setObject("tableData", (Object)this.tableData);
        return this.pp;
    }

    public boolean verify() {
        RptParams aacb = this.getCustomCondition();
        if (aacb.getObject("cmbAssistantAccount") == null) {
            MsgBox.showInfo((String)GLResource.getResourceString("no_assistant_account"));
            return false;
        }
        boolean validate = true;
        List tableData = (List)aacb.getObject("tableData");
        if (tableData == null) {
            validate = false;
        } else {
            boolean selected = false;
            for (int i = 0; i < tableData.size(); ++i) {
                Boolean bb = (Boolean)((Map)tableData.get(i)).put("selected", this.tblAssistantAccount.getRow(i).getCell("selected").getValue());
                if (!bb.booleanValue()) continue;
                selected = true;
                break;
            }
            validate &= selected;
        }
        if (!validate) {
            MsgBox.showInfo((String)GLResource.getResourceString("no_assistant_account_item"));
        }
        return validate;
    }

    public Dimension getSize() {
        return new Dimension(375, 325);
    }
}

