/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountF7Filter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.client.AbstractAssistantHgListConditionUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class AssistantHgListConditionUI
extends AbstractAssistantHgListConditionUI {
    private static final long serialVersionUID = -6400386255744869257L;
    private static final Logger logger = CoreUIObject.getLogger(AssistantHgListConditionUI.class);

    public AssistantHgListConditionUI() throws Exception {
        this.onInit();
    }

    public void onInit() throws Exception {
        AuxAccountF7Filter.setFilter((KDBizPromptBox)this.jebAcct);
        this.tbl.checkParsed();
        this.tbl.getSelectManager().setSelectMode(1);
        this.pkShowReference.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AssistantHgListConditionUI.this.pkShowNoReference.setSelected(false);
                }
            }
        });
        this.pkShowNoReference.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AssistantHgListConditionUI.this.pkShowReference.setSelected(false);
                }
            }
        });
        this.spMaxRecords.setModel((SpinnerModel)new SpinnerNumberModel(500, 0, 100000, 500));
        this.pkGroupNameLoss.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AssistantHgListConditionUI.this.pkItemNameError.setSelected(false);
                }
            }
        });
        this.pkItemNameError.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AssistantHgListConditionUI.this.pkGroupNameLoss.setSelected(false);
                }
            }
        });
    }

    @Override
    protected void jebAcct_dataChanged(DataChangeEvent e) throws Exception {
        String asstAccountId = null;
        Object value = this.jebAcct.getValue();
        if (value != null) {
            AsstAccountInfo aai = (AsstAccountInfo)value;
            asstAccountId = aai.getId().toString();
            try {
                List list = RptClientUtil.queryAsstAct(asstAccountId, SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString());
                this.setTableData(list);
            }
            catch (ReportBizException ex) {
                this.handUIException((Throwable)((Object)ex));
            }
        } else {
            this.tbl.removeRows();
        }
    }

    private void setTableData(List list) {
        AsstactTypeEntity at;
        this.tbl.setRefresh(false);
        this.tbl.removeRows();
        if (list == null) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            at = (AsstactTypeEntity)list.get(i);
            idSet.add(at.getId());
        }
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(fi);
        AsstActTypeCollection asstActColl = null;
        try {
            asstActColl = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            IRow row = this.tbl.addRow();
            at = (AsstactTypeEntity)list.get(i);
            this.addF7(row, at);
            row.setUserObject((Object)at);
            AsstActTypeInfo asstActTypeInfo = this.findAsstActTypeInfo(asstActColl, at.getId());
            if (asstActTypeInfo != null) {
                row.getCell("type").setValue((Object)asstActTypeInfo.getName());
            }
            row.getCell("from").setValue(at.getFrom());
            row.getCell("to").setValue(at.getTo());
        }
        this.tbl.setRefresh(true);
        this.tbl.updateUI();
    }

    private void addF7(IRow row, AsstactTypeEntity at) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setDisplayFormat("$number$ - $name$");
        bizPromptBox.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        bizPromptBox.setSelectorCollection(sic);
        GeneralAsstActTypeGroupInfo grp = null;
        if (at.getGeneralAsstactGroupId() != null) {
            grp = new GeneralAsstActTypeGroupInfo();
            grp.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
        }
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, null, (CoreUIObject)this, (boolean)at.isUseLongNumber());
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("from").setEditor((ICellEditor)editor);
        row.getCell("to").setEditor((ICellEditor)editor);
    }

    private AsstActTypeInfo findAsstActTypeInfo(AsstActTypeCollection asstActCol, String id) {
        if (asstActCol == null || id == null || id.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < asstActCol.size(); ++i) {
            if (!BOSUuid.read((String)id).equals((Object)asstActCol.get(i).getId())) continue;
            return asstActCol.get(i);
        }
        return null;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)this.getParam());
        return cp;
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this), new Component[]{this.tbl});
        rcm.setProperty("tableData", (Object)this.getTableData());
        return rcm.toRptParams();
    }

    protected List getTableData() {
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        AsstactTypeEntity at = null;
        IRow row = null;
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tbl.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            list.add(at);
        }
        return list;
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params, new String[]{"tableData"});
        rcm.restoreAllStatus((Container)((Object)this));
        this.setTableData((List)rcm.getProperty("tableData"));
    }

    public void setRptParams(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params, new String[]{"tableData"});
        rcm.restoreAllStatus((Container)((Object)this));
        this.setTableData((List)rcm.getProperty("tableData"));
    }

    public Object getParam() {
        return this.getCustomCondition();
    }

    public void setParam(Object condition) {
        if (condition != null) {
            this.setCustomCondition((RptParams)condition);
        }
    }

    public boolean verify() {
        if (this.jebAcct.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"208_AssistantHgListConditionUI"));
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.jebAcct.setValue(null);
    }
}

