/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.gl.AutoAssistantHGUpdateFacadeFactory;
import com.kingdee.eas.fi.gl.IAutoAssistantHGUpdateFacade;
import com.kingdee.eas.fi.gl.client.AbstractAssistantHgListUI;
import com.kingdee.eas.fi.gl.client.AssistantHgListConditionUI;
import com.kingdee.eas.fi.gl.client.AssistantHgRepairUI;
import com.kingdee.eas.fm.common.client.AbstractHidedMenuItem;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Base64Encoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class AssistantHgListUI
extends AbstractAssistantHgListUI {
    private static final long serialVersionUID = 8516119112015816794L;
    private static final Logger logger = CoreUIObject.getLogger(AssistantHgListUI.class);
    public static final String INITRESOURCE_PATH = "com.kingdee.eas.fi.gl.InitResource";
    private static final DateFormat DF_LOG = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    private AssistantHgListConditionUI conditonUI = new AssistantHgListConditionUI();
    private CommonQueryDialog dialog = null;
    private RptParams params;
    private boolean isFirstDefaultQuery = true;
    private boolean stop = false;
    private Color okColor = new Color(0, 130, 0);
    private Map<String, Object> inits = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.initMyIcon();
        this.tblMain.getColumn("asstName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("baseData").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("displayname").getStyleAttributes().setLocked(true);
        this.popFilterDialog();
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift Q"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"params", (Object)AssistantHgListUI.this.conditonUI.getCustomCondition());
                    IUIWindow wnd = fy.create("com.kingdee.eas.fi.gl.client.HGReplaceToolUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
        this.kDSplitPane1.setDividerLocation(this.kDSplitPane1.getHeight() - 88);
    }

    protected void initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl", "AssistanHgQuery"));
            this.dialog.setDisShowRowCount(true);
            try {
                this.dialog.addUserPanel((KDPanel)this.conditonUI);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            this.dialog.setShowSorter(false);
            this.dialog.setShowFilter(false);
            this.dialog.setHeight(320);
            this.dialog.setWidth(420);
        }
    }

    private void initMyIcon() {
        this.kbSelectAll.setEnabled(true);
        this.kbSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.kbRemoveAll.setEnabled(true);
        this.kbRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.kbDelete.setEnabled(true);
        this.kbDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.kbModify.setEnabled(true);
        this.kbModify.setIcon(EASResource.getIcon((String)"imgTbtn_modifyattribute"));
        this.kbAutoModify.setIcon(EASResource.getIcon((String)"imgTbtn_modifyattribute"));
        this.kbUnite.setEnabled(true);
        this.kbUnite.setIcon(EASResource.getIcon((String)"imgTbtn_unite"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.kbClearCache.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.kbClear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.kDScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(145, 148, 140), 1));
    }

    protected void popFilterDialog() throws Exception {
        this.initCommonQueryDialog();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = "com.kingdee.eas.fi.gl.AssistanHgQuery";
        CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
        String currUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName, currCompany.getId().toString(), currUserID)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName, currCompany.getId().toString(), currUserID);
            if (solution.getName().equals(FaResUtil.getRes((String)"defaultSolution"))) {
                this.actionQuery_actionPerformed(null);
            } else {
                QueryPanelCollection queryPanels = solution.getQueryPanelInfo();
                if (queryPanels != null) {
                    QueryPanelInfo queryPanel = null;
                    int size = queryPanels.size();
                    for (int i = 0; i < size; ++i) {
                        if (queryPanels.get(i).getQueryPanelType() != QueryPanelTypeEnum.CUSTOMER_PANEL) continue;
                        queryPanel = queryPanels.get(i);
                        break;
                    }
                    if (queryPanel != null && queryPanel.getCustomerParams() != null) {
                        try {
                            String pm;
                            String strParam = queryPanel.getCustomerParams();
                            if (strParam != null && (pm = XMLBean.TransStrToCustParams((String)strParam).getCustomerParam("RPTPARAMS_KEY_AT_CUSTOMERPARAMS")) != null) {
                                byte[] bytes = Base64Encoder.base64ToByteArray((String)pm);
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                                this.params = (RptParams)objectInputStream.readObject();
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                    }
                }
                if (this.params == null) {
                    this.actionQuery_actionPerformed(null);
                } else {
                    this.actionRefresh_actionPerformed(null);
                }
            }
        } else {
            this.actionQuery_actionPerformed(null);
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog.show()) {
            this.params = this.conditonUI.getCustomCondition();
            List dataCol = this.getFacade().getData(this.params);
            if (dataCol != null) {
                this.tblMain.removeRows();
                for (int i = 0; i < dataCol.size(); ++i) {
                    IRow rowAss = this.tblMain.addRow();
                    Map info = (Map)dataCol.get(i);
                    String id = (String)info.get("id");
                    rowAss.setUserObject((Object)info);
                    rowAss.getCell("select").setValue((Object)Boolean.FALSE);
                    rowAss.getCell("id").setValue((Object)id);
                    rowAss.getCell("asstName").setValue(info.get("asstName"));
                    rowAss.getCell("displayname").setValue(info.get("displayname"));
                    rowAss.getCell("asstAccountId").setValue(info.get("asstAccountId"));
                    rowAss.getCell("baseData").setValue(info.get("baseData"));
                }
            }
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.params == null) {
            return;
        }
        List dataCol = this.getFacade().getData(this.params);
        if (dataCol != null) {
            this.tblMain.removeRows();
            for (int i = 0; i < dataCol.size(); ++i) {
                IRow rowAss = this.tblMain.addRow();
                Map info = (Map)dataCol.get(i);
                String id = (String)info.get("id");
                rowAss.setUserObject((Object)info);
                rowAss.getCell("select").setValue((Object)Boolean.FALSE);
                rowAss.getCell("id").setValue((Object)id);
                rowAss.getCell("asstName").setValue(info.get("asstName"));
                rowAss.getCell("displayname").setValue(info.get("displayname"));
                rowAss.getCell("asstAccountId").setValue(info.get("asstAccountId"));
                rowAss.getCell("baseData").setValue(info.get("baseData"));
            }
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        new Thread(new Runnable(){

            @Override
            public void run() {
                AssistantHgListUI.this.doDelete();
            }
        }).start();
    }

    private void enableAction(boolean enable) {
        this.actionSelectAll.setEnabled(enable);
        this.actionRemoveAll.setEnabled(enable);
        this.actionRefresh.setEnabled(enable);
        this.actionQuery.setEnabled(enable);
        this.actionModify.setEnabled(enable);
        this.actionDelete.setEnabled(enable);
        this.actionUnite.setEnabled(enable);
        this.actionClearCache.setEnabled(enable);
        this.actionAutoModify.setEnabled(enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete() {
        this.showInfo(DF_LOG.format(new Date()) + " delete start... \n");
        try {
            this.enableAction(false);
            this.stop = false;
            int rowCount = this.tblMain.getRowCount();
            int total = 0;
            int count = 0;
            for (int i = 0; i < rowCount; ++i) {
                if (this.stop) {
                    return;
                }
                IRow rowAss = this.tblMain.getRow(i);
                boolean isSelected = (Boolean)rowAss.getCell("select").getValue();
                if (!isSelected) continue;
                ++total;
                String id = (String)rowAss.getCell("id").getValue();
                String info = "row :" + (i + 1) + " " + rowAss.getCell("displayname").getValue() + ": ";
                try {
                    this.getFacade().delete(id);
                    this.showInfo(info + "delete \n", this.okColor);
                    ++count;
                    continue;
                }
                catch (EASBizException ex) {
                    this.showInfo(info + ex.getMessage() + "\n", Color.RED);
                }
            }
            this.showInfo(DF_LOG.format(new Date()) + " delete finished, count:" + count + "/" + total + ". \n\n", null);
        }
        catch (Throwable ex) {
            this.handUIException(ex);
        }
        finally {
            this.enableAction(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AssistantHgListUI.this.actionRefresh_actionPerformed(null);
                }
                catch (Throwable ex) {
                    AssistantHgListUI.this.handUIException(ex);
                }
            }
        });
    }

    private void showInfo(String info) {
        this.showInfo(info, null);
    }

    private void showInfo(final String info, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                if (color != null) {
                    StyleConstants.setForeground(attributeSet, color);
                }
                Document doc = AssistantHgListUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), info, attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                AssistantHgListUI.this.txtConsole.setSelectionStart(doc.getLength());
            }
        });
    }

    @Override
    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        super.actionModify_actionPerformed(e);
        new Thread(new Runnable(){

            @Override
            public void run() {
                AssistantHgListUI.this.doModify();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doModify() {
        this.showInfo(DF_LOG.format(new Date()) + " repair start ...\n", null);
        try {
            this.enableAction(false);
            this.stop = false;
            HashMap<String, String> idMap = new HashMap<String, String>();
            IIDList idlist = this.getSelectedKeyValues();
            for (int i = 0; i < idlist.size(); ++i) {
                if (this.stop) {
                    return;
                }
                String id = idlist.getID(i);
                String longname = this.getFacade().modify(id);
                if (longname == null) continue;
                idMap.put(id, longname);
            }
            if (idMap.size() > 0) {
                int rowCount = this.tblMain.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    String id;
                    IRow rowAss = this.tblMain.getRow(i);
                    boolean isSelected = (Boolean)rowAss.getCell("select").getValue();
                    if (!isSelected || !idMap.containsKey(id = (String)rowAss.getCell("id").getValue())) continue;
                    rowAss.getCell("displayname").setValue(idMap.get(id));
                }
            }
            this.showInfo(DF_LOG.format(new Date()) + " repair finished, count:" + idMap.size() + "/" + idlist.size() + ". \n\n", null);
        }
        catch (Throwable ex) {
            this.handUIException(ex);
        }
        finally {
            this.enableAction(true);
        }
    }

    @Override
    public void actionAutoModify_actionPerformed(ActionEvent e) throws Exception {
        Map<String, Object> map;
        super.actionModify_actionPerformed(e);
        if (this.inits == null) {
            this.inits = new HashMap<String, Object>();
            ArrayList asstAccounts = new ArrayList();
            this.inits.put("asstAccounts", asstAccounts);
        }
        if ((map = AssistantHgRepairUI.showMe((Object)this, this.inits)) == null || map.size() == 0) {
            return;
        }
        this.inits = map;
        final AsstActTypeInfo asstActType = (AsstActTypeInfo)this.inits.get("asstActType");
        if (asstActType == null) {
            this.showInfo(DF_LOG.format(new Date()) + " asstActType can not be empty \n\n", null);
            return;
        }
        final List asstAccounts = (List)this.inits.get("asstAccounts");
        if (asstAccounts == null || asstAccounts.size() == 0) {
            this.showInfo(DF_LOG.format(new Date()) + " asstAccounts can not be empty \n\n", null);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                AssistantHgListUI.this.doAutoModify(asstActType, asstAccounts);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAutoModify(AsstActTypeInfo asstActType, List<AsstAccountInfo> asstAccounts) {
        this.showInfo(DF_LOG.format(new Date()) + " auto repair start ...\n", null);
        try {
            this.enableAction(false);
            this.stop = false;
            boolean isDetail = this.inits.get("isDetail") != null && Boolean.parseBoolean(this.inits.get("isDetail").toString());
            boolean isEffect = this.inits.get("isEffect") != null && Boolean.parseBoolean(this.inits.get("isEffect").toString());
            int count = 0;
            int total = 0;
            for (AsstAccountInfo asstAccount : asstAccounts) {
                if (this.stop) {
                    return;
                }
                this.showInfo(DF_LOG.format(new Date()) + " asstAccount:" + asstAccount.getName() + " start ...\n", null);
                HashMap<String, Object> ps = new HashMap<String, Object>();
                ps.put("asstActType", asstActType);
                ps.put("asstAct", this.inits.get("asstAct"));
                ps.put("asstAccount", asstAccount);
                ps.put("hg", this.inits.get("hg"));
                ps.put("isDetail", this.inits.get("isDetail"));
                ps.put("isEffect", this.inits.get("isEffect"));
                ps.put("loc", this.inits.get("loc"));
                Map result = this.getFacade().repair(ps);
                if (result.get("msg") != null) {
                    this.showInfo(result.get("msg") + " \n\n", Color.RED);
                    continue;
                }
                if (isDetail) {
                    List hgs = (List)result.get("hgs");
                    for (Map hg : hgs) {
                        this.showInfo((String)hg.get("id") + "\n", isEffect ? this.okColor : null);
                        this.showInfo("    " + (String)hg.get("longname_old") + "\n", isEffect ? this.okColor : null);
                        this.showInfo("    " + (String)hg.get("longname_new") + "\n", isEffect ? this.okColor : null);
                        this.showInfo("    " + (String)hg.get("displayname_old") + "\n", isEffect ? this.okColor : null);
                        this.showInfo("    " + (String)hg.get("displayname_new") + "\n", isEffect ? this.okColor : null);
                        this.showInfo("    " + (String)hg.get("longnumber_old") + "\n", isEffect ? this.okColor : null);
                        this.showInfo("    " + (String)hg.get("longnumber_new") + "\n", isEffect ? this.okColor : null);
                    }
                }
                int icount = (Integer)result.get("count");
                count += icount;
                int itotal = (Integer)result.get("total");
                total += itotal;
                this.showInfo(DF_LOG.format(new Date()) + " asstAccount:" + asstAccount.getName() + " finished, count:" + icount + "/" + itotal + ".\n", null);
            }
            this.showInfo(DF_LOG.format(new Date()) + " auto repair finished, count:" + count + "/" + total + ".\n\n", null);
        }
        catch (Throwable ex) {
            this.handUIException(ex);
        }
        finally {
            this.enableAction(true);
        }
    }

    protected boolean isFirstDefaultQuery() {
        return this.isFirstDefaultQuery;
    }

    @Override
    public void actionUnite_actionPerformed(final ActionEvent e) throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AssistantHgListUI.this.doUnite(e);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnite(final ActionEvent e) {
        this.showInfo(DF_LOG.format(new Date()) + " unite start... \n");
        int rowCount = this.tblMain.getRowCount();
        ArrayList<IRow> selectRows = new ArrayList<IRow>();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            boolean isSelected = (Boolean)rowAss.getCell("select").getValue();
            if (!isSelected) continue;
            selectRows.add(rowAss);
        }
        try {
            this.enableAction(false);
            String asstaccount = null;
            String groupName = null;
            ArrayList<String> idList = null;
            this.stop = false;
            for (int i = 0; i < selectRows.size(); ++i) {
                if (this.stop) {
                    return;
                }
                IRow rowAss = (IRow)selectRows.get(i);
                String curAsst = (String)rowAss.getCell("asstAccountId").getValue();
                String curGroupName = (String)rowAss.getCell("displayname").getValue();
                if (asstaccount == null || groupName == null) {
                    asstaccount = curAsst;
                    groupName = curGroupName;
                    String id = (String)rowAss.getCell("id").getValue();
                    idList = new ArrayList<String>();
                    idList.add(id);
                    continue;
                }
                if (curAsst.equals(asstaccount) && groupName.equals(curGroupName)) {
                    String id = (String)rowAss.getCell("id").getValue();
                    idList.add(id);
                    continue;
                }
                int count = idList.size();
                if (count > 1) {
                    String info = i + "/" + selectRows.size() + " " + groupName + ": ";
                    try {
                        this.getFacade().unite(idList.toArray(new String[count]), null, asstaccount, null);
                        this.showInfo(info + "unite \n", this.okColor);
                    }
                    catch (Exception ex) {
                        this.showInfo(info + ex.getMessage() + "\n", Color.RED);
                    }
                }
                asstaccount = curAsst;
                groupName = curGroupName;
                String id = (String)rowAss.getCell("id").getValue();
                idList = new ArrayList();
                idList.add(id);
            }
            if (idList != null && idList.size() > 1) {
                String info = selectRows.size() + "/" + selectRows.size() + " " + groupName + ": ";
                try {
                    this.getFacade().unite(idList.toArray(new String[idList.size()]), null, asstaccount, null);
                    this.showInfo(info + "unite \n", this.okColor);
                }
                catch (Exception ex) {
                    this.showInfo(info + ex.getMessage() + "\n", Color.RED);
                }
            }
            this.showInfo(DF_LOG.format(new Date()) + " unite finished. \n\n");
        }
        catch (Throwable ex) {
            this.handUIException(ex);
        }
        finally {
            this.enableAction(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AssistantHgListUI.this.actionRefresh_actionPerformed(e);
                }
                catch (Throwable ex) {
                    AssistantHgListUI.this.handUIException(ex);
                }
            }
        });
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(true);
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(false);
    }

    @Override
    public void actionClearCache_actionPerformed(ActionEvent e) throws Exception {
        this.clearCashe();
    }

    private void doSelect(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            rowAss.getCell("select").setValue((Object)select);
        }
    }

    private void clearCashe() throws Exception {
        this.getFacade().clearCashe();
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtConsole.setText("");
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private IAutoAssistantHGUpdateFacade getFacade() throws Exception {
        return AutoAssistantHGUpdateFacadeFactory.getRemoteInstance();
    }

    public void loadData() throws Exception {
    }

    protected IIDList getSelectedKeyValues() {
        RealModeIDList idList = new RealModeIDList();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            boolean isSelected = (Boolean)rowAss.getCell("select").getValue();
            if (!isSelected) continue;
            String id = (String)rowAss.getCell("id").getValue();
            idList.add(id);
        }
        return idList;
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }
}

