/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountF7Filter;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.client.AbstractAssistantHgRepairUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.apache.log4j.Logger;

public class AssistantHgRepairUI
extends AbstractAssistantHgRepairUI {
    private static final Logger logger = CoreUIObject.getLogger(AssistantHgRepairUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.AutoAssistantHGUpdateResource";
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    private Map<String, Object> params = null;
    private Map<String, Object> result = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        Map uiContext = this.getUIContext();
        this.params = (Map)uiContext.get("params");
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.showParams(this.params);
    }

    private void init() throws Exception {
        this.prmtAsstActType.setEditable(true);
        this.prmtAsstActType.setEditFormat("$number$");
        this.prmtAsstActType.setCommitFormat("$number$;$name$");
        this.prmtAsstActType.setDisplayFormat("$name$");
        this.prmtAsstActType.setHasCUDefaultFilter(false);
        AuxAccountF7Filter.setFilter((KDBizPromptBox)this.prmtAsstAccount);
        this.prmtAsstAccount.setEnabledMultiSelection(true);
        this.prmtAsstAccount.setValue(null);
        this.cbDetailLog.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.rbL1);
        group.add((AbstractButton)this.rbL2);
        group.add((AbstractButton)this.rbL3);
        String loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        if ("l1".equalsIgnoreCase(loc)) {
            this.rbL1.setSelected(true);
        } else if ("l3".equalsIgnoreCase(loc)) {
            this.rbL3.setSelected(true);
        } else {
            this.rbL2.setSelected(true);
        }
        this.rbL1.setEnabled(false);
        this.rbL2.setEnabled(false);
        this.rbL3.setEnabled(false);
    }

    private void showParams(Map params) {
        Object v = params.get("asstActType");
        if (v instanceof AsstActTypeInfo) {
            this.prmtAsstActType.setValue(v);
        }
        if ((v = params.get("asstAct")) != null) {
            this.txtAsstAct.setText(v.toString());
        }
        if ((v = params.get("asstAccounts")) instanceof List) {
            Object[] asstAccounts = ((List)v).toArray(new Object[0]);
            if (params.get("isAllAsstAccount") instanceof Boolean && ((Boolean)params.get("isAllAsstAccount")).booleanValue()) {
                asstAccounts = null;
            }
            this.prmtAsstAccount.setValue((Object)asstAccounts);
        }
        if ((v = params.get("hg")) != null) {
            this.txtHg.setText(v.toString());
        }
        if ((v = params.get("isDetail")) != null) {
            this.cbDetailLog.setSelected(Boolean.parseBoolean(v.toString()));
        }
        if ((v = params.get("isEffect")) != null) {
            this.cbEffect.setSelected(Boolean.parseBoolean(v.toString()));
        }
        if ((v = params.get("loc")) != null) {
            String loc = v.toString().trim();
            if ("l1".equalsIgnoreCase(loc)) {
                this.rbL1.setSelected(true);
            } else if ("l3".equalsIgnoreCase(loc)) {
                this.rbL3.setSelected(true);
            } else {
                this.rbL2.setSelected(true);
            }
        }
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        int r;
        Object object = this.prmtAsstActType.getValue();
        if (object == null) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u9879\u76ee\u7c7b\u578b");
            return;
        }
        AsstActTypeInfo type = (AsstActTypeInfo)object;
        boolean isAllAsstAccount = false;
        ArrayList<AsstAccountInfo> aas = new ArrayList<AsstAccountInfo>();
        Object[] objects = (Object[])this.prmtAsstAccount.getValue();
        if (objects != null && objects.length > 0) {
            for (Object o : objects) {
                AsstAccountInfo aa = (AsstAccountInfo)o;
                if (aa == null) continue;
                AsstActTypeCollection types = this.getAsstActTypes(aa.getId().toString());
                boolean found = false;
                for (AsstActTypeInfo t : types) {
                    if (!type.getAsstHGAttribute().equals(t.getAsstHGAttribute())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    MsgBox.showInfo((String)MessageFormat.format(this.getString("AsstAccount_No_AsstActType"), aa.getName(), type.getName()));
                    return;
                }
                aas.add(aa);
            }
        } else {
            isAllAsstAccount = true;
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            view.setSelector(sic);
            AsstAccountCollection coll = AsstAccountFactory.getRemoteInstance().getAsstAccountCollection(view);
            for (AsstAccountInfo aa : coll) {
                AsstActTypeCollection types = this.getAsstActTypes(aa.getId().toString());
                boolean found = false;
                for (AsstActTypeInfo t : types) {
                    if (!type.getAsstHGAttribute().equals(t.getAsstHGAttribute())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                aas.add(aa);
            }
        }
        if (aas.size() == 0) {
            MsgBox.showInfo((String)this.getString("NoNeedProcess_AsstAccount"));
            return;
        }
        if (this.cbEffect.isSelected() && (r = MsgBox.showConfirm2((String)this.getString("LongTime_GoOn"))) != 0) {
            return;
        }
        this.result = new HashMap<String, Object>();
        this.result.put("asstActType", type);
        this.result.put("asstAct", this.txtAsstAct.getText());
        this.result.put("asstAccounts", aas);
        this.result.put("isAllAsstAccount", isAllAsstAccount);
        this.result.put("hg", this.txtHg.getText());
        this.result.put("isDetail", this.cbDetailLog.isSelected());
        this.result.put("isEffect", this.cbEffect.isSelected());
        if (this.rbL1.isSelected()) {
            this.result.put("loc", "l1");
        } else if (this.rbL3.isSelected()) {
            this.result.put("loc", "l3");
        } else {
            this.result.put("loc", "l2");
        }
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public Map<String, Object> getParams() {
        return this.result;
    }

    private AsstActTypeCollection getAsstActTypes(String asstAccountId) throws BOSException {
        if (this.asstActTypess.containsKey(asstAccountId)) {
            return this.asstActTypess.get(asstAccountId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        this.asstActTypess.put(asstAccountId, asstActTypes);
        return asstActTypes;
    }

    public String getString(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }

    public static Map<String, Object> showMe(Object owner, Map<String, Object> params) {
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"params", params);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.AssistantHgRepairUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            AssistantHgRepairUI ui = (AssistantHgRepairUI)uiWindow.getUIObject();
            return ui.getParams();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

