/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLAsstAccountChangeFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AbstractAsstAccountChangeVchMgrUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class AsstAccountChangeVchMgrUI
extends AbstractAsstAccountChangeVchMgrUI {
    private static final Logger logger = CoreUIObject.getLogger(AsstAccountChangeVchMgrUI.class);
    protected static final String RESOURCE = "com.kingdee.eas.fi.gl.AsstActUniteResource";
    private static final String RES = "com.kingdee.eas.fi.gl.BalanceAnalysisResource";
    private boolean stop = false;
    private KDButtonGroup bgAction = new KDButtonGroup();
    private int maxFuture = 120;
    DataChangeListener companyListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                AsstAccountChangeVchMgrUI.this.initAccount();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                AsstAccountChangeVchMgrUI.this.handUIException(ex);
            }
            try {
                AsstAccountChangeVchMgrUI.this.initPeriod();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                AsstAccountChangeVchMgrUI.this.handUIException(ex);
            }
        }
    };

    public void onLoad() throws Exception {
        super.onLoad();
        this.spConsole.setBorder(BorderFactory.createLineBorder(new Color(145, 148, 140), 1));
        this.rbSubuild.setSelected(true);
        this.initMyIcon();
        this.initCompany();
    }

    private void initMyIcon() throws Exception {
        this.periodFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodFrom.setEditable(true);
        this.periodFrom.setEditFormat("$number$");
        this.periodFrom.setCommitFormat("$number$");
        this.periodTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodTo.setEditable(true);
        this.periodTo.setEditFormat("$number$");
        this.periodTo.setCommitFormat("$number$");
        this.bgAction.add((AbstractButton)this.rbSubuild);
        this.bgAction.add((AbstractButton)this.rbRebuild);
        this.bgAction.add((AbstractButton)this.rbDelete);
        this.rbSubuild.setSelected(true);
        this.btnOk.setEnabled(true);
    }

    private void initCompany() throws Exception {
        this.promptCompany.setQueryInfo("com.kingdee.eas.fi.gl.app.CompanyOrgUnitQuery");
        this.promptCompany.setEditable(true);
        this.promptCompany.setEditFormat("$number$");
        this.promptCompany.setCommitFormat("$name$;$number$");
        this.promptCompany.setDisplayFormat("$number$-$name$");
        this.promptCompany.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Integer(0)));
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s \n");
        sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append("    and sc.FStartPeriodID is not null \n");
        sql.append("    and sc.FCurrentPeriodID is not null \n");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filter);
        this.promptCompany.setEntityViewInfo(view);
        CompanyOrgUnitInfo company = this.getFirstOrg();
        if (company != null) {
            this.promptCompany.setValue((Object)new Object[]{company});
        } else {
            this.promptCompany.setValue((Object)new Object[0]);
        }
        this.promptCompany.addDataChangeListener(this.companyListener);
        this.initAccount();
        this.initPeriod();
    }

    private CompanyOrgUnitInfo getFirstOrg() {
        IRowSet rs;
        StringBuffer sql;
        Map context = this.getUIContext();
        if (context.get("company") != null) {
            return (CompanyOrgUnitInfo)context.get("company");
        }
        String companyId = null;
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company.isIsBizUnit() && !company.isIsSealUp()) {
            sql = new StringBuffer();
            sql.append("select c.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
            sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
            sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            sql.append("    and c.FID = '" + company.getId().toString() + "' \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    companyId = company.getId().toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (companyId == null) {
            sql = new StringBuffer();
            sql.append("select top 1 c.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
            sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
            sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    companyId = rs.getString("FID");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (companyId != null) {
            try {
                return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void initAccount() throws Exception {
    }

    private void initPeriod() throws Exception {
        this.periodFrom.setEnabled(false);
        this.periodTo.setEnabled(false);
        Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects == null || objects.length == 0) {
            this.periodFrom.setValue(null);
            this.periodTo.setValue(null);
            return;
        }
        CompanyOrgUnitInfo company = this.queryCompany((CompanyOrgUnitInfo)objects[0]);
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
        if (objects.length == 1) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod.getNumber(), CompareType.GREATER_EQUALS));
        }
        this.periodFrom.setEntityViewInfo(view);
        this.periodTo.setEntityViewInfo(view);
        this.periodFrom.setValue((Object)curPeriod);
        this.periodTo.setValue((Object)curPeriod);
        this.periodFrom.setEnabled(true);
        this.periodTo.setEnabled(true);
    }

    private CompanyOrgUnitInfo queryCompany(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.getAccountPeriodType() != null) {
            return company;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountPeriodType.id");
        CompanyOrgUnitInfo c = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
        company.setAccountPeriodType(c.getAccountPeriodType());
        return company;
    }

    private void enableComponent(boolean enable) {
        this.promptCompany.setEnabled(enable);
        this.txtAccount.setEnabled(enable);
        this.periodFrom.setEnabled(enable);
        this.periodTo.setEnabled(enable);
        this.rbSubuild.setEnabled(enable);
        this.rbRebuild.setEnabled(enable);
        this.rbDelete.setEnabled(enable);
        this.cbEffect.setEnabled(enable);
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnOk.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.actionComfirm.setEnabled(false);
            this.btnOk.setEnabled(false);
            return;
        }
        final Object[] companys = (Object[])this.promptCompany.getValue();
        if (companys == null || companys.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SelectOrg"));
            return;
        }
        final ArrayList<String> accounts = new ArrayList<String>();
        String strAccount = this.txtAccount.getText();
        if (strAccount != null) {
            String[] strAccounts;
            strAccount = strAccount.trim();
            for (String str : strAccounts = strAccount.split(";")) {
                if ((str = str.trim()).length() <= 0 || accounts.contains(str)) continue;
                accounts.add(str);
            }
        }
        if (accounts.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getString("Input_Account"));
            return;
        }
        PeriodInfo startPeriod = (PeriodInfo)this.periodFrom.getValue();
        if (startPeriod == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getString("Select_BeginPeriod"));
            return;
        }
        PeriodInfo endPeriod = (PeriodInfo)this.periodTo.getValue();
        if (endPeriod == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getString("Select_EndPeriod"));
            return;
        }
        if (startPeriod.getNumber() > endPeriod.getNumber()) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getString("Begin_MoreThan_End"));
            return;
        }
        HashSet<String> companyIds = new HashSet<String>();
        for (int i = 0; i < companys.length; ++i) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys[i];
            if (company.getAccountTable() != null && company.getAccountTable().getId() != null) continue;
            companyIds.add(company.getId().toString());
        }
        if (companyIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("accountTable.id");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
            view.setFilter(filter);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            HashMap<String, AccountTableInfo> accountTables = new HashMap<String, AccountTableInfo>();
            for (CompanyOrgUnitInfo company : coll) {
                accountTables.put(company.getId().toString(), company.getAccountTable());
            }
            for (int i = 0; i < companys.length; ++i) {
                CompanyOrgUnitInfo company;
                company = (CompanyOrgUnitInfo)companys[i];
                AccountTableInfo accountTable = (AccountTableInfo)accountTables.get(company.getId().toString());
                if (accountTable == null) continue;
                if (company.getAccountTable() == null) {
                    company.setAccountTable(accountTable);
                    continue;
                }
                if (company.getAccountTable().getId() != null) continue;
                company.getAccountTable().setId(accountTable.getId());
            }
        }
        HashSet<String> accountNumbers = new HashSet<String>();
        accountNumbers.addAll(accounts);
        final HashMap companyAccountss = new HashMap();
        for (int i = 0; i < companys.length; ++i) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys[i];
            HashMap<String, AccountViewInfo> companyAccounts = new HashMap<String, AccountViewInfo>();
            companyAccountss.put(company.getId().toString(), companyAccounts);
            AccountTableInfo accountTable = company.getAccountTable();
            if (accountTable == null) continue;
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("isLeaf");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", accountNumbers, CompareType.INCLUDE));
            view.setFilter(filter);
            AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
            for (AccountViewInfo account : coll) {
                companyAccounts.put(account.getNumber(), account);
            }
        }
        final HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("periodFrom", startPeriod.getNumber());
        params.put("periodTo", endPeriod.getNumber());
        if (this.rbRebuild.isSelected()) {
            params.put("action", "rebuild");
        } else if (this.rbDelete.isSelected()) {
            params.put("action", "delete");
        } else {
            params.put("action", "subuild");
        }
        final boolean isTry = !this.cbEffect.isSelected();
        params.put("isTry", String.valueOf(isTry));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AsstAccountChangeVchMgrUI.this.btnOk.putClientProperty((Object)"canStop", (Object)true);
                    AsstAccountChangeVchMgrUI.this.btnOk.setText(EASResource.getString((String)AsstAccountChangeVchMgrUI.RES, (String)"Stop"));
                    AsstAccountChangeVchMgrUI.this.enableComponent(false);
                    for (int i = 0; i < companys.length; ++i) {
                        CompanyOrgUnitInfo c = (CompanyOrgUnitInfo)companys[i];
                        AsstAccountChangeVchMgrUI.this.showInfo(MessageFormat.format(AsstAccountChangeVchMgrUI.this.getString("Process_Org"), c.getNumber()) + " ...", Color.BLACK);
                        params.put("companyId", c.getId().toString());
                        Map companyAccounts = (Map)companyAccountss.get(c.getId().toString());
                        for (int j = 0; j < accounts.size(); ++j) {
                            try {
                                Map voucher;
                                List vouchers;
                                AccountViewInfo account = (AccountViewInfo)companyAccounts.get(accounts.get(j));
                                if (account == null) continue;
                                if (!account.isIsLeaf()) {
                                    AsstAccountChangeVchMgrUI.this.showInfo("    " + MessageFormat.format(AsstAccountChangeVchMgrUI.this.getString("Account_NotDetail"), account.getNumber()), Color.RED);
                                    continue;
                                }
                                AsstAccountChangeVchMgrUI.this.showInfo("    " + MessageFormat.format(AsstAccountChangeVchMgrUI.this.getString("Account"), account.getNumber()) + " ...", Color.BLACK);
                                params.put("accountId", account.getId().toString());
                                Map result = GLAsstAccountChangeFacadeFactory.getRemoteInstance().transfer(params);
                                String error = (String)result.get("error");
                                if (error != null) {
                                    AsstAccountChangeVchMgrUI.this.showInfo("    " + error, Color.RED);
                                    continue;
                                }
                                if (AsstAccountChangeVchMgrUI.this.rbDelete.isSelected() || AsstAccountChangeVchMgrUI.this.rbRebuild.isSelected()) {
                                    vouchers = (List)result.get("existVouchers");
                                    if (vouchers != null && vouchers.size() > 0) {
                                        if (isTry) {
                                            AsstAccountChangeVchMgrUI.this.showInfo("        " + AsstAccountChangeVchMgrUI.this.getString("Exist_CarryVoucher"), Color.BLACK);
                                        } else {
                                            AsstAccountChangeVchMgrUI.this.showInfo("        " + AsstAccountChangeVchMgrUI.this.getString("Delete_CarryVoucher"), Color.BLACK);
                                        }
                                        for (Object item : vouchers) {
                                            voucher = (Map)item;
                                            AsstAccountChangeVchMgrUI.this.showInfo("            " + AsstAccountChangeVchMgrUI.this.getString("Period") + voucher.get("period") + " " + AsstAccountChangeVchMgrUI.this.getString("Number") + voucher.get("number"), Color.BLACK);
                                        }
                                    } else {
                                        AsstAccountChangeVchMgrUI.this.showInfo("        " + AsstAccountChangeVchMgrUI.this.getString("No_CarryVoucher"), Color.BLACK);
                                    }
                                }
                                if (AsstAccountChangeVchMgrUI.this.rbSubuild.isSelected() || AsstAccountChangeVchMgrUI.this.rbRebuild.isSelected()) {
                                    vouchers = (List)result.get("buildVouchers");
                                    if (isTry) {
                                        if (vouchers != null && vouchers.size() > 0) {
                                            Map voucher2 = (Map)vouchers.get(0);
                                            AsstAccountChangeVchMgrUI.this.showInfo("        " + AsstAccountChangeVchMgrUI.this.getString("Period") + voucher2.get("period") + ", " + AsstAccountChangeVchMgrUI.this.getString("Wait_CarryAmount"), Color.BLACK);
                                            List entries = (List)voucher2.get("entries");
                                            block8: for (Map entry : entries) {
                                                AsstAccountChangeVchMgrUI.this.showInfo("            " + AsstAccountChangeVchMgrUI.this.getString("Currency") + entry.get("currency") + ", " + AsstAccountChangeVchMgrUI.this.getString("Amount") + entry.get("amount"), Color.BLACK);
                                                List records = (List)entry.get("records");
                                                if (records == null || records.size() <= 0) continue;
                                                int count = 0;
                                                Iterator rit = records.iterator();
                                                while (rit.hasNext()) {
                                                    if (++count >= 11) {
                                                        AsstAccountChangeVchMgrUI.this.showInfo("                ...", Color.BLACK);
                                                        continue block8;
                                                    }
                                                    Map record = (Map)rit.next();
                                                    AsstAccountChangeVchMgrUI.this.showInfo("                " + AsstAccountChangeVchMgrUI.this.getString("AsstAccount") + record.get("assist") + ", " + AsstAccountChangeVchMgrUI.this.getString("Amount") + record.get("amount"), Color.BLACK);
                                                }
                                            }
                                        } else {
                                            AsstAccountChangeVchMgrUI.this.showInfo("    " + AsstAccountChangeVchMgrUI.this.getString("No_Wait_CarryAmount"), Color.BLACK);
                                        }
                                    } else if (vouchers != null && vouchers.size() > 0) {
                                        AsstAccountChangeVchMgrUI.this.showInfo("        " + AsstAccountChangeVchMgrUI.this.getString("Generate_CarryVoucher"), Color.BLACK);
                                        for (Object item : vouchers) {
                                            voucher = (Map)item;
                                            AsstAccountChangeVchMgrUI.this.showInfo("            " + AsstAccountChangeVchMgrUI.this.getString("Period") + voucher.get("period") + " " + AsstAccountChangeVchMgrUI.this.getString("Number") + voucher.get("number"), Color.BLACK);
                                        }
                                    } else {
                                        AsstAccountChangeVchMgrUI.this.showInfo("            " + AsstAccountChangeVchMgrUI.this.getString("No_Wait_CarryAmount"), Color.BLACK);
                                    }
                                }
                            }
                            catch (Exception e) {
                                AsstAccountChangeVchMgrUI.this.showInfo("    " + GlUtils.printStackTrace(e), Color.RED);
                            }
                            if (AsstAccountChangeVchMgrUI.this.stop) break;
                        }
                        if (AsstAccountChangeVchMgrUI.this.stop) break;
                    }
                    AsstAccountChangeVchMgrUI.this.showInfo(AsstAccountChangeVchMgrUI.this.getString("ProcessFinish") + "\n", Color.BLACK);
                }
                finally {
                    AsstAccountChangeVchMgrUI.this.btnOk.setText(EASResource.getString((String)AsstAccountChangeVchMgrUI.RES, (String)"Execute"));
                    AsstAccountChangeVchMgrUI.this.enableComponent(true);
                    AsstAccountChangeVchMgrUI.this.actionComfirm.setEnabled(true);
                    AsstAccountChangeVchMgrUI.this.btnOk.setEnabled(true);
                    AsstAccountChangeVchMgrUI.this.btnOk.putClientProperty((Object)"canStop", null);
                    AsstAccountChangeVchMgrUI.this.stop = false;
                }
            }
        }).start();
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtConsole.setText("");
    }

    private void showInfo(final String info, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = AsstAccountChangeVchMgrUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), info + "\n", attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                AsstAccountChangeVchMgrUI.this.txtConsole.setSelectionStart(doc.getLength());
            }
        });
    }

    protected String getString(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }
}

