/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountF7Filter;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.AutoAssistantHGUpdateFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractAsstActUniteUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class AsstActUniteUI
extends AbstractAsstActUniteUI {
    private static final Logger logger = CoreUIObject.getLogger(AsstActUniteUI.class);
    protected static final String RESOURCE = "com.kingdee.eas.fi.gl.AsstActUniteResource";
    private boolean stop = false;
    private static final Color WARN_COLOR = new Color(246, 168, 46);
    private SimpleAttributeSet defAttr = new SimpleAttributeSet();
    private SimpleAttributeSet warnAttr = new SimpleAttributeSet();
    private SimpleAttributeSet errorAttr = new SimpleAttributeSet();
    private SimpleAttributeSet exeAttr = new SimpleAttributeSet();
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    private Map<String, AsstActTypeInfo> asstActTypes = new HashMap<String, AsstActTypeInfo>();

    public AsstActUniteUI() throws Exception {
        StyleConstants.setForeground(this.warnAttr, WARN_COLOR);
        StyleConstants.setForeground(this.errorAttr, Color.RED);
        StyleConstants.setForeground(this.exeAttr, new Color(0, 130, 0));
    }

    public void onLoad() throws Exception {
        OrgUnitInfo ou = SysContext.getSysContext().getCurrentOrgUnit();
        if (ou != null) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(ou.getId()), (String)"gl_tool");
        } else {
            SysUtil.abort();
        }
        super.onLoad();
        this.initCommon();
        this.init();
    }

    private void initCommon() throws Exception {
        this.spConsole.setBorder(BorderFactory.createLineBorder(new Color(145, 148, 140), 1));
    }

    private void init() throws Exception {
        this.prmtAsstActType.setEditable(true);
        this.prmtAsstActType.setEditFormat("$number$");
        this.prmtAsstActType.setCommitFormat("$number$;$name$");
        this.prmtAsstActType.setDisplayFormat("$name$");
        this.prmtAsstActType.setHasCUDefaultFilter(false);
        AuxAccountF7Filter.setFilter((KDBizPromptBox)this.prmtAsstAccount);
        this.prmtAsstAccount.setEnabledMultiSelection(true);
        this.prmtAsstAccount.setValue(null);
        this.cbDetailLog.setSelected(true);
        this.cbNew.setSelected(true);
    }

    private void enableComponent(boolean enable) {
        this.prmtAsstActType.setEnabled(enable);
        this.prmtAsstAccount.setEnabled(enable);
        this.tfTargetAsstAct.setEnabled(enable);
        this.tfSourceAsstAct.setEnabled(enable);
        this.cbEffect.setEnabled(enable);
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtConsole.setText("");
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        int r;
        Object sourceAsstAct;
        Object targetAsstAct;
        CustomerCollection coll;
        if (this.btnOk.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.actionComfirm.setEnabled(false);
            this.btnOk.setEnabled(false);
            return;
        }
        Object object = this.prmtAsstActType.getValue();
        if (object == null) {
            this.showError(this.getString("AsstActType_SelectPlease"));
            return;
        }
        AsstActTypeInfo type = (AsstActTypeInfo)object;
        if (!"customer".equals((type = this.getAsstActType(type.getId().toString())).getAsstHGAttribute()) && !"provider".equals(type.getAsstHGAttribute())) {
            this.showError(this.getString("OnlySupport_CustomerProvider"));
            return;
        }
        HashSet<String> strTargetAsstActs = new HashSet<String>();
        String strTargetAsstAct = this.tfTargetAsstAct.getText();
        if (strTargetAsstAct == null || strTargetAsstAct.trim().length() == 0) {
            this.showError(this.getString("TargetAsstAct_SetPlease"));
            return;
        }
        strTargetAsstAct = strTargetAsstAct.trim();
        for (String str : strTargetAsstAct.split(";")) {
            if (str.trim().length() <= 0) continue;
            strTargetAsstActs.add(str.trim());
        }
        if (strTargetAsstActs.size() == 0) {
            this.showError(this.getString("TargetAsstAct_SetPlease"));
            return;
        }
        HashSet<String> strSourceAsstActs = new HashSet<String>();
        String strSourceAsstAct = this.tfSourceAsstAct.getText();
        if (strSourceAsstAct != null && strSourceAsstAct.trim().length() > 0) {
            strSourceAsstAct = strSourceAsstAct.trim();
            for (String str : strSourceAsstAct.split(";")) {
                if (str.trim().length() <= 0) continue;
                strSourceAsstActs.add(str.trim());
            }
            for (String str : strTargetAsstActs) {
                if (!strSourceAsstActs.contains(str)) continue;
                this.showError(this.getString("SourceAsstAct_ExistTarget"));
                return;
            }
        }
        if (strTargetAsstActs.size() > 1 && strSourceAsstActs.size() > 0) {
            this.showError(this.getString("MutilTarget_CannotSource"));
            return;
        }
        ArrayList targetAsstActs = new ArrayList();
        ArrayList sourceAsstActs = new ArrayList();
        HashSet<String> strAllAsstActs = new HashSet<String>();
        strAllAsstActs.addAll(strTargetAsstActs);
        strAllAsstActs.addAll(strSourceAsstActs);
        EntityViewInfo asstActView = new EntityViewInfo();
        SelectorItemCollection asstActSelector = new SelectorItemCollection();
        asstActSelector.add("id");
        asstActSelector.add("number");
        asstActSelector.add("name");
        asstActView.setSelector(asstActSelector);
        FilterInfo asstActFilter = new FilterInfo();
        asstActFilter.getFilterItems().add(new FilterItemInfo("number", strAllAsstActs, CompareType.INCLUDE));
        asstActView.setFilter(asstActFilter);
        if ("customer".equals(type.getAsstHGAttribute())) {
            coll = CustomerFactory.getRemoteInstance().getCustomerCollection(asstActView);
            HashMap<String, CustomerInfo> cs = new HashMap<String, CustomerInfo>();
            for (CustomerInfo c : coll) {
                if (cs.containsKey(c.getNumber())) {
                    this.showError(this.getString("AsstActNumber_Repeat"));
                    return;
                }
                cs.put(c.getNumber(), c);
            }
            for (String str : strTargetAsstActs) {
                targetAsstAct = cs.get(str);
                if (targetAsstAct == null) {
                    this.showError(MessageFormat.format(this.getString("TargetAsstAct_NotExist"), str));
                    return;
                }
                targetAsstActs.add(targetAsstAct);
            }
            for (String str : strSourceAsstActs) {
                sourceAsstAct = cs.get(str);
                if (sourceAsstAct == null) {
                    this.showError(MessageFormat.format(this.getString("SourceAsstAct_NotExist"), str));
                    return;
                }
                sourceAsstActs.add(sourceAsstAct);
            }
        } else {
            coll = SupplierFactory.getRemoteInstance().getSupplierCollection(asstActView);
            HashMap<String, SupplierInfo> ss = new HashMap<String, SupplierInfo>();
            for (SupplierInfo s : coll) {
                if (ss.containsKey(s.getNumber())) {
                    this.showError(this.getString("AsstActNumber_Repeat"));
                    return;
                }
                ss.put(s.getNumber(), s);
            }
            for (String str : strTargetAsstActs) {
                targetAsstAct = ss.get(str);
                if (targetAsstAct == null) {
                    this.showError(MessageFormat.format(this.getString("TargetAsstAct_NotExist"), str));
                    return;
                }
                targetAsstActs.add(targetAsstAct);
            }
            for (String str : strSourceAsstActs) {
                sourceAsstAct = ss.get(str);
                if (sourceAsstAct == null) {
                    this.showError(MessageFormat.format(this.getString("SourceAsstAct_NotExist"), str));
                    return;
                }
                sourceAsstActs.add(sourceAsstAct);
            }
        }
        ArrayList<AsstAccountInfo> aas = new ArrayList<AsstAccountInfo>();
        Object[] objects = (Object[])this.prmtAsstAccount.getValue();
        if (objects != null) {
            for (Object o : objects) {
                AsstAccountInfo aa = (AsstAccountInfo)o;
                if (aa == null) continue;
                AsstActTypeCollection types = this.getAsstActTypes(aa.getId().toString());
                boolean found = false;
                for (AsstActTypeInfo t : types) {
                    if (!type.getAsstHGAttribute().equals(t.getAsstHGAttribute())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.showError(MessageFormat.format(this.getString("AsstAccount_NoAsstActType"), aa.getName(), type.getName()));
                    return;
                }
                aas.add(aa);
            }
        } else {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            view.setSelector(sic);
            AsstAccountCollection coll2 = AsstAccountFactory.getRemoteInstance().getAsstAccountCollection(view);
            for (AsstAccountInfo aa : coll2) {
                AsstActTypeCollection types = this.getAsstActTypes(aa.getId().toString());
                boolean found = false;
                for (AsstActTypeInfo t : types) {
                    if (!type.getAsstHGAttribute().equals(t.getAsstHGAttribute())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                aas.add(aa);
            }
        }
        if (aas.size() == 0) {
            this.showInfo(this.getString("NoAsstAccount_Process"));
            return;
        }
        if (this.cbEffect.isSelected() && (r = MsgBox.showConfirm2((String)this.getString("BigOperate_Continue"))) != 0) {
            return;
        }
        this.btnOk.putClientProperty((Object)"canStop", (Object)true);
        this.btnOk.setText(this.getString("Stop"));
        this.enableComponent(false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("asstActType", type);
        params.put("targetAsstActs", targetAsstActs);
        params.put("sourceAsstActs", sourceAsstActs);
        params.put("asstAccounts", aas);
        params.put("isDetail", this.cbDetailLog.isSelected());
        params.put("isNew", this.cbNew.isSelected());
        params.put("isEffect", this.cbEffect.isSelected());
        new Worker(params).start();
    }

    private AsstActTypeCollection getAsstActTypes(String asstAccountId) throws BOSException {
        if (this.asstActTypess.containsKey(asstAccountId)) {
            return this.asstActTypess.get(asstAccountId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        this.asstActTypess.put(asstAccountId, asstActTypes);
        return asstActTypes;
    }

    private AsstActTypeInfo getAsstActType(String id) throws BOSException, EASBizException {
        if (this.asstActTypes.containsKey(id)) {
            return this.asstActTypes.get(id);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("asstHGAttribute");
        selector.add("mappingFieldName");
        selector.add("defaultQueryName");
        selector.add("isForCompany");
        selector.add("defaultF7UI");
        selector.add("glAsstActTypeGrp.id");
        selector.add("isMultilevel");
        AsstActTypeInfo info = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(id), selector);
        this.asstActTypes.put(id, info);
        return info;
    }

    private void showInfo(String message) {
        this.showDetail(message, this.defAttr);
    }

    private void showWarn(String message) {
        this.showDetail(message, this.warnAttr);
    }

    private void showError(String message) {
        this.showDetail(message, this.errorAttr);
    }

    private void showExe(String message) {
        this.showDetail(message, this.exeAttr);
    }

    private void showDetail(final String message, final SimpleAttributeSet set) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document doc = AsstActUniteUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), message + "\n", set);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    protected String getString(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }

    public static void showMe(Object owner) {
        UIContext uiContext = new UIContext(owner);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.AsstActUniteUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    class Worker
    extends Thread {
        private Map<String, Object> srcParams;

        public Worker(Map<String, Object> params) {
            this.srcParams = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AsstActTypeInfo asstActType = (AsstActTypeInfo)this.srcParams.get("asstActType");
            List targetAsstActs = (List)this.srcParams.get("targetAsstActs");
            List sourceAsstActs = (List)this.srcParams.get("sourceAsstActs");
            List aas = (List)this.srcParams.get("asstAccounts");
            boolean isDetail = (Boolean)this.srcParams.get("isDetail");
            boolean isNew = (Boolean)this.srcParams.get("isNew");
            boolean isEffect = (Boolean)this.srcParams.get("isEffect");
            try {
                for (AsstAccountInfo aa : aas) {
                    if (AsstActUniteUI.this.stop) break;
                    AsstActUniteUI.this.showInfo(MessageFormat.format(AsstActUniteUI.this.getString("Processing_AsstAccount"), aa.getName()) + " ...");
                    for (Object targetAsstAct : targetAsstActs) {
                        if (AsstActUniteUI.this.stop) break;
                        AsstActUniteUI.this.showInfo("\u3000\u3000" + MessageFormat.format(AsstActUniteUI.this.getString("Processing_AsstAct"), targetAsstAct) + " ...");
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("asstActType", asstActType);
                        params.put("targetAsstAct", targetAsstAct);
                        params.put("sourceAsstActs", sourceAsstActs);
                        params.put("asstAccount", aa);
                        params.put("isDetail", isDetail);
                        params.put("isNew", isNew);
                        params.put("isEffect", isEffect);
                        Object result = AutoAssistantHGUpdateFacadeFactory.getRemoteInstance().unite(params);
                        if (result == null || !(result instanceof Map)) continue;
                        Map m = (Map)result;
                        String msg = (String)m.get("msg");
                        if (msg != null) {
                            AsstActUniteUI.this.showInfo(msg);
                        }
                        List groups = (List)m.get("groups");
                        for (Map group : groups) {
                            String targetId = (String)group.get("targetId");
                            List sourceIds = (List)group.get("sourceIds");
                            AsstActUniteUI.this.showInfo("\u3000\u3000\u3000\u3000" + AsstActUniteUI.this.getString("Group") + group.get("key") + "\u3000\u3000action\uff1a" + group.get("action") + "\u3000\u3000" + AsstActUniteUI.this.getString("Count") + sourceIds.size());
                            if (isDetail) {
                                AsstActUniteUI.this.showInfo("\u3000\u3000\u3000\u3000\u3000\u3000" + AsstActUniteUI.this.getString("Target_HG") + targetId + "(" + group.get("targetName") + ")");
                            } else {
                                AsstActUniteUI.this.showInfo("\u3000\u3000\u3000\u3000\u3000\u3000" + AsstActUniteUI.this.getString("Target_HG") + targetId);
                            }
                            StringBuffer srcMsg = new StringBuffer();
                            srcMsg.append("\u3000\u3000\u3000\u3000\u3000\u3000" + AsstActUniteUI.this.getString("Source_HG"));
                            if (isDetail) {
                                List sourceNames = (List)group.get("sourceNames");
                                for (int i = 0; i < sourceIds.size(); ++i) {
                                    if (i > 0) {
                                        srcMsg.append(", ");
                                    }
                                    srcMsg.append(sourceIds.get(i) + "(" + sourceNames.get(i) + ")");
                                }
                            } else {
                                for (int i = 0; i < sourceIds.size(); ++i) {
                                    if (i > 0) {
                                        srcMsg.append(", ");
                                    }
                                    srcMsg.append(sourceIds.get(i));
                                }
                            }
                            AsstActUniteUI.this.showInfo(srcMsg.toString());
                        }
                    }
                    AsstActUniteUI.this.showInfo(MessageFormat.format(AsstActUniteUI.this.getString("AsstAccount_ProcessFinish"), aa.getName()) + "\n");
                }
                AsstActUniteUI.this.showInfo(AsstActUniteUI.this.getString("ProcessFinish") + "\n");
            }
            catch (Exception e) {
                AsstActUniteUI.this.handUIException(e);
            }
            finally {
                AsstActUniteUI.this.btnOk.setText(AsstActUniteUI.this.getString("Execute"));
                AsstActUniteUI.this.enableComponent(true);
                AsstActUniteUI.this.actionComfirm.setEnabled(true);
                AsstActUniteUI.this.btnOk.setEnabled(true);
                AsstActUniteUI.this.btnOk.putClientProperty((Object)"canStop", null);
                AsstActUniteUI.this.stop = false;
            }
        }
    }
}

