/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeReferenceCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeReferenceFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeReference;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.client.AbstractAsstSelectUI;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class AsstSelectUI
extends AbstractAsstSelectUI {
    private static final long serialVersionUID = -4626982891320433555L;
    private static final Logger logger = CoreUIObject.getLogger(AsstSelectUI.class);
    private Object data;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.loadData();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    AsstSelectUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    AsstSelectUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.kDBtnOK_actionPerformed(null);
        }
    }

    @Override
    protected void kDBtnCal_actionPerformed(ActionEvent e) throws Exception {
        super.kDBtnCal_actionPerformed(e);
        this.uiWindow.close();
    }

    @Override
    protected void kDBtnOK_actionPerformed(ActionEvent e) throws Exception {
        super.kDBtnOK_actionPerformed(e);
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            this.data = row == null ? null : (AsstActTypeInfo)row.getUserObject();
        }
        this.uiWindow.close();
    }

    public Object getData() {
        return this.data;
    }

    public void loadData() throws Exception {
        this.tblMain.removeRows();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("isSystemAsstActItem");
        evi.getSelector().add("realDataObjAlias");
        evi.getSelector().add("CU.name");
        evi.getSelector().add("description");
        evi.getSelector().add("isQty");
        evi.getSelector().add("measureUnit.id");
        evi.getSelector().add("measureUnitGroup.id");
        evi.getSorter().add(new SorterItemInfo("IsSystemAsstActItem"));
        evi.getSorter().add(new SorterItemInfo("IsSelfAsstActaiatem"));
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuid = CU.getId().toString();
        FilterInfo filter = new FilterInfo();
        FilterInfo oldfilter1 = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cuid, (String)CU.getLongNumber());
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("glAsstActTypeGrp.id", null));
        fic.add(new FilterItemInfo("glAsstActTypeGrp.id", null, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("glAsstActTypeGrp.shareTactic", (Object)String.valueOf(3), CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("glAsstActTypeGrp.id", null, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("glAsstActTypeGrp.shareTactic", (Object)String.valueOf(3)));
        fic.add(new FilterItemInfo("CU.id", (Object)cuid));
        filter.setMaskString("#0 or #1 and #2 or #3 and #4 and #5");
        if (oldfilter1 != null && oldfilter1.getFilterItems().size() > 0) {
            filter.mergeFilter(oldfilter1, "and");
        }
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        AsstActTypeCollection auxActTypes = asstActType.getAsstActTypeCollection(evi);
        if (this.getParentAssign() != null && this.getParentAssign().size() > 0) {
            auxActTypes.addObjectCollection((IObjectCollection)this.getParentAssign());
        }
        if (this.getCurrentAssign() != null && this.getCurrentAssign().size() > 0) {
            auxActTypes.addObjectCollection((IObjectCollection)this.getCurrentAssign());
        }
        int count = auxActTypes.size();
        for (int i = 0; i < count; ++i) {
            AsstActTypeInfo info = auxActTypes.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)String.valueOf(info.getName()));
            row.setUserObject((Object)info);
        }
    }

    AsstActTypeCollection getParentAssign() {
        AsstActTypeCollection aATCParent = new AsstActTypeCollection();
        try {
            IAsstActTypeReference iAsstActTypeReference = AsstActTypeReferenceFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("assignCU.id");
            evi.getSelector().add("assignCU.longnumber");
            evi.getSelector().add("asstActType.id");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignCU.level", (Object)new Integer(SysContext.getSysContext().getCurrentCtrlUnit().getLevel()), CompareType.LESS));
            evi.setFilter(filterInfo);
            AsstActTypeReferenceCollection aATRC = iAsstActTypeReference.getAsstActTypeReferenceCollection(evi);
            AsstActTypeReferenceCollection aATRCParent = new AsstActTypeReferenceCollection();
            if (aATRC.size() > 0) {
                for (int i = 0; i < aATRC.size(); ++i) {
                    if (SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber().indexOf(aATRC.get(i).getAssignCU().getLongNumber()) != 0) continue;
                    aATRCParent.addObject((IObjectValue)aATRC.get(i));
                }
            }
            if (aATRCParent.size() > 0) {
                IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
                EntityViewInfo evitemp = new EntityViewInfo();
                evitemp.getSelector().add("id");
                evitemp.getSelector().add("number");
                evitemp.getSelector().add("name");
                evitemp.getSelector().add("isSystemAsstActItem");
                evitemp.getSelector().add("realDataObjAlias");
                evitemp.getSelector().add("CU.name");
                evitemp.getSelector().add("description");
                evitemp.getSelector().add("cu.longnumber");
                evitemp.getSelector().add("isQty");
                evitemp.getSelector().add("measureUnit.id");
                evitemp.getSelector().add("measureUnitGroup.id");
                FilterInfo filterTemp = new FilterInfo();
                for (int i = 0; i < aATRCParent.size(); ++i) {
                    AsstActTypeCollection aATCTemp = new AsstActTypeCollection();
                    FilterItemInfo filterItem = new FilterItemInfo("id", (Object)aATRCParent.get(i).getAsstActType().getId().toString());
                    filterTemp.getFilterItems().add(filterItem);
                    evitemp.setFilter(filterTemp);
                    aATCTemp = iAsstActType.getAsstActTypeCollection(evitemp);
                    aATCParent.addObjectCollection((IObjectCollection)aATCTemp);
                    filterTemp.getFilterItems().remove(filterItem);
                }
            }
            if (aATCParent.size() > 0) {
                int i;
                AsstActTypeCollection aATCParentTemp = new AsstActTypeCollection();
                for (i = 0; i < aATCParent.size(); ++i) {
                    if (SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber().toString().indexOf(aATCParent.get(i).getCU().getLongNumber().toString()) != 0) continue;
                    aATCParentTemp.addObject((IObjectValue)aATCParent.get(i));
                }
                if (aATCParentTemp.size() > 0) {
                    for (i = 0; i < aATCParentTemp.size(); ++i) {
                        aATCParent.removeObject((Object)aATCParentTemp.get(i).getId());
                    }
                }
            }
            return aATCParent;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    AsstActTypeCollection getCurrentAssign() {
        try {
            IAsstActTypeReference iAsstActTypeReference = AsstActTypeReferenceFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignCU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString()));
            evi.setFilter(filterInfo);
            AsstActTypeReferenceCollection aATRC = iAsstActTypeReference.getAsstActTypeReferenceCollection(evi);
            AsstActTypeCollection aATC = new AsstActTypeCollection();
            if (aATRC.size() > 0) {
                IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
                EntityViewInfo evitemp = new EntityViewInfo();
                evitemp.getSelector().add("id");
                evitemp.getSelector().add("number");
                evitemp.getSelector().add("name");
                evitemp.getSelector().add("isSystemAsstActItem");
                evitemp.getSelector().add("realDataObjAlias");
                evitemp.getSelector().add("CU.name");
                evitemp.getSelector().add("description");
                evitemp.getSelector().add("isQty");
                evitemp.getSelector().add("measureUnit.id");
                evitemp.getSelector().add("measureUnitGroup.id");
                FilterInfo filterTemp = new FilterInfo();
                for (int i = 0; i < aATRC.size(); ++i) {
                    AsstActTypeCollection aATCTemp = new AsstActTypeCollection();
                    FilterItemInfo filterItem = new FilterItemInfo("id", (Object)aATRC.get(i).getAsstActType().getId().toString());
                    filterTemp.getFilterItems().add(filterItem);
                    evitemp.setFilter(filterTemp);
                    aATCTemp = iAsstActType.getAsstActTypeCollection(evitemp);
                    aATC.addObjectCollection((IObjectCollection)aATCTemp);
                    filterTemp.getFilterItems().remove(filterItem);
                }
            }
            return aATC;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }
}

