/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractAuditCancelBackFilterPanel;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AuditCancelBackFilterPanel
extends AbstractAuditCancelBackFilterPanel {
    private PeriodInfo currentPeriod = null;
    private CompanyOrgUnitInfo curCompany;
    private VoucherInfo voucherInfo;
    private Map params = new HashMap();

    public AuditCancelBackFilterPanel(CompanyOrgUnitInfo company) throws Exception {
        SpinnerNumberModel model = (SpinnerNumberModel)this.spnPeriod.getModel();
        model.setMaximum(new Integer(12));
        model.setMinimum(new Integer(1));
        this.getUIContext().put("KEY_COMPANY", company);
        this.curCompany = company;
        final String companyId = company.getId().toString();
        this.bizVoucherNumber.setCurrentMainBizOrgUnit((OrgUnitInfo)company, OrgType.Company);
        this.bizVoucherNumber.setDefaultF7UIName("com.kingdee.eas.fi.gl.client.AuditCancelBackFilterVoucherUI");
        this.bizVoucherNumber.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("company.id", companyId);
                params.put("bizStatus", new Integer(5));
                params.put("isAC", new Integer(1));
                if (AuditCancelBackFilterPanel.this.spnYear.getIntegerVlaue() != null) {
                    params.put("period.periodYear", AuditCancelBackFilterPanel.this.spnYear.getIntegerVlaue());
                }
                if (AuditCancelBackFilterPanel.this.spnPeriod.getIntegerVlaue() != null) {
                    params.put("period.periodNumber", AuditCancelBackFilterPanel.this.spnPeriod.getIntegerVlaue());
                }
                if (AuditCancelBackFilterPanel.this.comboCurrency.getSelectedItem() != null) {
                    params.put("entries.currency.id", ((CurrencyInfo)AuditCancelBackFilterPanel.this.comboCurrency.getSelectedItem()).getId().toString());
                }
                if (AuditCancelBackFilterPanel.this.bizVoucherType.getValue() != null) {
                    params.put("voucherType.id", ((VoucherTypeInfo)AuditCancelBackFilterPanel.this.bizVoucherType.getValue()).getId().toString());
                }
                if (AuditCancelBackFilterPanel.this.dpBusiDate.getValue() != null) {
                    params.put("bizDate", AuditCancelBackFilterPanel.this.dpBusiDate.getValue());
                }
                if (AuditCancelBackFilterPanel.this.pbAccount.getValue() != null) {
                    params.put("account.id", AuditCancelBackFilterPanel.this.pbAccount.getValue());
                }
                try {
                    AuditCancelBackFilterPanel.this.bizVoucherNumber.setEntityViewInfo(AcctCussentHistoryFacadeFactory.getRemoteInstance().getVoucherIdEntityView(params));
                    AuditCancelBackFilterPanel.this.bizVoucherNumber.getQueryAgent().resetRuntimeEntityView();
                }
                catch (BOSException e1) {
                    AuditCancelBackFilterPanel.this.handUIException(e1);
                    SysUtil.abort();
                }
            }
        });
        this.initUIByParam();
        this.spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int year = AuditCancelBackFilterPanel.this.spnYear.getIntegerVlaue();
                int numberEnd = AuditCancelBackFilterPanel.this.spnPeriod.getIntegerVlaue();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
                CompanyOrgUnitInfo company = AuditCancelBackFilterPanel.this.curCompany;
                RptClientUtil.periodChanged((IUIObject)AuditCancelBackFilterPanel.this, company, filter, year, numberEnd, AuditCancelBackFilterPanel.this.pbAccount, AuditCancelBackFilterPanel.this.pbAccount);
            }
        });
    }

    public void initUIByParam() throws BOSException, EASBizException {
        if (this.params.get("KEY_PERIOD") != null) {
            if (this.params.get("KEY_PERIOD_YEAR") != null) {
                this.spnYear.setValue(this.params.get("KEY_PERIOD_YEAR"));
            }
            if (this.params.get("KEY_PERIOD_NUMBER") != null) {
                this.spnPeriod.setValue(this.params.get("KEY_PERIOD_NUMBER"));
            }
            this.pbAccount.setValue(this.params.get("KEY_PERIOD"));
            this.dpBusiDate.setValue(this.params.get("KEY_BIZDATE"));
            this.comboCurrency.getModel().setSelectedItem(this.params.get("KEY_CURRENCY"));
            this.bizVoucherType.setValue(this.params.get("KEY_VOUCHERTYPE"));
            VoucherInfo voucherInfo = (VoucherInfo)this.params.get("KEY_VOUCHERNUMBER");
            if (voucherInfo != null) {
                this.bizVoucherNumber.setValue((Object)voucherInfo);
            }
        } else {
            this.currentPeriod = PeriodUtils.getPeriodInfo((CompanyOrgUnitInfo)this.getCurrentCompany());
            this.spnYear.setValue((Object)new Integer(this.currentPeriod.getPeriodYear()));
            this.spnPeriod.setValue((Object)new Integer(this.currentPeriod.getPeriodNumber()));
            this.dpBusiDate.setValue(null);
            this.bizVoucherType.setValue(null);
            this.bizVoucherNumber.setValue(null);
            this.pbAccount.setValue(null);
        }
    }

    private CompanyOrgUnitInfo getCurrentCompany() {
        if (this.getUIContext().get("KEY_COMPANY") != null) {
            return (CompanyOrgUnitInfo)this.getUIContext().get("KEY_COMPANY");
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    public void initData() throws Exception {
        this.curCompany = this.getCurrentCompany();
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        ICurrency curCtrl = CurrencyFactory.getRemoteInstance();
        CurrencyCollection col = curCtrl.getCurrencyCollection(true);
        CurrencyInfo local = null;
        for (int i = 0; i < col.size(); ++i) {
            CurrencyInfo temp = col.get(i);
            this.comboCurrency.addItem((Object)col.get(i));
            if (!temp.getId().toString().equals(this.curCompany.getBaseCurrency().getId().toString())) continue;
            local = temp;
        }
        if (local != null) {
            this.comboCurrency.setSelectedItem(local);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.curCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
        this.pbAccount.setEntityViewInfo(view);
        this.pbAccount.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, this.curCompany, filter, false, true));
    }

    public boolean verify() {
        if (this.bizVoucherType.getValue() == null) {
            this.bizVoucherType.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.VoucherTypeIsNull"));
            return false;
        }
        if (this.bizVoucherNumber.getValue() == null) {
            this.bizVoucherNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.VoucherNumberIsNull"));
            return false;
        }
        try {
            this.voucherInfo = (VoucherInfo)AcctCussentHistoryFacadeFactory.getRemoteInstance().getUnVerifyVoucher(this.getResult());
            if (this.voucherInfo == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.AcctHistoryNotExist"));
                return false;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            return false;
        }
        return true;
    }

    public HashMap getResult() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("companyId", this.getCurrentCompany().getId().toString());
        result.put(ParamKey.spnYear, this.spnYear.getValue());
        result.put(ParamKey.spnPeriod, this.spnPeriod.getValue());
        result.put(ParamKey.currency, this.comboCurrency.getSelectedItem());
        result.put(ParamKey.bizDate, this.dpBusiDate.getValue());
        result.put(ParamKey.account, this.pbAccount.getValue());
        result.put(ParamKey.voucherType, this.bizVoucherType.getValue());
        if (this.bizVoucherNumber != null && this.bizVoucherNumber.getValue() != null) {
            VoucherInfo voucherInfo = (VoucherInfo)this.bizVoucherNumber.getValue();
            result.put(ParamKey.voucherNumber, voucherInfo.getNumber());
            result.put(ParamKey.voucherInfo, voucherInfo);
        }
        return result;
    }

    public Object getParam() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ParamKey.spnYear, this.spnYear.getValue());
        result.put(ParamKey.spnPeriod, this.spnPeriod.getValue());
        result.put(ParamKey.currency, this.comboCurrency.getSelectedItem());
        result.put(ParamKey.bizDate, this.dpBusiDate.getValue());
        result.put(ParamKey.account, this.pbAccount.getValue());
        if (this.bizVoucherNumber.getValue() != null) {
            result.put(ParamKey.voucherNumber, ((VoucherInfo)this.bizVoucherNumber.getValue()).getNumber());
        }
        result.put(ParamKey.voucherType, this.bizVoucherType.getValue());
        return result;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        if (cp == null) {
            return;
        }
    }

    public void setParam(Object param) {
        Map result = (Map)param;
        String currencyId = ((CurrencyInfo)result.get(ParamKey.currency)).getId().toString();
        for (int i = 0; i < this.comboCurrency.getItemCount(); ++i) {
            CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getItemAt(i);
            if (!info.getId().toString().equals(currencyId)) continue;
            this.comboCurrency.setSelectedIndex(i);
            break;
        }
        Date beginDate = (Date)result.get(ParamKey.bizDate);
        this.dpBusiDate.setValue((Object)beginDate);
        this.pbAccount.setValue(result.get(ParamKey.account));
        this.spnYear.setValue(result.get(ParamKey.spnYear));
        this.spnPeriod.setValue(result.get(ParamKey.spnPeriod));
        Object voucherInfo = result.get(ParamKey.voucherNumber);
        if (voucherInfo instanceof VoucherInfo) {
            this.bizVoucherNumber.setValue((Object)((VoucherInfo)voucherInfo));
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            viewInfo.setFilter(filterInfo);
            viewInfo.setTopCount(1);
            CompanyOrgUnitInfo companyOrgUnitInfo = this.getCurrentCompany();
            if (companyOrgUnitInfo != null && companyOrgUnitInfo.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgUnitInfo.getId()));
            }
            if (result.get(ParamKey.spnYear) != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(result.get(ParamKey.spnYear).toString())));
            }
            if (result.get(ParamKey.spnPeriod) != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(result.get("spnPeriod").toString())));
            }
            if (result.get(ParamKey.voucherType) != null && result.get(ParamKey.voucherType) instanceof VoucherTypeInfo) {
                VoucherTypeInfo typeInfo = (VoucherTypeInfo)result.get(ParamKey.voucherType);
                filterInfo.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)typeInfo.getId()));
            }
            if (voucherInfo instanceof String && ((String)voucherInfo).length() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("number", voucherInfo));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            VoucherCollection voucherInfos = null;
            try {
                voucherInfos = VoucherFactory.getRemoteInstance().getVoucherCollection(viewInfo);
                if (voucherInfos != null && voucherInfos.size() > 0) {
                    this.bizVoucherNumber.setValue((Object)voucherInfos.get(0));
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.bizVoucherType.setValue(result.get(ParamKey.voucherType));
    }

    public void clear() {
        Boolean isFirstLoad = (Boolean)this.params.get("isFirstLoad");
        if (isFirstLoad != null && !isFirstLoad.booleanValue()) {
            this.pbAccount.setValue(null);
            this.spnYear.setValue((Object)new Integer(this.currentPeriod.getPeriodYear()));
            this.spnPeriod.setValue((Object)new Integer(this.currentPeriod.getPeriodQuarter()));
            this.bizVoucherNumber.setValue(null);
            this.bizVoucherType.setValue(null);
            this.comboCurrency.setSelectedIndex(0);
            this.dpBusiDate.setValue(null);
        } else {
            this.params.put("isFirstLoad", Boolean.FALSE);
        }
    }

    public void setQueryParams(Map param) {
        this.params = param;
    }

    public static final class ParamKey {
        static String currency = "currency";
        static String account = "account";
        static String bizDate = "bizDate";
        static String voucherNumber = "voucherNumber";
        static String voucherType = "voucherType";
        static String spnYear = "spnYear";
        static String spnPeriod = "spnPeriod";
        static String voucherInfo = "voucherInfo";
    }
}

