/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryInfo;
import com.kingdee.eas.fi.gl.AcctCussentInitFacadeFactory;
import com.kingdee.eas.fi.gl.IAcctCussentHistoryFacade;
import com.kingdee.eas.fi.gl.IAcctCussentInitFacade;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractAuditCancelBackUI;
import com.kingdee.eas.fi.gl.client.AuditCancelBackFilterPanel;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AuditCancelBackUI
extends AbstractAuditCancelBackUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLResource";
    private CommonQueryDialog conditionDialog = null;
    private AuditCancelBackFilterPanel auditCancelBackFilterPanel = null;
    private Map savedParam;
    private IAcctCussentHistoryFacade facade;
    private int baseScale = 6;
    private Map columnNames = new HashMap();
    private VoucherInfo voucherInfo = null;

    private CompanyOrgUnitInfo getCurrentCompany() throws EASBizException, BOSException {
        if (this.getUIContext().get("KEY_COMPANY") != null) {
            return (CompanyOrgUnitInfo)this.getUIContext().get("KEY_COMPANY");
        }
        return InitClientHelp.getCurrentCompany();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.menuItemConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIMainOrgContext(this.getCurrentCompany().getId().toString());
        this.facade = AcctCussentHistoryFacadeFactory.getRemoteInstance();
        this.tblMainUp.checkParsed();
        this.tblMainDown.checkParsed();
        this.tblMainUp.getColumn("select").setEditor((ICellEditor)new EditorFactory.BooleanEditor());
        this.tblMainUp.getColumn("select").getStyleAttributes().setBackground(this.tblMainUp.getBackground());
        this.tblMainDown.getColumn("select").setEditor((ICellEditor)new EditorFactory.BooleanEditor());
        this.tblMainDown.getColumn("select").getStyleAttributes().setBackground(this.tblMainDown.getBackground());
        BOSUuid currencyId = this.getCurrentCompany().getBaseCurrency().getId();
        CurrencyInfo currencyInfo = (CurrencyInfo)CurrencyFactory.getRemoteInstance().getValue("select precision where id = '" + currencyId + "'");
        this.baseScale = currencyInfo.getPrecision();
        this.tblMainUp.getColumn("originAmount").getStyleAttributes().setNumberFormat(this.getFormatPattern(this.baseScale));
        this.tblMainUp.getColumn("needAudit").getStyleAttributes().setNumberFormat(this.getFormatPattern(this.baseScale));
        this.tblMainDown.getColumn("originAmount").getStyleAttributes().setNumberFormat(this.getFormatPattern(this.baseScale));
        this.tblMainDown.getColumn("hasAudit").getStyleAttributes().setNumberFormat(this.getFormatPattern(this.baseScale));
        this.tblMainDown.getColumn("needAudit").getStyleAttributes().setNumberFormat(this.getFormatPattern(this.baseScale));
        this.tblMainDown.getColumn("unAudit").getStyleAttributes().setNumberFormat(this.getFormatPattern(this.baseScale));
        this.actionQuery_actionPerformed(null);
        this.tHelper.setCanMoveColumn(false);
    }

    private void refreshData() throws BOSException, EASBizException {
        String yearDesc = EASResource.getString((String)RESOURCE_PATH, (String)"Year");
        String monthDesc = EASResource.getString((String)RESOURCE_PATH, (String)"Month");
        AccountViewInfo account = (AccountViewInfo)this.savedParam.get(AuditCancelBackFilterPanel.ParamKey.account);
        boolean hasAccount = account != null;
        CurrencyInfo currency = (CurrencyInfo)this.savedParam.get(AuditCancelBackFilterPanel.ParamKey.currency);
        VoucherTypeInfo voucherTypeInfo = (VoucherTypeInfo)this.savedParam.get(AuditCancelBackFilterPanel.ParamKey.voucherType);
        this.voucherInfo = (VoucherInfo)this.savedParam.get(AuditCancelBackFilterPanel.ParamKey.voucherInfo);
        this.txtPeriod.setText(this.savedParam.get(AuditCancelBackFilterPanel.ParamKey.spnYear) + " " + yearDesc + " " + this.savedParam.get(AuditCancelBackFilterPanel.ParamKey.spnPeriod) + monthDesc);
        this.pkBizDate.setValue(this.savedParam.get(AuditCancelBackFilterPanel.ParamKey.bizDate));
        this.txtCurrency.setText(currency.getName());
        if (voucherTypeInfo == null) {
            return;
        }
        this.txtVoucherType.setText(voucherTypeInfo.getName());
        HashMap<String, CompanyOrgUnitInfo> otherCtx = new HashMap<String, CompanyOrgUnitInfo>();
        otherCtx.put("COMPANY", this.getCurrentCompany());
        AccountViewCollection accts = new AccountViewCollection();
        if (hasAccount) {
            accts.add(account);
        } else {
            accts = this.facade.getUnverifiedAccts(this.voucherInfo.getId().toString());
        }
        this.removeDynamicColumn();
        AsstActTypeCollection tcol = new AsstActTypeCollection();
        IAcctCussentInitFacade iInitFacade = AcctCussentInitFacadeFactory.getRemoteInstance();
        for (int i = 0; i < accts.size(); ++i) {
            AccountViewInfo newAcct = accts.get(i);
            tcol.addCollection(this.getAsstActTypes(newAcct.getCAA(), otherCtx));
            ArrayList result = iInitFacade.getCussentInitDataWithTypes(newAcct, currency, otherCtx);
            AsstActTypeCollection typeCol = (AsstActTypeCollection)result.get(0);
            this.addActTypeColumn(this.tblMainUp, typeCol);
            this.addActTypeColumn(this.tblMainDown, typeCol);
        }
        this.tblMainUp.removeRows();
        this.tblMainDown.removeRows();
        VoucherAssistRecordCollection assists = this.facade.getUnverfyCollection(this.voucherInfo.get("id").toString(), tcol);
        this.fillTable(assists);
    }

    private void removeDynamicColumn() {
        int i;
        Iterator iter = this.columnNames.keySet().iterator();
        ArrayList upList = new ArrayList();
        ArrayList downList = new ArrayList();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            boolean isUpTbl = key.endsWith("1");
            if (isUpTbl) {
                upList.add(this.columnNames.get(key));
                continue;
            }
            downList.add(this.columnNames.get(key));
        }
        Collections.sort(upList);
        Collections.sort(downList);
        for (i = upList.size() - 1; i >= 0; --i) {
            this.tblMainUp.removeColumn(((Integer)upList.get(i)).intValue());
        }
        for (i = downList.size() - 1; i >= 0; --i) {
            this.tblMainDown.removeColumn(((Integer)downList.get(i)).intValue());
        }
        this.columnNames.clear();
    }

    private void addActTypeColumn(KDTable tblMain, AsstActTypeCollection typeCol) {
        int startAsstColumn = tblMain.getColumnIndex("select") + 1;
        for (int i = 0; i < typeCol.size(); ++i) {
            AsstActTypeInfo type = typeCol.get(i);
            if (this.columnNames.containsKey(type.getName() + (tblMain == this.tblMainUp ? "1" : "0"))) continue;
            IColumn column = tblMain.addColumn(startAsstColumn + i);
            column.getStyleAttributes().setLocked(true);
            int columnIndex = column.getColumnIndex();
            this.columnNames.put(type.getName() + (tblMain == this.tblMainUp ? "1" : "0"), new Integer(columnIndex));
            column.setKey(type.getId().toString());
            column.setUserObject((Object)type);
            tblMain.getHeadRow(0).getCell(startAsstColumn + i).setValue((Object)type.getName());
            tblMain.getHeadRow(1).getCell(startAsstColumn + i).setValue((Object)type.getName());
            tblMain.getHeadMergeManager().mergeBlock(0, columnIndex, 1, columnIndex);
        }
    }

    private String getFormatPattern(int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return "%r{" + pattern + "}f";
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMainUp.getRowCount() == 0 && this.tblMainDown.getRowCount() == 0) {
            return;
        }
        this.facade.unverfyVoucher(this.voucherInfo.getId().toString());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.UnverfyCussentSucc"));
        this.tblMainUp.removeRows();
        this.tblMainDown.removeRows();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOnlyShowInCurrentOrg(true);
            this.conditionDialog.setOwner((Component)((Object)this));
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.gl.app", "VoucherQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(429);
            this.conditionDialog.setHeight(356);
            if (this.auditCancelBackFilterPanel == null) {
                CompanyOrgUnitInfo company = this.getCurrentCompany();
                this.auditCancelBackFilterPanel = new AuditCancelBackFilterPanel(company);
                this.auditCancelBackFilterPanel.initData();
                this.getUIContext().put("isFirstLoad", Boolean.TRUE);
                this.auditCancelBackFilterPanel.setQueryParams(this.getUIContext());
                this.auditCancelBackFilterPanel.initUIByParam();
                if (this.auditCancelBackFilterPanel.getCustomerParams() == null) {
                    CustomerParams params = new CustomerParams();
                    this.auditCancelBackFilterPanel.setCustomerParams(params);
                }
                this.auditCancelBackFilterPanel.getCustomerParams().putBoolean("isFirstLoad", true);
            }
            this.conditionDialog.addUserPanel((KDPanel)this.auditCancelBackFilterPanel);
            this.conditionDialog.setTitle(this.auditCancelBackFilterPanel.getUITitle());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.gl.client.AuditCancelBackUI");
            this.savedParam = this.auditCancelBackFilterPanel.getResult();
            this.refreshData();
            return;
        }
        if (this.conditionDialog.show()) {
            this.savedParam = this.auditCancelBackFilterPanel.getResult();
            this.refreshData();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMainUp);
        this.tblMainUp.getPrintManager().print();
        this.preparePrintPage(this.tblMainDown);
        this.tblMainDown.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMainUp);
        this.tblMainUp.getPrintManager().printPreview();
        this.preparePrintPage(this.tblMainDown);
        this.tblMainDown.getPrintManager().printPreview();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshData();
    }

    private void fillTable(VoucherAssistRecordCollection collection) throws BOSException, EASBizException {
        String debitDesc = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.cell_debit");
        String creditDesc = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.cell_credit");
        HashMap<String, String> historyIdMap = new HashMap<String, String>();
        for (int i = 0; i < collection.size(); ++i) {
            VoucherAssistRecordInfo assistInfo = collection.get(i);
            boolean isCussent = assistInfo.getBill() == null || assistInfo.getEntry() == null;
            Integer acctDc = null;
            if (!isCussent) {
                int entryDc = assistInfo.getEntry().getEntryDC().getValue();
                int acDc = assistInfo.getEntry().getAccount().getDC().getValue();
                if (entryDc == 1 && acDc == 1 || entryDc == 0 && acDc == -1) {
                    isCussent = true;
                }
                acctDc = new Integer(acDc == -1 ? 0 : 1);
            } else {
                acctDc = (Integer)assistInfo.get("INITDATA_ENTRY_DC");
            }
            KDTable tbl = isCussent ? this.tblMainUp : this.tblMainDown;
            List histories = (List)assistInfo.get("HISTORY_INFO");
            for (int j = 0; j < histories.size(); ++j) {
                AcctCussentHistoryInfo history = (AcctCussentHistoryInfo)histories.get(j);
                String historyId = history.getId().toString();
                if (historyIdMap.containsKey(historyId + isCussent)) continue;
                IRow row = tbl.addRow();
                row.getCell("select").setValue((Object)true);
                for (String key : this.columnNames.keySet()) {
                    if ((tbl != this.tblMainUp || !key.endsWith("1")) && (tbl != this.tblMainDown || !key.endsWith("0"))) continue;
                    int index = (Integer)this.columnNames.get(key);
                    IColumn column = tbl.getColumn(index);
                    AsstActTypeInfo t = (AsstActTypeInfo)column.getUserObject();
                    row.getCell(column.getKey()).setValue(assistInfo.getAssGrp().get(t.getAsstHGAttribute()));
                }
                row.getCell("bizDateBegin").setValue((Object)assistInfo.getBizDate());
                row.getCell("bizDateEnd").setValue((Object)assistInfo.getEndDate());
                row.getCell("voucherType").setValue(assistInfo.getBill() == null ? null : assistInfo.getBill().getVoucherType().getName());
                row.getCell("voucherNumber").setValue(assistInfo.getBill() == null ? null : assistInfo.getBill().getNumber());
                row.getCell("voucherAbstract").setValue((Object)assistInfo.getDescription());
                row.getCell("originAmount").setValue((Object)assistInfo.getOriginalAmount());
                row.getCell("needAudit").setValue((Object)history.getOroginalAmount());
                if (isCussent) {
                    if (acctDc == 1) {
                        row.getCell("debitOrCredit").setValue((Object)debitDesc);
                    } else {
                        row.getCell("debitOrCredit").setValue((Object)creditDesc);
                    }
                } else {
                    if (acctDc == 1) {
                        row.getCell("debitOrCredit").setValue((Object)creditDesc);
                    } else {
                        row.getCell("debitOrCredit").setValue((Object)debitDesc);
                    }
                    BigDecimal hasVerifyAmt = this.facade.getVerifiedAmount(assistInfo.getId().toString());
                    row.getCell("hasAudit").setValue((Object)hasVerifyAmt);
                    row.getCell("unAudit").setValue((Object)assistInfo.getOriginalAmount().subtract(hasVerifyAmt));
                }
                historyIdMap.put(historyId + isCussent, historyId);
            }
        }
    }

    private AsstActTypeCollection getAsstActTypes(AsstAccountInfo asstAccount, HashMap otherCtx) throws BOSException {
        IAsstActGroupDetail actGroupDetail = AsstActGroupDetailFactory.getRemoteInstance();
        AsstActGroupDetailCollection col = actGroupDetail.getAsstActGroupDetailCollection("select asstActType.* where asstAccount.id = '" + asstAccount.getId() + "' order by asstAccount.id");
        AsstActTypeCollection result = new AsstActTypeCollection();
        for (int i = 0; i < col.size(); ++i) {
            AsstActGroupDetailInfo detail = col.get(i);
            AsstActTypeInfo type = detail.getAsstActType();
            result.add(type);
        }
        return result;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        try {
            return new ObjectUuidPK(this.getCurrentCompany().getId().toString());
        }
        catch (Exception e) {
            return super.getOrgPK(action);
        }
    }
}

